# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GdcApplicationEnvironmentArgs', 'GdcApplicationEnvironment']

@pulumi.input_type
class GdcApplicationEnvironmentArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 serviceinstance: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 application_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spark_application_environment_config: Optional[pulumi.Input['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs']] = None):
        """
        The set of arguments for constructing a GdcApplicationEnvironment resource.
        :param pulumi.Input[builtins.str] location: The location of the application environment
        :param pulumi.Input[builtins.str] serviceinstance: The id of the service instance to which this application environment belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: The annotations to associate with this application environment. Annotations may be used to store client information, but are not used by the server.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] application_environment_id: The id of the application environment
        :param pulumi.Input[builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this application environment. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] namespace: The name of the namespace in which to create this ApplicationEnvironment. This namespace must already exist in the cluster
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs'] spark_application_environment_config: Represents the SparkApplicationEnvironmentConfig.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "serviceinstance", serviceinstance)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if application_environment_id is not None:
            pulumi.set(__self__, "application_environment_id", application_environment_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if spark_application_environment_config is not None:
            pulumi.set(__self__, "spark_application_environment_config", spark_application_environment_config)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the application environment
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def serviceinstance(self) -> pulumi.Input[builtins.str]:
        """
        The id of the service instance to which this application environment belongs.
        """
        return pulumi.get(self, "serviceinstance")

    @serviceinstance.setter
    def serviceinstance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "serviceinstance", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The annotations to associate with this application environment. Annotations may be used to store client information, but are not used by the server.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="applicationEnvironmentId")
    def application_environment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the application environment
        """
        return pulumi.get(self, "application_environment_id")

    @application_environment_id.setter
    def application_environment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_environment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels to associate with this application environment. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the namespace in which to create this ApplicationEnvironment. This namespace must already exist in the cluster
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sparkApplicationEnvironmentConfig")
    def spark_application_environment_config(self) -> Optional[pulumi.Input['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs']]:
        """
        Represents the SparkApplicationEnvironmentConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_application_environment_config")

    @spark_application_environment_config.setter
    def spark_application_environment_config(self, value: Optional[pulumi.Input['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs']]):
        pulumi.set(self, "spark_application_environment_config", value)


@pulumi.input_type
class _GdcApplicationEnvironmentState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 application_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 serviceinstance: Optional[pulumi.Input[builtins.str]] = None,
                 spark_application_environment_config: Optional[pulumi.Input['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs']] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GdcApplicationEnvironment resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: The annotations to associate with this application environment. Annotations may be used to store client information, but are not used by the server.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] application_environment_id: The id of the application environment
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this application environment. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the application environment
        :param pulumi.Input[builtins.str] name: Identifier. The name of the application environment. Format: projects/{project}/locations/{location}/serviceInstances/{service_instance}/applicationEnvironments/{application_environment_id}
        :param pulumi.Input[builtins.str] namespace: The name of the namespace in which to create this ApplicationEnvironment. This namespace must already exist in the cluster
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] serviceinstance: The id of the service instance to which this application environment belongs.
        :param pulumi.Input['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs'] spark_application_environment_config: Represents the SparkApplicationEnvironmentConfig.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: System generated unique identifier for this application environment, formatted as UUID4.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was most recently updated.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if application_environment_id is not None:
            pulumi.set(__self__, "application_environment_id", application_environment_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if serviceinstance is not None:
            pulumi.set(__self__, "serviceinstance", serviceinstance)
        if spark_application_environment_config is not None:
            pulumi.set(__self__, "spark_application_environment_config", spark_application_environment_config)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The annotations to associate with this application environment. Annotations may be used to store client information, but are not used by the server.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="applicationEnvironmentId")
    def application_environment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the application environment
        """
        return pulumi.get(self, "application_environment_id")

    @application_environment_id.setter
    def application_environment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_environment_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels to associate with this application environment. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the application environment
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The name of the application environment. Format: projects/{project}/locations/{location}/serviceInstances/{service_instance}/applicationEnvironments/{application_environment_id}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the namespace in which to create this ApplicationEnvironment. This namespace must already exist in the cluster
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def serviceinstance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the service instance to which this application environment belongs.
        """
        return pulumi.get(self, "serviceinstance")

    @serviceinstance.setter
    def serviceinstance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "serviceinstance", value)

    @property
    @pulumi.getter(name="sparkApplicationEnvironmentConfig")
    def spark_application_environment_config(self) -> Optional[pulumi.Input['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs']]:
        """
        Represents the SparkApplicationEnvironmentConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_application_environment_config")

    @spark_application_environment_config.setter
    def spark_application_environment_config(self, value: Optional[pulumi.Input['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs']]):
        pulumi.set(self, "spark_application_environment_config", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System generated unique identifier for this application environment, formatted as UUID4.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataproc/gdcApplicationEnvironment:GdcApplicationEnvironment")
class GdcApplicationEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 application_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 serviceinstance: Optional[pulumi.Input[builtins.str]] = None,
                 spark_application_environment_config: Optional[pulumi.Input[Union['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs', 'GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgsDict']]] = None,
                 __props__=None):
        """
        An ApplicationEnvironment contains shared configuration that may be referenced by multiple SparkApplications.

        To get more information about ApplicationEnvironment, see:

        * [API documentation](https://cloud.google.com/dataproc-gdc/docs/reference/rest/v1/projects.locations.applicationEnvironments)
        * How-to Guides
            * [Dataproc Intro](https://cloud.google.com/dataproc/)

        ## Example Usage

        ### Dataprocgdc Applicationenvironment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        application_environment = gcp.dataproc.GdcApplicationEnvironment("application-environment",
            application_environment_id="dp-tf-e2e-application-environment-basic",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default")
        ```
        ### Dataprocgdc Applicationenvironment

        ```python
        import pulumi
        import pulumi_gcp as gcp

        application_environment = gcp.dataproc.GdcApplicationEnvironment("application-environment",
            application_environment_id="dp-tf-e2e-application-environment",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="An application environment",
            labels={
                "test-label": "label-value",
            },
            annotations={
                "an_annotation": "annotation_value",
            },
            spark_application_environment_config={
                "default_properties": {
                    "spark.executor.memory": "4g",
                },
                "default_version": "1.2",
            })
        ```

        ## Import

        ApplicationEnvironment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceInstances/{{serviceinstance}}/applicationEnvironments/{{application_environment_id}}`

        * `{{project}}/{{location}}/{{serviceinstance}}/{{application_environment_id}}`

        * `{{location}}/{{serviceinstance}}/{{application_environment_id}}`

        When using the `pulumi import` command, ApplicationEnvironment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/gdcApplicationEnvironment:GdcApplicationEnvironment default projects/{{project}}/locations/{{location}}/serviceInstances/{{serviceinstance}}/applicationEnvironments/{{application_environment_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcApplicationEnvironment:GdcApplicationEnvironment default {{project}}/{{location}}/{{serviceinstance}}/{{application_environment_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcApplicationEnvironment:GdcApplicationEnvironment default {{location}}/{{serviceinstance}}/{{application_environment_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: The annotations to associate with this application environment. Annotations may be used to store client information, but are not used by the server.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] application_environment_id: The id of the application environment
        :param pulumi.Input[builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this application environment. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the application environment
        :param pulumi.Input[builtins.str] namespace: The name of the namespace in which to create this ApplicationEnvironment. This namespace must already exist in the cluster
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] serviceinstance: The id of the service instance to which this application environment belongs.
        :param pulumi.Input[Union['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs', 'GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgsDict']] spark_application_environment_config: Represents the SparkApplicationEnvironmentConfig.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GdcApplicationEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An ApplicationEnvironment contains shared configuration that may be referenced by multiple SparkApplications.

        To get more information about ApplicationEnvironment, see:

        * [API documentation](https://cloud.google.com/dataproc-gdc/docs/reference/rest/v1/projects.locations.applicationEnvironments)
        * How-to Guides
            * [Dataproc Intro](https://cloud.google.com/dataproc/)

        ## Example Usage

        ### Dataprocgdc Applicationenvironment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        application_environment = gcp.dataproc.GdcApplicationEnvironment("application-environment",
            application_environment_id="dp-tf-e2e-application-environment-basic",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default")
        ```
        ### Dataprocgdc Applicationenvironment

        ```python
        import pulumi
        import pulumi_gcp as gcp

        application_environment = gcp.dataproc.GdcApplicationEnvironment("application-environment",
            application_environment_id="dp-tf-e2e-application-environment",
            serviceinstance="do-not-delete-dataproc-gdc-instance",
            project="my-project",
            location="us-west2",
            namespace="default",
            display_name="An application environment",
            labels={
                "test-label": "label-value",
            },
            annotations={
                "an_annotation": "annotation_value",
            },
            spark_application_environment_config={
                "default_properties": {
                    "spark.executor.memory": "4g",
                },
                "default_version": "1.2",
            })
        ```

        ## Import

        ApplicationEnvironment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceInstances/{{serviceinstance}}/applicationEnvironments/{{application_environment_id}}`

        * `{{project}}/{{location}}/{{serviceinstance}}/{{application_environment_id}}`

        * `{{location}}/{{serviceinstance}}/{{application_environment_id}}`

        When using the `pulumi import` command, ApplicationEnvironment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/gdcApplicationEnvironment:GdcApplicationEnvironment default projects/{{project}}/locations/{{location}}/serviceInstances/{{serviceinstance}}/applicationEnvironments/{{application_environment_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcApplicationEnvironment:GdcApplicationEnvironment default {{project}}/{{location}}/{{serviceinstance}}/{{application_environment_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcApplicationEnvironment:GdcApplicationEnvironment default {{location}}/{{serviceinstance}}/{{application_environment_id}}
        ```

        :param str resource_name: The name of the resource.
        :param GdcApplicationEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GdcApplicationEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 application_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 serviceinstance: Optional[pulumi.Input[builtins.str]] = None,
                 spark_application_environment_config: Optional[pulumi.Input[Union['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs', 'GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GdcApplicationEnvironmentArgs.__new__(GdcApplicationEnvironmentArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["application_environment_id"] = application_environment_id
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["project"] = project
            if serviceinstance is None and not opts.urn:
                raise TypeError("Missing required property 'serviceinstance'")
            __props__.__dict__["serviceinstance"] = serviceinstance
            __props__.__dict__["spark_application_environment_config"] = spark_application_environment_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GdcApplicationEnvironment, __self__).__init__(
            'gcp:dataproc/gdcApplicationEnvironment:GdcApplicationEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            application_environment_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            serviceinstance: Optional[pulumi.Input[builtins.str]] = None,
            spark_application_environment_config: Optional[pulumi.Input[Union['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs', 'GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgsDict']]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'GdcApplicationEnvironment':
        """
        Get an existing GdcApplicationEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: The annotations to associate with this application environment. Annotations may be used to store client information, but are not used by the server.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] application_environment_id: The id of the application environment
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this application environment. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the application environment
        :param pulumi.Input[builtins.str] name: Identifier. The name of the application environment. Format: projects/{project}/locations/{location}/serviceInstances/{service_instance}/applicationEnvironments/{application_environment_id}
        :param pulumi.Input[builtins.str] namespace: The name of the namespace in which to create this ApplicationEnvironment. This namespace must already exist in the cluster
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] serviceinstance: The id of the service instance to which this application environment belongs.
        :param pulumi.Input[Union['GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgs', 'GdcApplicationEnvironmentSparkApplicationEnvironmentConfigArgsDict']] spark_application_environment_config: Represents the SparkApplicationEnvironmentConfig.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: System generated unique identifier for this application environment, formatted as UUID4.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GdcApplicationEnvironmentState.__new__(_GdcApplicationEnvironmentState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["application_environment_id"] = application_environment_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["serviceinstance"] = serviceinstance
        __props__.__dict__["spark_application_environment_config"] = spark_application_environment_config
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return GdcApplicationEnvironment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The annotations to associate with this application environment. Annotations may be used to store client information, but are not used by the server.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="applicationEnvironmentId")
    def application_environment_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The id of the application environment
        """
        return pulumi.get(self, "application_environment_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels to associate with this application environment. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the application environment
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The name of the application environment. Format: projects/{project}/locations/{location}/serviceInstances/{service_instance}/applicationEnvironments/{application_environment_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the namespace in which to create this ApplicationEnvironment. This namespace must already exist in the cluster
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def serviceinstance(self) -> pulumi.Output[builtins.str]:
        """
        The id of the service instance to which this application environment belongs.
        """
        return pulumi.get(self, "serviceinstance")

    @property
    @pulumi.getter(name="sparkApplicationEnvironmentConfig")
    def spark_application_environment_config(self) -> pulumi.Output[Optional['outputs.GdcApplicationEnvironmentSparkApplicationEnvironmentConfig']]:
        """
        Represents the SparkApplicationEnvironmentConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_application_environment_config")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System generated unique identifier for this application environment, formatted as UUID4.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was most recently updated.
        """
        return pulumi.get(self, "update_time")

