# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GdcServiceInstanceArgs', 'GdcServiceInstance']

@pulumi.input_type
class GdcServiceInstanceArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 service_instance_id: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 gdce_cluster: Optional[pulumi.Input['GdcServiceInstanceGdceClusterArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 spark_service_instance_config: Optional[pulumi.Input['GdcServiceInstanceSparkServiceInstanceConfigArgs']] = None):
        """
        The set of arguments for constructing a GdcServiceInstance resource.
        :param pulumi.Input[builtins.str] location: Location of the resource.
        :param pulumi.Input[builtins.str] service_instance_id: Id of the service instance.
        :param pulumi.Input[builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input['GdcServiceInstanceGdceClusterArgs'] gdce_cluster: Gdce cluster information.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this service instance. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] service_account: Requested service account to associate with ServiceInstance.
        :param pulumi.Input['GdcServiceInstanceSparkServiceInstanceConfigArgs'] spark_service_instance_config: Spark-specific service instance configuration.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "service_instance_id", service_instance_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gdce_cluster is not None:
            pulumi.set(__self__, "gdce_cluster", gdce_cluster)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if spark_service_instance_config is not None:
            pulumi.set(__self__, "spark_service_instance_config", spark_service_instance_config)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="serviceInstanceId")
    def service_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the service instance.
        """
        return pulumi.get(self, "service_instance_id")

    @service_instance_id.setter
    def service_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_instance_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gdceCluster")
    def gdce_cluster(self) -> Optional[pulumi.Input['GdcServiceInstanceGdceClusterArgs']]:
        """
        Gdce cluster information.
        Structure is documented below.
        """
        return pulumi.get(self, "gdce_cluster")

    @gdce_cluster.setter
    def gdce_cluster(self, value: Optional[pulumi.Input['GdcServiceInstanceGdceClusterArgs']]):
        pulumi.set(self, "gdce_cluster", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels to associate with this service instance. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Requested service account to associate with ServiceInstance.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="sparkServiceInstanceConfig")
    def spark_service_instance_config(self) -> Optional[pulumi.Input['GdcServiceInstanceSparkServiceInstanceConfigArgs']]:
        """
        Spark-specific service instance configuration.
        """
        return pulumi.get(self, "spark_service_instance_config")

    @spark_service_instance_config.setter
    def spark_service_instance_config(self, value: Optional[pulumi.Input['GdcServiceInstanceSparkServiceInstanceConfigArgs']]):
        pulumi.set(self, "spark_service_instance_config", value)


@pulumi.input_type
class _GdcServiceInstanceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 gdce_cluster: Optional[pulumi.Input['GdcServiceInstanceGdceClusterArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 requested_state: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 service_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 spark_service_instance_config: Optional[pulumi.Input['GdcServiceInstanceSparkServiceInstanceConfigArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_message: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GdcServiceInstance resources.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] effective_service_account: Effective service account associated with ServiceInstance. This will be the service_account if specified. Otherwise, it will be an automatically created per-resource P4SA that also automatically has Fleet Workload. Identity bindings applied.
        :param pulumi.Input['GdcServiceInstanceGdceClusterArgs'] gdce_cluster: Gdce cluster information.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this service instance. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the resource.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the service instance.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Whether the service instance is currently reconciling. True if the current state of the resource does not match the intended state, and the system is working to reconcile them, whether or not the change was user initiated.
        :param pulumi.Input[builtins.str] requested_state: The intended state to which the service instance is reconciling. Possible values:
               * `CREATING`
               * `ACTIVE`
               * `DISCONNECTED`
               * `DELETING`
               * `STOPPING`
               * `STOPPED`
               * `STARTING`
               * `UPDATING`
               * `FAILED`
        :param pulumi.Input[builtins.str] service_account: Requested service account to associate with ServiceInstance.
        :param pulumi.Input[builtins.str] service_instance_id: Id of the service instance.
        :param pulumi.Input['GdcServiceInstanceSparkServiceInstanceConfigArgs'] spark_service_instance_config: Spark-specific service instance configuration.
        :param pulumi.Input[builtins.str] state: The current state. Possible values:
               * `CREATING`
               * `ACTIVE`
               * `DISCONNECTED`
               * `DELETING`
               * `STOPPING`
               * `STOPPED`
               * `STARTING`
               * `UPDATING`
               * `FAILED`
        :param pulumi.Input[builtins.str] state_message: A message explaining the current state.
        :param pulumi.Input[builtins.str] uid: System generated unique identifier for this service instance, formatted as UUID4.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was most recently updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if effective_service_account is not None:
            pulumi.set(__self__, "effective_service_account", effective_service_account)
        if gdce_cluster is not None:
            pulumi.set(__self__, "gdce_cluster", gdce_cluster)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if requested_state is not None:
            pulumi.set(__self__, "requested_state", requested_state)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_instance_id is not None:
            pulumi.set(__self__, "service_instance_id", service_instance_id)
        if spark_service_instance_config is not None:
            pulumi.set(__self__, "spark_service_instance_config", spark_service_instance_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="effectiveServiceAccount")
    def effective_service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Effective service account associated with ServiceInstance. This will be the service_account if specified. Otherwise, it will be an automatically created per-resource P4SA that also automatically has Fleet Workload. Identity bindings applied.
        """
        return pulumi.get(self, "effective_service_account")

    @effective_service_account.setter
    def effective_service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "effective_service_account", value)

    @property
    @pulumi.getter(name="gdceCluster")
    def gdce_cluster(self) -> Optional[pulumi.Input['GdcServiceInstanceGdceClusterArgs']]:
        """
        Gdce cluster information.
        Structure is documented below.
        """
        return pulumi.get(self, "gdce_cluster")

    @gdce_cluster.setter
    def gdce_cluster(self, value: Optional[pulumi.Input['GdcServiceInstanceGdceClusterArgs']]):
        pulumi.set(self, "gdce_cluster", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels to associate with this service instance. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The name of the service instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the service instance is currently reconciling. True if the current state of the resource does not match the intended state, and the system is working to reconcile them, whether or not the change was user initiated.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter(name="requestedState")
    def requested_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The intended state to which the service instance is reconciling. Possible values:
        * `CREATING`
        * `ACTIVE`
        * `DISCONNECTED`
        * `DELETING`
        * `STOPPING`
        * `STOPPED`
        * `STARTING`
        * `UPDATING`
        * `FAILED`
        """
        return pulumi.get(self, "requested_state")

    @requested_state.setter
    def requested_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "requested_state", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Requested service account to associate with ServiceInstance.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceInstanceId")
    def service_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the service instance.
        """
        return pulumi.get(self, "service_instance_id")

    @service_instance_id.setter
    def service_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_instance_id", value)

    @property
    @pulumi.getter(name="sparkServiceInstanceConfig")
    def spark_service_instance_config(self) -> Optional[pulumi.Input['GdcServiceInstanceSparkServiceInstanceConfigArgs']]:
        """
        Spark-specific service instance configuration.
        """
        return pulumi.get(self, "spark_service_instance_config")

    @spark_service_instance_config.setter
    def spark_service_instance_config(self, value: Optional[pulumi.Input['GdcServiceInstanceSparkServiceInstanceConfigArgs']]):
        pulumi.set(self, "spark_service_instance_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state. Possible values:
        * `CREATING`
        * `ACTIVE`
        * `DISCONNECTED`
        * `DELETING`
        * `STOPPING`
        * `STOPPED`
        * `STARTING`
        * `UPDATING`
        * `FAILED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message explaining the current state.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System generated unique identifier for this service instance, formatted as UUID4.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataproc/gdcServiceInstance:GdcServiceInstance")
class GdcServiceInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 gdce_cluster: Optional[pulumi.Input[Union['GdcServiceInstanceGdceClusterArgs', 'GdcServiceInstanceGdceClusterArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 service_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 spark_service_instance_config: Optional[pulumi.Input[Union['GdcServiceInstanceSparkServiceInstanceConfigArgs', 'GdcServiceInstanceSparkServiceInstanceConfigArgsDict']]] = None,
                 __props__=None):
        """
        A service instance is an instance of the Dataproc operator running on a GDC cluster.

        To get more information about ServiceInstance, see:

        * [API documentation](https://cloud.google.com/dataproc-gdc/docs/reference/rest/v1/projects.locations.serviceInstances)
        * How-to Guides
            * [Dataproc Intro](https://cloud.google.com/dataproc/)

        ## Example Usage

        ### Dataprocgdc Serviceinstance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_instance = gcp.dataproc.GdcServiceInstance("service-instance",
            service_instance_id="tf-e2e-service-instance",
            project="my-project",
            location="us-west2",
            gdce_cluster={
                "gdce_cluster": "projects/gdce-cluster-monitoring/locations/us-west2/clusters/gdce-prism-prober-ord106",
            },
            display_name="A service instance",
            labels={
                "test-label": "label-value",
            },
            service_account="dataprocgdc-cep-workflows@gdce-cluster-monitoring.iam.gserviceaccount.com")
        ```

        ## Import

        ServiceInstance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceInstances/{{service_instance_id}}`

        * `{{project}}/{{location}}/{{service_instance_id}}`

        * `{{location}}/{{service_instance_id}}`

        When using the `pulumi import` command, ServiceInstance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/gdcServiceInstance:GdcServiceInstance default projects/{{project}}/locations/{{location}}/serviceInstances/{{service_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcServiceInstance:GdcServiceInstance default {{project}}/{{location}}/{{service_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcServiceInstance:GdcServiceInstance default {{location}}/{{service_instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Union['GdcServiceInstanceGdceClusterArgs', 'GdcServiceInstanceGdceClusterArgsDict']] gdce_cluster: Gdce cluster information.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this service instance. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] service_account: Requested service account to associate with ServiceInstance.
        :param pulumi.Input[builtins.str] service_instance_id: Id of the service instance.
        :param pulumi.Input[Union['GdcServiceInstanceSparkServiceInstanceConfigArgs', 'GdcServiceInstanceSparkServiceInstanceConfigArgsDict']] spark_service_instance_config: Spark-specific service instance configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GdcServiceInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A service instance is an instance of the Dataproc operator running on a GDC cluster.

        To get more information about ServiceInstance, see:

        * [API documentation](https://cloud.google.com/dataproc-gdc/docs/reference/rest/v1/projects.locations.serviceInstances)
        * How-to Guides
            * [Dataproc Intro](https://cloud.google.com/dataproc/)

        ## Example Usage

        ### Dataprocgdc Serviceinstance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_instance = gcp.dataproc.GdcServiceInstance("service-instance",
            service_instance_id="tf-e2e-service-instance",
            project="my-project",
            location="us-west2",
            gdce_cluster={
                "gdce_cluster": "projects/gdce-cluster-monitoring/locations/us-west2/clusters/gdce-prism-prober-ord106",
            },
            display_name="A service instance",
            labels={
                "test-label": "label-value",
            },
            service_account="dataprocgdc-cep-workflows@gdce-cluster-monitoring.iam.gserviceaccount.com")
        ```

        ## Import

        ServiceInstance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceInstances/{{service_instance_id}}`

        * `{{project}}/{{location}}/{{service_instance_id}}`

        * `{{location}}/{{service_instance_id}}`

        When using the `pulumi import` command, ServiceInstance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/gdcServiceInstance:GdcServiceInstance default projects/{{project}}/locations/{{location}}/serviceInstances/{{service_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcServiceInstance:GdcServiceInstance default {{project}}/{{location}}/{{service_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/gdcServiceInstance:GdcServiceInstance default {{location}}/{{service_instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param GdcServiceInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GdcServiceInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 gdce_cluster: Optional[pulumi.Input[Union['GdcServiceInstanceGdceClusterArgs', 'GdcServiceInstanceGdceClusterArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 service_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 spark_service_instance_config: Optional[pulumi.Input[Union['GdcServiceInstanceSparkServiceInstanceConfigArgs', 'GdcServiceInstanceSparkServiceInstanceConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GdcServiceInstanceArgs.__new__(GdcServiceInstanceArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["gdce_cluster"] = gdce_cluster
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["service_account"] = service_account
            if service_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_instance_id'")
            __props__.__dict__["service_instance_id"] = service_instance_id
            __props__.__dict__["spark_service_instance_config"] = spark_service_instance_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["effective_service_account"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["requested_state"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GdcServiceInstance, __self__).__init__(
            'gcp:dataproc/gdcServiceInstance:GdcServiceInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_service_account: Optional[pulumi.Input[builtins.str]] = None,
            gdce_cluster: Optional[pulumi.Input[Union['GdcServiceInstanceGdceClusterArgs', 'GdcServiceInstanceGdceClusterArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            requested_state: Optional[pulumi.Input[builtins.str]] = None,
            service_account: Optional[pulumi.Input[builtins.str]] = None,
            service_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            spark_service_instance_config: Optional[pulumi.Input[Union['GdcServiceInstanceSparkServiceInstanceConfigArgs', 'GdcServiceInstanceSparkServiceInstanceConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_message: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'GdcServiceInstance':
        """
        Get an existing GdcServiceInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.str] display_name: User-provided human-readable name to be used in user interfaces.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] effective_service_account: Effective service account associated with ServiceInstance. This will be the service_account if specified. Otherwise, it will be an automatically created per-resource P4SA that also automatically has Fleet Workload. Identity bindings applied.
        :param pulumi.Input[Union['GdcServiceInstanceGdceClusterArgs', 'GdcServiceInstanceGdceClusterArgsDict']] gdce_cluster: Gdce cluster information.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this service instance. Labels may be used for filtering and billing tracking.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the resource.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the service instance.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Whether the service instance is currently reconciling. True if the current state of the resource does not match the intended state, and the system is working to reconcile them, whether or not the change was user initiated.
        :param pulumi.Input[builtins.str] requested_state: The intended state to which the service instance is reconciling. Possible values:
               * `CREATING`
               * `ACTIVE`
               * `DISCONNECTED`
               * `DELETING`
               * `STOPPING`
               * `STOPPED`
               * `STARTING`
               * `UPDATING`
               * `FAILED`
        :param pulumi.Input[builtins.str] service_account: Requested service account to associate with ServiceInstance.
        :param pulumi.Input[builtins.str] service_instance_id: Id of the service instance.
        :param pulumi.Input[Union['GdcServiceInstanceSparkServiceInstanceConfigArgs', 'GdcServiceInstanceSparkServiceInstanceConfigArgsDict']] spark_service_instance_config: Spark-specific service instance configuration.
        :param pulumi.Input[builtins.str] state: The current state. Possible values:
               * `CREATING`
               * `ACTIVE`
               * `DISCONNECTED`
               * `DELETING`
               * `STOPPING`
               * `STOPPED`
               * `STARTING`
               * `UPDATING`
               * `FAILED`
        :param pulumi.Input[builtins.str] state_message: A message explaining the current state.
        :param pulumi.Input[builtins.str] uid: System generated unique identifier for this service instance, formatted as UUID4.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GdcServiceInstanceState.__new__(_GdcServiceInstanceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["effective_service_account"] = effective_service_account
        __props__.__dict__["gdce_cluster"] = gdce_cluster
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["requested_state"] = requested_state
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["service_instance_id"] = service_instance_id
        __props__.__dict__["spark_service_instance_config"] = spark_service_instance_config
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return GdcServiceInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-provided human-readable name to be used in user interfaces.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="effectiveServiceAccount")
    def effective_service_account(self) -> pulumi.Output[builtins.str]:
        """
        Effective service account associated with ServiceInstance. This will be the service_account if specified. Otherwise, it will be an automatically created per-resource P4SA that also automatically has Fleet Workload. Identity bindings applied.
        """
        return pulumi.get(self, "effective_service_account")

    @property
    @pulumi.getter(name="gdceCluster")
    def gdce_cluster(self) -> pulumi.Output[Optional['outputs.GdcServiceInstanceGdceCluster']]:
        """
        Gdce cluster information.
        Structure is documented below.
        """
        return pulumi.get(self, "gdce_cluster")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels to associate with this service instance. Labels may be used for filtering and billing tracking.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The name of the service instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the service instance is currently reconciling. True if the current state of the resource does not match the intended state, and the system is working to reconcile them, whether or not the change was user initiated.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="requestedState")
    def requested_state(self) -> pulumi.Output[builtins.str]:
        """
        The intended state to which the service instance is reconciling. Possible values:
        * `CREATING`
        * `ACTIVE`
        * `DISCONNECTED`
        * `DELETING`
        * `STOPPING`
        * `STOPPED`
        * `STARTING`
        * `UPDATING`
        * `FAILED`
        """
        return pulumi.get(self, "requested_state")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Requested service account to associate with ServiceInstance.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceInstanceId")
    def service_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the service instance.
        """
        return pulumi.get(self, "service_instance_id")

    @property
    @pulumi.getter(name="sparkServiceInstanceConfig")
    def spark_service_instance_config(self) -> pulumi.Output[Optional['outputs.GdcServiceInstanceSparkServiceInstanceConfig']]:
        """
        Spark-specific service instance configuration.
        """
        return pulumi.get(self, "spark_service_instance_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state. Possible values:
        * `CREATING`
        * `ACTIVE`
        * `DISCONNECTED`
        * `DELETING`
        * `STOPPING`
        * `STOPPED`
        * `STARTING`
        * `UPDATING`
        * `FAILED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[builtins.str]:
        """
        A message explaining the current state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System generated unique identifier for this service instance, formatted as UUID4.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was most recently updated.
        """
        return pulumi.get(self, "update_time")

