# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetClusterIamPolicyResult',
    'AwaitableGetClusterIamPolicyResult',
    'get_cluster_iam_policy',
    'get_cluster_iam_policy_output',
]

@pulumi.output_type
class GetClusterIamPolicyResult:
    """
    A collection of values returned by getClusterIamPolicy.
    """
    def __init__(__self__, cluster=None, etag=None, id=None, policy_data=None, project=None, region=None):
        if cluster and not isinstance(cluster, str):
            raise TypeError("Expected argument 'cluster' to be a str")
        pulumi.set(__self__, "cluster", cluster)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def cluster(self) -> builtins.str:
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetClusterIamPolicyResult(GetClusterIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterIamPolicyResult(
            cluster=self.cluster,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            project=self.project,
            region=self.region)


def get_cluster_iam_policy(cluster: Optional[builtins.str] = None,
                           project: Optional[builtins.str] = None,
                           region: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Dataproc cluster.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_cluster_iam_policy(cluster=cluster["name"],
        region="us-central1")
    ```


    :param builtins.str cluster: The name or relative resource id of the cluster to manage IAM policies for.
    """
    __args__ = dict()
    __args__['cluster'] = cluster
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataproc/getClusterIamPolicy:getClusterIamPolicy', __args__, opts=opts, typ=GetClusterIamPolicyResult).value

    return AwaitableGetClusterIamPolicyResult(
        cluster=pulumi.get(__ret__, 'cluster'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'))
def get_cluster_iam_policy_output(cluster: Optional[pulumi.Input[builtins.str]] = None,
                                  project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Dataproc cluster.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_cluster_iam_policy(cluster=cluster["name"],
        region="us-central1")
    ```


    :param builtins.str cluster: The name or relative resource id of the cluster to manage IAM policies for.
    """
    __args__ = dict()
    __args__['cluster'] = cluster
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:dataproc/getClusterIamPolicy:getClusterIamPolicy', __args__, opts=opts, typ=GetClusterIamPolicyResult)
    return __ret__.apply(lambda __response__: GetClusterIamPolicyResult(
        cluster=pulumi.get(__response__, 'cluster'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region')))
