# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamArgs', 'Stream']

@pulumi.input_type
class StreamArgs:
    def __init__(__self__, *,
                 destination_config: pulumi.Input['StreamDestinationConfigArgs'],
                 display_name: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 source_config: pulumi.Input['StreamSourceConfigArgs'],
                 stream_id: pulumi.Input[builtins.str],
                 backfill_all: Optional[pulumi.Input['StreamBackfillAllArgs']] = None,
                 backfill_none: Optional[pulumi.Input['StreamBackfillNoneArgs']] = None,
                 create_without_validation: Optional[pulumi.Input[builtins.bool]] = None,
                 customer_managed_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Stream resource.
        :param pulumi.Input['StreamDestinationConfigArgs'] destination_config: Destination connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: Display name.
        :param pulumi.Input[builtins.str] location: The name of the location this stream is located in.
        :param pulumi.Input['StreamSourceConfigArgs'] source_config: Source connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] stream_id: The stream identifier.
        :param pulumi.Input['StreamBackfillAllArgs'] backfill_all: Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
               Structure is documented below.
        :param pulumi.Input['StreamBackfillNoneArgs'] backfill_none: Backfill strategy to disable automatic backfill for the Stream's objects.
        :param pulumi.Input[builtins.bool] create_without_validation: Create the stream without validating it.
        :param pulumi.Input[builtins.str] customer_managed_encryption_key: A reference to a KMS encryption key. If provided, it will be used to encrypt the data. If left blank, data
               will be encrypted using an internal Stream-specific encryption key provisioned through KMS.
        :param pulumi.Input[builtins.str] desired_state: Desired state of the Stream. Set this field to `RUNNING` to start the stream,
               `NOT_STARTED` to create the stream without starting and `PAUSED` to pause
               the stream from a `RUNNING` state.
               Possible values: NOT_STARTED, RUNNING, PAUSED. Default: NOT_STARTED
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "destination_config", destination_config)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "source_config", source_config)
        pulumi.set(__self__, "stream_id", stream_id)
        if backfill_all is not None:
            pulumi.set(__self__, "backfill_all", backfill_all)
        if backfill_none is not None:
            pulumi.set(__self__, "backfill_none", backfill_none)
        if create_without_validation is not None:
            pulumi.set(__self__, "create_without_validation", create_without_validation)
        if customer_managed_encryption_key is not None:
            pulumi.set(__self__, "customer_managed_encryption_key", customer_managed_encryption_key)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Input['StreamDestinationConfigArgs']:
        """
        Destination connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: pulumi.Input['StreamDestinationConfigArgs']):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The name of the location this stream is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> pulumi.Input['StreamSourceConfigArgs']:
        """
        Source connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "source_config")

    @source_config.setter
    def source_config(self, value: pulumi.Input['StreamSourceConfigArgs']):
        pulumi.set(self, "source_config", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Input[builtins.str]:
        """
        The stream identifier.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="backfillAll")
    def backfill_all(self) -> Optional[pulumi.Input['StreamBackfillAllArgs']]:
        """
        Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_all")

    @backfill_all.setter
    def backfill_all(self, value: Optional[pulumi.Input['StreamBackfillAllArgs']]):
        pulumi.set(self, "backfill_all", value)

    @property
    @pulumi.getter(name="backfillNone")
    def backfill_none(self) -> Optional[pulumi.Input['StreamBackfillNoneArgs']]:
        """
        Backfill strategy to disable automatic backfill for the Stream's objects.
        """
        return pulumi.get(self, "backfill_none")

    @backfill_none.setter
    def backfill_none(self, value: Optional[pulumi.Input['StreamBackfillNoneArgs']]):
        pulumi.set(self, "backfill_none", value)

    @property
    @pulumi.getter(name="createWithoutValidation")
    def create_without_validation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Create the stream without validating it.
        """
        return pulumi.get(self, "create_without_validation")

    @create_without_validation.setter
    def create_without_validation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "create_without_validation", value)

    @property
    @pulumi.getter(name="customerManagedEncryptionKey")
    def customer_managed_encryption_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to a KMS encryption key. If provided, it will be used to encrypt the data. If left blank, data
        will be encrypted using an internal Stream-specific encryption key provisioned through KMS.
        """
        return pulumi.get(self, "customer_managed_encryption_key")

    @customer_managed_encryption_key.setter
    def customer_managed_encryption_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_encryption_key", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired state of the Stream. Set this field to `RUNNING` to start the stream,
        `NOT_STARTED` to create the stream without starting and `PAUSED` to pause
        the stream from a `RUNNING` state.
        Possible values: NOT_STARTED, RUNNING, PAUSED. Default: NOT_STARTED
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _StreamState:
    def __init__(__self__, *,
                 backfill_all: Optional[pulumi.Input['StreamBackfillAllArgs']] = None,
                 backfill_none: Optional[pulumi.Input['StreamBackfillNoneArgs']] = None,
                 create_without_validation: Optional[pulumi.Input[builtins.bool]] = None,
                 customer_managed_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 destination_config: Optional[pulumi.Input['StreamDestinationConfigArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 source_config: Optional[pulumi.Input['StreamSourceConfigArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Stream resources.
        :param pulumi.Input['StreamBackfillAllArgs'] backfill_all: Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
               Structure is documented below.
        :param pulumi.Input['StreamBackfillNoneArgs'] backfill_none: Backfill strategy to disable automatic backfill for the Stream's objects.
        :param pulumi.Input[builtins.bool] create_without_validation: Create the stream without validating it.
        :param pulumi.Input[builtins.str] customer_managed_encryption_key: A reference to a KMS encryption key. If provided, it will be used to encrypt the data. If left blank, data
               will be encrypted using an internal Stream-specific encryption key provisioned through KMS.
        :param pulumi.Input[builtins.str] desired_state: Desired state of the Stream. Set this field to `RUNNING` to start the stream,
               `NOT_STARTED` to create the stream without starting and `PAUSED` to pause
               the stream from a `RUNNING` state.
               Possible values: NOT_STARTED, RUNNING, PAUSED. Default: NOT_STARTED
        :param pulumi.Input['StreamDestinationConfigArgs'] destination_config: Destination connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: Display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The name of the location this stream is located in.
        :param pulumi.Input[builtins.str] name: The stream's name.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['StreamSourceConfigArgs'] source_config: Source connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: The state of the stream.
        :param pulumi.Input[builtins.str] stream_id: The stream identifier.
        """
        if backfill_all is not None:
            pulumi.set(__self__, "backfill_all", backfill_all)
        if backfill_none is not None:
            pulumi.set(__self__, "backfill_none", backfill_none)
        if create_without_validation is not None:
            pulumi.set(__self__, "create_without_validation", create_without_validation)
        if customer_managed_encryption_key is not None:
            pulumi.set(__self__, "customer_managed_encryption_key", customer_managed_encryption_key)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if source_config is not None:
            pulumi.set(__self__, "source_config", source_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)

    @property
    @pulumi.getter(name="backfillAll")
    def backfill_all(self) -> Optional[pulumi.Input['StreamBackfillAllArgs']]:
        """
        Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_all")

    @backfill_all.setter
    def backfill_all(self, value: Optional[pulumi.Input['StreamBackfillAllArgs']]):
        pulumi.set(self, "backfill_all", value)

    @property
    @pulumi.getter(name="backfillNone")
    def backfill_none(self) -> Optional[pulumi.Input['StreamBackfillNoneArgs']]:
        """
        Backfill strategy to disable automatic backfill for the Stream's objects.
        """
        return pulumi.get(self, "backfill_none")

    @backfill_none.setter
    def backfill_none(self, value: Optional[pulumi.Input['StreamBackfillNoneArgs']]):
        pulumi.set(self, "backfill_none", value)

    @property
    @pulumi.getter(name="createWithoutValidation")
    def create_without_validation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Create the stream without validating it.
        """
        return pulumi.get(self, "create_without_validation")

    @create_without_validation.setter
    def create_without_validation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "create_without_validation", value)

    @property
    @pulumi.getter(name="customerManagedEncryptionKey")
    def customer_managed_encryption_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to a KMS encryption key. If provided, it will be used to encrypt the data. If left blank, data
        will be encrypted using an internal Stream-specific encryption key provisioned through KMS.
        """
        return pulumi.get(self, "customer_managed_encryption_key")

    @customer_managed_encryption_key.setter
    def customer_managed_encryption_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_encryption_key", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired state of the Stream. Set this field to `RUNNING` to start the stream,
        `NOT_STARTED` to create the stream without starting and `PAUSED` to pause
        the stream from a `RUNNING` state.
        Possible values: NOT_STARTED, RUNNING, PAUSED. Default: NOT_STARTED
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['StreamDestinationConfigArgs']]:
        """
        Destination connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['StreamDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location this stream is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stream's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> Optional[pulumi.Input['StreamSourceConfigArgs']]:
        """
        Source connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "source_config")

    @source_config.setter
    def source_config(self, value: Optional[pulumi.Input['StreamSourceConfigArgs']]):
        pulumi.set(self, "source_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the stream.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stream identifier.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stream_id", value)


@pulumi.type_token("gcp:datastream/stream:Stream")
class Stream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backfill_all: Optional[pulumi.Input[Union['StreamBackfillAllArgs', 'StreamBackfillAllArgsDict']]] = None,
                 backfill_none: Optional[pulumi.Input[Union['StreamBackfillNoneArgs', 'StreamBackfillNoneArgsDict']]] = None,
                 create_without_validation: Optional[pulumi.Input[builtins.bool]] = None,
                 customer_managed_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 destination_config: Optional[pulumi.Input[Union['StreamDestinationConfigArgs', 'StreamDestinationConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 source_config: Optional[pulumi.Input[Union['StreamSourceConfigArgs', 'StreamSourceConfigArgsDict']]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A resource representing streaming data from a source to a destination.

        To get more information about Stream, see:

        * [API documentation](https://cloud.google.com/datastream/docs/reference/rest/v1/projects.locations.streams)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/datastream/docs/create-a-stream)

        ## Example Usage

        ### Datastream Stream Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        bucket = gcp.storage.Bucket("bucket",
            name="my-bucket",
            location="US",
            uniform_bucket_level_access=True)
        viewer = gcp.storage.BucketIAMMember("viewer",
            bucket=bucket.name,
            role="roles/storage.objectViewer",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        creator = gcp.storage.BucketIAMMember("creator",
            bucket=bucket.name,
            role="roles/storage.objectCreator",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        reader = gcp.storage.BucketIAMMember("reader",
            bucket=bucket.name,
            role="roles/storage.legacyBucketReader",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        key_user = gcp.kms.CryptoKeyIAMMember("key_user",
            crypto_key_id="kms-name",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        destination_connection_profile = gcp.datastream.ConnectionProfile("destination_connection_profile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="destination-profile",
            gcs_profile={
                "bucket": bucket.name,
                "root_path": "/path",
            })
        default = gcp.datastream.Stream("default",
            stream_id="my-stream",
            desired_state="NOT_STARTED",
            location="us-central1",
            display_name="my stream",
            labels={
                "key": "value",
            },
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {
                    "include_objects": {
                        "mysql_databases": [{
                            "database": "my-database",
                            "mysql_tables": [
                                {
                                    "table": "includedTable",
                                    "mysql_columns": [{
                                        "column": "includedColumn",
                                        "data_type": "VARCHAR",
                                        "collation": "utf8mb4",
                                        "primary_key": False,
                                        "nullable": False,
                                        "ordinal_position": 0,
                                    }],
                                },
                                {
                                    "table": "includedTable_2",
                                },
                            ],
                        }],
                    },
                    "exclude_objects": {
                        "mysql_databases": [{
                            "database": "my-database",
                            "mysql_tables": [{
                                "table": "excludedTable",
                                "mysql_columns": [{
                                    "column": "excludedColumn",
                                    "data_type": "VARCHAR",
                                    "collation": "utf8mb4",
                                    "primary_key": False,
                                    "nullable": False,
                                    "ordinal_position": 0,
                                }],
                            }],
                        }],
                    },
                    "max_concurrent_cdc_tasks": 5,
                },
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile.id,
                "gcs_destination_config": {
                    "path": "mydata",
                    "file_rotation_mb": 200,
                    "file_rotation_interval": "60s",
                    "json_file_format": {
                        "schema_file_format": "NO_SCHEMA_FILE",
                        "compression": "GZIP",
                    },
                },
            },
            backfill_all={
                "mysql_excluded_objects": {
                    "mysql_databases": [{
                        "database": "my-database",
                        "mysql_tables": [{
                            "table": "excludedTable",
                            "mysql_columns": [{
                                "column": "excludedColumn",
                                "data_type": "VARCHAR",
                                "collation": "utf8mb4",
                                "primary_key": False,
                                "nullable": False,
                                "ordinal_position": 0,
                            }],
                        }],
                    }],
                },
            },
            customer_managed_encryption_key="kms-name",
            opts = pulumi.ResourceOptions(depends_on=[key_user]))
        ```
        ### Datastream Stream Postgresql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source = gcp.datastream.ConnectionProfile("source",
            display_name="Postgresql Source",
            location="us-central1",
            connection_profile_id="source-profile",
            postgresql_profile={
                "hostname": "hostname",
                "port": 5432,
                "username": "user",
                "password": "pass",
                "database": "postgres",
            })
        destination = gcp.datastream.ConnectionProfile("destination",
            display_name="BigQuery Destination",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            display_name="Postgres to BigQuery",
            location="us-central1",
            stream_id="my-stream",
            desired_state="RUNNING",
            source_config={
                "source_connection_profile": source.id,
                "postgresql_source_config": {
                    "max_concurrent_backfill_tasks": 12,
                    "publication": "publication",
                    "replication_slot": "replication_slot",
                    "include_objects": {
                        "postgresql_schemas": [{
                            "schema": "schema",
                            "postgresql_tables": [{
                                "table": "table",
                                "postgresql_columns": [{
                                    "column": "column",
                                }],
                            }],
                        }],
                    },
                    "exclude_objects": {
                        "postgresql_schemas": [{
                            "schema": "schema",
                            "postgresql_tables": [{
                                "table": "table",
                                "postgresql_columns": [{
                                    "column": "column",
                                }],
                            }],
                        }],
                    },
                },
            },
            destination_config={
                "destination_connection_profile": destination.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                },
            },
            backfill_all={
                "postgresql_excluded_objects": {
                    "postgresql_schemas": [{
                        "schema": "schema",
                        "postgresql_tables": [{
                            "table": "table",
                            "postgresql_columns": [{
                                "column": "column",
                            }],
                        }],
                    }],
                },
            })
        ```
        ### Datastream Stream Oracle

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source = gcp.datastream.ConnectionProfile("source",
            display_name="Oracle Source",
            location="us-central1",
            connection_profile_id="source-profile",
            oracle_profile={
                "hostname": "hostname",
                "port": 1521,
                "username": "user",
                "password": "pass",
                "database_service": "ORCL",
            })
        destination = gcp.datastream.ConnectionProfile("destination",
            display_name="BigQuery Destination",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        stream5 = gcp.datastream.Stream("stream5",
            display_name="Oracle to BigQuery",
            location="us-central1",
            stream_id="my-stream",
            desired_state="RUNNING",
            source_config={
                "source_connection_profile": source.id,
                "oracle_source_config": {
                    "max_concurrent_cdc_tasks": 8,
                    "max_concurrent_backfill_tasks": 12,
                    "include_objects": {
                        "oracle_schemas": [{
                            "schema": "schema",
                            "oracle_tables": [{
                                "table": "table",
                                "oracle_columns": [{
                                    "column": "column",
                                }],
                            }],
                        }],
                    },
                    "exclude_objects": {
                        "oracle_schemas": [{
                            "schema": "schema",
                            "oracle_tables": [{
                                "table": "table",
                                "oracle_columns": [{
                                    "column": "column",
                                }],
                            }],
                        }],
                    },
                    "drop_large_objects": {},
                },
            },
            destination_config={
                "destination_connection_profile": destination.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                },
            },
            backfill_all={
                "oracle_excluded_objects": {
                    "oracle_schemas": [{
                        "schema": "schema",
                        "oracle_tables": [{
                            "table": "table",
                            "oracle_columns": [{
                                "column": "column",
                            }],
                        }],
                    }],
                },
            })
        ```
        ### Datastream Stream Sql Server

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="sql-server",
            database_version="SQLSERVER_2019_STANDARD",
            region="us-central1",
            root_password="root-password",
            deletion_protection=True,
            settings={
                "tier": "db-custom-2-4096",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            })
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password="password")
        db = gcp.sql.Database("db",
            name="db",
            instance=instance.name,
            opts = pulumi.ResourceOptions(depends_on=[user]))
        source = gcp.datastream.ConnectionProfile("source",
            display_name="SQL Server Source",
            location="us-central1",
            connection_profile_id="source-profile",
            sql_server_profile={
                "hostname": instance.public_ip_address,
                "port": 1433,
                "username": user.name,
                "password": user.password,
                "database": db.name,
            })
        destination = gcp.datastream.ConnectionProfile("destination",
            display_name="BigQuery Destination",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            display_name="SQL Server to BigQuery",
            location="us-central1",
            stream_id="stream",
            source_config={
                "source_connection_profile": source.id,
                "sql_server_source_config": {
                    "include_objects": {
                        "schemas": [{
                            "schema": "schema",
                            "tables": [{
                                "table": "table",
                            }],
                        }],
                    },
                    "transaction_logs": {},
                },
            },
            destination_config={
                "destination_connection_profile": destination.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                },
            },
            backfill_none={})
        ```
        ### Datastream Stream Sql Server Change Tables

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="sql-server",
            database_version="SQLSERVER_2019_STANDARD",
            region="us-central1",
            root_password="root-password",
            deletion_protection=True,
            settings={
                "tier": "db-custom-2-4096",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            })
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password="password")
        db = gcp.sql.Database("db",
            name="db",
            instance=instance.name,
            opts = pulumi.ResourceOptions(depends_on=[user]))
        source = gcp.datastream.ConnectionProfile("source",
            display_name="SQL Server Source",
            location="us-central1",
            connection_profile_id="source-profile",
            sql_server_profile={
                "hostname": instance.public_ip_address,
                "port": 1433,
                "username": user.name,
                "password": user.password,
                "database": db.name,
            })
        destination = gcp.datastream.ConnectionProfile("destination",
            display_name="BigQuery Destination",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            display_name="SQL Server to BigQuery",
            location="us-central1",
            stream_id="stream",
            source_config={
                "source_connection_profile": source.id,
                "sql_server_source_config": {
                    "include_objects": {
                        "schemas": [{
                            "schema": "schema",
                            "tables": [{
                                "table": "table",
                            }],
                        }],
                    },
                    "change_tables": {},
                },
            },
            destination_config={
                "destination_connection_profile": destination.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                },
            },
            backfill_none={})
        ```
        ### Datastream Stream Postgresql Bigquery Dataset Id

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        postgres = gcp.bigquery.Dataset("postgres",
            dataset_id="postgres",
            friendly_name="postgres",
            description="Database of postgres",
            location="us-central1")
        destination_connection_profile2 = gcp.datastream.ConnectionProfile("destination_connection_profile2",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="dest-profile",
            bigquery_profile={})
        instance = gcp.sql.DatabaseInstance("instance",
            name="instance-name",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=False)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="my-user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        default = gcp.datastream.Stream("default",
            display_name="postgres to bigQuery",
            location="us-central1",
            stream_id="postgres-bigquery",
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {},
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile2.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "single_target_dataset": {
                        "dataset_id": postgres.id,
                    },
                },
            },
            backfill_all={})
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        ```
        ### Datastream Stream Bigquery

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        bq_sa = gcp.bigquery.get_default_service_account()
        bigquery_key_user = gcp.kms.CryptoKeyIAMMember("bigquery_key_user",
            crypto_key_id="bigquery-kms-name",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:{bq_sa.email}")
        destination_connection_profile = gcp.datastream.ConnectionProfile("destination_connection_profile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            stream_id="my-stream",
            location="us-central1",
            display_name="my stream",
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {},
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile.id,
                "bigquery_destination_config": {
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                            "kms_key_name": "bigquery-kms-name",
                        },
                    },
                },
            },
            backfill_none={},
            opts = pulumi.ResourceOptions(depends_on=[bigquery_key_user]))
        ```
        ### Datastream Stream Bigquery Append Only

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        destination_connection_profile = gcp.datastream.ConnectionProfile("destination_connection_profile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            stream_id="my-stream",
            location="us-central1",
            display_name="my stream",
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {},
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile.id,
                "bigquery_destination_config": {
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                    "append_only": {},
                },
            },
            backfill_none={})
        ```
        ### Datastream Stream Bigquery Blmt

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            name="blmt-instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        blmt_bucket = gcp.storage.Bucket("blmt_bucket",
            name="blmt-bucket",
            location="us-central1",
            force_destroy=True)
        blmt_connection = gcp.bigquery.Connection("blmt_connection",
            project=project.project_id,
            location="us-central1",
            connection_id="blmt-connection",
            friendly_name="Datastream BLMT Test Connection",
            description="Connection for Datastream BLMT test",
            cloud_resource={})
        blmt_connection_bucket_admin = gcp.storage.BucketIAMMember("blmt_connection_bucket_admin",
            bucket=blmt_bucket.name,
            role="roles/storage.admin",
            member=blmt_connection.cloud_resource.apply(lambda cloud_resource: f"serviceAccount:{cloud_resource.service_account_id}"))
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="blmt-source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        destination_connection_profile = gcp.datastream.ConnectionProfile("destination_connection_profile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="blmt-destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            stream_id="blmt-stream",
            location="us-central1",
            display_name="My BLMT stream",
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {},
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile.id,
                "bigquery_destination_config": {
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                    "blmt_config": {
                        "bucket": blmt_bucket.name,
                        "connection_name": pulumi.Output.all(
                            project=blmt_connection.project,
                            location=blmt_connection.location,
                            connection_id=blmt_connection.connection_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['project']}.{resolved_outputs['location']}.{resolved_outputs['connection_id']}")
        ,
                        "file_format": "PARQUET",
                        "table_format": "ICEBERG",
                        "root_path": "/",
                    },
                    "append_only": {},
                },
            },
            backfill_none={})
        ```
        ## Import

        Stream can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/streams/{{stream_id}}`

        * `{{project}}/{{location}}/{{stream_id}}`

        * `{{location}}/{{stream_id}}`

        When using the `pulumi import` command, Stream can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datastream/stream:Stream default projects/{{project}}/locations/{{location}}/streams/{{stream_id}}
        ```

        ```sh
        $ pulumi import gcp:datastream/stream:Stream default {{project}}/{{location}}/{{stream_id}}
        ```

        ```sh
        $ pulumi import gcp:datastream/stream:Stream default {{location}}/{{stream_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StreamBackfillAllArgs', 'StreamBackfillAllArgsDict']] backfill_all: Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
               Structure is documented below.
        :param pulumi.Input[Union['StreamBackfillNoneArgs', 'StreamBackfillNoneArgsDict']] backfill_none: Backfill strategy to disable automatic backfill for the Stream's objects.
        :param pulumi.Input[builtins.bool] create_without_validation: Create the stream without validating it.
        :param pulumi.Input[builtins.str] customer_managed_encryption_key: A reference to a KMS encryption key. If provided, it will be used to encrypt the data. If left blank, data
               will be encrypted using an internal Stream-specific encryption key provisioned through KMS.
        :param pulumi.Input[builtins.str] desired_state: Desired state of the Stream. Set this field to `RUNNING` to start the stream,
               `NOT_STARTED` to create the stream without starting and `PAUSED` to pause
               the stream from a `RUNNING` state.
               Possible values: NOT_STARTED, RUNNING, PAUSED. Default: NOT_STARTED
        :param pulumi.Input[Union['StreamDestinationConfigArgs', 'StreamDestinationConfigArgsDict']] destination_config: Destination connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: Display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The name of the location this stream is located in.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['StreamSourceConfigArgs', 'StreamSourceConfigArgsDict']] source_config: Source connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] stream_id: The stream identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A resource representing streaming data from a source to a destination.

        To get more information about Stream, see:

        * [API documentation](https://cloud.google.com/datastream/docs/reference/rest/v1/projects.locations.streams)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/datastream/docs/create-a-stream)

        ## Example Usage

        ### Datastream Stream Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        bucket = gcp.storage.Bucket("bucket",
            name="my-bucket",
            location="US",
            uniform_bucket_level_access=True)
        viewer = gcp.storage.BucketIAMMember("viewer",
            bucket=bucket.name,
            role="roles/storage.objectViewer",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        creator = gcp.storage.BucketIAMMember("creator",
            bucket=bucket.name,
            role="roles/storage.objectCreator",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        reader = gcp.storage.BucketIAMMember("reader",
            bucket=bucket.name,
            role="roles/storage.legacyBucketReader",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        key_user = gcp.kms.CryptoKeyIAMMember("key_user",
            crypto_key_id="kms-name",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        destination_connection_profile = gcp.datastream.ConnectionProfile("destination_connection_profile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="destination-profile",
            gcs_profile={
                "bucket": bucket.name,
                "root_path": "/path",
            })
        default = gcp.datastream.Stream("default",
            stream_id="my-stream",
            desired_state="NOT_STARTED",
            location="us-central1",
            display_name="my stream",
            labels={
                "key": "value",
            },
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {
                    "include_objects": {
                        "mysql_databases": [{
                            "database": "my-database",
                            "mysql_tables": [
                                {
                                    "table": "includedTable",
                                    "mysql_columns": [{
                                        "column": "includedColumn",
                                        "data_type": "VARCHAR",
                                        "collation": "utf8mb4",
                                        "primary_key": False,
                                        "nullable": False,
                                        "ordinal_position": 0,
                                    }],
                                },
                                {
                                    "table": "includedTable_2",
                                },
                            ],
                        }],
                    },
                    "exclude_objects": {
                        "mysql_databases": [{
                            "database": "my-database",
                            "mysql_tables": [{
                                "table": "excludedTable",
                                "mysql_columns": [{
                                    "column": "excludedColumn",
                                    "data_type": "VARCHAR",
                                    "collation": "utf8mb4",
                                    "primary_key": False,
                                    "nullable": False,
                                    "ordinal_position": 0,
                                }],
                            }],
                        }],
                    },
                    "max_concurrent_cdc_tasks": 5,
                },
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile.id,
                "gcs_destination_config": {
                    "path": "mydata",
                    "file_rotation_mb": 200,
                    "file_rotation_interval": "60s",
                    "json_file_format": {
                        "schema_file_format": "NO_SCHEMA_FILE",
                        "compression": "GZIP",
                    },
                },
            },
            backfill_all={
                "mysql_excluded_objects": {
                    "mysql_databases": [{
                        "database": "my-database",
                        "mysql_tables": [{
                            "table": "excludedTable",
                            "mysql_columns": [{
                                "column": "excludedColumn",
                                "data_type": "VARCHAR",
                                "collation": "utf8mb4",
                                "primary_key": False,
                                "nullable": False,
                                "ordinal_position": 0,
                            }],
                        }],
                    }],
                },
            },
            customer_managed_encryption_key="kms-name",
            opts = pulumi.ResourceOptions(depends_on=[key_user]))
        ```
        ### Datastream Stream Postgresql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source = gcp.datastream.ConnectionProfile("source",
            display_name="Postgresql Source",
            location="us-central1",
            connection_profile_id="source-profile",
            postgresql_profile={
                "hostname": "hostname",
                "port": 5432,
                "username": "user",
                "password": "pass",
                "database": "postgres",
            })
        destination = gcp.datastream.ConnectionProfile("destination",
            display_name="BigQuery Destination",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            display_name="Postgres to BigQuery",
            location="us-central1",
            stream_id="my-stream",
            desired_state="RUNNING",
            source_config={
                "source_connection_profile": source.id,
                "postgresql_source_config": {
                    "max_concurrent_backfill_tasks": 12,
                    "publication": "publication",
                    "replication_slot": "replication_slot",
                    "include_objects": {
                        "postgresql_schemas": [{
                            "schema": "schema",
                            "postgresql_tables": [{
                                "table": "table",
                                "postgresql_columns": [{
                                    "column": "column",
                                }],
                            }],
                        }],
                    },
                    "exclude_objects": {
                        "postgresql_schemas": [{
                            "schema": "schema",
                            "postgresql_tables": [{
                                "table": "table",
                                "postgresql_columns": [{
                                    "column": "column",
                                }],
                            }],
                        }],
                    },
                },
            },
            destination_config={
                "destination_connection_profile": destination.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                },
            },
            backfill_all={
                "postgresql_excluded_objects": {
                    "postgresql_schemas": [{
                        "schema": "schema",
                        "postgresql_tables": [{
                            "table": "table",
                            "postgresql_columns": [{
                                "column": "column",
                            }],
                        }],
                    }],
                },
            })
        ```
        ### Datastream Stream Oracle

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source = gcp.datastream.ConnectionProfile("source",
            display_name="Oracle Source",
            location="us-central1",
            connection_profile_id="source-profile",
            oracle_profile={
                "hostname": "hostname",
                "port": 1521,
                "username": "user",
                "password": "pass",
                "database_service": "ORCL",
            })
        destination = gcp.datastream.ConnectionProfile("destination",
            display_name="BigQuery Destination",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        stream5 = gcp.datastream.Stream("stream5",
            display_name="Oracle to BigQuery",
            location="us-central1",
            stream_id="my-stream",
            desired_state="RUNNING",
            source_config={
                "source_connection_profile": source.id,
                "oracle_source_config": {
                    "max_concurrent_cdc_tasks": 8,
                    "max_concurrent_backfill_tasks": 12,
                    "include_objects": {
                        "oracle_schemas": [{
                            "schema": "schema",
                            "oracle_tables": [{
                                "table": "table",
                                "oracle_columns": [{
                                    "column": "column",
                                }],
                            }],
                        }],
                    },
                    "exclude_objects": {
                        "oracle_schemas": [{
                            "schema": "schema",
                            "oracle_tables": [{
                                "table": "table",
                                "oracle_columns": [{
                                    "column": "column",
                                }],
                            }],
                        }],
                    },
                    "drop_large_objects": {},
                },
            },
            destination_config={
                "destination_connection_profile": destination.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                },
            },
            backfill_all={
                "oracle_excluded_objects": {
                    "oracle_schemas": [{
                        "schema": "schema",
                        "oracle_tables": [{
                            "table": "table",
                            "oracle_columns": [{
                                "column": "column",
                            }],
                        }],
                    }],
                },
            })
        ```
        ### Datastream Stream Sql Server

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="sql-server",
            database_version="SQLSERVER_2019_STANDARD",
            region="us-central1",
            root_password="root-password",
            deletion_protection=True,
            settings={
                "tier": "db-custom-2-4096",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            })
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password="password")
        db = gcp.sql.Database("db",
            name="db",
            instance=instance.name,
            opts = pulumi.ResourceOptions(depends_on=[user]))
        source = gcp.datastream.ConnectionProfile("source",
            display_name="SQL Server Source",
            location="us-central1",
            connection_profile_id="source-profile",
            sql_server_profile={
                "hostname": instance.public_ip_address,
                "port": 1433,
                "username": user.name,
                "password": user.password,
                "database": db.name,
            })
        destination = gcp.datastream.ConnectionProfile("destination",
            display_name="BigQuery Destination",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            display_name="SQL Server to BigQuery",
            location="us-central1",
            stream_id="stream",
            source_config={
                "source_connection_profile": source.id,
                "sql_server_source_config": {
                    "include_objects": {
                        "schemas": [{
                            "schema": "schema",
                            "tables": [{
                                "table": "table",
                            }],
                        }],
                    },
                    "transaction_logs": {},
                },
            },
            destination_config={
                "destination_connection_profile": destination.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                },
            },
            backfill_none={})
        ```
        ### Datastream Stream Sql Server Change Tables

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="sql-server",
            database_version="SQLSERVER_2019_STANDARD",
            region="us-central1",
            root_password="root-password",
            deletion_protection=True,
            settings={
                "tier": "db-custom-2-4096",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            })
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            password="password")
        db = gcp.sql.Database("db",
            name="db",
            instance=instance.name,
            opts = pulumi.ResourceOptions(depends_on=[user]))
        source = gcp.datastream.ConnectionProfile("source",
            display_name="SQL Server Source",
            location="us-central1",
            connection_profile_id="source-profile",
            sql_server_profile={
                "hostname": instance.public_ip_address,
                "port": 1433,
                "username": user.name,
                "password": user.password,
                "database": db.name,
            })
        destination = gcp.datastream.ConnectionProfile("destination",
            display_name="BigQuery Destination",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            display_name="SQL Server to BigQuery",
            location="us-central1",
            stream_id="stream",
            source_config={
                "source_connection_profile": source.id,
                "sql_server_source_config": {
                    "include_objects": {
                        "schemas": [{
                            "schema": "schema",
                            "tables": [{
                                "table": "table",
                            }],
                        }],
                    },
                    "change_tables": {},
                },
            },
            destination_config={
                "destination_connection_profile": destination.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                },
            },
            backfill_none={})
        ```
        ### Datastream Stream Postgresql Bigquery Dataset Id

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        postgres = gcp.bigquery.Dataset("postgres",
            dataset_id="postgres",
            friendly_name="postgres",
            description="Database of postgres",
            location="us-central1")
        destination_connection_profile2 = gcp.datastream.ConnectionProfile("destination_connection_profile2",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="dest-profile",
            bigquery_profile={})
        instance = gcp.sql.DatabaseInstance("instance",
            name="instance-name",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=False)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="my-user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        default = gcp.datastream.Stream("default",
            display_name="postgres to bigQuery",
            location="us-central1",
            stream_id="postgres-bigquery",
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {},
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile2.id,
                "bigquery_destination_config": {
                    "data_freshness": "900s",
                    "single_target_dataset": {
                        "dataset_id": postgres.id,
                    },
                },
            },
            backfill_all={})
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        ```
        ### Datastream Stream Bigquery

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        bq_sa = gcp.bigquery.get_default_service_account()
        bigquery_key_user = gcp.kms.CryptoKeyIAMMember("bigquery_key_user",
            crypto_key_id="bigquery-kms-name",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:{bq_sa.email}")
        destination_connection_profile = gcp.datastream.ConnectionProfile("destination_connection_profile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            stream_id="my-stream",
            location="us-central1",
            display_name="my stream",
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {},
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile.id,
                "bigquery_destination_config": {
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                            "kms_key_name": "bigquery-kms-name",
                        },
                    },
                },
            },
            backfill_none={},
            opts = pulumi.ResourceOptions(depends_on=[bigquery_key_user]))
        ```
        ### Datastream Stream Bigquery Append Only

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            name="my-instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        destination_connection_profile = gcp.datastream.ConnectionProfile("destination_connection_profile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            stream_id="my-stream",
            location="us-central1",
            display_name="my stream",
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {},
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile.id,
                "bigquery_destination_config": {
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                    "append_only": {},
                },
            },
            backfill_none={})
        ```
        ### Datastream Stream Bigquery Blmt

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            name="blmt-instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "authorized_networks": [
                        {
                            "value": "34.71.242.81",
                        },
                        {
                            "value": "34.72.28.29",
                        },
                        {
                            "value": "34.67.6.157",
                        },
                        {
                            "value": "34.67.234.134",
                        },
                        {
                            "value": "34.72.239.218",
                        },
                    ],
                },
            },
            deletion_protection=True)
        db = gcp.sql.Database("db",
            instance=instance.name,
            name="db")
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            name="user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        blmt_bucket = gcp.storage.Bucket("blmt_bucket",
            name="blmt-bucket",
            location="us-central1",
            force_destroy=True)
        blmt_connection = gcp.bigquery.Connection("blmt_connection",
            project=project.project_id,
            location="us-central1",
            connection_id="blmt-connection",
            friendly_name="Datastream BLMT Test Connection",
            description="Connection for Datastream BLMT test",
            cloud_resource={})
        blmt_connection_bucket_admin = gcp.storage.BucketIAMMember("blmt_connection_bucket_admin",
            bucket=blmt_bucket.name,
            role="roles/storage.admin",
            member=blmt_connection.cloud_resource.apply(lambda cloud_resource: f"serviceAccount:{cloud_resource.service_account_id}"))
        source_connection_profile = gcp.datastream.ConnectionProfile("source_connection_profile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="blmt-source-profile",
            mysql_profile={
                "hostname": instance.public_ip_address,
                "username": user.name,
                "password": user.password,
            })
        destination_connection_profile = gcp.datastream.ConnectionProfile("destination_connection_profile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="blmt-destination-profile",
            bigquery_profile={})
        default = gcp.datastream.Stream("default",
            stream_id="blmt-stream",
            location="us-central1",
            display_name="My BLMT stream",
            source_config={
                "source_connection_profile": source_connection_profile.id,
                "mysql_source_config": {},
            },
            destination_config={
                "destination_connection_profile": destination_connection_profile.id,
                "bigquery_destination_config": {
                    "source_hierarchy_datasets": {
                        "dataset_template": {
                            "location": "us-central1",
                        },
                    },
                    "blmt_config": {
                        "bucket": blmt_bucket.name,
                        "connection_name": pulumi.Output.all(
                            project=blmt_connection.project,
                            location=blmt_connection.location,
                            connection_id=blmt_connection.connection_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['project']}.{resolved_outputs['location']}.{resolved_outputs['connection_id']}")
        ,
                        "file_format": "PARQUET",
                        "table_format": "ICEBERG",
                        "root_path": "/",
                    },
                    "append_only": {},
                },
            },
            backfill_none={})
        ```
        ## Import

        Stream can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/streams/{{stream_id}}`

        * `{{project}}/{{location}}/{{stream_id}}`

        * `{{location}}/{{stream_id}}`

        When using the `pulumi import` command, Stream can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datastream/stream:Stream default projects/{{project}}/locations/{{location}}/streams/{{stream_id}}
        ```

        ```sh
        $ pulumi import gcp:datastream/stream:Stream default {{project}}/{{location}}/{{stream_id}}
        ```

        ```sh
        $ pulumi import gcp:datastream/stream:Stream default {{location}}/{{stream_id}}
        ```

        :param str resource_name: The name of the resource.
        :param StreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backfill_all: Optional[pulumi.Input[Union['StreamBackfillAllArgs', 'StreamBackfillAllArgsDict']]] = None,
                 backfill_none: Optional[pulumi.Input[Union['StreamBackfillNoneArgs', 'StreamBackfillNoneArgsDict']]] = None,
                 create_without_validation: Optional[pulumi.Input[builtins.bool]] = None,
                 customer_managed_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 destination_config: Optional[pulumi.Input[Union['StreamDestinationConfigArgs', 'StreamDestinationConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 source_config: Optional[pulumi.Input[Union['StreamSourceConfigArgs', 'StreamSourceConfigArgsDict']]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamArgs.__new__(StreamArgs)

            __props__.__dict__["backfill_all"] = backfill_all
            __props__.__dict__["backfill_none"] = backfill_none
            __props__.__dict__["create_without_validation"] = create_without_validation
            __props__.__dict__["customer_managed_encryption_key"] = customer_managed_encryption_key
            __props__.__dict__["desired_state"] = desired_state
            if destination_config is None and not opts.urn:
                raise TypeError("Missing required property 'destination_config'")
            __props__.__dict__["destination_config"] = destination_config
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if source_config is None and not opts.urn:
                raise TypeError("Missing required property 'source_config'")
            __props__.__dict__["source_config"] = source_config
            if stream_id is None and not opts.urn:
                raise TypeError("Missing required property 'stream_id'")
            __props__.__dict__["stream_id"] = stream_id
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Stream, __self__).__init__(
            'gcp:datastream/stream:Stream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backfill_all: Optional[pulumi.Input[Union['StreamBackfillAllArgs', 'StreamBackfillAllArgsDict']]] = None,
            backfill_none: Optional[pulumi.Input[Union['StreamBackfillNoneArgs', 'StreamBackfillNoneArgsDict']]] = None,
            create_without_validation: Optional[pulumi.Input[builtins.bool]] = None,
            customer_managed_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
            desired_state: Optional[pulumi.Input[builtins.str]] = None,
            destination_config: Optional[pulumi.Input[Union['StreamDestinationConfigArgs', 'StreamDestinationConfigArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            source_config: Optional[pulumi.Input[Union['StreamSourceConfigArgs', 'StreamSourceConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            stream_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Stream':
        """
        Get an existing Stream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StreamBackfillAllArgs', 'StreamBackfillAllArgsDict']] backfill_all: Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
               Structure is documented below.
        :param pulumi.Input[Union['StreamBackfillNoneArgs', 'StreamBackfillNoneArgsDict']] backfill_none: Backfill strategy to disable automatic backfill for the Stream's objects.
        :param pulumi.Input[builtins.bool] create_without_validation: Create the stream without validating it.
        :param pulumi.Input[builtins.str] customer_managed_encryption_key: A reference to a KMS encryption key. If provided, it will be used to encrypt the data. If left blank, data
               will be encrypted using an internal Stream-specific encryption key provisioned through KMS.
        :param pulumi.Input[builtins.str] desired_state: Desired state of the Stream. Set this field to `RUNNING` to start the stream,
               `NOT_STARTED` to create the stream without starting and `PAUSED` to pause
               the stream from a `RUNNING` state.
               Possible values: NOT_STARTED, RUNNING, PAUSED. Default: NOT_STARTED
        :param pulumi.Input[Union['StreamDestinationConfigArgs', 'StreamDestinationConfigArgsDict']] destination_config: Destination connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: Display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The name of the location this stream is located in.
        :param pulumi.Input[builtins.str] name: The stream's name.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['StreamSourceConfigArgs', 'StreamSourceConfigArgsDict']] source_config: Source connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: The state of the stream.
        :param pulumi.Input[builtins.str] stream_id: The stream identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamState.__new__(_StreamState)

        __props__.__dict__["backfill_all"] = backfill_all
        __props__.__dict__["backfill_none"] = backfill_none
        __props__.__dict__["create_without_validation"] = create_without_validation
        __props__.__dict__["customer_managed_encryption_key"] = customer_managed_encryption_key
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["destination_config"] = destination_config
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["source_config"] = source_config
        __props__.__dict__["state"] = state
        __props__.__dict__["stream_id"] = stream_id
        return Stream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backfillAll")
    def backfill_all(self) -> pulumi.Output[Optional['outputs.StreamBackfillAll']]:
        """
        Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_all")

    @property
    @pulumi.getter(name="backfillNone")
    def backfill_none(self) -> pulumi.Output[Optional['outputs.StreamBackfillNone']]:
        """
        Backfill strategy to disable automatic backfill for the Stream's objects.
        """
        return pulumi.get(self, "backfill_none")

    @property
    @pulumi.getter(name="createWithoutValidation")
    def create_without_validation(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Create the stream without validating it.
        """
        return pulumi.get(self, "create_without_validation")

    @property
    @pulumi.getter(name="customerManagedEncryptionKey")
    def customer_managed_encryption_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A reference to a KMS encryption key. If provided, it will be used to encrypt the data. If left blank, data
        will be encrypted using an internal Stream-specific encryption key provisioned through KMS.
        """
        return pulumi.get(self, "customer_managed_encryption_key")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Desired state of the Stream. Set this field to `RUNNING` to start the stream,
        `NOT_STARTED` to create the stream without starting and `PAUSED` to pause
        the stream from a `RUNNING` state.
        Possible values: NOT_STARTED, RUNNING, PAUSED. Default: NOT_STARTED
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Output['outputs.StreamDestinationConfig']:
        """
        Destination connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_config")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The name of the location this stream is located in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The stream's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> pulumi.Output['outputs.StreamSourceConfig']:
        """
        Source connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "source_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the stream.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Output[builtins.str]:
        """
        The stream identifier.
        """
        return pulumi.get(self, "stream_id")

