# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountConnectorArgs', 'AccountConnector']

@pulumi.input_type
class AccountConnectorArgs:
    def __init__(__self__, *,
                 account_connector_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 provider_oauth_config: Optional[pulumi.Input['AccountConnectorProviderOauthConfigArgs']] = None):
        """
        The set of arguments for constructing a AccountConnector resource.
        :param pulumi.Input[builtins.str] account_connector_id: Required. The ID to use for the AccountConnector, which will become the final
               component of the AccountConnector's resource name. Its format should adhere
               to https://google.aip.dev/122#resource-id-segments Names must be unique
               per-project per-location.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Allows users to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AccountConnectorProviderOauthConfigArgs'] provider_oauth_config: ProviderOAuthConfig is the OAuth config for a provider.
               Structure is documented below.
        """
        pulumi.set(__self__, "account_connector_id", account_connector_id)
        pulumi.set(__self__, "location", location)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if provider_oauth_config is not None:
            pulumi.set(__self__, "provider_oauth_config", provider_oauth_config)

    @property
    @pulumi.getter(name="accountConnectorId")
    def account_connector_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. The ID to use for the AccountConnector, which will become the final
        component of the AccountConnector's resource name. Its format should adhere
        to https://google.aip.dev/122#resource-id-segments Names must be unique
        per-project per-location.
        """
        return pulumi.get(self, "account_connector_id")

    @account_connector_id.setter
    def account_connector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_connector_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Allows users to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="providerOauthConfig")
    def provider_oauth_config(self) -> Optional[pulumi.Input['AccountConnectorProviderOauthConfigArgs']]:
        """
        ProviderOAuthConfig is the OAuth config for a provider.
        Structure is documented below.
        """
        return pulumi.get(self, "provider_oauth_config")

    @provider_oauth_config.setter
    def provider_oauth_config(self, value: Optional[pulumi.Input['AccountConnectorProviderOauthConfigArgs']]):
        pulumi.set(self, "provider_oauth_config", value)


@pulumi.input_type
class _AccountConnectorState:
    def __init__(__self__, *,
                 account_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_start_uri: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 provider_oauth_config: Optional[pulumi.Input['AccountConnectorProviderOauthConfigArgs']] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountConnector resources.
        :param pulumi.Input[builtins.str] account_connector_id: Required. The ID to use for the AccountConnector, which will become the final
               component of the AccountConnector's resource name. Its format should adhere
               to https://google.aip.dev/122#resource-id-segments Names must be unique
               per-project per-location.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Allows users to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp when the userConnection was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the userConnection, in the format
               `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
        :param pulumi.Input[builtins.str] oauth_start_uri: Output only. Start OAuth flow by clicking on this URL.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AccountConnectorProviderOauthConfigArgs'] provider_oauth_config: ProviderOAuthConfig is the OAuth config for a provider.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: Output only. The timestamp when the userConnection was updated.
        """
        if account_connector_id is not None:
            pulumi.set(__self__, "account_connector_id", account_connector_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_start_uri is not None:
            pulumi.set(__self__, "oauth_start_uri", oauth_start_uri)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if provider_oauth_config is not None:
            pulumi.set(__self__, "provider_oauth_config", provider_oauth_config)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accountConnectorId")
    def account_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The ID to use for the AccountConnector, which will become the final
        component of the AccountConnector's resource name. Its format should adhere
        to https://google.aip.dev/122#resource-id-segments Names must be unique
        per-project per-location.
        """
        return pulumi.get(self, "account_connector_id")

    @account_connector_id.setter
    def account_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_connector_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Allows users to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp when the userConnection was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The resource name of the userConnection, in the format
        `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthStartUri")
    def oauth_start_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Start OAuth flow by clicking on this URL.
        """
        return pulumi.get(self, "oauth_start_uri")

    @oauth_start_uri.setter
    def oauth_start_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth_start_uri", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="providerOauthConfig")
    def provider_oauth_config(self) -> Optional[pulumi.Input['AccountConnectorProviderOauthConfigArgs']]:
        """
        ProviderOAuthConfig is the OAuth config for a provider.
        Structure is documented below.
        """
        return pulumi.get(self, "provider_oauth_config")

    @provider_oauth_config.setter
    def provider_oauth_config(self, value: Optional[pulumi.Input['AccountConnectorProviderOauthConfigArgs']]):
        pulumi.set(self, "provider_oauth_config", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp when the userConnection was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:developerconnect/accountConnector:AccountConnector")
class AccountConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 provider_oauth_config: Optional[pulumi.Input[Union['AccountConnectorProviderOauthConfigArgs', 'AccountConnectorProviderOauthConfigArgsDict']]] = None,
                 __props__=None):
        """
        Description

        ## Example Usage

        ### Developer Connect Account Connector Github

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "GITHUB",
                "scopes": ["repo"],
            })
        ```
        ### Developer Connect Account Connector Gitlab

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "GITLAB",
                "scopes": ["api"],
            })
        ```
        ### Developer Connect Account Connector Google

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "GOOGLE",
                "scopes": ["https://www.googleapis.com/auth/drive.readonly"],
            })
        ```
        ### Developer Connect Account Connector Sentry

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "SENTRY",
                "scopes": ["org:read"],
            })
        ```
        ### Developer Connect Account Connector Rovo

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "ROVO",
                "scopes": ["rovo"],
            })
        ```
        ### Developer Connect Account Connector New Relic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "NEW_RELIC",
                "scopes": [],
            })
        ```
        ### Developer Connect Account Connector Datastax

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "DATASTAX",
                "scopes": [],
            })
        ```

        ## Import

        AccountConnector can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/accountConnectors/{{account_connector_id}}`

        * `{{project}}/{{location}}/{{account_connector_id}}`

        * `{{location}}/{{account_connector_id}}`

        When using the `pulumi import` command, AccountConnector can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:developerconnect/accountConnector:AccountConnector default projects/{{project}}/locations/{{location}}/accountConnectors/{{account_connector_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/accountConnector:AccountConnector default {{project}}/{{location}}/{{account_connector_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/accountConnector:AccountConnector default {{location}}/{{account_connector_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_connector_id: Required. The ID to use for the AccountConnector, which will become the final
               component of the AccountConnector's resource name. Its format should adhere
               to https://google.aip.dev/122#resource-id-segments Names must be unique
               per-project per-location.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Allows users to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AccountConnectorProviderOauthConfigArgs', 'AccountConnectorProviderOauthConfigArgsDict']] provider_oauth_config: ProviderOAuthConfig is the OAuth config for a provider.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description

        ## Example Usage

        ### Developer Connect Account Connector Github

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "GITHUB",
                "scopes": ["repo"],
            })
        ```
        ### Developer Connect Account Connector Gitlab

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "GITLAB",
                "scopes": ["api"],
            })
        ```
        ### Developer Connect Account Connector Google

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "GOOGLE",
                "scopes": ["https://www.googleapis.com/auth/drive.readonly"],
            })
        ```
        ### Developer Connect Account Connector Sentry

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "SENTRY",
                "scopes": ["org:read"],
            })
        ```
        ### Developer Connect Account Connector Rovo

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "ROVO",
                "scopes": ["rovo"],
            })
        ```
        ### Developer Connect Account Connector New Relic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "NEW_RELIC",
                "scopes": [],
            })
        ```
        ### Developer Connect Account Connector Datastax

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_account_connector = gcp.developerconnect.AccountConnector("my-account-connector",
            location="us-central1",
            account_connector_id="tf-test-ac",
            provider_oauth_config={
                "system_provider_id": "DATASTAX",
                "scopes": [],
            })
        ```

        ## Import

        AccountConnector can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/accountConnectors/{{account_connector_id}}`

        * `{{project}}/{{location}}/{{account_connector_id}}`

        * `{{location}}/{{account_connector_id}}`

        When using the `pulumi import` command, AccountConnector can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:developerconnect/accountConnector:AccountConnector default projects/{{project}}/locations/{{location}}/accountConnectors/{{account_connector_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/accountConnector:AccountConnector default {{project}}/{{location}}/{{account_connector_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/accountConnector:AccountConnector default {{location}}/{{account_connector_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AccountConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 provider_oauth_config: Optional[pulumi.Input[Union['AccountConnectorProviderOauthConfigArgs', 'AccountConnectorProviderOauthConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountConnectorArgs.__new__(AccountConnectorArgs)

            if account_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_connector_id'")
            __props__.__dict__["account_connector_id"] = account_connector_id
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["provider_oauth_config"] = provider_oauth_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["oauth_start_uri"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AccountConnector, __self__).__init__(
            'gcp:developerconnect/accountConnector:AccountConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_connector_id: Optional[pulumi.Input[builtins.str]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            oauth_start_uri: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            provider_oauth_config: Optional[pulumi.Input[Union['AccountConnectorProviderOauthConfigArgs', 'AccountConnectorProviderOauthConfigArgsDict']]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'AccountConnector':
        """
        Get an existing AccountConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_connector_id: Required. The ID to use for the AccountConnector, which will become the final
               component of the AccountConnector's resource name. Its format should adhere
               to https://google.aip.dev/122#resource-id-segments Names must be unique
               per-project per-location.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Allows users to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp when the userConnection was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the userConnection, in the format
               `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
        :param pulumi.Input[builtins.str] oauth_start_uri: Output only. Start OAuth flow by clicking on this URL.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AccountConnectorProviderOauthConfigArgs', 'AccountConnectorProviderOauthConfigArgsDict']] provider_oauth_config: ProviderOAuthConfig is the OAuth config for a provider.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: Output only. The timestamp when the userConnection was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountConnectorState.__new__(_AccountConnectorState)

        __props__.__dict__["account_connector_id"] = account_connector_id
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_start_uri"] = oauth_start_uri
        __props__.__dict__["project"] = project
        __props__.__dict__["provider_oauth_config"] = provider_oauth_config
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        return AccountConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountConnectorId")
    def account_connector_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. The ID to use for the AccountConnector, which will become the final
        component of the AccountConnector's resource name. Its format should adhere
        to https://google.aip.dev/122#resource-id-segments Names must be unique
        per-project per-location.
        """
        return pulumi.get(self, "account_connector_id")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Allows users to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp when the userConnection was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The resource name of the userConnection, in the format
        `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthStartUri")
    def oauth_start_uri(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Start OAuth flow by clicking on this URL.
        """
        return pulumi.get(self, "oauth_start_uri")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="providerOauthConfig")
    def provider_oauth_config(self) -> pulumi.Output[Optional['outputs.AccountConnectorProviderOauthConfig']]:
        """
        ProviderOAuthConfig is the OAuth config for a provider.
        Structure is documented below.
        """
        return pulumi.get(self, "provider_oauth_config")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp when the userConnection was updated.
        """
        return pulumi.get(self, "update_time")

