# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccountConnectorProviderOauthConfig',
    'ConnectionBitbucketCloudConfig',
    'ConnectionBitbucketCloudConfigAuthorizerCredential',
    'ConnectionBitbucketCloudConfigReadAuthorizerCredential',
    'ConnectionBitbucketDataCenterConfig',
    'ConnectionBitbucketDataCenterConfigAuthorizerCredential',
    'ConnectionBitbucketDataCenterConfigReadAuthorizerCredential',
    'ConnectionBitbucketDataCenterConfigServiceDirectoryConfig',
    'ConnectionCryptoKeyConfig',
    'ConnectionGithubConfig',
    'ConnectionGithubConfigAuthorizerCredential',
    'ConnectionGithubEnterpriseConfig',
    'ConnectionGithubEnterpriseConfigServiceDirectoryConfig',
    'ConnectionGitlabConfig',
    'ConnectionGitlabConfigAuthorizerCredential',
    'ConnectionGitlabConfigReadAuthorizerCredential',
    'ConnectionGitlabEnterpriseConfig',
    'ConnectionGitlabEnterpriseConfigAuthorizerCredential',
    'ConnectionGitlabEnterpriseConfigReadAuthorizerCredential',
    'ConnectionGitlabEnterpriseConfigServiceDirectoryConfig',
    'ConnectionInstallationState',
]

@pulumi.output_type
class AccountConnectorProviderOauthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemProviderId":
            suggest = "system_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountConnectorProviderOauthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountConnectorProviderOauthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountConnectorProviderOauthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scopes: Sequence[builtins.str],
                 system_provider_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] scopes: Required. User selected scopes to apply to the Oauth config
               In the event of changing scopes, user records under AccountConnector will
               be deleted and users will re-auth again.
        :param builtins.str system_provider_id: List of providers that are owned by Developer Connect.
               Possible values:
               GITHUB
               GITLAB
               GOOGLE
               SENTRY
               ROVO
               NEW_RELIC
               DATASTAX
        """
        pulumi.set(__self__, "scopes", scopes)
        if system_provider_id is not None:
            pulumi.set(__self__, "system_provider_id", system_provider_id)

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[builtins.str]:
        """
        Required. User selected scopes to apply to the Oauth config
        In the event of changing scopes, user records under AccountConnector will
        be deleted and users will re-auth again.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="systemProviderId")
    def system_provider_id(self) -> Optional[builtins.str]:
        """
        List of providers that are owned by Developer Connect.
        Possible values:
        GITHUB
        GITLAB
        GOOGLE
        SENTRY
        ROVO
        NEW_RELIC
        DATASTAX
        """
        return pulumi.get(self, "system_provider_id")


@pulumi.output_type
class ConnectionBitbucketCloudConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerCredential":
            suggest = "authorizer_credential"
        elif key == "readAuthorizerCredential":
            suggest = "read_authorizer_credential"
        elif key == "webhookSecretSecretVersion":
            suggest = "webhook_secret_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBitbucketCloudConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBitbucketCloudConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBitbucketCloudConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_credential: 'outputs.ConnectionBitbucketCloudConfigAuthorizerCredential',
                 read_authorizer_credential: 'outputs.ConnectionBitbucketCloudConfigReadAuthorizerCredential',
                 webhook_secret_secret_version: builtins.str,
                 workspace: builtins.str):
        """
        :param 'ConnectionBitbucketCloudConfigAuthorizerCredentialArgs' authorizer_credential: Represents a personal access token that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param 'ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgs' read_authorizer_credential: Represents a personal access token that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param builtins.str webhook_secret_secret_version: Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook
               events, formatted as `projects/*/secrets/*/versions/*`. This is used to
               validate and create webhooks.
        :param builtins.str workspace: Required. The Bitbucket Cloud Workspace ID to be connected to Google Cloud Platform.
        """
        pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        pulumi.set(__self__, "read_authorizer_credential", read_authorizer_credential)
        pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)
        pulumi.set(__self__, "workspace", workspace)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> 'outputs.ConnectionBitbucketCloudConfigAuthorizerCredential':
        """
        Represents a personal access token that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @property
    @pulumi.getter(name="readAuthorizerCredential")
    def read_authorizer_credential(self) -> 'outputs.ConnectionBitbucketCloudConfigReadAuthorizerCredential':
        """
        Represents a personal access token that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "read_authorizer_credential")

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> builtins.str:
        """
        Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook
        events, formatted as `projects/*/secrets/*/versions/*`. This is used to
        validate and create webhooks.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @property
    @pulumi.getter
    def workspace(self) -> builtins.str:
        """
        Required. The Bitbucket Cloud Workspace ID to be connected to Google Cloud Platform.
        """
        return pulumi.get(self, "workspace")


@pulumi.output_type
class ConnectionBitbucketCloudConfigAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userTokenSecretVersion":
            suggest = "user_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBitbucketCloudConfigAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBitbucketCloudConfigAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBitbucketCloudConfigAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes
               the Developer Connect connection. Format:
               `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the user token that authorizes
        the Developer Connect connection. Format:
        `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionBitbucketCloudConfigReadAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userTokenSecretVersion":
            suggest = "user_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBitbucketCloudConfigReadAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBitbucketCloudConfigReadAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBitbucketCloudConfigReadAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes
               the Developer Connect connection. Format:
               `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the user token that authorizes
        the Developer Connect connection. Format:
        `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionBitbucketDataCenterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerCredential":
            suggest = "authorizer_credential"
        elif key == "hostUri":
            suggest = "host_uri"
        elif key == "readAuthorizerCredential":
            suggest = "read_authorizer_credential"
        elif key == "webhookSecretSecretVersion":
            suggest = "webhook_secret_secret_version"
        elif key == "serverVersion":
            suggest = "server_version"
        elif key == "serviceDirectoryConfig":
            suggest = "service_directory_config"
        elif key == "sslCaCertificate":
            suggest = "ssl_ca_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBitbucketDataCenterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBitbucketDataCenterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBitbucketDataCenterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_credential: 'outputs.ConnectionBitbucketDataCenterConfigAuthorizerCredential',
                 host_uri: builtins.str,
                 read_authorizer_credential: 'outputs.ConnectionBitbucketDataCenterConfigReadAuthorizerCredential',
                 webhook_secret_secret_version: builtins.str,
                 server_version: Optional[builtins.str] = None,
                 service_directory_config: Optional['outputs.ConnectionBitbucketDataCenterConfigServiceDirectoryConfig'] = None,
                 ssl_ca_certificate: Optional[builtins.str] = None):
        """
        :param 'ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgs' authorizer_credential: Represents a personal access token that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param builtins.str host_uri: Required. The URI of the Bitbucket Data Center host this connection is for.
        :param 'ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgs' read_authorizer_credential: Represents a personal access token that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param builtins.str webhook_secret_secret_version: Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook
               events, formatted as `projects/*/secrets/*/versions/*`. This is used to
               validate webhooks.
        :param builtins.str server_version: (Output)
               Output only. Version of the Bitbucket Data Center server running on the `host_uri`.
        :param 'ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgs' service_directory_config: ServiceDirectoryConfig represents Service Directory configuration for a
               connection.
               Structure is documented below.
        :param builtins.str ssl_ca_certificate: Optional. SSL certificate authority to trust when making requests to Bitbucket Data
               Center.
        """
        pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "read_authorizer_credential", read_authorizer_credential)
        pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if ssl_ca_certificate is not None:
            pulumi.set(__self__, "ssl_ca_certificate", ssl_ca_certificate)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> 'outputs.ConnectionBitbucketDataCenterConfigAuthorizerCredential':
        """
        Represents a personal access token that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> builtins.str:
        """
        Required. The URI of the Bitbucket Data Center host this connection is for.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter(name="readAuthorizerCredential")
    def read_authorizer_credential(self) -> 'outputs.ConnectionBitbucketDataCenterConfigReadAuthorizerCredential':
        """
        Represents a personal access token that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "read_authorizer_credential")

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> builtins.str:
        """
        Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook
        events, formatted as `projects/*/secrets/*/versions/*`. This is used to
        validate webhooks.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Version of the Bitbucket Data Center server running on the `host_uri`.
        """
        return pulumi.get(self, "server_version")

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional['outputs.ConnectionBitbucketDataCenterConfigServiceDirectoryConfig']:
        """
        ServiceDirectoryConfig represents Service Directory configuration for a
        connection.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @property
    @pulumi.getter(name="sslCaCertificate")
    def ssl_ca_certificate(self) -> Optional[builtins.str]:
        """
        Optional. SSL certificate authority to trust when making requests to Bitbucket Data
        Center.
        """
        return pulumi.get(self, "ssl_ca_certificate")


@pulumi.output_type
class ConnectionBitbucketDataCenterConfigAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userTokenSecretVersion":
            suggest = "user_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBitbucketDataCenterConfigAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBitbucketDataCenterConfigAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBitbucketDataCenterConfigAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes
               the Developer Connect connection. Format:
               `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the user token that authorizes
        the Developer Connect connection. Format:
        `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionBitbucketDataCenterConfigReadAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userTokenSecretVersion":
            suggest = "user_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBitbucketDataCenterConfigReadAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBitbucketDataCenterConfigReadAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBitbucketDataCenterConfigReadAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes
               the Developer Connect connection. Format:
               `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the user token that authorizes
        the Developer Connect connection. Format:
        `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionBitbucketDataCenterConfigServiceDirectoryConfig(dict):
    def __init__(__self__, *,
                 service: builtins.str):
        """
        :param builtins.str service: Required. The Service Directory service name.
               Format:
               projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        Required. The Service Directory service name.
        Format:
        projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ConnectionCryptoKeyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyReference":
            suggest = "key_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionCryptoKeyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionCryptoKeyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionCryptoKeyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_reference: builtins.str):
        """
        :param builtins.str key_reference: Required. The name of the key which is used to encrypt/decrypt customer data. For key
               in Cloud KMS, the key should be in the format of
               `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        pulumi.set(__self__, "key_reference", key_reference)

    @property
    @pulumi.getter(name="keyReference")
    def key_reference(self) -> builtins.str:
        """
        Required. The name of the key which is used to encrypt/decrypt customer data. For key
        in Cloud KMS, the key should be in the format of
        `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "key_reference")


@pulumi.output_type
class ConnectionGithubConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "githubApp":
            suggest = "github_app"
        elif key == "appInstallationId":
            suggest = "app_installation_id"
        elif key == "authorizerCredential":
            suggest = "authorizer_credential"
        elif key == "installationUri":
            suggest = "installation_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGithubConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGithubConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGithubConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 github_app: builtins.str,
                 app_installation_id: Optional[builtins.str] = None,
                 authorizer_credential: Optional['outputs.ConnectionGithubConfigAuthorizerCredential'] = None,
                 installation_uri: Optional[builtins.str] = None):
        """
        :param builtins.str github_app: Required. Immutable. The GitHub Application that was installed to the GitHub user or
               organization.
               Possible values:
               GIT_HUB_APP_UNSPECIFIED
               DEVELOPER_CONNECT
               FIREBASE
        :param builtins.str app_installation_id: Optional. GitHub App installation id.
        :param 'ConnectionGithubConfigAuthorizerCredentialArgs' authorizer_credential: Represents an OAuth token of the account that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param builtins.str installation_uri: (Output)
               Output only. The URI to navigate to in order to manage the installation associated
               with this GitHubConfig.
        """
        pulumi.set(__self__, "github_app", github_app)
        if app_installation_id is not None:
            pulumi.set(__self__, "app_installation_id", app_installation_id)
        if authorizer_credential is not None:
            pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        if installation_uri is not None:
            pulumi.set(__self__, "installation_uri", installation_uri)

    @property
    @pulumi.getter(name="githubApp")
    def github_app(self) -> builtins.str:
        """
        Required. Immutable. The GitHub Application that was installed to the GitHub user or
        organization.
        Possible values:
        GIT_HUB_APP_UNSPECIFIED
        DEVELOPER_CONNECT
        FIREBASE
        """
        return pulumi.get(self, "github_app")

    @property
    @pulumi.getter(name="appInstallationId")
    def app_installation_id(self) -> Optional[builtins.str]:
        """
        Optional. GitHub App installation id.
        """
        return pulumi.get(self, "app_installation_id")

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> Optional['outputs.ConnectionGithubConfigAuthorizerCredential']:
        """
        Represents an OAuth token of the account that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @property
    @pulumi.getter(name="installationUri")
    def installation_uri(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The URI to navigate to in order to manage the installation associated
        with this GitHubConfig.
        """
        return pulumi.get(self, "installation_uri")


@pulumi.output_type
class ConnectionGithubConfigAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oauthTokenSecretVersion":
            suggest = "oauth_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGithubConfigAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGithubConfigAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGithubConfigAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oauth_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str oauth_token_secret_version: Required. A SecretManager resource containing the OAuth token that authorizes
               the connection. Format: `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "oauth_token_secret_version", oauth_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="oauthTokenSecretVersion")
    def oauth_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the OAuth token that authorizes
        the connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "oauth_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionGithubEnterpriseConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostUri":
            suggest = "host_uri"
        elif key == "appId":
            suggest = "app_id"
        elif key == "appInstallationId":
            suggest = "app_installation_id"
        elif key == "appSlug":
            suggest = "app_slug"
        elif key == "installationUri":
            suggest = "installation_uri"
        elif key == "privateKeySecretVersion":
            suggest = "private_key_secret_version"
        elif key == "serverVersion":
            suggest = "server_version"
        elif key == "serviceDirectoryConfig":
            suggest = "service_directory_config"
        elif key == "sslCaCertificate":
            suggest = "ssl_ca_certificate"
        elif key == "webhookSecretSecretVersion":
            suggest = "webhook_secret_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGithubEnterpriseConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGithubEnterpriseConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGithubEnterpriseConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_uri: builtins.str,
                 app_id: Optional[builtins.str] = None,
                 app_installation_id: Optional[builtins.str] = None,
                 app_slug: Optional[builtins.str] = None,
                 installation_uri: Optional[builtins.str] = None,
                 private_key_secret_version: Optional[builtins.str] = None,
                 server_version: Optional[builtins.str] = None,
                 service_directory_config: Optional['outputs.ConnectionGithubEnterpriseConfigServiceDirectoryConfig'] = None,
                 ssl_ca_certificate: Optional[builtins.str] = None,
                 webhook_secret_secret_version: Optional[builtins.str] = None):
        """
        :param builtins.str host_uri: Required. The URI of the GitHub Enterprise host this connection is for.
        :param builtins.str app_id: Optional. ID of the GitHub App created from the manifest.
        :param builtins.str app_installation_id: Optional. ID of the installation of the GitHub App.
        :param builtins.str app_slug: (Output)
               Output only. The URL-friendly name of the GitHub App.
        :param builtins.str installation_uri: (Output)
               Output only. The URI to navigate to in order to manage the installation associated
               with this GitHubEnterpriseConfig.
        :param builtins.str private_key_secret_version: Optional. SecretManager resource containing the private key of the GitHub App,
               formatted as `projects/*/secrets/*/versions/*`.
        :param builtins.str server_version: (Output)
               Output only. GitHub Enterprise version installed at the host_uri.
        :param 'ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs' service_directory_config: ServiceDirectoryConfig represents Service Directory configuration for a
               connection.
               Structure is documented below.
        :param builtins.str ssl_ca_certificate: Optional. SSL certificate to use for requests to GitHub Enterprise.
        :param builtins.str webhook_secret_secret_version: Optional. SecretManager resource containing the webhook secret of the GitHub App,
               formatted as `projects/*/secrets/*/versions/*`.
        """
        pulumi.set(__self__, "host_uri", host_uri)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_installation_id is not None:
            pulumi.set(__self__, "app_installation_id", app_installation_id)
        if app_slug is not None:
            pulumi.set(__self__, "app_slug", app_slug)
        if installation_uri is not None:
            pulumi.set(__self__, "installation_uri", installation_uri)
        if private_key_secret_version is not None:
            pulumi.set(__self__, "private_key_secret_version", private_key_secret_version)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if ssl_ca_certificate is not None:
            pulumi.set(__self__, "ssl_ca_certificate", ssl_ca_certificate)
        if webhook_secret_secret_version is not None:
            pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> builtins.str:
        """
        Required. The URI of the GitHub Enterprise host this connection is for.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[builtins.str]:
        """
        Optional. ID of the GitHub App created from the manifest.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appInstallationId")
    def app_installation_id(self) -> Optional[builtins.str]:
        """
        Optional. ID of the installation of the GitHub App.
        """
        return pulumi.get(self, "app_installation_id")

    @property
    @pulumi.getter(name="appSlug")
    def app_slug(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The URL-friendly name of the GitHub App.
        """
        return pulumi.get(self, "app_slug")

    @property
    @pulumi.getter(name="installationUri")
    def installation_uri(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The URI to navigate to in order to manage the installation associated
        with this GitHubEnterpriseConfig.
        """
        return pulumi.get(self, "installation_uri")

    @property
    @pulumi.getter(name="privateKeySecretVersion")
    def private_key_secret_version(self) -> Optional[builtins.str]:
        """
        Optional. SecretManager resource containing the private key of the GitHub App,
        formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "private_key_secret_version")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. GitHub Enterprise version installed at the host_uri.
        """
        return pulumi.get(self, "server_version")

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional['outputs.ConnectionGithubEnterpriseConfigServiceDirectoryConfig']:
        """
        ServiceDirectoryConfig represents Service Directory configuration for a
        connection.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @property
    @pulumi.getter(name="sslCaCertificate")
    def ssl_ca_certificate(self) -> Optional[builtins.str]:
        """
        Optional. SSL certificate to use for requests to GitHub Enterprise.
        """
        return pulumi.get(self, "ssl_ca_certificate")

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> Optional[builtins.str]:
        """
        Optional. SecretManager resource containing the webhook secret of the GitHub App,
        formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "webhook_secret_secret_version")


@pulumi.output_type
class ConnectionGithubEnterpriseConfigServiceDirectoryConfig(dict):
    def __init__(__self__, *,
                 service: builtins.str):
        """
        :param builtins.str service: Required. The Service Directory service name.
               Format:
               projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        Required. The Service Directory service name.
        Format:
        projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ConnectionGitlabConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerCredential":
            suggest = "authorizer_credential"
        elif key == "readAuthorizerCredential":
            suggest = "read_authorizer_credential"
        elif key == "webhookSecretSecretVersion":
            suggest = "webhook_secret_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGitlabConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGitlabConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGitlabConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_credential: 'outputs.ConnectionGitlabConfigAuthorizerCredential',
                 read_authorizer_credential: 'outputs.ConnectionGitlabConfigReadAuthorizerCredential',
                 webhook_secret_secret_version: builtins.str):
        """
        :param 'ConnectionGitlabConfigAuthorizerCredentialArgs' authorizer_credential: Represents a personal access token that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param 'ConnectionGitlabConfigReadAuthorizerCredentialArgs' read_authorizer_credential: Represents a personal access token that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param builtins.str webhook_secret_secret_version: Required. Immutable. SecretManager resource containing the webhook secret of a GitLab project,
               formatted as `projects/*/secrets/*/versions/*`. This is used to validate
               webhooks.
        """
        pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        pulumi.set(__self__, "read_authorizer_credential", read_authorizer_credential)
        pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> 'outputs.ConnectionGitlabConfigAuthorizerCredential':
        """
        Represents a personal access token that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @property
    @pulumi.getter(name="readAuthorizerCredential")
    def read_authorizer_credential(self) -> 'outputs.ConnectionGitlabConfigReadAuthorizerCredential':
        """
        Represents a personal access token that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "read_authorizer_credential")

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> builtins.str:
        """
        Required. Immutable. SecretManager resource containing the webhook secret of a GitLab project,
        formatted as `projects/*/secrets/*/versions/*`. This is used to validate
        webhooks.
        """
        return pulumi.get(self, "webhook_secret_secret_version")


@pulumi.output_type
class ConnectionGitlabConfigAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userTokenSecretVersion":
            suggest = "user_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGitlabConfigAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGitlabConfigAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGitlabConfigAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes
               the Developer Connect connection. Format:
               `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the user token that authorizes
        the Developer Connect connection. Format:
        `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionGitlabConfigReadAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userTokenSecretVersion":
            suggest = "user_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGitlabConfigReadAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGitlabConfigReadAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGitlabConfigReadAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes
               the Developer Connect connection. Format:
               `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the user token that authorizes
        the Developer Connect connection. Format:
        `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionGitlabEnterpriseConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerCredential":
            suggest = "authorizer_credential"
        elif key == "hostUri":
            suggest = "host_uri"
        elif key == "readAuthorizerCredential":
            suggest = "read_authorizer_credential"
        elif key == "webhookSecretSecretVersion":
            suggest = "webhook_secret_secret_version"
        elif key == "serverVersion":
            suggest = "server_version"
        elif key == "serviceDirectoryConfig":
            suggest = "service_directory_config"
        elif key == "sslCaCertificate":
            suggest = "ssl_ca_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGitlabEnterpriseConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGitlabEnterpriseConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGitlabEnterpriseConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_credential: 'outputs.ConnectionGitlabEnterpriseConfigAuthorizerCredential',
                 host_uri: builtins.str,
                 read_authorizer_credential: 'outputs.ConnectionGitlabEnterpriseConfigReadAuthorizerCredential',
                 webhook_secret_secret_version: builtins.str,
                 server_version: Optional[builtins.str] = None,
                 service_directory_config: Optional['outputs.ConnectionGitlabEnterpriseConfigServiceDirectoryConfig'] = None,
                 ssl_ca_certificate: Optional[builtins.str] = None):
        """
        :param 'ConnectionGitlabEnterpriseConfigAuthorizerCredentialArgs' authorizer_credential: Represents a personal access token that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param builtins.str host_uri: Required. The URI of the GitLab Enterprise host this connection is for.
        :param 'ConnectionGitlabEnterpriseConfigReadAuthorizerCredentialArgs' read_authorizer_credential: Represents a personal access token that authorized the Connection,
               and associated metadata.
               Structure is documented below.
        :param builtins.str webhook_secret_secret_version: Required. Immutable. SecretManager resource containing the webhook secret of a GitLab project,
               formatted as `projects/*/secrets/*/versions/*`. This is used to validate
               webhooks.
        :param builtins.str server_version: (Output)
               Output only. Version of the GitLab Enterprise server running on the `host_uri`.
        :param 'ConnectionGitlabEnterpriseConfigServiceDirectoryConfigArgs' service_directory_config: ServiceDirectoryConfig represents Service Directory configuration for a
               connection.
               Structure is documented below.
        :param builtins.str ssl_ca_certificate: Optional. SSL Certificate Authority certificate to use for requests to GitLab
               Enterprise instance.
        """
        pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "read_authorizer_credential", read_authorizer_credential)
        pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if ssl_ca_certificate is not None:
            pulumi.set(__self__, "ssl_ca_certificate", ssl_ca_certificate)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> 'outputs.ConnectionGitlabEnterpriseConfigAuthorizerCredential':
        """
        Represents a personal access token that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> builtins.str:
        """
        Required. The URI of the GitLab Enterprise host this connection is for.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter(name="readAuthorizerCredential")
    def read_authorizer_credential(self) -> 'outputs.ConnectionGitlabEnterpriseConfigReadAuthorizerCredential':
        """
        Represents a personal access token that authorized the Connection,
        and associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "read_authorizer_credential")

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> builtins.str:
        """
        Required. Immutable. SecretManager resource containing the webhook secret of a GitLab project,
        formatted as `projects/*/secrets/*/versions/*`. This is used to validate
        webhooks.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Version of the GitLab Enterprise server running on the `host_uri`.
        """
        return pulumi.get(self, "server_version")

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional['outputs.ConnectionGitlabEnterpriseConfigServiceDirectoryConfig']:
        """
        ServiceDirectoryConfig represents Service Directory configuration for a
        connection.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @property
    @pulumi.getter(name="sslCaCertificate")
    def ssl_ca_certificate(self) -> Optional[builtins.str]:
        """
        Optional. SSL Certificate Authority certificate to use for requests to GitLab
        Enterprise instance.
        """
        return pulumi.get(self, "ssl_ca_certificate")


@pulumi.output_type
class ConnectionGitlabEnterpriseConfigAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userTokenSecretVersion":
            suggest = "user_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGitlabEnterpriseConfigAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGitlabEnterpriseConfigAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGitlabEnterpriseConfigAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes
               the Developer Connect connection. Format:
               `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the user token that authorizes
        the Developer Connect connection. Format:
        `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionGitlabEnterpriseConfigReadAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userTokenSecretVersion":
            suggest = "user_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGitlabEnterpriseConfigReadAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGitlabEnterpriseConfigReadAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGitlabEnterpriseConfigReadAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_token_secret_version: builtins.str,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes
               the Developer Connect connection. Format:
               `projects/*/secrets/*/versions/*`.
        :param builtins.str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> builtins.str:
        """
        Required. A SecretManager resource containing the user token that authorizes
        the Developer Connect connection. Format:
        `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionGitlabEnterpriseConfigServiceDirectoryConfig(dict):
    def __init__(__self__, *,
                 service: builtins.str):
        """
        :param builtins.str service: Required. The Service Directory service name.
               Format:
               projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        Required. The Service Directory service name.
        Format:
        projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ConnectionInstallationState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionUri":
            suggest = "action_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionInstallationState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionInstallationState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionInstallationState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_uri: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 stage: Optional[builtins.str] = None):
        """
        :param builtins.str action_uri: Output only. Link to follow for next action. Empty string if the installation is already
               complete.
        :param builtins.str message: Output only. Message of what the user should do next to continue the installation.
               Empty string if the installation is already complete.
        :param builtins.str stage: (Output)
               Output only. Current step of the installation process.
               Possible values:
               STAGE_UNSPECIFIED
               PENDING_CREATE_APP
               PENDING_USER_OAUTH
               PENDING_INSTALL_APP
               COMPLETE
        """
        if action_uri is not None:
            pulumi.set(__self__, "action_uri", action_uri)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="actionUri")
    def action_uri(self) -> Optional[builtins.str]:
        """
        Output only. Link to follow for next action. Empty string if the installation is already
        complete.
        """
        return pulumi.get(self, "action_uri")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Output only. Message of what the user should do next to continue the installation.
        Empty string if the installation is already complete.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def stage(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. Current step of the installation process.
        Possible values:
        STAGE_UNSPECIFIED
        PENDING_CREATE_APP
        PENDING_USER_OAUTH
        PENDING_INSTALL_APP
        COMPLETE
        """
        return pulumi.get(self, "stage")


