# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxGenerativeSettingsArgs', 'CxGenerativeSettings']

@pulumi.input_type
class CxGenerativeSettingsArgs:
    def __init__(__self__, *,
                 language_code: pulumi.Input[builtins.str],
                 fallback_settings: Optional[pulumi.Input['CxGenerativeSettingsFallbackSettingsArgs']] = None,
                 generative_safety_settings: Optional[pulumi.Input['CxGenerativeSettingsGenerativeSafetySettingsArgs']] = None,
                 knowledge_connector_settings: Optional[pulumi.Input['CxGenerativeSettingsKnowledgeConnectorSettingsArgs']] = None,
                 llm_model_settings: Optional[pulumi.Input['CxGenerativeSettingsLlmModelSettingsArgs']] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CxGenerativeSettings resource.
        :param pulumi.Input[builtins.str] language_code: Language for this settings.
        :param pulumi.Input['CxGenerativeSettingsFallbackSettingsArgs'] fallback_settings: Settings for Generative Fallback.
               Structure is documented below.
        :param pulumi.Input['CxGenerativeSettingsGenerativeSafetySettingsArgs'] generative_safety_settings: Settings for Generative Safety.
               w
               Structure is documented below.
        :param pulumi.Input['CxGenerativeSettingsKnowledgeConnectorSettingsArgs'] knowledge_connector_settings: Settings for knowledge connector.
               Structure is documented below.
        :param pulumi.Input['CxGenerativeSettingsLlmModelSettingsArgs'] llm_model_settings: LLM model settings.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The agent to create a flow for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        pulumi.set(__self__, "language_code", language_code)
        if fallback_settings is not None:
            pulumi.set(__self__, "fallback_settings", fallback_settings)
        if generative_safety_settings is not None:
            pulumi.set(__self__, "generative_safety_settings", generative_safety_settings)
        if knowledge_connector_settings is not None:
            pulumi.set(__self__, "knowledge_connector_settings", knowledge_connector_settings)
        if llm_model_settings is not None:
            pulumi.set(__self__, "llm_model_settings", llm_model_settings)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Input[builtins.str]:
        """
        Language for this settings.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="fallbackSettings")
    def fallback_settings(self) -> Optional[pulumi.Input['CxGenerativeSettingsFallbackSettingsArgs']]:
        """
        Settings for Generative Fallback.
        Structure is documented below.
        """
        return pulumi.get(self, "fallback_settings")

    @fallback_settings.setter
    def fallback_settings(self, value: Optional[pulumi.Input['CxGenerativeSettingsFallbackSettingsArgs']]):
        pulumi.set(self, "fallback_settings", value)

    @property
    @pulumi.getter(name="generativeSafetySettings")
    def generative_safety_settings(self) -> Optional[pulumi.Input['CxGenerativeSettingsGenerativeSafetySettingsArgs']]:
        """
        Settings for Generative Safety.
        w
        Structure is documented below.
        """
        return pulumi.get(self, "generative_safety_settings")

    @generative_safety_settings.setter
    def generative_safety_settings(self, value: Optional[pulumi.Input['CxGenerativeSettingsGenerativeSafetySettingsArgs']]):
        pulumi.set(self, "generative_safety_settings", value)

    @property
    @pulumi.getter(name="knowledgeConnectorSettings")
    def knowledge_connector_settings(self) -> Optional[pulumi.Input['CxGenerativeSettingsKnowledgeConnectorSettingsArgs']]:
        """
        Settings for knowledge connector.
        Structure is documented below.
        """
        return pulumi.get(self, "knowledge_connector_settings")

    @knowledge_connector_settings.setter
    def knowledge_connector_settings(self, value: Optional[pulumi.Input['CxGenerativeSettingsKnowledgeConnectorSettingsArgs']]):
        pulumi.set(self, "knowledge_connector_settings", value)

    @property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> Optional[pulumi.Input['CxGenerativeSettingsLlmModelSettingsArgs']]:
        """
        LLM model settings.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @llm_model_settings.setter
    def llm_model_settings(self, value: Optional[pulumi.Input['CxGenerativeSettingsLlmModelSettingsArgs']]):
        pulumi.set(self, "llm_model_settings", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The agent to create a flow for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)


@pulumi.input_type
class _CxGenerativeSettingsState:
    def __init__(__self__, *,
                 fallback_settings: Optional[pulumi.Input['CxGenerativeSettingsFallbackSettingsArgs']] = None,
                 generative_safety_settings: Optional[pulumi.Input['CxGenerativeSettingsGenerativeSafetySettingsArgs']] = None,
                 knowledge_connector_settings: Optional[pulumi.Input['CxGenerativeSettingsKnowledgeConnectorSettingsArgs']] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 llm_model_settings: Optional[pulumi.Input['CxGenerativeSettingsLlmModelSettingsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CxGenerativeSettings resources.
        :param pulumi.Input['CxGenerativeSettingsFallbackSettingsArgs'] fallback_settings: Settings for Generative Fallback.
               Structure is documented below.
        :param pulumi.Input['CxGenerativeSettingsGenerativeSafetySettingsArgs'] generative_safety_settings: Settings for Generative Safety.
               w
               Structure is documented below.
        :param pulumi.Input['CxGenerativeSettingsKnowledgeConnectorSettingsArgs'] knowledge_connector_settings: Settings for knowledge connector.
               Structure is documented below.
        :param pulumi.Input[builtins.str] language_code: Language for this settings.
        :param pulumi.Input['CxGenerativeSettingsLlmModelSettingsArgs'] llm_model_settings: LLM model settings.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The unique identifier of the generativeSettings.
               Format: projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings.
        :param pulumi.Input[builtins.str] parent: The agent to create a flow for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        if fallback_settings is not None:
            pulumi.set(__self__, "fallback_settings", fallback_settings)
        if generative_safety_settings is not None:
            pulumi.set(__self__, "generative_safety_settings", generative_safety_settings)
        if knowledge_connector_settings is not None:
            pulumi.set(__self__, "knowledge_connector_settings", knowledge_connector_settings)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if llm_model_settings is not None:
            pulumi.set(__self__, "llm_model_settings", llm_model_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter(name="fallbackSettings")
    def fallback_settings(self) -> Optional[pulumi.Input['CxGenerativeSettingsFallbackSettingsArgs']]:
        """
        Settings for Generative Fallback.
        Structure is documented below.
        """
        return pulumi.get(self, "fallback_settings")

    @fallback_settings.setter
    def fallback_settings(self, value: Optional[pulumi.Input['CxGenerativeSettingsFallbackSettingsArgs']]):
        pulumi.set(self, "fallback_settings", value)

    @property
    @pulumi.getter(name="generativeSafetySettings")
    def generative_safety_settings(self) -> Optional[pulumi.Input['CxGenerativeSettingsGenerativeSafetySettingsArgs']]:
        """
        Settings for Generative Safety.
        w
        Structure is documented below.
        """
        return pulumi.get(self, "generative_safety_settings")

    @generative_safety_settings.setter
    def generative_safety_settings(self, value: Optional[pulumi.Input['CxGenerativeSettingsGenerativeSafetySettingsArgs']]):
        pulumi.set(self, "generative_safety_settings", value)

    @property
    @pulumi.getter(name="knowledgeConnectorSettings")
    def knowledge_connector_settings(self) -> Optional[pulumi.Input['CxGenerativeSettingsKnowledgeConnectorSettingsArgs']]:
        """
        Settings for knowledge connector.
        Structure is documented below.
        """
        return pulumi.get(self, "knowledge_connector_settings")

    @knowledge_connector_settings.setter
    def knowledge_connector_settings(self, value: Optional[pulumi.Input['CxGenerativeSettingsKnowledgeConnectorSettingsArgs']]):
        pulumi.set(self, "knowledge_connector_settings", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Language for this settings.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> Optional[pulumi.Input['CxGenerativeSettingsLlmModelSettingsArgs']]:
        """
        LLM model settings.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @llm_model_settings.setter
    def llm_model_settings(self, value: Optional[pulumi.Input['CxGenerativeSettingsLlmModelSettingsArgs']]):
        pulumi.set(self, "llm_model_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the generativeSettings.
        Format: projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The agent to create a flow for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)


@pulumi.type_token("gcp:diagflow/cxGenerativeSettings:CxGenerativeSettings")
class CxGenerativeSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fallback_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsFallbackSettingsArgs', 'CxGenerativeSettingsFallbackSettingsArgsDict']]] = None,
                 generative_safety_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsGenerativeSafetySettingsArgs', 'CxGenerativeSettingsGenerativeSafetySettingsArgsDict']]] = None,
                 knowledge_connector_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsKnowledgeConnectorSettingsArgs', 'CxGenerativeSettingsKnowledgeConnectorSettingsArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 llm_model_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsLlmModelSettingsArgs', 'CxGenerativeSettingsLlmModelSettingsArgsDict']]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Settings for Generative AI.

        To get more information about GenerativeSettings, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents/getGenerativeSettings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Generative Settings Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        full_generative_settings = gcp.diagflow.CxGenerativeSettings("full_generative_settings",
            parent=agent.id,
            fallback_settings={
                "selected_prompt": "example prompt",
                "prompt_templates": [{
                    "display_name": "example prompt",
                    "prompt_text": "example prompt text",
                    "frozen": False,
                }],
            },
            generative_safety_settings={
                "default_banned_phrase_match_strategy": "PARTIAL_MATCH",
                "banned_phrases": [{
                    "text": "example text",
                    "language_code": "en",
                }],
            },
            knowledge_connector_settings={
                "business": "example business",
                "agent": "example agent",
                "agent_identity": "virtual agent",
                "business_description": "a family company selling freshly roasted coffee beans",
                "agent_scope": "Example company website",
                "disable_data_store_fallback": False,
            },
            language_code="en",
            llm_model_settings={
                "model": "gemini-2.0-flash-001",
                "prompt_text": "example prompt text",
            })
        ```

        ## Import

        GenerativeSettings can be imported using any of these accepted formats:

        * `{{parent}}/generativeSettings`

        * `{{parent}}`

        When using the `pulumi import` command, GenerativeSettings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxGenerativeSettings:CxGenerativeSettings default {{parent}}/generativeSettings
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxGenerativeSettings:CxGenerativeSettings default {{parent}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxGenerativeSettingsFallbackSettingsArgs', 'CxGenerativeSettingsFallbackSettingsArgsDict']] fallback_settings: Settings for Generative Fallback.
               Structure is documented below.
        :param pulumi.Input[Union['CxGenerativeSettingsGenerativeSafetySettingsArgs', 'CxGenerativeSettingsGenerativeSafetySettingsArgsDict']] generative_safety_settings: Settings for Generative Safety.
               w
               Structure is documented below.
        :param pulumi.Input[Union['CxGenerativeSettingsKnowledgeConnectorSettingsArgs', 'CxGenerativeSettingsKnowledgeConnectorSettingsArgsDict']] knowledge_connector_settings: Settings for knowledge connector.
               Structure is documented below.
        :param pulumi.Input[builtins.str] language_code: Language for this settings.
        :param pulumi.Input[Union['CxGenerativeSettingsLlmModelSettingsArgs', 'CxGenerativeSettingsLlmModelSettingsArgsDict']] llm_model_settings: LLM model settings.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The agent to create a flow for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxGenerativeSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Settings for Generative AI.

        To get more information about GenerativeSettings, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents/getGenerativeSettings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Generative Settings Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        full_generative_settings = gcp.diagflow.CxGenerativeSettings("full_generative_settings",
            parent=agent.id,
            fallback_settings={
                "selected_prompt": "example prompt",
                "prompt_templates": [{
                    "display_name": "example prompt",
                    "prompt_text": "example prompt text",
                    "frozen": False,
                }],
            },
            generative_safety_settings={
                "default_banned_phrase_match_strategy": "PARTIAL_MATCH",
                "banned_phrases": [{
                    "text": "example text",
                    "language_code": "en",
                }],
            },
            knowledge_connector_settings={
                "business": "example business",
                "agent": "example agent",
                "agent_identity": "virtual agent",
                "business_description": "a family company selling freshly roasted coffee beans",
                "agent_scope": "Example company website",
                "disable_data_store_fallback": False,
            },
            language_code="en",
            llm_model_settings={
                "model": "gemini-2.0-flash-001",
                "prompt_text": "example prompt text",
            })
        ```

        ## Import

        GenerativeSettings can be imported using any of these accepted formats:

        * `{{parent}}/generativeSettings`

        * `{{parent}}`

        When using the `pulumi import` command, GenerativeSettings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxGenerativeSettings:CxGenerativeSettings default {{parent}}/generativeSettings
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxGenerativeSettings:CxGenerativeSettings default {{parent}}
        ```

        :param str resource_name: The name of the resource.
        :param CxGenerativeSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxGenerativeSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fallback_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsFallbackSettingsArgs', 'CxGenerativeSettingsFallbackSettingsArgsDict']]] = None,
                 generative_safety_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsGenerativeSafetySettingsArgs', 'CxGenerativeSettingsGenerativeSafetySettingsArgsDict']]] = None,
                 knowledge_connector_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsKnowledgeConnectorSettingsArgs', 'CxGenerativeSettingsKnowledgeConnectorSettingsArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 llm_model_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsLlmModelSettingsArgs', 'CxGenerativeSettingsLlmModelSettingsArgsDict']]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxGenerativeSettingsArgs.__new__(CxGenerativeSettingsArgs)

            __props__.__dict__["fallback_settings"] = fallback_settings
            __props__.__dict__["generative_safety_settings"] = generative_safety_settings
            __props__.__dict__["knowledge_connector_settings"] = knowledge_connector_settings
            if language_code is None and not opts.urn:
                raise TypeError("Missing required property 'language_code'")
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["llm_model_settings"] = llm_model_settings
            __props__.__dict__["parent"] = parent
            __props__.__dict__["name"] = None
        super(CxGenerativeSettings, __self__).__init__(
            'gcp:diagflow/cxGenerativeSettings:CxGenerativeSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fallback_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsFallbackSettingsArgs', 'CxGenerativeSettingsFallbackSettingsArgsDict']]] = None,
            generative_safety_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsGenerativeSafetySettingsArgs', 'CxGenerativeSettingsGenerativeSafetySettingsArgsDict']]] = None,
            knowledge_connector_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsKnowledgeConnectorSettingsArgs', 'CxGenerativeSettingsKnowledgeConnectorSettingsArgsDict']]] = None,
            language_code: Optional[pulumi.Input[builtins.str]] = None,
            llm_model_settings: Optional[pulumi.Input[Union['CxGenerativeSettingsLlmModelSettingsArgs', 'CxGenerativeSettingsLlmModelSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None) -> 'CxGenerativeSettings':
        """
        Get an existing CxGenerativeSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxGenerativeSettingsFallbackSettingsArgs', 'CxGenerativeSettingsFallbackSettingsArgsDict']] fallback_settings: Settings for Generative Fallback.
               Structure is documented below.
        :param pulumi.Input[Union['CxGenerativeSettingsGenerativeSafetySettingsArgs', 'CxGenerativeSettingsGenerativeSafetySettingsArgsDict']] generative_safety_settings: Settings for Generative Safety.
               w
               Structure is documented below.
        :param pulumi.Input[Union['CxGenerativeSettingsKnowledgeConnectorSettingsArgs', 'CxGenerativeSettingsKnowledgeConnectorSettingsArgsDict']] knowledge_connector_settings: Settings for knowledge connector.
               Structure is documented below.
        :param pulumi.Input[builtins.str] language_code: Language for this settings.
        :param pulumi.Input[Union['CxGenerativeSettingsLlmModelSettingsArgs', 'CxGenerativeSettingsLlmModelSettingsArgsDict']] llm_model_settings: LLM model settings.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The unique identifier of the generativeSettings.
               Format: projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings.
        :param pulumi.Input[builtins.str] parent: The agent to create a flow for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxGenerativeSettingsState.__new__(_CxGenerativeSettingsState)

        __props__.__dict__["fallback_settings"] = fallback_settings
        __props__.__dict__["generative_safety_settings"] = generative_safety_settings
        __props__.__dict__["knowledge_connector_settings"] = knowledge_connector_settings
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["llm_model_settings"] = llm_model_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        return CxGenerativeSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fallbackSettings")
    def fallback_settings(self) -> pulumi.Output[Optional['outputs.CxGenerativeSettingsFallbackSettings']]:
        """
        Settings for Generative Fallback.
        Structure is documented below.
        """
        return pulumi.get(self, "fallback_settings")

    @property
    @pulumi.getter(name="generativeSafetySettings")
    def generative_safety_settings(self) -> pulumi.Output[Optional['outputs.CxGenerativeSettingsGenerativeSafetySettings']]:
        """
        Settings for Generative Safety.
        w
        Structure is documented below.
        """
        return pulumi.get(self, "generative_safety_settings")

    @property
    @pulumi.getter(name="knowledgeConnectorSettings")
    def knowledge_connector_settings(self) -> pulumi.Output[Optional['outputs.CxGenerativeSettingsKnowledgeConnectorSettings']]:
        """
        Settings for knowledge connector.
        Structure is documented below.
        """
        return pulumi.get(self, "knowledge_connector_settings")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[builtins.str]:
        """
        Language for this settings.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> pulumi.Output[Optional['outputs.CxGenerativeSettingsLlmModelSettings']]:
        """
        LLM model settings.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the generativeSettings.
        Format: projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The agent to create a flow for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

