# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxVersionArgs', 'CxVersion']

@pulumi.input_type
class CxVersionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CxVersion resource.
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the version. Limit of 64 characters.
        :param pulumi.Input[builtins.str] description: The description of the version. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[builtins.str] parent: The Flow to create an Version for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        pulumi.set(__self__, "display_name", display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The human-readable name of the version. Limit of 64 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the version. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Flow to create an Version for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)


@pulumi.input_type
class _CxVersionState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nlu_settings: Optional[pulumi.Input[Sequence[pulumi.Input['CxVersionNluSettingArgs']]]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CxVersion resources.
        :param pulumi.Input[builtins.str] create_time: A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] description: The description of the version. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the version. Limit of 64 characters.
        :param pulumi.Input[builtins.str] name: Format: projects//locations//agents//flows//versions/. Version ID is a self-increasing number generated by Dialogflow upon version creation.
        :param pulumi.Input[Sequence[pulumi.Input['CxVersionNluSettingArgs']]] nlu_settings: The NLU settings of the flow at version creation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The Flow to create an Version for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[builtins.str] state: The state of this version.
               * RUNNING: Version is not ready to serve (e.g. training is running).
               * SUCCEEDED: Training has succeeded and this version is ready to serve.
               * FAILED: Version training failed.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nlu_settings is not None:
            pulumi.set(__self__, "nlu_settings", nlu_settings)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the version. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The human-readable name of the version. Limit of 64 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Format: projects//locations//agents//flows//versions/. Version ID is a self-increasing number generated by Dialogflow upon version creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nluSettings")
    def nlu_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxVersionNluSettingArgs']]]]:
        """
        The NLU settings of the flow at version creation.
        Structure is documented below.
        """
        return pulumi.get(self, "nlu_settings")

    @nlu_settings.setter
    def nlu_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxVersionNluSettingArgs']]]]):
        pulumi.set(self, "nlu_settings", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Flow to create an Version for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of this version.
        * RUNNING: Version is not ready to serve (e.g. training is running).
        * SUCCEEDED: Training has succeeded and this version is ready to serve.
        * FAILED: Version training failed.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:diagflow/cxVersion:CxVersion")
class CxVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        You can create multiple versions of your agent flows and deploy them to separate serving environments.
        When you edit a flow, you are editing a draft flow. At any point, you can save a draft flow as a flow version. A flow version is an immutable snapshot of your flow data and associated agent data like intents, entities, webhooks, pages, route groups, etc.

        To get more information about Version, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.flows.versions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Version Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        version1 = gcp.diagflow.CxVersion("version_1",
            parent=agent.start_flow,
            display_name="1.0.0",
            description="version 1.0.0")
        ```

        ## Import

        Version can be imported using any of these accepted formats:

        * `{{parent}}/versions/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Version can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxVersion:CxVersion default {{parent}}/versions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxVersion:CxVersion default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the version. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the version. Limit of 64 characters.
        :param pulumi.Input[builtins.str] parent: The Flow to create an Version for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        You can create multiple versions of your agent flows and deploy them to separate serving environments.
        When you edit a flow, you are editing a draft flow. At any point, you can save a draft flow as a flow version. A flow version is an immutable snapshot of your flow data and associated agent data like intents, entities, webhooks, pages, route groups, etc.

        To get more information about Version, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.flows.versions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Version Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        version1 = gcp.diagflow.CxVersion("version_1",
            parent=agent.start_flow,
            display_name="1.0.0",
            description="version 1.0.0")
        ```

        ## Import

        Version can be imported using any of these accepted formats:

        * `{{parent}}/versions/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Version can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxVersion:CxVersion default {{parent}}/versions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxVersion:CxVersion default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxVersionArgs.__new__(CxVersionArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["parent"] = parent
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["nlu_settings"] = None
            __props__.__dict__["state"] = None
        super(CxVersion, __self__).__init__(
            'gcp:diagflow/cxVersion:CxVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nlu_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxVersionNluSettingArgs', 'CxVersionNluSettingArgsDict']]]]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'CxVersion':
        """
        Get an existing CxVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] description: The description of the version. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the version. Limit of 64 characters.
        :param pulumi.Input[builtins.str] name: Format: projects//locations//agents//flows//versions/. Version ID is a self-increasing number generated by Dialogflow upon version creation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxVersionNluSettingArgs', 'CxVersionNluSettingArgsDict']]]] nlu_settings: The NLU settings of the flow at version creation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The Flow to create an Version for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[builtins.str] state: The state of this version.
               * RUNNING: Version is not ready to serve (e.g. training is running).
               * SUCCEEDED: Training has succeeded and this version is ready to serve.
               * FAILED: Version training failed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxVersionState.__new__(_CxVersionState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["nlu_settings"] = nlu_settings
        __props__.__dict__["parent"] = parent
        __props__.__dict__["state"] = state
        return CxVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the version. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The human-readable name of the version. Limit of 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Format: projects//locations//agents//flows//versions/. Version ID is a self-increasing number generated by Dialogflow upon version creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nluSettings")
    def nlu_settings(self) -> pulumi.Output[Sequence['outputs.CxVersionNluSetting']]:
        """
        The NLU settings of the flow at version creation.
        Structure is documented below.
        """
        return pulumi.get(self, "nlu_settings")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Flow to create an Version for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of this version.
        * RUNNING: Version is not ready to serve (e.g. training is running).
        * SUCCEEDED: Training has succeeded and this version is ready to serve.
        * FAILED: Version training failed.
        """
        return pulumi.get(self, "state")

