# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EncryptionSpecArgs', 'EncryptionSpec']

@pulumi.input_type
class EncryptionSpecArgs:
    def __init__(__self__, *,
                 encryption_spec: pulumi.Input['EncryptionSpecEncryptionSpecArgs'],
                 location: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EncryptionSpec resource.
        :param pulumi.Input['EncryptionSpecEncryptionSpecArgs'] encryption_spec: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location in which the encryptionSpec is to be initialized.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "encryption_spec", encryption_spec)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> pulumi.Input['EncryptionSpecEncryptionSpecArgs']:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @encryption_spec.setter
    def encryption_spec(self, value: pulumi.Input['EncryptionSpecEncryptionSpecArgs']):
        pulumi.set(self, "encryption_spec", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location in which the encryptionSpec is to be initialized.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _EncryptionSpecState:
    def __init__(__self__, *,
                 encryption_spec: Optional[pulumi.Input['EncryptionSpecEncryptionSpecArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EncryptionSpec resources.
        :param pulumi.Input['EncryptionSpecEncryptionSpecArgs'] encryption_spec: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location in which the encryptionSpec is to be initialized.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if encryption_spec is not None:
            pulumi.set(__self__, "encryption_spec", encryption_spec)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> Optional[pulumi.Input['EncryptionSpecEncryptionSpecArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @encryption_spec.setter
    def encryption_spec(self, value: Optional[pulumi.Input['EncryptionSpecEncryptionSpecArgs']]):
        pulumi.set(self, "encryption_spec", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location in which the encryptionSpec is to be initialized.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:diagflow/encryptionSpec:EncryptionSpec")
class EncryptionSpec(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_spec: Optional[pulumi.Input[Union['EncryptionSpecEncryptionSpecArgs', 'EncryptionSpecEncryptionSpecArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Initializes a location-level encryption key specification.

        To get more information about EncryptionSpec, see:

        * [API documentation](https://cloud.google.com/dialogflow/es/docs/reference/rest/v2/projects.locations.encryptionSpec)
        * How-to Guides
            * [Official CX Documentation](https://cloud.google.com/dialogflow/cx/docs)
            * [Official ES Documentation](https://cloud.google.com/dialogflow/es/docs)

        ## Example Usage

        ### Dialogflow Encryption Spec Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="my-proj",
            name="my-proj",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        cloudkms = gcp.projects.Service("cloudkms",
            project=project.project_id,
            service="cloudkms.googleapis.com")
        dialogflow = gcp.projects.Service("dialogflow",
            project=project.project_id,
            service="dialogflow.googleapis.com")
        wait_enable_service_api = time.index.Sleep("wait_enable_service_api", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[
                cloudkms,
                dialogflow,
            ]))
        gcp_sa = gcp.projects.ServiceIdentity("gcp_sa",
            service="dialogflow.googleapis.com",
            project=project.project_id,
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        wait_create_sa = time.index.Sleep("wait_create_sa", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[gcp_sa]))
        keyring = gcp.kms.KeyRing("keyring",
            name="my-keyring",
            location="us-central1",
            project=project.project_id,
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        key = gcp.kms.CryptoKey("key",
            name="my-key",
            key_ring=keyring.id,
            purpose="ENCRYPT_DECRYPT")
        crypto_key = gcp.kms.CryptoKeyIAMMember("crypto_key",
            crypto_key_id=key.id,
            member=std.replace_output(text=gcp_sa.member,
                search="@gcp-sa-dialogflow.iam",
                replace="@gcp-sa-ccai-cmek.iam").apply(lambda invoke: invoke.result),
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            opts = pulumi.ResourceOptions(depends_on=[wait_create_sa]))
        my_encryption_spec = gcp.diagflow.EncryptionSpec("my-encryption-spec",
            project=project.project_id,
            location="us-central1",
            encryption_spec={
                "kms_key": key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key]))
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EncryptionSpecEncryptionSpecArgs', 'EncryptionSpecEncryptionSpecArgsDict']] encryption_spec: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location in which the encryptionSpec is to be initialized.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EncryptionSpecArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Initializes a location-level encryption key specification.

        To get more information about EncryptionSpec, see:

        * [API documentation](https://cloud.google.com/dialogflow/es/docs/reference/rest/v2/projects.locations.encryptionSpec)
        * How-to Guides
            * [Official CX Documentation](https://cloud.google.com/dialogflow/cx/docs)
            * [Official ES Documentation](https://cloud.google.com/dialogflow/es/docs)

        ## Example Usage

        ### Dialogflow Encryption Spec Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="my-proj",
            name="my-proj",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        cloudkms = gcp.projects.Service("cloudkms",
            project=project.project_id,
            service="cloudkms.googleapis.com")
        dialogflow = gcp.projects.Service("dialogflow",
            project=project.project_id,
            service="dialogflow.googleapis.com")
        wait_enable_service_api = time.index.Sleep("wait_enable_service_api", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[
                cloudkms,
                dialogflow,
            ]))
        gcp_sa = gcp.projects.ServiceIdentity("gcp_sa",
            service="dialogflow.googleapis.com",
            project=project.project_id,
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        wait_create_sa = time.index.Sleep("wait_create_sa", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[gcp_sa]))
        keyring = gcp.kms.KeyRing("keyring",
            name="my-keyring",
            location="us-central1",
            project=project.project_id,
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        key = gcp.kms.CryptoKey("key",
            name="my-key",
            key_ring=keyring.id,
            purpose="ENCRYPT_DECRYPT")
        crypto_key = gcp.kms.CryptoKeyIAMMember("crypto_key",
            crypto_key_id=key.id,
            member=std.replace_output(text=gcp_sa.member,
                search="@gcp-sa-dialogflow.iam",
                replace="@gcp-sa-ccai-cmek.iam").apply(lambda invoke: invoke.result),
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            opts = pulumi.ResourceOptions(depends_on=[wait_create_sa]))
        my_encryption_spec = gcp.diagflow.EncryptionSpec("my-encryption-spec",
            project=project.project_id,
            location="us-central1",
            encryption_spec={
                "kms_key": key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key]))
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param EncryptionSpecArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EncryptionSpecArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_spec: Optional[pulumi.Input[Union['EncryptionSpecEncryptionSpecArgs', 'EncryptionSpecEncryptionSpecArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EncryptionSpecArgs.__new__(EncryptionSpecArgs)

            if encryption_spec is None and not opts.urn:
                raise TypeError("Missing required property 'encryption_spec'")
            __props__.__dict__["encryption_spec"] = encryption_spec
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
        super(EncryptionSpec, __self__).__init__(
            'gcp:diagflow/encryptionSpec:EncryptionSpec',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            encryption_spec: Optional[pulumi.Input[Union['EncryptionSpecEncryptionSpecArgs', 'EncryptionSpecEncryptionSpecArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None) -> 'EncryptionSpec':
        """
        Get an existing EncryptionSpec resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EncryptionSpecEncryptionSpecArgs', 'EncryptionSpecEncryptionSpecArgsDict']] encryption_spec: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location in which the encryptionSpec is to be initialized.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EncryptionSpecState.__new__(_EncryptionSpecState)

        __props__.__dict__["encryption_spec"] = encryption_spec
        __props__.__dict__["location"] = location
        __props__.__dict__["project"] = project
        return EncryptionSpec(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> pulumi.Output['outputs.EncryptionSpecEncryptionSpec']:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location in which the encryptionSpec is to be initialized.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

