# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ChatEngineChatEngineConfig',
    'ChatEngineChatEngineConfigAgentCreationConfig',
    'ChatEngineChatEngineMetadata',
    'ChatEngineCommonConfig',
    'DataStoreAdvancedSiteSearchConfig',
    'DataStoreDocumentProcessingConfig',
    'DataStoreDocumentProcessingConfigChunkingConfig',
    'DataStoreDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig',
    'DataStoreDocumentProcessingConfigDefaultParsingConfig',
    'DataStoreDocumentProcessingConfigDefaultParsingConfigDigitalParsingConfig',
    'DataStoreDocumentProcessingConfigDefaultParsingConfigLayoutParsingConfig',
    'DataStoreDocumentProcessingConfigDefaultParsingConfigOcrParsingConfig',
    'DataStoreDocumentProcessingConfigParsingConfigOverride',
    'DataStoreDocumentProcessingConfigParsingConfigOverrideDigitalParsingConfig',
    'DataStoreDocumentProcessingConfigParsingConfigOverrideLayoutParsingConfig',
    'DataStoreDocumentProcessingConfigParsingConfigOverrideOcrParsingConfig',
    'SearchEngineCommonConfig',
    'SearchEngineSearchEngineConfig',
    'TargetSiteFailureReason',
    'TargetSiteFailureReasonQuotaFailure',
    'TargetSiteSiteVerificationInfo',
]

@pulumi.output_type
class ChatEngineChatEngineConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentCreationConfig":
            suggest = "agent_creation_config"
        elif key == "allowCrossRegion":
            suggest = "allow_cross_region"
        elif key == "dialogflowAgentToLink":
            suggest = "dialogflow_agent_to_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChatEngineChatEngineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChatEngineChatEngineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChatEngineChatEngineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_creation_config: Optional['outputs.ChatEngineChatEngineConfigAgentCreationConfig'] = None,
                 allow_cross_region: Optional[builtins.bool] = None,
                 dialogflow_agent_to_link: Optional[builtins.str] = None):
        """
        :param 'ChatEngineChatEngineConfigAgentCreationConfigArgs' agent_creation_config: The configuration to generate the Dialogflow agent that is associated to this Engine.
               Exactly one of `agent_creation_config` or `dialogflow_agent_to_link` must be set.
               Structure is documented below.
        :param builtins.bool allow_cross_region: If the flag set to true, we allow the agent and engine are in
               different locations, otherwise the agent and engine are required to be
               in the same location. The flag is set to false by default.
               Note that the `allow_cross_region` are one-time consumed by and passed
               to EngineService.CreateEngine. It means they cannot be retrieved using
               EngineService.GetEngine or EngineService.ListEngines API after engine
               creation.
        :param builtins.str dialogflow_agent_to_link: The resource name of an existing Dialogflow agent to link to this Chat Engine. Format: `projects/<Project_ID>/locations/<Location_ID>/agents/<Agent_ID>`.
               Exactly one of `agent_creation_config` or `dialogflow_agent_to_link` must be set.
        """
        if agent_creation_config is not None:
            pulumi.set(__self__, "agent_creation_config", agent_creation_config)
        if allow_cross_region is not None:
            pulumi.set(__self__, "allow_cross_region", allow_cross_region)
        if dialogflow_agent_to_link is not None:
            pulumi.set(__self__, "dialogflow_agent_to_link", dialogflow_agent_to_link)

    @property
    @pulumi.getter(name="agentCreationConfig")
    def agent_creation_config(self) -> Optional['outputs.ChatEngineChatEngineConfigAgentCreationConfig']:
        """
        The configuration to generate the Dialogflow agent that is associated to this Engine.
        Exactly one of `agent_creation_config` or `dialogflow_agent_to_link` must be set.
        Structure is documented below.
        """
        return pulumi.get(self, "agent_creation_config")

    @property
    @pulumi.getter(name="allowCrossRegion")
    def allow_cross_region(self) -> Optional[builtins.bool]:
        """
        If the flag set to true, we allow the agent and engine are in
        different locations, otherwise the agent and engine are required to be
        in the same location. The flag is set to false by default.
        Note that the `allow_cross_region` are one-time consumed by and passed
        to EngineService.CreateEngine. It means they cannot be retrieved using
        EngineService.GetEngine or EngineService.ListEngines API after engine
        creation.
        """
        return pulumi.get(self, "allow_cross_region")

    @property
    @pulumi.getter(name="dialogflowAgentToLink")
    def dialogflow_agent_to_link(self) -> Optional[builtins.str]:
        """
        The resource name of an existing Dialogflow agent to link to this Chat Engine. Format: `projects/<Project_ID>/locations/<Location_ID>/agents/<Agent_ID>`.
        Exactly one of `agent_creation_config` or `dialogflow_agent_to_link` must be set.
        """
        return pulumi.get(self, "dialogflow_agent_to_link")


@pulumi.output_type
class ChatEngineChatEngineConfigAgentCreationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultLanguageCode":
            suggest = "default_language_code"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChatEngineChatEngineConfigAgentCreationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChatEngineChatEngineConfigAgentCreationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChatEngineChatEngineConfigAgentCreationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_language_code: builtins.str,
                 time_zone: builtins.str,
                 business: Optional[builtins.str] = None,
                 location: Optional[builtins.str] = None):
        """
        :param builtins.str default_language_code: The default language of the agent as a language tag. See [Language Support](https://cloud.google.com/dialogflow/docs/reference/language) for a list of the currently supported language codes.
        :param builtins.str time_zone: The time zone of the agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
        :param builtins.str business: Name of the company, organization or other entity that the agent represents. Used for knowledge connector LLM prompt and for knowledge search.
        :param builtins.str location: Agent location for Agent creation, currently supported values: global/us/eu, it needs to be the same region as the Chat Engine.
        """
        pulumi.set(__self__, "default_language_code", default_language_code)
        pulumi.set(__self__, "time_zone", time_zone)
        if business is not None:
            pulumi.set(__self__, "business", business)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> builtins.str:
        """
        The default language of the agent as a language tag. See [Language Support](https://cloud.google.com/dialogflow/docs/reference/language) for a list of the currently supported language codes.
        """
        return pulumi.get(self, "default_language_code")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time zone of the agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def business(self) -> Optional[builtins.str]:
        """
        Name of the company, organization or other entity that the agent represents. Used for knowledge connector LLM prompt and for knowledge search.
        """
        return pulumi.get(self, "business")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        Agent location for Agent creation, currently supported values: global/us/eu, it needs to be the same region as the Chat Engine.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class ChatEngineChatEngineMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dialogflowAgent":
            suggest = "dialogflow_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChatEngineChatEngineMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChatEngineChatEngineMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChatEngineChatEngineMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dialogflow_agent: Optional[builtins.str] = None):
        """
        :param builtins.str dialogflow_agent: (Output)
               The resource name of a Dialogflow agent, that this Chat Engine refers to.
        """
        if dialogflow_agent is not None:
            pulumi.set(__self__, "dialogflow_agent", dialogflow_agent)

    @property
    @pulumi.getter(name="dialogflowAgent")
    def dialogflow_agent(self) -> Optional[builtins.str]:
        """
        (Output)
        The resource name of a Dialogflow agent, that this Chat Engine refers to.
        """
        return pulumi.get(self, "dialogflow_agent")


@pulumi.output_type
class ChatEngineCommonConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "companyName":
            suggest = "company_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChatEngineCommonConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChatEngineCommonConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChatEngineCommonConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 company_name: Optional[builtins.str] = None):
        """
        :param builtins.str company_name: The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.
        """
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[builtins.str]:
        """
        The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.
        """
        return pulumi.get(self, "company_name")


@pulumi.output_type
class DataStoreAdvancedSiteSearchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAutomaticRefresh":
            suggest = "disable_automatic_refresh"
        elif key == "disableInitialIndex":
            suggest = "disable_initial_index"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreAdvancedSiteSearchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreAdvancedSiteSearchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreAdvancedSiteSearchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_automatic_refresh: Optional[builtins.bool] = None,
                 disable_initial_index: Optional[builtins.bool] = None):
        """
        :param builtins.bool disable_automatic_refresh: If set true, automatic refresh is disabled for the DataStore.
        :param builtins.bool disable_initial_index: If set true, initial indexing is disabled for the DataStore.
        """
        if disable_automatic_refresh is not None:
            pulumi.set(__self__, "disable_automatic_refresh", disable_automatic_refresh)
        if disable_initial_index is not None:
            pulumi.set(__self__, "disable_initial_index", disable_initial_index)

    @property
    @pulumi.getter(name="disableAutomaticRefresh")
    def disable_automatic_refresh(self) -> Optional[builtins.bool]:
        """
        If set true, automatic refresh is disabled for the DataStore.
        """
        return pulumi.get(self, "disable_automatic_refresh")

    @property
    @pulumi.getter(name="disableInitialIndex")
    def disable_initial_index(self) -> Optional[builtins.bool]:
        """
        If set true, initial indexing is disabled for the DataStore.
        """
        return pulumi.get(self, "disable_initial_index")


@pulumi.output_type
class DataStoreDocumentProcessingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkingConfig":
            suggest = "chunking_config"
        elif key == "defaultParsingConfig":
            suggest = "default_parsing_config"
        elif key == "parsingConfigOverrides":
            suggest = "parsing_config_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chunking_config: Optional['outputs.DataStoreDocumentProcessingConfigChunkingConfig'] = None,
                 default_parsing_config: Optional['outputs.DataStoreDocumentProcessingConfigDefaultParsingConfig'] = None,
                 name: Optional[builtins.str] = None,
                 parsing_config_overrides: Optional[Sequence['outputs.DataStoreDocumentProcessingConfigParsingConfigOverride']] = None):
        """
        :param 'DataStoreDocumentProcessingConfigChunkingConfigArgs' chunking_config: Whether chunking mode is enabled.
               Structure is documented below.
        :param 'DataStoreDocumentProcessingConfigDefaultParsingConfigArgs' default_parsing_config: Configurations for default Document parser. If not specified, this resource
               will be configured to use a default DigitalParsingConfig, and the default parsing
               config will be applied to all file types for Document parsing.
               Structure is documented below.
        :param builtins.str name: (Output)
               The full resource name of the Document Processing Config. Format:
               `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/documentProcessingConfig`.
        :param Sequence['DataStoreDocumentProcessingConfigParsingConfigOverrideArgs'] parsing_config_overrides: Map from file type to override the default parsing configuration based on the file type. Supported keys:
        """
        if chunking_config is not None:
            pulumi.set(__self__, "chunking_config", chunking_config)
        if default_parsing_config is not None:
            pulumi.set(__self__, "default_parsing_config", default_parsing_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parsing_config_overrides is not None:
            pulumi.set(__self__, "parsing_config_overrides", parsing_config_overrides)

    @property
    @pulumi.getter(name="chunkingConfig")
    def chunking_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigChunkingConfig']:
        """
        Whether chunking mode is enabled.
        Structure is documented below.
        """
        return pulumi.get(self, "chunking_config")

    @property
    @pulumi.getter(name="defaultParsingConfig")
    def default_parsing_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigDefaultParsingConfig']:
        """
        Configurations for default Document parser. If not specified, this resource
        will be configured to use a default DigitalParsingConfig, and the default parsing
        config will be applied to all file types for Document parsing.
        Structure is documented below.
        """
        return pulumi.get(self, "default_parsing_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Output)
        The full resource name of the Document Processing Config. Format:
        `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/documentProcessingConfig`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parsingConfigOverrides")
    def parsing_config_overrides(self) -> Optional[Sequence['outputs.DataStoreDocumentProcessingConfigParsingConfigOverride']]:
        """
        Map from file type to override the default parsing configuration based on the file type. Supported keys:
        """
        return pulumi.get(self, "parsing_config_overrides")


@pulumi.output_type
class DataStoreDocumentProcessingConfigChunkingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "layoutBasedChunkingConfig":
            suggest = "layout_based_chunking_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfigChunkingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfigChunkingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfigChunkingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 layout_based_chunking_config: Optional['outputs.DataStoreDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig'] = None):
        """
        :param 'DataStoreDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfigArgs' layout_based_chunking_config: Configuration for the layout based chunking.
               Structure is documented below.
        """
        if layout_based_chunking_config is not None:
            pulumi.set(__self__, "layout_based_chunking_config", layout_based_chunking_config)

    @property
    @pulumi.getter(name="layoutBasedChunkingConfig")
    def layout_based_chunking_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig']:
        """
        Configuration for the layout based chunking.
        Structure is documented below.
        """
        return pulumi.get(self, "layout_based_chunking_config")


@pulumi.output_type
class DataStoreDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkSize":
            suggest = "chunk_size"
        elif key == "includeAncestorHeadings":
            suggest = "include_ancestor_headings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chunk_size: Optional[builtins.int] = None,
                 include_ancestor_headings: Optional[builtins.bool] = None):
        """
        :param builtins.int chunk_size: The token size limit for each chunk.
               Supported values: 100-500 (inclusive). Default value: 500.
        :param builtins.bool include_ancestor_headings: Whether to include appending different levels of headings to chunks from the middle of the document to prevent context loss.
               Default value: False.
        """
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if include_ancestor_headings is not None:
            pulumi.set(__self__, "include_ancestor_headings", include_ancestor_headings)

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[builtins.int]:
        """
        The token size limit for each chunk.
        Supported values: 100-500 (inclusive). Default value: 500.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter(name="includeAncestorHeadings")
    def include_ancestor_headings(self) -> Optional[builtins.bool]:
        """
        Whether to include appending different levels of headings to chunks from the middle of the document to prevent context loss.
        Default value: False.
        """
        return pulumi.get(self, "include_ancestor_headings")


@pulumi.output_type
class DataStoreDocumentProcessingConfigDefaultParsingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "digitalParsingConfig":
            suggest = "digital_parsing_config"
        elif key == "layoutParsingConfig":
            suggest = "layout_parsing_config"
        elif key == "ocrParsingConfig":
            suggest = "ocr_parsing_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfigDefaultParsingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfigDefaultParsingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfigDefaultParsingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 digital_parsing_config: Optional['outputs.DataStoreDocumentProcessingConfigDefaultParsingConfigDigitalParsingConfig'] = None,
                 layout_parsing_config: Optional['outputs.DataStoreDocumentProcessingConfigDefaultParsingConfigLayoutParsingConfig'] = None,
                 ocr_parsing_config: Optional['outputs.DataStoreDocumentProcessingConfigDefaultParsingConfigOcrParsingConfig'] = None):
        """
        :param 'DataStoreDocumentProcessingConfigDefaultParsingConfigDigitalParsingConfigArgs' digital_parsing_config: Configurations applied to digital parser.
        :param 'DataStoreDocumentProcessingConfigDefaultParsingConfigLayoutParsingConfigArgs' layout_parsing_config: Configurations applied to layout parser.
               Structure is documented below.
        :param 'DataStoreDocumentProcessingConfigDefaultParsingConfigOcrParsingConfigArgs' ocr_parsing_config: Configurations applied to OCR parser. Currently it only applies to PDFs.
               Structure is documented below.
        """
        if digital_parsing_config is not None:
            pulumi.set(__self__, "digital_parsing_config", digital_parsing_config)
        if layout_parsing_config is not None:
            pulumi.set(__self__, "layout_parsing_config", layout_parsing_config)
        if ocr_parsing_config is not None:
            pulumi.set(__self__, "ocr_parsing_config", ocr_parsing_config)

    @property
    @pulumi.getter(name="digitalParsingConfig")
    def digital_parsing_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigDefaultParsingConfigDigitalParsingConfig']:
        """
        Configurations applied to digital parser.
        """
        return pulumi.get(self, "digital_parsing_config")

    @property
    @pulumi.getter(name="layoutParsingConfig")
    def layout_parsing_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigDefaultParsingConfigLayoutParsingConfig']:
        """
        Configurations applied to layout parser.
        Structure is documented below.
        """
        return pulumi.get(self, "layout_parsing_config")

    @property
    @pulumi.getter(name="ocrParsingConfig")
    def ocr_parsing_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigDefaultParsingConfigOcrParsingConfig']:
        """
        Configurations applied to OCR parser. Currently it only applies to PDFs.
        Structure is documented below.
        """
        return pulumi.get(self, "ocr_parsing_config")


@pulumi.output_type
class DataStoreDocumentProcessingConfigDefaultParsingConfigDigitalParsingConfig(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DataStoreDocumentProcessingConfigDefaultParsingConfigLayoutParsingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableImageAnnotation":
            suggest = "enable_image_annotation"
        elif key == "enableTableAnnotation":
            suggest = "enable_table_annotation"
        elif key == "excludeHtmlClasses":
            suggest = "exclude_html_classes"
        elif key == "excludeHtmlElements":
            suggest = "exclude_html_elements"
        elif key == "excludeHtmlIds":
            suggest = "exclude_html_ids"
        elif key == "structuredContentTypes":
            suggest = "structured_content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfigDefaultParsingConfigLayoutParsingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfigDefaultParsingConfigLayoutParsingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfigDefaultParsingConfigLayoutParsingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_image_annotation: Optional[builtins.bool] = None,
                 enable_table_annotation: Optional[builtins.bool] = None,
                 exclude_html_classes: Optional[Sequence[builtins.str]] = None,
                 exclude_html_elements: Optional[Sequence[builtins.str]] = None,
                 exclude_html_ids: Optional[Sequence[builtins.str]] = None,
                 structured_content_types: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool enable_image_annotation: If true, the LLM based annotation is added to the image during parsing.
        :param builtins.bool enable_table_annotation: If true, the LLM based annotation is added to the table during parsing.
        :param Sequence[builtins.str] exclude_html_classes: List of HTML classes to exclude from the parsed content.
        :param Sequence[builtins.str] exclude_html_elements: List of HTML elements to exclude from the parsed content.
        :param Sequence[builtins.str] exclude_html_ids: List of HTML ids to exclude from the parsed content.
        :param Sequence[builtins.str] structured_content_types: Contains the required structure types to extract from the document. Supported values: `shareholder-structure`.
        """
        if enable_image_annotation is not None:
            pulumi.set(__self__, "enable_image_annotation", enable_image_annotation)
        if enable_table_annotation is not None:
            pulumi.set(__self__, "enable_table_annotation", enable_table_annotation)
        if exclude_html_classes is not None:
            pulumi.set(__self__, "exclude_html_classes", exclude_html_classes)
        if exclude_html_elements is not None:
            pulumi.set(__self__, "exclude_html_elements", exclude_html_elements)
        if exclude_html_ids is not None:
            pulumi.set(__self__, "exclude_html_ids", exclude_html_ids)
        if structured_content_types is not None:
            pulumi.set(__self__, "structured_content_types", structured_content_types)

    @property
    @pulumi.getter(name="enableImageAnnotation")
    def enable_image_annotation(self) -> Optional[builtins.bool]:
        """
        If true, the LLM based annotation is added to the image during parsing.
        """
        return pulumi.get(self, "enable_image_annotation")

    @property
    @pulumi.getter(name="enableTableAnnotation")
    def enable_table_annotation(self) -> Optional[builtins.bool]:
        """
        If true, the LLM based annotation is added to the table during parsing.
        """
        return pulumi.get(self, "enable_table_annotation")

    @property
    @pulumi.getter(name="excludeHtmlClasses")
    def exclude_html_classes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of HTML classes to exclude from the parsed content.
        """
        return pulumi.get(self, "exclude_html_classes")

    @property
    @pulumi.getter(name="excludeHtmlElements")
    def exclude_html_elements(self) -> Optional[Sequence[builtins.str]]:
        """
        List of HTML elements to exclude from the parsed content.
        """
        return pulumi.get(self, "exclude_html_elements")

    @property
    @pulumi.getter(name="excludeHtmlIds")
    def exclude_html_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of HTML ids to exclude from the parsed content.
        """
        return pulumi.get(self, "exclude_html_ids")

    @property
    @pulumi.getter(name="structuredContentTypes")
    def structured_content_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains the required structure types to extract from the document. Supported values: `shareholder-structure`.
        """
        return pulumi.get(self, "structured_content_types")


@pulumi.output_type
class DataStoreDocumentProcessingConfigDefaultParsingConfigOcrParsingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useNativeText":
            suggest = "use_native_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfigDefaultParsingConfigOcrParsingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfigDefaultParsingConfigOcrParsingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfigDefaultParsingConfigOcrParsingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_native_text: Optional[builtins.bool] = None):
        """
        :param builtins.bool use_native_text: If true, will use native text instead of OCR text on pages containing native text.
        """
        if use_native_text is not None:
            pulumi.set(__self__, "use_native_text", use_native_text)

    @property
    @pulumi.getter(name="useNativeText")
    def use_native_text(self) -> Optional[builtins.bool]:
        """
        If true, will use native text instead of OCR text on pages containing native text.
        """
        return pulumi.get(self, "use_native_text")


@pulumi.output_type
class DataStoreDocumentProcessingConfigParsingConfigOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileType":
            suggest = "file_type"
        elif key == "digitalParsingConfig":
            suggest = "digital_parsing_config"
        elif key == "layoutParsingConfig":
            suggest = "layout_parsing_config"
        elif key == "ocrParsingConfig":
            suggest = "ocr_parsing_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfigParsingConfigOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfigParsingConfigOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfigParsingConfigOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_type: builtins.str,
                 digital_parsing_config: Optional['outputs.DataStoreDocumentProcessingConfigParsingConfigOverrideDigitalParsingConfig'] = None,
                 layout_parsing_config: Optional['outputs.DataStoreDocumentProcessingConfigParsingConfigOverrideLayoutParsingConfig'] = None,
                 ocr_parsing_config: Optional['outputs.DataStoreDocumentProcessingConfigParsingConfigOverrideOcrParsingConfig'] = None):
        """
        :param builtins.str file_type: The identifier for this object. Format specified above.
        :param 'DataStoreDocumentProcessingConfigParsingConfigOverrideDigitalParsingConfigArgs' digital_parsing_config: Configurations applied to digital parser.
        :param 'DataStoreDocumentProcessingConfigParsingConfigOverrideLayoutParsingConfigArgs' layout_parsing_config: Configurations applied to layout parser.
               Structure is documented below.
        :param 'DataStoreDocumentProcessingConfigParsingConfigOverrideOcrParsingConfigArgs' ocr_parsing_config: Configurations applied to OCR parser. Currently it only applies to PDFs.
               Structure is documented below.
        """
        pulumi.set(__self__, "file_type", file_type)
        if digital_parsing_config is not None:
            pulumi.set(__self__, "digital_parsing_config", digital_parsing_config)
        if layout_parsing_config is not None:
            pulumi.set(__self__, "layout_parsing_config", layout_parsing_config)
        if ocr_parsing_config is not None:
            pulumi.set(__self__, "ocr_parsing_config", ocr_parsing_config)

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter(name="digitalParsingConfig")
    def digital_parsing_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigParsingConfigOverrideDigitalParsingConfig']:
        """
        Configurations applied to digital parser.
        """
        return pulumi.get(self, "digital_parsing_config")

    @property
    @pulumi.getter(name="layoutParsingConfig")
    def layout_parsing_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigParsingConfigOverrideLayoutParsingConfig']:
        """
        Configurations applied to layout parser.
        Structure is documented below.
        """
        return pulumi.get(self, "layout_parsing_config")

    @property
    @pulumi.getter(name="ocrParsingConfig")
    def ocr_parsing_config(self) -> Optional['outputs.DataStoreDocumentProcessingConfigParsingConfigOverrideOcrParsingConfig']:
        """
        Configurations applied to OCR parser. Currently it only applies to PDFs.
        Structure is documented below.
        """
        return pulumi.get(self, "ocr_parsing_config")


@pulumi.output_type
class DataStoreDocumentProcessingConfigParsingConfigOverrideDigitalParsingConfig(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DataStoreDocumentProcessingConfigParsingConfigOverrideLayoutParsingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableImageAnnotation":
            suggest = "enable_image_annotation"
        elif key == "enableTableAnnotation":
            suggest = "enable_table_annotation"
        elif key == "excludeHtmlClasses":
            suggest = "exclude_html_classes"
        elif key == "excludeHtmlElements":
            suggest = "exclude_html_elements"
        elif key == "excludeHtmlIds":
            suggest = "exclude_html_ids"
        elif key == "structuredContentTypes":
            suggest = "structured_content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfigParsingConfigOverrideLayoutParsingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfigParsingConfigOverrideLayoutParsingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfigParsingConfigOverrideLayoutParsingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_image_annotation: Optional[builtins.bool] = None,
                 enable_table_annotation: Optional[builtins.bool] = None,
                 exclude_html_classes: Optional[Sequence[builtins.str]] = None,
                 exclude_html_elements: Optional[Sequence[builtins.str]] = None,
                 exclude_html_ids: Optional[Sequence[builtins.str]] = None,
                 structured_content_types: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool enable_image_annotation: If true, the LLM based annotation is added to the image during parsing.
        :param builtins.bool enable_table_annotation: If true, the LLM based annotation is added to the table during parsing.
        :param Sequence[builtins.str] exclude_html_classes: List of HTML classes to exclude from the parsed content.
        :param Sequence[builtins.str] exclude_html_elements: List of HTML elements to exclude from the parsed content.
        :param Sequence[builtins.str] exclude_html_ids: List of HTML ids to exclude from the parsed content.
        :param Sequence[builtins.str] structured_content_types: Contains the required structure types to extract from the document. Supported values: `shareholder-structure`.
        """
        if enable_image_annotation is not None:
            pulumi.set(__self__, "enable_image_annotation", enable_image_annotation)
        if enable_table_annotation is not None:
            pulumi.set(__self__, "enable_table_annotation", enable_table_annotation)
        if exclude_html_classes is not None:
            pulumi.set(__self__, "exclude_html_classes", exclude_html_classes)
        if exclude_html_elements is not None:
            pulumi.set(__self__, "exclude_html_elements", exclude_html_elements)
        if exclude_html_ids is not None:
            pulumi.set(__self__, "exclude_html_ids", exclude_html_ids)
        if structured_content_types is not None:
            pulumi.set(__self__, "structured_content_types", structured_content_types)

    @property
    @pulumi.getter(name="enableImageAnnotation")
    def enable_image_annotation(self) -> Optional[builtins.bool]:
        """
        If true, the LLM based annotation is added to the image during parsing.
        """
        return pulumi.get(self, "enable_image_annotation")

    @property
    @pulumi.getter(name="enableTableAnnotation")
    def enable_table_annotation(self) -> Optional[builtins.bool]:
        """
        If true, the LLM based annotation is added to the table during parsing.
        """
        return pulumi.get(self, "enable_table_annotation")

    @property
    @pulumi.getter(name="excludeHtmlClasses")
    def exclude_html_classes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of HTML classes to exclude from the parsed content.
        """
        return pulumi.get(self, "exclude_html_classes")

    @property
    @pulumi.getter(name="excludeHtmlElements")
    def exclude_html_elements(self) -> Optional[Sequence[builtins.str]]:
        """
        List of HTML elements to exclude from the parsed content.
        """
        return pulumi.get(self, "exclude_html_elements")

    @property
    @pulumi.getter(name="excludeHtmlIds")
    def exclude_html_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of HTML ids to exclude from the parsed content.
        """
        return pulumi.get(self, "exclude_html_ids")

    @property
    @pulumi.getter(name="structuredContentTypes")
    def structured_content_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains the required structure types to extract from the document. Supported values: `shareholder-structure`.
        """
        return pulumi.get(self, "structured_content_types")


@pulumi.output_type
class DataStoreDocumentProcessingConfigParsingConfigOverrideOcrParsingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useNativeText":
            suggest = "use_native_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreDocumentProcessingConfigParsingConfigOverrideOcrParsingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreDocumentProcessingConfigParsingConfigOverrideOcrParsingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreDocumentProcessingConfigParsingConfigOverrideOcrParsingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_native_text: Optional[builtins.bool] = None):
        """
        :param builtins.bool use_native_text: If true, will use native text instead of OCR text on pages containing native text.
        """
        if use_native_text is not None:
            pulumi.set(__self__, "use_native_text", use_native_text)

    @property
    @pulumi.getter(name="useNativeText")
    def use_native_text(self) -> Optional[builtins.bool]:
        """
        If true, will use native text instead of OCR text on pages containing native text.
        """
        return pulumi.get(self, "use_native_text")


@pulumi.output_type
class SearchEngineCommonConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "companyName":
            suggest = "company_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchEngineCommonConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchEngineCommonConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchEngineCommonConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 company_name: Optional[builtins.str] = None):
        """
        :param builtins.str company_name: The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.cd
        """
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[builtins.str]:
        """
        The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.cd
        """
        return pulumi.get(self, "company_name")


@pulumi.output_type
class SearchEngineSearchEngineConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "searchAddOns":
            suggest = "search_add_ons"
        elif key == "searchTier":
            suggest = "search_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchEngineSearchEngineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchEngineSearchEngineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchEngineSearchEngineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 search_add_ons: Optional[Sequence[builtins.str]] = None,
                 search_tier: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] search_add_ons: The add-on that this search engine enables.
               Each value may be one of: `SEARCH_ADD_ON_LLM`.
        :param builtins.str search_tier: The search feature tier of this engine. Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
               Default value is `SEARCH_TIER_STANDARD`.
               Possible values are: `SEARCH_TIER_STANDARD`, `SEARCH_TIER_ENTERPRISE`.
        """
        if search_add_ons is not None:
            pulumi.set(__self__, "search_add_ons", search_add_ons)
        if search_tier is not None:
            pulumi.set(__self__, "search_tier", search_tier)

    @property
    @pulumi.getter(name="searchAddOns")
    def search_add_ons(self) -> Optional[Sequence[builtins.str]]:
        """
        The add-on that this search engine enables.
        Each value may be one of: `SEARCH_ADD_ON_LLM`.
        """
        return pulumi.get(self, "search_add_ons")

    @property
    @pulumi.getter(name="searchTier")
    def search_tier(self) -> Optional[builtins.str]:
        """
        The search feature tier of this engine. Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
        Default value is `SEARCH_TIER_STANDARD`.
        Possible values are: `SEARCH_TIER_STANDARD`, `SEARCH_TIER_ENTERPRISE`.
        """
        return pulumi.get(self, "search_tier")


@pulumi.output_type
class TargetSiteFailureReason(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quotaFailure":
            suggest = "quota_failure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetSiteFailureReason. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetSiteFailureReason.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetSiteFailureReason.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quota_failure: Optional['outputs.TargetSiteFailureReasonQuotaFailure'] = None):
        """
        :param 'TargetSiteFailureReasonQuotaFailureArgs' quota_failure: Site verification state indicating the ownership and validity.
               Structure is documented below.
        """
        if quota_failure is not None:
            pulumi.set(__self__, "quota_failure", quota_failure)

    @property
    @pulumi.getter(name="quotaFailure")
    def quota_failure(self) -> Optional['outputs.TargetSiteFailureReasonQuotaFailure']:
        """
        Site verification state indicating the ownership and validity.
        Structure is documented below.
        """
        return pulumi.get(self, "quota_failure")


@pulumi.output_type
class TargetSiteFailureReasonQuotaFailure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "totalRequiredQuota":
            suggest = "total_required_quota"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetSiteFailureReasonQuotaFailure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetSiteFailureReasonQuotaFailure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetSiteFailureReasonQuotaFailure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 total_required_quota: Optional[builtins.int] = None):
        """
        :param builtins.int total_required_quota: This number is an estimation on how much total quota this project
               needs to successfully complete indexing.
        """
        if total_required_quota is not None:
            pulumi.set(__self__, "total_required_quota", total_required_quota)

    @property
    @pulumi.getter(name="totalRequiredQuota")
    def total_required_quota(self) -> Optional[builtins.int]:
        """
        This number is an estimation on how much total quota this project
        needs to successfully complete indexing.
        """
        return pulumi.get(self, "total_required_quota")


@pulumi.output_type
class TargetSiteSiteVerificationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "siteVerificationState":
            suggest = "site_verification_state"
        elif key == "verifyTime":
            suggest = "verify_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetSiteSiteVerificationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetSiteSiteVerificationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetSiteSiteVerificationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 site_verification_state: Optional[builtins.str] = None,
                 verify_time: Optional[builtins.str] = None):
        """
        :param builtins.str site_verification_state: Site verification state indicating the ownership and validity.
               Possible values are: `VERIFIED`, `UNVERIFIED`, `EXEMPTED`.
        :param builtins.str verify_time: Latest site verification time.
        """
        if site_verification_state is not None:
            pulumi.set(__self__, "site_verification_state", site_verification_state)
        if verify_time is not None:
            pulumi.set(__self__, "verify_time", verify_time)

    @property
    @pulumi.getter(name="siteVerificationState")
    def site_verification_state(self) -> Optional[builtins.str]:
        """
        Site verification state indicating the ownership and validity.
        Possible values are: `VERIFIED`, `UNVERIFIED`, `EXEMPTED`.
        """
        return pulumi.get(self, "site_verification_state")

    @property
    @pulumi.getter(name="verifyTime")
    def verify_time(self) -> Optional[builtins.str]:
        """
        Latest site verification time.
        """
        return pulumi.get(self, "verify_time")


