# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SearchEngineArgs', 'SearchEngine']

@pulumi.input_type
class SearchEngineArgs:
    def __init__(__self__, *,
                 collection_id: pulumi.Input[builtins.str],
                 data_store_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 display_name: pulumi.Input[builtins.str],
                 engine_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 search_engine_config: pulumi.Input['SearchEngineSearchEngineConfigArgs'],
                 common_config: Optional[pulumi.Input['SearchEngineCommonConfigArgs']] = None,
                 industry_vertical: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SearchEngine resource.
        :param pulumi.Input[builtins.str] collection_id: The collection ID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_store_ids: The data stores associated with this engine. For SOLUTION_TYPE_SEARCH type of engines, they can only associate with at most one data store.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[builtins.str] engine_id: Unique ID to use for Search Engine App.
        :param pulumi.Input[builtins.str] location: Location.
        :param pulumi.Input['SearchEngineSearchEngineConfigArgs'] search_engine_config: Configurations for a Search Engine.
               Structure is documented below.
        :param pulumi.Input['SearchEngineCommonConfigArgs'] common_config: Common config spec that specifies the metadata of the engine.
               Structure is documented below.
        :param pulumi.Input[builtins.str] industry_vertical: The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
               Default value is `GENERIC`.
               Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "collection_id", collection_id)
        pulumi.set(__self__, "data_store_ids", data_store_ids)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "engine_id", engine_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "search_engine_config", search_engine_config)
        if common_config is not None:
            pulumi.set(__self__, "common_config", common_config)
        if industry_vertical is not None:
            pulumi.set(__self__, "industry_vertical", industry_vertical)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Input[builtins.str]:
        """
        The collection ID.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "collection_id", value)

    @property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The data stores associated with this engine. For SOLUTION_TYPE_SEARCH type of engines, they can only associate with at most one data store.
        """
        return pulumi.get(self, "data_store_ids")

    @data_store_ids.setter
    def data_store_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "data_store_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique ID to use for Search Engine App.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "engine_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="searchEngineConfig")
    def search_engine_config(self) -> pulumi.Input['SearchEngineSearchEngineConfigArgs']:
        """
        Configurations for a Search Engine.
        Structure is documented below.
        """
        return pulumi.get(self, "search_engine_config")

    @search_engine_config.setter
    def search_engine_config(self, value: pulumi.Input['SearchEngineSearchEngineConfigArgs']):
        pulumi.set(self, "search_engine_config", value)

    @property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> Optional[pulumi.Input['SearchEngineCommonConfigArgs']]:
        """
        Common config spec that specifies the metadata of the engine.
        Structure is documented below.
        """
        return pulumi.get(self, "common_config")

    @common_config.setter
    def common_config(self, value: Optional[pulumi.Input['SearchEngineCommonConfigArgs']]):
        pulumi.set(self, "common_config", value)

    @property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
        Default value is `GENERIC`.
        Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        """
        return pulumi.get(self, "industry_vertical")

    @industry_vertical.setter
    def industry_vertical(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "industry_vertical", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _SearchEngineState:
    def __init__(__self__, *,
                 collection_id: Optional[pulumi.Input[builtins.str]] = None,
                 common_config: Optional[pulumi.Input['SearchEngineCommonConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[builtins.str]] = None,
                 industry_vertical: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 search_engine_config: Optional[pulumi.Input['SearchEngineSearchEngineConfigArgs']] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SearchEngine resources.
        :param pulumi.Input[builtins.str] collection_id: The collection ID.
        :param pulumi.Input['SearchEngineCommonConfigArgs'] common_config: Common config spec that specifies the metadata of the engine.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: Timestamp the Engine was created at.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_store_ids: The data stores associated with this engine. For SOLUTION_TYPE_SEARCH type of engines, they can only associate with at most one data store.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[builtins.str] engine_id: Unique ID to use for Search Engine App.
        :param pulumi.Input[builtins.str] industry_vertical: The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
               Default value is `GENERIC`.
               Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        :param pulumi.Input[builtins.str] location: Location.
        :param pulumi.Input[builtins.str] name: The unique full resource name of the search engine. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SearchEngineSearchEngineConfigArgs'] search_engine_config: Configurations for a Search Engine.
               Structure is documented below.
        :param pulumi.Input[builtins.str] update_time: Timestamp the Engine was last updated.
        """
        if collection_id is not None:
            pulumi.set(__self__, "collection_id", collection_id)
        if common_config is not None:
            pulumi.set(__self__, "common_config", common_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_store_ids is not None:
            pulumi.set(__self__, "data_store_ids", data_store_ids)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if engine_id is not None:
            pulumi.set(__self__, "engine_id", engine_id)
        if industry_vertical is not None:
            pulumi.set(__self__, "industry_vertical", industry_vertical)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if search_engine_config is not None:
            pulumi.set(__self__, "search_engine_config", search_engine_config)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The collection ID.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collection_id", value)

    @property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> Optional[pulumi.Input['SearchEngineCommonConfigArgs']]:
        """
        Common config spec that specifies the metadata of the engine.
        Structure is documented below.
        """
        return pulumi.get(self, "common_config")

    @common_config.setter
    def common_config(self, value: Optional[pulumi.Input['SearchEngineCommonConfigArgs']]):
        pulumi.set(self, "common_config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp the Engine was created at.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The data stores associated with this engine. For SOLUTION_TYPE_SEARCH type of engines, they can only associate with at most one data store.
        """
        return pulumi.get(self, "data_store_ids")

    @data_store_ids.setter
    def data_store_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "data_store_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique ID to use for Search Engine App.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_id", value)

    @property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
        Default value is `GENERIC`.
        Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        """
        return pulumi.get(self, "industry_vertical")

    @industry_vertical.setter
    def industry_vertical(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "industry_vertical", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique full resource name of the search engine. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="searchEngineConfig")
    def search_engine_config(self) -> Optional[pulumi.Input['SearchEngineSearchEngineConfigArgs']]:
        """
        Configurations for a Search Engine.
        Structure is documented below.
        """
        return pulumi.get(self, "search_engine_config")

    @search_engine_config.setter
    def search_engine_config(self, value: Optional[pulumi.Input['SearchEngineSearchEngineConfigArgs']]):
        pulumi.set(self, "search_engine_config", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp the Engine was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:discoveryengine/searchEngine:SearchEngine")
class SearchEngine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collection_id: Optional[pulumi.Input[builtins.str]] = None,
                 common_config: Optional[pulumi.Input[Union['SearchEngineCommonConfigArgs', 'SearchEngineCommonConfigArgsDict']]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[builtins.str]] = None,
                 industry_vertical: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 search_engine_config: Optional[pulumi.Input[Union['SearchEngineSearchEngineConfigArgs', 'SearchEngineSearchEngineConfigArgsDict']]] = None,
                 __props__=None):
        """
        Vertex AI Search and Conversation can be used to create a search engine or a chat application by connecting it with a datastore

        To get more information about SearchEngine, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.engines)
        * How-to Guides
            * [Create a Search Engine](https://cloud.google.com/generative-ai-app-builder/docs/create-engine-es)

        ## Example Usage

        ### Discoveryengine Searchengine Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="example-datastore-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False)
        basic_search_engine = gcp.discoveryengine.SearchEngine("basic",
            engine_id="example-engine-id",
            collection_id="default_collection",
            location=basic.location,
            display_name="Example Display Name",
            data_store_ids=[basic.data_store_id],
            search_engine_config={})
        ```

        ## Import

        SearchEngine can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}`

        * `{{project}}/{{location}}/{{collection_id}}/{{engine_id}}`

        * `{{location}}/{{collection_id}}/{{engine_id}}`

        When using the `pulumi import` command, SearchEngine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/searchEngine:SearchEngine default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/searchEngine:SearchEngine default {{project}}/{{location}}/{{collection_id}}/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/searchEngine:SearchEngine default {{location}}/{{collection_id}}/{{engine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] collection_id: The collection ID.
        :param pulumi.Input[Union['SearchEngineCommonConfigArgs', 'SearchEngineCommonConfigArgsDict']] common_config: Common config spec that specifies the metadata of the engine.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_store_ids: The data stores associated with this engine. For SOLUTION_TYPE_SEARCH type of engines, they can only associate with at most one data store.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[builtins.str] engine_id: Unique ID to use for Search Engine App.
        :param pulumi.Input[builtins.str] industry_vertical: The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
               Default value is `GENERIC`.
               Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        :param pulumi.Input[builtins.str] location: Location.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SearchEngineSearchEngineConfigArgs', 'SearchEngineSearchEngineConfigArgsDict']] search_engine_config: Configurations for a Search Engine.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SearchEngineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Vertex AI Search and Conversation can be used to create a search engine or a chat application by connecting it with a datastore

        To get more information about SearchEngine, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.engines)
        * How-to Guides
            * [Create a Search Engine](https://cloud.google.com/generative-ai-app-builder/docs/create-engine-es)

        ## Example Usage

        ### Discoveryengine Searchengine Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="example-datastore-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False)
        basic_search_engine = gcp.discoveryengine.SearchEngine("basic",
            engine_id="example-engine-id",
            collection_id="default_collection",
            location=basic.location,
            display_name="Example Display Name",
            data_store_ids=[basic.data_store_id],
            search_engine_config={})
        ```

        ## Import

        SearchEngine can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}`

        * `{{project}}/{{location}}/{{collection_id}}/{{engine_id}}`

        * `{{location}}/{{collection_id}}/{{engine_id}}`

        When using the `pulumi import` command, SearchEngine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/searchEngine:SearchEngine default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/searchEngine:SearchEngine default {{project}}/{{location}}/{{collection_id}}/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/searchEngine:SearchEngine default {{location}}/{{collection_id}}/{{engine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param SearchEngineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SearchEngineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collection_id: Optional[pulumi.Input[builtins.str]] = None,
                 common_config: Optional[pulumi.Input[Union['SearchEngineCommonConfigArgs', 'SearchEngineCommonConfigArgsDict']]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[builtins.str]] = None,
                 industry_vertical: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 search_engine_config: Optional[pulumi.Input[Union['SearchEngineSearchEngineConfigArgs', 'SearchEngineSearchEngineConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SearchEngineArgs.__new__(SearchEngineArgs)

            if collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'collection_id'")
            __props__.__dict__["collection_id"] = collection_id
            __props__.__dict__["common_config"] = common_config
            if data_store_ids is None and not opts.urn:
                raise TypeError("Missing required property 'data_store_ids'")
            __props__.__dict__["data_store_ids"] = data_store_ids
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if engine_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_id'")
            __props__.__dict__["engine_id"] = engine_id
            __props__.__dict__["industry_vertical"] = industry_vertical
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if search_engine_config is None and not opts.urn:
                raise TypeError("Missing required property 'search_engine_config'")
            __props__.__dict__["search_engine_config"] = search_engine_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(SearchEngine, __self__).__init__(
            'gcp:discoveryengine/searchEngine:SearchEngine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            collection_id: Optional[pulumi.Input[builtins.str]] = None,
            common_config: Optional[pulumi.Input[Union['SearchEngineCommonConfigArgs', 'SearchEngineCommonConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            engine_id: Optional[pulumi.Input[builtins.str]] = None,
            industry_vertical: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            search_engine_config: Optional[pulumi.Input[Union['SearchEngineSearchEngineConfigArgs', 'SearchEngineSearchEngineConfigArgsDict']]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'SearchEngine':
        """
        Get an existing SearchEngine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] collection_id: The collection ID.
        :param pulumi.Input[Union['SearchEngineCommonConfigArgs', 'SearchEngineCommonConfigArgsDict']] common_config: Common config spec that specifies the metadata of the engine.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: Timestamp the Engine was created at.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_store_ids: The data stores associated with this engine. For SOLUTION_TYPE_SEARCH type of engines, they can only associate with at most one data store.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[builtins.str] engine_id: Unique ID to use for Search Engine App.
        :param pulumi.Input[builtins.str] industry_vertical: The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
               Default value is `GENERIC`.
               Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        :param pulumi.Input[builtins.str] location: Location.
        :param pulumi.Input[builtins.str] name: The unique full resource name of the search engine. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SearchEngineSearchEngineConfigArgs', 'SearchEngineSearchEngineConfigArgsDict']] search_engine_config: Configurations for a Search Engine.
               Structure is documented below.
        :param pulumi.Input[builtins.str] update_time: Timestamp the Engine was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SearchEngineState.__new__(_SearchEngineState)

        __props__.__dict__["collection_id"] = collection_id
        __props__.__dict__["common_config"] = common_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_store_ids"] = data_store_ids
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["engine_id"] = engine_id
        __props__.__dict__["industry_vertical"] = industry_vertical
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["search_engine_config"] = search_engine_config
        __props__.__dict__["update_time"] = update_time
        return SearchEngine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Output[builtins.str]:
        """
        The collection ID.
        """
        return pulumi.get(self, "collection_id")

    @property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> pulumi.Output[Optional['outputs.SearchEngineCommonConfig']]:
        """
        Common config spec that specifies the metadata of the engine.
        Structure is documented below.
        """
        return pulumi.get(self, "common_config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp the Engine was created at.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The data stores associated with this engine. For SOLUTION_TYPE_SEARCH type of engines, they can only associate with at most one data store.
        """
        return pulumi.get(self, "data_store_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique ID to use for Search Engine App.
        """
        return pulumi.get(self, "engine_id")

    @property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
        Default value is `GENERIC`.
        Possible values are: `GENERIC`, `MEDIA`, `HEALTHCARE_FHIR`.
        """
        return pulumi.get(self, "industry_vertical")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique full resource name of the search engine. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="searchEngineConfig")
    def search_engine_config(self) -> pulumi.Output['outputs.SearchEngineSearchEngineConfig']:
        """
        Configurations for a Search Engine.
        Structure is documented below.
        """
        return pulumi.get(self, "search_engine_config")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp the Engine was last updated.
        """
        return pulumi.get(self, "update_time")

