# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SitemapArgs', 'Sitemap']

@pulumi.input_type
class SitemapArgs:
    def __init__(__self__, *,
                 data_store_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Sitemap resource.
        :param pulumi.Input[builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] uri: Public URI for the sitemap, e.g. "www.example.com/sitemap.xml".
        """
        pulumi.set(__self__, "data_store_id", data_store_id)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @data_store_id.setter
    def data_store_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_store_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Public URI for the sitemap, e.g. "www.example.com/sitemap.xml".
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class _SitemapState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 data_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 sitemap_id: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Sitemap resources.
        :param pulumi.Input[builtins.str] create_time: Timestamp when the sitemap was created.
        :param pulumi.Input[builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[builtins.str] name: The unique full resource name of the sitemap. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/siteSearchEngine/sitemaps/{sitemap_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] sitemap_id: The unique id of the sitemap.
        :param pulumi.Input[builtins.str] uri: Public URI for the sitemap, e.g. "www.example.com/sitemap.xml".
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_store_id is not None:
            pulumi.set(__self__, "data_store_id", data_store_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sitemap_id is not None:
            pulumi.set(__self__, "sitemap_id", sitemap_id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp when the sitemap was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @data_store_id.setter
    def data_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_store_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique full resource name of the sitemap. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/siteSearchEngine/sitemaps/{sitemap_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sitemapId")
    def sitemap_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique id of the sitemap.
        """
        return pulumi.get(self, "sitemap_id")

    @sitemap_id.setter
    def sitemap_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sitemap_id", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Public URI for the sitemap, e.g. "www.example.com/sitemap.xml".
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.type_token("gcp:discoveryengine/sitemap:Sitemap")
class Sitemap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Sitemap is a file where you provide information about the pages, videos, and
        other files on your site, and the relationships between them.

        To get more information about Sitemap, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.dataStores.siteSearchEngine.sitemaps)

        ## Example Usage

        ### Discoveryengine Sitemap Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advanced = gcp.discoveryengine.DataStore("advanced",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-advanced-site-search-datastore",
            industry_vertical="GENERIC",
            content_config="PUBLIC_WEBSITE",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=True,
            skip_default_schema_creation=False)
        basic = gcp.discoveryengine.Sitemap("basic",
            location=advanced.location,
            data_store_id=advanced.data_store_id,
            uri="https://www.test.com/sitemap.xml")
        ```

        ## Import

        Sitemap can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, Sitemap can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/sitemap:Sitemap default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] uri: Public URI for the sitemap, e.g. "www.example.com/sitemap.xml".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SitemapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Sitemap is a file where you provide information about the pages, videos, and
        other files on your site, and the relationships between them.

        To get more information about Sitemap, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.dataStores.siteSearchEngine.sitemaps)

        ## Example Usage

        ### Discoveryengine Sitemap Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advanced = gcp.discoveryengine.DataStore("advanced",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-advanced-site-search-datastore",
            industry_vertical="GENERIC",
            content_config="PUBLIC_WEBSITE",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=True,
            skip_default_schema_creation=False)
        basic = gcp.discoveryengine.Sitemap("basic",
            location=advanced.location,
            data_store_id=advanced.data_store_id,
            uri="https://www.test.com/sitemap.xml")
        ```

        ## Import

        Sitemap can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, Sitemap can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/sitemap:Sitemap default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SitemapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SitemapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SitemapArgs.__new__(SitemapArgs)

            if data_store_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_store_id'")
            __props__.__dict__["data_store_id"] = data_store_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["uri"] = uri
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["sitemap_id"] = None
        super(Sitemap, __self__).__init__(
            'gcp:discoveryengine/sitemap:Sitemap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            data_store_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            sitemap_id: Optional[pulumi.Input[builtins.str]] = None,
            uri: Optional[pulumi.Input[builtins.str]] = None) -> 'Sitemap':
        """
        Get an existing Sitemap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Timestamp when the sitemap was created.
        :param pulumi.Input[builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[builtins.str] name: The unique full resource name of the sitemap. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/siteSearchEngine/sitemaps/{sitemap_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] sitemap_id: The unique id of the sitemap.
        :param pulumi.Input[builtins.str] uri: Public URI for the sitemap, e.g. "www.example.com/sitemap.xml".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SitemapState.__new__(_SitemapState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_store_id"] = data_store_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["sitemap_id"] = sitemap_id
        __props__.__dict__["uri"] = uri
        return Sitemap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp when the sitemap was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique full resource name of the sitemap. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/siteSearchEngine/sitemaps/{sitemap_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sitemapId")
    def sitemap_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique id of the sitemap.
        """
        return pulumi.get(self, "sitemap_id")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Public URI for the sitemap, e.g. "www.example.com/sitemap.xml".
        """
        return pulumi.get(self, "uri")

