# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DnsManagedZoneIamBindingCondition',
    'DnsManagedZoneIamMemberCondition',
    'ManagedZoneCloudLoggingConfig',
    'ManagedZoneDnssecConfig',
    'ManagedZoneDnssecConfigDefaultKeySpec',
    'ManagedZoneForwardingConfig',
    'ManagedZoneForwardingConfigTargetNameServer',
    'ManagedZonePeeringConfig',
    'ManagedZonePeeringConfigTargetNetwork',
    'ManagedZonePrivateVisibilityConfig',
    'ManagedZonePrivateVisibilityConfigGkeCluster',
    'ManagedZonePrivateVisibilityConfigNetwork',
    'ManagedZoneServiceDirectoryConfig',
    'ManagedZoneServiceDirectoryConfigNamespace',
    'PolicyAlternativeNameServerConfig',
    'PolicyAlternativeNameServerConfigTargetNameServer',
    'PolicyDns64Config',
    'PolicyDns64ConfigScope',
    'PolicyNetwork',
    'RecordSetRoutingPolicy',
    'RecordSetRoutingPolicyGeo',
    'RecordSetRoutingPolicyGeoHealthCheckedTargets',
    'RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancer',
    'RecordSetRoutingPolicyPrimaryBackup',
    'RecordSetRoutingPolicyPrimaryBackupBackupGeo',
    'RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets',
    'RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancer',
    'RecordSetRoutingPolicyPrimaryBackupPrimary',
    'RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancer',
    'RecordSetRoutingPolicyWrr',
    'RecordSetRoutingPolicyWrrHealthCheckedTargets',
    'RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancer',
    'ResponsePolicyGkeCluster',
    'ResponsePolicyNetwork',
    'ResponsePolicyRuleLocalData',
    'ResponsePolicyRuleLocalDataLocalData',
    'GetKeysKeySigningKeyResult',
    'GetKeysKeySigningKeyDigestResult',
    'GetKeysZoneSigningKeyResult',
    'GetKeysZoneSigningKeyDigestResult',
    'GetManagedZonesManagedZoneResult',
]

@pulumi.output_type
class DnsManagedZoneIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DnsManagedZoneIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ManagedZoneCloudLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableLogging":
            suggest = "enable_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneCloudLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneCloudLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneCloudLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_logging: builtins.bool):
        """
        :param builtins.bool enable_logging: If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        pulumi.set(__self__, "enable_logging", enable_logging)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> builtins.bool:
        """
        If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        return pulumi.get(self, "enable_logging")


@pulumi.output_type
class ManagedZoneDnssecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKeySpecs":
            suggest = "default_key_specs"
        elif key == "nonExistence":
            suggest = "non_existence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneDnssecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneDnssecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneDnssecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_key_specs: Optional[Sequence['outputs.ManagedZoneDnssecConfigDefaultKeySpec']] = None,
                 kind: Optional[builtins.str] = None,
                 non_existence: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param Sequence['ManagedZoneDnssecConfigDefaultKeySpecArgs'] default_key_specs: Specifies parameters that will be used for generating initial DnsKeys
               for this ManagedZone. If you provide a spec for keySigning or zoneSigning,
               you must also provide one for the other.
               default_key_specs can only be updated when the state is `off`.
               Structure is documented below.
        :param builtins.str kind: Identifies what kind of resource this is
        :param builtins.str non_existence: Specifies the mechanism used to provide authenticated denial-of-existence responses.
               non_existence can only be updated when the state is `off`.
               Possible values are: `nsec`, `nsec3`.
        :param builtins.str state: Specifies whether DNSSEC is enabled, and what mode it is in
               Possible values are: `off`, `on`, `transfer`.
        """
        if default_key_specs is not None:
            pulumi.set(__self__, "default_key_specs", default_key_specs)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if non_existence is not None:
            pulumi.set(__self__, "non_existence", non_existence)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="defaultKeySpecs")
    def default_key_specs(self) -> Optional[Sequence['outputs.ManagedZoneDnssecConfigDefaultKeySpec']]:
        """
        Specifies parameters that will be used for generating initial DnsKeys
        for this ManagedZone. If you provide a spec for keySigning or zoneSigning,
        you must also provide one for the other.
        default_key_specs can only be updated when the state is `off`.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_specs")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Identifies what kind of resource this is
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="nonExistence")
    def non_existence(self) -> Optional[builtins.str]:
        """
        Specifies the mechanism used to provide authenticated denial-of-existence responses.
        non_existence can only be updated when the state is `off`.
        Possible values are: `nsec`, `nsec3`.
        """
        return pulumi.get(self, "non_existence")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Specifies whether DNSSEC is enabled, and what mode it is in
        Possible values are: `off`, `on`, `transfer`.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedZoneDnssecConfigDefaultKeySpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyLength":
            suggest = "key_length"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneDnssecConfigDefaultKeySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneDnssecConfigDefaultKeySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneDnssecConfigDefaultKeySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[builtins.str] = None,
                 key_length: Optional[builtins.int] = None,
                 key_type: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None):
        """
        :param builtins.str algorithm: String mnemonic specifying the DNSSEC algorithm of this key
               Possible values are: `ecdsap256sha256`, `ecdsap384sha384`, `rsasha1`, `rsasha256`, `rsasha512`.
        :param builtins.int key_length: Length of the keys in bits
        :param builtins.str key_type: Specifies whether this is a key signing key (KSK) or a zone
               signing key (ZSK). Key signing keys have the Secure Entry
               Point flag set and, when active, will only be used to sign
               resource record sets of type DNSKEY. Zone signing keys do
               not have the Secure Entry Point flag set and will be used
               to sign all other types of resource record sets.
               Possible values are: `keySigning`, `zoneSigning`.
        :param builtins.str kind: Identifies what kind of resource this is
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_length is not None:
            pulumi.set(__self__, "key_length", key_length)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[builtins.str]:
        """
        String mnemonic specifying the DNSSEC algorithm of this key
        Possible values are: `ecdsap256sha256`, `ecdsap384sha384`, `rsasha1`, `rsasha256`, `rsasha512`.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> Optional[builtins.int]:
        """
        Length of the keys in bits
        """
        return pulumi.get(self, "key_length")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[builtins.str]:
        """
        Specifies whether this is a key signing key (KSK) or a zone
        signing key (ZSK). Key signing keys have the Secure Entry
        Point flag set and, when active, will only be used to sign
        resource record sets of type DNSKEY. Zone signing keys do
        not have the Secure Entry Point flag set and will be used
        to sign all other types of resource record sets.
        Possible values are: `keySigning`, `zoneSigning`.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Identifies what kind of resource this is
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZoneForwardingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNameServers":
            suggest = "target_name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneForwardingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneForwardingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneForwardingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_name_servers: Sequence['outputs.ManagedZoneForwardingConfigTargetNameServer']):
        """
        :param Sequence['ManagedZoneForwardingConfigTargetNameServerArgs'] target_name_servers: List of target name servers to forward to. Cloud DNS will
               select the best available name server if more than
               one target is given.
               Structure is documented below.
        """
        pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> Sequence['outputs.ManagedZoneForwardingConfigTargetNameServer']:
        """
        List of target name servers to forward to. Cloud DNS will
        select the best available name server if more than
        one target is given.
        Structure is documented below.
        """
        return pulumi.get(self, "target_name_servers")


@pulumi.output_type
class ManagedZoneForwardingConfigTargetNameServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "forwardingPath":
            suggest = "forwarding_path"
        elif key == "ipv4Address":
            suggest = "ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneForwardingConfigTargetNameServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneForwardingConfigTargetNameServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneForwardingConfigTargetNameServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[builtins.str] = None,
                 forwarding_path: Optional[builtins.str] = None,
                 ipv4_address: Optional[builtins.str] = None):
        """
        :param builtins.str domain_name: Fully qualified domain name for the forwarding target.
        :param builtins.str forwarding_path: Forwarding path for this TargetNameServer. If unset or `default` Cloud DNS will make forwarding
               decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
               to the Internet. When set to `private`, Cloud DNS will always send queries through VPC for this target
               Possible values are: `default`, `private`.
        :param builtins.str ipv4_address: IPv4 address of a target name server.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if forwarding_path is not None:
            pulumi.set(__self__, "forwarding_path", forwarding_path)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[builtins.str]:
        """
        Fully qualified domain name for the forwarding target.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> Optional[builtins.str]:
        """
        Forwarding path for this TargetNameServer. If unset or `default` Cloud DNS will make forwarding
        decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
        to the Internet. When set to `private`, Cloud DNS will always send queries through VPC for this target
        Possible values are: `default`, `private`.
        """
        return pulumi.get(self, "forwarding_path")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[builtins.str]:
        """
        IPv4 address of a target name server.
        """
        return pulumi.get(self, "ipv4_address")


@pulumi.output_type
class ManagedZonePeeringConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNetwork":
            suggest = "target_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePeeringConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePeeringConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePeeringConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_network: 'outputs.ManagedZonePeeringConfigTargetNetwork'):
        """
        :param 'ManagedZonePeeringConfigTargetNetworkArgs' target_network: The network with which to peer.
               Structure is documented below.
        """
        pulumi.set(__self__, "target_network", target_network)

    @property
    @pulumi.getter(name="targetNetwork")
    def target_network(self) -> 'outputs.ManagedZonePeeringConfigTargetNetwork':
        """
        The network with which to peer.
        Structure is documented below.
        """
        return pulumi.get(self, "target_network")


@pulumi.output_type
class ManagedZonePeeringConfigTargetNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePeeringConfigTargetNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePeeringConfigTargetNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePeeringConfigTargetNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_url: builtins.str):
        """
        :param builtins.str network_url: The id or fully qualified URL of the VPC network to forward queries to.
               This should be formatted like `projects/{project}/global/networks/{network}` or
               `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> builtins.str:
        """
        The id or fully qualified URL of the VPC network to forward queries to.
        This should be formatted like `projects/{project}/global/networks/{network}` or
        `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusters":
            suggest = "gke_clusters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_clusters: Optional[Sequence['outputs.ManagedZonePrivateVisibilityConfigGkeCluster']] = None,
                 networks: Optional[Sequence['outputs.ManagedZonePrivateVisibilityConfigNetwork']] = None):
        """
        :param Sequence['ManagedZonePrivateVisibilityConfigGkeClusterArgs'] gke_clusters: The list of Google Kubernetes Engine clusters that can see this zone.
               Structure is documented below.
        """
        if gke_clusters is not None:
            pulumi.set(__self__, "gke_clusters", gke_clusters)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter(name="gkeClusters")
    def gke_clusters(self) -> Optional[Sequence['outputs.ManagedZonePrivateVisibilityConfigGkeCluster']]:
        """
        The list of Google Kubernetes Engine clusters that can see this zone.
        Structure is documented below.
        """
        return pulumi.get(self, "gke_clusters")

    @property
    @pulumi.getter
    def networks(self) -> Optional[Sequence['outputs.ManagedZonePrivateVisibilityConfigNetwork']]:
        return pulumi.get(self, "networks")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfigGkeCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusterName":
            suggest = "gke_cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfigGkeCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfigGkeCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfigGkeCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_cluster_name: builtins.str):
        """
        :param builtins.str gke_cluster_name: The resource name of the cluster to bind this ManagedZone to.
               This should be specified in the format like
               `projects/*/locations/*/clusters/*`
        """
        pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> builtins.str:
        """
        The resource name of the cluster to bind this ManagedZone to.
        This should be specified in the format like
        `projects/*/locations/*/clusters/*`
        """
        return pulumi.get(self, "gke_cluster_name")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfigNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfigNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfigNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfigNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_url: builtins.str):
        """
        :param builtins.str network_url: The id or fully qualified URL of the VPC network to bind to.
               This should be formatted like `projects/{project}/global/networks/{network}` or
               `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> builtins.str:
        """
        The id or fully qualified URL of the VPC network to bind to.
        This should be formatted like `projects/{project}/global/networks/{network}` or
        `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ManagedZoneServiceDirectoryConfig(dict):
    def __init__(__self__, *,
                 namespace: 'outputs.ManagedZoneServiceDirectoryConfigNamespace'):
        """
        :param 'ManagedZoneServiceDirectoryConfigNamespaceArgs' namespace: The namespace associated with the zone.
               Structure is documented below.
        """
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> 'outputs.ManagedZoneServiceDirectoryConfigNamespace':
        """
        The namespace associated with the zone.
        Structure is documented below.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ManagedZoneServiceDirectoryConfigNamespace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceUrl":
            suggest = "namespace_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneServiceDirectoryConfigNamespace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneServiceDirectoryConfigNamespace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneServiceDirectoryConfigNamespace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace_url: builtins.str):
        """
        :param builtins.str namespace_url: The fully qualified or partial URL of the service directory namespace that should be
               associated with the zone. This should be formatted like
               `https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace_id}`
               or simply `projects/{project}/locations/{location}/namespaces/{namespace_id}`
               Ignored for `public` visibility zones.
        """
        pulumi.set(__self__, "namespace_url", namespace_url)

    @property
    @pulumi.getter(name="namespaceUrl")
    def namespace_url(self) -> builtins.str:
        """
        The fully qualified or partial URL of the service directory namespace that should be
        associated with the zone. This should be formatted like
        `https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace_id}`
        or simply `projects/{project}/locations/{location}/namespaces/{namespace_id}`
        Ignored for `public` visibility zones.
        """
        return pulumi.get(self, "namespace_url")


@pulumi.output_type
class PolicyAlternativeNameServerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNameServers":
            suggest = "target_name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAlternativeNameServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAlternativeNameServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAlternativeNameServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_name_servers: Sequence['outputs.PolicyAlternativeNameServerConfigTargetNameServer']):
        """
        :param Sequence['PolicyAlternativeNameServerConfigTargetNameServerArgs'] target_name_servers: Sets an alternative name server for the associated networks. When specified,
               all DNS queries are forwarded to a name server that you choose. Names such as .internal
               are not available when an alternative name server is specified.
               Structure is documented below.
        """
        pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> Sequence['outputs.PolicyAlternativeNameServerConfigTargetNameServer']:
        """
        Sets an alternative name server for the associated networks. When specified,
        all DNS queries are forwarded to a name server that you choose. Names such as .internal
        are not available when an alternative name server is specified.
        Structure is documented below.
        """
        return pulumi.get(self, "target_name_servers")


@pulumi.output_type
class PolicyAlternativeNameServerConfigTargetNameServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "forwardingPath":
            suggest = "forwarding_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAlternativeNameServerConfigTargetNameServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAlternativeNameServerConfigTargetNameServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAlternativeNameServerConfigTargetNameServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_address: builtins.str,
                 forwarding_path: Optional[builtins.str] = None):
        """
        :param builtins.str ipv4_address: IPv4 address to forward to.
        :param builtins.str forwarding_path: Forwarding path for this TargetNameServer. If unset or `default` Cloud DNS will make forwarding
               decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
               to the Internet. When set to `private`, Cloud DNS will always send queries through VPC for this target
               Possible values are: `default`, `private`.
               
               <a name="nested_dns64_config"></a>The `dns64_config` block supports:
        """
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        if forwarding_path is not None:
            pulumi.set(__self__, "forwarding_path", forwarding_path)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> builtins.str:
        """
        IPv4 address to forward to.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> Optional[builtins.str]:
        """
        Forwarding path for this TargetNameServer. If unset or `default` Cloud DNS will make forwarding
        decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
        to the Internet. When set to `private`, Cloud DNS will always send queries through VPC for this target
        Possible values are: `default`, `private`.

        <a name="nested_dns64_config"></a>The `dns64_config` block supports:
        """
        return pulumi.get(self, "forwarding_path")


@pulumi.output_type
class PolicyDns64Config(dict):
    def __init__(__self__, *,
                 scope: 'outputs.PolicyDns64ConfigScope'):
        """
        :param 'PolicyDns64ConfigScopeArgs' scope: The scope to which DNS64 config will be applied to.
        """
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def scope(self) -> 'outputs.PolicyDns64ConfigScope':
        """
        The scope to which DNS64 config will be applied to.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class PolicyDns64ConfigScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allQueries":
            suggest = "all_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDns64ConfigScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDns64ConfigScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDns64ConfigScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_queries: Optional[builtins.bool] = None):
        """
        :param builtins.bool all_queries: Controls whether DNS64 is enabled globally at the network level.
        """
        if all_queries is not None:
            pulumi.set(__self__, "all_queries", all_queries)

    @property
    @pulumi.getter(name="allQueries")
    def all_queries(self) -> Optional[builtins.bool]:
        """
        Controls whether DNS64 is enabled globally at the network level.
        """
        return pulumi.get(self, "all_queries")


@pulumi.output_type
class PolicyNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_url: builtins.str):
        """
        :param builtins.str network_url: The id or fully qualified URL of the VPC network to forward queries to.
               This should be formatted like `projects/{project}/global/networks/{network}` or
               `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> builtins.str:
        """
        The id or fully qualified URL of the VPC network to forward queries to.
        This should be formatted like `projects/{project}/global/networks/{network}` or
        `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class RecordSetRoutingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableGeoFencing":
            suggest = "enable_geo_fencing"
        elif key == "healthCheck":
            suggest = "health_check"
        elif key == "primaryBackup":
            suggest = "primary_backup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_geo_fencing: Optional[builtins.bool] = None,
                 geos: Optional[Sequence['outputs.RecordSetRoutingPolicyGeo']] = None,
                 health_check: Optional[builtins.str] = None,
                 primary_backup: Optional['outputs.RecordSetRoutingPolicyPrimaryBackup'] = None,
                 wrrs: Optional[Sequence['outputs.RecordSetRoutingPolicyWrr']] = None):
        """
        :param builtins.bool enable_geo_fencing: Specifies whether to enable fencing for geo queries.
        :param Sequence['RecordSetRoutingPolicyGeoArgs'] geos: The configuration for Geolocation based routing policy.
               Structure is documented below.
        :param builtins.str health_check: Specifies the health check (used with external endpoints).
        :param 'RecordSetRoutingPolicyPrimaryBackupArgs' primary_backup: The configuration for a failover policy with global to regional failover. Queries are responded to with the global primary targets, but if none of the primary targets are healthy, then we fallback to a regional failover policy.
               Structure is documented below.
        :param Sequence['RecordSetRoutingPolicyWrrArgs'] wrrs: The configuration for Weighted Round Robin based routing policy.
               Structure is documented below.
        """
        if enable_geo_fencing is not None:
            pulumi.set(__self__, "enable_geo_fencing", enable_geo_fencing)
        if geos is not None:
            pulumi.set(__self__, "geos", geos)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if primary_backup is not None:
            pulumi.set(__self__, "primary_backup", primary_backup)
        if wrrs is not None:
            pulumi.set(__self__, "wrrs", wrrs)

    @property
    @pulumi.getter(name="enableGeoFencing")
    def enable_geo_fencing(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable fencing for geo queries.
        """
        return pulumi.get(self, "enable_geo_fencing")

    @property
    @pulumi.getter
    def geos(self) -> Optional[Sequence['outputs.RecordSetRoutingPolicyGeo']]:
        """
        The configuration for Geolocation based routing policy.
        Structure is documented below.
        """
        return pulumi.get(self, "geos")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[builtins.str]:
        """
        Specifies the health check (used with external endpoints).
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="primaryBackup")
    def primary_backup(self) -> Optional['outputs.RecordSetRoutingPolicyPrimaryBackup']:
        """
        The configuration for a failover policy with global to regional failover. Queries are responded to with the global primary targets, but if none of the primary targets are healthy, then we fallback to a regional failover policy.
        Structure is documented below.
        """
        return pulumi.get(self, "primary_backup")

    @property
    @pulumi.getter
    def wrrs(self) -> Optional[Sequence['outputs.RecordSetRoutingPolicyWrr']]:
        """
        The configuration for Weighted Round Robin based routing policy.
        Structure is documented below.
        """
        return pulumi.get(self, "wrrs")


@pulumi.output_type
class RecordSetRoutingPolicyGeo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckedTargets":
            suggest = "health_checked_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyGeo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyGeo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyGeo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 health_checked_targets: Optional['outputs.RecordSetRoutingPolicyGeoHealthCheckedTargets'] = None,
                 rrdatas: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str location: The location name defined in Google Cloud.
        :param 'RecordSetRoutingPolicyGeoHealthCheckedTargetsArgs' health_checked_targets: For A and AAAA types only. The list of targets to be health checked. These can be specified along with `rrdatas` within this item.
               Structure is documented below.
        :param Sequence[builtins.str] rrdatas: Same as `rrdatas` above.
        """
        pulumi.set(__self__, "location", location)
        if health_checked_targets is not None:
            pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location name defined in Google Cloud.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> Optional['outputs.RecordSetRoutingPolicyGeoHealthCheckedTargets']:
        """
        For A and AAAA types only. The list of targets to be health checked. These can be specified along with `rrdatas` within this item.
        Structure is documented below.
        """
        return pulumi.get(self, "health_checked_targets")

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[Sequence[builtins.str]]:
        """
        Same as `rrdatas` above.
        """
        return pulumi.get(self, "rrdatas")


@pulumi.output_type
class RecordSetRoutingPolicyGeoHealthCheckedTargets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalEndpoints":
            suggest = "external_endpoints"
        elif key == "internalLoadBalancers":
            suggest = "internal_load_balancers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyGeoHealthCheckedTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyGeoHealthCheckedTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyGeoHealthCheckedTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_endpoints: Optional[Sequence[builtins.str]] = None,
                 internal_load_balancers: Optional[Sequence['outputs.RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancer']] = None):
        """
        :param Sequence[builtins.str] external_endpoints: The list of external endpoint addresses to health check.
        :param Sequence['RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancerArgs'] internal_load_balancers: The list of internal load balancers to health check.
               Structure is documented below.
        """
        if external_endpoints is not None:
            pulumi.set(__self__, "external_endpoints", external_endpoints)
        if internal_load_balancers is not None:
            pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="externalEndpoints")
    def external_endpoints(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of external endpoint addresses to health check.
        """
        return pulumi.get(self, "external_endpoints")

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> Optional[Sequence['outputs.RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancer']]:
        """
        The list of internal load balancers to health check.
        Structure is documented below.
        """
        return pulumi.get(self, "internal_load_balancers")


@pulumi.output_type
class RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipProtocol":
            suggest = "ip_protocol"
        elif key == "networkUrl":
            suggest = "network_url"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: builtins.str,
                 ip_protocol: builtins.str,
                 network_url: builtins.str,
                 port: builtins.str,
                 project: builtins.str,
                 load_balancer_type: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str ip_address: The frontend IP address of the load balancer.
        :param builtins.str ip_protocol: The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        :param builtins.str network_url: The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        :param builtins.str port: The configured port of the load balancer.
        :param builtins.str project: The ID of the project in which the load balancer belongs.
        :param builtins.str load_balancer_type: The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb", "regionalL7ilb", "globalL7ilb"]
        :param builtins.str region: The region of the load balancer. Only needed for regional load balancers.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The frontend IP address of the load balancer.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> builtins.str:
        """
        The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> builtins.str:
        """
        The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        """
        return pulumi.get(self, "network_url")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        The configured port of the load balancer.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID of the project in which the load balancer belongs.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[builtins.str]:
        """
        The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb", "regionalL7ilb", "globalL7ilb"]
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region of the load balancer. Only needed for regional load balancers.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class RecordSetRoutingPolicyPrimaryBackup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupGeos":
            suggest = "backup_geos"
        elif key == "enableGeoFencingForBackups":
            suggest = "enable_geo_fencing_for_backups"
        elif key == "trickleRatio":
            suggest = "trickle_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyPrimaryBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyPrimaryBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyPrimaryBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_geos: Sequence['outputs.RecordSetRoutingPolicyPrimaryBackupBackupGeo'],
                 primary: 'outputs.RecordSetRoutingPolicyPrimaryBackupPrimary',
                 enable_geo_fencing_for_backups: Optional[builtins.bool] = None,
                 trickle_ratio: Optional[builtins.float] = None):
        """
        :param Sequence['RecordSetRoutingPolicyPrimaryBackupBackupGeoArgs'] backup_geos: The backup geo targets, which provide a regional failover policy for the otherwise global primary targets.
               Structure is document above.
        :param 'RecordSetRoutingPolicyPrimaryBackupPrimaryArgs' primary: The list of global primary targets to be health checked.
               Structure is documented below.
        :param builtins.bool enable_geo_fencing_for_backups: Specifies whether to enable fencing for backup geo queries.
        :param builtins.float trickle_ratio: Specifies the percentage of traffic to send to the backup targets even when the primary targets are healthy.
        """
        pulumi.set(__self__, "backup_geos", backup_geos)
        pulumi.set(__self__, "primary", primary)
        if enable_geo_fencing_for_backups is not None:
            pulumi.set(__self__, "enable_geo_fencing_for_backups", enable_geo_fencing_for_backups)
        if trickle_ratio is not None:
            pulumi.set(__self__, "trickle_ratio", trickle_ratio)

    @property
    @pulumi.getter(name="backupGeos")
    def backup_geos(self) -> Sequence['outputs.RecordSetRoutingPolicyPrimaryBackupBackupGeo']:
        """
        The backup geo targets, which provide a regional failover policy for the otherwise global primary targets.
        Structure is document above.
        """
        return pulumi.get(self, "backup_geos")

    @property
    @pulumi.getter
    def primary(self) -> 'outputs.RecordSetRoutingPolicyPrimaryBackupPrimary':
        """
        The list of global primary targets to be health checked.
        Structure is documented below.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="enableGeoFencingForBackups")
    def enable_geo_fencing_for_backups(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable fencing for backup geo queries.
        """
        return pulumi.get(self, "enable_geo_fencing_for_backups")

    @property
    @pulumi.getter(name="trickleRatio")
    def trickle_ratio(self) -> Optional[builtins.float]:
        """
        Specifies the percentage of traffic to send to the backup targets even when the primary targets are healthy.
        """
        return pulumi.get(self, "trickle_ratio")


@pulumi.output_type
class RecordSetRoutingPolicyPrimaryBackupBackupGeo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckedTargets":
            suggest = "health_checked_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyPrimaryBackupBackupGeo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyPrimaryBackupBackupGeo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyPrimaryBackupBackupGeo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 health_checked_targets: Optional['outputs.RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets'] = None,
                 rrdatas: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str location: The location name defined in Google Cloud.
        :param 'RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsArgs' health_checked_targets: For A and AAAA types only. The list of targets to be health checked. These can be specified along with `rrdatas` within this item.
        """
        pulumi.set(__self__, "location", location)
        if health_checked_targets is not None:
            pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location name defined in Google Cloud.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> Optional['outputs.RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets']:
        """
        For A and AAAA types only. The list of targets to be health checked. These can be specified along with `rrdatas` within this item.
        """
        return pulumi.get(self, "health_checked_targets")

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "rrdatas")


@pulumi.output_type
class RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalEndpoints":
            suggest = "external_endpoints"
        elif key == "internalLoadBalancers":
            suggest = "internal_load_balancers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_endpoints: Optional[Sequence[builtins.str]] = None,
                 internal_load_balancers: Optional[Sequence['outputs.RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancer']] = None):
        """
        :param Sequence[builtins.str] external_endpoints: The list of external endpoint addresses to health check.
        :param Sequence['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancerArgs'] internal_load_balancers: The list of internal load balancers to health check.
               Structure is documented below.
        """
        if external_endpoints is not None:
            pulumi.set(__self__, "external_endpoints", external_endpoints)
        if internal_load_balancers is not None:
            pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="externalEndpoints")
    def external_endpoints(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of external endpoint addresses to health check.
        """
        return pulumi.get(self, "external_endpoints")

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> Optional[Sequence['outputs.RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancer']]:
        """
        The list of internal load balancers to health check.
        Structure is documented below.
        """
        return pulumi.get(self, "internal_load_balancers")


@pulumi.output_type
class RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipProtocol":
            suggest = "ip_protocol"
        elif key == "networkUrl":
            suggest = "network_url"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: builtins.str,
                 ip_protocol: builtins.str,
                 network_url: builtins.str,
                 port: builtins.str,
                 project: builtins.str,
                 load_balancer_type: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str ip_address: The frontend IP address of the load balancer.
        :param builtins.str ip_protocol: The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        :param builtins.str network_url: The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        :param builtins.str port: The configured port of the load balancer.
        :param builtins.str project: The ID of the project in which the load balancer belongs.
        :param builtins.str load_balancer_type: The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb", "regionalL7ilb", "globalL7ilb"]
        :param builtins.str region: The region of the load balancer. Only needed for regional load balancers.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The frontend IP address of the load balancer.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> builtins.str:
        """
        The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> builtins.str:
        """
        The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        """
        return pulumi.get(self, "network_url")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        The configured port of the load balancer.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID of the project in which the load balancer belongs.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[builtins.str]:
        """
        The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb", "regionalL7ilb", "globalL7ilb"]
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region of the load balancer. Only needed for regional load balancers.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class RecordSetRoutingPolicyPrimaryBackupPrimary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalEndpoints":
            suggest = "external_endpoints"
        elif key == "internalLoadBalancers":
            suggest = "internal_load_balancers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyPrimaryBackupPrimary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyPrimaryBackupPrimary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyPrimaryBackupPrimary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_endpoints: Optional[Sequence[builtins.str]] = None,
                 internal_load_balancers: Optional[Sequence['outputs.RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancer']] = None):
        """
        :param Sequence[builtins.str] external_endpoints: The Internet IP addresses to be health checked.
        :param Sequence['RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancerArgs'] internal_load_balancers: The list of internal load balancers to health check.
        """
        if external_endpoints is not None:
            pulumi.set(__self__, "external_endpoints", external_endpoints)
        if internal_load_balancers is not None:
            pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="externalEndpoints")
    def external_endpoints(self) -> Optional[Sequence[builtins.str]]:
        """
        The Internet IP addresses to be health checked.
        """
        return pulumi.get(self, "external_endpoints")

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> Optional[Sequence['outputs.RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancer']]:
        """
        The list of internal load balancers to health check.
        """
        return pulumi.get(self, "internal_load_balancers")


@pulumi.output_type
class RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipProtocol":
            suggest = "ip_protocol"
        elif key == "networkUrl":
            suggest = "network_url"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: builtins.str,
                 ip_protocol: builtins.str,
                 network_url: builtins.str,
                 port: builtins.str,
                 project: builtins.str,
                 load_balancer_type: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str ip_address: The frontend IP address of the load balancer.
        :param builtins.str ip_protocol: The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        :param builtins.str network_url: The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        :param builtins.str port: The configured port of the load balancer.
        :param builtins.str project: The ID of the project in which the load balancer belongs.
        :param builtins.str load_balancer_type: The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb", "regionalL7ilb", "globalL7ilb"]
        :param builtins.str region: The region of the load balancer. Only needed for regional load balancers.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The frontend IP address of the load balancer.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> builtins.str:
        """
        The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> builtins.str:
        """
        The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        """
        return pulumi.get(self, "network_url")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        The configured port of the load balancer.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID of the project in which the load balancer belongs.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[builtins.str]:
        """
        The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb", "regionalL7ilb", "globalL7ilb"]
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region of the load balancer. Only needed for regional load balancers.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class RecordSetRoutingPolicyWrr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckedTargets":
            suggest = "health_checked_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyWrr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyWrr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyWrr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 weight: builtins.float,
                 health_checked_targets: Optional['outputs.RecordSetRoutingPolicyWrrHealthCheckedTargets'] = None,
                 rrdatas: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.float weight: The ratio of traffic routed to the target.
        :param 'RecordSetRoutingPolicyWrrHealthCheckedTargetsArgs' health_checked_targets: The list of targets to be health checked. Note that if DNSSEC is enabled for this zone, only one of `rrdatas` or `health_checked_targets` can be set.
               Structure is documented below.
        :param Sequence[builtins.str] rrdatas: Same as `rrdatas` above.
        """
        pulumi.set(__self__, "weight", weight)
        if health_checked_targets is not None:
            pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)

    @property
    @pulumi.getter
    def weight(self) -> builtins.float:
        """
        The ratio of traffic routed to the target.
        """
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> Optional['outputs.RecordSetRoutingPolicyWrrHealthCheckedTargets']:
        """
        The list of targets to be health checked. Note that if DNSSEC is enabled for this zone, only one of `rrdatas` or `health_checked_targets` can be set.
        Structure is documented below.
        """
        return pulumi.get(self, "health_checked_targets")

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[Sequence[builtins.str]]:
        """
        Same as `rrdatas` above.
        """
        return pulumi.get(self, "rrdatas")


@pulumi.output_type
class RecordSetRoutingPolicyWrrHealthCheckedTargets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalEndpoints":
            suggest = "external_endpoints"
        elif key == "internalLoadBalancers":
            suggest = "internal_load_balancers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyWrrHealthCheckedTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyWrrHealthCheckedTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyWrrHealthCheckedTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_endpoints: Optional[Sequence[builtins.str]] = None,
                 internal_load_balancers: Optional[Sequence['outputs.RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancer']] = None):
        """
        :param Sequence[builtins.str] external_endpoints: The list of external endpoint addresses to health check.
        :param Sequence['RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancerArgs'] internal_load_balancers: The list of internal load balancers to health check.
               Structure is documented below.
        """
        if external_endpoints is not None:
            pulumi.set(__self__, "external_endpoints", external_endpoints)
        if internal_load_balancers is not None:
            pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="externalEndpoints")
    def external_endpoints(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of external endpoint addresses to health check.
        """
        return pulumi.get(self, "external_endpoints")

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> Optional[Sequence['outputs.RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancer']]:
        """
        The list of internal load balancers to health check.
        Structure is documented below.
        """
        return pulumi.get(self, "internal_load_balancers")


@pulumi.output_type
class RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipProtocol":
            suggest = "ip_protocol"
        elif key == "networkUrl":
            suggest = "network_url"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: builtins.str,
                 ip_protocol: builtins.str,
                 network_url: builtins.str,
                 port: builtins.str,
                 project: builtins.str,
                 load_balancer_type: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str ip_address: The frontend IP address of the load balancer.
        :param builtins.str ip_protocol: The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        :param builtins.str network_url: The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        :param builtins.str port: The configured port of the load balancer.
        :param builtins.str project: The ID of the project in which the load balancer belongs.
        :param builtins.str load_balancer_type: The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb", "regionalL7ilb", "globalL7ilb"]
        :param builtins.str region: The region of the load balancer. Only needed for regional load balancers.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The frontend IP address of the load balancer.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> builtins.str:
        """
        The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> builtins.str:
        """
        The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        """
        return pulumi.get(self, "network_url")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        The configured port of the load balancer.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID of the project in which the load balancer belongs.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[builtins.str]:
        """
        The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb", "regionalL7ilb", "globalL7ilb"]
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region of the load balancer. Only needed for regional load balancers.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ResponsePolicyGkeCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusterName":
            suggest = "gke_cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyGkeCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyGkeCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyGkeCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_cluster_name: builtins.str):
        """
        :param builtins.str gke_cluster_name: The resource name of the cluster to bind this ManagedZone to.
               This should be specified in the format like
               `projects/*/locations/*/clusters/*`
        """
        pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> builtins.str:
        """
        The resource name of the cluster to bind this ManagedZone to.
        This should be specified in the format like
        `projects/*/locations/*/clusters/*`
        """
        return pulumi.get(self, "gke_cluster_name")


@pulumi.output_type
class ResponsePolicyNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_url: builtins.str):
        """
        :param builtins.str network_url: The fully qualified URL of the VPC network to bind to.
               This should be formatted like
               `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> builtins.str:
        """
        The fully qualified URL of the VPC network to bind to.
        This should be formatted like
        `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ResponsePolicyRuleLocalData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localDatas":
            suggest = "local_datas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyRuleLocalData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyRuleLocalData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyRuleLocalData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_datas: Sequence['outputs.ResponsePolicyRuleLocalDataLocalData']):
        """
        :param Sequence['ResponsePolicyRuleLocalDataLocalDataArgs'] local_datas: All resource record sets for this selector, one per resource record type. The name must match the dns_name.
               Structure is documented below.
        """
        pulumi.set(__self__, "local_datas", local_datas)

    @property
    @pulumi.getter(name="localDatas")
    def local_datas(self) -> Sequence['outputs.ResponsePolicyRuleLocalDataLocalData']:
        """
        All resource record sets for this selector, one per resource record type. The name must match the dns_name.
        Structure is documented below.
        """
        return pulumi.get(self, "local_datas")


@pulumi.output_type
class ResponsePolicyRuleLocalDataLocalData(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str,
                 rrdatas: Optional[Sequence[builtins.str]] = None,
                 ttl: Optional[builtins.int] = None):
        """
        :param builtins.str name: For example, www.example.com.
        :param builtins.str type: One of valid DNS resource types.
               Possible values are: `A`, `AAAA`, `CAA`, `CNAME`, `DNSKEY`, `DS`, `HTTPS`, `IPSECVPNKEY`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV`, `SSHFP`, `SVCB`, `TLSA`, `TXT`.
        :param Sequence[builtins.str] rrdatas: As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1)
        :param builtins.int ttl: Number of seconds that this ResourceRecordSet can be cached by
               resolvers.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        For example, www.example.com.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        One of valid DNS resource types.
        Possible values are: `A`, `AAAA`, `CAA`, `CNAME`, `DNSKEY`, `DS`, `HTTPS`, `IPSECVPNKEY`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV`, `SSHFP`, `SVCB`, `TLSA`, `TXT`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[Sequence[builtins.str]]:
        """
        As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1)
        """
        return pulumi.get(self, "rrdatas")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[builtins.int]:
        """
        Number of seconds that this ResourceRecordSet can be cached by
        resolvers.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetKeysKeySigningKeyResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 creation_time: builtins.str,
                 description: builtins.str,
                 digests: Sequence['outputs.GetKeysKeySigningKeyDigestResult'],
                 ds_record: builtins.str,
                 id: builtins.str,
                 is_active: builtins.bool,
                 key_length: builtins.int,
                 key_tag: builtins.int,
                 public_key: builtins.str):
        """
        :param builtins.str algorithm: String mnemonic specifying the DNSSEC algorithm of this key. Immutable after creation time. Possible values are `ecdsap256sha256`, `ecdsap384sha384`, `rsasha1`, `rsasha256`, and `rsasha512`.
        :param builtins.str creation_time: The time that this resource was created in the control plane. This is in RFC3339 text format.
        :param builtins.str description: A mutable string of at most 1024 characters associated with this resource for the user's convenience.
        :param Sequence['GetKeysKeySigningKeyDigestArgs'] digests: A list of cryptographic hashes of the DNSKEY resource record associated with this DnsKey. These digests are needed to construct a DS record that points at this DNS key. Each contains:
        :param builtins.str ds_record: The DS record based on the KSK record. This is used when [delegating](https://cloud.google.com/dns/docs/dnssec-advanced#subdelegation) DNSSEC-signed subdomains.
        :param builtins.str id: Unique identifier for the resource; defined by the server.
        :param builtins.bool is_active: Active keys will be used to sign subsequent changes to the ManagedZone. Inactive keys will still be present as DNSKEY Resource Records for the use of resolvers validating existing signatures.
        :param builtins.int key_length: Length of the key in bits. Specified at creation time then immutable.
        :param builtins.int key_tag: The key tag is a non-cryptographic hash of the a DNSKEY resource record associated with this DnsKey. The key tag can be used to identify a DNSKEY more quickly (but it is not a unique identifier). In particular, the key tag is used in a parent zone's DS record to point at the DNSKEY in this child ManagedZone. The key tag is a number in the range [0, 65535] and the algorithm to calculate it is specified in RFC4034 Appendix B.
        :param builtins.str public_key: Base64 encoded public half of this key.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "digests", digests)
        pulumi.set(__self__, "ds_record", ds_record)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_active", is_active)
        pulumi.set(__self__, "key_length", key_length)
        pulumi.set(__self__, "key_tag", key_tag)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        String mnemonic specifying the DNSSEC algorithm of this key. Immutable after creation time. Possible values are `ecdsap256sha256`, `ecdsap384sha384`, `rsasha1`, `rsasha256`, and `rsasha512`.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> builtins.str:
        """
        The time that this resource was created in the control plane. This is in RFC3339 text format.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A mutable string of at most 1024 characters associated with this resource for the user's convenience.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def digests(self) -> Sequence['outputs.GetKeysKeySigningKeyDigestResult']:
        """
        A list of cryptographic hashes of the DNSKEY resource record associated with this DnsKey. These digests are needed to construct a DS record that points at this DNS key. Each contains:
        """
        return pulumi.get(self, "digests")

    @property
    @pulumi.getter(name="dsRecord")
    def ds_record(self) -> builtins.str:
        """
        The DS record based on the KSK record. This is used when [delegating](https://cloud.google.com/dns/docs/dnssec-advanced#subdelegation) DNSSEC-signed subdomains.
        """
        return pulumi.get(self, "ds_record")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier for the resource; defined by the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> builtins.bool:
        """
        Active keys will be used to sign subsequent changes to the ManagedZone. Inactive keys will still be present as DNSKEY Resource Records for the use of resolvers validating existing signatures.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> builtins.int:
        """
        Length of the key in bits. Specified at creation time then immutable.
        """
        return pulumi.get(self, "key_length")

    @property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> builtins.int:
        """
        The key tag is a non-cryptographic hash of the a DNSKEY resource record associated with this DnsKey. The key tag can be used to identify a DNSKEY more quickly (but it is not a unique identifier). In particular, the key tag is used in a parent zone's DS record to point at the DNSKEY in this child ManagedZone. The key tag is a number in the range [0, 65535] and the algorithm to calculate it is specified in RFC4034 Appendix B.
        """
        return pulumi.get(self, "key_tag")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> builtins.str:
        """
        Base64 encoded public half of this key.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetKeysKeySigningKeyDigestResult(dict):
    def __init__(__self__, *,
                 digest: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str digest: The base-16 encoded bytes of this digest. Suitable for use in a DS resource record.
        :param builtins.str type: Specifies the algorithm used to calculate this digest. Possible values are `sha1`, `sha256` and `sha384`
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def digest(self) -> Optional[builtins.str]:
        """
        The base-16 encoded bytes of this digest. Suitable for use in a DS resource record.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Specifies the algorithm used to calculate this digest. Possible values are `sha1`, `sha256` and `sha384`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetKeysZoneSigningKeyResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 creation_time: builtins.str,
                 description: builtins.str,
                 digests: Sequence['outputs.GetKeysZoneSigningKeyDigestResult'],
                 id: builtins.str,
                 is_active: builtins.bool,
                 key_length: builtins.int,
                 key_tag: builtins.int,
                 public_key: builtins.str):
        """
        :param builtins.str algorithm: String mnemonic specifying the DNSSEC algorithm of this key. Immutable after creation time. Possible values are `ecdsap256sha256`, `ecdsap384sha384`, `rsasha1`, `rsasha256`, and `rsasha512`.
        :param builtins.str creation_time: The time that this resource was created in the control plane. This is in RFC3339 text format.
        :param builtins.str description: A mutable string of at most 1024 characters associated with this resource for the user's convenience.
        :param Sequence['GetKeysZoneSigningKeyDigestArgs'] digests: A list of cryptographic hashes of the DNSKEY resource record associated with this DnsKey. These digests are needed to construct a DS record that points at this DNS key. Each contains:
        :param builtins.str id: Unique identifier for the resource; defined by the server.
        :param builtins.bool is_active: Active keys will be used to sign subsequent changes to the ManagedZone. Inactive keys will still be present as DNSKEY Resource Records for the use of resolvers validating existing signatures.
        :param builtins.int key_length: Length of the key in bits. Specified at creation time then immutable.
        :param builtins.int key_tag: The key tag is a non-cryptographic hash of the a DNSKEY resource record associated with this DnsKey. The key tag can be used to identify a DNSKEY more quickly (but it is not a unique identifier). In particular, the key tag is used in a parent zone's DS record to point at the DNSKEY in this child ManagedZone. The key tag is a number in the range [0, 65535] and the algorithm to calculate it is specified in RFC4034 Appendix B.
        :param builtins.str public_key: Base64 encoded public half of this key.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "digests", digests)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_active", is_active)
        pulumi.set(__self__, "key_length", key_length)
        pulumi.set(__self__, "key_tag", key_tag)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        String mnemonic specifying the DNSSEC algorithm of this key. Immutable after creation time. Possible values are `ecdsap256sha256`, `ecdsap384sha384`, `rsasha1`, `rsasha256`, and `rsasha512`.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> builtins.str:
        """
        The time that this resource was created in the control plane. This is in RFC3339 text format.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A mutable string of at most 1024 characters associated with this resource for the user's convenience.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def digests(self) -> Sequence['outputs.GetKeysZoneSigningKeyDigestResult']:
        """
        A list of cryptographic hashes of the DNSKEY resource record associated with this DnsKey. These digests are needed to construct a DS record that points at this DNS key. Each contains:
        """
        return pulumi.get(self, "digests")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier for the resource; defined by the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> builtins.bool:
        """
        Active keys will be used to sign subsequent changes to the ManagedZone. Inactive keys will still be present as DNSKEY Resource Records for the use of resolvers validating existing signatures.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> builtins.int:
        """
        Length of the key in bits. Specified at creation time then immutable.
        """
        return pulumi.get(self, "key_length")

    @property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> builtins.int:
        """
        The key tag is a non-cryptographic hash of the a DNSKEY resource record associated with this DnsKey. The key tag can be used to identify a DNSKEY more quickly (but it is not a unique identifier). In particular, the key tag is used in a parent zone's DS record to point at the DNSKEY in this child ManagedZone. The key tag is a number in the range [0, 65535] and the algorithm to calculate it is specified in RFC4034 Appendix B.
        """
        return pulumi.get(self, "key_tag")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> builtins.str:
        """
        Base64 encoded public half of this key.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetKeysZoneSigningKeyDigestResult(dict):
    def __init__(__self__, *,
                 digest: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str digest: The base-16 encoded bytes of this digest. Suitable for use in a DS resource record.
        :param builtins.str type: Specifies the algorithm used to calculate this digest. Possible values are `sha1`, `sha256` and `sha384`
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def digest(self) -> Optional[builtins.str]:
        """
        The base-16 encoded bytes of this digest. Suitable for use in a DS resource record.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Specifies the algorithm used to calculate this digest. Possible values are `sha1`, `sha256` and `sha384`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetManagedZonesManagedZoneResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 dns_name: builtins.str,
                 id: builtins.str,
                 managed_zone_id: builtins.str,
                 name_servers: Sequence[builtins.str],
                 visibility: builtins.str,
                 name: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None):
        """
        :param builtins.str project: The ID of the project containing Google Cloud DNS zones. If this is not provided the default project will be used.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "managed_zone_id", managed_zone_id)
        pulumi.set(__self__, "name_servers", name_servers)
        pulumi.set(__self__, "visibility", visibility)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> builtins.str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedZoneId")
    def managed_zone_id(self) -> builtins.str:
        return pulumi.get(self, "managed_zone_id")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter
    def visibility(self) -> builtins.str:
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        """
        The ID of the project containing Google Cloud DNS zones. If this is not provided the default project will be used.
        """
        return pulumi.get(self, "project")


