# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 authorization: pulumi.Input['ClusterAuthorizationArgs'],
                 fleet: pulumi.Input['ClusterFleetArgs'],
                 location: pulumi.Input[builtins.str],
                 networking: pulumi.Input['ClusterNetworkingArgs'],
                 control_plane: Optional[pulumi.Input['ClusterControlPlaneArgs']] = None,
                 control_plane_encryption: Optional[pulumi.Input['ClusterControlPlaneEncryptionArgs']] = None,
                 default_max_pods_per_node: Optional[pulumi.Input[builtins.int]] = None,
                 external_load_balancer_ipv4_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 release_channel: Optional[pulumi.Input[builtins.str]] = None,
                 system_addons_config: Optional[pulumi.Input['ClusterSystemAddonsConfigArgs']] = None,
                 target_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['ClusterAuthorizationArgs'] authorization: RBAC policy that will be applied and managed by GEC.
               Structure is documented below.
        :param pulumi.Input['ClusterFleetArgs'] fleet: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input['ClusterNetworkingArgs'] networking: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               Structure is documented below.
        :param pulumi.Input['ClusterControlPlaneArgs'] control_plane: The configuration of the cluster control plane.
               Structure is documented below.
        :param pulumi.Input['ClusterControlPlaneEncryptionArgs'] control_plane_encryption: Remote control plane disk encryption options. This field is only used when
               enabling CMEK support.
               Structure is documented below.
        :param pulumi.Input[builtins.int] default_max_pods_per_node: The default maximum number of pods per node used if a maximum value is not
               specified explicitly for a node pool in this cluster. If unspecified, the
               Kubernetes default value will be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_load_balancer_ipv4_address_pools: Address pools for cluster data plane external load balancing.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the edgecloud cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['ClusterMaintenancePolicyArgs'] maintenance_policy: Cluster-wide maintenance policy configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The GDCE cluster name.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] release_channel: The release channel a cluster is subscribed to.
               Possible values are: `RELEASE_CHANNEL_UNSPECIFIED`, `NONE`, `REGULAR`.
        :param pulumi.Input['ClusterSystemAddonsConfigArgs'] system_addons_config: Config that customers are allowed to define for GDCE system add-ons.
               Structure is documented below.
        :param pulumi.Input[builtins.str] target_version: The target cluster version. For example: "1.5.0".
        """
        pulumi.set(__self__, "authorization", authorization)
        pulumi.set(__self__, "fleet", fleet)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "networking", networking)
        if control_plane is not None:
            pulumi.set(__self__, "control_plane", control_plane)
        if control_plane_encryption is not None:
            pulumi.set(__self__, "control_plane_encryption", control_plane_encryption)
        if default_max_pods_per_node is not None:
            pulumi.set(__self__, "default_max_pods_per_node", default_max_pods_per_node)
        if external_load_balancer_ipv4_address_pools is not None:
            pulumi.set(__self__, "external_load_balancer_ipv4_address_pools", external_load_balancer_ipv4_address_pools)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if release_channel is not None:
            pulumi.set(__self__, "release_channel", release_channel)
        if system_addons_config is not None:
            pulumi.set(__self__, "system_addons_config", system_addons_config)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Input['ClusterAuthorizationArgs']:
        """
        RBAC policy that will be applied and managed by GEC.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: pulumi.Input['ClusterAuthorizationArgs']):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Input['ClusterFleetArgs']:
        """
        Fleet related configuration.
        Fleets are a Google Cloud concept for logically organizing clusters,
        letting you use and manage multi-cluster capabilities and apply
        consistent policies across your systems.
        Structure is documented below.
        """
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: pulumi.Input['ClusterFleetArgs']):
        pulumi.set(self, "fleet", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Input['ClusterNetworkingArgs']:
        """
        Fleet related configuration.
        Fleets are a Google Cloud concept for logically organizing clusters,
        letting you use and manage multi-cluster capabilities and apply
        consistent policies across your systems.
        Structure is documented below.
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: pulumi.Input['ClusterNetworkingArgs']):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> Optional[pulumi.Input['ClusterControlPlaneArgs']]:
        """
        The configuration of the cluster control plane.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: Optional[pulumi.Input['ClusterControlPlaneArgs']]):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter(name="controlPlaneEncryption")
    def control_plane_encryption(self) -> Optional[pulumi.Input['ClusterControlPlaneEncryptionArgs']]:
        """
        Remote control plane disk encryption options. This field is only used when
        enabling CMEK support.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_encryption")

    @control_plane_encryption.setter
    def control_plane_encryption(self, value: Optional[pulumi.Input['ClusterControlPlaneEncryptionArgs']]):
        pulumi.set(self, "control_plane_encryption", value)

    @property
    @pulumi.getter(name="defaultMaxPodsPerNode")
    def default_max_pods_per_node(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default maximum number of pods per node used if a maximum value is not
        specified explicitly for a node pool in this cluster. If unspecified, the
        Kubernetes default value will be used.
        """
        return pulumi.get(self, "default_max_pods_per_node")

    @default_max_pods_per_node.setter
    def default_max_pods_per_node(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_max_pods_per_node", value)

    @property
    @pulumi.getter(name="externalLoadBalancerIpv4AddressPools")
    def external_load_balancer_ipv4_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Address pools for cluster data plane external load balancing.
        """
        return pulumi.get(self, "external_load_balancer_ipv4_address_pools")

    @external_load_balancer_ipv4_address_pools.setter
    def external_load_balancer_ipv4_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "external_load_balancer_ipv4_address_pools", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the edgecloud cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]:
        """
        Cluster-wide maintenance policy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GDCE cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The release channel a cluster is subscribed to.
        Possible values are: `RELEASE_CHANNEL_UNSPECIFIED`, `NONE`, `REGULAR`.
        """
        return pulumi.get(self, "release_channel")

    @release_channel.setter
    def release_channel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_channel", value)

    @property
    @pulumi.getter(name="systemAddonsConfig")
    def system_addons_config(self) -> Optional[pulumi.Input['ClusterSystemAddonsConfigArgs']]:
        """
        Config that customers are allowed to define for GDCE system add-ons.
        Structure is documented below.
        """
        return pulumi.get(self, "system_addons_config")

    @system_addons_config.setter
    def system_addons_config(self, value: Optional[pulumi.Input['ClusterSystemAddonsConfigArgs']]):
        pulumi.set(self, "system_addons_config", value)

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The target cluster version. For example: "1.5.0".
        """
        return pulumi.get(self, "target_version")

    @target_version.setter
    def target_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_version", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 authorization: Optional[pulumi.Input['ClusterAuthorizationArgs']] = None,
                 cluster_ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 control_plane: Optional[pulumi.Input['ClusterControlPlaneArgs']] = None,
                 control_plane_encryption: Optional[pulumi.Input['ClusterControlPlaneEncryptionArgs']] = None,
                 control_plane_version: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 default_max_pods_per_node: Optional[pulumi.Input[builtins.int]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 external_load_balancer_ipv4_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 fleet: Optional[pulumi.Input['ClusterFleetArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_events: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceEventArgs']]]] = None,
                 maintenance_policy: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networking: Optional[pulumi.Input['ClusterNetworkingArgs']] = None,
                 node_version: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 release_channel: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 system_addons_config: Optional[pulumi.Input['ClusterSystemAddonsConfigArgs']] = None,
                 target_version: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input['ClusterAuthorizationArgs'] authorization: RBAC policy that will be applied and managed by GEC.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster_ca_certificate: The PEM-encoded public certificate of the cluster's CA.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input['ClusterControlPlaneArgs'] control_plane: The configuration of the cluster control plane.
               Structure is documented below.
        :param pulumi.Input['ClusterControlPlaneEncryptionArgs'] control_plane_encryption: Remote control plane disk encryption options. This field is only used when
               enabling CMEK support.
               Structure is documented below.
        :param pulumi.Input[builtins.str] control_plane_version: The control plane release version.
        :param pulumi.Input[builtins.str] create_time: (Output)
               The time when the maintenance event request was created.
        :param pulumi.Input[builtins.int] default_max_pods_per_node: The default maximum number of pods per node used if a maximum value is not
               specified explicitly for a node pool in this cluster. If unspecified, the
               Kubernetes default value will be used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] endpoint: The IP address of the Kubernetes API server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_load_balancer_ipv4_address_pools: Address pools for cluster data plane external load balancing.
        :param pulumi.Input['ClusterFleetArgs'] fleet: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the edgecloud cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceEventArgs']]] maintenance_events: All the maintenance events scheduled for the cluster, including the ones
               ongoing, planned for the future and done in the past (up to 90 days).
               Structure is documented below.
        :param pulumi.Input['ClusterMaintenancePolicyArgs'] maintenance_policy: Cluster-wide maintenance policy configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The GDCE cluster name.
        :param pulumi.Input['ClusterNetworkingArgs'] networking: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               Structure is documented below.
        :param pulumi.Input[builtins.str] node_version: The lowest release version among all worker nodes. This field can be empty
               if the cluster does not have any worker nodes.
        :param pulumi.Input[builtins.int] port: The port number of the Kubernetes API server.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] release_channel: The release channel a cluster is subscribed to.
               Possible values are: `RELEASE_CHANNEL_UNSPECIFIED`, `NONE`, `REGULAR`.
        :param pulumi.Input[builtins.str] status: Indicates the status of the cluster.
        :param pulumi.Input['ClusterSystemAddonsConfigArgs'] system_addons_config: Config that customers are allowed to define for GDCE system add-ons.
               Structure is documented below.
        :param pulumi.Input[builtins.str] target_version: The target cluster version. For example: "1.5.0".
        :param pulumi.Input[builtins.str] update_time: (Output)
               The time when the maintenance event message was updated.
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if control_plane is not None:
            pulumi.set(__self__, "control_plane", control_plane)
        if control_plane_encryption is not None:
            pulumi.set(__self__, "control_plane_encryption", control_plane_encryption)
        if control_plane_version is not None:
            pulumi.set(__self__, "control_plane_version", control_plane_version)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if default_max_pods_per_node is not None:
            pulumi.set(__self__, "default_max_pods_per_node", default_max_pods_per_node)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if external_load_balancer_ipv4_address_pools is not None:
            pulumi.set(__self__, "external_load_balancer_ipv4_address_pools", external_load_balancer_ipv4_address_pools)
        if fleet is not None:
            pulumi.set(__self__, "fleet", fleet)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_events is not None:
            pulumi.set(__self__, "maintenance_events", maintenance_events)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if node_version is not None:
            pulumi.set(__self__, "node_version", node_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if release_channel is not None:
            pulumi.set(__self__, "release_channel", release_channel)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_addons_config is not None:
            pulumi.set(__self__, "system_addons_config", system_addons_config)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['ClusterAuthorizationArgs']]:
        """
        RBAC policy that will be applied and managed by GEC.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['ClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PEM-encoded public certificate of the cluster's CA.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @cluster_ca_certificate.setter
    def cluster_ca_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_ca_certificate", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> Optional[pulumi.Input['ClusterControlPlaneArgs']]:
        """
        The configuration of the cluster control plane.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: Optional[pulumi.Input['ClusterControlPlaneArgs']]):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter(name="controlPlaneEncryption")
    def control_plane_encryption(self) -> Optional[pulumi.Input['ClusterControlPlaneEncryptionArgs']]:
        """
        Remote control plane disk encryption options. This field is only used when
        enabling CMEK support.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_encryption")

    @control_plane_encryption.setter
    def control_plane_encryption(self, value: Optional[pulumi.Input['ClusterControlPlaneEncryptionArgs']]):
        pulumi.set(self, "control_plane_encryption", value)

    @property
    @pulumi.getter(name="controlPlaneVersion")
    def control_plane_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The control plane release version.
        """
        return pulumi.get(self, "control_plane_version")

    @control_plane_version.setter
    def control_plane_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "control_plane_version", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The time when the maintenance event request was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="defaultMaxPodsPerNode")
    def default_max_pods_per_node(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default maximum number of pods per node used if a maximum value is not
        specified explicitly for a node pool in this cluster. If unspecified, the
        Kubernetes default value will be used.
        """
        return pulumi.get(self, "default_max_pods_per_node")

    @default_max_pods_per_node.setter
    def default_max_pods_per_node(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_max_pods_per_node", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address of the Kubernetes API server.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="externalLoadBalancerIpv4AddressPools")
    def external_load_balancer_ipv4_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Address pools for cluster data plane external load balancing.
        """
        return pulumi.get(self, "external_load_balancer_ipv4_address_pools")

    @external_load_balancer_ipv4_address_pools.setter
    def external_load_balancer_ipv4_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "external_load_balancer_ipv4_address_pools", value)

    @property
    @pulumi.getter
    def fleet(self) -> Optional[pulumi.Input['ClusterFleetArgs']]:
        """
        Fleet related configuration.
        Fleets are a Google Cloud concept for logically organizing clusters,
        letting you use and manage multi-cluster capabilities and apply
        consistent policies across your systems.
        Structure is documented below.
        """
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: Optional[pulumi.Input['ClusterFleetArgs']]):
        pulumi.set(self, "fleet", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the edgecloud cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceEvents")
    def maintenance_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceEventArgs']]]]:
        """
        All the maintenance events scheduled for the cluster, including the ones
        ongoing, planned for the future and done in the past (up to 90 days).
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_events")

    @maintenance_events.setter
    def maintenance_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceEventArgs']]]]):
        pulumi.set(self, "maintenance_events", value)

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]:
        """
        Cluster-wide maintenance policy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GDCE cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networking(self) -> Optional[pulumi.Input['ClusterNetworkingArgs']]:
        """
        Fleet related configuration.
        Fleets are a Google Cloud concept for logically organizing clusters,
        letting you use and manage multi-cluster capabilities and apply
        consistent policies across your systems.
        Structure is documented below.
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: Optional[pulumi.Input['ClusterNetworkingArgs']]):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lowest release version among all worker nodes. This field can be empty
        if the cluster does not have any worker nodes.
        """
        return pulumi.get(self, "node_version")

    @node_version.setter
    def node_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_version", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port number of the Kubernetes API server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The release channel a cluster is subscribed to.
        Possible values are: `RELEASE_CHANNEL_UNSPECIFIED`, `NONE`, `REGULAR`.
        """
        return pulumi.get(self, "release_channel")

    @release_channel.setter
    def release_channel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_channel", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the status of the cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemAddonsConfig")
    def system_addons_config(self) -> Optional[pulumi.Input['ClusterSystemAddonsConfigArgs']]:
        """
        Config that customers are allowed to define for GDCE system add-ons.
        Structure is documented below.
        """
        return pulumi.get(self, "system_addons_config")

    @system_addons_config.setter
    def system_addons_config(self, value: Optional[pulumi.Input['ClusterSystemAddonsConfigArgs']]):
        pulumi.set(self, "system_addons_config", value)

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The target cluster version. For example: "1.5.0".
        """
        return pulumi.get(self, "target_version")

    @target_version.setter
    def target_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_version", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The time when the maintenance event message was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:edgecontainer/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[Union['ClusterAuthorizationArgs', 'ClusterAuthorizationArgsDict']]] = None,
                 control_plane: Optional[pulumi.Input[Union['ClusterControlPlaneArgs', 'ClusterControlPlaneArgsDict']]] = None,
                 control_plane_encryption: Optional[pulumi.Input[Union['ClusterControlPlaneEncryptionArgs', 'ClusterControlPlaneEncryptionArgsDict']]] = None,
                 default_max_pods_per_node: Optional[pulumi.Input[builtins.int]] = None,
                 external_load_balancer_ipv4_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 fleet: Optional[pulumi.Input[Union['ClusterFleetArgs', 'ClusterFleetArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networking: Optional[pulumi.Input[Union['ClusterNetworkingArgs', 'ClusterNetworkingArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 release_channel: Optional[pulumi.Input[builtins.str]] = None,
                 system_addons_config: Optional[pulumi.Input[Union['ClusterSystemAddonsConfigArgs', 'ClusterSystemAddonsConfigArgsDict']]] = None,
                 target_version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Cluster contains information about a Google Distributed Cloud Edge Kubernetes cluster.

        To get more information about Cluster, see:

        * [API documentation](https://cloud.google.com/distributed-cloud/edge/latest/docs/reference/container/rest/v1/projects.locations.clusters)
        * How-to Guides
            * [Create and manage clusters](https://cloud.google.com/distributed-cloud/edge/latest/docs/clusters)

        ## Example Usage

        ### Edgecontainer Cluster

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.edgecontainer.Cluster("default",
            name="basic-cluster",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            },
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            })
        ```
        ### Edgecontainer Cluster With Maintenance Window

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.edgecontainer.Cluster("default",
            name="cluster-with-maintenance",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            },
            maintenance_policy={
                "window": {
                    "recurring_window": {
                        "window": {
                            "start_time": "2023-01-01T08:00:00Z",
                            "end_time": "2023-01-01T17:00:00Z",
                        },
                        "recurrence": "FREQ=WEEKLY;BYDAY=SA",
                    },
                },
            })
        ```
        ### Edgecontainer Local Control Plane Cluster

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.edgecontainer.Cluster("default",
            name="local-control-plane-cluster",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            },
            external_load_balancer_ipv4_address_pools=["10.100.0.0-10.100.0.10"],
            control_plane={
                "local": {
                    "node_location": "us-central1-edge-example-edgesite",
                    "node_count": 1,
                    "machine_filter": "machine-name",
                    "shared_deployment_policy": "ALLOWED",
                },
            })
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:edgecontainer/cluster:Cluster default projects/{{project}}/locations/{{location}}/clusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/cluster:Cluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/cluster:Cluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterAuthorizationArgs', 'ClusterAuthorizationArgsDict']] authorization: RBAC policy that will be applied and managed by GEC.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterControlPlaneArgs', 'ClusterControlPlaneArgsDict']] control_plane: The configuration of the cluster control plane.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterControlPlaneEncryptionArgs', 'ClusterControlPlaneEncryptionArgsDict']] control_plane_encryption: Remote control plane disk encryption options. This field is only used when
               enabling CMEK support.
               Structure is documented below.
        :param pulumi.Input[builtins.int] default_max_pods_per_node: The default maximum number of pods per node used if a maximum value is not
               specified explicitly for a node pool in this cluster. If unspecified, the
               Kubernetes default value will be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_load_balancer_ipv4_address_pools: Address pools for cluster data plane external load balancing.
        :param pulumi.Input[Union['ClusterFleetArgs', 'ClusterFleetArgsDict']] fleet: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the edgecloud cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']] maintenance_policy: Cluster-wide maintenance policy configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The GDCE cluster name.
        :param pulumi.Input[Union['ClusterNetworkingArgs', 'ClusterNetworkingArgsDict']] networking: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] release_channel: The release channel a cluster is subscribed to.
               Possible values are: `RELEASE_CHANNEL_UNSPECIFIED`, `NONE`, `REGULAR`.
        :param pulumi.Input[Union['ClusterSystemAddonsConfigArgs', 'ClusterSystemAddonsConfigArgsDict']] system_addons_config: Config that customers are allowed to define for GDCE system add-ons.
               Structure is documented below.
        :param pulumi.Input[builtins.str] target_version: The target cluster version. For example: "1.5.0".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cluster contains information about a Google Distributed Cloud Edge Kubernetes cluster.

        To get more information about Cluster, see:

        * [API documentation](https://cloud.google.com/distributed-cloud/edge/latest/docs/reference/container/rest/v1/projects.locations.clusters)
        * How-to Guides
            * [Create and manage clusters](https://cloud.google.com/distributed-cloud/edge/latest/docs/clusters)

        ## Example Usage

        ### Edgecontainer Cluster

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.edgecontainer.Cluster("default",
            name="basic-cluster",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            },
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            })
        ```
        ### Edgecontainer Cluster With Maintenance Window

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.edgecontainer.Cluster("default",
            name="cluster-with-maintenance",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            },
            maintenance_policy={
                "window": {
                    "recurring_window": {
                        "window": {
                            "start_time": "2023-01-01T08:00:00Z",
                            "end_time": "2023-01-01T17:00:00Z",
                        },
                        "recurrence": "FREQ=WEEKLY;BYDAY=SA",
                    },
                },
            })
        ```
        ### Edgecontainer Local Control Plane Cluster

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.edgecontainer.Cluster("default",
            name="local-control-plane-cluster",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            },
            external_load_balancer_ipv4_address_pools=["10.100.0.0-10.100.0.10"],
            control_plane={
                "local": {
                    "node_location": "us-central1-edge-example-edgesite",
                    "node_count": 1,
                    "machine_filter": "machine-name",
                    "shared_deployment_policy": "ALLOWED",
                },
            })
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:edgecontainer/cluster:Cluster default projects/{{project}}/locations/{{location}}/clusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/cluster:Cluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/cluster:Cluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[Union['ClusterAuthorizationArgs', 'ClusterAuthorizationArgsDict']]] = None,
                 control_plane: Optional[pulumi.Input[Union['ClusterControlPlaneArgs', 'ClusterControlPlaneArgsDict']]] = None,
                 control_plane_encryption: Optional[pulumi.Input[Union['ClusterControlPlaneEncryptionArgs', 'ClusterControlPlaneEncryptionArgsDict']]] = None,
                 default_max_pods_per_node: Optional[pulumi.Input[builtins.int]] = None,
                 external_load_balancer_ipv4_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 fleet: Optional[pulumi.Input[Union['ClusterFleetArgs', 'ClusterFleetArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networking: Optional[pulumi.Input[Union['ClusterNetworkingArgs', 'ClusterNetworkingArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 release_channel: Optional[pulumi.Input[builtins.str]] = None,
                 system_addons_config: Optional[pulumi.Input[Union['ClusterSystemAddonsConfigArgs', 'ClusterSystemAddonsConfigArgsDict']]] = None,
                 target_version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if authorization is None and not opts.urn:
                raise TypeError("Missing required property 'authorization'")
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["control_plane"] = control_plane
            __props__.__dict__["control_plane_encryption"] = control_plane_encryption
            __props__.__dict__["default_max_pods_per_node"] = default_max_pods_per_node
            __props__.__dict__["external_load_balancer_ipv4_address_pools"] = external_load_balancer_ipv4_address_pools
            if fleet is None and not opts.urn:
                raise TypeError("Missing required property 'fleet'")
            __props__.__dict__["fleet"] = fleet
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["name"] = name
            if networking is None and not opts.urn:
                raise TypeError("Missing required property 'networking'")
            __props__.__dict__["networking"] = networking
            __props__.__dict__["project"] = project
            __props__.__dict__["release_channel"] = release_channel
            __props__.__dict__["system_addons_config"] = system_addons_config
            __props__.__dict__["target_version"] = target_version
            __props__.__dict__["cluster_ca_certificate"] = None
            __props__.__dict__["control_plane_version"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["maintenance_events"] = None
            __props__.__dict__["node_version"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterCaCertificate", "effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'gcp:edgecontainer/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization: Optional[pulumi.Input[Union['ClusterAuthorizationArgs', 'ClusterAuthorizationArgsDict']]] = None,
            cluster_ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
            control_plane: Optional[pulumi.Input[Union['ClusterControlPlaneArgs', 'ClusterControlPlaneArgsDict']]] = None,
            control_plane_encryption: Optional[pulumi.Input[Union['ClusterControlPlaneEncryptionArgs', 'ClusterControlPlaneEncryptionArgsDict']]] = None,
            control_plane_version: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            default_max_pods_per_node: Optional[pulumi.Input[builtins.int]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            external_load_balancer_ipv4_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            fleet: Optional[pulumi.Input[Union['ClusterFleetArgs', 'ClusterFleetArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_events: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMaintenanceEventArgs', 'ClusterMaintenanceEventArgsDict']]]]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            networking: Optional[pulumi.Input[Union['ClusterNetworkingArgs', 'ClusterNetworkingArgsDict']]] = None,
            node_version: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            release_channel: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            system_addons_config: Optional[pulumi.Input[Union['ClusterSystemAddonsConfigArgs', 'ClusterSystemAddonsConfigArgsDict']]] = None,
            target_version: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterAuthorizationArgs', 'ClusterAuthorizationArgsDict']] authorization: RBAC policy that will be applied and managed by GEC.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster_ca_certificate: The PEM-encoded public certificate of the cluster's CA.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[Union['ClusterControlPlaneArgs', 'ClusterControlPlaneArgsDict']] control_plane: The configuration of the cluster control plane.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterControlPlaneEncryptionArgs', 'ClusterControlPlaneEncryptionArgsDict']] control_plane_encryption: Remote control plane disk encryption options. This field is only used when
               enabling CMEK support.
               Structure is documented below.
        :param pulumi.Input[builtins.str] control_plane_version: The control plane release version.
        :param pulumi.Input[builtins.str] create_time: (Output)
               The time when the maintenance event request was created.
        :param pulumi.Input[builtins.int] default_max_pods_per_node: The default maximum number of pods per node used if a maximum value is not
               specified explicitly for a node pool in this cluster. If unspecified, the
               Kubernetes default value will be used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] endpoint: The IP address of the Kubernetes API server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_load_balancer_ipv4_address_pools: Address pools for cluster data plane external load balancing.
        :param pulumi.Input[Union['ClusterFleetArgs', 'ClusterFleetArgsDict']] fleet: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the edgecloud cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterMaintenanceEventArgs', 'ClusterMaintenanceEventArgsDict']]]] maintenance_events: All the maintenance events scheduled for the cluster, including the ones
               ongoing, planned for the future and done in the past (up to 90 days).
               Structure is documented below.
        :param pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']] maintenance_policy: Cluster-wide maintenance policy configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The GDCE cluster name.
        :param pulumi.Input[Union['ClusterNetworkingArgs', 'ClusterNetworkingArgsDict']] networking: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               Structure is documented below.
        :param pulumi.Input[builtins.str] node_version: The lowest release version among all worker nodes. This field can be empty
               if the cluster does not have any worker nodes.
        :param pulumi.Input[builtins.int] port: The port number of the Kubernetes API server.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] release_channel: The release channel a cluster is subscribed to.
               Possible values are: `RELEASE_CHANNEL_UNSPECIFIED`, `NONE`, `REGULAR`.
        :param pulumi.Input[builtins.str] status: Indicates the status of the cluster.
        :param pulumi.Input[Union['ClusterSystemAddonsConfigArgs', 'ClusterSystemAddonsConfigArgsDict']] system_addons_config: Config that customers are allowed to define for GDCE system add-ons.
               Structure is documented below.
        :param pulumi.Input[builtins.str] target_version: The target cluster version. For example: "1.5.0".
        :param pulumi.Input[builtins.str] update_time: (Output)
               The time when the maintenance event message was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["cluster_ca_certificate"] = cluster_ca_certificate
        __props__.__dict__["control_plane"] = control_plane
        __props__.__dict__["control_plane_encryption"] = control_plane_encryption
        __props__.__dict__["control_plane_version"] = control_plane_version
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["default_max_pods_per_node"] = default_max_pods_per_node
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["external_load_balancer_ipv4_address_pools"] = external_load_balancer_ipv4_address_pools
        __props__.__dict__["fleet"] = fleet
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_events"] = maintenance_events
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["networking"] = networking
        __props__.__dict__["node_version"] = node_version
        __props__.__dict__["port"] = port
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["release_channel"] = release_channel
        __props__.__dict__["status"] = status
        __props__.__dict__["system_addons_config"] = system_addons_config
        __props__.__dict__["target_version"] = target_version
        __props__.__dict__["update_time"] = update_time
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output['outputs.ClusterAuthorization']:
        """
        RBAC policy that will be applied and managed by GEC.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> pulumi.Output[builtins.str]:
        """
        The PEM-encoded public certificate of the cluster's CA.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> pulumi.Output[Optional['outputs.ClusterControlPlane']]:
        """
        The configuration of the cluster control plane.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane")

    @property
    @pulumi.getter(name="controlPlaneEncryption")
    def control_plane_encryption(self) -> pulumi.Output['outputs.ClusterControlPlaneEncryption']:
        """
        Remote control plane disk encryption options. This field is only used when
        enabling CMEK support.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_encryption")

    @property
    @pulumi.getter(name="controlPlaneVersion")
    def control_plane_version(self) -> pulumi.Output[builtins.str]:
        """
        The control plane release version.
        """
        return pulumi.get(self, "control_plane_version")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        The time when the maintenance event request was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="defaultMaxPodsPerNode")
    def default_max_pods_per_node(self) -> pulumi.Output[builtins.int]:
        """
        The default maximum number of pods per node used if a maximum value is not
        specified explicitly for a node pool in this cluster. If unspecified, the
        Kubernetes default value will be used.
        """
        return pulumi.get(self, "default_max_pods_per_node")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The IP address of the Kubernetes API server.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="externalLoadBalancerIpv4AddressPools")
    def external_load_balancer_ipv4_address_pools(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Address pools for cluster data plane external load balancing.
        """
        return pulumi.get(self, "external_load_balancer_ipv4_address_pools")

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Output['outputs.ClusterFleet']:
        """
        Fleet related configuration.
        Fleets are a Google Cloud concept for logically organizing clusters,
        letting you use and manage multi-cluster capabilities and apply
        consistent policies across your systems.
        Structure is documented below.
        """
        return pulumi.get(self, "fleet")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined labels for the edgecloud cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceEvents")
    def maintenance_events(self) -> pulumi.Output[Sequence['outputs.ClusterMaintenanceEvent']]:
        """
        All the maintenance events scheduled for the cluster, including the ones
        ongoing, planned for the future and done in the past (up to 90 days).
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_events")

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output['outputs.ClusterMaintenancePolicy']:
        """
        Cluster-wide maintenance policy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The GDCE cluster name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Output['outputs.ClusterNetworking']:
        """
        Fleet related configuration.
        Fleets are a Google Cloud concept for logically organizing clusters,
        letting you use and manage multi-cluster capabilities and apply
        consistent policies across your systems.
        Structure is documented below.
        """
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> pulumi.Output[builtins.str]:
        """
        The lowest release version among all worker nodes. This field can be empty
        if the cluster does not have any worker nodes.
        """
        return pulumi.get(self, "node_version")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        The port number of the Kubernetes API server.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> pulumi.Output[builtins.str]:
        """
        The release channel a cluster is subscribed to.
        Possible values are: `RELEASE_CHANNEL_UNSPECIFIED`, `NONE`, `REGULAR`.
        """
        return pulumi.get(self, "release_channel")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Indicates the status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemAddonsConfig")
    def system_addons_config(self) -> pulumi.Output['outputs.ClusterSystemAddonsConfig']:
        """
        Config that customers are allowed to define for GDCE system add-ons.
        Structure is documented below.
        """
        return pulumi.get(self, "system_addons_config")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> pulumi.Output[builtins.str]:
        """
        The target cluster version. For example: "1.5.0".
        """
        return pulumi.get(self, "target_version")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        The time when the maintenance event message was updated.
        """
        return pulumi.get(self, "update_time")

