# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpnConnectionArgs', 'VpnConnection']

@pulumi.input_type
class VpnConnectionArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 enable_high_availability: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 vpc: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_project: Optional[pulumi.Input['VpnConnectionVpcProjectArgs']] = None):
        """
        The set of arguments for constructing a VpnConnection resource.
        :param pulumi.Input[builtins.str] cluster: The canonical Cluster name to connect to. It is in the form of projects/{project}/locations/{location}/clusters/{cluster}.
        :param pulumi.Input[builtins.str] location: Google Cloud Platform location.
        :param pulumi.Input[builtins.bool] enable_high_availability: Whether this VPN connection has HA enabled on cluster side. If enabled, when creating VPN connection we will attempt to use 2 ANG floating IPs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels associated with this resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name of VPN connection
        :param pulumi.Input[builtins.str] nat_gateway_ip: NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the customer needs to configure NAT such that only one external IP maps to the GMEC Anthos cluster.
               This is empty if NAT is not used.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] router: The VPN connection Cloud Router name.
        :param pulumi.Input[builtins.str] vpc: The network ID of VPC to connect to.
        :param pulumi.Input['VpnConnectionVpcProjectArgs'] vpc_project: Project detail of the VPC network. Required if VPC is in a different project than the cluster project.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "location", location)
        if enable_high_availability is not None:
            pulumi.set(__self__, "enable_high_availability", enable_high_availability)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_gateway_ip is not None:
            pulumi.set(__self__, "nat_gateway_ip", nat_gateway_ip)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)
        if vpc_project is not None:
            pulumi.set(__self__, "vpc_project", vpc_project)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        The canonical Cluster name to connect to. It is in the form of projects/{project}/locations/{location}/clusters/{cluster}.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Google Cloud Platform location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="enableHighAvailability")
    def enable_high_availability(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this VPN connection has HA enabled on cluster side. If enabled, when creating VPN connection we will attempt to use 2 ANG floating IPs.
        """
        return pulumi.get(self, "enable_high_availability")

    @enable_high_availability.setter
    def enable_high_availability(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_high_availability", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels associated with this resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of VPN connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natGatewayIp")
    def nat_gateway_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the customer needs to configure NAT such that only one external IP maps to the GMEC Anthos cluster.
        This is empty if NAT is not used.
        """
        return pulumi.get(self, "nat_gateway_ip")

    @nat_gateway_ip.setter
    def nat_gateway_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nat_gateway_ip", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPN connection Cloud Router name.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network ID of VPC to connect to.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc", value)

    @property
    @pulumi.getter(name="vpcProject")
    def vpc_project(self) -> Optional[pulumi.Input['VpnConnectionVpcProjectArgs']]:
        """
        Project detail of the VPC network. Required if VPC is in a different project than the cluster project.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_project")

    @vpc_project.setter
    def vpc_project(self, value: Optional[pulumi.Input['VpnConnectionVpcProjectArgs']]):
        pulumi.set(self, "vpc_project", value)


@pulumi.input_type
class _VpnConnectionState:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailArgs']]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enable_high_availability: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 vpc: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_project: Optional[pulumi.Input['VpnConnectionVpcProjectArgs']] = None):
        """
        Input properties used for looking up and filtering VpnConnection resources.
        :param pulumi.Input[builtins.str] cluster: The canonical Cluster name to connect to. It is in the form of projects/{project}/locations/{location}/clusters/{cluster}.
        :param pulumi.Input[builtins.str] create_time: The time when the VPN connection was created.
        :param pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailArgs']]] details: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_high_availability: Whether this VPN connection has HA enabled on cluster side. If enabled, when creating VPN connection we will attempt to use 2 ANG floating IPs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels associated with this resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Google Cloud Platform location.
        :param pulumi.Input[builtins.str] name: The resource name of VPN connection
        :param pulumi.Input[builtins.str] nat_gateway_ip: NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the customer needs to configure NAT such that only one external IP maps to the GMEC Anthos cluster.
               This is empty if NAT is not used.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] router: The VPN connection Cloud Router name.
        :param pulumi.Input[builtins.str] update_time: The time when the VPN connection was last updated.
        :param pulumi.Input[builtins.str] vpc: The network ID of VPC to connect to.
        :param pulumi.Input['VpnConnectionVpcProjectArgs'] vpc_project: Project detail of the VPC network. Required if VPC is in a different project than the cluster project.
               Structure is documented below.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_high_availability is not None:
            pulumi.set(__self__, "enable_high_availability", enable_high_availability)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_gateway_ip is not None:
            pulumi.set(__self__, "nat_gateway_ip", nat_gateway_ip)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)
        if vpc_project is not None:
            pulumi.set(__self__, "vpc_project", vpc_project)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canonical Cluster name to connect to. It is in the form of projects/{project}/locations/{location}/clusters/{cluster}.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the VPN connection was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailArgs']]]]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="enableHighAvailability")
    def enable_high_availability(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this VPN connection has HA enabled on cluster side. If enabled, when creating VPN connection we will attempt to use 2 ANG floating IPs.
        """
        return pulumi.get(self, "enable_high_availability")

    @enable_high_availability.setter
    def enable_high_availability(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_high_availability", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels associated with this resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Google Cloud Platform location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of VPN connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natGatewayIp")
    def nat_gateway_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the customer needs to configure NAT such that only one external IP maps to the GMEC Anthos cluster.
        This is empty if NAT is not used.
        """
        return pulumi.get(self, "nat_gateway_ip")

    @nat_gateway_ip.setter
    def nat_gateway_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nat_gateway_ip", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPN connection Cloud Router name.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the VPN connection was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network ID of VPC to connect to.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc", value)

    @property
    @pulumi.getter(name="vpcProject")
    def vpc_project(self) -> Optional[pulumi.Input['VpnConnectionVpcProjectArgs']]:
        """
        Project detail of the VPC network. Required if VPC is in a different project than the cluster project.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_project")

    @vpc_project.setter
    def vpc_project(self, value: Optional[pulumi.Input['VpnConnectionVpcProjectArgs']]):
        pulumi.set(self, "vpc_project", value)


@pulumi.type_token("gcp:edgecontainer/vpnConnection:VpnConnection")
class VpnConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 enable_high_availability: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 vpc: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_project: Optional[pulumi.Input[Union['VpnConnectionVpcProjectArgs', 'VpnConnectionVpcProjectArgsDict']]] = None,
                 __props__=None):
        """
        A VPN connection

        To get more information about VpnConnection, see:

        * [API documentation](https://cloud.google.com/distributed-cloud/edge/latest/docs/reference/container/rest/v1/projects.locations.vpnConnections)
        * How-to Guides
            * [Google Distributed Cloud Edge](https://cloud.google.com/distributed-cloud/edge/latest/docs)

        ## Example Usage

        ### Edgecontainer Vpn Connection

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cluster = gcp.edgecontainer.Cluster("cluster",
            name="default",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            })
        node_pool = gcp.edgecontainer.NodePool("node_pool",
            name="nodepool-1",
            cluster=cluster.name,
            location="us-central1",
            node_location="us-central1-edge-example-edgesite",
            node_count=3)
        vpc = gcp.compute.Network("vpc", name="example-vpc")
        default = gcp.edgecontainer.VpnConnection("default",
            name="vpn-connection-1",
            location="us-central1",
            cluster=cluster.name.apply(lambda name: f"projects/{project.number}/locations/us-east1/clusters/{name}"),
            vpc=vpc.name,
            enable_high_availability=True,
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            opts = pulumi.ResourceOptions(depends_on=[node_pool]))
        ```

        ## Import

        VpnConnection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vpnConnections/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, VpnConnection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:edgecontainer/vpnConnection:VpnConnection default projects/{{project}}/locations/{{location}}/vpnConnections/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/vpnConnection:VpnConnection default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/vpnConnection:VpnConnection default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The canonical Cluster name to connect to. It is in the form of projects/{project}/locations/{location}/clusters/{cluster}.
        :param pulumi.Input[builtins.bool] enable_high_availability: Whether this VPN connection has HA enabled on cluster side. If enabled, when creating VPN connection we will attempt to use 2 ANG floating IPs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels associated with this resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Google Cloud Platform location.
        :param pulumi.Input[builtins.str] name: The resource name of VPN connection
        :param pulumi.Input[builtins.str] nat_gateway_ip: NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the customer needs to configure NAT such that only one external IP maps to the GMEC Anthos cluster.
               This is empty if NAT is not used.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] router: The VPN connection Cloud Router name.
        :param pulumi.Input[builtins.str] vpc: The network ID of VPC to connect to.
        :param pulumi.Input[Union['VpnConnectionVpcProjectArgs', 'VpnConnectionVpcProjectArgsDict']] vpc_project: Project detail of the VPC network. Required if VPC is in a different project than the cluster project.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A VPN connection

        To get more information about VpnConnection, see:

        * [API documentation](https://cloud.google.com/distributed-cloud/edge/latest/docs/reference/container/rest/v1/projects.locations.vpnConnections)
        * How-to Guides
            * [Google Distributed Cloud Edge](https://cloud.google.com/distributed-cloud/edge/latest/docs)

        ## Example Usage

        ### Edgecontainer Vpn Connection

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cluster = gcp.edgecontainer.Cluster("cluster",
            name="default",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            })
        node_pool = gcp.edgecontainer.NodePool("node_pool",
            name="nodepool-1",
            cluster=cluster.name,
            location="us-central1",
            node_location="us-central1-edge-example-edgesite",
            node_count=3)
        vpc = gcp.compute.Network("vpc", name="example-vpc")
        default = gcp.edgecontainer.VpnConnection("default",
            name="vpn-connection-1",
            location="us-central1",
            cluster=cluster.name.apply(lambda name: f"projects/{project.number}/locations/us-east1/clusters/{name}"),
            vpc=vpc.name,
            enable_high_availability=True,
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            opts = pulumi.ResourceOptions(depends_on=[node_pool]))
        ```

        ## Import

        VpnConnection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vpnConnections/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, VpnConnection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:edgecontainer/vpnConnection:VpnConnection default projects/{{project}}/locations/{{location}}/vpnConnections/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/vpnConnection:VpnConnection default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/vpnConnection:VpnConnection default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param VpnConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 enable_high_availability: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 vpc: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_project: Optional[pulumi.Input[Union['VpnConnectionVpcProjectArgs', 'VpnConnectionVpcProjectArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnConnectionArgs.__new__(VpnConnectionArgs)

            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["enable_high_availability"] = enable_high_availability
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["nat_gateway_ip"] = nat_gateway_ip
            __props__.__dict__["project"] = project
            __props__.__dict__["router"] = router
            __props__.__dict__["vpc"] = vpc
            __props__.__dict__["vpc_project"] = vpc_project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["details"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VpnConnection, __self__).__init__(
            'gcp:edgecontainer/vpnConnection:VpnConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionDetailArgs', 'VpnConnectionDetailArgsDict']]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            enable_high_availability: Optional[pulumi.Input[builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            router: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            vpc: Optional[pulumi.Input[builtins.str]] = None,
            vpc_project: Optional[pulumi.Input[Union['VpnConnectionVpcProjectArgs', 'VpnConnectionVpcProjectArgsDict']]] = None) -> 'VpnConnection':
        """
        Get an existing VpnConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The canonical Cluster name to connect to. It is in the form of projects/{project}/locations/{location}/clusters/{cluster}.
        :param pulumi.Input[builtins.str] create_time: The time when the VPN connection was created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionDetailArgs', 'VpnConnectionDetailArgsDict']]]] details: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_high_availability: Whether this VPN connection has HA enabled on cluster side. If enabled, when creating VPN connection we will attempt to use 2 ANG floating IPs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels associated with this resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Google Cloud Platform location.
        :param pulumi.Input[builtins.str] name: The resource name of VPN connection
        :param pulumi.Input[builtins.str] nat_gateway_ip: NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the customer needs to configure NAT such that only one external IP maps to the GMEC Anthos cluster.
               This is empty if NAT is not used.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] router: The VPN connection Cloud Router name.
        :param pulumi.Input[builtins.str] update_time: The time when the VPN connection was last updated.
        :param pulumi.Input[builtins.str] vpc: The network ID of VPC to connect to.
        :param pulumi.Input[Union['VpnConnectionVpcProjectArgs', 'VpnConnectionVpcProjectArgsDict']] vpc_project: Project detail of the VPC network. Required if VPC is in a different project than the cluster project.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnConnectionState.__new__(_VpnConnectionState)

        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["details"] = details
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_high_availability"] = enable_high_availability
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_gateway_ip"] = nat_gateway_ip
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["router"] = router
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpc"] = vpc
        __props__.__dict__["vpc_project"] = vpc_project
        return VpnConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        The canonical Cluster name to connect to. It is in the form of projects/{project}/locations/{location}/clusters/{cluster}.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the VPN connection was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def details(self) -> pulumi.Output[Sequence['outputs.VpnConnectionDetail']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableHighAvailability")
    def enable_high_availability(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this VPN connection has HA enabled on cluster side. If enabled, when creating VPN connection we will attempt to use 2 ANG floating IPs.
        """
        return pulumi.get(self, "enable_high_availability")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels associated with this resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Google Cloud Platform location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of VPN connection
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natGatewayIp")
    def nat_gateway_ip(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the customer needs to configure NAT such that only one external IP maps to the GMEC Anthos cluster.
        This is empty if NAT is not used.
        """
        return pulumi.get(self, "nat_gateway_ip")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The VPN connection Cloud Router name.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the VPN connection was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def vpc(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The network ID of VPC to connect to.
        """
        return pulumi.get(self, "vpc")

    @property
    @pulumi.getter(name="vpcProject")
    def vpc_project(self) -> pulumi.Output[Optional['outputs.VpnConnectionVpcProject']]:
        """
        Project detail of the VPC network. Required if VPC is in a different project than the cluster project.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_project")

