# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnrollmentArgs', 'Enrollment']

@pulumi.input_type
class EnrollmentArgs:
    def __init__(__self__, *,
                 cel_match: pulumi.Input[builtins.str],
                 destination: pulumi.Input[builtins.str],
                 enrollment_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 message_bus: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Enrollment resource.
        :param pulumi.Input[builtins.str] cel_match: A CEL expression identifying which messages this enrollment applies to.
        :param pulumi.Input[builtins.str] destination: Destination is the Pipeline that the Enrollment is delivering to. It must
               point to the full resource name of a Pipeline. Format:
               "projects/{PROJECT_ID}/locations/{region}/pipelines/{PIPELINE_ID)"
        :param pulumi.Input[builtins.str] enrollment_id: The user-provided ID to be assigned to the Enrollment. It should match the
               format `^a-z?$`.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] message_bus: Resource name of the message bus identifying the source of the messages. It
               matches the form
               projects/{project}/locations/{location}/messageBuses/{messageBus}.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Resource annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] display_name: Resource display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "cel_match", cel_match)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enrollment_id", enrollment_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "message_bus", message_bus)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="celMatch")
    def cel_match(self) -> pulumi.Input[builtins.str]:
        """
        A CEL expression identifying which messages this enrollment applies to.
        """
        return pulumi.get(self, "cel_match")

    @cel_match.setter
    def cel_match(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cel_match", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[builtins.str]:
        """
        Destination is the Pipeline that the Enrollment is delivering to. It must
        point to the full resource name of a Pipeline. Format:
        "projects/{PROJECT_ID}/locations/{region}/pipelines/{PIPELINE_ID)"
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> pulumi.Input[builtins.str]:
        """
        The user-provided ID to be assigned to the Enrollment. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "enrollment_id")

    @enrollment_id.setter
    def enrollment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "enrollment_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="messageBus")
    def message_bus(self) -> pulumi.Input[builtins.str]:
        """
        Resource name of the message bus identifying the source of the messages. It
        matches the form
        projects/{project}/locations/{location}/messageBuses/{messageBus}.
        """
        return pulumi.get(self, "message_bus")

    @message_bus.setter
    def message_bus(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "message_bus", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _EnrollmentState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cel_match: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enrollment_id: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 message_bus: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Enrollment resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Resource annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] cel_match: A CEL expression identifying which messages this enrollment applies to.
        :param pulumi.Input[builtins.str] create_time: The creation time.
        :param pulumi.Input[builtins.str] destination: Destination is the Pipeline that the Enrollment is delivering to. It must
               point to the full resource name of a Pipeline. Format:
               "projects/{PROJECT_ID}/locations/{region}/pipelines/{PIPELINE_ID)"
        :param pulumi.Input[builtins.str] display_name: Resource display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] enrollment_id: The user-provided ID to be assigned to the Enrollment. It should match the
               format `^a-z?$`.
        :param pulumi.Input[builtins.str] etag: This checksum is computed by the server based on the value of other
               fields, and might be sent only on update and delete requests to ensure that
               the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] message_bus: Resource name of the message bus identifying the source of the messages. It
               matches the form
               projects/{project}/locations/{location}/messageBuses/{messageBus}.
        :param pulumi.Input[builtins.str] name: Resource name of the form
               projects/{project}/locations/{location}/enrollments/{enrollment}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] uid: Server assigned unique identifier for the channel. The value is a UUID4
               string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[builtins.str] update_time: The last-modified time.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cel_match is not None:
            pulumi.set(__self__, "cel_match", cel_match)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enrollment_id is not None:
            pulumi.set(__self__, "enrollment_id", enrollment_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if message_bus is not None:
            pulumi.set(__self__, "message_bus", message_bus)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="celMatch")
    def cel_match(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A CEL expression identifying which messages this enrollment applies to.
        """
        return pulumi.get(self, "cel_match")

    @cel_match.setter
    def cel_match(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cel_match", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination is the Pipeline that the Enrollment is delivering to. It must
        point to the full resource name of a Pipeline. Format:
        "projects/{PROJECT_ID}/locations/{region}/pipelines/{PIPELINE_ID)"
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-provided ID to be assigned to the Enrollment. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "enrollment_id")

    @enrollment_id.setter
    def enrollment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enrollment_id", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This checksum is computed by the server based on the value of other
        fields, and might be sent only on update and delete requests to ensure that
        the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="messageBus")
    def message_bus(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of the message bus identifying the source of the messages. It
        matches the form
        projects/{project}/locations/{location}/messageBuses/{messageBus}.
        """
        return pulumi.get(self, "message_bus")

    @message_bus.setter
    def message_bus(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_bus", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of the form
        projects/{project}/locations/{location}/enrollments/{enrollment}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server assigned unique identifier for the channel. The value is a UUID4
        string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:eventarc/enrollment:Enrollment")
class Enrollment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cel_match: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enrollment_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 message_bus: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The Eventarc Enrollment resource

        To get more information about Enrollment, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.enrollments)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/advanced/docs/receive-events/create-enrollment)

        ## Example Usage

        ### Eventarc Enrollment With Pipeline Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pipeline = gcp.eventarc.Pipeline("pipeline",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
            }])
        primary = gcp.eventarc.Enrollment("primary",
            location="us-central1",
            enrollment_id="some-enrollment",
            message_bus=primary_google_eventarc_message_bus["id"],
            destination=pipeline.id,
            cel_match="message.type == 'google.cloud.dataflow.job.v1beta3.statusChanged'")
        message_bus = gcp.eventarc.MessageBus("message_bus",
            location="us-central1",
            message_bus_id="some-message-bus")
        ```

        ## Import

        Enrollment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/enrollments/{{enrollment_id}}`

        * `{{project}}/{{location}}/{{enrollment_id}}`

        * `{{location}}/{{enrollment_id}}`

        When using the `pulumi import` command, Enrollment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/enrollment:Enrollment default projects/{{project}}/locations/{{location}}/enrollments/{{enrollment_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/enrollment:Enrollment default {{project}}/{{location}}/{{enrollment_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/enrollment:Enrollment default {{location}}/{{enrollment_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Resource annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] cel_match: A CEL expression identifying which messages this enrollment applies to.
        :param pulumi.Input[builtins.str] destination: Destination is the Pipeline that the Enrollment is delivering to. It must
               point to the full resource name of a Pipeline. Format:
               "projects/{PROJECT_ID}/locations/{region}/pipelines/{PIPELINE_ID)"
        :param pulumi.Input[builtins.str] display_name: Resource display name.
        :param pulumi.Input[builtins.str] enrollment_id: The user-provided ID to be assigned to the Enrollment. It should match the
               format `^a-z?$`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] message_bus: Resource name of the message bus identifying the source of the messages. It
               matches the form
               projects/{project}/locations/{location}/messageBuses/{messageBus}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnrollmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Eventarc Enrollment resource

        To get more information about Enrollment, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.enrollments)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/advanced/docs/receive-events/create-enrollment)

        ## Example Usage

        ### Eventarc Enrollment With Pipeline Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pipeline = gcp.eventarc.Pipeline("pipeline",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
            }])
        primary = gcp.eventarc.Enrollment("primary",
            location="us-central1",
            enrollment_id="some-enrollment",
            message_bus=primary_google_eventarc_message_bus["id"],
            destination=pipeline.id,
            cel_match="message.type == 'google.cloud.dataflow.job.v1beta3.statusChanged'")
        message_bus = gcp.eventarc.MessageBus("message_bus",
            location="us-central1",
            message_bus_id="some-message-bus")
        ```

        ## Import

        Enrollment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/enrollments/{{enrollment_id}}`

        * `{{project}}/{{location}}/{{enrollment_id}}`

        * `{{location}}/{{enrollment_id}}`

        When using the `pulumi import` command, Enrollment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/enrollment:Enrollment default projects/{{project}}/locations/{{location}}/enrollments/{{enrollment_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/enrollment:Enrollment default {{project}}/{{location}}/{{enrollment_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/enrollment:Enrollment default {{location}}/{{enrollment_id}}
        ```

        :param str resource_name: The name of the resource.
        :param EnrollmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnrollmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cel_match: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enrollment_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 message_bus: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnrollmentArgs.__new__(EnrollmentArgs)

            __props__.__dict__["annotations"] = annotations
            if cel_match is None and not opts.urn:
                raise TypeError("Missing required property 'cel_match'")
            __props__.__dict__["cel_match"] = cel_match
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["display_name"] = display_name
            if enrollment_id is None and not opts.urn:
                raise TypeError("Missing required property 'enrollment_id'")
            __props__.__dict__["enrollment_id"] = enrollment_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if message_bus is None and not opts.urn:
                raise TypeError("Missing required property 'message_bus'")
            __props__.__dict__["message_bus"] = message_bus
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Enrollment, __self__).__init__(
            'gcp:eventarc/enrollment:Enrollment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            cel_match: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            destination: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            enrollment_id: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            message_bus: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Enrollment':
        """
        Get an existing Enrollment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Resource annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] cel_match: A CEL expression identifying which messages this enrollment applies to.
        :param pulumi.Input[builtins.str] create_time: The creation time.
        :param pulumi.Input[builtins.str] destination: Destination is the Pipeline that the Enrollment is delivering to. It must
               point to the full resource name of a Pipeline. Format:
               "projects/{PROJECT_ID}/locations/{region}/pipelines/{PIPELINE_ID)"
        :param pulumi.Input[builtins.str] display_name: Resource display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] enrollment_id: The user-provided ID to be assigned to the Enrollment. It should match the
               format `^a-z?$`.
        :param pulumi.Input[builtins.str] etag: This checksum is computed by the server based on the value of other
               fields, and might be sent only on update and delete requests to ensure that
               the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] message_bus: Resource name of the message bus identifying the source of the messages. It
               matches the form
               projects/{project}/locations/{location}/messageBuses/{messageBus}.
        :param pulumi.Input[builtins.str] name: Resource name of the form
               projects/{project}/locations/{location}/enrollments/{enrollment}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] uid: Server assigned unique identifier for the channel. The value is a UUID4
               string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[builtins.str] update_time: The last-modified time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnrollmentState.__new__(_EnrollmentState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["cel_match"] = cel_match
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["destination"] = destination
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enrollment_id"] = enrollment_id
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["message_bus"] = message_bus
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Enrollment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Resource annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="celMatch")
    def cel_match(self) -> pulumi.Output[builtins.str]:
        """
        A CEL expression identifying which messages this enrollment applies to.
        """
        return pulumi.get(self, "cel_match")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[builtins.str]:
        """
        Destination is the Pipeline that the Enrollment is delivering to. It must
        point to the full resource name of a Pipeline. Format:
        "projects/{PROJECT_ID}/locations/{region}/pipelines/{PIPELINE_ID)"
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Resource display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> pulumi.Output[builtins.str]:
        """
        The user-provided ID to be assigned to the Enrollment. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "enrollment_id")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        This checksum is computed by the server based on the value of other
        fields, and might be sent only on update and delete requests to ensure that
        the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="messageBus")
    def message_bus(self) -> pulumi.Output[builtins.str]:
        """
        Resource name of the message bus identifying the source of the messages. It
        matches the form
        projects/{project}/locations/{location}/messageBuses/{messageBus}.
        """
        return pulumi.get(self, "message_bus")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Resource name of the form
        projects/{project}/locations/{location}/enrollments/{enrollment}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Server assigned unique identifier for the channel. The value is a UUID4
        string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

