# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceDirectoryServicesArgs',
    'InstanceDirectoryServicesArgsDict',
    'InstanceDirectoryServicesLdapArgs',
    'InstanceDirectoryServicesLdapArgsDict',
    'InstanceEffectiveReplicationArgs',
    'InstanceEffectiveReplicationArgsDict',
    'InstanceEffectiveReplicationReplicaArgs',
    'InstanceEffectiveReplicationReplicaArgsDict',
    'InstanceFileSharesArgs',
    'InstanceFileSharesArgsDict',
    'InstanceFileSharesNfsExportOptionArgs',
    'InstanceFileSharesNfsExportOptionArgsDict',
    'InstanceInitialReplicationArgs',
    'InstanceInitialReplicationArgsDict',
    'InstanceInitialReplicationReplicaArgs',
    'InstanceInitialReplicationReplicaArgsDict',
    'InstanceNetworkArgs',
    'InstanceNetworkArgsDict',
    'InstanceNetworkPscConfigArgs',
    'InstanceNetworkPscConfigArgsDict',
    'InstancePerformanceConfigArgs',
    'InstancePerformanceConfigArgsDict',
    'InstancePerformanceConfigFixedIopsArgs',
    'InstancePerformanceConfigFixedIopsArgsDict',
    'InstancePerformanceConfigIopsPerTbArgs',
    'InstancePerformanceConfigIopsPerTbArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceDirectoryServicesArgsDict(TypedDict):
        ldap: NotRequired[pulumi.Input['InstanceDirectoryServicesLdapArgsDict']]
        """
        Configuration for LDAP servers.
        Structure is documented below.
        """
elif False:
    InstanceDirectoryServicesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDirectoryServicesArgs:
    def __init__(__self__, *,
                 ldap: Optional[pulumi.Input['InstanceDirectoryServicesLdapArgs']] = None):
        """
        :param pulumi.Input['InstanceDirectoryServicesLdapArgs'] ldap: Configuration for LDAP servers.
               Structure is documented below.
        """
        if ldap is not None:
            pulumi.set(__self__, "ldap", ldap)

    @property
    @pulumi.getter
    def ldap(self) -> Optional[pulumi.Input['InstanceDirectoryServicesLdapArgs']]:
        """
        Configuration for LDAP servers.
        Structure is documented below.
        """
        return pulumi.get(self, "ldap")

    @ldap.setter
    def ldap(self, value: Optional[pulumi.Input['InstanceDirectoryServicesLdapArgs']]):
        pulumi.set(self, "ldap", value)


if not MYPY:
    class InstanceDirectoryServicesLdapArgsDict(TypedDict):
        domain: pulumi.Input[builtins.str]
        """
        The LDAP domain name in the format of `my-domain.com`.
        """
        servers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The servers names are used for specifying the LDAP servers names.
        The LDAP servers names can come with two formats:
        1. DNS name, for example: `ldap.example1.com`, `ldap.example2.com`.
        2. IP address, for example: `10.0.0.1`, `10.0.0.2`, `10.0.0.3`.
        All servers names must be in the same format: either all DNS names or all
        IP addresses.
        """
        groups_ou: NotRequired[pulumi.Input[builtins.str]]
        """
        The groups Organizational Unit (OU) is optional. This parameter is a hint
        to allow faster lookup in the LDAP namespace. In case that this parameter
        is not provided, Filestore instance will query the whole LDAP namespace.
        """
        users_ou: NotRequired[pulumi.Input[builtins.str]]
        """
        The users Organizational Unit (OU) is optional. This parameter is a hint
        to allow faster lookup in the LDAP namespace. In case that this parameter
        is not provided, Filestore instance will query the whole LDAP namespace.
        """
elif False:
    InstanceDirectoryServicesLdapArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDirectoryServicesLdapArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[builtins.str],
                 servers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 groups_ou: Optional[pulumi.Input[builtins.str]] = None,
                 users_ou: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] domain: The LDAP domain name in the format of `my-domain.com`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] servers: The servers names are used for specifying the LDAP servers names.
               The LDAP servers names can come with two formats:
               1. DNS name, for example: `ldap.example1.com`, `ldap.example2.com`.
               2. IP address, for example: `10.0.0.1`, `10.0.0.2`, `10.0.0.3`.
               All servers names must be in the same format: either all DNS names or all
               IP addresses.
        :param pulumi.Input[builtins.str] groups_ou: The groups Organizational Unit (OU) is optional. This parameter is a hint
               to allow faster lookup in the LDAP namespace. In case that this parameter
               is not provided, Filestore instance will query the whole LDAP namespace.
        :param pulumi.Input[builtins.str] users_ou: The users Organizational Unit (OU) is optional. This parameter is a hint
               to allow faster lookup in the LDAP namespace. In case that this parameter
               is not provided, Filestore instance will query the whole LDAP namespace.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "servers", servers)
        if groups_ou is not None:
            pulumi.set(__self__, "groups_ou", groups_ou)
        if users_ou is not None:
            pulumi.set(__self__, "users_ou", users_ou)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[builtins.str]:
        """
        The LDAP domain name in the format of `my-domain.com`.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The servers names are used for specifying the LDAP servers names.
        The LDAP servers names can come with two formats:
        1. DNS name, for example: `ldap.example1.com`, `ldap.example2.com`.
        2. IP address, for example: `10.0.0.1`, `10.0.0.2`, `10.0.0.3`.
        All servers names must be in the same format: either all DNS names or all
        IP addresses.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="groupsOu")
    def groups_ou(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The groups Organizational Unit (OU) is optional. This parameter is a hint
        to allow faster lookup in the LDAP namespace. In case that this parameter
        is not provided, Filestore instance will query the whole LDAP namespace.
        """
        return pulumi.get(self, "groups_ou")

    @groups_ou.setter
    def groups_ou(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "groups_ou", value)

    @property
    @pulumi.getter(name="usersOu")
    def users_ou(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The users Organizational Unit (OU) is optional. This parameter is a hint
        to allow faster lookup in the LDAP namespace. In case that this parameter
        is not provided, Filestore instance will query the whole LDAP namespace.
        """
        return pulumi.get(self, "users_ou")

    @users_ou.setter
    def users_ou(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "users_ou", value)


if not MYPY:
    class InstanceEffectiveReplicationArgsDict(TypedDict):
        replicas: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationReplicaArgsDict']]]]
        """
        The replication role.
        Structure is documented below.
        """
        role: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        The replication role.
        """
elif False:
    InstanceEffectiveReplicationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceEffectiveReplicationArgs:
    def __init__(__self__, *,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationReplicaArgs']]]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationReplicaArgs']]] replicas: The replication role.
               Structure is documented below.
        :param pulumi.Input[builtins.str] role: (Output)
               The replication role.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationReplicaArgs']]]]:
        """
        The replication role.
        Structure is documented below.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationReplicaArgs']]]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The replication role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


if not MYPY:
    class InstanceEffectiveReplicationReplicaArgsDict(TypedDict):
        last_active_sync_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The timestamp of the latest replication snapshot taken on the active instance and is already replicated safely.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        peer_instance: NotRequired[pulumi.Input[builtins.str]]
        """
        The peer instance.
        """
        state: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The replica state
        """
        state_reasons: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Output)
        Output only. Additional information about the replication state, if available.
        """
elif False:
    InstanceEffectiveReplicationReplicaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceEffectiveReplicationReplicaArgs:
    def __init__(__self__, *,
                 last_active_sync_time: Optional[pulumi.Input[builtins.str]] = None,
                 peer_instance: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] last_active_sync_time: (Output)
               Output only. The timestamp of the latest replication snapshot taken on the active instance and is already replicated safely.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param pulumi.Input[builtins.str] peer_instance: The peer instance.
        :param pulumi.Input[builtins.str] state: (Output)
               Output only. The replica state
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] state_reasons: (Output)
               Output only. Additional information about the replication state, if available.
        """
        if last_active_sync_time is not None:
            pulumi.set(__self__, "last_active_sync_time", last_active_sync_time)
        if peer_instance is not None:
            pulumi.set(__self__, "peer_instance", peer_instance)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_reasons is not None:
            pulumi.set(__self__, "state_reasons", state_reasons)

    @property
    @pulumi.getter(name="lastActiveSyncTime")
    def last_active_sync_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The timestamp of the latest replication snapshot taken on the active instance and is already replicated safely.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "last_active_sync_time")

    @last_active_sync_time.setter
    def last_active_sync_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_active_sync_time", value)

    @property
    @pulumi.getter(name="peerInstance")
    def peer_instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The peer instance.
        """
        return pulumi.get(self, "peer_instance")

    @peer_instance.setter
    def peer_instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_instance", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The replica state
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateReasons")
    def state_reasons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Output)
        Output only. Additional information about the replication state, if available.
        """
        return pulumi.get(self, "state_reasons")

    @state_reasons.setter
    def state_reasons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "state_reasons", value)


if not MYPY:
    class InstanceFileSharesArgsDict(TypedDict):
        capacity_gb: pulumi.Input[builtins.int]
        """
        File share capacity in GiB. This must be at least 1024 GiB
        for the standard tier, or 2560 GiB for the premium tier.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the fileshare (16 characters or less)
        """
        nfs_export_options: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceFileSharesNfsExportOptionArgsDict']]]]
        """
        Nfs Export Options. There is a limit of 10 export options per file share.
        Structure is documented below.
        """
        source_backup: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource name of the backup, in the format
        projects/{projectId}/locations/{locationId}/backups/{backupId},
        that this file share has been restored from.
        """
elif False:
    InstanceFileSharesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceFileSharesArgs:
    def __init__(__self__, *,
                 capacity_gb: pulumi.Input[builtins.int],
                 name: pulumi.Input[builtins.str],
                 nfs_export_options: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFileSharesNfsExportOptionArgs']]]] = None,
                 source_backup: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] capacity_gb: File share capacity in GiB. This must be at least 1024 GiB
               for the standard tier, or 2560 GiB for the premium tier.
        :param pulumi.Input[builtins.str] name: The name of the fileshare (16 characters or less)
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFileSharesNfsExportOptionArgs']]] nfs_export_options: Nfs Export Options. There is a limit of 10 export options per file share.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_backup: The resource name of the backup, in the format
               projects/{projectId}/locations/{locationId}/backups/{backupId},
               that this file share has been restored from.
        """
        pulumi.set(__self__, "capacity_gb", capacity_gb)
        pulumi.set(__self__, "name", name)
        if nfs_export_options is not None:
            pulumi.set(__self__, "nfs_export_options", nfs_export_options)
        if source_backup is not None:
            pulumi.set(__self__, "source_backup", source_backup)

    @property
    @pulumi.getter(name="capacityGb")
    def capacity_gb(self) -> pulumi.Input[builtins.int]:
        """
        File share capacity in GiB. This must be at least 1024 GiB
        for the standard tier, or 2560 GiB for the premium tier.
        """
        return pulumi.get(self, "capacity_gb")

    @capacity_gb.setter
    def capacity_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "capacity_gb", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the fileshare (16 characters or less)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nfsExportOptions")
    def nfs_export_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFileSharesNfsExportOptionArgs']]]]:
        """
        Nfs Export Options. There is a limit of 10 export options per file share.
        Structure is documented below.
        """
        return pulumi.get(self, "nfs_export_options")

    @nfs_export_options.setter
    def nfs_export_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFileSharesNfsExportOptionArgs']]]]):
        pulumi.set(self, "nfs_export_options", value)

    @property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the backup, in the format
        projects/{projectId}/locations/{locationId}/backups/{backupId},
        that this file share has been restored from.
        """
        return pulumi.get(self, "source_backup")

    @source_backup.setter
    def source_backup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_backup", value)


if not MYPY:
    class InstanceFileSharesNfsExportOptionArgsDict(TypedDict):
        access_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        Either READ_ONLY, for allowing only read requests on the exported directory,
        or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE.
        Default value is `READ_WRITE`.
        Possible values are: `READ_ONLY`, `READ_WRITE`.
        """
        anon_gid: NotRequired[pulumi.Input[builtins.int]]
        """
        An integer representing the anonymous group id with a default value of 65534.
        Anon_gid may only be set with squashMode of ROOT_SQUASH. An error will be returned
        if this field is specified for other squashMode settings.
        """
        anon_uid: NotRequired[pulumi.Input[builtins.int]]
        """
        An integer representing the anonymous user id with a default value of 65534.
        Anon_uid may only be set with squashMode of ROOT_SQUASH. An error will be returned
        if this field is specified for other squashMode settings.
        """
        ip_ranges: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of either IPv4 addresses, or ranges in CIDR notation which may mount the file share.
        Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned.
        The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        """
        network: NotRequired[pulumi.Input[builtins.str]]
        """
        The source VPC network for `ip_ranges`.
        Required for instances using Private Service Connect, optional otherwise.
        """
        squash_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH,
        for not allowing root access. The default is NO_ROOT_SQUASH.
        Default value is `NO_ROOT_SQUASH`.
        Possible values are: `NO_ROOT_SQUASH`, `ROOT_SQUASH`.
        """
elif False:
    InstanceFileSharesNfsExportOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceFileSharesNfsExportOptionArgs:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[builtins.str]] = None,
                 anon_gid: Optional[pulumi.Input[builtins.int]] = None,
                 anon_uid: Optional[pulumi.Input[builtins.int]] = None,
                 ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 squash_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] access_mode: Either READ_ONLY, for allowing only read requests on the exported directory,
               or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE.
               Default value is `READ_WRITE`.
               Possible values are: `READ_ONLY`, `READ_WRITE`.
        :param pulumi.Input[builtins.int] anon_gid: An integer representing the anonymous group id with a default value of 65534.
               Anon_gid may only be set with squashMode of ROOT_SQUASH. An error will be returned
               if this field is specified for other squashMode settings.
        :param pulumi.Input[builtins.int] anon_uid: An integer representing the anonymous user id with a default value of 65534.
               Anon_uid may only be set with squashMode of ROOT_SQUASH. An error will be returned
               if this field is specified for other squashMode settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ranges: List of either IPv4 addresses, or ranges in CIDR notation which may mount the file share.
               Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned.
               The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        :param pulumi.Input[builtins.str] network: The source VPC network for `ip_ranges`.
               Required for instances using Private Service Connect, optional otherwise.
        :param pulumi.Input[builtins.str] squash_mode: Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH,
               for not allowing root access. The default is NO_ROOT_SQUASH.
               Default value is `NO_ROOT_SQUASH`.
               Possible values are: `NO_ROOT_SQUASH`, `ROOT_SQUASH`.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if anon_gid is not None:
            pulumi.set(__self__, "anon_gid", anon_gid)
        if anon_uid is not None:
            pulumi.set(__self__, "anon_uid", anon_uid)
        if ip_ranges is not None:
            pulumi.set(__self__, "ip_ranges", ip_ranges)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if squash_mode is not None:
            pulumi.set(__self__, "squash_mode", squash_mode)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Either READ_ONLY, for allowing only read requests on the exported directory,
        or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE.
        Default value is `READ_WRITE`.
        Possible values are: `READ_ONLY`, `READ_WRITE`.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="anonGid")
    def anon_gid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer representing the anonymous group id with a default value of 65534.
        Anon_gid may only be set with squashMode of ROOT_SQUASH. An error will be returned
        if this field is specified for other squashMode settings.
        """
        return pulumi.get(self, "anon_gid")

    @anon_gid.setter
    def anon_gid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "anon_gid", value)

    @property
    @pulumi.getter(name="anonUid")
    def anon_uid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer representing the anonymous user id with a default value of 65534.
        Anon_uid may only be set with squashMode of ROOT_SQUASH. An error will be returned
        if this field is specified for other squashMode settings.
        """
        return pulumi.get(self, "anon_uid")

    @anon_uid.setter
    def anon_uid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "anon_uid", value)

    @property
    @pulumi.getter(name="ipRanges")
    def ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of either IPv4 addresses, or ranges in CIDR notation which may mount the file share.
        Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned.
        The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        """
        return pulumi.get(self, "ip_ranges")

    @ip_ranges.setter
    def ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_ranges", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source VPC network for `ip_ranges`.
        Required for instances using Private Service Connect, optional otherwise.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="squashMode")
    def squash_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH,
        for not allowing root access. The default is NO_ROOT_SQUASH.
        Default value is `NO_ROOT_SQUASH`.
        Possible values are: `NO_ROOT_SQUASH`, `ROOT_SQUASH`.
        """
        return pulumi.get(self, "squash_mode")

    @squash_mode.setter
    def squash_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "squash_mode", value)


if not MYPY:
    class InstanceInitialReplicationArgsDict(TypedDict):
        replicas: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceInitialReplicationReplicaArgsDict']]]]
        """
        The replication role.
        Structure is documented below.
        """
        role: NotRequired[pulumi.Input[builtins.str]]
        """
        The replication role.
        Default value is `STANDBY`.
        Possible values are: `ROLE_UNSPECIFIED`, `ACTIVE`, `STANDBY`.
        """
elif False:
    InstanceInitialReplicationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceInitialReplicationArgs:
    def __init__(__self__, *,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInitialReplicationReplicaArgs']]]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceInitialReplicationReplicaArgs']]] replicas: The replication role.
               Structure is documented below.
        :param pulumi.Input[builtins.str] role: The replication role.
               Default value is `STANDBY`.
               Possible values are: `ROLE_UNSPECIFIED`, `ACTIVE`, `STANDBY`.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInitialReplicationReplicaArgs']]]]:
        """
        The replication role.
        Structure is documented below.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInitialReplicationReplicaArgs']]]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The replication role.
        Default value is `STANDBY`.
        Possible values are: `ROLE_UNSPECIFIED`, `ACTIVE`, `STANDBY`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


if not MYPY:
    class InstanceInitialReplicationReplicaArgsDict(TypedDict):
        peer_instance: pulumi.Input[builtins.str]
        """
        The peer instance.
        """
elif False:
    InstanceInitialReplicationReplicaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceInitialReplicationReplicaArgs:
    def __init__(__self__, *,
                 peer_instance: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] peer_instance: The peer instance.
        """
        pulumi.set(__self__, "peer_instance", peer_instance)

    @property
    @pulumi.getter(name="peerInstance")
    def peer_instance(self) -> pulumi.Input[builtins.str]:
        """
        The peer instance.
        """
        return pulumi.get(self, "peer_instance")

    @peer_instance.setter
    def peer_instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "peer_instance", value)


if not MYPY:
    class InstanceNetworkArgsDict(TypedDict):
        modes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        IP versions for which the instance has
        IP addresses assigned.
        Each value may be one of: `ADDRESS_MODE_UNSPECIFIED`, `MODE_IPV4`, `MODE_IPV6`.
        """
        network: pulumi.Input[builtins.str]
        """
        The name of the GCE VPC network to which the
        instance is connected.
        """
        connect_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The network connect mode of the Filestore instance.
        If not provided, the connect mode defaults to
        DIRECT_PEERING.
        Default value is `DIRECT_PEERING`.
        Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`, `PRIVATE_SERVICE_CONNECT`.
        """
        ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Output)
        A list of IPv4 or IPv6 addresses.
        """
        psc_config: NotRequired[pulumi.Input['InstanceNetworkPscConfigArgsDict']]
        """
        Private Service Connect configuration.
        Should only be set when connect_mode is PRIVATE_SERVICE_CONNECT.
        Structure is documented below.
        """
        reserved_ip_range: NotRequired[pulumi.Input[builtins.str]]
        """
        A /29 CIDR block that identifies the range of IP
        addresses reserved for this instance.
        """
elif False:
    InstanceNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNetworkArgs:
    def __init__(__self__, *,
                 modes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 network: pulumi.Input[builtins.str],
                 connect_mode: Optional[pulumi.Input[builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 psc_config: Optional[pulumi.Input['InstanceNetworkPscConfigArgs']] = None,
                 reserved_ip_range: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] modes: IP versions for which the instance has
               IP addresses assigned.
               Each value may be one of: `ADDRESS_MODE_UNSPECIFIED`, `MODE_IPV4`, `MODE_IPV6`.
        :param pulumi.Input[builtins.str] network: The name of the GCE VPC network to which the
               instance is connected.
        :param pulumi.Input[builtins.str] connect_mode: The network connect mode of the Filestore instance.
               If not provided, the connect mode defaults to
               DIRECT_PEERING.
               Default value is `DIRECT_PEERING`.
               Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`, `PRIVATE_SERVICE_CONNECT`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_addresses: (Output)
               A list of IPv4 or IPv6 addresses.
        :param pulumi.Input['InstanceNetworkPscConfigArgs'] psc_config: Private Service Connect configuration.
               Should only be set when connect_mode is PRIVATE_SERVICE_CONNECT.
               Structure is documented below.
        :param pulumi.Input[builtins.str] reserved_ip_range: A /29 CIDR block that identifies the range of IP
               addresses reserved for this instance.
        """
        pulumi.set(__self__, "modes", modes)
        pulumi.set(__self__, "network", network)
        if connect_mode is not None:
            pulumi.set(__self__, "connect_mode", connect_mode)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if psc_config is not None:
            pulumi.set(__self__, "psc_config", psc_config)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)

    @property
    @pulumi.getter
    def modes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        IP versions for which the instance has
        IP addresses assigned.
        Each value may be one of: `ADDRESS_MODE_UNSPECIFIED`, `MODE_IPV4`, `MODE_IPV6`.
        """
        return pulumi.get(self, "modes")

    @modes.setter
    def modes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "modes", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The name of the GCE VPC network to which the
        instance is connected.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network connect mode of the Filestore instance.
        If not provided, the connect mode defaults to
        DIRECT_PEERING.
        Default value is `DIRECT_PEERING`.
        Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`, `PRIVATE_SERVICE_CONNECT`.
        """
        return pulumi.get(self, "connect_mode")

    @connect_mode.setter
    def connect_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connect_mode", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Output)
        A list of IPv4 or IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> Optional[pulumi.Input['InstanceNetworkPscConfigArgs']]:
        """
        Private Service Connect configuration.
        Should only be set when connect_mode is PRIVATE_SERVICE_CONNECT.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @psc_config.setter
    def psc_config(self, value: Optional[pulumi.Input['InstanceNetworkPscConfigArgs']]):
        pulumi.set(self, "psc_config", value)

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A /29 CIDR block that identifies the range of IP
        addresses reserved for this instance.
        """
        return pulumi.get(self, "reserved_ip_range")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reserved_ip_range", value)


if not MYPY:
    class InstanceNetworkPscConfigArgsDict(TypedDict):
        endpoint_project: NotRequired[pulumi.Input[builtins.str]]
        """
        Consumer service project in which the Private Service Connect endpoint
        would be set up. This is optional, and only relevant in case the network
        is a shared VPC. If this is not specified, the endpoint would be set up
        in the VPC host project.
        """
elif False:
    InstanceNetworkPscConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNetworkPscConfigArgs:
    def __init__(__self__, *,
                 endpoint_project: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] endpoint_project: Consumer service project in which the Private Service Connect endpoint
               would be set up. This is optional, and only relevant in case the network
               is a shared VPC. If this is not specified, the endpoint would be set up
               in the VPC host project.
        """
        if endpoint_project is not None:
            pulumi.set(__self__, "endpoint_project", endpoint_project)

    @property
    @pulumi.getter(name="endpointProject")
    def endpoint_project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Consumer service project in which the Private Service Connect endpoint
        would be set up. This is optional, and only relevant in case the network
        is a shared VPC. If this is not specified, the endpoint would be set up
        in the VPC host project.
        """
        return pulumi.get(self, "endpoint_project")

    @endpoint_project.setter
    def endpoint_project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_project", value)


if not MYPY:
    class InstancePerformanceConfigArgsDict(TypedDict):
        fixed_iops: NotRequired[pulumi.Input['InstancePerformanceConfigFixedIopsArgsDict']]
        """
        The instance will have a fixed provisioned IOPS value,
        which will remain constant regardless of instance
        capacity.
        Structure is documented below.
        """
        iops_per_tb: NotRequired[pulumi.Input['InstancePerformanceConfigIopsPerTbArgsDict']]
        """
        The instance provisioned IOPS will change dynamically
        based on the capacity of the instance.
        Structure is documented below.
        """
elif False:
    InstancePerformanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePerformanceConfigArgs:
    def __init__(__self__, *,
                 fixed_iops: Optional[pulumi.Input['InstancePerformanceConfigFixedIopsArgs']] = None,
                 iops_per_tb: Optional[pulumi.Input['InstancePerformanceConfigIopsPerTbArgs']] = None):
        """
        :param pulumi.Input['InstancePerformanceConfigFixedIopsArgs'] fixed_iops: The instance will have a fixed provisioned IOPS value,
               which will remain constant regardless of instance
               capacity.
               Structure is documented below.
        :param pulumi.Input['InstancePerformanceConfigIopsPerTbArgs'] iops_per_tb: The instance provisioned IOPS will change dynamically
               based on the capacity of the instance.
               Structure is documented below.
        """
        if fixed_iops is not None:
            pulumi.set(__self__, "fixed_iops", fixed_iops)
        if iops_per_tb is not None:
            pulumi.set(__self__, "iops_per_tb", iops_per_tb)

    @property
    @pulumi.getter(name="fixedIops")
    def fixed_iops(self) -> Optional[pulumi.Input['InstancePerformanceConfigFixedIopsArgs']]:
        """
        The instance will have a fixed provisioned IOPS value,
        which will remain constant regardless of instance
        capacity.
        Structure is documented below.
        """
        return pulumi.get(self, "fixed_iops")

    @fixed_iops.setter
    def fixed_iops(self, value: Optional[pulumi.Input['InstancePerformanceConfigFixedIopsArgs']]):
        pulumi.set(self, "fixed_iops", value)

    @property
    @pulumi.getter(name="iopsPerTb")
    def iops_per_tb(self) -> Optional[pulumi.Input['InstancePerformanceConfigIopsPerTbArgs']]:
        """
        The instance provisioned IOPS will change dynamically
        based on the capacity of the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "iops_per_tb")

    @iops_per_tb.setter
    def iops_per_tb(self, value: Optional[pulumi.Input['InstancePerformanceConfigIopsPerTbArgs']]):
        pulumi.set(self, "iops_per_tb", value)


if not MYPY:
    class InstancePerformanceConfigFixedIopsArgsDict(TypedDict):
        max_iops: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of IOPS to provision for the instance.
        max_iops must be in multiple of 1000.
        """
elif False:
    InstancePerformanceConfigFixedIopsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePerformanceConfigFixedIopsArgs:
    def __init__(__self__, *,
                 max_iops: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_iops: The number of IOPS to provision for the instance.
               max_iops must be in multiple of 1000.
        """
        if max_iops is not None:
            pulumi.set(__self__, "max_iops", max_iops)

    @property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of IOPS to provision for the instance.
        max_iops must be in multiple of 1000.
        """
        return pulumi.get(self, "max_iops")

    @max_iops.setter
    def max_iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_iops", value)


if not MYPY:
    class InstancePerformanceConfigIopsPerTbArgsDict(TypedDict):
        max_iops_per_tb: NotRequired[pulumi.Input[builtins.int]]
        """
        The instance max IOPS will be calculated by multiplying
        the capacity of the instance (TB) by max_iops_per_tb,
        and rounding to the nearest 1000. The instance max IOPS
        will be changed dynamically based on the instance
        capacity.
        """
elif False:
    InstancePerformanceConfigIopsPerTbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePerformanceConfigIopsPerTbArgs:
    def __init__(__self__, *,
                 max_iops_per_tb: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_iops_per_tb: The instance max IOPS will be calculated by multiplying
               the capacity of the instance (TB) by max_iops_per_tb,
               and rounding to the nearest 1000. The instance max IOPS
               will be changed dynamically based on the instance
               capacity.
        """
        if max_iops_per_tb is not None:
            pulumi.set(__self__, "max_iops_per_tb", max_iops_per_tb)

    @property
    @pulumi.getter(name="maxIopsPerTb")
    def max_iops_per_tb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The instance max IOPS will be calculated by multiplying
        the capacity of the instance (TB) by max_iops_per_tb,
        and rounding to the nearest 1000. The instance max IOPS
        will be changed dynamically based on the instance
        capacity.
        """
        return pulumi.get(self, "max_iops_per_tb")

    @max_iops_per_tb.setter
    def max_iops_per_tb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_iops_per_tb", value)


