# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 file_shares: pulumi.Input['InstanceFileSharesArgs'],
                 networks: pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]],
                 tier: pulumi.Input[builtins.str],
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_services: Optional[pulumi.Input['InstanceDirectoryServicesArgs']] = None,
                 initial_replication: Optional[pulumi.Input['InstanceInitialReplicationArgs']] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 performance_config: Optional[pulumi.Input['InstancePerformanceConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input['InstanceFileSharesArgs'] file_shares: File system shares on the instance. For this version, only a
               single file share is supported.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]] networks: VPC networks to which the instance is connected. For this version,
               only a single network is supported.
               Structure is documented below.
        :param pulumi.Input[builtins.str] tier: The service tier of the instance.
               Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: Indicates whether the instance is protected against deletion.
        :param pulumi.Input[builtins.str] deletion_protection_reason: The reason for enabling deletion protection.
        :param pulumi.Input[builtins.str] description: A description of the instance.
        :param pulumi.Input['InstanceDirectoryServicesArgs'] directory_services: Directory Services configuration.
               Should only be set if protocol is "NFS_V4_1".
               Structure is documented below.
        :param pulumi.Input['InstanceInitialReplicationArgs'] initial_replication: Replication configuration, once set, this cannot be updated.
               Additionally this should be specified on the replica instance only, indicating the active as the peer_instance
               Structure is documented below.
        :param pulumi.Input[builtins.str] kms_key_name: KMS key name used for data encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        :param pulumi.Input[builtins.str] name: The resource name of the instance.
        :param pulumi.Input['InstancePerformanceConfigArgs'] performance_config: Performance configuration for the instance. If not provided,
               the default performance settings will be used.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] protocol: Either NFSv3, for using NFS version 3 as file sharing protocol,
               or NFSv4.1, for using NFS version 4.1 as file sharing protocol.
               NFSv4.1 can be used with HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE.
               The default is NFSv3.
               Default value is `NFS_V3`.
               Possible values are: `NFS_V3`, `NFS_V4_1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of resource manager tags. Resource manager tag keys
               and values have the same definition as resource manager
               tags. Keys must be in the format tagKeys/{tag_key_id},
               and values are in the format tagValues/456. The field is
               ignored when empty. The field is immutable and causes
               resource replacement when mutated. This field is only set
               at create time and modifying this field after creation
               will trigger recreation. To apply tags to an existing
               resource, see the `tags.TagValue` resource.
        :param pulumi.Input[builtins.str] zone: (Optional, Deprecated)
               The name of the Filestore zone of the instance.
               
               > **Warning:** `zone` is deprecated and will be removed in a future major release. Use `location` instead.
        """
        pulumi.set(__self__, "file_shares", file_shares)
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "tier", tier)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deletion_protection_reason is not None:
            pulumi.set(__self__, "deletion_protection_reason", deletion_protection_reason)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directory_services is not None:
            pulumi.set(__self__, "directory_services", directory_services)
        if initial_replication is not None:
            pulumi.set(__self__, "initial_replication", initial_replication)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_config is not None:
            pulumi.set(__self__, "performance_config", performance_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            warnings.warn("""`zone` is deprecated and will be removed in a future major release. Use `location` instead.""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: `zone` is deprecated and will be removed in a future major release. Use `location` instead.""")
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="fileShares")
    def file_shares(self) -> pulumi.Input['InstanceFileSharesArgs']:
        """
        File system shares on the instance. For this version, only a
        single file share is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "file_shares")

    @file_shares.setter
    def file_shares(self, value: pulumi.Input['InstanceFileSharesArgs']):
        pulumi.set(self, "file_shares", value)

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]:
        """
        VPC networks to which the instance is connected. For this version,
        only a single network is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[builtins.str]:
        """
        The service tier of the instance.
        Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the instance is protected against deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for enabling deletion protection.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @deletion_protection_reason.setter
    def deletion_protection_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_protection_reason", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directoryServices")
    def directory_services(self) -> Optional[pulumi.Input['InstanceDirectoryServicesArgs']]:
        """
        Directory Services configuration.
        Should only be set if protocol is "NFS_V4_1".
        Structure is documented below.
        """
        return pulumi.get(self, "directory_services")

    @directory_services.setter
    def directory_services(self, value: Optional[pulumi.Input['InstanceDirectoryServicesArgs']]):
        pulumi.set(self, "directory_services", value)

    @property
    @pulumi.getter(name="initialReplication")
    def initial_replication(self) -> Optional[pulumi.Input['InstanceInitialReplicationArgs']]:
        """
        Replication configuration, once set, this cannot be updated.
        Additionally this should be specified on the replica instance only, indicating the active as the peer_instance
        Structure is documented below.
        """
        return pulumi.get(self, "initial_replication")

    @initial_replication.setter
    def initial_replication(self, value: Optional[pulumi.Input['InstanceInitialReplicationArgs']]):
        pulumi.set(self, "initial_replication", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS key name used for data encryption.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceConfig")
    def performance_config(self) -> Optional[pulumi.Input['InstancePerformanceConfigArgs']]:
        """
        Performance configuration for the instance. If not provided,
        the default performance settings will be used.
        Structure is documented below.
        """
        return pulumi.get(self, "performance_config")

    @performance_config.setter
    def performance_config(self, value: Optional[pulumi.Input['InstancePerformanceConfigArgs']]):
        pulumi.set(self, "performance_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Either NFSv3, for using NFS version 3 as file sharing protocol,
        or NFSv4.1, for using NFS version 4.1 as file sharing protocol.
        NFSv4.1 can be used with HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE.
        The default is NFSv3.
        Default value is `NFS_V3`.
        Possible values are: `NFS_V3`, `NFS_V4_1`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of resource manager tags. Resource manager tag keys
        and values have the same definition as resource manager
        tags. Keys must be in the format tagKeys/{tag_key_id},
        and values are in the format tagValues/456. The field is
        ignored when empty. The field is immutable and causes
        resource replacement when mutated. This field is only set
        at create time and modifying this field after creation
        will trigger recreation. To apply tags to an existing
        resource, see the `tags.TagValue` resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`zone` is deprecated and will be removed in a future major release. Use `location` instead.""")
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional, Deprecated)
        The name of the Filestore zone of the instance.

        > **Warning:** `zone` is deprecated and will be removed in a future major release. Use `location` instead.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_services: Optional[pulumi.Input['InstanceDirectoryServicesArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_replications: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationArgs']]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 file_shares: Optional[pulumi.Input['InstanceFileSharesArgs']] = None,
                 initial_replication: Optional[pulumi.Input['InstanceInitialReplicationArgs']] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]] = None,
                 performance_config: Optional[pulumi.Input['InstancePerformanceConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[builtins.str] create_time: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: Indicates whether the instance is protected against deletion.
        :param pulumi.Input[builtins.str] deletion_protection_reason: The reason for enabling deletion protection.
        :param pulumi.Input[builtins.str] description: A description of the instance.
        :param pulumi.Input['InstanceDirectoryServicesArgs'] directory_services: Directory Services configuration.
               Should only be set if protocol is "NFS_V4_1".
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationArgs']]] effective_replications: Output only fields for replication configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: Server-specified ETag for the instance resource to prevent
               simultaneous updates from overwriting each other.
        :param pulumi.Input['InstanceFileSharesArgs'] file_shares: File system shares on the instance. For this version, only a
               single file share is supported.
               Structure is documented below.
        :param pulumi.Input['InstanceInitialReplicationArgs'] initial_replication: Replication configuration, once set, this cannot be updated.
               Additionally this should be specified on the replica instance only, indicating the active as the peer_instance
               Structure is documented below.
        :param pulumi.Input[builtins.str] kms_key_name: KMS key name used for data encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        :param pulumi.Input[builtins.str] name: The resource name of the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]] networks: VPC networks to which the instance is connected. For this version,
               only a single network is supported.
               Structure is documented below.
        :param pulumi.Input['InstancePerformanceConfigArgs'] performance_config: Performance configuration for the instance. If not provided,
               the default performance settings will be used.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] protocol: Either NFSv3, for using NFS version 3 as file sharing protocol,
               or NFSv4.1, for using NFS version 4.1 as file sharing protocol.
               NFSv4.1 can be used with HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE.
               The default is NFSv3.
               Default value is `NFS_V3`.
               Possible values are: `NFS_V3`, `NFS_V4_1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of resource manager tags. Resource manager tag keys
               and values have the same definition as resource manager
               tags. Keys must be in the format tagKeys/{tag_key_id},
               and values are in the format tagValues/456. The field is
               ignored when empty. The field is immutable and causes
               resource replacement when mutated. This field is only set
               at create time and modifying this field after creation
               will trigger recreation. To apply tags to an existing
               resource, see the `tags.TagValue` resource.
        :param pulumi.Input[builtins.str] tier: The service tier of the instance.
               Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE
        :param pulumi.Input[builtins.str] zone: (Optional, Deprecated)
               The name of the Filestore zone of the instance.
               
               > **Warning:** `zone` is deprecated and will be removed in a future major release. Use `location` instead.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deletion_protection_reason is not None:
            pulumi.set(__self__, "deletion_protection_reason", deletion_protection_reason)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directory_services is not None:
            pulumi.set(__self__, "directory_services", directory_services)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if effective_replications is not None:
            pulumi.set(__self__, "effective_replications", effective_replications)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if file_shares is not None:
            pulumi.set(__self__, "file_shares", file_shares)
        if initial_replication is not None:
            pulumi.set(__self__, "initial_replication", initial_replication)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if performance_config is not None:
            pulumi.set(__self__, "performance_config", performance_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if zone is not None:
            warnings.warn("""`zone` is deprecated and will be removed in a future major release. Use `location` instead.""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: `zone` is deprecated and will be removed in a future major release. Use `location` instead.""")
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the instance is protected against deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for enabling deletion protection.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @deletion_protection_reason.setter
    def deletion_protection_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_protection_reason", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directoryServices")
    def directory_services(self) -> Optional[pulumi.Input['InstanceDirectoryServicesArgs']]:
        """
        Directory Services configuration.
        Should only be set if protocol is "NFS_V4_1".
        Structure is documented below.
        """
        return pulumi.get(self, "directory_services")

    @directory_services.setter
    def directory_services(self, value: Optional[pulumi.Input['InstanceDirectoryServicesArgs']]):
        pulumi.set(self, "directory_services", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="effectiveReplications")
    def effective_replications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationArgs']]]]:
        """
        Output only fields for replication configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "effective_replications")

    @effective_replications.setter
    def effective_replications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEffectiveReplicationArgs']]]]):
        pulumi.set(self, "effective_replications", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-specified ETag for the instance resource to prevent
        simultaneous updates from overwriting each other.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="fileShares")
    def file_shares(self) -> Optional[pulumi.Input['InstanceFileSharesArgs']]:
        """
        File system shares on the instance. For this version, only a
        single file share is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "file_shares")

    @file_shares.setter
    def file_shares(self, value: Optional[pulumi.Input['InstanceFileSharesArgs']]):
        pulumi.set(self, "file_shares", value)

    @property
    @pulumi.getter(name="initialReplication")
    def initial_replication(self) -> Optional[pulumi.Input['InstanceInitialReplicationArgs']]:
        """
        Replication configuration, once set, this cannot be updated.
        Additionally this should be specified on the replica instance only, indicating the active as the peer_instance
        Structure is documented below.
        """
        return pulumi.get(self, "initial_replication")

    @initial_replication.setter
    def initial_replication(self, value: Optional[pulumi.Input['InstanceInitialReplicationArgs']]):
        pulumi.set(self, "initial_replication", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS key name used for data encryption.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]:
        """
        VPC networks to which the instance is connected. For this version,
        only a single network is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="performanceConfig")
    def performance_config(self) -> Optional[pulumi.Input['InstancePerformanceConfigArgs']]:
        """
        Performance configuration for the instance. If not provided,
        the default performance settings will be used.
        Structure is documented below.
        """
        return pulumi.get(self, "performance_config")

    @performance_config.setter
    def performance_config(self, value: Optional[pulumi.Input['InstancePerformanceConfigArgs']]):
        pulumi.set(self, "performance_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Either NFSv3, for using NFS version 3 as file sharing protocol,
        or NFSv4.1, for using NFS version 4.1 as file sharing protocol.
        NFSv4.1 can be used with HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE.
        The default is NFSv3.
        Default value is `NFS_V3`.
        Possible values are: `NFS_V3`, `NFS_V4_1`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of resource manager tags. Resource manager tag keys
        and values have the same definition as resource manager
        tags. Keys must be in the format tagKeys/{tag_key_id},
        and values are in the format tagValues/456. The field is
        ignored when empty. The field is immutable and causes
        resource replacement when mutated. This field is only set
        at create time and modifying this field after creation
        will trigger recreation. To apply tags to an existing
        resource, see the `tags.TagValue` resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service tier of the instance.
        Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`zone` is deprecated and will be removed in a future major release. Use `location` instead.""")
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional, Deprecated)
        The name of the Filestore zone of the instance.

        > **Warning:** `zone` is deprecated and will be removed in a future major release. Use `location` instead.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:filestore/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_services: Optional[pulumi.Input[Union['InstanceDirectoryServicesArgs', 'InstanceDirectoryServicesArgsDict']]] = None,
                 file_shares: Optional[pulumi.Input[Union['InstanceFileSharesArgs', 'InstanceFileSharesArgsDict']]] = None,
                 initial_replication: Optional[pulumi.Input[Union['InstanceInitialReplicationArgs', 'InstanceInitialReplicationArgsDict']]] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
                 performance_config: Optional[pulumi.Input[Union['InstancePerformanceConfigArgs', 'InstancePerformanceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Google Cloud Filestore instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/filestore/docs/reference/rest/v1beta1/projects.locations.instances/create)
        * How-to Guides
            * [Copying Data In/Out](https://cloud.google.com/filestore/docs/copying-data)
            * [Official Documentation](https://cloud.google.com/filestore/docs/creating-instances)
            * [Use with Kubernetes](https://cloud.google.com/filestore/docs/accessing-fileshares)

        ## Example Usage

        ### Filestore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            name="test-instance",
            location="us-central1-b",
            tier="BASIC_HDD",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }])
        ```
        ### Filestore Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            name="test-instance",
            location="us-central1-b",
            tier="BASIC_SSD",
            file_shares={
                "capacity_gb": 2560,
                "name": "share1",
                "nfs_export_options": [
                    {
                        "ip_ranges": ["10.0.0.0/24"],
                        "access_mode": "READ_WRITE",
                        "squash_mode": "NO_ROOT_SQUASH",
                    },
                    {
                        "ip_ranges": ["10.10.0.0/24"],
                        "access_mode": "READ_ONLY",
                        "squash_mode": "ROOT_SQUASH",
                        "anon_uid": 123,
                        "anon_gid": 456,
                    },
                ],
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
                "connect_mode": "DIRECT_PEERING",
            }])
        ```
        ### Filestore Instance Protocol

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            name="test-instance",
            location="us-central1",
            tier="ENTERPRISE",
            protocol="NFS_V4_1",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }])
        ```
        ### Filestore Instance Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        filestore_keyring = gcp.kms.KeyRing("filestore_keyring",
            name="filestore-keyring",
            location="us-central1")
        filestore_key = gcp.kms.CryptoKey("filestore_key",
            name="filestore-key",
            key_ring=filestore_keyring.id)
        instance = gcp.filestore.Instance("instance",
            name="test-instance",
            location="us-central1",
            tier="ENTERPRISE",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }],
            kms_key_name=filestore_key.id)
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:filestore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:filestore/instance:Instance default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:filestore/instance:Instance default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: Indicates whether the instance is protected against deletion.
        :param pulumi.Input[builtins.str] deletion_protection_reason: The reason for enabling deletion protection.
        :param pulumi.Input[builtins.str] description: A description of the instance.
        :param pulumi.Input[Union['InstanceDirectoryServicesArgs', 'InstanceDirectoryServicesArgsDict']] directory_services: Directory Services configuration.
               Should only be set if protocol is "NFS_V4_1".
               Structure is documented below.
        :param pulumi.Input[Union['InstanceFileSharesArgs', 'InstanceFileSharesArgsDict']] file_shares: File system shares on the instance. For this version, only a
               single file share is supported.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceInitialReplicationArgs', 'InstanceInitialReplicationArgsDict']] initial_replication: Replication configuration, once set, this cannot be updated.
               Additionally this should be specified on the replica instance only, indicating the active as the peer_instance
               Structure is documented below.
        :param pulumi.Input[builtins.str] kms_key_name: KMS key name used for data encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        :param pulumi.Input[builtins.str] name: The resource name of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]] networks: VPC networks to which the instance is connected. For this version,
               only a single network is supported.
               Structure is documented below.
        :param pulumi.Input[Union['InstancePerformanceConfigArgs', 'InstancePerformanceConfigArgsDict']] performance_config: Performance configuration for the instance. If not provided,
               the default performance settings will be used.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] protocol: Either NFSv3, for using NFS version 3 as file sharing protocol,
               or NFSv4.1, for using NFS version 4.1 as file sharing protocol.
               NFSv4.1 can be used with HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE.
               The default is NFSv3.
               Default value is `NFS_V3`.
               Possible values are: `NFS_V3`, `NFS_V4_1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of resource manager tags. Resource manager tag keys
               and values have the same definition as resource manager
               tags. Keys must be in the format tagKeys/{tag_key_id},
               and values are in the format tagValues/456. The field is
               ignored when empty. The field is immutable and causes
               resource replacement when mutated. This field is only set
               at create time and modifying this field after creation
               will trigger recreation. To apply tags to an existing
               resource, see the `tags.TagValue` resource.
        :param pulumi.Input[builtins.str] tier: The service tier of the instance.
               Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE
        :param pulumi.Input[builtins.str] zone: (Optional, Deprecated)
               The name of the Filestore zone of the instance.
               
               > **Warning:** `zone` is deprecated and will be removed in a future major release. Use `location` instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Filestore instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/filestore/docs/reference/rest/v1beta1/projects.locations.instances/create)
        * How-to Guides
            * [Copying Data In/Out](https://cloud.google.com/filestore/docs/copying-data)
            * [Official Documentation](https://cloud.google.com/filestore/docs/creating-instances)
            * [Use with Kubernetes](https://cloud.google.com/filestore/docs/accessing-fileshares)

        ## Example Usage

        ### Filestore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            name="test-instance",
            location="us-central1-b",
            tier="BASIC_HDD",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }])
        ```
        ### Filestore Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            name="test-instance",
            location="us-central1-b",
            tier="BASIC_SSD",
            file_shares={
                "capacity_gb": 2560,
                "name": "share1",
                "nfs_export_options": [
                    {
                        "ip_ranges": ["10.0.0.0/24"],
                        "access_mode": "READ_WRITE",
                        "squash_mode": "NO_ROOT_SQUASH",
                    },
                    {
                        "ip_ranges": ["10.10.0.0/24"],
                        "access_mode": "READ_ONLY",
                        "squash_mode": "ROOT_SQUASH",
                        "anon_uid": 123,
                        "anon_gid": 456,
                    },
                ],
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
                "connect_mode": "DIRECT_PEERING",
            }])
        ```
        ### Filestore Instance Protocol

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            name="test-instance",
            location="us-central1",
            tier="ENTERPRISE",
            protocol="NFS_V4_1",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }])
        ```
        ### Filestore Instance Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        filestore_keyring = gcp.kms.KeyRing("filestore_keyring",
            name="filestore-keyring",
            location="us-central1")
        filestore_key = gcp.kms.CryptoKey("filestore_key",
            name="filestore-key",
            key_ring=filestore_keyring.id)
        instance = gcp.filestore.Instance("instance",
            name="test-instance",
            location="us-central1",
            tier="ENTERPRISE",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }],
            kms_key_name=filestore_key.id)
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:filestore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:filestore/instance:Instance default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:filestore/instance:Instance default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_services: Optional[pulumi.Input[Union['InstanceDirectoryServicesArgs', 'InstanceDirectoryServicesArgsDict']]] = None,
                 file_shares: Optional[pulumi.Input[Union['InstanceFileSharesArgs', 'InstanceFileSharesArgsDict']]] = None,
                 initial_replication: Optional[pulumi.Input[Union['InstanceInitialReplicationArgs', 'InstanceInitialReplicationArgsDict']]] = None,
                 kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
                 performance_config: Optional[pulumi.Input[Union['InstancePerformanceConfigArgs', 'InstancePerformanceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["deletion_protection_reason"] = deletion_protection_reason
            __props__.__dict__["description"] = description
            __props__.__dict__["directory_services"] = directory_services
            if file_shares is None and not opts.urn:
                raise TypeError("Missing required property 'file_shares'")
            __props__.__dict__["file_shares"] = file_shares
            __props__.__dict__["initial_replication"] = initial_replication
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if networks is None and not opts.urn:
                raise TypeError("Missing required property 'networks'")
            __props__.__dict__["networks"] = networks
            __props__.__dict__["performance_config"] = performance_config
            __props__.__dict__["project"] = project
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["tags"] = tags
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["zone"] = zone
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["effective_replications"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:filestore/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            deletion_protection_reason: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            directory_services: Optional[pulumi.Input[Union['InstanceDirectoryServicesArgs', 'InstanceDirectoryServicesArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_replications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEffectiveReplicationArgs', 'InstanceEffectiveReplicationArgsDict']]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            file_shares: Optional[pulumi.Input[Union['InstanceFileSharesArgs', 'InstanceFileSharesArgsDict']]] = None,
            initial_replication: Optional[pulumi.Input[Union['InstanceInitialReplicationArgs', 'InstanceInitialReplicationArgsDict']]] = None,
            kms_key_name: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
            performance_config: Optional[pulumi.Input[Union['InstancePerformanceConfigArgs', 'InstancePerformanceConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tier: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: Indicates whether the instance is protected against deletion.
        :param pulumi.Input[builtins.str] deletion_protection_reason: The reason for enabling deletion protection.
        :param pulumi.Input[builtins.str] description: A description of the instance.
        :param pulumi.Input[Union['InstanceDirectoryServicesArgs', 'InstanceDirectoryServicesArgsDict']] directory_services: Directory Services configuration.
               Should only be set if protocol is "NFS_V4_1".
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEffectiveReplicationArgs', 'InstanceEffectiveReplicationArgsDict']]]] effective_replications: Output only fields for replication configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: Server-specified ETag for the instance resource to prevent
               simultaneous updates from overwriting each other.
        :param pulumi.Input[Union['InstanceFileSharesArgs', 'InstanceFileSharesArgsDict']] file_shares: File system shares on the instance. For this version, only a
               single file share is supported.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceInitialReplicationArgs', 'InstanceInitialReplicationArgsDict']] initial_replication: Replication configuration, once set, this cannot be updated.
               Additionally this should be specified on the replica instance only, indicating the active as the peer_instance
               Structure is documented below.
        :param pulumi.Input[builtins.str] kms_key_name: KMS key name used for data encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        :param pulumi.Input[builtins.str] name: The resource name of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]] networks: VPC networks to which the instance is connected. For this version,
               only a single network is supported.
               Structure is documented below.
        :param pulumi.Input[Union['InstancePerformanceConfigArgs', 'InstancePerformanceConfigArgsDict']] performance_config: Performance configuration for the instance. If not provided,
               the default performance settings will be used.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] protocol: Either NFSv3, for using NFS version 3 as file sharing protocol,
               or NFSv4.1, for using NFS version 4.1 as file sharing protocol.
               NFSv4.1 can be used with HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE.
               The default is NFSv3.
               Default value is `NFS_V3`.
               Possible values are: `NFS_V3`, `NFS_V4_1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of resource manager tags. Resource manager tag keys
               and values have the same definition as resource manager
               tags. Keys must be in the format tagKeys/{tag_key_id},
               and values are in the format tagValues/456. The field is
               ignored when empty. The field is immutable and causes
               resource replacement when mutated. This field is only set
               at create time and modifying this field after creation
               will trigger recreation. To apply tags to an existing
               resource, see the `tags.TagValue` resource.
        :param pulumi.Input[builtins.str] tier: The service tier of the instance.
               Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE
        :param pulumi.Input[builtins.str] zone: (Optional, Deprecated)
               The name of the Filestore zone of the instance.
               
               > **Warning:** `zone` is deprecated and will be removed in a future major release. Use `location` instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["deletion_protection_reason"] = deletion_protection_reason
        __props__.__dict__["description"] = description
        __props__.__dict__["directory_services"] = directory_services
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["effective_replications"] = effective_replications
        __props__.__dict__["etag"] = etag
        __props__.__dict__["file_shares"] = file_shares
        __props__.__dict__["initial_replication"] = initial_replication
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["performance_config"] = performance_config
        __props__.__dict__["project"] = project
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tier"] = tier
        __props__.__dict__["zone"] = zone
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the instance is protected against deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The reason for enabling deletion protection.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryServices")
    def directory_services(self) -> pulumi.Output[Optional['outputs.InstanceDirectoryServices']]:
        """
        Directory Services configuration.
        Should only be set if protocol is "NFS_V4_1".
        Structure is documented below.
        """
        return pulumi.get(self, "directory_services")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="effectiveReplications")
    def effective_replications(self) -> pulumi.Output[Sequence['outputs.InstanceEffectiveReplication']]:
        """
        Output only fields for replication configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "effective_replications")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Server-specified ETag for the instance resource to prevent
        simultaneous updates from overwriting each other.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="fileShares")
    def file_shares(self) -> pulumi.Output['outputs.InstanceFileShares']:
        """
        File system shares on the instance. For this version, only a
        single file share is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "file_shares")

    @property
    @pulumi.getter(name="initialReplication")
    def initial_replication(self) -> pulumi.Output[Optional['outputs.InstanceInitialReplication']]:
        """
        Replication configuration, once set, this cannot be updated.
        Additionally this should be specified on the replica instance only, indicating the active as the peer_instance
        Structure is documented below.
        """
        return pulumi.get(self, "initial_replication")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        KMS key name used for data encryption.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.InstanceNetwork']]:
        """
        VPC networks to which the instance is connected. For this version,
        only a single network is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="performanceConfig")
    def performance_config(self) -> pulumi.Output[Optional['outputs.InstancePerformanceConfig']]:
        """
        Performance configuration for the instance. If not provided,
        the default performance settings will be used.
        Structure is documented below.
        """
        return pulumi.get(self, "performance_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Either NFSv3, for using NFS version 3 as file sharing protocol,
        or NFSv4.1, for using NFS version 4.1 as file sharing protocol.
        NFSv4.1 can be used with HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE.
        The default is NFSv3.
        Default value is `NFS_V3`.
        Possible values are: `NFS_V3`, `NFS_V4_1`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of resource manager tags. Resource manager tag keys
        and values have the same definition as resource manager
        tags. Keys must be in the format tagKeys/{tag_key_id},
        and values are in the format tagValues/456. The field is
        ignored when empty. The field is immutable and causes
        resource replacement when mutated. This field is only set
        at create time and modifying this field after creation
        will trigger recreation. To apply tags to an existing
        resource, see the `tags.TagValue` resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[builtins.str]:
        """
        The service tier of the instance.
        Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD, ZONAL, REGIONAL and ENTERPRISE
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    @_utilities.deprecated("""`zone` is deprecated and will be removed in a future major release. Use `location` instead.""")
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        (Optional, Deprecated)
        The name of the Filestore zone of the instance.

        > **Warning:** `zone` is deprecated and will be removed in a future major release. Use `location` instead.
        """
        return pulumi.get(self, "zone")

