# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppCheckAppAttestConfigArgs', 'AppCheckAppAttestConfig']

@pulumi.input_type
class AppCheckAppAttestConfigArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 token_ttl: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AppCheckAppAttestConfig resource.
        :param pulumi.Input[builtins.str] app_id: The ID of an
               [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] token_ttl: Specifies the duration for which App Check tokens exchanged from App Attest artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "app_id", app_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of an
        [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the duration for which App Check tokens exchanged from App Attest artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_ttl", value)


@pulumi.input_type
class _AppCheckAppAttestConfigState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 token_ttl: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppCheckAppAttestConfig resources.
        :param pulumi.Input[builtins.str] app_id: The ID of an
               [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        :param pulumi.Input[builtins.str] name: The relative resource name of the App Attest configuration object
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] token_ttl: Specifies the duration for which App Check tokens exchanged from App Attest artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of an
        [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name of the App Attest configuration object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the duration for which App Check tokens exchanged from App Attest artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_ttl", value)


@pulumi.type_token("gcp:firebase/appCheckAppAttestConfig:AppCheckAppAttestConfig")
class AppCheckAppAttestConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 token_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An app's App Attest configuration object. Note that the Team ID registered with your
        app is used as part of the validation process. Make sure your `firebase.AppleApp` has a team_id present.

        To get more information about AppAttestConfig, see:

        * [API documentation](https://firebase.google.com/docs/reference/appcheck/rest/v1/projects.apps.appAttestConfig)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/docs/app-check)

        ## Example Usage

        ### Firebase App Check App Attest Config Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Apple app",
            bundle_id="bundle.id.appattest",
            team_id="9987654321")
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_app_attest_config = gcp.firebase.AppCheckAppAttestConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```
        ### Firebase App Check App Attest Config Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Apple app",
            bundle_id="bundle.id.appattest",
            team_id="9987654321")
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_app_attest_config = gcp.firebase.AppCheckAppAttestConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            token_ttl="7200s",
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```

        ## Import

        AppAttestConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/apps/{{app_id}}/appAttestConfig`

        * `{{project}}/{{app_id}}`

        * `{{app_id}}`

        When using the `pulumi import` command, AppAttestConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appCheckAppAttestConfig:AppCheckAppAttestConfig default projects/{{project}}/apps/{{app_id}}/appAttestConfig
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckAppAttestConfig:AppCheckAppAttestConfig default {{project}}/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckAppAttestConfig:AppCheckAppAttestConfig default {{app_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_id: The ID of an
               [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] token_ttl: Specifies the duration for which App Check tokens exchanged from App Attest artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppCheckAppAttestConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An app's App Attest configuration object. Note that the Team ID registered with your
        app is used as part of the validation process. Make sure your `firebase.AppleApp` has a team_id present.

        To get more information about AppAttestConfig, see:

        * [API documentation](https://firebase.google.com/docs/reference/appcheck/rest/v1/projects.apps.appAttestConfig)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/docs/app-check)

        ## Example Usage

        ### Firebase App Check App Attest Config Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Apple app",
            bundle_id="bundle.id.appattest",
            team_id="9987654321")
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_app_attest_config = gcp.firebase.AppCheckAppAttestConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```
        ### Firebase App Check App Attest Config Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Apple app",
            bundle_id="bundle.id.appattest",
            team_id="9987654321")
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_app_attest_config = gcp.firebase.AppCheckAppAttestConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            token_ttl="7200s",
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```

        ## Import

        AppAttestConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/apps/{{app_id}}/appAttestConfig`

        * `{{project}}/{{app_id}}`

        * `{{app_id}}`

        When using the `pulumi import` command, AppAttestConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appCheckAppAttestConfig:AppCheckAppAttestConfig default projects/{{project}}/apps/{{app_id}}/appAttestConfig
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckAppAttestConfig:AppCheckAppAttestConfig default {{project}}/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckAppAttestConfig:AppCheckAppAttestConfig default {{app_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AppCheckAppAttestConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppCheckAppAttestConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 token_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppCheckAppAttestConfigArgs.__new__(AppCheckAppAttestConfigArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["project"] = project
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["name"] = None
        super(AppCheckAppAttestConfig, __self__).__init__(
            'gcp:firebase/appCheckAppAttestConfig:AppCheckAppAttestConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            token_ttl: Optional[pulumi.Input[builtins.str]] = None) -> 'AppCheckAppAttestConfig':
        """
        Get an existing AppCheckAppAttestConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_id: The ID of an
               [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        :param pulumi.Input[builtins.str] name: The relative resource name of the App Attest configuration object
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] token_ttl: Specifies the duration for which App Check tokens exchanged from App Attest artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppCheckAppAttestConfigState.__new__(_AppCheckAppAttestConfigState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["token_ttl"] = token_ttl
        return AppCheckAppAttestConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of an
        [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The relative resource name of the App Attest configuration object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the duration for which App Check tokens exchanged from App Attest artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

