# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppHostingDefaultDomainArgs', 'AppHostingDefaultDomain']

@pulumi.input_type
class AppHostingDefaultDomainArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[builtins.str],
                 domain_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AppHostingDefaultDomain resource.
        :param pulumi.Input[builtins.str] backend: The ID of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] domain_id: Id of the domain. For default domain, it should be {{backend}}--{{project_id}}.{{location}}.hosted.app
        :param pulumi.Input[builtins.str] location: The location of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.bool] disabled: Whether the domain is disabled. Defaults to false.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "location", location)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the domain. For default domain, it should be {{backend}}--{{project_id}}.{{location}}.hosted.app
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the domain is disabled. Defaults to false.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AppHostingDefaultDomainState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppHostingDefaultDomain resources.
        :param pulumi.Input[builtins.str] backend: The ID of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] create_time: Time at which the domain was created.
        :param pulumi.Input[builtins.bool] disabled: Whether the domain is disabled. Defaults to false.
        :param pulumi.Input[builtins.str] domain_id: Id of the domain. For default domain, it should be {{backend}}--{{project_id}}.{{location}}.hosted.app
        :param pulumi.Input[builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[builtins.str] location: The location of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the domain, e.g.
               `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{domainId}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[builtins.str] update_time: Time at which the domain was last updated.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the domain was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the domain is disabled. Defaults to false.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the domain. For default domain, it should be {{backend}}--{{project_id}}.{{location}}.hosted.app
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The resource name of the domain, e.g.
        `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{domainId}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the domain was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:firebase/appHostingDefaultDomain:AppHostingDefaultDomain")
class AppHostingDefaultDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A domain name that is associated with a backend.

        ## Example Usage

        ### Firebase App Hosting Default Domain Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="service-account",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="dd-mini",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDefaultDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id=example_app_hosting_backend.uri)
        ```
        ### Firebase App Hosting Default Domain Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="service-account",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="dd-full",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDefaultDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id=example_app_hosting_backend.uri,
            disabled=False)
        ```
        ### Firebase App Hosting Default Domain Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="service-account",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="dd-disabled",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDefaultDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id=example_app_hosting_backend.uri,
            disabled=True)
        ```

        ## Import

        DefaultDomain can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend}}/domains/{{domain_id}}`

        * `{{project}}/{{location}}/{{backend}}/{{domain_id}}`

        * `{{location}}/{{backend}}/{{domain_id}}`

        When using the `pulumi import` command, DefaultDomain can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingDefaultDomain:AppHostingDefaultDomain default projects/{{project}}/locations/{{location}}/backends/{{backend}}/domains/{{domain_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingDefaultDomain:AppHostingDefaultDomain default {{project}}/{{location}}/{{backend}}/{{domain_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingDefaultDomain:AppHostingDefaultDomain default {{location}}/{{backend}}/{{domain_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: The ID of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.bool] disabled: Whether the domain is disabled. Defaults to false.
        :param pulumi.Input[builtins.str] domain_id: Id of the domain. For default domain, it should be {{backend}}--{{project_id}}.{{location}}.hosted.app
        :param pulumi.Input[builtins.str] location: The location of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppHostingDefaultDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A domain name that is associated with a backend.

        ## Example Usage

        ### Firebase App Hosting Default Domain Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="service-account",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="dd-mini",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDefaultDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id=example_app_hosting_backend.uri)
        ```
        ### Firebase App Hosting Default Domain Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="service-account",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="dd-full",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDefaultDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id=example_app_hosting_backend.uri,
            disabled=False)
        ```
        ### Firebase App Hosting Default Domain Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="service-account",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="dd-disabled",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDefaultDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id=example_app_hosting_backend.uri,
            disabled=True)
        ```

        ## Import

        DefaultDomain can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend}}/domains/{{domain_id}}`

        * `{{project}}/{{location}}/{{backend}}/{{domain_id}}`

        * `{{location}}/{{backend}}/{{domain_id}}`

        When using the `pulumi import` command, DefaultDomain can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingDefaultDomain:AppHostingDefaultDomain default projects/{{project}}/locations/{{location}}/backends/{{backend}}/domains/{{domain_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingDefaultDomain:AppHostingDefaultDomain default {{project}}/{{location}}/{{backend}}/{{domain_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingDefaultDomain:AppHostingDefaultDomain default {{location}}/{{backend}}/{{domain_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AppHostingDefaultDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppHostingDefaultDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppHostingDefaultDomainArgs.__new__(AppHostingDefaultDomainArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["disabled"] = disabled
            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(AppHostingDefaultDomain, __self__).__init__(
            'gcp:firebase/appHostingDefaultDomain:AppHostingDefaultDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            domain_id: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'AppHostingDefaultDomain':
        """
        Get an existing AppHostingDefaultDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: The ID of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] create_time: Time at which the domain was created.
        :param pulumi.Input[builtins.bool] disabled: Whether the domain is disabled. Defaults to false.
        :param pulumi.Input[builtins.str] domain_id: Id of the domain. For default domain, it should be {{backend}}--{{project_id}}.{{location}}.hosted.app
        :param pulumi.Input[builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[builtins.str] location: The location of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the domain, e.g.
               `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{domainId}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[builtins.str] update_time: Time at which the domain was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppHostingDefaultDomainState.__new__(_AppHostingDefaultDomainState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return AppHostingDefaultDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the domain was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the domain is disabled. Defaults to false.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the domain. For default domain, it should be {{backend}}--{{project_id}}.{{location}}.hosted.app
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The resource name of the domain, e.g.
        `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{domainId}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the domain was last updated.
        """
        return pulumi.get(self, "update_time")

