# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostingVersionArgs', 'HostingVersion']

@pulumi.input_type
class HostingVersionArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[builtins.str],
                 config: Optional[pulumi.Input['HostingVersionConfigArgs']] = None):
        """
        The set of arguments for constructing a HostingVersion resource.
        :param pulumi.Input[builtins.str] site_id: Required. The ID of the site in which to create this Version.
        :param pulumi.Input['HostingVersionConfigArgs'] config: The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
               Structure is documented below.
        """
        pulumi.set(__self__, "site_id", site_id)
        if config is not None:
            pulumi.set(__self__, "config", config)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. The ID of the site in which to create this Version.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['HostingVersionConfigArgs']]:
        """
        The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['HostingVersionConfigArgs']]):
        pulumi.set(self, "config", value)


@pulumi.input_type
class _HostingVersionState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['HostingVersionConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering HostingVersion resources.
        :param pulumi.Input['HostingVersionConfigArgs'] config: The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The fully-qualified resource name for the version, in the format:
               sites/SITE_ID/versions/VERSION_ID
        :param pulumi.Input[builtins.str] site_id: Required. The ID of the site in which to create this Version.
        :param pulumi.Input[builtins.str] version_id: The ID for the version as in sites/SITE_ID/versions/VERSION_ID
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['HostingVersionConfigArgs']]:
        """
        The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['HostingVersionConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fully-qualified resource name for the version, in the format:
        sites/SITE_ID/versions/VERSION_ID
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The ID of the site in which to create this Version.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID for the version as in sites/SITE_ID/versions/VERSION_ID
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_id", value)


@pulumi.type_token("gcp:firebase/hostingVersion:HostingVersion")
class HostingVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['HostingVersionConfigArgs', 'HostingVersionConfigArgsDict']]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Firebasehosting Version Redirect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "redirects": [{
                    "glob": "/google/**",
                    "status_code": 302,
                    "location": "https://www.google.com",
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Redirect to Google")
        ```
        ### Firebasehosting Version Headers

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "headers": [{
                    "glob": "/headers/**",
                    "headers": {
                        "my-header": "my-value",
                    },
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="With custom headers")
        ```
        ### Firebasehosting Version Headers Regex

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "headers": [{
                    "regex": "^~/headers$",
                    "headers": {
                        "my-header": "my-value",
                    },
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="With custom headers")
        ```
        ### Firebasehosting Version Path

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "rewrites": [{
                    "glob": "**",
                    "path": "/index.html",
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Path Rewrite")
        ```
        ### Firebasehosting Version Cloud Run

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_service = gcp.cloudrunv2.Service("default",
            project="my-project-name",
            name="cloud-run-service-via-hosting",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            },
            deletion_protection=True)
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "rewrites": [{
                    "glob": "/hello/**",
                    "run": {
                        "service_id": default_service.name,
                        "region": default_service.location,
                    },
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Run Integration")
        ```
        ### Firebasehosting Version Cloud Functions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        bucket = gcp.storage.Bucket("bucket",
            project="my-project-name",
            name="site-id-function-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            project="my-project-name",
            name="cloud-function-via-hosting",
            location="us-central1",
            description="A Cloud Function connected to Firebase Hosing",
            build_config={
                "runtime": "nodejs22",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            })
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "rewrites": [{
                    "glob": "/hello/**",
                    "function": function.name,
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Functions Integration")
        ```

        ## Import

        Version can be imported using any of these accepted formats:

        * `sites/{{site_id}}/versions/{{version_id}}`

        * `{{site_id}}/{{version_id}}`

        When using the `pulumi import` command, Version can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/hostingVersion:HostingVersion default sites/{{site_id}}/versions/{{version_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/hostingVersion:HostingVersion default {{site_id}}/{{version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['HostingVersionConfigArgs', 'HostingVersionConfigArgsDict']] config: The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
               Structure is documented below.
        :param pulumi.Input[builtins.str] site_id: Required. The ID of the site in which to create this Version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostingVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Firebasehosting Version Redirect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "redirects": [{
                    "glob": "/google/**",
                    "status_code": 302,
                    "location": "https://www.google.com",
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Redirect to Google")
        ```
        ### Firebasehosting Version Headers

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "headers": [{
                    "glob": "/headers/**",
                    "headers": {
                        "my-header": "my-value",
                    },
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="With custom headers")
        ```
        ### Firebasehosting Version Headers Regex

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "headers": [{
                    "regex": "^~/headers$",
                    "headers": {
                        "my-header": "my-value",
                    },
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="With custom headers")
        ```
        ### Firebasehosting Version Path

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "rewrites": [{
                    "glob": "**",
                    "path": "/index.html",
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Path Rewrite")
        ```
        ### Firebasehosting Version Cloud Run

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_service = gcp.cloudrunv2.Service("default",
            project="my-project-name",
            name="cloud-run-service-via-hosting",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            },
            deletion_protection=True)
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "rewrites": [{
                    "glob": "/hello/**",
                    "run": {
                        "service_id": default_service.name,
                        "region": default_service.location,
                    },
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Run Integration")
        ```
        ### Firebasehosting Version Cloud Functions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        bucket = gcp.storage.Bucket("bucket",
            project="my-project-name",
            name="site-id-function-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            project="my-project-name",
            name="cloud-function-via-hosting",
            location="us-central1",
            description="A Cloud Function connected to Firebase Hosing",
            build_config={
                "runtime": "nodejs22",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            })
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "rewrites": [{
                    "glob": "/hello/**",
                    "function": function.name,
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Functions Integration")
        ```

        ## Import

        Version can be imported using any of these accepted formats:

        * `sites/{{site_id}}/versions/{{version_id}}`

        * `{{site_id}}/{{version_id}}`

        When using the `pulumi import` command, Version can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/hostingVersion:HostingVersion default sites/{{site_id}}/versions/{{version_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/hostingVersion:HostingVersion default {{site_id}}/{{version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param HostingVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostingVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['HostingVersionConfigArgs', 'HostingVersionConfigArgsDict']]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostingVersionArgs.__new__(HostingVersionArgs)

            __props__.__dict__["config"] = config
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["name"] = None
            __props__.__dict__["version_id"] = None
        super(HostingVersion, __self__).__init__(
            'gcp:firebase/hostingVersion:HostingVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['HostingVersionConfigArgs', 'HostingVersionConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            site_id: Optional[pulumi.Input[builtins.str]] = None,
            version_id: Optional[pulumi.Input[builtins.str]] = None) -> 'HostingVersion':
        """
        Get an existing HostingVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['HostingVersionConfigArgs', 'HostingVersionConfigArgsDict']] config: The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The fully-qualified resource name for the version, in the format:
               sites/SITE_ID/versions/VERSION_ID
        :param pulumi.Input[builtins.str] site_id: Required. The ID of the site in which to create this Version.
        :param pulumi.Input[builtins.str] version_id: The ID for the version as in sites/SITE_ID/versions/VERSION_ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostingVersionState.__new__(_HostingVersionState)

        __props__.__dict__["config"] = config
        __props__.__dict__["name"] = name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["version_id"] = version_id
        return HostingVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.HostingVersionConfig']]:
        """
        The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The fully-qualified resource name for the version, in the format:
        sites/SITE_ID/versions/VERSION_ID
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. The ID of the site in which to create this Version.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID for the version as in sites/SITE_ID/versions/VERSION_ID
        """
        return pulumi.get(self, "version_id")

