# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDocumentResult',
    'AwaitableGetDocumentResult',
    'get_document',
    'get_document_output',
]

@pulumi.output_type
class GetDocumentResult:
    """
    A collection of values returned by getDocument.
    """
    def __init__(__self__, collection=None, create_time=None, database=None, document_id=None, fields=None, id=None, name=None, path=None, project=None, update_time=None):
        if collection and not isinstance(collection, str):
            raise TypeError("Expected argument 'collection' to be a str")
        pulumi.set(__self__, "collection", collection)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if document_id and not isinstance(document_id, str):
            raise TypeError("Expected argument 'document_id' to be a str")
        pulumi.set(__self__, "document_id", document_id)
        if fields and not isinstance(fields, str):
            raise TypeError("Expected argument 'fields' to be a str")
        pulumi.set(__self__, "fields", fields)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def collection(self) -> builtins.str:
        return pulumi.get(self, "collection")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def database(self) -> builtins.str:
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="documentId")
    def document_id(self) -> builtins.str:
        return pulumi.get(self, "document_id")

    @property
    @pulumi.getter
    def fields(self) -> builtins.str:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> builtins.str:
        return pulumi.get(self, "update_time")


class AwaitableGetDocumentResult(GetDocumentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDocumentResult(
            collection=self.collection,
            create_time=self.create_time,
            database=self.database,
            document_id=self.document_id,
            fields=self.fields,
            id=self.id,
            name=self.name,
            path=self.path,
            project=self.project,
            update_time=self.update_time)


def get_document(collection: Optional[builtins.str] = None,
                 database: Optional[builtins.str] = None,
                 document_id: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDocumentResult:
    """
    Reads a document from a Firestore database.
    See [the official documentation](https://cloud.google.com/firestore/native/docs/)
    and
    [API](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.documents/get/).

    ## Example Usage

    Retrieve a document from the Firestore database.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    mydoc = gcp.firestore.Document("mydoc",
        project=database["project"],
        database=database["name"],
        collection="somenewcollection",
        document_id="my-doc-id")
    ```


    :param builtins.str collection: The name of the collection of documents.
    :param builtins.str database: The name of the Firestore database.
    :param builtins.str document_id: The id of the document to get.
    :param builtins.str project: The project in which the database resides.
    """
    __args__ = dict()
    __args__['collection'] = collection
    __args__['database'] = database
    __args__['documentId'] = document_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:firestore/getDocument:getDocument', __args__, opts=opts, typ=GetDocumentResult).value

    return AwaitableGetDocumentResult(
        collection=pulumi.get(__ret__, 'collection'),
        create_time=pulumi.get(__ret__, 'create_time'),
        database=pulumi.get(__ret__, 'database'),
        document_id=pulumi.get(__ret__, 'document_id'),
        fields=pulumi.get(__ret__, 'fields'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        path=pulumi.get(__ret__, 'path'),
        project=pulumi.get(__ret__, 'project'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_document_output(collection: Optional[pulumi.Input[builtins.str]] = None,
                        database: Optional[pulumi.Input[builtins.str]] = None,
                        document_id: Optional[pulumi.Input[builtins.str]] = None,
                        project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDocumentResult]:
    """
    Reads a document from a Firestore database.
    See [the official documentation](https://cloud.google.com/firestore/native/docs/)
    and
    [API](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.documents/get/).

    ## Example Usage

    Retrieve a document from the Firestore database.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    mydoc = gcp.firestore.Document("mydoc",
        project=database["project"],
        database=database["name"],
        collection="somenewcollection",
        document_id="my-doc-id")
    ```


    :param builtins.str collection: The name of the collection of documents.
    :param builtins.str database: The name of the Firestore database.
    :param builtins.str document_id: The id of the document to get.
    :param builtins.str project: The project in which the database resides.
    """
    __args__ = dict()
    __args__['collection'] = collection
    __args__['database'] = database
    __args__['documentId'] = document_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:firestore/getDocument:getDocument', __args__, opts=opts, typ=GetDocumentResult)
    return __ret__.apply(lambda __response__: GetDocumentResult(
        collection=pulumi.get(__response__, 'collection'),
        create_time=pulumi.get(__response__, 'create_time'),
        database=pulumi.get(__response__, 'database'),
        document_id=pulumi.get(__response__, 'document_id'),
        fields=pulumi.get(__response__, 'fields'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        path=pulumi.get(__response__, 'path'),
        project=pulumi.get(__response__, 'project'),
        update_time=pulumi.get(__response__, 'update_time')))
