# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataSharingWithGoogleSettingArgs', 'DataSharingWithGoogleSetting']

@pulumi.input_type
class DataSharingWithGoogleSettingArgs:
    def __init__(__self__, *,
                 data_sharing_with_google_setting_id: pulumi.Input[builtins.str],
                 enable_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_preview_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataSharingWithGoogleSetting resource.
        :param pulumi.Input[builtins.str] data_sharing_with_google_setting_id: Id of the Data Sharing With Google Setting.
        :param pulumi.Input[builtins.bool] enable_data_sharing: Whether data sharing should be enabled in GA products.
        :param pulumi.Input[builtins.bool] enable_preview_data_sharing: Whether data sharing should be enabled in Preview products.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "data_sharing_with_google_setting_id", data_sharing_with_google_setting_id)
        if enable_data_sharing is not None:
            pulumi.set(__self__, "enable_data_sharing", enable_data_sharing)
        if enable_preview_data_sharing is not None:
            pulumi.set(__self__, "enable_preview_data_sharing", enable_preview_data_sharing)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dataSharingWithGoogleSettingId")
    def data_sharing_with_google_setting_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the Data Sharing With Google Setting.
        """
        return pulumi.get(self, "data_sharing_with_google_setting_id")

    @data_sharing_with_google_setting_id.setter
    def data_sharing_with_google_setting_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_sharing_with_google_setting_id", value)

    @property
    @pulumi.getter(name="enableDataSharing")
    def enable_data_sharing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether data sharing should be enabled in GA products.
        """
        return pulumi.get(self, "enable_data_sharing")

    @enable_data_sharing.setter
    def enable_data_sharing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_data_sharing", value)

    @property
    @pulumi.getter(name="enablePreviewDataSharing")
    def enable_preview_data_sharing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether data sharing should be enabled in Preview products.
        """
        return pulumi.get(self, "enable_preview_data_sharing")

    @enable_preview_data_sharing.setter
    def enable_preview_data_sharing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_preview_data_sharing", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DataSharingWithGoogleSettingState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 data_sharing_with_google_setting_id: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enable_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_preview_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataSharingWithGoogleSetting resources.
        :param pulumi.Input[builtins.str] create_time: Create time stamp.
        :param pulumi.Input[builtins.str] data_sharing_with_google_setting_id: Id of the Data Sharing With Google Setting.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_data_sharing: Whether data sharing should be enabled in GA products.
        :param pulumi.Input[builtins.bool] enable_preview_data_sharing: Whether data sharing should be enabled in Preview products.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the resource.
               Format:projects/{project}/locations/{location}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSetting}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: Update time stamp.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_sharing_with_google_setting_id is not None:
            pulumi.set(__self__, "data_sharing_with_google_setting_id", data_sharing_with_google_setting_id)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_data_sharing is not None:
            pulumi.set(__self__, "enable_data_sharing", enable_data_sharing)
        if enable_preview_data_sharing is not None:
            pulumi.set(__self__, "enable_preview_data_sharing", enable_preview_data_sharing)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Create time stamp.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataSharingWithGoogleSettingId")
    def data_sharing_with_google_setting_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the Data Sharing With Google Setting.
        """
        return pulumi.get(self, "data_sharing_with_google_setting_id")

    @data_sharing_with_google_setting_id.setter
    def data_sharing_with_google_setting_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_sharing_with_google_setting_id", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="enableDataSharing")
    def enable_data_sharing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether data sharing should be enabled in GA products.
        """
        return pulumi.get(self, "enable_data_sharing")

    @enable_data_sharing.setter
    def enable_data_sharing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_data_sharing", value)

    @property
    @pulumi.getter(name="enablePreviewDataSharing")
    def enable_preview_data_sharing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether data sharing should be enabled in Preview products.
        """
        return pulumi.get(self, "enable_preview_data_sharing")

    @enable_preview_data_sharing.setter
    def enable_preview_data_sharing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_preview_data_sharing", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. Name of the resource.
        Format:projects/{project}/locations/{location}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSetting}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Update time stamp.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:gemini/dataSharingWithGoogleSetting:DataSharingWithGoogleSetting")
class DataSharingWithGoogleSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_sharing_with_google_setting_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_preview_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The resource for managing DataSharingWithGoogle settings for Admin Control.

        ## Example Usage

        ### Gemini Data Sharing With Google Setting Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.gemini.DataSharingWithGoogleSetting("example",
            data_sharing_with_google_setting_id="ls1-tf",
            location="global",
            labels={
                "my_key": "my_value",
            },
            enable_preview_data_sharing=True,
            enable_data_sharing=True)
        ```

        ## Import

        DataSharingWithGoogleSetting can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataSharingWithGoogleSettings/{{data_sharing_with_google_setting_id}}`

        * `{{project}}/{{location}}/{{data_sharing_with_google_setting_id}}`

        * `{{location}}/{{data_sharing_with_google_setting_id}}`

        When using the `pulumi import` command, DataSharingWithGoogleSetting can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gemini/dataSharingWithGoogleSetting:DataSharingWithGoogleSetting default projects/{{project}}/locations/{{location}}/dataSharingWithGoogleSettings/{{data_sharing_with_google_setting_id}}
        ```

        ```sh
        $ pulumi import gcp:gemini/dataSharingWithGoogleSetting:DataSharingWithGoogleSetting default {{project}}/{{location}}/{{data_sharing_with_google_setting_id}}
        ```

        ```sh
        $ pulumi import gcp:gemini/dataSharingWithGoogleSetting:DataSharingWithGoogleSetting default {{location}}/{{data_sharing_with_google_setting_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_sharing_with_google_setting_id: Id of the Data Sharing With Google Setting.
        :param pulumi.Input[builtins.bool] enable_data_sharing: Whether data sharing should be enabled in GA products.
        :param pulumi.Input[builtins.bool] enable_preview_data_sharing: Whether data sharing should be enabled in Preview products.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSharingWithGoogleSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The resource for managing DataSharingWithGoogle settings for Admin Control.

        ## Example Usage

        ### Gemini Data Sharing With Google Setting Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.gemini.DataSharingWithGoogleSetting("example",
            data_sharing_with_google_setting_id="ls1-tf",
            location="global",
            labels={
                "my_key": "my_value",
            },
            enable_preview_data_sharing=True,
            enable_data_sharing=True)
        ```

        ## Import

        DataSharingWithGoogleSetting can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataSharingWithGoogleSettings/{{data_sharing_with_google_setting_id}}`

        * `{{project}}/{{location}}/{{data_sharing_with_google_setting_id}}`

        * `{{location}}/{{data_sharing_with_google_setting_id}}`

        When using the `pulumi import` command, DataSharingWithGoogleSetting can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gemini/dataSharingWithGoogleSetting:DataSharingWithGoogleSetting default projects/{{project}}/locations/{{location}}/dataSharingWithGoogleSettings/{{data_sharing_with_google_setting_id}}
        ```

        ```sh
        $ pulumi import gcp:gemini/dataSharingWithGoogleSetting:DataSharingWithGoogleSetting default {{project}}/{{location}}/{{data_sharing_with_google_setting_id}}
        ```

        ```sh
        $ pulumi import gcp:gemini/dataSharingWithGoogleSetting:DataSharingWithGoogleSetting default {{location}}/{{data_sharing_with_google_setting_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DataSharingWithGoogleSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSharingWithGoogleSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_sharing_with_google_setting_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_preview_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSharingWithGoogleSettingArgs.__new__(DataSharingWithGoogleSettingArgs)

            if data_sharing_with_google_setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_sharing_with_google_setting_id'")
            __props__.__dict__["data_sharing_with_google_setting_id"] = data_sharing_with_google_setting_id
            __props__.__dict__["enable_data_sharing"] = enable_data_sharing
            __props__.__dict__["enable_preview_data_sharing"] = enable_preview_data_sharing
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DataSharingWithGoogleSetting, __self__).__init__(
            'gcp:gemini/dataSharingWithGoogleSetting:DataSharingWithGoogleSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            data_sharing_with_google_setting_id: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            enable_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
            enable_preview_data_sharing: Optional[pulumi.Input[builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'DataSharingWithGoogleSetting':
        """
        Get an existing DataSharingWithGoogleSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Create time stamp.
        :param pulumi.Input[builtins.str] data_sharing_with_google_setting_id: Id of the Data Sharing With Google Setting.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_data_sharing: Whether data sharing should be enabled in GA products.
        :param pulumi.Input[builtins.bool] enable_preview_data_sharing: Whether data sharing should be enabled in Preview products.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the resource.
               Format:projects/{project}/locations/{location}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSetting}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: Update time stamp.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSharingWithGoogleSettingState.__new__(_DataSharingWithGoogleSettingState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_sharing_with_google_setting_id"] = data_sharing_with_google_setting_id
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_data_sharing"] = enable_data_sharing
        __props__.__dict__["enable_preview_data_sharing"] = enable_preview_data_sharing
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        return DataSharingWithGoogleSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Create time stamp.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataSharingWithGoogleSettingId")
    def data_sharing_with_google_setting_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the Data Sharing With Google Setting.
        """
        return pulumi.get(self, "data_sharing_with_google_setting_id")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableDataSharing")
    def enable_data_sharing(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether data sharing should be enabled in GA products.
        """
        return pulumi.get(self, "enable_data_sharing")

    @property
    @pulumi.getter(name="enablePreviewDataSharing")
    def enable_preview_data_sharing(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether data sharing should be enabled in Preview products.
        """
        return pulumi.get(self, "enable_preview_data_sharing")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. Name of the resource.
        Format:projects/{project}/locations/{location}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSetting}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Update time stamp.
        """
        return pulumi.get(self, "update_time")

