# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RepositoryGroupIamPolicyArgs', 'RepositoryGroupIamPolicy']

@pulumi.input_type
class RepositoryGroupIamPolicyArgs:
    def __init__(__self__, *,
                 code_repository_index: pulumi.Input[builtins.str],
                 policy_data: pulumi.Input[builtins.str],
                 repository_group_id: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RepositoryGroupIamPolicy resource.
        :param pulumi.Input[builtins.str] code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[builtins.str] repository_group_id: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[builtins.str] location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        pulumi.set(__self__, "code_repository_index", code_repository_index)
        pulumi.set(__self__, "policy_data", policy_data)
        pulumi.set(__self__, "repository_group_id", repository_group_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="codeRepositoryIndex")
    def code_repository_index(self) -> pulumi.Input[builtins.str]:
        """
        Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "code_repository_index")

    @code_repository_index.setter
    def code_repository_index(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "code_repository_index", value)

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Input[builtins.str]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_data", value)

    @property
    @pulumi.getter(name="repositoryGroupId")
    def repository_group_id(self) -> pulumi.Input[builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "repository_group_id")

    @repository_group_id.setter
    def repository_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repository_group_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RepositoryGroupIamPolicyState:
    def __init__(__self__, *,
                 code_repository_index: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RepositoryGroupIamPolicy resources.
        :param pulumi.Input[builtins.str] code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[builtins.str] location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        :param pulumi.Input[builtins.str] repository_group_id: Used to find the parent resource to bind the IAM policy to
        """
        if code_repository_index is not None:
            pulumi.set(__self__, "code_repository_index", code_repository_index)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if policy_data is not None:
            pulumi.set(__self__, "policy_data", policy_data)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repository_group_id is not None:
            pulumi.set(__self__, "repository_group_id", repository_group_id)

    @property
    @pulumi.getter(name="codeRepositoryIndex")
    def code_repository_index(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "code_repository_index")

    @code_repository_index.setter
    def code_repository_index(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code_repository_index", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_data", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repositoryGroupId")
    def repository_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "repository_group_id")

    @repository_group_id.setter
    def repository_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_group_id", value)


@pulumi.type_token("gcp:gemini/repositoryGroupIamPolicy:RepositoryGroupIamPolicy")
class RepositoryGroupIamPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_repository_index: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Three different resources help you manage your IAM policy for Gemini for Google Cloud RepositoryGroup. Each of these resources serves a different use case:

        * `gemini.RepositoryGroupIamPolicy`: Authoritative. Sets the IAM policy for the repositorygroup and replaces any existing policy already attached.
        * `gemini.RepositoryGroupIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the repositorygroup are preserved.
        * `gemini.RepositoryGroupIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the repositorygroup are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `gemini.RepositoryGroupIamPolicy`: Retrieves the IAM policy for the repositorygroup

        > **Note:** `gemini.RepositoryGroupIamPolicy` **cannot** be used in conjunction with `gemini.RepositoryGroupIamBinding` and `gemini.RepositoryGroupIamMember` or they will fight over what your policy should be.

        > **Note:** `gemini.RepositoryGroupIamBinding` resources **can be** used in conjunction with `gemini.RepositoryGroupIamMember` resources **only if** they do not grant privilege to the same role.

        ## gemini.RepositoryGroupIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/cloudaicompanion.repositoryGroupsUser",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.gemini.RepositoryGroupIamPolicy("policy",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            policy_data=admin.policy_data)
        ```

        ## gemini.RepositoryGroupIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.gemini.RepositoryGroupIamBinding("binding",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            members=["user:jane@example.com"])
        ```

        ## gemini.RepositoryGroupIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.gemini.RepositoryGroupIamMember("member",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            member="user:jane@example.com")
        ```

        ## This resource supports User Project Overrides.

        - 

        # IAM policy for Gemini for Google Cloud RepositoryGroup
        Three different resources help you manage your IAM policy for Gemini for Google Cloud RepositoryGroup. Each of these resources serves a different use case:

        * `gemini.RepositoryGroupIamPolicy`: Authoritative. Sets the IAM policy for the repositorygroup and replaces any existing policy already attached.
        * `gemini.RepositoryGroupIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the repositorygroup are preserved.
        * `gemini.RepositoryGroupIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the repositorygroup are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `gemini.RepositoryGroupIamPolicy`: Retrieves the IAM policy for the repositorygroup

        > **Note:** `gemini.RepositoryGroupIamPolicy` **cannot** be used in conjunction with `gemini.RepositoryGroupIamBinding` and `gemini.RepositoryGroupIamMember` or they will fight over what your policy should be.

        > **Note:** `gemini.RepositoryGroupIamBinding` resources **can be** used in conjunction with `gemini.RepositoryGroupIamMember` resources **only if** they do not grant privilege to the same role.

        ## gemini.RepositoryGroupIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/cloudaicompanion.repositoryGroupsUser",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.gemini.RepositoryGroupIamPolicy("policy",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            policy_data=admin.policy_data)
        ```

        ## gemini.RepositoryGroupIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.gemini.RepositoryGroupIamBinding("binding",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            members=["user:jane@example.com"])
        ```

        ## gemini.RepositoryGroupIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.gemini.RepositoryGroupIamMember("member",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}}

        * {{project}}/{{location}}/{{code_repository_index}}/{{repository_group_id}}

        * {{location}}/{{code_repository_index}}/{{repository_group_id}}

        * {{repository_group_id}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Gemini for Google Cloud repositorygroup IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamPolicy:RepositoryGroupIamPolicy editor "projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}} roles/cloudaicompanion.repositoryGroupsUser user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamPolicy:RepositoryGroupIamPolicy editor "projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}} roles/cloudaicompanion.repositoryGroupsUser"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamPolicy:RepositoryGroupIamPolicy editor projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[builtins.str] location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        :param pulumi.Input[builtins.str] repository_group_id: Used to find the parent resource to bind the IAM policy to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryGroupIamPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Three different resources help you manage your IAM policy for Gemini for Google Cloud RepositoryGroup. Each of these resources serves a different use case:

        * `gemini.RepositoryGroupIamPolicy`: Authoritative. Sets the IAM policy for the repositorygroup and replaces any existing policy already attached.
        * `gemini.RepositoryGroupIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the repositorygroup are preserved.
        * `gemini.RepositoryGroupIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the repositorygroup are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `gemini.RepositoryGroupIamPolicy`: Retrieves the IAM policy for the repositorygroup

        > **Note:** `gemini.RepositoryGroupIamPolicy` **cannot** be used in conjunction with `gemini.RepositoryGroupIamBinding` and `gemini.RepositoryGroupIamMember` or they will fight over what your policy should be.

        > **Note:** `gemini.RepositoryGroupIamBinding` resources **can be** used in conjunction with `gemini.RepositoryGroupIamMember` resources **only if** they do not grant privilege to the same role.

        ## gemini.RepositoryGroupIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/cloudaicompanion.repositoryGroupsUser",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.gemini.RepositoryGroupIamPolicy("policy",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            policy_data=admin.policy_data)
        ```

        ## gemini.RepositoryGroupIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.gemini.RepositoryGroupIamBinding("binding",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            members=["user:jane@example.com"])
        ```

        ## gemini.RepositoryGroupIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.gemini.RepositoryGroupIamMember("member",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            member="user:jane@example.com")
        ```

        ## This resource supports User Project Overrides.

        - 

        # IAM policy for Gemini for Google Cloud RepositoryGroup
        Three different resources help you manage your IAM policy for Gemini for Google Cloud RepositoryGroup. Each of these resources serves a different use case:

        * `gemini.RepositoryGroupIamPolicy`: Authoritative. Sets the IAM policy for the repositorygroup and replaces any existing policy already attached.
        * `gemini.RepositoryGroupIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the repositorygroup are preserved.
        * `gemini.RepositoryGroupIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the repositorygroup are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `gemini.RepositoryGroupIamPolicy`: Retrieves the IAM policy for the repositorygroup

        > **Note:** `gemini.RepositoryGroupIamPolicy` **cannot** be used in conjunction with `gemini.RepositoryGroupIamBinding` and `gemini.RepositoryGroupIamMember` or they will fight over what your policy should be.

        > **Note:** `gemini.RepositoryGroupIamBinding` resources **can be** used in conjunction with `gemini.RepositoryGroupIamMember` resources **only if** they do not grant privilege to the same role.

        ## gemini.RepositoryGroupIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/cloudaicompanion.repositoryGroupsUser",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.gemini.RepositoryGroupIamPolicy("policy",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            policy_data=admin.policy_data)
        ```

        ## gemini.RepositoryGroupIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.gemini.RepositoryGroupIamBinding("binding",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            members=["user:jane@example.com"])
        ```

        ## gemini.RepositoryGroupIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.gemini.RepositoryGroupIamMember("member",
            project=example["project"],
            location=example["location"],
            code_repository_index=example["codeRepositoryIndex"],
            repository_group_id=example["repositoryGroupId"],
            role="roles/cloudaicompanion.repositoryGroupsUser",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}}

        * {{project}}/{{location}}/{{code_repository_index}}/{{repository_group_id}}

        * {{location}}/{{code_repository_index}}/{{repository_group_id}}

        * {{repository_group_id}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Gemini for Google Cloud repositorygroup IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamPolicy:RepositoryGroupIamPolicy editor "projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}} roles/cloudaicompanion.repositoryGroupsUser user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamPolicy:RepositoryGroupIamPolicy editor "projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}} roles/cloudaicompanion.repositoryGroupsUser"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:gemini/repositoryGroupIamPolicy:RepositoryGroupIamPolicy editor projects/{{project}}/locations/{{location}}/codeRepositoryIndexes/{{code_repository_index}}/repositoryGroups/{{repository_group_id}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param RepositoryGroupIamPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryGroupIamPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_repository_index: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryGroupIamPolicyArgs.__new__(RepositoryGroupIamPolicyArgs)

            if code_repository_index is None and not opts.urn:
                raise TypeError("Missing required property 'code_repository_index'")
            __props__.__dict__["code_repository_index"] = code_repository_index
            __props__.__dict__["location"] = location
            if policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'policy_data'")
            __props__.__dict__["policy_data"] = policy_data
            __props__.__dict__["project"] = project
            if repository_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_group_id'")
            __props__.__dict__["repository_group_id"] = repository_group_id
            __props__.__dict__["etag"] = None
        super(RepositoryGroupIamPolicy, __self__).__init__(
            'gcp:gemini/repositoryGroupIamPolicy:RepositoryGroupIamPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            code_repository_index: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            policy_data: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            repository_group_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RepositoryGroupIamPolicy':
        """
        Get an existing RepositoryGroupIamPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[builtins.str] location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        :param pulumi.Input[builtins.str] repository_group_id: Used to find the parent resource to bind the IAM policy to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryGroupIamPolicyState.__new__(_RepositoryGroupIamPolicyState)

        __props__.__dict__["code_repository_index"] = code_repository_index
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["policy_data"] = policy_data
        __props__.__dict__["project"] = project
        __props__.__dict__["repository_group_id"] = repository_group_id
        return RepositoryGroupIamPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="codeRepositoryIndex")
    def code_repository_index(self) -> pulumi.Output[builtins.str]:
        """
        Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "code_repository_index")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Output[builtins.str]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repositoryGroupId")
    def repository_group_id(self) -> pulumi.Output[builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "repository_group_id")

