# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupPlanArgs', 'BackupPlan']

@pulumi.input_type
class BackupPlanArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 backup_config: Optional[pulumi.Input['BackupPlanBackupConfigArgs']] = None,
                 backup_schedule: Optional[pulumi.Input['BackupPlanBackupScheduleArgs']] = None,
                 deactivated: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input['BackupPlanRetentionPolicyArgs']] = None):
        """
        The set of arguments for constructing a BackupPlan resource.
        :param pulumi.Input[builtins.str] cluster: The source cluster from which Backups will be created via this BackupPlan.
        :param pulumi.Input[builtins.str] location: The region of the Backup Plan.
        :param pulumi.Input['BackupPlanBackupConfigArgs'] backup_config: Defines the configuration of Backups created via this BackupPlan.
               Structure is documented below.
        :param pulumi.Input['BackupPlanBackupScheduleArgs'] backup_schedule: Defines a schedule for automatic Backup creation via this BackupPlan.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] deactivated: This flag indicates whether this BackupPlan has been deactivated.
               Setting this field to True locks the BackupPlan such that no further updates will be allowed
               (except deletes), including the deactivated field itself. It also prevents any new Backups
               from being created via this BackupPlan (including scheduled Backups).
        :param pulumi.Input[builtins.str] description: User specified descriptive string for this BackupPlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The full name of the BackupPlan Resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['BackupPlanRetentionPolicyArgs'] retention_policy: RetentionPolicy governs lifecycle of Backups created under this plan.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "location", location)
        if backup_config is not None:
            pulumi.set(__self__, "backup_config", backup_config)
        if backup_schedule is not None:
            pulumi.set(__self__, "backup_schedule", backup_schedule)
        if deactivated is not None:
            pulumi.set(__self__, "deactivated", deactivated)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        The source cluster from which Backups will be created via this BackupPlan.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The region of the Backup Plan.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> Optional[pulumi.Input['BackupPlanBackupConfigArgs']]:
        """
        Defines the configuration of Backups created via this BackupPlan.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_config")

    @backup_config.setter
    def backup_config(self, value: Optional[pulumi.Input['BackupPlanBackupConfigArgs']]):
        pulumi.set(self, "backup_config", value)

    @property
    @pulumi.getter(name="backupSchedule")
    def backup_schedule(self) -> Optional[pulumi.Input['BackupPlanBackupScheduleArgs']]:
        """
        Defines a schedule for automatic Backup creation via this BackupPlan.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_schedule")

    @backup_schedule.setter
    def backup_schedule(self, value: Optional[pulumi.Input['BackupPlanBackupScheduleArgs']]):
        pulumi.set(self, "backup_schedule", value)

    @property
    @pulumi.getter
    def deactivated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This flag indicates whether this BackupPlan has been deactivated.
        Setting this field to True locks the BackupPlan such that no further updates will be allowed
        (except deletes), including the deactivated field itself. It also prevents any new Backups
        from being created via this BackupPlan (including scheduled Backups).
        """
        return pulumi.get(self, "deactivated")

    @deactivated.setter
    def deactivated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deactivated", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User specified descriptive string for this BackupPlan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full name of the BackupPlan Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['BackupPlanRetentionPolicyArgs']]:
        """
        RetentionPolicy governs lifecycle of Backups created under this plan.
        Structure is documented below.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['BackupPlanRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)


@pulumi.input_type
class _BackupPlanState:
    def __init__(__self__, *,
                 backup_config: Optional[pulumi.Input['BackupPlanBackupConfigArgs']] = None,
                 backup_schedule: Optional[pulumi.Input['BackupPlanBackupScheduleArgs']] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 deactivated: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protected_pod_count: Optional[pulumi.Input[builtins.int]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 retention_policy: Optional[pulumi.Input['BackupPlanRetentionPolicyArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_reason: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupPlan resources.
        :param pulumi.Input['BackupPlanBackupConfigArgs'] backup_config: Defines the configuration of Backups created via this BackupPlan.
               Structure is documented below.
        :param pulumi.Input['BackupPlanBackupScheduleArgs'] backup_schedule: Defines a schedule for automatic Backup creation via this BackupPlan.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster: The source cluster from which Backups will be created via this BackupPlan.
        :param pulumi.Input[builtins.bool] deactivated: This flag indicates whether this BackupPlan has been deactivated.
               Setting this field to True locks the BackupPlan such that no further updates will be allowed
               (except deletes), including the deactivated field itself. It also prevents any new Backups
               from being created via this BackupPlan (including scheduled Backups).
        :param pulumi.Input[builtins.str] description: User specified descriptive string for this BackupPlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: etag is used for optimistic concurrency control as a way to help prevent simultaneous
               updates of a backup plan from overwriting each other. It is strongly suggested that
               systems make use of the 'etag' in the read-modify-write cycle to perform BackupPlan updates
               in order to avoid race conditions: An etag is returned in the response to backupPlans.get,
               and systems are expected to put that etag in the request to backupPlans.patch or
               backupPlans.delete to ensure that their change will be applied to the same version of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The region of the Backup Plan.
        :param pulumi.Input[builtins.str] name: The full name of the BackupPlan Resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.int] protected_pod_count: The number of Kubernetes Pods backed up in the last successful Backup created via this BackupPlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['BackupPlanRetentionPolicyArgs'] retention_policy: RetentionPolicy governs lifecycle of Backups created under this plan.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: The State of the BackupPlan.
        :param pulumi.Input[builtins.str] state_reason: Detailed description of why BackupPlan is in its current state.
        :param pulumi.Input[builtins.str] uid: Server generated, unique identifier of UUID format.
        """
        if backup_config is not None:
            pulumi.set(__self__, "backup_config", backup_config)
        if backup_schedule is not None:
            pulumi.set(__self__, "backup_schedule", backup_schedule)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if deactivated is not None:
            pulumi.set(__self__, "deactivated", deactivated)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protected_pod_count is not None:
            pulumi.set(__self__, "protected_pod_count", protected_pod_count)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_reason is not None:
            pulumi.set(__self__, "state_reason", state_reason)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> Optional[pulumi.Input['BackupPlanBackupConfigArgs']]:
        """
        Defines the configuration of Backups created via this BackupPlan.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_config")

    @backup_config.setter
    def backup_config(self, value: Optional[pulumi.Input['BackupPlanBackupConfigArgs']]):
        pulumi.set(self, "backup_config", value)

    @property
    @pulumi.getter(name="backupSchedule")
    def backup_schedule(self) -> Optional[pulumi.Input['BackupPlanBackupScheduleArgs']]:
        """
        Defines a schedule for automatic Backup creation via this BackupPlan.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_schedule")

    @backup_schedule.setter
    def backup_schedule(self, value: Optional[pulumi.Input['BackupPlanBackupScheduleArgs']]):
        pulumi.set(self, "backup_schedule", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source cluster from which Backups will be created via this BackupPlan.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def deactivated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This flag indicates whether this BackupPlan has been deactivated.
        Setting this field to True locks the BackupPlan such that no further updates will be allowed
        (except deletes), including the deactivated field itself. It also prevents any new Backups
        from being created via this BackupPlan (including scheduled Backups).
        """
        return pulumi.get(self, "deactivated")

    @deactivated.setter
    def deactivated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deactivated", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User specified descriptive string for this BackupPlan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        etag is used for optimistic concurrency control as a way to help prevent simultaneous
        updates of a backup plan from overwriting each other. It is strongly suggested that
        systems make use of the 'etag' in the read-modify-write cycle to perform BackupPlan updates
        in order to avoid race conditions: An etag is returned in the response to backupPlans.get,
        and systems are expected to put that etag in the request to backupPlans.patch or
        backupPlans.delete to ensure that their change will be applied to the same version of the resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the Backup Plan.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full name of the BackupPlan Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="protectedPodCount")
    def protected_pod_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Kubernetes Pods backed up in the last successful Backup created via this BackupPlan.
        """
        return pulumi.get(self, "protected_pod_count")

    @protected_pod_count.setter
    def protected_pod_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "protected_pod_count", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['BackupPlanRetentionPolicyArgs']]:
        """
        RetentionPolicy governs lifecycle of Backups created under this plan.
        Structure is documented below.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['BackupPlanRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The State of the BackupPlan.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Detailed description of why BackupPlan is in its current state.
        """
        return pulumi.get(self, "state_reason")

    @state_reason.setter
    def state_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_reason", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server generated, unique identifier of UUID format.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("gcp:gkebackup/backupPlan:BackupPlan")
class BackupPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_config: Optional[pulumi.Input[Union['BackupPlanBackupConfigArgs', 'BackupPlanBackupConfigArgsDict']]] = None,
                 backup_schedule: Optional[pulumi.Input[Union['BackupPlanBackupScheduleArgs', 'BackupPlanBackupScheduleArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 deactivated: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[Union['BackupPlanRetentionPolicyArgs', 'BackupPlanRetentionPolicyArgsDict']]] = None,
                 __props__=None):
        """
        Represents a Backup Plan instance.

        To get more information about BackupPlan, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/projects.locations.backupPlans)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke)

        ## Example Usage

        ### Gkebackup Backupplan Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="basic-plan",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        ```
        ### Gkebackup Backupplan Autopilot

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="autopilot-cluster",
            location="us-central1",
            enable_autopilot=True,
            ip_allocation_policy={},
            release_channel={
                "channel": "RAPID",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        autopilot = gcp.gkebackup.BackupPlan("autopilot",
            name="autopilot-plan",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        ```
        ### Gkebackup Backupplan Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="cmek-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        key_ring = gcp.kms.KeyRing("key_ring",
            name="backup-key",
            location="us-central1")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="backup-key",
            key_ring=key_ring.id)
        cmek = gcp.gkebackup.BackupPlan("cmek",
            name="cmek-plan",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "selected_namespaces": {
                    "namespaces": [
                        "default",
                        "test",
                    ],
                },
                "encryption_key": {
                    "gcp_kms_encryption_key": crypto_key.id,
                },
            })
        ```
        ### Gkebackup Backupplan Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="full-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        full = gcp.gkebackup.BackupPlan("full",
            name="full-plan",
            cluster=primary.id,
            location="us-central1",
            retention_policy={
                "backup_delete_lock_days": 30,
                "backup_retain_days": 180,
            },
            backup_schedule={
                "cron_schedule": "0 9 * * 1",
            },
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "selected_applications": {
                    "namespaced_names": [
                        {
                            "name": "app1",
                            "namespace": "ns1",
                        },
                        {
                            "name": "app2",
                            "namespace": "ns2",
                        },
                    ],
                },
            })
        ```
        ### Gkebackup Backupplan Permissive

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="permissive-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        permissive = gcp.gkebackup.BackupPlan("permissive",
            name="permissive-plan",
            cluster=primary.id,
            location="us-central1",
            retention_policy={
                "backup_delete_lock_days": 30,
                "backup_retain_days": 180,
            },
            backup_schedule={
                "cron_schedule": "0 9 * * 1",
            },
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "permissive_mode": True,
                "selected_applications": {
                    "namespaced_names": [
                        {
                            "name": "app1",
                            "namespace": "ns1",
                        },
                        {
                            "name": "app2",
                            "namespace": "ns2",
                        },
                    ],
                },
            })
        ```
        ### Gkebackup Backupplan Rpo Daily Window

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rpo-daily-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        rpo_daily_window = gcp.gkebackup.BackupPlan("rpo_daily_window",
            name="rpo-daily-window",
            cluster=primary.id,
            location="us-central1",
            retention_policy={
                "backup_delete_lock_days": 30,
                "backup_retain_days": 180,
            },
            backup_schedule={
                "paused": True,
                "rpo_config": {
                    "target_rpo_minutes": 1440,
                    "exclusion_windows": [
                        {
                            "start_time": {
                                "hours": 12,
                            },
                            "duration": "7200s",
                            "daily": True,
                        },
                        {
                            "start_time": {
                                "hours": 8,
                                "minutes": 40,
                                "seconds": 1,
                                "nanos": 100,
                            },
                            "duration": "3600s",
                            "single_occurrence_date": {
                                "year": 2024,
                                "month": 3,
                                "day": 16,
                            },
                        },
                    ],
                },
            },
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        ```
        ### Gkebackup Backupplan Rpo Weekly Window

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rpo-weekly-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        rpo_weekly_window = gcp.gkebackup.BackupPlan("rpo_weekly_window",
            name="rpo-weekly-window",
            cluster=primary.id,
            location="us-central1",
            retention_policy={
                "backup_delete_lock_days": 30,
                "backup_retain_days": 180,
            },
            backup_schedule={
                "paused": True,
                "rpo_config": {
                    "target_rpo_minutes": 1440,
                    "exclusion_windows": [
                        {
                            "start_time": {
                                "hours": 1,
                                "minutes": 23,
                            },
                            "duration": "1800s",
                            "days_of_week": {
                                "days_of_weeks": [
                                    "MONDAY",
                                    "THURSDAY",
                                ],
                            },
                        },
                        {
                            "start_time": {
                                "hours": 12,
                            },
                            "duration": "3600s",
                            "single_occurrence_date": {
                                "year": 2024,
                                "month": 3,
                                "day": 17,
                            },
                        },
                        {
                            "start_time": {
                                "hours": 8,
                                "minutes": 40,
                            },
                            "duration": "600s",
                            "single_occurrence_date": {
                                "year": 2024,
                                "month": 3,
                                "day": 18,
                            },
                        },
                    ],
                },
            },
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        ```

        ## Import

        BackupPlan can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupPlans/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, BackupPlan can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkebackup/backupPlan:BackupPlan default projects/{{project}}/locations/{{location}}/backupPlans/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/backupPlan:BackupPlan default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/backupPlan:BackupPlan default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BackupPlanBackupConfigArgs', 'BackupPlanBackupConfigArgsDict']] backup_config: Defines the configuration of Backups created via this BackupPlan.
               Structure is documented below.
        :param pulumi.Input[Union['BackupPlanBackupScheduleArgs', 'BackupPlanBackupScheduleArgsDict']] backup_schedule: Defines a schedule for automatic Backup creation via this BackupPlan.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster: The source cluster from which Backups will be created via this BackupPlan.
        :param pulumi.Input[builtins.bool] deactivated: This flag indicates whether this BackupPlan has been deactivated.
               Setting this field to True locks the BackupPlan such that no further updates will be allowed
               (except deletes), including the deactivated field itself. It also prevents any new Backups
               from being created via this BackupPlan (including scheduled Backups).
        :param pulumi.Input[builtins.str] description: User specified descriptive string for this BackupPlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The region of the Backup Plan.
        :param pulumi.Input[builtins.str] name: The full name of the BackupPlan Resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['BackupPlanRetentionPolicyArgs', 'BackupPlanRetentionPolicyArgsDict']] retention_policy: RetentionPolicy governs lifecycle of Backups created under this plan.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Backup Plan instance.

        To get more information about BackupPlan, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/projects.locations.backupPlans)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke)

        ## Example Usage

        ### Gkebackup Backupplan Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        basic = gcp.gkebackup.BackupPlan("basic",
            name="basic-plan",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        ```
        ### Gkebackup Backupplan Autopilot

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="autopilot-cluster",
            location="us-central1",
            enable_autopilot=True,
            ip_allocation_policy={},
            release_channel={
                "channel": "RAPID",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        autopilot = gcp.gkebackup.BackupPlan("autopilot",
            name="autopilot-plan",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        ```
        ### Gkebackup Backupplan Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="cmek-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        key_ring = gcp.kms.KeyRing("key_ring",
            name="backup-key",
            location="us-central1")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="backup-key",
            key_ring=key_ring.id)
        cmek = gcp.gkebackup.BackupPlan("cmek",
            name="cmek-plan",
            cluster=primary.id,
            location="us-central1",
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "selected_namespaces": {
                    "namespaces": [
                        "default",
                        "test",
                    ],
                },
                "encryption_key": {
                    "gcp_kms_encryption_key": crypto_key.id,
                },
            })
        ```
        ### Gkebackup Backupplan Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="full-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        full = gcp.gkebackup.BackupPlan("full",
            name="full-plan",
            cluster=primary.id,
            location="us-central1",
            retention_policy={
                "backup_delete_lock_days": 30,
                "backup_retain_days": 180,
            },
            backup_schedule={
                "cron_schedule": "0 9 * * 1",
            },
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "selected_applications": {
                    "namespaced_names": [
                        {
                            "name": "app1",
                            "namespace": "ns1",
                        },
                        {
                            "name": "app2",
                            "namespace": "ns2",
                        },
                    ],
                },
            })
        ```
        ### Gkebackup Backupplan Permissive

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="permissive-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        permissive = gcp.gkebackup.BackupPlan("permissive",
            name="permissive-plan",
            cluster=primary.id,
            location="us-central1",
            retention_policy={
                "backup_delete_lock_days": 30,
                "backup_retain_days": 180,
            },
            backup_schedule={
                "cron_schedule": "0 9 * * 1",
            },
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "permissive_mode": True,
                "selected_applications": {
                    "namespaced_names": [
                        {
                            "name": "app1",
                            "namespace": "ns1",
                        },
                        {
                            "name": "app2",
                            "namespace": "ns2",
                        },
                    ],
                },
            })
        ```
        ### Gkebackup Backupplan Rpo Daily Window

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rpo-daily-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        rpo_daily_window = gcp.gkebackup.BackupPlan("rpo_daily_window",
            name="rpo-daily-window",
            cluster=primary.id,
            location="us-central1",
            retention_policy={
                "backup_delete_lock_days": 30,
                "backup_retain_days": 180,
            },
            backup_schedule={
                "paused": True,
                "rpo_config": {
                    "target_rpo_minutes": 1440,
                    "exclusion_windows": [
                        {
                            "start_time": {
                                "hours": 12,
                            },
                            "duration": "7200s",
                            "daily": True,
                        },
                        {
                            "start_time": {
                                "hours": 8,
                                "minutes": 40,
                                "seconds": 1,
                                "nanos": 100,
                            },
                            "duration": "3600s",
                            "single_occurrence_date": {
                                "year": 2024,
                                "month": 3,
                                "day": 16,
                            },
                        },
                    ],
                },
            },
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        ```
        ### Gkebackup Backupplan Rpo Weekly Window

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="rpo-weekly-cluster",
            location="us-central1",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            addons_config={
                "gke_backup_agent_config": {
                    "enabled": True,
                },
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        rpo_weekly_window = gcp.gkebackup.BackupPlan("rpo_weekly_window",
            name="rpo-weekly-window",
            cluster=primary.id,
            location="us-central1",
            retention_policy={
                "backup_delete_lock_days": 30,
                "backup_retain_days": 180,
            },
            backup_schedule={
                "paused": True,
                "rpo_config": {
                    "target_rpo_minutes": 1440,
                    "exclusion_windows": [
                        {
                            "start_time": {
                                "hours": 1,
                                "minutes": 23,
                            },
                            "duration": "1800s",
                            "days_of_week": {
                                "days_of_weeks": [
                                    "MONDAY",
                                    "THURSDAY",
                                ],
                            },
                        },
                        {
                            "start_time": {
                                "hours": 12,
                            },
                            "duration": "3600s",
                            "single_occurrence_date": {
                                "year": 2024,
                                "month": 3,
                                "day": 17,
                            },
                        },
                        {
                            "start_time": {
                                "hours": 8,
                                "minutes": 40,
                            },
                            "duration": "600s",
                            "single_occurrence_date": {
                                "year": 2024,
                                "month": 3,
                                "day": 18,
                            },
                        },
                    ],
                },
            },
            backup_config={
                "include_volume_data": True,
                "include_secrets": True,
                "all_namespaces": True,
            })
        ```

        ## Import

        BackupPlan can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupPlans/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, BackupPlan can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkebackup/backupPlan:BackupPlan default projects/{{project}}/locations/{{location}}/backupPlans/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/backupPlan:BackupPlan default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/backupPlan:BackupPlan default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BackupPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_config: Optional[pulumi.Input[Union['BackupPlanBackupConfigArgs', 'BackupPlanBackupConfigArgsDict']]] = None,
                 backup_schedule: Optional[pulumi.Input[Union['BackupPlanBackupScheduleArgs', 'BackupPlanBackupScheduleArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 deactivated: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[Union['BackupPlanRetentionPolicyArgs', 'BackupPlanRetentionPolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPlanArgs.__new__(BackupPlanArgs)

            __props__.__dict__["backup_config"] = backup_config
            __props__.__dict__["backup_schedule"] = backup_schedule
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["deactivated"] = deactivated
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["retention_policy"] = retention_policy
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["protected_pod_count"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_reason"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BackupPlan, __self__).__init__(
            'gcp:gkebackup/backupPlan:BackupPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_config: Optional[pulumi.Input[Union['BackupPlanBackupConfigArgs', 'BackupPlanBackupConfigArgsDict']]] = None,
            backup_schedule: Optional[pulumi.Input[Union['BackupPlanBackupScheduleArgs', 'BackupPlanBackupScheduleArgsDict']]] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            deactivated: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            protected_pod_count: Optional[pulumi.Input[builtins.int]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            retention_policy: Optional[pulumi.Input[Union['BackupPlanRetentionPolicyArgs', 'BackupPlanRetentionPolicyArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_reason: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None) -> 'BackupPlan':
        """
        Get an existing BackupPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BackupPlanBackupConfigArgs', 'BackupPlanBackupConfigArgsDict']] backup_config: Defines the configuration of Backups created via this BackupPlan.
               Structure is documented below.
        :param pulumi.Input[Union['BackupPlanBackupScheduleArgs', 'BackupPlanBackupScheduleArgsDict']] backup_schedule: Defines a schedule for automatic Backup creation via this BackupPlan.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster: The source cluster from which Backups will be created via this BackupPlan.
        :param pulumi.Input[builtins.bool] deactivated: This flag indicates whether this BackupPlan has been deactivated.
               Setting this field to True locks the BackupPlan such that no further updates will be allowed
               (except deletes), including the deactivated field itself. It also prevents any new Backups
               from being created via this BackupPlan (including scheduled Backups).
        :param pulumi.Input[builtins.str] description: User specified descriptive string for this BackupPlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: etag is used for optimistic concurrency control as a way to help prevent simultaneous
               updates of a backup plan from overwriting each other. It is strongly suggested that
               systems make use of the 'etag' in the read-modify-write cycle to perform BackupPlan updates
               in order to avoid race conditions: An etag is returned in the response to backupPlans.get,
               and systems are expected to put that etag in the request to backupPlans.patch or
               backupPlans.delete to ensure that their change will be applied to the same version of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The region of the Backup Plan.
        :param pulumi.Input[builtins.str] name: The full name of the BackupPlan Resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.int] protected_pod_count: The number of Kubernetes Pods backed up in the last successful Backup created via this BackupPlan.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['BackupPlanRetentionPolicyArgs', 'BackupPlanRetentionPolicyArgsDict']] retention_policy: RetentionPolicy governs lifecycle of Backups created under this plan.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: The State of the BackupPlan.
        :param pulumi.Input[builtins.str] state_reason: Detailed description of why BackupPlan is in its current state.
        :param pulumi.Input[builtins.str] uid: Server generated, unique identifier of UUID format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPlanState.__new__(_BackupPlanState)

        __props__.__dict__["backup_config"] = backup_config
        __props__.__dict__["backup_schedule"] = backup_schedule
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["deactivated"] = deactivated
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["protected_pod_count"] = protected_pod_count
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["retention_policy"] = retention_policy
        __props__.__dict__["state"] = state
        __props__.__dict__["state_reason"] = state_reason
        __props__.__dict__["uid"] = uid
        return BackupPlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> pulumi.Output[Optional['outputs.BackupPlanBackupConfig']]:
        """
        Defines the configuration of Backups created via this BackupPlan.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_config")

    @property
    @pulumi.getter(name="backupSchedule")
    def backup_schedule(self) -> pulumi.Output[Optional['outputs.BackupPlanBackupSchedule']]:
        """
        Defines a schedule for automatic Backup creation via this BackupPlan.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_schedule")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        The source cluster from which Backups will be created via this BackupPlan.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def deactivated(self) -> pulumi.Output[builtins.bool]:
        """
        This flag indicates whether this BackupPlan has been deactivated.
        Setting this field to True locks the BackupPlan such that no further updates will be allowed
        (except deletes), including the deactivated field itself. It also prevents any new Backups
        from being created via this BackupPlan (including scheduled Backups).
        """
        return pulumi.get(self, "deactivated")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User specified descriptive string for this BackupPlan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        etag is used for optimistic concurrency control as a way to help prevent simultaneous
        updates of a backup plan from overwriting each other. It is strongly suggested that
        systems make use of the 'etag' in the read-modify-write cycle to perform BackupPlan updates
        in order to avoid race conditions: An etag is returned in the response to backupPlans.get,
        and systems are expected to put that etag in the request to backupPlans.patch or
        backupPlans.delete to ensure that their change will be applied to the same version of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The region of the Backup Plan.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The full name of the BackupPlan Resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="protectedPodCount")
    def protected_pod_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of Kubernetes Pods backed up in the last successful Backup created via this BackupPlan.
        """
        return pulumi.get(self, "protected_pod_count")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Output[Optional['outputs.BackupPlanRetentionPolicy']]:
        """
        RetentionPolicy governs lifecycle of Backups created under this plan.
        Structure is documented below.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The State of the BackupPlan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> pulumi.Output[builtins.str]:
        """
        Detailed description of why BackupPlan is in its current state.
        """
        return pulumi.get(self, "state_reason")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Server generated, unique identifier of UUID format.
        """
        return pulumi.get(self, "uid")

