# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MembershipArgs', 'Membership']

@pulumi.input_type
class MembershipArgs:
    def __init__(__self__, *,
                 membership_id: pulumi.Input[builtins.str],
                 authority: Optional[pulumi.Input['MembershipAuthorityArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input['MembershipEndpointArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Membership resource.
        :param pulumi.Input[builtins.str] membership_id: The client-provided identifier of the membership.
        :param pulumi.Input['MembershipAuthorityArgs'] authority: Authority encodes how Google will recognize identities from this Membership.
               See the workload identity documentation for more details:
               https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The name of this entity type to be displayed on the console. This field is unavailable in v1 of the API.
               
               > **Warning:** `description` is deprecated and will be removed in a future major release.
        :param pulumi.Input['MembershipEndpointArgs'] endpoint: If this Membership is a Kubernetes API server hosted on GKE, this is a self link to its GCP resource.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this membership.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the membership.
               The default value is `global`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "membership_id", membership_id)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if description is not None:
            warnings.warn("""`description` is deprecated and will be removed in a future major release.""", DeprecationWarning)
            pulumi.log.warn("""description is deprecated: `description` is deprecated and will be removed in a future major release.""")
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> pulumi.Input[builtins.str]:
        """
        The client-provided identifier of the membership.
        """
        return pulumi.get(self, "membership_id")

    @membership_id.setter
    def membership_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "membership_id", value)

    @property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input['MembershipAuthorityArgs']]:
        """
        Authority encodes how Google will recognize identities from this Membership.
        See the workload identity documentation for more details:
        https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
        Structure is documented below.
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input['MembershipAuthorityArgs']]):
        pulumi.set(self, "authority", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`description` is deprecated and will be removed in a future major release.""")
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this entity type to be displayed on the console. This field is unavailable in v1 of the API.

        > **Warning:** `description` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['MembershipEndpointArgs']]:
        """
        If this Membership is a Kubernetes API server hosted on GKE, this is a self link to its GCP resource.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['MembershipEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to apply to this membership.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the membership.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _MembershipState:
    def __init__(__self__, *,
                 authority: Optional[pulumi.Input['MembershipAuthorityArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input['MembershipEndpointArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 membership_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Membership resources.
        :param pulumi.Input['MembershipAuthorityArgs'] authority: Authority encodes how Google will recognize identities from this Membership.
               See the workload identity documentation for more details:
               https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The name of this entity type to be displayed on the console. This field is unavailable in v1 of the API.
               
               > **Warning:** `description` is deprecated and will be removed in a future major release.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['MembershipEndpointArgs'] endpoint: If this Membership is a Kubernetes API server hosted on GKE, this is a self link to its GCP resource.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this membership.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the membership.
               The default value is `global`.
        :param pulumi.Input[builtins.str] membership_id: The client-provided identifier of the membership.
        :param pulumi.Input[builtins.str] name: The unique identifier of the membership.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if description is not None:
            warnings.warn("""`description` is deprecated and will be removed in a future major release.""", DeprecationWarning)
            pulumi.log.warn("""description is deprecated: `description` is deprecated and will be removed in a future major release.""")
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if membership_id is not None:
            pulumi.set(__self__, "membership_id", membership_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)

    @property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input['MembershipAuthorityArgs']]:
        """
        Authority encodes how Google will recognize identities from this Membership.
        See the workload identity documentation for more details:
        https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
        Structure is documented below.
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input['MembershipAuthorityArgs']]):
        pulumi.set(self, "authority", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`description` is deprecated and will be removed in a future major release.""")
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this entity type to be displayed on the console. This field is unavailable in v1 of the API.

        > **Warning:** `description` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['MembershipEndpointArgs']]:
        """
        If this Membership is a Kubernetes API server hosted on GKE, this is a self link to its GCP resource.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['MembershipEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to apply to this membership.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the membership.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The client-provided identifier of the membership.
        """
        return pulumi.get(self, "membership_id")

    @membership_id.setter
    def membership_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "membership_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the membership.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)


@pulumi.type_token("gcp:gkehub/membership:Membership")
class Membership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authority: Optional[pulumi.Input[Union['MembershipAuthorityArgs', 'MembershipAuthorityArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[Union['MembershipEndpointArgs', 'MembershipEndpointArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 membership_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Membership contains information about a member cluster.

        To get more information about Membership, see:

        * [API documentation](https://cloud.google.com/anthos/multicluster-management/reference/rest/v1/projects.locations.memberships)
        * How-to Guides
            * [Registering a Cluster](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage

        ### Gkehub Membership Regional

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1-a",
            initial_node_count=1,
            deletion_protection=False,
            network="default",
            subnetwork="default")
        membership = gcp.gkehub.Membership("membership",
            membership_id="basic",
            location="us-west1",
            endpoint={
                "gke_cluster": {
                    "resource_link": primary.id.apply(lambda id: f"//container.googleapis.com/{id}"),
                },
            })
        ```
        ### Gkehub Membership Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1-a",
            initial_node_count=1,
            deletion_protection=True,
            network="default",
            subnetwork="default")
        membership = gcp.gkehub.Membership("membership",
            membership_id="basic",
            endpoint={
                "gke_cluster": {
                    "resource_link": primary.id.apply(lambda id: f"//container.googleapis.com/{id}"),
                },
            },
            labels={
                "env": "test",
            })
        ```
        ### Gkehub Membership Issuer

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1-a",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        membership = gcp.gkehub.Membership("membership",
            membership_id="basic",
            endpoint={
                "gke_cluster": {
                    "resource_link": primary.id,
                },
            },
            authority={
                "issuer": primary.id.apply(lambda id: f"https://container.googleapis.com/v1/{id}"),
            })
        ```

        ## Import

        Membership can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/memberships/{{membership_id}}`

        * `{{project}}/{{location}}/{{membership_id}}`

        * `{{location}}/{{membership_id}}`

        When using the `pulumi import` command, Membership can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkehub/membership:Membership default projects/{{project}}/locations/{{location}}/memberships/{{membership_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/membership:Membership default {{project}}/{{location}}/{{membership_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/membership:Membership default {{location}}/{{membership_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MembershipAuthorityArgs', 'MembershipAuthorityArgsDict']] authority: Authority encodes how Google will recognize identities from this Membership.
               See the workload identity documentation for more details:
               https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The name of this entity type to be displayed on the console. This field is unavailable in v1 of the API.
               
               > **Warning:** `description` is deprecated and will be removed in a future major release.
        :param pulumi.Input[Union['MembershipEndpointArgs', 'MembershipEndpointArgsDict']] endpoint: If this Membership is a Kubernetes API server hosted on GKE, this is a self link to its GCP resource.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this membership.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the membership.
               The default value is `global`.
        :param pulumi.Input[builtins.str] membership_id: The client-provided identifier of the membership.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Membership contains information about a member cluster.

        To get more information about Membership, see:

        * [API documentation](https://cloud.google.com/anthos/multicluster-management/reference/rest/v1/projects.locations.memberships)
        * How-to Guides
            * [Registering a Cluster](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage

        ### Gkehub Membership Regional

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1-a",
            initial_node_count=1,
            deletion_protection=False,
            network="default",
            subnetwork="default")
        membership = gcp.gkehub.Membership("membership",
            membership_id="basic",
            location="us-west1",
            endpoint={
                "gke_cluster": {
                    "resource_link": primary.id.apply(lambda id: f"//container.googleapis.com/{id}"),
                },
            })
        ```
        ### Gkehub Membership Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1-a",
            initial_node_count=1,
            deletion_protection=True,
            network="default",
            subnetwork="default")
        membership = gcp.gkehub.Membership("membership",
            membership_id="basic",
            endpoint={
                "gke_cluster": {
                    "resource_link": primary.id.apply(lambda id: f"//container.googleapis.com/{id}"),
                },
            },
            labels={
                "env": "test",
            })
        ```
        ### Gkehub Membership Issuer

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1-a",
            initial_node_count=1,
            workload_identity_config={
                "workload_pool": "my-project-name.svc.id.goog",
            },
            deletion_protection=True,
            network="default",
            subnetwork="default")
        membership = gcp.gkehub.Membership("membership",
            membership_id="basic",
            endpoint={
                "gke_cluster": {
                    "resource_link": primary.id,
                },
            },
            authority={
                "issuer": primary.id.apply(lambda id: f"https://container.googleapis.com/v1/{id}"),
            })
        ```

        ## Import

        Membership can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/memberships/{{membership_id}}`

        * `{{project}}/{{location}}/{{membership_id}}`

        * `{{location}}/{{membership_id}}`

        When using the `pulumi import` command, Membership can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkehub/membership:Membership default projects/{{project}}/locations/{{location}}/memberships/{{membership_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/membership:Membership default {{project}}/{{location}}/{{membership_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/membership:Membership default {{location}}/{{membership_id}}
        ```

        :param str resource_name: The name of the resource.
        :param MembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authority: Optional[pulumi.Input[Union['MembershipAuthorityArgs', 'MembershipAuthorityArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[Union['MembershipEndpointArgs', 'MembershipEndpointArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 membership_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MembershipArgs.__new__(MembershipArgs)

            __props__.__dict__["authority"] = authority
            __props__.__dict__["description"] = description
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            if membership_id is None and not opts.urn:
                raise TypeError("Missing required property 'membership_id'")
            __props__.__dict__["membership_id"] = membership_id
            __props__.__dict__["project"] = project
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Membership, __self__).__init__(
            'gcp:gkehub/membership:Membership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authority: Optional[pulumi.Input[Union['MembershipAuthorityArgs', 'MembershipAuthorityArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            endpoint: Optional[pulumi.Input[Union['MembershipEndpointArgs', 'MembershipEndpointArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            membership_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Membership':
        """
        Get an existing Membership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MembershipAuthorityArgs', 'MembershipAuthorityArgsDict']] authority: Authority encodes how Google will recognize identities from this Membership.
               See the workload identity documentation for more details:
               https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The name of this entity type to be displayed on the console. This field is unavailable in v1 of the API.
               
               > **Warning:** `description` is deprecated and will be removed in a future major release.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['MembershipEndpointArgs', 'MembershipEndpointArgsDict']] endpoint: If this Membership is a Kubernetes API server hosted on GKE, this is a self link to its GCP resource.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this membership.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the membership.
               The default value is `global`.
        :param pulumi.Input[builtins.str] membership_id: The client-provided identifier of the membership.
        :param pulumi.Input[builtins.str] name: The unique identifier of the membership.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MembershipState.__new__(_MembershipState)

        __props__.__dict__["authority"] = authority
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["membership_id"] = membership_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        return Membership(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authority(self) -> pulumi.Output[Optional['outputs.MembershipAuthority']]:
        """
        Authority encodes how Google will recognize identities from this Membership.
        See the workload identity documentation for more details:
        https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
        Structure is documented below.
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter
    @_utilities.deprecated("""`description` is deprecated and will be removed in a future major release.""")
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of this entity type to be displayed on the console. This field is unavailable in v1 of the API.

        > **Warning:** `description` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional['outputs.MembershipEndpoint']]:
        """
        If this Membership is a Kubernetes API server hosted on GKE, this is a self link to its GCP resource.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels to apply to this membership.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Location of the membership.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> pulumi.Output[builtins.str]:
        """
        The client-provided identifier of the membership.
        """
        return pulumi.get(self, "membership_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the membership.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

