# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScopeRbacRoleBindingArgs', 'ScopeRbacRoleBinding']

@pulumi.input_type
class ScopeRbacRoleBindingArgs:
    def __init__(__self__, *,
                 role: pulumi.Input['ScopeRbacRoleBindingRoleArgs'],
                 scope_id: pulumi.Input[builtins.str],
                 scope_rbac_role_binding_id: pulumi.Input[builtins.str],
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ScopeRbacRoleBinding resource.
        :param pulumi.Input['ScopeRbacRoleBindingRoleArgs'] role: Role to bind to the principal.
               Structure is documented below.
        :param pulumi.Input[builtins.str] scope_id: Id of the scope
        :param pulumi.Input[builtins.str] scope_rbac_role_binding_id: The client-provided identifier of the RBAC Role Binding.
        :param pulumi.Input[builtins.str] group: Principal that is be authorized in the cluster (at least of one the oneof
               is required). Updating one will unset the other automatically.
               group is the group, as seen by the kubernetes cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this ScopeRBACRoleBinding.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] user: Principal that is be authorized in the cluster (at least of one the oneof
               is required). Updating one will unset the other automatically.
               user is the name of the user as seen by the kubernetes cluster, example
               "alice" or "alice@domain.tld"
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "scope_id", scope_id)
        pulumi.set(__self__, "scope_rbac_role_binding_id", scope_rbac_role_binding_id)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input['ScopeRbacRoleBindingRoleArgs']:
        """
        Role to bind to the principal.
        Structure is documented below.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input['ScopeRbacRoleBindingRoleArgs']):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="scopeId")
    def scope_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the scope
        """
        return pulumi.get(self, "scope_id")

    @scope_id.setter
    def scope_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scope_id", value)

    @property
    @pulumi.getter(name="scopeRbacRoleBindingId")
    def scope_rbac_role_binding_id(self) -> pulumi.Input[builtins.str]:
        """
        The client-provided identifier of the RBAC Role Binding.
        """
        return pulumi.get(self, "scope_rbac_role_binding_id")

    @scope_rbac_role_binding_id.setter
    def scope_rbac_role_binding_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scope_rbac_role_binding_id", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Principal that is be authorized in the cluster (at least of one the oneof
        is required). Updating one will unset the other automatically.
        group is the group, as seen by the kubernetes cluster.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels for this ScopeRBACRoleBinding.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Principal that is be authorized in the cluster (at least of one the oneof
        is required). Updating one will unset the other automatically.
        user is the name of the user as seen by the kubernetes cluster, example
        "alice" or "alice@domain.tld"
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _ScopeRbacRoleBindingState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 role: Optional[pulumi.Input['ScopeRbacRoleBindingRoleArgs']] = None,
                 scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope_rbac_role_binding_id: Optional[pulumi.Input[builtins.str]] = None,
                 states: Optional[pulumi.Input[Sequence[pulumi.Input['ScopeRbacRoleBindingStateArgs']]]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScopeRbacRoleBinding resources.
        :param pulumi.Input[builtins.str] create_time: Time the RBAC Role Binding was created in UTC.
        :param pulumi.Input[builtins.str] delete_time: Time the RBAC Role Binding was deleted in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] group: Principal that is be authorized in the cluster (at least of one the oneof
               is required). Updating one will unset the other automatically.
               group is the group, as seen by the kubernetes cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this ScopeRBACRoleBinding.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name for the RBAC Role Binding
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['ScopeRbacRoleBindingRoleArgs'] role: Role to bind to the principal.
               Structure is documented below.
        :param pulumi.Input[builtins.str] scope_id: Id of the scope
        :param pulumi.Input[builtins.str] scope_rbac_role_binding_id: The client-provided identifier of the RBAC Role Binding.
        :param pulumi.Input[Sequence[pulumi.Input['ScopeRbacRoleBindingStateArgs']]] states: State of the RBAC Role Binding resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: Google-generated UUID for this resource.
        :param pulumi.Input[builtins.str] update_time: Time the RBAC Role Binding was updated in UTC.
        :param pulumi.Input[builtins.str] user: Principal that is be authorized in the cluster (at least of one the oneof
               is required). Updating one will unset the other automatically.
               user is the name of the user as seen by the kubernetes cluster, example
               "alice" or "alice@domain.tld"
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if scope_id is not None:
            pulumi.set(__self__, "scope_id", scope_id)
        if scope_rbac_role_binding_id is not None:
            pulumi.set(__self__, "scope_rbac_role_binding_id", scope_rbac_role_binding_id)
        if states is not None:
            pulumi.set(__self__, "states", states)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the RBAC Role Binding was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the RBAC Role Binding was deleted in UTC.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Principal that is be authorized in the cluster (at least of one the oneof
        is required). Updating one will unset the other automatically.
        group is the group, as seen by the kubernetes cluster.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels for this ScopeRBACRoleBinding.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for the RBAC Role Binding
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input['ScopeRbacRoleBindingRoleArgs']]:
        """
        Role to bind to the principal.
        Structure is documented below.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input['ScopeRbacRoleBindingRoleArgs']]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="scopeId")
    def scope_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the scope
        """
        return pulumi.get(self, "scope_id")

    @scope_id.setter
    def scope_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope_id", value)

    @property
    @pulumi.getter(name="scopeRbacRoleBindingId")
    def scope_rbac_role_binding_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The client-provided identifier of the RBAC Role Binding.
        """
        return pulumi.get(self, "scope_rbac_role_binding_id")

    @scope_rbac_role_binding_id.setter
    def scope_rbac_role_binding_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope_rbac_role_binding_id", value)

    @property
    @pulumi.getter
    def states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScopeRbacRoleBindingStateArgs']]]]:
        """
        State of the RBAC Role Binding resource.
        Structure is documented below.
        """
        return pulumi.get(self, "states")

    @states.setter
    def states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScopeRbacRoleBindingStateArgs']]]]):
        pulumi.set(self, "states", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Google-generated UUID for this resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the RBAC Role Binding was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Principal that is be authorized in the cluster (at least of one the oneof
        is required). Updating one will unset the other automatically.
        user is the name of the user as seen by the kubernetes cluster, example
        "alice" or "alice@domain.tld"
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("gcp:gkehub/scopeRbacRoleBinding:ScopeRbacRoleBinding")
class ScopeRbacRoleBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[Union['ScopeRbacRoleBindingRoleArgs', 'ScopeRbacRoleBindingRoleArgsDict']]] = None,
                 scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope_rbac_role_binding_id: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        RBACRoleBinding represents a rbacrolebinding across the Fleet.

        To get more information about ScopeRBACRoleBinding, see:

        * [API documentation](https://cloud.google.com/anthos/fleet-management/docs/reference/rest/v1/projects.locations.scopes.rbacrolebindings)
        * How-to Guides
            * [Registering a Cluster](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage

        ### Gkehub Scope Rbac Role Binding Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        scope = gcp.gkehub.Scope("scope", scope_id="tf-test-scope_76044")
        scope_rbac_role_binding = gcp.gkehub.ScopeRbacRoleBinding("scope_rbac_role_binding",
            scope_rbac_role_binding_id="tf-test-scope-rbac-role-binding_69391",
            scope_id=scope.scope_id,
            user="test-email@gmail.com",
            role={
                "predefined_role": "ADMIN",
            },
            labels={
                "key": "value",
            })
        ```
        ### Gkehub Scope Rbac Custom Role Binding Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        scope = gcp.gkehub.Scope("scope", scope_id="tf-test-scope_8270")
        rbacrolebindingactuation = gcp.gkehub.Feature("rbacrolebindingactuation",
            name="rbacrolebindingactuation",
            location="global",
            spec={
                "rbacrolebindingactuation": {
                    "allowed_custom_roles": ["my-custom-role"],
                },
            })
        scope_rbac_role_binding = gcp.gkehub.ScopeRbacRoleBinding("scope_rbac_role_binding",
            scope_rbac_role_binding_id="tf-test-scope-rbac-role-binding_41150",
            scope_id=scope.scope_id,
            user="test-email@gmail.com",
            role={
                "custom_role": "my-custom-role",
            },
            labels={
                "key": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[rbacrolebindingactuation]))
        ```

        ## Import

        ScopeRBACRoleBinding can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/scopes/{{scope_id}}/rbacrolebindings/{{scope_rbac_role_binding_id}}`

        * `{{project}}/{{scope_id}}/{{scope_rbac_role_binding_id}}`

        * `{{scope_id}}/{{scope_rbac_role_binding_id}}`

        When using the `pulumi import` command, ScopeRBACRoleBinding can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkehub/scopeRbacRoleBinding:ScopeRbacRoleBinding default projects/{{project}}/locations/global/scopes/{{scope_id}}/rbacrolebindings/{{scope_rbac_role_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/scopeRbacRoleBinding:ScopeRbacRoleBinding default {{project}}/{{scope_id}}/{{scope_rbac_role_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/scopeRbacRoleBinding:ScopeRbacRoleBinding default {{scope_id}}/{{scope_rbac_role_binding_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] group: Principal that is be authorized in the cluster (at least of one the oneof
               is required). Updating one will unset the other automatically.
               group is the group, as seen by the kubernetes cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this ScopeRBACRoleBinding.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ScopeRbacRoleBindingRoleArgs', 'ScopeRbacRoleBindingRoleArgsDict']] role: Role to bind to the principal.
               Structure is documented below.
        :param pulumi.Input[builtins.str] scope_id: Id of the scope
        :param pulumi.Input[builtins.str] scope_rbac_role_binding_id: The client-provided identifier of the RBAC Role Binding.
        :param pulumi.Input[builtins.str] user: Principal that is be authorized in the cluster (at least of one the oneof
               is required). Updating one will unset the other automatically.
               user is the name of the user as seen by the kubernetes cluster, example
               "alice" or "alice@domain.tld"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScopeRbacRoleBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        RBACRoleBinding represents a rbacrolebinding across the Fleet.

        To get more information about ScopeRBACRoleBinding, see:

        * [API documentation](https://cloud.google.com/anthos/fleet-management/docs/reference/rest/v1/projects.locations.scopes.rbacrolebindings)
        * How-to Guides
            * [Registering a Cluster](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage

        ### Gkehub Scope Rbac Role Binding Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        scope = gcp.gkehub.Scope("scope", scope_id="tf-test-scope_76044")
        scope_rbac_role_binding = gcp.gkehub.ScopeRbacRoleBinding("scope_rbac_role_binding",
            scope_rbac_role_binding_id="tf-test-scope-rbac-role-binding_69391",
            scope_id=scope.scope_id,
            user="test-email@gmail.com",
            role={
                "predefined_role": "ADMIN",
            },
            labels={
                "key": "value",
            })
        ```
        ### Gkehub Scope Rbac Custom Role Binding Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        scope = gcp.gkehub.Scope("scope", scope_id="tf-test-scope_8270")
        rbacrolebindingactuation = gcp.gkehub.Feature("rbacrolebindingactuation",
            name="rbacrolebindingactuation",
            location="global",
            spec={
                "rbacrolebindingactuation": {
                    "allowed_custom_roles": ["my-custom-role"],
                },
            })
        scope_rbac_role_binding = gcp.gkehub.ScopeRbacRoleBinding("scope_rbac_role_binding",
            scope_rbac_role_binding_id="tf-test-scope-rbac-role-binding_41150",
            scope_id=scope.scope_id,
            user="test-email@gmail.com",
            role={
                "custom_role": "my-custom-role",
            },
            labels={
                "key": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[rbacrolebindingactuation]))
        ```

        ## Import

        ScopeRBACRoleBinding can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/scopes/{{scope_id}}/rbacrolebindings/{{scope_rbac_role_binding_id}}`

        * `{{project}}/{{scope_id}}/{{scope_rbac_role_binding_id}}`

        * `{{scope_id}}/{{scope_rbac_role_binding_id}}`

        When using the `pulumi import` command, ScopeRBACRoleBinding can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkehub/scopeRbacRoleBinding:ScopeRbacRoleBinding default projects/{{project}}/locations/global/scopes/{{scope_id}}/rbacrolebindings/{{scope_rbac_role_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/scopeRbacRoleBinding:ScopeRbacRoleBinding default {{project}}/{{scope_id}}/{{scope_rbac_role_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/scopeRbacRoleBinding:ScopeRbacRoleBinding default {{scope_id}}/{{scope_rbac_role_binding_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ScopeRbacRoleBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScopeRbacRoleBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[Union['ScopeRbacRoleBindingRoleArgs', 'ScopeRbacRoleBindingRoleArgsDict']]] = None,
                 scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope_rbac_role_binding_id: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScopeRbacRoleBindingArgs.__new__(ScopeRbacRoleBindingArgs)

            __props__.__dict__["group"] = group
            __props__.__dict__["labels"] = labels
            __props__.__dict__["project"] = project
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if scope_id is None and not opts.urn:
                raise TypeError("Missing required property 'scope_id'")
            __props__.__dict__["scope_id"] = scope_id
            if scope_rbac_role_binding_id is None and not opts.urn:
                raise TypeError("Missing required property 'scope_rbac_role_binding_id'")
            __props__.__dict__["scope_rbac_role_binding_id"] = scope_rbac_role_binding_id
            __props__.__dict__["user"] = user
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["states"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ScopeRbacRoleBinding, __self__).__init__(
            'gcp:gkehub/scopeRbacRoleBinding:ScopeRbacRoleBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            delete_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            group: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            role: Optional[pulumi.Input[Union['ScopeRbacRoleBindingRoleArgs', 'ScopeRbacRoleBindingRoleArgsDict']]] = None,
            scope_id: Optional[pulumi.Input[builtins.str]] = None,
            scope_rbac_role_binding_id: Optional[pulumi.Input[builtins.str]] = None,
            states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScopeRbacRoleBindingStateArgs', 'ScopeRbacRoleBindingStateArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            user: Optional[pulumi.Input[builtins.str]] = None) -> 'ScopeRbacRoleBinding':
        """
        Get an existing ScopeRbacRoleBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Time the RBAC Role Binding was created in UTC.
        :param pulumi.Input[builtins.str] delete_time: Time the RBAC Role Binding was deleted in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] group: Principal that is be authorized in the cluster (at least of one the oneof
               is required). Updating one will unset the other automatically.
               group is the group, as seen by the kubernetes cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this ScopeRBACRoleBinding.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name for the RBAC Role Binding
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['ScopeRbacRoleBindingRoleArgs', 'ScopeRbacRoleBindingRoleArgsDict']] role: Role to bind to the principal.
               Structure is documented below.
        :param pulumi.Input[builtins.str] scope_id: Id of the scope
        :param pulumi.Input[builtins.str] scope_rbac_role_binding_id: The client-provided identifier of the RBAC Role Binding.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScopeRbacRoleBindingStateArgs', 'ScopeRbacRoleBindingStateArgsDict']]]] states: State of the RBAC Role Binding resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: Google-generated UUID for this resource.
        :param pulumi.Input[builtins.str] update_time: Time the RBAC Role Binding was updated in UTC.
        :param pulumi.Input[builtins.str] user: Principal that is be authorized in the cluster (at least of one the oneof
               is required). Updating one will unset the other automatically.
               user is the name of the user as seen by the kubernetes cluster, example
               "alice" or "alice@domain.tld"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScopeRbacRoleBindingState.__new__(_ScopeRbacRoleBindingState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["group"] = group
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["role"] = role
        __props__.__dict__["scope_id"] = scope_id
        __props__.__dict__["scope_rbac_role_binding_id"] = scope_rbac_role_binding_id
        __props__.__dict__["states"] = states
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["user"] = user
        return ScopeRbacRoleBinding(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the RBAC Role Binding was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the RBAC Role Binding was deleted in UTC.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Principal that is be authorized in the cluster (at least of one the oneof
        is required). Updating one will unset the other automatically.
        group is the group, as seen by the kubernetes cluster.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels for this ScopeRBACRoleBinding.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name for the RBAC Role Binding
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output['outputs.ScopeRbacRoleBindingRole']:
        """
        Role to bind to the principal.
        Structure is documented below.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="scopeId")
    def scope_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the scope
        """
        return pulumi.get(self, "scope_id")

    @property
    @pulumi.getter(name="scopeRbacRoleBindingId")
    def scope_rbac_role_binding_id(self) -> pulumi.Output[builtins.str]:
        """
        The client-provided identifier of the RBAC Role Binding.
        """
        return pulumi.get(self, "scope_rbac_role_binding_id")

    @property
    @pulumi.getter
    def states(self) -> pulumi.Output[Sequence['outputs.ScopeRbacRoleBindingState']]:
        """
        State of the RBAC Role Binding resource.
        Structure is documented below.
        """
        return pulumi.get(self, "states")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Google-generated UUID for this resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the RBAC Role Binding was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Principal that is be authorized in the cluster (at least of one the oneof
        is required). Updating one will unset the other automatically.
        user is the name of the user as seen by the kubernetes cluster, example
        "alice" or "alice@domain.tld"
        """
        return pulumi.get(self, "user")

