# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BareMetalClusterArgs', 'BareMetalCluster']

@pulumi.input_type
class BareMetalClusterArgs:
    def __init__(__self__, *,
                 admin_cluster_membership: pulumi.Input[builtins.str],
                 bare_metal_version: pulumi.Input[builtins.str],
                 control_plane: pulumi.Input['BareMetalClusterControlPlaneArgs'],
                 load_balancer: pulumi.Input['BareMetalClusterLoadBalancerArgs'],
                 location: pulumi.Input[builtins.str],
                 network_config: pulumi.Input['BareMetalClusterNetworkConfigArgs'],
                 storage: pulumi.Input['BareMetalClusterStorageArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['BareMetalClusterBinaryAuthorizationArgs']] = None,
                 cluster_operations: Optional[pulumi.Input['BareMetalClusterClusterOperationsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_config: Optional[pulumi.Input['BareMetalClusterMaintenanceConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_access_config: Optional[pulumi.Input['BareMetalClusterNodeAccessConfigArgs']] = None,
                 node_config: Optional[pulumi.Input['BareMetalClusterNodeConfigArgs']] = None,
                 os_environment_config: Optional[pulumi.Input['BareMetalClusterOsEnvironmentConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy: Optional[pulumi.Input['BareMetalClusterProxyArgs']] = None,
                 security_config: Optional[pulumi.Input['BareMetalClusterSecurityConfigArgs']] = None,
                 upgrade_policy: Optional[pulumi.Input['BareMetalClusterUpgradePolicyArgs']] = None):
        """
        The set of arguments for constructing a BareMetalCluster resource.
        :param pulumi.Input[builtins.str] admin_cluster_membership: The Admin Cluster this Bare Metal User Cluster belongs to.
               This is the full resource name of the Admin Cluster's hub membership.
        :param pulumi.Input[builtins.str] bare_metal_version: A human readable description of this Bare Metal User Cluster.
        :param pulumi.Input['BareMetalClusterControlPlaneArgs'] control_plane: Specifies the control plane configuration.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterLoadBalancerArgs'] load_balancer: Specifies the load balancer configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input['BareMetalClusterNetworkConfigArgs'] network_config: Network configuration.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterStorageArgs'] storage: Specifies the cluster storage configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations on the Bare Metal User Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['BareMetalClusterBinaryAuthorizationArgs'] binary_authorization: Binary Authorization related configurations.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterClusterOperationsArgs'] cluster_operations: Specifies the User Cluster's observability infrastructure.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A human readable description of this Bare Metal User Cluster.
        :param pulumi.Input['BareMetalClusterMaintenanceConfigArgs'] maintenance_config: Specifies the workload node configurations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The bare metal cluster name.
        :param pulumi.Input['BareMetalClusterNodeAccessConfigArgs'] node_access_config: Specifies the node access related settings for the bare metal user cluster.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterNodeConfigArgs'] node_config: Specifies the workload node configurations.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterOsEnvironmentConfigArgs'] os_environment_config: OS environment related configurations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['BareMetalClusterProxyArgs'] proxy: Specifies the cluster proxy configuration.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterSecurityConfigArgs'] security_config: Specifies the security related settings for the Bare Metal User Cluster.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterUpgradePolicyArgs'] upgrade_policy: The cluster upgrade policy.
               Structure is documented below.
        """
        pulumi.set(__self__, "admin_cluster_membership", admin_cluster_membership)
        pulumi.set(__self__, "bare_metal_version", bare_metal_version)
        pulumi.set(__self__, "control_plane", control_plane)
        pulumi.set(__self__, "load_balancer", load_balancer)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network_config", network_config)
        pulumi.set(__self__, "storage", storage)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if cluster_operations is not None:
            pulumi.set(__self__, "cluster_operations", cluster_operations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if maintenance_config is not None:
            pulumi.set(__self__, "maintenance_config", maintenance_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_access_config is not None:
            pulumi.set(__self__, "node_access_config", node_access_config)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if os_environment_config is not None:
            pulumi.set(__self__, "os_environment_config", os_environment_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)

    @property
    @pulumi.getter(name="adminClusterMembership")
    def admin_cluster_membership(self) -> pulumi.Input[builtins.str]:
        """
        The Admin Cluster this Bare Metal User Cluster belongs to.
        This is the full resource name of the Admin Cluster's hub membership.
        """
        return pulumi.get(self, "admin_cluster_membership")

    @admin_cluster_membership.setter
    def admin_cluster_membership(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "admin_cluster_membership", value)

    @property
    @pulumi.getter(name="bareMetalVersion")
    def bare_metal_version(self) -> pulumi.Input[builtins.str]:
        """
        A human readable description of this Bare Metal User Cluster.
        """
        return pulumi.get(self, "bare_metal_version")

    @bare_metal_version.setter
    def bare_metal_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bare_metal_version", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> pulumi.Input['BareMetalClusterControlPlaneArgs']:
        """
        Specifies the control plane configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: pulumi.Input['BareMetalClusterControlPlaneArgs']):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Input['BareMetalClusterLoadBalancerArgs']:
        """
        Specifies the load balancer configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: pulumi.Input['BareMetalClusterLoadBalancerArgs']):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Input['BareMetalClusterNetworkConfigArgs']:
        """
        Network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: pulumi.Input['BareMetalClusterNetworkConfigArgs']):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Input['BareMetalClusterStorageArgs']:
        """
        Specifies the cluster storage configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: pulumi.Input['BareMetalClusterStorageArgs']):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Annotations on the Bare Metal User Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['BareMetalClusterBinaryAuthorizationArgs']]:
        """
        Binary Authorization related configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['BareMetalClusterBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter(name="clusterOperations")
    def cluster_operations(self) -> Optional[pulumi.Input['BareMetalClusterClusterOperationsArgs']]:
        """
        Specifies the User Cluster's observability infrastructure.
        Structure is documented below.
        """
        return pulumi.get(self, "cluster_operations")

    @cluster_operations.setter
    def cluster_operations(self, value: Optional[pulumi.Input['BareMetalClusterClusterOperationsArgs']]):
        pulumi.set(self, "cluster_operations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable description of this Bare Metal User Cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="maintenanceConfig")
    def maintenance_config(self) -> Optional[pulumi.Input['BareMetalClusterMaintenanceConfigArgs']]:
        """
        Specifies the workload node configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_config")

    @maintenance_config.setter
    def maintenance_config(self, value: Optional[pulumi.Input['BareMetalClusterMaintenanceConfigArgs']]):
        pulumi.set(self, "maintenance_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bare metal cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeAccessConfig")
    def node_access_config(self) -> Optional[pulumi.Input['BareMetalClusterNodeAccessConfigArgs']]:
        """
        Specifies the node access related settings for the bare metal user cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "node_access_config")

    @node_access_config.setter
    def node_access_config(self, value: Optional[pulumi.Input['BareMetalClusterNodeAccessConfigArgs']]):
        pulumi.set(self, "node_access_config", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['BareMetalClusterNodeConfigArgs']]:
        """
        Specifies the workload node configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['BareMetalClusterNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="osEnvironmentConfig")
    def os_environment_config(self) -> Optional[pulumi.Input['BareMetalClusterOsEnvironmentConfigArgs']]:
        """
        OS environment related configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "os_environment_config")

    @os_environment_config.setter
    def os_environment_config(self, value: Optional[pulumi.Input['BareMetalClusterOsEnvironmentConfigArgs']]):
        pulumi.set(self, "os_environment_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['BareMetalClusterProxyArgs']]:
        """
        Specifies the cluster proxy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['BareMetalClusterProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional[pulumi.Input['BareMetalClusterSecurityConfigArgs']]:
        """
        Specifies the security related settings for the Bare Metal User Cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "security_config")

    @security_config.setter
    def security_config(self, value: Optional[pulumi.Input['BareMetalClusterSecurityConfigArgs']]):
        pulumi.set(self, "security_config", value)

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['BareMetalClusterUpgradePolicyArgs']]:
        """
        The cluster upgrade policy.
        Structure is documented below.
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['BareMetalClusterUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)


@pulumi.input_type
class _BareMetalClusterState:
    def __init__(__self__, *,
                 admin_cluster_membership: Optional[pulumi.Input[builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bare_metal_version: Optional[pulumi.Input[builtins.str]] = None,
                 binary_authorization: Optional[pulumi.Input['BareMetalClusterBinaryAuthorizationArgs']] = None,
                 cluster_operations: Optional[pulumi.Input['BareMetalClusterClusterOperationsArgs']] = None,
                 control_plane: Optional[pulumi.Input['BareMetalClusterControlPlaneArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 fleets: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterFleetArgs']]]] = None,
                 load_balancer: Optional[pulumi.Input['BareMetalClusterLoadBalancerArgs']] = None,
                 local_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_config: Optional[pulumi.Input['BareMetalClusterMaintenanceConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['BareMetalClusterNetworkConfigArgs']] = None,
                 node_access_config: Optional[pulumi.Input['BareMetalClusterNodeAccessConfigArgs']] = None,
                 node_config: Optional[pulumi.Input['BareMetalClusterNodeConfigArgs']] = None,
                 os_environment_config: Optional[pulumi.Input['BareMetalClusterOsEnvironmentConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy: Optional[pulumi.Input['BareMetalClusterProxyArgs']] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 security_config: Optional[pulumi.Input['BareMetalClusterSecurityConfigArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterStatusArgs']]]] = None,
                 storage: Optional[pulumi.Input['BareMetalClusterStorageArgs']] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_policy: Optional[pulumi.Input['BareMetalClusterUpgradePolicyArgs']] = None,
                 validation_checks: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterValidationCheckArgs']]]] = None):
        """
        Input properties used for looking up and filtering BareMetalCluster resources.
        :param pulumi.Input[builtins.str] admin_cluster_membership: The Admin Cluster this Bare Metal User Cluster belongs to.
               This is the full resource name of the Admin Cluster's hub membership.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations on the Bare Metal User Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] bare_metal_version: A human readable description of this Bare Metal User Cluster.
        :param pulumi.Input['BareMetalClusterBinaryAuthorizationArgs'] binary_authorization: Binary Authorization related configurations.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterClusterOperationsArgs'] cluster_operations: Specifies the User Cluster's observability infrastructure.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterControlPlaneArgs'] control_plane: Specifies the control plane configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[builtins.str] delete_time: The time the cluster was deleted, in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: A human readable description of this Bare Metal User Cluster.
        :param pulumi.Input[builtins.str] endpoint: The IP address name of Bare Metal User Cluster's API server.
        :param pulumi.Input[builtins.str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[Sequence[pulumi.Input['BareMetalClusterFleetArgs']]] fleets: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               See [Anthos Fleets](https://cloud.google.com/anthos/multicluster-management/fleets) for
               more details on Anthos multi-cluster capabilities using Fleets.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterLoadBalancerArgs'] load_balancer: Specifies the load balancer configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] local_name: The object name of the Bare Metal Cluster custom resource on the
               associated admin cluster. This field is used to support conflicting
               names when enrolling existing clusters to the API. When used as a part of
               cluster enrollment, this field will differ from the ID in the resource
               name. For new clusters, this field will match the user provided cluster ID
               and be visible in the last component of the resource name. It is not
               modifiable.
               All users should use this name to access their cluster using gkectl or
               kubectl and should expect to see the local name when viewing admin
               cluster controller logs.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input['BareMetalClusterMaintenanceConfigArgs'] maintenance_config: Specifies the workload node configurations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The bare metal cluster name.
        :param pulumi.Input['BareMetalClusterNetworkConfigArgs'] network_config: Network configuration.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterNodeAccessConfigArgs'] node_access_config: Specifies the node access related settings for the bare metal user cluster.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterNodeConfigArgs'] node_config: Specifies the workload node configurations.
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterOsEnvironmentConfigArgs'] os_environment_config: OS environment related configurations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['BareMetalClusterProxyArgs'] proxy: Specifies the cluster proxy configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] reconciling: If set, there are currently changes in flight to the Bare Metal User Cluster.
        :param pulumi.Input['BareMetalClusterSecurityConfigArgs'] security_config: Specifies the security related settings for the Bare Metal User Cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input['BareMetalClusterStatusArgs']]] statuses: (Output)
               Specifies the detailed validation check status
               Structure is documented below.
        :param pulumi.Input['BareMetalClusterStorageArgs'] storage: Specifies the cluster storage configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: The unique identifier of the Bare Metal User Cluster.
        :param pulumi.Input[builtins.str] update_time: The time the cluster was last updated, in RFC3339 text format.
        :param pulumi.Input['BareMetalClusterUpgradePolicyArgs'] upgrade_policy: The cluster upgrade policy.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['BareMetalClusterValidationCheckArgs']]] validation_checks: Specifies the security related settings for the Bare Metal User Cluster.
               Structure is documented below.
        """
        if admin_cluster_membership is not None:
            pulumi.set(__self__, "admin_cluster_membership", admin_cluster_membership)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if bare_metal_version is not None:
            pulumi.set(__self__, "bare_metal_version", bare_metal_version)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if cluster_operations is not None:
            pulumi.set(__self__, "cluster_operations", cluster_operations)
        if control_plane is not None:
            pulumi.set(__self__, "control_plane", control_plane)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if fleets is not None:
            pulumi.set(__self__, "fleets", fleets)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if local_name is not None:
            pulumi.set(__self__, "local_name", local_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_config is not None:
            pulumi.set(__self__, "maintenance_config", maintenance_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if node_access_config is not None:
            pulumi.set(__self__, "node_access_config", node_access_config)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if os_environment_config is not None:
            pulumi.set(__self__, "os_environment_config", os_environment_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if validation_checks is not None:
            pulumi.set(__self__, "validation_checks", validation_checks)

    @property
    @pulumi.getter(name="adminClusterMembership")
    def admin_cluster_membership(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Admin Cluster this Bare Metal User Cluster belongs to.
        This is the full resource name of the Admin Cluster's hub membership.
        """
        return pulumi.get(self, "admin_cluster_membership")

    @admin_cluster_membership.setter
    def admin_cluster_membership(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_cluster_membership", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Annotations on the Bare Metal User Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="bareMetalVersion")
    def bare_metal_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable description of this Bare Metal User Cluster.
        """
        return pulumi.get(self, "bare_metal_version")

    @bare_metal_version.setter
    def bare_metal_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bare_metal_version", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['BareMetalClusterBinaryAuthorizationArgs']]:
        """
        Binary Authorization related configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['BareMetalClusterBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter(name="clusterOperations")
    def cluster_operations(self) -> Optional[pulumi.Input['BareMetalClusterClusterOperationsArgs']]:
        """
        Specifies the User Cluster's observability infrastructure.
        Structure is documented below.
        """
        return pulumi.get(self, "cluster_operations")

    @cluster_operations.setter
    def cluster_operations(self, value: Optional[pulumi.Input['BareMetalClusterClusterOperationsArgs']]):
        pulumi.set(self, "cluster_operations", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> Optional[pulumi.Input['BareMetalClusterControlPlaneArgs']]:
        """
        Specifies the control plane configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: Optional[pulumi.Input['BareMetalClusterControlPlaneArgs']]):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the cluster was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable description of this Bare Metal User Cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address name of Bare Metal User Cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def fleets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterFleetArgs']]]]:
        """
        Fleet related configuration.
        Fleets are a Google Cloud concept for logically organizing clusters,
        letting you use and manage multi-cluster capabilities and apply
        consistent policies across your systems.
        See [Anthos Fleets](https://cloud.google.com/anthos/multicluster-management/fleets) for
        more details on Anthos multi-cluster capabilities using Fleets.
        Structure is documented below.
        """
        return pulumi.get(self, "fleets")

    @fleets.setter
    def fleets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterFleetArgs']]]]):
        pulumi.set(self, "fleets", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['BareMetalClusterLoadBalancerArgs']]:
        """
        Specifies the load balancer configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['BareMetalClusterLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="localName")
    def local_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object name of the Bare Metal Cluster custom resource on the
        associated admin cluster. This field is used to support conflicting
        names when enrolling existing clusters to the API. When used as a part of
        cluster enrollment, this field will differ from the ID in the resource
        name. For new clusters, this field will match the user provided cluster ID
        and be visible in the last component of the resource name. It is not
        modifiable.
        All users should use this name to access their cluster using gkectl or
        kubectl and should expect to see the local name when viewing admin
        cluster controller logs.
        """
        return pulumi.get(self, "local_name")

    @local_name.setter
    def local_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceConfig")
    def maintenance_config(self) -> Optional[pulumi.Input['BareMetalClusterMaintenanceConfigArgs']]:
        """
        Specifies the workload node configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_config")

    @maintenance_config.setter
    def maintenance_config(self, value: Optional[pulumi.Input['BareMetalClusterMaintenanceConfigArgs']]):
        pulumi.set(self, "maintenance_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bare metal cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['BareMetalClusterNetworkConfigArgs']]:
        """
        Network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['BareMetalClusterNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="nodeAccessConfig")
    def node_access_config(self) -> Optional[pulumi.Input['BareMetalClusterNodeAccessConfigArgs']]:
        """
        Specifies the node access related settings for the bare metal user cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "node_access_config")

    @node_access_config.setter
    def node_access_config(self, value: Optional[pulumi.Input['BareMetalClusterNodeAccessConfigArgs']]):
        pulumi.set(self, "node_access_config", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['BareMetalClusterNodeConfigArgs']]:
        """
        Specifies the workload node configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['BareMetalClusterNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="osEnvironmentConfig")
    def os_environment_config(self) -> Optional[pulumi.Input['BareMetalClusterOsEnvironmentConfigArgs']]:
        """
        OS environment related configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "os_environment_config")

    @os_environment_config.setter
    def os_environment_config(self, value: Optional[pulumi.Input['BareMetalClusterOsEnvironmentConfigArgs']]):
        pulumi.set(self, "os_environment_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['BareMetalClusterProxyArgs']]:
        """
        Specifies the cluster proxy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['BareMetalClusterProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set, there are currently changes in flight to the Bare Metal User Cluster.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional[pulumi.Input['BareMetalClusterSecurityConfigArgs']]:
        """
        Specifies the security related settings for the Bare Metal User Cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "security_config")

    @security_config.setter
    def security_config(self, value: Optional[pulumi.Input['BareMetalClusterSecurityConfigArgs']]):
        pulumi.set(self, "security_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterStatusArgs']]]]:
        """
        (Output)
        Specifies the detailed validation check status
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['BareMetalClusterStorageArgs']]:
        """
        Specifies the cluster storage configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['BareMetalClusterStorageArgs']]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the Bare Metal User Cluster.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['BareMetalClusterUpgradePolicyArgs']]:
        """
        The cluster upgrade policy.
        Structure is documented below.
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['BareMetalClusterUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @property
    @pulumi.getter(name="validationChecks")
    def validation_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterValidationCheckArgs']]]]:
        """
        Specifies the security related settings for the Bare Metal User Cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "validation_checks")

    @validation_checks.setter
    def validation_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalClusterValidationCheckArgs']]]]):
        pulumi.set(self, "validation_checks", value)


@pulumi.type_token("gcp:gkeonprem/bareMetalCluster:BareMetalCluster")
class BareMetalCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_cluster_membership: Optional[pulumi.Input[builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bare_metal_version: Optional[pulumi.Input[builtins.str]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['BareMetalClusterBinaryAuthorizationArgs', 'BareMetalClusterBinaryAuthorizationArgsDict']]] = None,
                 cluster_operations: Optional[pulumi.Input[Union['BareMetalClusterClusterOperationsArgs', 'BareMetalClusterClusterOperationsArgsDict']]] = None,
                 control_plane: Optional[pulumi.Input[Union['BareMetalClusterControlPlaneArgs', 'BareMetalClusterControlPlaneArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancer: Optional[pulumi.Input[Union['BareMetalClusterLoadBalancerArgs', 'BareMetalClusterLoadBalancerArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_config: Optional[pulumi.Input[Union['BareMetalClusterMaintenanceConfigArgs', 'BareMetalClusterMaintenanceConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['BareMetalClusterNetworkConfigArgs', 'BareMetalClusterNetworkConfigArgsDict']]] = None,
                 node_access_config: Optional[pulumi.Input[Union['BareMetalClusterNodeAccessConfigArgs', 'BareMetalClusterNodeAccessConfigArgsDict']]] = None,
                 node_config: Optional[pulumi.Input[Union['BareMetalClusterNodeConfigArgs', 'BareMetalClusterNodeConfigArgsDict']]] = None,
                 os_environment_config: Optional[pulumi.Input[Union['BareMetalClusterOsEnvironmentConfigArgs', 'BareMetalClusterOsEnvironmentConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy: Optional[pulumi.Input[Union['BareMetalClusterProxyArgs', 'BareMetalClusterProxyArgsDict']]] = None,
                 security_config: Optional[pulumi.Input[Union['BareMetalClusterSecurityConfigArgs', 'BareMetalClusterSecurityConfigArgsDict']]] = None,
                 storage: Optional[pulumi.Input[Union['BareMetalClusterStorageArgs', 'BareMetalClusterStorageArgsDict']]] = None,
                 upgrade_policy: Optional[pulumi.Input[Union['BareMetalClusterUpgradePolicyArgs', 'BareMetalClusterUpgradePolicyArgsDict']]] = None,
                 __props__=None):
        """
        A Google Bare Metal User Cluster.

        To get more information about BareMetalCluster, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/distributed-cloud/reference/on-prem-api/rest/v1/projects.locations.bareMetalClusters)

        ## Example Usage

        ### Gkeonprem Bare Metal Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_basic = gcp.gkeonprem.BareMetalCluster("cluster-basic",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                    },
                },
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "metal_lb_config": {
                    "address_pools": [{
                        "pool": "pool1",
                        "addresses": [
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                        "avoid_buggy_ips": True,
                        "manual_assign": True,
                    }],
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            })
        ```
        ### Gkeonprem Bare Metal Cluster Manuallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_manuallb = gcp.gkeonprem.BareMetalCluster("cluster-manuallb",
            name="cluster-manuallb",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                    },
                },
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "manual_lb_config": {
                    "enabled": True,
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            },
            binary_authorization={
                "evaluation_mode": "DISABLED",
            },
            upgrade_policy={
                "policy": "SERIAL",
            })
        ```
        ### Gkeonprem Bare Metal Cluster Bgplb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_bgplb = gcp.gkeonprem.BareMetalCluster("cluster-bgplb",
            name="cluster-bgplb",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
                "advanced_networking": True,
                "multiple_network_interfaces_config": {
                    "enabled": True,
                },
                "sr_iov_config": {
                    "enabled": True,
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                        "taints": [{
                            "key": "test-key",
                            "value": "test-value",
                            "effect": "NO_EXECUTE",
                        }],
                    },
                },
                "api_server_args": [{
                    "argument": "test-argument",
                    "value": "test-value",
                }],
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "bgp_lb_config": {
                    "asn": 123456,
                    "bgp_peer_configs": [{
                        "asn": 123457,
                        "ip_address": "10.0.0.1",
                        "control_plane_nodes": ["test-node"],
                    }],
                    "address_pools": [{
                        "pool": "pool1",
                        "addresses": [
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    }],
                    "load_balancer_node_pool_config": {
                        "node_pool_config": {
                            "labels": {},
                            "operating_system": "LINUX",
                            "node_configs": [{
                                "labels": {},
                                "node_ip": "10.200.0.9",
                            }],
                            "taints": [{
                                "key": "test-key",
                                "value": "test-value",
                                "effect": "NO_EXECUTE",
                            }],
                            "kubelet_config": {
                                "registry_pull_qps": 10,
                                "registry_burst": 12,
                                "serialize_image_pulls_disabled": True,
                            },
                        },
                    },
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            },
            proxy={
                "uri": "http://test-domain/test",
                "no_proxies": ["127.0.0.1"],
            },
            cluster_operations={
                "enable_application_logs": True,
            },
            maintenance_config={
                "maintenance_address_cidr_blocks": ["192.168.0.1/20"],
            },
            node_config={
                "max_pods_per_node": 10,
                "container_runtime": "CONTAINERD",
            },
            node_access_config={
                "login_user": "test@example.com",
            },
            os_environment_config={
                "package_repo_excluded": True,
            })
        ```

        ## Import

        BareMetalCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/bareMetalClusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, BareMetalCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalCluster:BareMetalCluster default projects/{{project}}/locations/{{location}}/bareMetalClusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalCluster:BareMetalCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalCluster:BareMetalCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admin_cluster_membership: The Admin Cluster this Bare Metal User Cluster belongs to.
               This is the full resource name of the Admin Cluster's hub membership.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations on the Bare Metal User Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] bare_metal_version: A human readable description of this Bare Metal User Cluster.
        :param pulumi.Input[Union['BareMetalClusterBinaryAuthorizationArgs', 'BareMetalClusterBinaryAuthorizationArgsDict']] binary_authorization: Binary Authorization related configurations.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterClusterOperationsArgs', 'BareMetalClusterClusterOperationsArgsDict']] cluster_operations: Specifies the User Cluster's observability infrastructure.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterControlPlaneArgs', 'BareMetalClusterControlPlaneArgsDict']] control_plane: Specifies the control plane configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A human readable description of this Bare Metal User Cluster.
        :param pulumi.Input[Union['BareMetalClusterLoadBalancerArgs', 'BareMetalClusterLoadBalancerArgsDict']] load_balancer: Specifies the load balancer configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[Union['BareMetalClusterMaintenanceConfigArgs', 'BareMetalClusterMaintenanceConfigArgsDict']] maintenance_config: Specifies the workload node configurations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The bare metal cluster name.
        :param pulumi.Input[Union['BareMetalClusterNetworkConfigArgs', 'BareMetalClusterNetworkConfigArgsDict']] network_config: Network configuration.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterNodeAccessConfigArgs', 'BareMetalClusterNodeAccessConfigArgsDict']] node_access_config: Specifies the node access related settings for the bare metal user cluster.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterNodeConfigArgs', 'BareMetalClusterNodeConfigArgsDict']] node_config: Specifies the workload node configurations.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterOsEnvironmentConfigArgs', 'BareMetalClusterOsEnvironmentConfigArgsDict']] os_environment_config: OS environment related configurations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['BareMetalClusterProxyArgs', 'BareMetalClusterProxyArgsDict']] proxy: Specifies the cluster proxy configuration.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterSecurityConfigArgs', 'BareMetalClusterSecurityConfigArgsDict']] security_config: Specifies the security related settings for the Bare Metal User Cluster.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterStorageArgs', 'BareMetalClusterStorageArgsDict']] storage: Specifies the cluster storage configuration.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterUpgradePolicyArgs', 'BareMetalClusterUpgradePolicyArgsDict']] upgrade_policy: The cluster upgrade policy.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BareMetalClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Bare Metal User Cluster.

        To get more information about BareMetalCluster, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/distributed-cloud/reference/on-prem-api/rest/v1/projects.locations.bareMetalClusters)

        ## Example Usage

        ### Gkeonprem Bare Metal Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_basic = gcp.gkeonprem.BareMetalCluster("cluster-basic",
            name="my-cluster",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                    },
                },
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "metal_lb_config": {
                    "address_pools": [{
                        "pool": "pool1",
                        "addresses": [
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                        "avoid_buggy_ips": True,
                        "manual_assign": True,
                    }],
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            })
        ```
        ### Gkeonprem Bare Metal Cluster Manuallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_manuallb = gcp.gkeonprem.BareMetalCluster("cluster-manuallb",
            name="cluster-manuallb",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                    },
                },
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "manual_lb_config": {
                    "enabled": True,
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            },
            binary_authorization={
                "evaluation_mode": "DISABLED",
            },
            upgrade_policy={
                "policy": "SERIAL",
            })
        ```
        ### Gkeonprem Bare Metal Cluster Bgplb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_bgplb = gcp.gkeonprem.BareMetalCluster("cluster-bgplb",
            name="cluster-bgplb",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config={
                "island_mode_cidr": {
                    "service_address_cidr_blocks": ["172.26.0.0/16"],
                    "pod_address_cidr_blocks": ["10.240.0.0/13"],
                },
                "advanced_networking": True,
                "multiple_network_interfaces_config": {
                    "enabled": True,
                },
                "sr_iov_config": {
                    "enabled": True,
                },
            },
            control_plane={
                "control_plane_node_pool_config": {
                    "node_pool_config": {
                        "labels": {},
                        "operating_system": "LINUX",
                        "node_configs": [{
                            "labels": {},
                            "node_ip": "10.200.0.9",
                        }],
                        "taints": [{
                            "key": "test-key",
                            "value": "test-value",
                            "effect": "NO_EXECUTE",
                        }],
                    },
                },
                "api_server_args": [{
                    "argument": "test-argument",
                    "value": "test-value",
                }],
            },
            load_balancer={
                "port_config": {
                    "control_plane_load_balancer_port": 443,
                },
                "vip_config": {
                    "control_plane_vip": "10.200.0.13",
                    "ingress_vip": "10.200.0.14",
                },
                "bgp_lb_config": {
                    "asn": 123456,
                    "bgp_peer_configs": [{
                        "asn": 123457,
                        "ip_address": "10.0.0.1",
                        "control_plane_nodes": ["test-node"],
                    }],
                    "address_pools": [{
                        "pool": "pool1",
                        "addresses": [
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    }],
                    "load_balancer_node_pool_config": {
                        "node_pool_config": {
                            "labels": {},
                            "operating_system": "LINUX",
                            "node_configs": [{
                                "labels": {},
                                "node_ip": "10.200.0.9",
                            }],
                            "taints": [{
                                "key": "test-key",
                                "value": "test-value",
                                "effect": "NO_EXECUTE",
                            }],
                            "kubelet_config": {
                                "registry_pull_qps": 10,
                                "registry_burst": 12,
                                "serialize_image_pulls_disabled": True,
                            },
                        },
                    },
                },
            },
            storage={
                "lvp_share_config": {
                    "lvp_config": {
                        "path": "/mnt/localpv-share",
                        "storage_class": "local-shared",
                    },
                    "shared_path_pv_count": 5,
                },
                "lvp_node_mounts_config": {
                    "path": "/mnt/localpv-disk",
                    "storage_class": "local-disks",
                },
            },
            security_config={
                "authorization": {
                    "admin_users": [{
                        "username": "admin@hashicorptest.com",
                    }],
                },
            },
            proxy={
                "uri": "http://test-domain/test",
                "no_proxies": ["127.0.0.1"],
            },
            cluster_operations={
                "enable_application_logs": True,
            },
            maintenance_config={
                "maintenance_address_cidr_blocks": ["192.168.0.1/20"],
            },
            node_config={
                "max_pods_per_node": 10,
                "container_runtime": "CONTAINERD",
            },
            node_access_config={
                "login_user": "test@example.com",
            },
            os_environment_config={
                "package_repo_excluded": True,
            })
        ```

        ## Import

        BareMetalCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/bareMetalClusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, BareMetalCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalCluster:BareMetalCluster default projects/{{project}}/locations/{{location}}/bareMetalClusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalCluster:BareMetalCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkeonprem/bareMetalCluster:BareMetalCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BareMetalClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BareMetalClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_cluster_membership: Optional[pulumi.Input[builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bare_metal_version: Optional[pulumi.Input[builtins.str]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['BareMetalClusterBinaryAuthorizationArgs', 'BareMetalClusterBinaryAuthorizationArgsDict']]] = None,
                 cluster_operations: Optional[pulumi.Input[Union['BareMetalClusterClusterOperationsArgs', 'BareMetalClusterClusterOperationsArgsDict']]] = None,
                 control_plane: Optional[pulumi.Input[Union['BareMetalClusterControlPlaneArgs', 'BareMetalClusterControlPlaneArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 load_balancer: Optional[pulumi.Input[Union['BareMetalClusterLoadBalancerArgs', 'BareMetalClusterLoadBalancerArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_config: Optional[pulumi.Input[Union['BareMetalClusterMaintenanceConfigArgs', 'BareMetalClusterMaintenanceConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['BareMetalClusterNetworkConfigArgs', 'BareMetalClusterNetworkConfigArgsDict']]] = None,
                 node_access_config: Optional[pulumi.Input[Union['BareMetalClusterNodeAccessConfigArgs', 'BareMetalClusterNodeAccessConfigArgsDict']]] = None,
                 node_config: Optional[pulumi.Input[Union['BareMetalClusterNodeConfigArgs', 'BareMetalClusterNodeConfigArgsDict']]] = None,
                 os_environment_config: Optional[pulumi.Input[Union['BareMetalClusterOsEnvironmentConfigArgs', 'BareMetalClusterOsEnvironmentConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy: Optional[pulumi.Input[Union['BareMetalClusterProxyArgs', 'BareMetalClusterProxyArgsDict']]] = None,
                 security_config: Optional[pulumi.Input[Union['BareMetalClusterSecurityConfigArgs', 'BareMetalClusterSecurityConfigArgsDict']]] = None,
                 storage: Optional[pulumi.Input[Union['BareMetalClusterStorageArgs', 'BareMetalClusterStorageArgsDict']]] = None,
                 upgrade_policy: Optional[pulumi.Input[Union['BareMetalClusterUpgradePolicyArgs', 'BareMetalClusterUpgradePolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BareMetalClusterArgs.__new__(BareMetalClusterArgs)

            if admin_cluster_membership is None and not opts.urn:
                raise TypeError("Missing required property 'admin_cluster_membership'")
            __props__.__dict__["admin_cluster_membership"] = admin_cluster_membership
            __props__.__dict__["annotations"] = annotations
            if bare_metal_version is None and not opts.urn:
                raise TypeError("Missing required property 'bare_metal_version'")
            __props__.__dict__["bare_metal_version"] = bare_metal_version
            __props__.__dict__["binary_authorization"] = binary_authorization
            __props__.__dict__["cluster_operations"] = cluster_operations
            if control_plane is None and not opts.urn:
                raise TypeError("Missing required property 'control_plane'")
            __props__.__dict__["control_plane"] = control_plane
            __props__.__dict__["description"] = description
            if load_balancer is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer'")
            __props__.__dict__["load_balancer"] = load_balancer
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_config"] = maintenance_config
            __props__.__dict__["name"] = name
            if network_config is None and not opts.urn:
                raise TypeError("Missing required property 'network_config'")
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["node_access_config"] = node_access_config
            __props__.__dict__["node_config"] = node_config
            __props__.__dict__["os_environment_config"] = os_environment_config
            __props__.__dict__["project"] = project
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["security_config"] = security_config
            if storage is None and not opts.urn:
                raise TypeError("Missing required property 'storage'")
            __props__.__dict__["storage"] = storage
            __props__.__dict__["upgrade_policy"] = upgrade_policy
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["fleets"] = None
            __props__.__dict__["local_name"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["validation_checks"] = None
        super(BareMetalCluster, __self__).__init__(
            'gcp:gkeonprem/bareMetalCluster:BareMetalCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_cluster_membership: Optional[pulumi.Input[builtins.str]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            bare_metal_version: Optional[pulumi.Input[builtins.str]] = None,
            binary_authorization: Optional[pulumi.Input[Union['BareMetalClusterBinaryAuthorizationArgs', 'BareMetalClusterBinaryAuthorizationArgsDict']]] = None,
            cluster_operations: Optional[pulumi.Input[Union['BareMetalClusterClusterOperationsArgs', 'BareMetalClusterClusterOperationsArgsDict']]] = None,
            control_plane: Optional[pulumi.Input[Union['BareMetalClusterControlPlaneArgs', 'BareMetalClusterControlPlaneArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            delete_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            fleets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BareMetalClusterFleetArgs', 'BareMetalClusterFleetArgsDict']]]]] = None,
            load_balancer: Optional[pulumi.Input[Union['BareMetalClusterLoadBalancerArgs', 'BareMetalClusterLoadBalancerArgsDict']]] = None,
            local_name: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_config: Optional[pulumi.Input[Union['BareMetalClusterMaintenanceConfigArgs', 'BareMetalClusterMaintenanceConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_config: Optional[pulumi.Input[Union['BareMetalClusterNetworkConfigArgs', 'BareMetalClusterNetworkConfigArgsDict']]] = None,
            node_access_config: Optional[pulumi.Input[Union['BareMetalClusterNodeAccessConfigArgs', 'BareMetalClusterNodeAccessConfigArgsDict']]] = None,
            node_config: Optional[pulumi.Input[Union['BareMetalClusterNodeConfigArgs', 'BareMetalClusterNodeConfigArgsDict']]] = None,
            os_environment_config: Optional[pulumi.Input[Union['BareMetalClusterOsEnvironmentConfigArgs', 'BareMetalClusterOsEnvironmentConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            proxy: Optional[pulumi.Input[Union['BareMetalClusterProxyArgs', 'BareMetalClusterProxyArgsDict']]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            security_config: Optional[pulumi.Input[Union['BareMetalClusterSecurityConfigArgs', 'BareMetalClusterSecurityConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BareMetalClusterStatusArgs', 'BareMetalClusterStatusArgsDict']]]]] = None,
            storage: Optional[pulumi.Input[Union['BareMetalClusterStorageArgs', 'BareMetalClusterStorageArgsDict']]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            upgrade_policy: Optional[pulumi.Input[Union['BareMetalClusterUpgradePolicyArgs', 'BareMetalClusterUpgradePolicyArgsDict']]] = None,
            validation_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BareMetalClusterValidationCheckArgs', 'BareMetalClusterValidationCheckArgsDict']]]]] = None) -> 'BareMetalCluster':
        """
        Get an existing BareMetalCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admin_cluster_membership: The Admin Cluster this Bare Metal User Cluster belongs to.
               This is the full resource name of the Admin Cluster's hub membership.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations on the Bare Metal User Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] bare_metal_version: A human readable description of this Bare Metal User Cluster.
        :param pulumi.Input[Union['BareMetalClusterBinaryAuthorizationArgs', 'BareMetalClusterBinaryAuthorizationArgsDict']] binary_authorization: Binary Authorization related configurations.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterClusterOperationsArgs', 'BareMetalClusterClusterOperationsArgsDict']] cluster_operations: Specifies the User Cluster's observability infrastructure.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterControlPlaneArgs', 'BareMetalClusterControlPlaneArgsDict']] control_plane: Specifies the control plane configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[builtins.str] delete_time: The time the cluster was deleted, in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: A human readable description of this Bare Metal User Cluster.
        :param pulumi.Input[builtins.str] endpoint: The IP address name of Bare Metal User Cluster's API server.
        :param pulumi.Input[builtins.str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BareMetalClusterFleetArgs', 'BareMetalClusterFleetArgsDict']]]] fleets: Fleet related configuration.
               Fleets are a Google Cloud concept for logically organizing clusters,
               letting you use and manage multi-cluster capabilities and apply
               consistent policies across your systems.
               See [Anthos Fleets](https://cloud.google.com/anthos/multicluster-management/fleets) for
               more details on Anthos multi-cluster capabilities using Fleets.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterLoadBalancerArgs', 'BareMetalClusterLoadBalancerArgsDict']] load_balancer: Specifies the load balancer configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] local_name: The object name of the Bare Metal Cluster custom resource on the
               associated admin cluster. This field is used to support conflicting
               names when enrolling existing clusters to the API. When used as a part of
               cluster enrollment, this field will differ from the ID in the resource
               name. For new clusters, this field will match the user provided cluster ID
               and be visible in the last component of the resource name. It is not
               modifiable.
               All users should use this name to access their cluster using gkectl or
               kubectl and should expect to see the local name when viewing admin
               cluster controller logs.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[Union['BareMetalClusterMaintenanceConfigArgs', 'BareMetalClusterMaintenanceConfigArgsDict']] maintenance_config: Specifies the workload node configurations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The bare metal cluster name.
        :param pulumi.Input[Union['BareMetalClusterNetworkConfigArgs', 'BareMetalClusterNetworkConfigArgsDict']] network_config: Network configuration.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterNodeAccessConfigArgs', 'BareMetalClusterNodeAccessConfigArgsDict']] node_access_config: Specifies the node access related settings for the bare metal user cluster.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterNodeConfigArgs', 'BareMetalClusterNodeConfigArgsDict']] node_config: Specifies the workload node configurations.
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterOsEnvironmentConfigArgs', 'BareMetalClusterOsEnvironmentConfigArgsDict']] os_environment_config: OS environment related configurations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['BareMetalClusterProxyArgs', 'BareMetalClusterProxyArgsDict']] proxy: Specifies the cluster proxy configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] reconciling: If set, there are currently changes in flight to the Bare Metal User Cluster.
        :param pulumi.Input[Union['BareMetalClusterSecurityConfigArgs', 'BareMetalClusterSecurityConfigArgsDict']] security_config: Specifies the security related settings for the Bare Metal User Cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BareMetalClusterStatusArgs', 'BareMetalClusterStatusArgsDict']]]] statuses: (Output)
               Specifies the detailed validation check status
               Structure is documented below.
        :param pulumi.Input[Union['BareMetalClusterStorageArgs', 'BareMetalClusterStorageArgsDict']] storage: Specifies the cluster storage configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: The unique identifier of the Bare Metal User Cluster.
        :param pulumi.Input[builtins.str] update_time: The time the cluster was last updated, in RFC3339 text format.
        :param pulumi.Input[Union['BareMetalClusterUpgradePolicyArgs', 'BareMetalClusterUpgradePolicyArgsDict']] upgrade_policy: The cluster upgrade policy.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BareMetalClusterValidationCheckArgs', 'BareMetalClusterValidationCheckArgsDict']]]] validation_checks: Specifies the security related settings for the Bare Metal User Cluster.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BareMetalClusterState.__new__(_BareMetalClusterState)

        __props__.__dict__["admin_cluster_membership"] = admin_cluster_membership
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["bare_metal_version"] = bare_metal_version
        __props__.__dict__["binary_authorization"] = binary_authorization
        __props__.__dict__["cluster_operations"] = cluster_operations
        __props__.__dict__["control_plane"] = control_plane
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["etag"] = etag
        __props__.__dict__["fleets"] = fleets
        __props__.__dict__["load_balancer"] = load_balancer
        __props__.__dict__["local_name"] = local_name
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_config"] = maintenance_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["node_access_config"] = node_access_config
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["os_environment_config"] = os_environment_config
        __props__.__dict__["project"] = project
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["security_config"] = security_config
        __props__.__dict__["state"] = state
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["storage"] = storage
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["upgrade_policy"] = upgrade_policy
        __props__.__dict__["validation_checks"] = validation_checks
        return BareMetalCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminClusterMembership")
    def admin_cluster_membership(self) -> pulumi.Output[builtins.str]:
        """
        The Admin Cluster this Bare Metal User Cluster belongs to.
        This is the full resource name of the Admin Cluster's hub membership.
        """
        return pulumi.get(self, "admin_cluster_membership")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Annotations on the Bare Metal User Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="bareMetalVersion")
    def bare_metal_version(self) -> pulumi.Output[builtins.str]:
        """
        A human readable description of this Bare Metal User Cluster.
        """
        return pulumi.get(self, "bare_metal_version")

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> pulumi.Output[Optional['outputs.BareMetalClusterBinaryAuthorization']]:
        """
        Binary Authorization related configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @property
    @pulumi.getter(name="clusterOperations")
    def cluster_operations(self) -> pulumi.Output[Optional['outputs.BareMetalClusterClusterOperations']]:
        """
        Specifies the User Cluster's observability infrastructure.
        Structure is documented below.
        """
        return pulumi.get(self, "cluster_operations")

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> pulumi.Output['outputs.BareMetalClusterControlPlane']:
        """
        Specifies the control plane configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the cluster was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human readable description of this Bare Metal User Cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The IP address name of Bare Metal User Cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def fleets(self) -> pulumi.Output[Sequence['outputs.BareMetalClusterFleet']]:
        """
        Fleet related configuration.
        Fleets are a Google Cloud concept for logically organizing clusters,
        letting you use and manage multi-cluster capabilities and apply
        consistent policies across your systems.
        See [Anthos Fleets](https://cloud.google.com/anthos/multicluster-management/fleets) for
        more details on Anthos multi-cluster capabilities using Fleets.
        Structure is documented below.
        """
        return pulumi.get(self, "fleets")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output['outputs.BareMetalClusterLoadBalancer']:
        """
        Specifies the load balancer configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter(name="localName")
    def local_name(self) -> pulumi.Output[builtins.str]:
        """
        The object name of the Bare Metal Cluster custom resource on the
        associated admin cluster. This field is used to support conflicting
        names when enrolling existing clusters to the API. When used as a part of
        cluster enrollment, this field will differ from the ID in the resource
        name. For new clusters, this field will match the user provided cluster ID
        and be visible in the last component of the resource name. It is not
        modifiable.
        All users should use this name to access their cluster using gkectl or
        kubectl and should expect to see the local name when viewing admin
        cluster controller logs.
        """
        return pulumi.get(self, "local_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceConfig")
    def maintenance_config(self) -> pulumi.Output[Optional['outputs.BareMetalClusterMaintenanceConfig']]:
        """
        Specifies the workload node configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The bare metal cluster name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output['outputs.BareMetalClusterNetworkConfig']:
        """
        Network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="nodeAccessConfig")
    def node_access_config(self) -> pulumi.Output[Optional['outputs.BareMetalClusterNodeAccessConfig']]:
        """
        Specifies the node access related settings for the bare metal user cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "node_access_config")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Output[Optional['outputs.BareMetalClusterNodeConfig']]:
        """
        Specifies the workload node configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="osEnvironmentConfig")
    def os_environment_config(self) -> pulumi.Output[Optional['outputs.BareMetalClusterOsEnvironmentConfig']]:
        """
        OS environment related configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "os_environment_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Output[Optional['outputs.BareMetalClusterProxy']]:
        """
        Specifies the cluster proxy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        If set, there are currently changes in flight to the Bare Metal User Cluster.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> pulumi.Output[Optional['outputs.BareMetalClusterSecurityConfig']]:
        """
        Specifies the security related settings for the Bare Metal User Cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "security_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.BareMetalClusterStatus']]:
        """
        (Output)
        Specifies the detailed validation check status
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output['outputs.BareMetalClusterStorage']:
        """
        Specifies the cluster storage configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the Bare Metal User Cluster.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> pulumi.Output[Optional['outputs.BareMetalClusterUpgradePolicy']]:
        """
        The cluster upgrade policy.
        Structure is documented below.
        """
        return pulumi.get(self, "upgrade_policy")

    @property
    @pulumi.getter(name="validationChecks")
    def validation_checks(self) -> pulumi.Output[Sequence['outputs.BareMetalClusterValidationCheck']]:
        """
        Specifies the security related settings for the Bare Metal User Cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "validation_checks")

