# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OauthClientArgs', 'OauthClient']

@pulumi.input_type
class OauthClientArgs:
    def __init__(__self__, *,
                 allowed_grant_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allowed_redirect_uris: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allowed_scopes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 location: pulumi.Input[builtins.str],
                 oauth_client_id: pulumi.Input[builtins.str],
                 client_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OauthClient resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_grant_types: Required. The list of OAuth grant types is allowed for the OauthClient.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_redirect_uris: Required. The list of redirect uris that is allowed to redirect back
               when authorization process is completed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_scopes: Required. The list of scopes that the OauthClient is allowed to request during
               OAuth flows.
               The following scopes are supported:
               * `https://www.googleapis.com/auth/cloud-platform`: See, edit, configure,
               and delete your Google Cloud data and see the email address for your Google
               Account.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] oauth_client_id: Required. The ID to use for the OauthClient, which becomes the final component of
               the resource name. This value should be a string of 6 to 63 lowercase
               letters, digits, or hyphens. It must start with a letter, and cannot have a
               trailing hyphen. The prefix `gcp-` is reserved for use by Google, and may
               not be specified.
        :param pulumi.Input[builtins.str] client_type: Immutable. The type of OauthClient. Either public or private.
               For private clients, the client secret can be managed using the dedicated
               OauthClientCredential resource.
               Possible values:
               CLIENT_TYPE_UNSPECIFIED
               PUBLIC_CLIENT
               CONFIDENTIAL_CLIENT
        :param pulumi.Input[builtins.str] description: A user-specified description of the OauthClient.
               Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the OauthClient is disabled. You cannot use a disabled OAuth
               client.
        :param pulumi.Input[builtins.str] display_name: A user-specified display name of the OauthClient.
               Cannot exceed 32 characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        pulumi.set(__self__, "allowed_redirect_uris", allowed_redirect_uris)
        pulumi.set(__self__, "allowed_scopes", allowed_scopes)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        if client_type is not None:
            pulumi.set(__self__, "client_type", client_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Required. The list of OAuth grant types is allowed for the OauthClient.
        """
        return pulumi.get(self, "allowed_grant_types")

    @allowed_grant_types.setter
    def allowed_grant_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_grant_types", value)

    @property
    @pulumi.getter(name="allowedRedirectUris")
    def allowed_redirect_uris(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Required. The list of redirect uris that is allowed to redirect back
        when authorization process is completed.
        """
        return pulumi.get(self, "allowed_redirect_uris")

    @allowed_redirect_uris.setter
    def allowed_redirect_uris(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_redirect_uris", value)

    @property
    @pulumi.getter(name="allowedScopes")
    def allowed_scopes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Required. The list of scopes that the OauthClient is allowed to request during
        OAuth flows.
        The following scopes are supported:
        * `https://www.googleapis.com/auth/cloud-platform`: See, edit, configure,
        and delete your Google Cloud data and see the email address for your Google
        Account.
        """
        return pulumi.get(self, "allowed_scopes")

    @allowed_scopes.setter
    def allowed_scopes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_scopes", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. The ID to use for the OauthClient, which becomes the final component of
        the resource name. This value should be a string of 6 to 63 lowercase
        letters, digits, or hyphens. It must start with a letter, and cannot have a
        trailing hyphen. The prefix `gcp-` is reserved for use by Google, and may
        not be specified.
        """
        return pulumi.get(self, "oauth_client_id")

    @oauth_client_id.setter
    def oauth_client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "oauth_client_id", value)

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The type of OauthClient. Either public or private.
        For private clients, the client secret can be managed using the dedicated
        OauthClientCredential resource.
        Possible values:
        CLIENT_TYPE_UNSPECIFIED
        PUBLIC_CLIENT
        CONFIDENTIAL_CLIENT
        """
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-specified description of the OauthClient.
        Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the OauthClient is disabled. You cannot use a disabled OAuth
        client.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-specified display name of the OauthClient.
        Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _OauthClientState:
    def __init__(__self__, *,
                 allowed_grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OauthClient resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_grant_types: Required. The list of OAuth grant types is allowed for the OauthClient.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_redirect_uris: Required. The list of redirect uris that is allowed to redirect back
               when authorization process is completed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_scopes: Required. The list of scopes that the OauthClient is allowed to request during
               OAuth flows.
               The following scopes are supported:
               * `https://www.googleapis.com/auth/cloud-platform`: See, edit, configure,
               and delete your Google Cloud data and see the email address for your Google
               Account.
        :param pulumi.Input[builtins.str] client_id: Output only. The system-generated OauthClient id.
        :param pulumi.Input[builtins.str] client_type: Immutable. The type of OauthClient. Either public or private.
               For private clients, the client secret can be managed using the dedicated
               OauthClientCredential resource.
               Possible values:
               CLIENT_TYPE_UNSPECIFIED
               PUBLIC_CLIENT
               CONFIDENTIAL_CLIENT
        :param pulumi.Input[builtins.str] description: A user-specified description of the OauthClient.
               Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the OauthClient is disabled. You cannot use a disabled OAuth
               client.
        :param pulumi.Input[builtins.str] display_name: A user-specified display name of the OauthClient.
               Cannot exceed 32 characters.
        :param pulumi.Input[builtins.str] expire_time: Time after which the OauthClient will be permanently purged and cannot
               be recovered.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Immutable. Identifier. The resource name of the OauthClient.
               Format:`projects/{project}/locations/{location}/oauthClients/{oauth_client}`.
        :param pulumi.Input[builtins.str] oauth_client_id: Required. The ID to use for the OauthClient, which becomes the final component of
               the resource name. This value should be a string of 6 to 63 lowercase
               letters, digits, or hyphens. It must start with a letter, and cannot have a
               trailing hyphen. The prefix `gcp-` is reserved for use by Google, and may
               not be specified.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: The state of the OauthClient.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               DELETED
        """
        if allowed_grant_types is not None:
            pulumi.set(__self__, "allowed_grant_types", allowed_grant_types)
        if allowed_redirect_uris is not None:
            pulumi.set(__self__, "allowed_redirect_uris", allowed_redirect_uris)
        if allowed_scopes is not None:
            pulumi.set(__self__, "allowed_scopes", allowed_scopes)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_type is not None:
            pulumi.set(__self__, "client_type", client_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_client_id is not None:
            pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Required. The list of OAuth grant types is allowed for the OauthClient.
        """
        return pulumi.get(self, "allowed_grant_types")

    @allowed_grant_types.setter
    def allowed_grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_grant_types", value)

    @property
    @pulumi.getter(name="allowedRedirectUris")
    def allowed_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Required. The list of redirect uris that is allowed to redirect back
        when authorization process is completed.
        """
        return pulumi.get(self, "allowed_redirect_uris")

    @allowed_redirect_uris.setter
    def allowed_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_redirect_uris", value)

    @property
    @pulumi.getter(name="allowedScopes")
    def allowed_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Required. The list of scopes that the OauthClient is allowed to request during
        OAuth flows.
        The following scopes are supported:
        * `https://www.googleapis.com/auth/cloud-platform`: See, edit, configure,
        and delete your Google Cloud data and see the email address for your Google
        Account.
        """
        return pulumi.get(self, "allowed_scopes")

    @allowed_scopes.setter
    def allowed_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_scopes", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The system-generated OauthClient id.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The type of OauthClient. Either public or private.
        For private clients, the client secret can be managed using the dedicated
        OauthClientCredential resource.
        Possible values:
        CLIENT_TYPE_UNSPECIFIED
        PUBLIC_CLIENT
        CONFIDENTIAL_CLIENT
        """
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-specified description of the OauthClient.
        Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the OauthClient is disabled. You cannot use a disabled OAuth
        client.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-specified display name of the OauthClient.
        Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time after which the OauthClient will be permanently purged and cannot
        be recovered.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. Identifier. The resource name of the OauthClient.
        Format:`projects/{project}/locations/{location}/oauthClients/{oauth_client}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The ID to use for the OauthClient, which becomes the final component of
        the resource name. This value should be a string of 6 to 63 lowercase
        letters, digits, or hyphens. It must start with a letter, and cannot have a
        trailing hyphen. The prefix `gcp-` is reserved for use by Google, and may
        not be specified.
        """
        return pulumi.get(self, "oauth_client_id")

    @oauth_client_id.setter
    def oauth_client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth_client_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the OauthClient.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        DELETED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:iam/oauthClient:OauthClient")
class OauthClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents an OAuth Client. Used to access Google Cloud resources on behalf of a
        Workforce Identity Federation user by using OAuth 2.0 Protocol to obtain an access
        token from Google Cloud.

        To get more information about OauthClient, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.oauthClients)
        * How-to Guides
            * [Managing OAuth clients](https://cloud.google.com/iam/docs/workforce-manage-oauth-app#manage-clients)

        ## Example Usage

        ### Iam Oauth Client Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.iam.OauthClient("example",
            oauth_client_id="example-client-id",
            display_name="Display Name of OAuth client",
            description="A sample OAuth client",
            location="global",
            disabled=False,
            allowed_grant_types=["AUTHORIZATION_CODE_GRANT"],
            allowed_redirect_uris=["https://www.example.com"],
            allowed_scopes=["https://www.googleapis.com/auth/cloud-platform"],
            client_type="CONFIDENTIAL_CLIENT")
        ```

        ## Import

        OauthClient can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/oauthClients/{{oauth_client_id}}`

        * `{{project}}/{{location}}/{{oauth_client_id}}`

        * `{{location}}/{{oauth_client_id}}`

        When using the `pulumi import` command, OauthClient can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/oauthClient:OauthClient default projects/{{project}}/locations/{{location}}/oauthClients/{{oauth_client_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/oauthClient:OauthClient default {{project}}/{{location}}/{{oauth_client_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/oauthClient:OauthClient default {{location}}/{{oauth_client_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_grant_types: Required. The list of OAuth grant types is allowed for the OauthClient.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_redirect_uris: Required. The list of redirect uris that is allowed to redirect back
               when authorization process is completed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_scopes: Required. The list of scopes that the OauthClient is allowed to request during
               OAuth flows.
               The following scopes are supported:
               * `https://www.googleapis.com/auth/cloud-platform`: See, edit, configure,
               and delete your Google Cloud data and see the email address for your Google
               Account.
        :param pulumi.Input[builtins.str] client_type: Immutable. The type of OauthClient. Either public or private.
               For private clients, the client secret can be managed using the dedicated
               OauthClientCredential resource.
               Possible values:
               CLIENT_TYPE_UNSPECIFIED
               PUBLIC_CLIENT
               CONFIDENTIAL_CLIENT
        :param pulumi.Input[builtins.str] description: A user-specified description of the OauthClient.
               Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the OauthClient is disabled. You cannot use a disabled OAuth
               client.
        :param pulumi.Input[builtins.str] display_name: A user-specified display name of the OauthClient.
               Cannot exceed 32 characters.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] oauth_client_id: Required. The ID to use for the OauthClient, which becomes the final component of
               the resource name. This value should be a string of 6 to 63 lowercase
               letters, digits, or hyphens. It must start with a letter, and cannot have a
               trailing hyphen. The prefix `gcp-` is reserved for use by Google, and may
               not be specified.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OauthClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an OAuth Client. Used to access Google Cloud resources on behalf of a
        Workforce Identity Federation user by using OAuth 2.0 Protocol to obtain an access
        token from Google Cloud.

        To get more information about OauthClient, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.oauthClients)
        * How-to Guides
            * [Managing OAuth clients](https://cloud.google.com/iam/docs/workforce-manage-oauth-app#manage-clients)

        ## Example Usage

        ### Iam Oauth Client Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.iam.OauthClient("example",
            oauth_client_id="example-client-id",
            display_name="Display Name of OAuth client",
            description="A sample OAuth client",
            location="global",
            disabled=False,
            allowed_grant_types=["AUTHORIZATION_CODE_GRANT"],
            allowed_redirect_uris=["https://www.example.com"],
            allowed_scopes=["https://www.googleapis.com/auth/cloud-platform"],
            client_type="CONFIDENTIAL_CLIENT")
        ```

        ## Import

        OauthClient can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/oauthClients/{{oauth_client_id}}`

        * `{{project}}/{{location}}/{{oauth_client_id}}`

        * `{{location}}/{{oauth_client_id}}`

        When using the `pulumi import` command, OauthClient can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/oauthClient:OauthClient default projects/{{project}}/locations/{{location}}/oauthClients/{{oauth_client_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/oauthClient:OauthClient default {{project}}/{{location}}/{{oauth_client_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/oauthClient:OauthClient default {{location}}/{{oauth_client_id}}
        ```

        :param str resource_name: The name of the resource.
        :param OauthClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OauthClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OauthClientArgs.__new__(OauthClientArgs)

            if allowed_grant_types is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_grant_types'")
            __props__.__dict__["allowed_grant_types"] = allowed_grant_types
            if allowed_redirect_uris is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_redirect_uris'")
            __props__.__dict__["allowed_redirect_uris"] = allowed_redirect_uris
            if allowed_scopes is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_scopes'")
            __props__.__dict__["allowed_scopes"] = allowed_scopes
            __props__.__dict__["client_type"] = client_type
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if oauth_client_id is None and not opts.urn:
                raise TypeError("Missing required property 'oauth_client_id'")
            __props__.__dict__["oauth_client_id"] = oauth_client_id
            __props__.__dict__["project"] = project
            __props__.__dict__["client_id"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(OauthClient, __self__).__init__(
            'gcp:iam/oauthClient:OauthClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_type: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            expire_time: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            oauth_client_id: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'OauthClient':
        """
        Get an existing OauthClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_grant_types: Required. The list of OAuth grant types is allowed for the OauthClient.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_redirect_uris: Required. The list of redirect uris that is allowed to redirect back
               when authorization process is completed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_scopes: Required. The list of scopes that the OauthClient is allowed to request during
               OAuth flows.
               The following scopes are supported:
               * `https://www.googleapis.com/auth/cloud-platform`: See, edit, configure,
               and delete your Google Cloud data and see the email address for your Google
               Account.
        :param pulumi.Input[builtins.str] client_id: Output only. The system-generated OauthClient id.
        :param pulumi.Input[builtins.str] client_type: Immutable. The type of OauthClient. Either public or private.
               For private clients, the client secret can be managed using the dedicated
               OauthClientCredential resource.
               Possible values:
               CLIENT_TYPE_UNSPECIFIED
               PUBLIC_CLIENT
               CONFIDENTIAL_CLIENT
        :param pulumi.Input[builtins.str] description: A user-specified description of the OauthClient.
               Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the OauthClient is disabled. You cannot use a disabled OAuth
               client.
        :param pulumi.Input[builtins.str] display_name: A user-specified display name of the OauthClient.
               Cannot exceed 32 characters.
        :param pulumi.Input[builtins.str] expire_time: Time after which the OauthClient will be permanently purged and cannot
               be recovered.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Immutable. Identifier. The resource name of the OauthClient.
               Format:`projects/{project}/locations/{location}/oauthClients/{oauth_client}`.
        :param pulumi.Input[builtins.str] oauth_client_id: Required. The ID to use for the OauthClient, which becomes the final component of
               the resource name. This value should be a string of 6 to 63 lowercase
               letters, digits, or hyphens. It must start with a letter, and cannot have a
               trailing hyphen. The prefix `gcp-` is reserved for use by Google, and may
               not be specified.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: The state of the OauthClient.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               DELETED
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OauthClientState.__new__(_OauthClientState)

        __props__.__dict__["allowed_grant_types"] = allowed_grant_types
        __props__.__dict__["allowed_redirect_uris"] = allowed_redirect_uris
        __props__.__dict__["allowed_scopes"] = allowed_scopes
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_type"] = client_type
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_client_id"] = oauth_client_id
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        return OauthClient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedGrantTypes")
    def allowed_grant_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Required. The list of OAuth grant types is allowed for the OauthClient.
        """
        return pulumi.get(self, "allowed_grant_types")

    @property
    @pulumi.getter(name="allowedRedirectUris")
    def allowed_redirect_uris(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Required. The list of redirect uris that is allowed to redirect back
        when authorization process is completed.
        """
        return pulumi.get(self, "allowed_redirect_uris")

    @property
    @pulumi.getter(name="allowedScopes")
    def allowed_scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Required. The list of scopes that the OauthClient is allowed to request during
        OAuth flows.
        The following scopes are supported:
        * `https://www.googleapis.com/auth/cloud-platform`: See, edit, configure,
        and delete your Google Cloud data and see the email address for your Google
        Account.
        """
        return pulumi.get(self, "allowed_scopes")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The system-generated OauthClient id.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Immutable. The type of OauthClient. Either public or private.
        For private clients, the client secret can be managed using the dedicated
        OauthClientCredential resource.
        Possible values:
        CLIENT_TYPE_UNSPECIFIED
        PUBLIC_CLIENT
        CONFIDENTIAL_CLIENT
        """
        return pulumi.get(self, "client_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A user-specified description of the OauthClient.
        Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the OauthClient is disabled. You cannot use a disabled OAuth
        client.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A user-specified display name of the OauthClient.
        Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[builtins.str]:
        """
        Time after which the OauthClient will be permanently purged and cannot
        be recovered.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Immutable. Identifier. The resource name of the OauthClient.
        Format:`projects/{project}/locations/{location}/oauthClients/{oauth_client}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. The ID to use for the OauthClient, which becomes the final component of
        the resource name. This value should be a string of 6 to 63 lowercase
        letters, digits, or hyphens. It must start with a letter, and cannot have a
        trailing hyphen. The prefix `gcp-` is reserved for use by Google, and may
        not be specified.
        """
        return pulumi.get(self, "oauth_client_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the OauthClient.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        DELETED
        """
        return pulumi.get(self, "state")

