# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkloadIdentityPoolProviderArgs', 'WorkloadIdentityPoolProvider']

@pulumi.input_type
class WorkloadIdentityPoolProviderArgs:
    def __init__(__self__, *,
                 workload_identity_pool_id: pulumi.Input[builtins.str],
                 workload_identity_pool_provider_id: pulumi.Input[builtins.str],
                 attribute_condition: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 aws: Optional[pulumi.Input['WorkloadIdentityPoolProviderAwsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 oidc: Optional[pulumi.Input['WorkloadIdentityPoolProviderOidcArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 saml: Optional[pulumi.Input['WorkloadIdentityPoolProviderSamlArgs']] = None,
                 x509: Optional[pulumi.Input['WorkloadIdentityPoolProviderX509Args']] = None):
        """
        The set of arguments for constructing a WorkloadIdentityPoolProvider resource.
        :param pulumi.Input[builtins.str] workload_identity_pool_id: The ID used for the pool, which is the final component of the pool resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] workload_identity_pool_provider_id: The ID for the provider, which becomes the final component of the resource name. This
               value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] attribute_condition: [A Common Expression Language](https://opensource.google/projects/cel) expression, in
               plain text, to restrict what otherwise valid authentication credentials issued by the
               provider should not be accepted.
               The expression must output a boolean representing whether to allow the federation.
               The following keywords may be referenced in the expressions:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attribute_mapping: Maps attributes from authentication credentials issued by an external identity provider
               to Google Cloud attributes, such as `subject` and `segment`.
               Each key must be a string specifying the Google Cloud IAM attribute to map to.
               The following keys are supported:
               * `google.subject`: The principal IAM is authenticating. You can reference this value
               in IAM bindings. This is also the subject that appears in Cloud Logging logs.
               Cannot exceed 127 characters.
               * `google.groups`: Groups the external identity belongs to. You can grant groups
               access to resources using an IAM `principalSet` binding; access applies to all
               members of the group.
               You can also provide custom attributes by specifying `attribute.{custom_attribute}`,
               where `{custom_attribute}` is the name of the custom attribute to be mapped. You can
               define a maximum of 50 custom attributes. The maximum length of a mapped attribute key
               is 100 characters, and the key may only contain the characters [a-z0-9_].
               You can reference these attributes in IAM policies to define fine-grained access for a
               workload to Google Cloud resources. For example:
               * `google.subject`:
               `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}`
               * `google.groups`:
               `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}`
               * `attribute.{custom_attribute}`:
               `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}`
               Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
               function that maps an identity provider credential to the normalized attribute specified
               by the corresponding map key.
               You can use the `assertion` keyword in the expression to access a JSON representation of
               the authentication credential issued by the provider.
               The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
               the total size of all mapped attributes must not exceed 8KB.
               For AWS providers, the following rules apply:
               - If no attribute mapping is defined, the following default mapping applies:
               ```
               {
               "google.subject":"assertion.arn",
               "attribute.aws_role":
               "assertion.arn.contains('assumed-role')"
               " ? assertion.arn.extract('{account_arn}assumed-role/')"
               "   + 'assumed-role/'"
               "   + assertion.arn.extract('assumed-role/{role_name}/')"
               " : assertion.arn",
               }
               ```
               - If any custom attribute mappings are defined, they must include a mapping to the
               `google.subject` attribute.
               For OIDC providers, the following rules apply:
               - Custom attribute mappings must be defined, and must include a mapping to the
               `google.subject` attribute. For example, the following maps the `sub` claim of the
               incoming credential to the `subject` attribute on a Google token.
               ```
               {"google.subject": "assertion.sub"}
               ```
        :param pulumi.Input['WorkloadIdentityPoolProviderAwsArgs'] aws: An Amazon Web Services identity provider. Not compatible with the property oidc or saml.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description for the provider. Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
               However, existing tokens still grant access.
        :param pulumi.Input[builtins.str] display_name: A display name for the provider. Cannot exceed 32 characters.
        :param pulumi.Input['WorkloadIdentityPoolProviderOidcArgs'] oidc: An OpenId Connect 1.0 identity provider. Not compatible with the property aws or saml.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['WorkloadIdentityPoolProviderSamlArgs'] saml: An SAML 2.0 identity provider. Not compatible with the property oidc or aws.
               Structure is documented below.
        :param pulumi.Input['WorkloadIdentityPoolProviderX509Args'] x509: An X.509-type identity provider represents a CA. It is trusted to assert a
               client identity if the client has a certificate that chains up to this CA.
               Structure is documented below.
        """
        pulumi.set(__self__, "workload_identity_pool_id", workload_identity_pool_id)
        pulumi.set(__self__, "workload_identity_pool_provider_id", workload_identity_pool_provider_id)
        if attribute_condition is not None:
            pulumi.set(__self__, "attribute_condition", attribute_condition)
        if attribute_mapping is not None:
            pulumi.set(__self__, "attribute_mapping", attribute_mapping)
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if oidc is not None:
            pulumi.set(__self__, "oidc", oidc)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)
        if x509 is not None:
            pulumi.set(__self__, "x509", x509)

    @property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID used for the pool, which is the final component of the pool resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @workload_identity_pool_id.setter
    def workload_identity_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_identity_pool_id", value)

    @property
    @pulumi.getter(name="workloadIdentityPoolProviderId")
    def workload_identity_pool_provider_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID for the provider, which becomes the final component of the resource name. This
        value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_provider_id")

    @workload_identity_pool_provider_id.setter
    def workload_identity_pool_provider_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_identity_pool_provider_id", value)

    @property
    @pulumi.getter(name="attributeCondition")
    def attribute_condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [A Common Expression Language](https://opensource.google/projects/cel) expression, in
        plain text, to restrict what otherwise valid authentication credentials issued by the
        provider should not be accepted.
        The expression must output a boolean representing whether to allow the federation.
        The following keywords may be referenced in the expressions:
        """
        return pulumi.get(self, "attribute_condition")

    @attribute_condition.setter
    def attribute_condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attribute_condition", value)

    @property
    @pulumi.getter(name="attributeMapping")
    def attribute_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Maps attributes from authentication credentials issued by an external identity provider
        to Google Cloud attributes, such as `subject` and `segment`.
        Each key must be a string specifying the Google Cloud IAM attribute to map to.
        The following keys are supported:
        * `google.subject`: The principal IAM is authenticating. You can reference this value
        in IAM bindings. This is also the subject that appears in Cloud Logging logs.
        Cannot exceed 127 characters.
        * `google.groups`: Groups the external identity belongs to. You can grant groups
        access to resources using an IAM `principalSet` binding; access applies to all
        members of the group.
        You can also provide custom attributes by specifying `attribute.{custom_attribute}`,
        where `{custom_attribute}` is the name of the custom attribute to be mapped. You can
        define a maximum of 50 custom attributes. The maximum length of a mapped attribute key
        is 100 characters, and the key may only contain the characters [a-z0-9_].
        You can reference these attributes in IAM policies to define fine-grained access for a
        workload to Google Cloud resources. For example:
        * `google.subject`:
        `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}`
        * `google.groups`:
        `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}`
        * `attribute.{custom_attribute}`:
        `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}`
        Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
        function that maps an identity provider credential to the normalized attribute specified
        by the corresponding map key.
        You can use the `assertion` keyword in the expression to access a JSON representation of
        the authentication credential issued by the provider.
        The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
        the total size of all mapped attributes must not exceed 8KB.
        For AWS providers, the following rules apply:
        - If no attribute mapping is defined, the following default mapping applies:
        ```
        {
        "google.subject":"assertion.arn",
        "attribute.aws_role":
        "assertion.arn.contains('assumed-role')"
        " ? assertion.arn.extract('{account_arn}assumed-role/')"
        "   + 'assumed-role/'"
        "   + assertion.arn.extract('assumed-role/{role_name}/')"
        " : assertion.arn",
        }
        ```
        - If any custom attribute mappings are defined, they must include a mapping to the
        `google.subject` attribute.
        For OIDC providers, the following rules apply:
        - Custom attribute mappings must be defined, and must include a mapping to the
        `google.subject` attribute. For example, the following maps the `sub` claim of the
        incoming credential to the `subject` attribute on a Google token.
        ```
        {"google.subject": "assertion.sub"}
        ```
        """
        return pulumi.get(self, "attribute_mapping")

    @attribute_mapping.setter
    def attribute_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_mapping", value)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['WorkloadIdentityPoolProviderAwsArgs']]:
        """
        An Amazon Web Services identity provider. Not compatible with the property oidc or saml.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['WorkloadIdentityPoolProviderAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
        However, existing tokens still grant access.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A display name for the provider. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def oidc(self) -> Optional[pulumi.Input['WorkloadIdentityPoolProviderOidcArgs']]:
        """
        An OpenId Connect 1.0 identity provider. Not compatible with the property aws or saml.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc")

    @oidc.setter
    def oidc(self, value: Optional[pulumi.Input['WorkloadIdentityPoolProviderOidcArgs']]):
        pulumi.set(self, "oidc", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['WorkloadIdentityPoolProviderSamlArgs']]:
        """
        An SAML 2.0 identity provider. Not compatible with the property oidc or aws.
        Structure is documented below.
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['WorkloadIdentityPoolProviderSamlArgs']]):
        pulumi.set(self, "saml", value)

    @property
    @pulumi.getter
    def x509(self) -> Optional[pulumi.Input['WorkloadIdentityPoolProviderX509Args']]:
        """
        An X.509-type identity provider represents a CA. It is trusted to assert a
        client identity if the client has a certificate that chains up to this CA.
        Structure is documented below.
        """
        return pulumi.get(self, "x509")

    @x509.setter
    def x509(self, value: Optional[pulumi.Input['WorkloadIdentityPoolProviderX509Args']]):
        pulumi.set(self, "x509", value)


@pulumi.input_type
class _WorkloadIdentityPoolProviderState:
    def __init__(__self__, *,
                 attribute_condition: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 aws: Optional[pulumi.Input['WorkloadIdentityPoolProviderAwsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oidc: Optional[pulumi.Input['WorkloadIdentityPoolProviderOidcArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 saml: Optional[pulumi.Input['WorkloadIdentityPoolProviderSamlArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_provider_id: Optional[pulumi.Input[builtins.str]] = None,
                 x509: Optional[pulumi.Input['WorkloadIdentityPoolProviderX509Args']] = None):
        """
        Input properties used for looking up and filtering WorkloadIdentityPoolProvider resources.
        :param pulumi.Input[builtins.str] attribute_condition: [A Common Expression Language](https://opensource.google/projects/cel) expression, in
               plain text, to restrict what otherwise valid authentication credentials issued by the
               provider should not be accepted.
               The expression must output a boolean representing whether to allow the federation.
               The following keywords may be referenced in the expressions:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attribute_mapping: Maps attributes from authentication credentials issued by an external identity provider
               to Google Cloud attributes, such as `subject` and `segment`.
               Each key must be a string specifying the Google Cloud IAM attribute to map to.
               The following keys are supported:
               * `google.subject`: The principal IAM is authenticating. You can reference this value
               in IAM bindings. This is also the subject that appears in Cloud Logging logs.
               Cannot exceed 127 characters.
               * `google.groups`: Groups the external identity belongs to. You can grant groups
               access to resources using an IAM `principalSet` binding; access applies to all
               members of the group.
               You can also provide custom attributes by specifying `attribute.{custom_attribute}`,
               where `{custom_attribute}` is the name of the custom attribute to be mapped. You can
               define a maximum of 50 custom attributes. The maximum length of a mapped attribute key
               is 100 characters, and the key may only contain the characters [a-z0-9_].
               You can reference these attributes in IAM policies to define fine-grained access for a
               workload to Google Cloud resources. For example:
               * `google.subject`:
               `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}`
               * `google.groups`:
               `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}`
               * `attribute.{custom_attribute}`:
               `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}`
               Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
               function that maps an identity provider credential to the normalized attribute specified
               by the corresponding map key.
               You can use the `assertion` keyword in the expression to access a JSON representation of
               the authentication credential issued by the provider.
               The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
               the total size of all mapped attributes must not exceed 8KB.
               For AWS providers, the following rules apply:
               - If no attribute mapping is defined, the following default mapping applies:
               ```
               {
               "google.subject":"assertion.arn",
               "attribute.aws_role":
               "assertion.arn.contains('assumed-role')"
               " ? assertion.arn.extract('{account_arn}assumed-role/')"
               "   + 'assumed-role/'"
               "   + assertion.arn.extract('assumed-role/{role_name}/')"
               " : assertion.arn",
               }
               ```
               - If any custom attribute mappings are defined, they must include a mapping to the
               `google.subject` attribute.
               For OIDC providers, the following rules apply:
               - Custom attribute mappings must be defined, and must include a mapping to the
               `google.subject` attribute. For example, the following maps the `sub` claim of the
               incoming credential to the `subject` attribute on a Google token.
               ```
               {"google.subject": "assertion.sub"}
               ```
        :param pulumi.Input['WorkloadIdentityPoolProviderAwsArgs'] aws: An Amazon Web Services identity provider. Not compatible with the property oidc or saml.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description for the provider. Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
               However, existing tokens still grant access.
        :param pulumi.Input[builtins.str] display_name: A display name for the provider. Cannot exceed 32 characters.
        :param pulumi.Input[builtins.str] name: The resource name of the provider as
               `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}/providers/{workload_identity_pool_provider_id}`.
        :param pulumi.Input['WorkloadIdentityPoolProviderOidcArgs'] oidc: An OpenId Connect 1.0 identity provider. Not compatible with the property aws or saml.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['WorkloadIdentityPoolProviderSamlArgs'] saml: An SAML 2.0 identity provider. Not compatible with the property oidc or aws.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: The state of the provider.
               * STATE_UNSPECIFIED: State unspecified.
               * ACTIVE: The provider is active, and may be used to validate authentication credentials.
               * DELETED: The provider is soft-deleted. Soft-deleted providers are permanently deleted
               after approximately 30 days. You can restore a soft-deleted provider using
               UndeleteWorkloadIdentityPoolProvider. You cannot reuse the ID of a soft-deleted provider
               until it is permanently deleted.
        :param pulumi.Input[builtins.str] workload_identity_pool_id: The ID used for the pool, which is the final component of the pool resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] workload_identity_pool_provider_id: The ID for the provider, which becomes the final component of the resource name. This
               value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input['WorkloadIdentityPoolProviderX509Args'] x509: An X.509-type identity provider represents a CA. It is trusted to assert a
               client identity if the client has a certificate that chains up to this CA.
               Structure is documented below.
        """
        if attribute_condition is not None:
            pulumi.set(__self__, "attribute_condition", attribute_condition)
        if attribute_mapping is not None:
            pulumi.set(__self__, "attribute_mapping", attribute_mapping)
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc is not None:
            pulumi.set(__self__, "oidc", oidc)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if workload_identity_pool_id is not None:
            pulumi.set(__self__, "workload_identity_pool_id", workload_identity_pool_id)
        if workload_identity_pool_provider_id is not None:
            pulumi.set(__self__, "workload_identity_pool_provider_id", workload_identity_pool_provider_id)
        if x509 is not None:
            pulumi.set(__self__, "x509", x509)

    @property
    @pulumi.getter(name="attributeCondition")
    def attribute_condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [A Common Expression Language](https://opensource.google/projects/cel) expression, in
        plain text, to restrict what otherwise valid authentication credentials issued by the
        provider should not be accepted.
        The expression must output a boolean representing whether to allow the federation.
        The following keywords may be referenced in the expressions:
        """
        return pulumi.get(self, "attribute_condition")

    @attribute_condition.setter
    def attribute_condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attribute_condition", value)

    @property
    @pulumi.getter(name="attributeMapping")
    def attribute_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Maps attributes from authentication credentials issued by an external identity provider
        to Google Cloud attributes, such as `subject` and `segment`.
        Each key must be a string specifying the Google Cloud IAM attribute to map to.
        The following keys are supported:
        * `google.subject`: The principal IAM is authenticating. You can reference this value
        in IAM bindings. This is also the subject that appears in Cloud Logging logs.
        Cannot exceed 127 characters.
        * `google.groups`: Groups the external identity belongs to. You can grant groups
        access to resources using an IAM `principalSet` binding; access applies to all
        members of the group.
        You can also provide custom attributes by specifying `attribute.{custom_attribute}`,
        where `{custom_attribute}` is the name of the custom attribute to be mapped. You can
        define a maximum of 50 custom attributes. The maximum length of a mapped attribute key
        is 100 characters, and the key may only contain the characters [a-z0-9_].
        You can reference these attributes in IAM policies to define fine-grained access for a
        workload to Google Cloud resources. For example:
        * `google.subject`:
        `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}`
        * `google.groups`:
        `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}`
        * `attribute.{custom_attribute}`:
        `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}`
        Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
        function that maps an identity provider credential to the normalized attribute specified
        by the corresponding map key.
        You can use the `assertion` keyword in the expression to access a JSON representation of
        the authentication credential issued by the provider.
        The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
        the total size of all mapped attributes must not exceed 8KB.
        For AWS providers, the following rules apply:
        - If no attribute mapping is defined, the following default mapping applies:
        ```
        {
        "google.subject":"assertion.arn",
        "attribute.aws_role":
        "assertion.arn.contains('assumed-role')"
        " ? assertion.arn.extract('{account_arn}assumed-role/')"
        "   + 'assumed-role/'"
        "   + assertion.arn.extract('assumed-role/{role_name}/')"
        " : assertion.arn",
        }
        ```
        - If any custom attribute mappings are defined, they must include a mapping to the
        `google.subject` attribute.
        For OIDC providers, the following rules apply:
        - Custom attribute mappings must be defined, and must include a mapping to the
        `google.subject` attribute. For example, the following maps the `sub` claim of the
        incoming credential to the `subject` attribute on a Google token.
        ```
        {"google.subject": "assertion.sub"}
        ```
        """
        return pulumi.get(self, "attribute_mapping")

    @attribute_mapping.setter
    def attribute_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_mapping", value)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['WorkloadIdentityPoolProviderAwsArgs']]:
        """
        An Amazon Web Services identity provider. Not compatible with the property oidc or saml.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['WorkloadIdentityPoolProviderAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
        However, existing tokens still grant access.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A display name for the provider. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the provider as
        `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}/providers/{workload_identity_pool_provider_id}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def oidc(self) -> Optional[pulumi.Input['WorkloadIdentityPoolProviderOidcArgs']]:
        """
        An OpenId Connect 1.0 identity provider. Not compatible with the property aws or saml.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc")

    @oidc.setter
    def oidc(self, value: Optional[pulumi.Input['WorkloadIdentityPoolProviderOidcArgs']]):
        pulumi.set(self, "oidc", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['WorkloadIdentityPoolProviderSamlArgs']]:
        """
        An SAML 2.0 identity provider. Not compatible with the property oidc or aws.
        Structure is documented below.
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['WorkloadIdentityPoolProviderSamlArgs']]):
        pulumi.set(self, "saml", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the provider.
        * STATE_UNSPECIFIED: State unspecified.
        * ACTIVE: The provider is active, and may be used to validate authentication credentials.
        * DELETED: The provider is soft-deleted. Soft-deleted providers are permanently deleted
        after approximately 30 days. You can restore a soft-deleted provider using
        UndeleteWorkloadIdentityPoolProvider. You cannot reuse the ID of a soft-deleted provider
        until it is permanently deleted.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID used for the pool, which is the final component of the pool resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @workload_identity_pool_id.setter
    def workload_identity_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_identity_pool_id", value)

    @property
    @pulumi.getter(name="workloadIdentityPoolProviderId")
    def workload_identity_pool_provider_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID for the provider, which becomes the final component of the resource name. This
        value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_provider_id")

    @workload_identity_pool_provider_id.setter
    def workload_identity_pool_provider_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_identity_pool_provider_id", value)

    @property
    @pulumi.getter
    def x509(self) -> Optional[pulumi.Input['WorkloadIdentityPoolProviderX509Args']]:
        """
        An X.509-type identity provider represents a CA. It is trusted to assert a
        client identity if the client has a certificate that chains up to this CA.
        Structure is documented below.
        """
        return pulumi.get(self, "x509")

    @x509.setter
    def x509(self, value: Optional[pulumi.Input['WorkloadIdentityPoolProviderX509Args']]):
        pulumi.set(self, "x509", value)


@pulumi.type_token("gcp:iam/workloadIdentityPoolProvider:WorkloadIdentityPoolProvider")
class WorkloadIdentityPoolProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_condition: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 aws: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderAwsArgs', 'WorkloadIdentityPoolProviderAwsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 oidc: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderOidcArgs', 'WorkloadIdentityPoolProviderOidcArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 saml: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderSamlArgs', 'WorkloadIdentityPoolProviderSamlArgsDict']]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_provider_id: Optional[pulumi.Input[builtins.str]] = None,
                 x509: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderX509Args', 'WorkloadIdentityPoolProviderX509ArgsDict']]] = None,
                 __props__=None):
        """
        A configuration for an external identity provider.

        To get more information about WorkloadIdentityPoolProvider, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.workloadIdentityPools.providers)
        * How-to Guides
            * [Managing workload identity providers](https://cloud.google.com/iam/docs/manage-workload-identity-pools-providers#managing_workload_identity_providers)

        ## Example Usage

        ### Iam Workload Identity Pool Provider Aws Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            aws={
                "account_id": "999999999999",
            })
        ```
        ### Iam Workload Identity Pool Provider Aws Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="AWS identity pool provider for automated test",
            disabled=True,
            attribute_condition="attribute.aws_role==\\"arn:aws:sts::999999999999:assumed-role/stack-eu-central-1-lambdaRole\\"",
            attribute_mapping={
                "google.subject": "assertion.arn",
                "attribute.aws_account": "assertion.account",
                "attribute.environment": "assertion.arn.contains(\\":instance-profile/Production\\") ? \\"prod\\" : \\"test\\"",
            },
            aws={
                "account_id": "999999999999",
            })
        ```
        ### Iam Workload Identity Pool Provider Github Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="GitHub Actions identity pool provider for automated test",
            disabled=True,
            attribute_condition=\"\"\"    assertion.repository_owner_id == "123456789" &&
            attribute.repository == "gh-org/gh-repo" &&
            assertion.ref == "refs/heads/main" &&
            assertion.ref_type == "branch"
        \"\"\",
            attribute_mapping={
                "google.subject": "assertion.sub",
                "attribute.actor": "assertion.actor",
                "attribute.aud": "assertion.aud",
                "attribute.repository": "assertion.repository",
            },
            oidc={
                "issuer_uri": "https://token.actions.githubusercontent.com",
            })
        ```
        ### Iam Workload Identity Pool Provider Oidc Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://sts.windows.net/azure-tenant-id",
            })
        ```
        ### Iam Workload Identity Pool Provider Oidc Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="OIDC identity pool provider for automated test",
            disabled=True,
            attribute_condition="\\"e968c2ef-047c-498d-8d79-16ca1b61e77e\\" in assertion.groups",
            attribute_mapping={
                "google.subject": "\\"azure::\\" + assertion.tid + \\"::\\" + assertion.sub",
                "attribute.tid": "assertion.tid",
                "attribute.managed_identity_name": \"\"\"      {
                "8bb39bdb-1cc5-4447-b7db-a19e920eb111":"workload1",
                "55d36609-9bcf-48e0-a366-a3cf19027d2a":"workload2"
              }[assertion.oid]
        \"\"\",
            },
            oidc={
                "allowed_audiences": [
                    "https://example.com/gcp-oidc-federation",
                    "example.com/gcp-oidc-federation",
                ],
                "issuer_uri": "https://sts.windows.net/azure-tenant-id",
            })
        ```
        ### Iam Workload Identity Pool Provider Saml Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.arn",
                "attribute.aws_account": "assertion.account",
                "attribute.environment": "assertion.arn.contains(\\":instance-profile/Production\\") ? \\"prod\\" : \\"test\\"",
            },
            saml={
                "idp_metadata_xml": std.file(input="test-fixtures/metadata.xml").result,
            })
        ```
        ### Iam Workload Identity Pool Provider Saml Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="SAML 2.0 identity pool provider for automated test",
            disabled=True,
            attribute_mapping={
                "google.subject": "assertion.arn",
                "attribute.aws_account": "assertion.account",
                "attribute.environment": "assertion.arn.contains(\\":instance-profile/Production\\") ? \\"prod\\" : \\"test\\"",
            },
            saml={
                "idp_metadata_xml": std.file(input="test-fixtures/metadata.xml").result,
            })
        ```
        ### Iam Workload Identity Pool Provider Oidc Upload Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="OIDC identity pool provider for automated test",
            disabled=True,
            attribute_condition="\\"e968c2ef-047c-498d-8d79-16ca1b61e77e\\" in assertion.groups",
            attribute_mapping={
                "google.subject": "\\"azure::\\" + assertion.tid + \\"::\\" + assertion.sub",
                "attribute.tid": "assertion.tid",
                "attribute.managed_identity_name": \"\"\"      {
                "8bb39bdb-1cc5-4447-b7db-a19e920eb111":"workload1",
                "55d36609-9bcf-48e0-a366-a3cf19027d2a":"workload2"
              }[assertion.oid]
        \"\"\",
            },
            oidc={
                "allowed_audiences": [
                    "https://example.com/gcp-oidc-federation",
                    "example.com/gcp-oidc-federation",
                ],
                "issuer_uri": "https://sts.windows.net/azure-tenant-id",
                "jwks_json": "{\\"keys\\":[{\\"kty\\":\\"RSA\\",\\"alg\\":\\"RS256\\",\\"kid\\":\\"sif0AR-F6MuvksAyAOv-Pds08Bcf2eUMlxE30NofddA\\",\\"use\\":\\"sig\\",\\"e\\":\\"AQAB\\",\\"n\\":\\"ylH1Chl1tpfti3lh51E1g5dPogzXDaQseqjsefGLknaNl5W6Wd4frBhHyE2t41Q5zgz_Ll0-NvWm0FlaG6brhrN9QZu6sJP1bM8WPfJVPgXOanxi7d7TXCkeNubGeiLTf5R3UXtS9Lm_guemU7MxDjDTelxnlgGCihOVTcL526suNJUdfXtpwUsvdU6_ZnAp9IpsuYjCtwPm9hPumlcZGMbxstdh07O4y4O90cVQClJOKSGQjAUCKJWXIQ0cqffGS_HuS_725CPzQ85SzYZzaNpgfhAER7kx_9P16ARM3BJz0PI5fe2hECE61J4GYU_BY43sxDfs7HyJpEXKLU9eWw\\"}]}",
            })
        ```
        ### Iam Workload Identity Pool Provider X509 Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.subject.dn.cn",
            },
            x509={
                "trust_store": {
                    "trust_anchors": [{
                        "pem_certificate": std.file(input="test-fixtures/trust_anchor.pem").result,
                    }],
                },
            })
        ```
        ### Iam Workload Identity Pool Provider X509 Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="X.509 identity pool provider for automated test",
            disabled=True,
            attribute_mapping={
                "google.subject": "assertion.subject.dn.cn",
            },
            x509={
                "trust_store": {
                    "trust_anchors": [{
                        "pem_certificate": std.file(input="test-fixtures/trust_anchor.pem").result,
                    }],
                    "intermediate_cas": [{
                        "pem_certificate": std.file(input="test-fixtures/intermediate_ca.pem").result,
                    }],
                },
            })
        ```

        ## Import

        WorkloadIdentityPoolProvider can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}/providers/{{workload_identity_pool_provider_id}}`

        * `{{project}}/{{workload_identity_pool_id}}/{{workload_identity_pool_provider_id}}`

        * `{{workload_identity_pool_id}}/{{workload_identity_pool_provider_id}}`

        When using the `pulumi import` command, WorkloadIdentityPoolProvider can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolProvider:WorkloadIdentityPoolProvider default projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}/providers/{{workload_identity_pool_provider_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolProvider:WorkloadIdentityPoolProvider default {{project}}/{{workload_identity_pool_id}}/{{workload_identity_pool_provider_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolProvider:WorkloadIdentityPoolProvider default {{workload_identity_pool_id}}/{{workload_identity_pool_provider_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attribute_condition: [A Common Expression Language](https://opensource.google/projects/cel) expression, in
               plain text, to restrict what otherwise valid authentication credentials issued by the
               provider should not be accepted.
               The expression must output a boolean representing whether to allow the federation.
               The following keywords may be referenced in the expressions:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attribute_mapping: Maps attributes from authentication credentials issued by an external identity provider
               to Google Cloud attributes, such as `subject` and `segment`.
               Each key must be a string specifying the Google Cloud IAM attribute to map to.
               The following keys are supported:
               * `google.subject`: The principal IAM is authenticating. You can reference this value
               in IAM bindings. This is also the subject that appears in Cloud Logging logs.
               Cannot exceed 127 characters.
               * `google.groups`: Groups the external identity belongs to. You can grant groups
               access to resources using an IAM `principalSet` binding; access applies to all
               members of the group.
               You can also provide custom attributes by specifying `attribute.{custom_attribute}`,
               where `{custom_attribute}` is the name of the custom attribute to be mapped. You can
               define a maximum of 50 custom attributes. The maximum length of a mapped attribute key
               is 100 characters, and the key may only contain the characters [a-z0-9_].
               You can reference these attributes in IAM policies to define fine-grained access for a
               workload to Google Cloud resources. For example:
               * `google.subject`:
               `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}`
               * `google.groups`:
               `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}`
               * `attribute.{custom_attribute}`:
               `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}`
               Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
               function that maps an identity provider credential to the normalized attribute specified
               by the corresponding map key.
               You can use the `assertion` keyword in the expression to access a JSON representation of
               the authentication credential issued by the provider.
               The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
               the total size of all mapped attributes must not exceed 8KB.
               For AWS providers, the following rules apply:
               - If no attribute mapping is defined, the following default mapping applies:
               ```
               {
               "google.subject":"assertion.arn",
               "attribute.aws_role":
               "assertion.arn.contains('assumed-role')"
               " ? assertion.arn.extract('{account_arn}assumed-role/')"
               "   + 'assumed-role/'"
               "   + assertion.arn.extract('assumed-role/{role_name}/')"
               " : assertion.arn",
               }
               ```
               - If any custom attribute mappings are defined, they must include a mapping to the
               `google.subject` attribute.
               For OIDC providers, the following rules apply:
               - Custom attribute mappings must be defined, and must include a mapping to the
               `google.subject` attribute. For example, the following maps the `sub` claim of the
               incoming credential to the `subject` attribute on a Google token.
               ```
               {"google.subject": "assertion.sub"}
               ```
        :param pulumi.Input[Union['WorkloadIdentityPoolProviderAwsArgs', 'WorkloadIdentityPoolProviderAwsArgsDict']] aws: An Amazon Web Services identity provider. Not compatible with the property oidc or saml.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description for the provider. Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
               However, existing tokens still grant access.
        :param pulumi.Input[builtins.str] display_name: A display name for the provider. Cannot exceed 32 characters.
        :param pulumi.Input[Union['WorkloadIdentityPoolProviderOidcArgs', 'WorkloadIdentityPoolProviderOidcArgsDict']] oidc: An OpenId Connect 1.0 identity provider. Not compatible with the property aws or saml.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['WorkloadIdentityPoolProviderSamlArgs', 'WorkloadIdentityPoolProviderSamlArgsDict']] saml: An SAML 2.0 identity provider. Not compatible with the property oidc or aws.
               Structure is documented below.
        :param pulumi.Input[builtins.str] workload_identity_pool_id: The ID used for the pool, which is the final component of the pool resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] workload_identity_pool_provider_id: The ID for the provider, which becomes the final component of the resource name. This
               value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[Union['WorkloadIdentityPoolProviderX509Args', 'WorkloadIdentityPoolProviderX509ArgsDict']] x509: An X.509-type identity provider represents a CA. It is trusted to assert a
               client identity if the client has a certificate that chains up to this CA.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkloadIdentityPoolProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A configuration for an external identity provider.

        To get more information about WorkloadIdentityPoolProvider, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.workloadIdentityPools.providers)
        * How-to Guides
            * [Managing workload identity providers](https://cloud.google.com/iam/docs/manage-workload-identity-pools-providers#managing_workload_identity_providers)

        ## Example Usage

        ### Iam Workload Identity Pool Provider Aws Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            aws={
                "account_id": "999999999999",
            })
        ```
        ### Iam Workload Identity Pool Provider Aws Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="AWS identity pool provider for automated test",
            disabled=True,
            attribute_condition="attribute.aws_role==\\"arn:aws:sts::999999999999:assumed-role/stack-eu-central-1-lambdaRole\\"",
            attribute_mapping={
                "google.subject": "assertion.arn",
                "attribute.aws_account": "assertion.account",
                "attribute.environment": "assertion.arn.contains(\\":instance-profile/Production\\") ? \\"prod\\" : \\"test\\"",
            },
            aws={
                "account_id": "999999999999",
            })
        ```
        ### Iam Workload Identity Pool Provider Github Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="GitHub Actions identity pool provider for automated test",
            disabled=True,
            attribute_condition=\"\"\"    assertion.repository_owner_id == "123456789" &&
            attribute.repository == "gh-org/gh-repo" &&
            assertion.ref == "refs/heads/main" &&
            assertion.ref_type == "branch"
        \"\"\",
            attribute_mapping={
                "google.subject": "assertion.sub",
                "attribute.actor": "assertion.actor",
                "attribute.aud": "assertion.aud",
                "attribute.repository": "assertion.repository",
            },
            oidc={
                "issuer_uri": "https://token.actions.githubusercontent.com",
            })
        ```
        ### Iam Workload Identity Pool Provider Oidc Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://sts.windows.net/azure-tenant-id",
            })
        ```
        ### Iam Workload Identity Pool Provider Oidc Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="OIDC identity pool provider for automated test",
            disabled=True,
            attribute_condition="\\"e968c2ef-047c-498d-8d79-16ca1b61e77e\\" in assertion.groups",
            attribute_mapping={
                "google.subject": "\\"azure::\\" + assertion.tid + \\"::\\" + assertion.sub",
                "attribute.tid": "assertion.tid",
                "attribute.managed_identity_name": \"\"\"      {
                "8bb39bdb-1cc5-4447-b7db-a19e920eb111":"workload1",
                "55d36609-9bcf-48e0-a366-a3cf19027d2a":"workload2"
              }[assertion.oid]
        \"\"\",
            },
            oidc={
                "allowed_audiences": [
                    "https://example.com/gcp-oidc-federation",
                    "example.com/gcp-oidc-federation",
                ],
                "issuer_uri": "https://sts.windows.net/azure-tenant-id",
            })
        ```
        ### Iam Workload Identity Pool Provider Saml Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.arn",
                "attribute.aws_account": "assertion.account",
                "attribute.environment": "assertion.arn.contains(\\":instance-profile/Production\\") ? \\"prod\\" : \\"test\\"",
            },
            saml={
                "idp_metadata_xml": std.file(input="test-fixtures/metadata.xml").result,
            })
        ```
        ### Iam Workload Identity Pool Provider Saml Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="SAML 2.0 identity pool provider for automated test",
            disabled=True,
            attribute_mapping={
                "google.subject": "assertion.arn",
                "attribute.aws_account": "assertion.account",
                "attribute.environment": "assertion.arn.contains(\\":instance-profile/Production\\") ? \\"prod\\" : \\"test\\"",
            },
            saml={
                "idp_metadata_xml": std.file(input="test-fixtures/metadata.xml").result,
            })
        ```
        ### Iam Workload Identity Pool Provider Oidc Upload Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="OIDC identity pool provider for automated test",
            disabled=True,
            attribute_condition="\\"e968c2ef-047c-498d-8d79-16ca1b61e77e\\" in assertion.groups",
            attribute_mapping={
                "google.subject": "\\"azure::\\" + assertion.tid + \\"::\\" + assertion.sub",
                "attribute.tid": "assertion.tid",
                "attribute.managed_identity_name": \"\"\"      {
                "8bb39bdb-1cc5-4447-b7db-a19e920eb111":"workload1",
                "55d36609-9bcf-48e0-a366-a3cf19027d2a":"workload2"
              }[assertion.oid]
        \"\"\",
            },
            oidc={
                "allowed_audiences": [
                    "https://example.com/gcp-oidc-federation",
                    "example.com/gcp-oidc-federation",
                ],
                "issuer_uri": "https://sts.windows.net/azure-tenant-id",
                "jwks_json": "{\\"keys\\":[{\\"kty\\":\\"RSA\\",\\"alg\\":\\"RS256\\",\\"kid\\":\\"sif0AR-F6MuvksAyAOv-Pds08Bcf2eUMlxE30NofddA\\",\\"use\\":\\"sig\\",\\"e\\":\\"AQAB\\",\\"n\\":\\"ylH1Chl1tpfti3lh51E1g5dPogzXDaQseqjsefGLknaNl5W6Wd4frBhHyE2t41Q5zgz_Ll0-NvWm0FlaG6brhrN9QZu6sJP1bM8WPfJVPgXOanxi7d7TXCkeNubGeiLTf5R3UXtS9Lm_guemU7MxDjDTelxnlgGCihOVTcL526suNJUdfXtpwUsvdU6_ZnAp9IpsuYjCtwPm9hPumlcZGMbxstdh07O4y4O90cVQClJOKSGQjAUCKJWXIQ0cqffGS_HuS_725CPzQ85SzYZzaNpgfhAER7kx_9P16ARM3BJz0PI5fe2hECE61J4GYU_BY43sxDfs7HyJpEXKLU9eWw\\"}]}",
            })
        ```
        ### Iam Workload Identity Pool Provider X509 Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.subject.dn.cn",
            },
            x509={
                "trust_store": {
                    "trust_anchors": [{
                        "pem_certificate": std.file(input="test-fixtures/trust_anchor.pem").result,
                    }],
                },
            })
        ```
        ### Iam Workload Identity Pool Provider X509 Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        pool = gcp.iam.WorkloadIdentityPool("pool", workload_identity_pool_id="example-pool")
        example = gcp.iam.WorkloadIdentityPoolProvider("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_provider_id="example-prvdr",
            display_name="Name of provider",
            description="X.509 identity pool provider for automated test",
            disabled=True,
            attribute_mapping={
                "google.subject": "assertion.subject.dn.cn",
            },
            x509={
                "trust_store": {
                    "trust_anchors": [{
                        "pem_certificate": std.file(input="test-fixtures/trust_anchor.pem").result,
                    }],
                    "intermediate_cas": [{
                        "pem_certificate": std.file(input="test-fixtures/intermediate_ca.pem").result,
                    }],
                },
            })
        ```

        ## Import

        WorkloadIdentityPoolProvider can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}/providers/{{workload_identity_pool_provider_id}}`

        * `{{project}}/{{workload_identity_pool_id}}/{{workload_identity_pool_provider_id}}`

        * `{{workload_identity_pool_id}}/{{workload_identity_pool_provider_id}}`

        When using the `pulumi import` command, WorkloadIdentityPoolProvider can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolProvider:WorkloadIdentityPoolProvider default projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}/providers/{{workload_identity_pool_provider_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolProvider:WorkloadIdentityPoolProvider default {{project}}/{{workload_identity_pool_id}}/{{workload_identity_pool_provider_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolProvider:WorkloadIdentityPoolProvider default {{workload_identity_pool_id}}/{{workload_identity_pool_provider_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkloadIdentityPoolProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkloadIdentityPoolProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_condition: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 aws: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderAwsArgs', 'WorkloadIdentityPoolProviderAwsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 oidc: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderOidcArgs', 'WorkloadIdentityPoolProviderOidcArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 saml: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderSamlArgs', 'WorkloadIdentityPoolProviderSamlArgsDict']]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_provider_id: Optional[pulumi.Input[builtins.str]] = None,
                 x509: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderX509Args', 'WorkloadIdentityPoolProviderX509ArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkloadIdentityPoolProviderArgs.__new__(WorkloadIdentityPoolProviderArgs)

            __props__.__dict__["attribute_condition"] = attribute_condition
            __props__.__dict__["attribute_mapping"] = attribute_mapping
            __props__.__dict__["aws"] = aws
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["oidc"] = oidc
            __props__.__dict__["project"] = project
            __props__.__dict__["saml"] = saml
            if workload_identity_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'workload_identity_pool_id'")
            __props__.__dict__["workload_identity_pool_id"] = workload_identity_pool_id
            if workload_identity_pool_provider_id is None and not opts.urn:
                raise TypeError("Missing required property 'workload_identity_pool_provider_id'")
            __props__.__dict__["workload_identity_pool_provider_id"] = workload_identity_pool_provider_id
            __props__.__dict__["x509"] = x509
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(WorkloadIdentityPoolProvider, __self__).__init__(
            'gcp:iam/workloadIdentityPoolProvider:WorkloadIdentityPoolProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_condition: Optional[pulumi.Input[builtins.str]] = None,
            attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            aws: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderAwsArgs', 'WorkloadIdentityPoolProviderAwsArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            oidc: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderOidcArgs', 'WorkloadIdentityPoolProviderOidcArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            saml: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderSamlArgs', 'WorkloadIdentityPoolProviderSamlArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            workload_identity_pool_provider_id: Optional[pulumi.Input[builtins.str]] = None,
            x509: Optional[pulumi.Input[Union['WorkloadIdentityPoolProviderX509Args', 'WorkloadIdentityPoolProviderX509ArgsDict']]] = None) -> 'WorkloadIdentityPoolProvider':
        """
        Get an existing WorkloadIdentityPoolProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attribute_condition: [A Common Expression Language](https://opensource.google/projects/cel) expression, in
               plain text, to restrict what otherwise valid authentication credentials issued by the
               provider should not be accepted.
               The expression must output a boolean representing whether to allow the federation.
               The following keywords may be referenced in the expressions:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attribute_mapping: Maps attributes from authentication credentials issued by an external identity provider
               to Google Cloud attributes, such as `subject` and `segment`.
               Each key must be a string specifying the Google Cloud IAM attribute to map to.
               The following keys are supported:
               * `google.subject`: The principal IAM is authenticating. You can reference this value
               in IAM bindings. This is also the subject that appears in Cloud Logging logs.
               Cannot exceed 127 characters.
               * `google.groups`: Groups the external identity belongs to. You can grant groups
               access to resources using an IAM `principalSet` binding; access applies to all
               members of the group.
               You can also provide custom attributes by specifying `attribute.{custom_attribute}`,
               where `{custom_attribute}` is the name of the custom attribute to be mapped. You can
               define a maximum of 50 custom attributes. The maximum length of a mapped attribute key
               is 100 characters, and the key may only contain the characters [a-z0-9_].
               You can reference these attributes in IAM policies to define fine-grained access for a
               workload to Google Cloud resources. For example:
               * `google.subject`:
               `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}`
               * `google.groups`:
               `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}`
               * `attribute.{custom_attribute}`:
               `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}`
               Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
               function that maps an identity provider credential to the normalized attribute specified
               by the corresponding map key.
               You can use the `assertion` keyword in the expression to access a JSON representation of
               the authentication credential issued by the provider.
               The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
               the total size of all mapped attributes must not exceed 8KB.
               For AWS providers, the following rules apply:
               - If no attribute mapping is defined, the following default mapping applies:
               ```
               {
               "google.subject":"assertion.arn",
               "attribute.aws_role":
               "assertion.arn.contains('assumed-role')"
               " ? assertion.arn.extract('{account_arn}assumed-role/')"
               "   + 'assumed-role/'"
               "   + assertion.arn.extract('assumed-role/{role_name}/')"
               " : assertion.arn",
               }
               ```
               - If any custom attribute mappings are defined, they must include a mapping to the
               `google.subject` attribute.
               For OIDC providers, the following rules apply:
               - Custom attribute mappings must be defined, and must include a mapping to the
               `google.subject` attribute. For example, the following maps the `sub` claim of the
               incoming credential to the `subject` attribute on a Google token.
               ```
               {"google.subject": "assertion.sub"}
               ```
        :param pulumi.Input[Union['WorkloadIdentityPoolProviderAwsArgs', 'WorkloadIdentityPoolProviderAwsArgsDict']] aws: An Amazon Web Services identity provider. Not compatible with the property oidc or saml.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description for the provider. Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
               However, existing tokens still grant access.
        :param pulumi.Input[builtins.str] display_name: A display name for the provider. Cannot exceed 32 characters.
        :param pulumi.Input[builtins.str] name: The resource name of the provider as
               `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}/providers/{workload_identity_pool_provider_id}`.
        :param pulumi.Input[Union['WorkloadIdentityPoolProviderOidcArgs', 'WorkloadIdentityPoolProviderOidcArgsDict']] oidc: An OpenId Connect 1.0 identity provider. Not compatible with the property aws or saml.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['WorkloadIdentityPoolProviderSamlArgs', 'WorkloadIdentityPoolProviderSamlArgsDict']] saml: An SAML 2.0 identity provider. Not compatible with the property oidc or aws.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: The state of the provider.
               * STATE_UNSPECIFIED: State unspecified.
               * ACTIVE: The provider is active, and may be used to validate authentication credentials.
               * DELETED: The provider is soft-deleted. Soft-deleted providers are permanently deleted
               after approximately 30 days. You can restore a soft-deleted provider using
               UndeleteWorkloadIdentityPoolProvider. You cannot reuse the ID of a soft-deleted provider
               until it is permanently deleted.
        :param pulumi.Input[builtins.str] workload_identity_pool_id: The ID used for the pool, which is the final component of the pool resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] workload_identity_pool_provider_id: The ID for the provider, which becomes the final component of the resource name. This
               value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[Union['WorkloadIdentityPoolProviderX509Args', 'WorkloadIdentityPoolProviderX509ArgsDict']] x509: An X.509-type identity provider represents a CA. It is trusted to assert a
               client identity if the client has a certificate that chains up to this CA.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkloadIdentityPoolProviderState.__new__(_WorkloadIdentityPoolProviderState)

        __props__.__dict__["attribute_condition"] = attribute_condition
        __props__.__dict__["attribute_mapping"] = attribute_mapping
        __props__.__dict__["aws"] = aws
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["oidc"] = oidc
        __props__.__dict__["project"] = project
        __props__.__dict__["saml"] = saml
        __props__.__dict__["state"] = state
        __props__.__dict__["workload_identity_pool_id"] = workload_identity_pool_id
        __props__.__dict__["workload_identity_pool_provider_id"] = workload_identity_pool_provider_id
        __props__.__dict__["x509"] = x509
        return WorkloadIdentityPoolProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attributeCondition")
    def attribute_condition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        [A Common Expression Language](https://opensource.google/projects/cel) expression, in
        plain text, to restrict what otherwise valid authentication credentials issued by the
        provider should not be accepted.
        The expression must output a boolean representing whether to allow the federation.
        The following keywords may be referenced in the expressions:
        """
        return pulumi.get(self, "attribute_condition")

    @property
    @pulumi.getter(name="attributeMapping")
    def attribute_mapping(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Maps attributes from authentication credentials issued by an external identity provider
        to Google Cloud attributes, such as `subject` and `segment`.
        Each key must be a string specifying the Google Cloud IAM attribute to map to.
        The following keys are supported:
        * `google.subject`: The principal IAM is authenticating. You can reference this value
        in IAM bindings. This is also the subject that appears in Cloud Logging logs.
        Cannot exceed 127 characters.
        * `google.groups`: Groups the external identity belongs to. You can grant groups
        access to resources using an IAM `principalSet` binding; access applies to all
        members of the group.
        You can also provide custom attributes by specifying `attribute.{custom_attribute}`,
        where `{custom_attribute}` is the name of the custom attribute to be mapped. You can
        define a maximum of 50 custom attributes. The maximum length of a mapped attribute key
        is 100 characters, and the key may only contain the characters [a-z0-9_].
        You can reference these attributes in IAM policies to define fine-grained access for a
        workload to Google Cloud resources. For example:
        * `google.subject`:
        `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}`
        * `google.groups`:
        `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}`
        * `attribute.{custom_attribute}`:
        `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}`
        Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
        function that maps an identity provider credential to the normalized attribute specified
        by the corresponding map key.
        You can use the `assertion` keyword in the expression to access a JSON representation of
        the authentication credential issued by the provider.
        The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
        the total size of all mapped attributes must not exceed 8KB.
        For AWS providers, the following rules apply:
        - If no attribute mapping is defined, the following default mapping applies:
        ```
        {
        "google.subject":"assertion.arn",
        "attribute.aws_role":
        "assertion.arn.contains('assumed-role')"
        " ? assertion.arn.extract('{account_arn}assumed-role/')"
        "   + 'assumed-role/'"
        "   + assertion.arn.extract('assumed-role/{role_name}/')"
        " : assertion.arn",
        }
        ```
        - If any custom attribute mappings are defined, they must include a mapping to the
        `google.subject` attribute.
        For OIDC providers, the following rules apply:
        - Custom attribute mappings must be defined, and must include a mapping to the
        `google.subject` attribute. For example, the following maps the `sub` claim of the
        incoming credential to the `subject` attribute on a Google token.
        ```
        {"google.subject": "assertion.sub"}
        ```
        """
        return pulumi.get(self, "attribute_mapping")

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.WorkloadIdentityPoolProviderAws']]:
        """
        An Amazon Web Services identity provider. Not compatible with the property oidc or saml.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
        However, existing tokens still grant access.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A display name for the provider. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the provider as
        `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}/providers/{workload_identity_pool_provider_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def oidc(self) -> pulumi.Output[Optional['outputs.WorkloadIdentityPoolProviderOidc']]:
        """
        An OpenId Connect 1.0 identity provider. Not compatible with the property aws or saml.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def saml(self) -> pulumi.Output[Optional['outputs.WorkloadIdentityPoolProviderSaml']]:
        """
        An SAML 2.0 identity provider. Not compatible with the property oidc or aws.
        Structure is documented below.
        """
        return pulumi.get(self, "saml")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the provider.
        * STATE_UNSPECIFIED: State unspecified.
        * ACTIVE: The provider is active, and may be used to validate authentication credentials.
        * DELETED: The provider is soft-deleted. Soft-deleted providers are permanently deleted
        after approximately 30 days. You can restore a soft-deleted provider using
        UndeleteWorkloadIdentityPoolProvider. You cannot reuse the ID of a soft-deleted provider
        until it is permanently deleted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID used for the pool, which is the final component of the pool resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @property
    @pulumi.getter(name="workloadIdentityPoolProviderId")
    def workload_identity_pool_provider_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID for the provider, which becomes the final component of the resource name. This
        value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_provider_id")

    @property
    @pulumi.getter
    def x509(self) -> pulumi.Output[Optional['outputs.WorkloadIdentityPoolProviderX509']]:
        """
        An X.509-type identity provider represents a CA. It is trusted to assert a
        client identity if the client has a certificate that chains up to this CA.
        Structure is documented below.
        """
        return pulumi.get(self, "x509")

