# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWebTypeAppEngineIamPolicyResult',
    'AwaitableGetWebTypeAppEngineIamPolicyResult',
    'get_web_type_app_engine_iam_policy',
    'get_web_type_app_engine_iam_policy_output',
]

@pulumi.output_type
class GetWebTypeAppEngineIamPolicyResult:
    """
    A collection of values returned by getWebTypeAppEngineIamPolicy.
    """
    def __init__(__self__, app_id=None, etag=None, id=None, policy_data=None, project=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> builtins.str:
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Required only by `iap.WebTypeAppEngingIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetWebTypeAppEngineIamPolicyResult(GetWebTypeAppEngineIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebTypeAppEngineIamPolicyResult(
            app_id=self.app_id,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            project=self.project)


def get_web_type_app_engine_iam_policy(app_id: Optional[builtins.str] = None,
                                       project: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebTypeAppEngineIamPolicyResult:
    """
    Retrieves the current IAM policy data for webtypeappengine

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.iap.get_web_type_app_engine_iam_policy(project=app["project"],
        app_id=app["appId"])
    ```


    :param builtins.str app_id: Used to find the parent resource to bind the IAM policy to
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:iap/getWebTypeAppEngineIamPolicy:getWebTypeAppEngineIamPolicy', __args__, opts=opts, typ=GetWebTypeAppEngineIamPolicyResult).value

    return AwaitableGetWebTypeAppEngineIamPolicyResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))
def get_web_type_app_engine_iam_policy_output(app_id: Optional[pulumi.Input[builtins.str]] = None,
                                              project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebTypeAppEngineIamPolicyResult]:
    """
    Retrieves the current IAM policy data for webtypeappengine

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.iap.get_web_type_app_engine_iam_policy(project=app["project"],
        app_id=app["appId"])
    ```


    :param builtins.str app_id: Used to find the parent resource to bind the IAM policy to
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:iap/getWebTypeAppEngineIamPolicy:getWebTypeAppEngineIamPolicy', __args__, opts=opts, typ=GetWebTypeAppEngineIamPolicyResult)
    return __ret__.apply(lambda __response__: GetWebTypeAppEngineIamPolicyResult(
        app_id=pulumi.get(__response__, 'app_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project')))
