# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CryptoKeyArgs', 'CryptoKey']

@pulumi.input_type
class CryptoKeyArgs:
    def __init__(__self__, *,
                 key_ring: pulumi.Input[builtins.str],
                 crypto_key_backend: Optional[pulumi.Input[builtins.str]] = None,
                 destroy_scheduled_duration: Optional[pulumi.Input[builtins.str]] = None,
                 import_only: Optional[pulumi.Input[builtins.bool]] = None,
                 key_access_justifications_policy: Optional[pulumi.Input['CryptoKeyKeyAccessJustificationsPolicyArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[builtins.str]] = None,
                 skip_initial_version_creation: Optional[pulumi.Input[builtins.bool]] = None,
                 version_template: Optional[pulumi.Input['CryptoKeyVersionTemplateArgs']] = None):
        """
        The set of arguments for constructing a CryptoKey resource.
        :param pulumi.Input[builtins.str] key_ring: The KeyRing that this key belongs to.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        :param pulumi.Input[builtins.str] crypto_key_backend: The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
               The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        :param pulumi.Input[builtins.str] destroy_scheduled_duration: The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
               If not specified at creation time, the default duration is 30 days.
        :param pulumi.Input[builtins.bool] import_only: Whether this key may contain imported versions only.
        :param pulumi.Input['CryptoKeyKeyAccessJustificationsPolicyArgs'] key_access_justifications_policy: The policy used for Key Access Justifications Policy Enforcement. If this
               field is present and this key is enrolled in Key Access Justifications
               Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
               sign operations, and the operation will fail if rejected by the policy. The
               policy is defined by specifying zero or more allowed justification codes.
               https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
               By default, this field is absent, and all justification codes are allowed.
               This field is currently in beta and is subject to change.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata to apply to this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name for the CryptoKey.
        :param pulumi.Input[builtins.str] purpose: The immutable purpose of this CryptoKey. See the
               [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
               for possible inputs.
               Default value is "ENCRYPT_DECRYPT".
        :param pulumi.Input[builtins.str] rotation_period: Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
               The first rotation will take place after the specified period. The rotation period has
               the format of a decimal number with up to 9 fractional digits, followed by the
               letter `s` (seconds). It must be greater than a day (ie, 86400).
        :param pulumi.Input[builtins.bool] skip_initial_version_creation: If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
               You must use the `kms.CryptoKeyVersion` resource to create a new CryptoKeyVersion
               or `kms.KeyRingImportJob` resource to import the CryptoKeyVersion.
        :param pulumi.Input['CryptoKeyVersionTemplateArgs'] version_template: A template describing settings for new crypto key versions.
               Structure is documented below.
        """
        pulumi.set(__self__, "key_ring", key_ring)
        if crypto_key_backend is not None:
            pulumi.set(__self__, "crypto_key_backend", crypto_key_backend)
        if destroy_scheduled_duration is not None:
            pulumi.set(__self__, "destroy_scheduled_duration", destroy_scheduled_duration)
        if import_only is not None:
            pulumi.set(__self__, "import_only", import_only)
        if key_access_justifications_policy is not None:
            pulumi.set(__self__, "key_access_justifications_policy", key_access_justifications_policy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if skip_initial_version_creation is not None:
            pulumi.set(__self__, "skip_initial_version_creation", skip_initial_version_creation)
        if version_template is not None:
            pulumi.set(__self__, "version_template", version_template)

    @property
    @pulumi.getter(name="keyRing")
    def key_ring(self) -> pulumi.Input[builtins.str]:
        """
        The KeyRing that this key belongs to.
        Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        """
        return pulumi.get(self, "key_ring")

    @key_ring.setter
    def key_ring(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_ring", value)

    @property
    @pulumi.getter(name="cryptoKeyBackend")
    def crypto_key_backend(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
        The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        """
        return pulumi.get(self, "crypto_key_backend")

    @crypto_key_backend.setter
    def crypto_key_backend(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crypto_key_backend", value)

    @property
    @pulumi.getter(name="destroyScheduledDuration")
    def destroy_scheduled_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
        If not specified at creation time, the default duration is 30 days.
        """
        return pulumi.get(self, "destroy_scheduled_duration")

    @destroy_scheduled_duration.setter
    def destroy_scheduled_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destroy_scheduled_duration", value)

    @property
    @pulumi.getter(name="importOnly")
    def import_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this key may contain imported versions only.
        """
        return pulumi.get(self, "import_only")

    @import_only.setter
    def import_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "import_only", value)

    @property
    @pulumi.getter(name="keyAccessJustificationsPolicy")
    def key_access_justifications_policy(self) -> Optional[pulumi.Input['CryptoKeyKeyAccessJustificationsPolicyArgs']]:
        """
        The policy used for Key Access Justifications Policy Enforcement. If this
        field is present and this key is enrolled in Key Access Justifications
        Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
        sign operations, and the operation will fail if rejected by the policy. The
        policy is defined by specifying zero or more allowed justification codes.
        https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
        By default, this field is absent, and all justification codes are allowed.
        This field is currently in beta and is subject to change.
        Structure is documented below.
        """
        return pulumi.get(self, "key_access_justifications_policy")

    @key_access_justifications_policy.setter
    def key_access_justifications_policy(self, value: Optional[pulumi.Input['CryptoKeyKeyAccessJustificationsPolicyArgs']]):
        pulumi.set(self, "key_access_justifications_policy", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels with user-defined metadata to apply to this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for the CryptoKey.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The immutable purpose of this CryptoKey. See the
        [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
        for possible inputs.
        Default value is "ENCRYPT_DECRYPT".
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
        The first rotation will take place after the specified period. The rotation period has
        the format of a decimal number with up to 9 fractional digits, followed by the
        letter `s` (seconds). It must be greater than a day (ie, 86400).
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rotation_period", value)

    @property
    @pulumi.getter(name="skipInitialVersionCreation")
    def skip_initial_version_creation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
        You must use the `kms.CryptoKeyVersion` resource to create a new CryptoKeyVersion
        or `kms.KeyRingImportJob` resource to import the CryptoKeyVersion.
        """
        return pulumi.get(self, "skip_initial_version_creation")

    @skip_initial_version_creation.setter
    def skip_initial_version_creation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_initial_version_creation", value)

    @property
    @pulumi.getter(name="versionTemplate")
    def version_template(self) -> Optional[pulumi.Input['CryptoKeyVersionTemplateArgs']]:
        """
        A template describing settings for new crypto key versions.
        Structure is documented below.
        """
        return pulumi.get(self, "version_template")

    @version_template.setter
    def version_template(self, value: Optional[pulumi.Input['CryptoKeyVersionTemplateArgs']]):
        pulumi.set(self, "version_template", value)


@pulumi.input_type
class _CryptoKeyState:
    def __init__(__self__, *,
                 crypto_key_backend: Optional[pulumi.Input[builtins.str]] = None,
                 destroy_scheduled_duration: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 import_only: Optional[pulumi.Input[builtins.bool]] = None,
                 key_access_justifications_policy: Optional[pulumi.Input['CryptoKeyKeyAccessJustificationsPolicyArgs']] = None,
                 key_ring: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primaries: Optional[pulumi.Input[Sequence[pulumi.Input['CryptoKeyPrimaryArgs']]]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[builtins.str]] = None,
                 skip_initial_version_creation: Optional[pulumi.Input[builtins.bool]] = None,
                 version_template: Optional[pulumi.Input['CryptoKeyVersionTemplateArgs']] = None):
        """
        Input properties used for looking up and filtering CryptoKey resources.
        :param pulumi.Input[builtins.str] crypto_key_backend: The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
               The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        :param pulumi.Input[builtins.str] destroy_scheduled_duration: The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
               If not specified at creation time, the default duration is 30 days.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] import_only: Whether this key may contain imported versions only.
        :param pulumi.Input['CryptoKeyKeyAccessJustificationsPolicyArgs'] key_access_justifications_policy: The policy used for Key Access Justifications Policy Enforcement. If this
               field is present and this key is enrolled in Key Access Justifications
               Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
               sign operations, and the operation will fail if rejected by the policy. The
               policy is defined by specifying zero or more allowed justification codes.
               https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
               By default, this field is absent, and all justification codes are allowed.
               This field is currently in beta and is subject to change.
               Structure is documented below.
        :param pulumi.Input[builtins.str] key_ring: The KeyRing that this key belongs to.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata to apply to this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name for the CryptoKey.
        :param pulumi.Input[Sequence[pulumi.Input['CryptoKeyPrimaryArgs']]] primaries: A copy of the primary CryptoKeyVersion that will be used by cryptoKeys.encrypt when this CryptoKey is given in EncryptRequest.name.
               Keys with purpose ENCRYPT_DECRYPT may have a primary. For other keys, this field will be unset.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] purpose: The immutable purpose of this CryptoKey. See the
               [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
               for possible inputs.
               Default value is "ENCRYPT_DECRYPT".
        :param pulumi.Input[builtins.str] rotation_period: Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
               The first rotation will take place after the specified period. The rotation period has
               the format of a decimal number with up to 9 fractional digits, followed by the
               letter `s` (seconds). It must be greater than a day (ie, 86400).
        :param pulumi.Input[builtins.bool] skip_initial_version_creation: If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
               You must use the `kms.CryptoKeyVersion` resource to create a new CryptoKeyVersion
               or `kms.KeyRingImportJob` resource to import the CryptoKeyVersion.
        :param pulumi.Input['CryptoKeyVersionTemplateArgs'] version_template: A template describing settings for new crypto key versions.
               Structure is documented below.
        """
        if crypto_key_backend is not None:
            pulumi.set(__self__, "crypto_key_backend", crypto_key_backend)
        if destroy_scheduled_duration is not None:
            pulumi.set(__self__, "destroy_scheduled_duration", destroy_scheduled_duration)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if import_only is not None:
            pulumi.set(__self__, "import_only", import_only)
        if key_access_justifications_policy is not None:
            pulumi.set(__self__, "key_access_justifications_policy", key_access_justifications_policy)
        if key_ring is not None:
            pulumi.set(__self__, "key_ring", key_ring)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primaries is not None:
            pulumi.set(__self__, "primaries", primaries)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if skip_initial_version_creation is not None:
            pulumi.set(__self__, "skip_initial_version_creation", skip_initial_version_creation)
        if version_template is not None:
            pulumi.set(__self__, "version_template", version_template)

    @property
    @pulumi.getter(name="cryptoKeyBackend")
    def crypto_key_backend(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
        The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        """
        return pulumi.get(self, "crypto_key_backend")

    @crypto_key_backend.setter
    def crypto_key_backend(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crypto_key_backend", value)

    @property
    @pulumi.getter(name="destroyScheduledDuration")
    def destroy_scheduled_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
        If not specified at creation time, the default duration is 30 days.
        """
        return pulumi.get(self, "destroy_scheduled_duration")

    @destroy_scheduled_duration.setter
    def destroy_scheduled_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destroy_scheduled_duration", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="importOnly")
    def import_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this key may contain imported versions only.
        """
        return pulumi.get(self, "import_only")

    @import_only.setter
    def import_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "import_only", value)

    @property
    @pulumi.getter(name="keyAccessJustificationsPolicy")
    def key_access_justifications_policy(self) -> Optional[pulumi.Input['CryptoKeyKeyAccessJustificationsPolicyArgs']]:
        """
        The policy used for Key Access Justifications Policy Enforcement. If this
        field is present and this key is enrolled in Key Access Justifications
        Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
        sign operations, and the operation will fail if rejected by the policy. The
        policy is defined by specifying zero or more allowed justification codes.
        https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
        By default, this field is absent, and all justification codes are allowed.
        This field is currently in beta and is subject to change.
        Structure is documented below.
        """
        return pulumi.get(self, "key_access_justifications_policy")

    @key_access_justifications_policy.setter
    def key_access_justifications_policy(self, value: Optional[pulumi.Input['CryptoKeyKeyAccessJustificationsPolicyArgs']]):
        pulumi.set(self, "key_access_justifications_policy", value)

    @property
    @pulumi.getter(name="keyRing")
    def key_ring(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KeyRing that this key belongs to.
        Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        """
        return pulumi.get(self, "key_ring")

    @key_ring.setter
    def key_ring(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_ring", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels with user-defined metadata to apply to this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for the CryptoKey.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def primaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CryptoKeyPrimaryArgs']]]]:
        """
        A copy of the primary CryptoKeyVersion that will be used by cryptoKeys.encrypt when this CryptoKey is given in EncryptRequest.name.
        Keys with purpose ENCRYPT_DECRYPT may have a primary. For other keys, this field will be unset.
        Structure is documented below.
        """
        return pulumi.get(self, "primaries")

    @primaries.setter
    def primaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CryptoKeyPrimaryArgs']]]]):
        pulumi.set(self, "primaries", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The immutable purpose of this CryptoKey. See the
        [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
        for possible inputs.
        Default value is "ENCRYPT_DECRYPT".
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
        The first rotation will take place after the specified period. The rotation period has
        the format of a decimal number with up to 9 fractional digits, followed by the
        letter `s` (seconds). It must be greater than a day (ie, 86400).
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rotation_period", value)

    @property
    @pulumi.getter(name="skipInitialVersionCreation")
    def skip_initial_version_creation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
        You must use the `kms.CryptoKeyVersion` resource to create a new CryptoKeyVersion
        or `kms.KeyRingImportJob` resource to import the CryptoKeyVersion.
        """
        return pulumi.get(self, "skip_initial_version_creation")

    @skip_initial_version_creation.setter
    def skip_initial_version_creation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_initial_version_creation", value)

    @property
    @pulumi.getter(name="versionTemplate")
    def version_template(self) -> Optional[pulumi.Input['CryptoKeyVersionTemplateArgs']]:
        """
        A template describing settings for new crypto key versions.
        Structure is documented below.
        """
        return pulumi.get(self, "version_template")

    @version_template.setter
    def version_template(self, value: Optional[pulumi.Input['CryptoKeyVersionTemplateArgs']]):
        pulumi.set(self, "version_template", value)


@pulumi.type_token("gcp:kms/cryptoKey:CryptoKey")
class CryptoKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key_backend: Optional[pulumi.Input[builtins.str]] = None,
                 destroy_scheduled_duration: Optional[pulumi.Input[builtins.str]] = None,
                 import_only: Optional[pulumi.Input[builtins.bool]] = None,
                 key_access_justifications_policy: Optional[pulumi.Input[Union['CryptoKeyKeyAccessJustificationsPolicyArgs', 'CryptoKeyKeyAccessJustificationsPolicyArgsDict']]] = None,
                 key_ring: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[builtins.str]] = None,
                 skip_initial_version_creation: Optional[pulumi.Input[builtins.bool]] = None,
                 version_template: Optional[pulumi.Input[Union['CryptoKeyVersionTemplateArgs', 'CryptoKeyVersionTemplateArgsDict']]] = None,
                 __props__=None):
        """
        A `CryptoKey` represents a logical key that can be used for cryptographic operations.

        > **Note:** CryptoKeys cannot be deleted from Google Cloud Platform.
        Destroying a provider-managed CryptoKey will remove it from state
        and delete all CryptoKeyVersions, rendering the key unusable, but *will
        not delete the resource from the project.* When the provider destroys these keys,
        any data previously encrypted with these keys will be irrecoverable.
        For this reason, it is strongly recommended that you use Pulumi's [protect resource option](https://www.pulumi.com/docs/concepts/options/protect/).

        To get more information about CryptoKey, see:

        * [API documentation](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
        * How-to Guides
            * [Creating a key](https://cloud.google.com/kms/docs/creating-keys#create_a_key)

        ## Example Usage

        ### Kms Crypto Key Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        keyring = gcp.kms.KeyRing("keyring",
            name="keyring-example",
            location="global")
        example_key = gcp.kms.CryptoKey("example-key",
            name="crypto-key-example",
            key_ring=keyring.id,
            rotation_period="7776000s")
        ```
        ### Kms Crypto Key Asymmetric Sign

        ```python
        import pulumi
        import pulumi_gcp as gcp

        keyring = gcp.kms.KeyRing("keyring",
            name="keyring-example",
            location="global")
        example_asymmetric_sign_key = gcp.kms.CryptoKey("example-asymmetric-sign-key",
            name="crypto-key-example",
            key_ring=keyring.id,
            purpose="ASYMMETRIC_SIGN",
            version_template={
                "algorithm": "EC_SIGN_P384_SHA384",
            })
        ```

        ## Import

        CryptoKey can be imported using any of these accepted formats:

        * `{{key_ring}}/cryptoKeys/{{name}}`

        * `{{key_ring}}/{{name}}`

        When using the `pulumi import` command, CryptoKey can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/cryptoKey:CryptoKey default {{key_ring}}/cryptoKeys/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/cryptoKey:CryptoKey default {{key_ring}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] crypto_key_backend: The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
               The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        :param pulumi.Input[builtins.str] destroy_scheduled_duration: The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
               If not specified at creation time, the default duration is 30 days.
        :param pulumi.Input[builtins.bool] import_only: Whether this key may contain imported versions only.
        :param pulumi.Input[Union['CryptoKeyKeyAccessJustificationsPolicyArgs', 'CryptoKeyKeyAccessJustificationsPolicyArgsDict']] key_access_justifications_policy: The policy used for Key Access Justifications Policy Enforcement. If this
               field is present and this key is enrolled in Key Access Justifications
               Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
               sign operations, and the operation will fail if rejected by the policy. The
               policy is defined by specifying zero or more allowed justification codes.
               https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
               By default, this field is absent, and all justification codes are allowed.
               This field is currently in beta and is subject to change.
               Structure is documented below.
        :param pulumi.Input[builtins.str] key_ring: The KeyRing that this key belongs to.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata to apply to this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name for the CryptoKey.
        :param pulumi.Input[builtins.str] purpose: The immutable purpose of this CryptoKey. See the
               [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
               for possible inputs.
               Default value is "ENCRYPT_DECRYPT".
        :param pulumi.Input[builtins.str] rotation_period: Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
               The first rotation will take place after the specified period. The rotation period has
               the format of a decimal number with up to 9 fractional digits, followed by the
               letter `s` (seconds). It must be greater than a day (ie, 86400).
        :param pulumi.Input[builtins.bool] skip_initial_version_creation: If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
               You must use the `kms.CryptoKeyVersion` resource to create a new CryptoKeyVersion
               or `kms.KeyRingImportJob` resource to import the CryptoKeyVersion.
        :param pulumi.Input[Union['CryptoKeyVersionTemplateArgs', 'CryptoKeyVersionTemplateArgsDict']] version_template: A template describing settings for new crypto key versions.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CryptoKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A `CryptoKey` represents a logical key that can be used for cryptographic operations.

        > **Note:** CryptoKeys cannot be deleted from Google Cloud Platform.
        Destroying a provider-managed CryptoKey will remove it from state
        and delete all CryptoKeyVersions, rendering the key unusable, but *will
        not delete the resource from the project.* When the provider destroys these keys,
        any data previously encrypted with these keys will be irrecoverable.
        For this reason, it is strongly recommended that you use Pulumi's [protect resource option](https://www.pulumi.com/docs/concepts/options/protect/).

        To get more information about CryptoKey, see:

        * [API documentation](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
        * How-to Guides
            * [Creating a key](https://cloud.google.com/kms/docs/creating-keys#create_a_key)

        ## Example Usage

        ### Kms Crypto Key Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        keyring = gcp.kms.KeyRing("keyring",
            name="keyring-example",
            location="global")
        example_key = gcp.kms.CryptoKey("example-key",
            name="crypto-key-example",
            key_ring=keyring.id,
            rotation_period="7776000s")
        ```
        ### Kms Crypto Key Asymmetric Sign

        ```python
        import pulumi
        import pulumi_gcp as gcp

        keyring = gcp.kms.KeyRing("keyring",
            name="keyring-example",
            location="global")
        example_asymmetric_sign_key = gcp.kms.CryptoKey("example-asymmetric-sign-key",
            name="crypto-key-example",
            key_ring=keyring.id,
            purpose="ASYMMETRIC_SIGN",
            version_template={
                "algorithm": "EC_SIGN_P384_SHA384",
            })
        ```

        ## Import

        CryptoKey can be imported using any of these accepted formats:

        * `{{key_ring}}/cryptoKeys/{{name}}`

        * `{{key_ring}}/{{name}}`

        When using the `pulumi import` command, CryptoKey can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/cryptoKey:CryptoKey default {{key_ring}}/cryptoKeys/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/cryptoKey:CryptoKey default {{key_ring}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CryptoKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CryptoKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key_backend: Optional[pulumi.Input[builtins.str]] = None,
                 destroy_scheduled_duration: Optional[pulumi.Input[builtins.str]] = None,
                 import_only: Optional[pulumi.Input[builtins.bool]] = None,
                 key_access_justifications_policy: Optional[pulumi.Input[Union['CryptoKeyKeyAccessJustificationsPolicyArgs', 'CryptoKeyKeyAccessJustificationsPolicyArgsDict']]] = None,
                 key_ring: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[builtins.str]] = None,
                 skip_initial_version_creation: Optional[pulumi.Input[builtins.bool]] = None,
                 version_template: Optional[pulumi.Input[Union['CryptoKeyVersionTemplateArgs', 'CryptoKeyVersionTemplateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CryptoKeyArgs.__new__(CryptoKeyArgs)

            __props__.__dict__["crypto_key_backend"] = crypto_key_backend
            __props__.__dict__["destroy_scheduled_duration"] = destroy_scheduled_duration
            __props__.__dict__["import_only"] = import_only
            __props__.__dict__["key_access_justifications_policy"] = key_access_justifications_policy
            if key_ring is None and not opts.urn:
                raise TypeError("Missing required property 'key_ring'")
            __props__.__dict__["key_ring"] = key_ring
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["skip_initial_version_creation"] = skip_initial_version_creation
            __props__.__dict__["version_template"] = version_template
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["primaries"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CryptoKey, __self__).__init__(
            'gcp:kms/cryptoKey:CryptoKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            crypto_key_backend: Optional[pulumi.Input[builtins.str]] = None,
            destroy_scheduled_duration: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            import_only: Optional[pulumi.Input[builtins.bool]] = None,
            key_access_justifications_policy: Optional[pulumi.Input[Union['CryptoKeyKeyAccessJustificationsPolicyArgs', 'CryptoKeyKeyAccessJustificationsPolicyArgsDict']]] = None,
            key_ring: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            primaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CryptoKeyPrimaryArgs', 'CryptoKeyPrimaryArgsDict']]]]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            purpose: Optional[pulumi.Input[builtins.str]] = None,
            rotation_period: Optional[pulumi.Input[builtins.str]] = None,
            skip_initial_version_creation: Optional[pulumi.Input[builtins.bool]] = None,
            version_template: Optional[pulumi.Input[Union['CryptoKeyVersionTemplateArgs', 'CryptoKeyVersionTemplateArgsDict']]] = None) -> 'CryptoKey':
        """
        Get an existing CryptoKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] crypto_key_backend: The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
               The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        :param pulumi.Input[builtins.str] destroy_scheduled_duration: The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
               If not specified at creation time, the default duration is 30 days.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] import_only: Whether this key may contain imported versions only.
        :param pulumi.Input[Union['CryptoKeyKeyAccessJustificationsPolicyArgs', 'CryptoKeyKeyAccessJustificationsPolicyArgsDict']] key_access_justifications_policy: The policy used for Key Access Justifications Policy Enforcement. If this
               field is present and this key is enrolled in Key Access Justifications
               Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
               sign operations, and the operation will fail if rejected by the policy. The
               policy is defined by specifying zero or more allowed justification codes.
               https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
               By default, this field is absent, and all justification codes are allowed.
               This field is currently in beta and is subject to change.
               Structure is documented below.
        :param pulumi.Input[builtins.str] key_ring: The KeyRing that this key belongs to.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata to apply to this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The resource name for the CryptoKey.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CryptoKeyPrimaryArgs', 'CryptoKeyPrimaryArgsDict']]]] primaries: A copy of the primary CryptoKeyVersion that will be used by cryptoKeys.encrypt when this CryptoKey is given in EncryptRequest.name.
               Keys with purpose ENCRYPT_DECRYPT may have a primary. For other keys, this field will be unset.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] purpose: The immutable purpose of this CryptoKey. See the
               [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
               for possible inputs.
               Default value is "ENCRYPT_DECRYPT".
        :param pulumi.Input[builtins.str] rotation_period: Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
               The first rotation will take place after the specified period. The rotation period has
               the format of a decimal number with up to 9 fractional digits, followed by the
               letter `s` (seconds). It must be greater than a day (ie, 86400).
        :param pulumi.Input[builtins.bool] skip_initial_version_creation: If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
               You must use the `kms.CryptoKeyVersion` resource to create a new CryptoKeyVersion
               or `kms.KeyRingImportJob` resource to import the CryptoKeyVersion.
        :param pulumi.Input[Union['CryptoKeyVersionTemplateArgs', 'CryptoKeyVersionTemplateArgsDict']] version_template: A template describing settings for new crypto key versions.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CryptoKeyState.__new__(_CryptoKeyState)

        __props__.__dict__["crypto_key_backend"] = crypto_key_backend
        __props__.__dict__["destroy_scheduled_duration"] = destroy_scheduled_duration
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["import_only"] = import_only
        __props__.__dict__["key_access_justifications_policy"] = key_access_justifications_policy
        __props__.__dict__["key_ring"] = key_ring
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["primaries"] = primaries
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["skip_initial_version_creation"] = skip_initial_version_creation
        __props__.__dict__["version_template"] = version_template
        return CryptoKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cryptoKeyBackend")
    def crypto_key_backend(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
        The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        """
        return pulumi.get(self, "crypto_key_backend")

    @property
    @pulumi.getter(name="destroyScheduledDuration")
    def destroy_scheduled_duration(self) -> pulumi.Output[builtins.str]:
        """
        The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
        If not specified at creation time, the default duration is 30 days.
        """
        return pulumi.get(self, "destroy_scheduled_duration")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="importOnly")
    def import_only(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this key may contain imported versions only.
        """
        return pulumi.get(self, "import_only")

    @property
    @pulumi.getter(name="keyAccessJustificationsPolicy")
    def key_access_justifications_policy(self) -> pulumi.Output['outputs.CryptoKeyKeyAccessJustificationsPolicy']:
        """
        The policy used for Key Access Justifications Policy Enforcement. If this
        field is present and this key is enrolled in Key Access Justifications
        Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
        sign operations, and the operation will fail if rejected by the policy. The
        policy is defined by specifying zero or more allowed justification codes.
        https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
        By default, this field is absent, and all justification codes are allowed.
        This field is currently in beta and is subject to change.
        Structure is documented below.
        """
        return pulumi.get(self, "key_access_justifications_policy")

    @property
    @pulumi.getter(name="keyRing")
    def key_ring(self) -> pulumi.Output[builtins.str]:
        """
        The KeyRing that this key belongs to.
        Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        """
        return pulumi.get(self, "key_ring")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels with user-defined metadata to apply to this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name for the CryptoKey.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primaries(self) -> pulumi.Output[Sequence['outputs.CryptoKeyPrimary']]:
        """
        A copy of the primary CryptoKeyVersion that will be used by cryptoKeys.encrypt when this CryptoKey is given in EncryptRequest.name.
        Keys with purpose ENCRYPT_DECRYPT may have a primary. For other keys, this field will be unset.
        Structure is documented below.
        """
        return pulumi.get(self, "primaries")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The immutable purpose of this CryptoKey. See the
        [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
        for possible inputs.
        Default value is "ENCRYPT_DECRYPT".
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
        The first rotation will take place after the specified period. The rotation period has
        the format of a decimal number with up to 9 fractional digits, followed by the
        letter `s` (seconds). It must be greater than a day (ie, 86400).
        """
        return pulumi.get(self, "rotation_period")

    @property
    @pulumi.getter(name="skipInitialVersionCreation")
    def skip_initial_version_creation(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
        You must use the `kms.CryptoKeyVersion` resource to create a new CryptoKeyVersion
        or `kms.KeyRingImportJob` resource to import the CryptoKeyVersion.
        """
        return pulumi.get(self, "skip_initial_version_creation")

    @property
    @pulumi.getter(name="versionTemplate")
    def version_template(self) -> pulumi.Output['outputs.CryptoKeyVersionTemplate']:
        """
        A template describing settings for new crypto key versions.
        Structure is documented below.
        """
        return pulumi.get(self, "version_template")

