# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EkmConnectionArgs', 'EkmConnection']

@pulumi.input_type
class EkmConnectionArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 service_resolvers: pulumi.Input[Sequence[pulumi.Input['EkmConnectionServiceResolverArgs']]],
                 crypto_space_path: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key_management_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EkmConnection resource.
        :param pulumi.Input[builtins.str] location: The location for the EkmConnection.
               A full list of valid locations can be found by running `gcloud kms locations list`.
        :param pulumi.Input[Sequence[pulumi.Input['EkmConnectionServiceResolverArgs']]] service_resolvers: A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported
               Structure is documented below.
        :param pulumi.Input[builtins.str] crypto_space_path: Optional. Identifies the EKM Crypto Space that this EkmConnection maps to. Note: This field is required if KeyManagementMode is CLOUD_KMS.
        :param pulumi.Input[builtins.str] etag: Optional. Etag of the currently stored EkmConnection.
        :param pulumi.Input[builtins.str] key_management_mode: Optional. Describes who can perform control plane operations on the EKM. If unset, this defaults to MANUAL
               Default value is `MANUAL`.
               Possible values are: `MANUAL`, `CLOUD_KMS`.
        :param pulumi.Input[builtins.str] name: The resource name for the EkmConnection.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "service_resolvers", service_resolvers)
        if crypto_space_path is not None:
            pulumi.set(__self__, "crypto_space_path", crypto_space_path)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key_management_mode is not None:
            pulumi.set(__self__, "key_management_mode", key_management_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the EkmConnection.
        A full list of valid locations can be found by running `gcloud kms locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="serviceResolvers")
    def service_resolvers(self) -> pulumi.Input[Sequence[pulumi.Input['EkmConnectionServiceResolverArgs']]]:
        """
        A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported
        Structure is documented below.
        """
        return pulumi.get(self, "service_resolvers")

    @service_resolvers.setter
    def service_resolvers(self, value: pulumi.Input[Sequence[pulumi.Input['EkmConnectionServiceResolverArgs']]]):
        pulumi.set(self, "service_resolvers", value)

    @property
    @pulumi.getter(name="cryptoSpacePath")
    def crypto_space_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Identifies the EKM Crypto Space that this EkmConnection maps to. Note: This field is required if KeyManagementMode is CLOUD_KMS.
        """
        return pulumi.get(self, "crypto_space_path")

    @crypto_space_path.setter
    def crypto_space_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crypto_space_path", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Etag of the currently stored EkmConnection.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="keyManagementMode")
    def key_management_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Describes who can perform control plane operations on the EKM. If unset, this defaults to MANUAL
        Default value is `MANUAL`.
        Possible values are: `MANUAL`, `CLOUD_KMS`.
        """
        return pulumi.get(self, "key_management_mode")

    @key_management_mode.setter
    def key_management_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_management_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for the EkmConnection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _EkmConnectionState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 crypto_space_path: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key_management_mode: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_resolvers: Optional[pulumi.Input[Sequence[pulumi.Input['EkmConnectionServiceResolverArgs']]]] = None):
        """
        Input properties used for looking up and filtering EkmConnection resources.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which the EkmConnection was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] crypto_space_path: Optional. Identifies the EKM Crypto Space that this EkmConnection maps to. Note: This field is required if KeyManagementMode is CLOUD_KMS.
        :param pulumi.Input[builtins.str] etag: Optional. Etag of the currently stored EkmConnection.
        :param pulumi.Input[builtins.str] key_management_mode: Optional. Describes who can perform control plane operations on the EKM. If unset, this defaults to MANUAL
               Default value is `MANUAL`.
               Possible values are: `MANUAL`, `CLOUD_KMS`.
        :param pulumi.Input[builtins.str] location: The location for the EkmConnection.
               A full list of valid locations can be found by running `gcloud kms locations list`.
        :param pulumi.Input[builtins.str] name: The resource name for the EkmConnection.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['EkmConnectionServiceResolverArgs']]] service_resolvers: A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if crypto_space_path is not None:
            pulumi.set(__self__, "crypto_space_path", crypto_space_path)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key_management_mode is not None:
            pulumi.set(__self__, "key_management_mode", key_management_mode)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_resolvers is not None:
            pulumi.set(__self__, "service_resolvers", service_resolvers)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which the EkmConnection was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="cryptoSpacePath")
    def crypto_space_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Identifies the EKM Crypto Space that this EkmConnection maps to. Note: This field is required if KeyManagementMode is CLOUD_KMS.
        """
        return pulumi.get(self, "crypto_space_path")

    @crypto_space_path.setter
    def crypto_space_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crypto_space_path", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Etag of the currently stored EkmConnection.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="keyManagementMode")
    def key_management_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Describes who can perform control plane operations on the EKM. If unset, this defaults to MANUAL
        Default value is `MANUAL`.
        Possible values are: `MANUAL`, `CLOUD_KMS`.
        """
        return pulumi.get(self, "key_management_mode")

    @key_management_mode.setter
    def key_management_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_management_mode", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the EkmConnection.
        A full list of valid locations can be found by running `gcloud kms locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for the EkmConnection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceResolvers")
    def service_resolvers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EkmConnectionServiceResolverArgs']]]]:
        """
        A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported
        Structure is documented below.
        """
        return pulumi.get(self, "service_resolvers")

    @service_resolvers.setter
    def service_resolvers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EkmConnectionServiceResolverArgs']]]]):
        pulumi.set(self, "service_resolvers", value)


@pulumi.type_token("gcp:kms/ekmConnection:EkmConnection")
class EkmConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_space_path: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key_management_mode: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_resolvers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EkmConnectionServiceResolverArgs', 'EkmConnectionServiceResolverArgsDict']]]]] = None,
                 __props__=None):
        """
        `Ekm Connections` are used to control the connection settings for an `EXTERNAL_VPC` CryptoKey.
        It is used to connect customer's external key manager to Google Cloud EKM.

        > **Note:** Ekm Connections cannot be deleted from Google Cloud Platform.

        To get more information about EkmConnection, see:

        * [API documentation](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.ekmConnections)
        * How-to Guides
            * [Creating a Ekm Connection](https://cloud.google.com/kms/docs/create-ekm-connection)

        ## Example Usage

        ### Kms Ekm Connection Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_ekmconnection = gcp.kms.EkmConnection("example-ekmconnection",
            name="ekmconnection_example",
            location="us-central1",
            key_management_mode="MANUAL",
            service_resolvers=[{
                "service_directory_service": "projects/project_id/locations/us-central1/namespaces/namespace_name/services/service_name",
                "hostname": "example-ekm.goog",
                "server_certificates": [{
                    "raw_der": "==HAwIBCCAr6gAwIBAgIUWR+EV4lqiV7Ql12VY==",
                }],
            }])
        ```

        ## Import

        EkmConnection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/ekmConnections/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, EkmConnection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/ekmConnection:EkmConnection default projects/{{project}}/locations/{{location}}/ekmConnections/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/ekmConnection:EkmConnection default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/ekmConnection:EkmConnection default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] crypto_space_path: Optional. Identifies the EKM Crypto Space that this EkmConnection maps to. Note: This field is required if KeyManagementMode is CLOUD_KMS.
        :param pulumi.Input[builtins.str] etag: Optional. Etag of the currently stored EkmConnection.
        :param pulumi.Input[builtins.str] key_management_mode: Optional. Describes who can perform control plane operations on the EKM. If unset, this defaults to MANUAL
               Default value is `MANUAL`.
               Possible values are: `MANUAL`, `CLOUD_KMS`.
        :param pulumi.Input[builtins.str] location: The location for the EkmConnection.
               A full list of valid locations can be found by running `gcloud kms locations list`.
        :param pulumi.Input[builtins.str] name: The resource name for the EkmConnection.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EkmConnectionServiceResolverArgs', 'EkmConnectionServiceResolverArgsDict']]]] service_resolvers: A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EkmConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `Ekm Connections` are used to control the connection settings for an `EXTERNAL_VPC` CryptoKey.
        It is used to connect customer's external key manager to Google Cloud EKM.

        > **Note:** Ekm Connections cannot be deleted from Google Cloud Platform.

        To get more information about EkmConnection, see:

        * [API documentation](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.ekmConnections)
        * How-to Guides
            * [Creating a Ekm Connection](https://cloud.google.com/kms/docs/create-ekm-connection)

        ## Example Usage

        ### Kms Ekm Connection Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_ekmconnection = gcp.kms.EkmConnection("example-ekmconnection",
            name="ekmconnection_example",
            location="us-central1",
            key_management_mode="MANUAL",
            service_resolvers=[{
                "service_directory_service": "projects/project_id/locations/us-central1/namespaces/namespace_name/services/service_name",
                "hostname": "example-ekm.goog",
                "server_certificates": [{
                    "raw_der": "==HAwIBCCAr6gAwIBAgIUWR+EV4lqiV7Ql12VY==",
                }],
            }])
        ```

        ## Import

        EkmConnection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/ekmConnections/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, EkmConnection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/ekmConnection:EkmConnection default projects/{{project}}/locations/{{location}}/ekmConnections/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/ekmConnection:EkmConnection default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/ekmConnection:EkmConnection default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EkmConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EkmConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_space_path: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key_management_mode: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_resolvers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EkmConnectionServiceResolverArgs', 'EkmConnectionServiceResolverArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EkmConnectionArgs.__new__(EkmConnectionArgs)

            __props__.__dict__["crypto_space_path"] = crypto_space_path
            __props__.__dict__["etag"] = etag
            __props__.__dict__["key_management_mode"] = key_management_mode
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if service_resolvers is None and not opts.urn:
                raise TypeError("Missing required property 'service_resolvers'")
            __props__.__dict__["service_resolvers"] = service_resolvers
            __props__.__dict__["create_time"] = None
        super(EkmConnection, __self__).__init__(
            'gcp:kms/ekmConnection:EkmConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            crypto_space_path: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            key_management_mode: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            service_resolvers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EkmConnectionServiceResolverArgs', 'EkmConnectionServiceResolverArgsDict']]]]] = None) -> 'EkmConnection':
        """
        Get an existing EkmConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which the EkmConnection was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] crypto_space_path: Optional. Identifies the EKM Crypto Space that this EkmConnection maps to. Note: This field is required if KeyManagementMode is CLOUD_KMS.
        :param pulumi.Input[builtins.str] etag: Optional. Etag of the currently stored EkmConnection.
        :param pulumi.Input[builtins.str] key_management_mode: Optional. Describes who can perform control plane operations on the EKM. If unset, this defaults to MANUAL
               Default value is `MANUAL`.
               Possible values are: `MANUAL`, `CLOUD_KMS`.
        :param pulumi.Input[builtins.str] location: The location for the EkmConnection.
               A full list of valid locations can be found by running `gcloud kms locations list`.
        :param pulumi.Input[builtins.str] name: The resource name for the EkmConnection.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EkmConnectionServiceResolverArgs', 'EkmConnectionServiceResolverArgsDict']]]] service_resolvers: A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EkmConnectionState.__new__(_EkmConnectionState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["crypto_space_path"] = crypto_space_path
        __props__.__dict__["etag"] = etag
        __props__.__dict__["key_management_mode"] = key_management_mode
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["service_resolvers"] = service_resolvers
        return EkmConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which the EkmConnection was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="cryptoSpacePath")
    def crypto_space_path(self) -> pulumi.Output[builtins.str]:
        """
        Optional. Identifies the EKM Crypto Space that this EkmConnection maps to. Note: This field is required if KeyManagementMode is CLOUD_KMS.
        """
        return pulumi.get(self, "crypto_space_path")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Optional. Etag of the currently stored EkmConnection.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="keyManagementMode")
    def key_management_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. Describes who can perform control plane operations on the EKM. If unset, this defaults to MANUAL
        Default value is `MANUAL`.
        Possible values are: `MANUAL`, `CLOUD_KMS`.
        """
        return pulumi.get(self, "key_management_mode")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the EkmConnection.
        A full list of valid locations can be found by running `gcloud kms locations list`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name for the EkmConnection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceResolvers")
    def service_resolvers(self) -> pulumi.Output[Sequence['outputs.EkmConnectionServiceResolver']]:
        """
        A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported
        Structure is documented below.
        """
        return pulumi.get(self, "service_resolvers")

