# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAutokeyConfigResult',
    'AwaitableGetAutokeyConfigResult',
    'get_autokey_config',
    'get_autokey_config_output',
]

@pulumi.output_type
class GetAutokeyConfigResult:
    """
    A collection of values returned by getAutokeyConfig.
    """
    def __init__(__self__, etag=None, folder=None, id=None, key_project=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_project and not isinstance(key_project, str):
            raise TypeError("Expected argument 'key_project' to be a str")
        pulumi.set(__self__, "key_project", key_project)

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def folder(self) -> builtins.str:
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyProject")
    def key_project(self) -> builtins.str:
        """
        The identifier of the project hosting KMS KeyRings and Keys generated by Autokey. Its format is `projects/{projectId}`.
        """
        return pulumi.get(self, "key_project")


class AwaitableGetAutokeyConfigResult(GetAutokeyConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutokeyConfigResult(
            etag=self.etag,
            folder=self.folder,
            id=self.id,
            key_project=self.key_project)


def get_autokey_config(folder: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutokeyConfigResult:
    """
    Provides access to Google Cloud Platform KMS AutokeyConfig. A AutokeyConfig is a Cloud KMS resource that helps you safely span the separation of duties to create new Cloud KMS keys for CMEK using Autokey.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/reference/rest/v1/folders)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyHandles).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_autokey_config = gcp.kms.get_autokey_config(folder="folders/123")
    ```


    :param builtins.str folder: The folder in which the AutokeyConfig is configured. If it
           is not provided, the provider folder is used.
    """
    __args__ = dict()
    __args__['folder'] = folder
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getAutokeyConfig:getAutokeyConfig', __args__, opts=opts, typ=GetAutokeyConfigResult).value

    return AwaitableGetAutokeyConfigResult(
        etag=pulumi.get(__ret__, 'etag'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        key_project=pulumi.get(__ret__, 'key_project'))
def get_autokey_config_output(folder: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutokeyConfigResult]:
    """
    Provides access to Google Cloud Platform KMS AutokeyConfig. A AutokeyConfig is a Cloud KMS resource that helps you safely span the separation of duties to create new Cloud KMS keys for CMEK using Autokey.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/reference/rest/v1/folders)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyHandles).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_autokey_config = gcp.kms.get_autokey_config(folder="folders/123")
    ```


    :param builtins.str folder: The folder in which the AutokeyConfig is configured. If it
           is not provided, the provider folder is used.
    """
    __args__ = dict()
    __args__['folder'] = folder
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:kms/getAutokeyConfig:getAutokeyConfig', __args__, opts=opts, typ=GetAutokeyConfigResult)
    return __ret__.apply(lambda __response__: GetAutokeyConfigResult(
        etag=pulumi.get(__response__, 'etag'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        key_project=pulumi.get(__response__, 'key_project')))
