# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKeyHandlesResult',
    'AwaitableGetKeyHandlesResult',
    'get_key_handles',
    'get_key_handles_output',
]

@pulumi.output_type
class GetKeyHandlesResult:
    """
    A collection of values returned by getKeyHandles.
    """
    def __init__(__self__, id=None, key_handles=None, location=None, project=None, resource_type_selector=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_handles and not isinstance(key_handles, list):
            raise TypeError("Expected argument 'key_handles' to be a list")
        pulumi.set(__self__, "key_handles", key_handles)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if resource_type_selector and not isinstance(resource_type_selector, str):
            raise TypeError("Expected argument 'resource_type_selector' to be a str")
        pulumi.set(__self__, "resource_type_selector", resource_type_selector)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyHandles")
    def key_handles(self) -> Sequence['outputs.GetKeyHandlesKeyHandleResult']:
        return pulumi.get(self, "key_handles")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location of the KMS Key and KeyHandle.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        """
        The identifier of the project where KMS KeyHandle is created.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="resourceTypeSelector")
    def resource_type_selector(self) -> builtins.str:
        """
        Indicates the resource type that the resulting CryptoKey is meant to protect, e.g. {SERVICE}.googleapis.com/{TYPE}. See documentation for supported resource types.
        """
        return pulumi.get(self, "resource_type_selector")


class AwaitableGetKeyHandlesResult(GetKeyHandlesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyHandlesResult(
            id=self.id,
            key_handles=self.key_handles,
            location=self.location,
            project=self.project,
            resource_type_selector=self.resource_type_selector)


def get_key_handles(location: Optional[builtins.str] = None,
                    project: Optional[builtins.str] = None,
                    resource_type_selector: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyHandlesResult:
    """
    Provides access to Google Cloud Platform KMS KeyHandle. A key handle is a Cloud KMS resource that helps you safely span the separation of duties to create new Cloud KMS keys for CMEK using Autokey.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/resource-hierarchy#key_handles)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyHandles/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_handles = gcp.kms.get_key_handles(project="resource-project-id",
        location="us-central1",
        resource_type_selector="storage.googleapis.com/Bucket")
    ```


    :param builtins.str location: The Google Cloud Platform location for the KeyHandle.
           A full list of valid locations can be found by running `gcloud kms locations list`.
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str resource_type_selector: The resource type by which to filter KeyHandle e.g. {SERVICE}.googleapis.com/{TYPE}. See documentation for supported resource types. 
           
           - - -
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['resourceTypeSelector'] = resource_type_selector
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKeyHandles:getKeyHandles', __args__, opts=opts, typ=GetKeyHandlesResult).value

    return AwaitableGetKeyHandlesResult(
        id=pulumi.get(__ret__, 'id'),
        key_handles=pulumi.get(__ret__, 'key_handles'),
        location=pulumi.get(__ret__, 'location'),
        project=pulumi.get(__ret__, 'project'),
        resource_type_selector=pulumi.get(__ret__, 'resource_type_selector'))
def get_key_handles_output(location: Optional[pulumi.Input[builtins.str]] = None,
                           project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           resource_type_selector: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyHandlesResult]:
    """
    Provides access to Google Cloud Platform KMS KeyHandle. A key handle is a Cloud KMS resource that helps you safely span the separation of duties to create new Cloud KMS keys for CMEK using Autokey.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/resource-hierarchy#key_handles)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyHandles/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_handles = gcp.kms.get_key_handles(project="resource-project-id",
        location="us-central1",
        resource_type_selector="storage.googleapis.com/Bucket")
    ```


    :param builtins.str location: The Google Cloud Platform location for the KeyHandle.
           A full list of valid locations can be found by running `gcloud kms locations list`.
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str resource_type_selector: The resource type by which to filter KeyHandle e.g. {SERVICE}.googleapis.com/{TYPE}. See documentation for supported resource types. 
           
           - - -
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['resourceTypeSelector'] = resource_type_selector
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:kms/getKeyHandles:getKeyHandles', __args__, opts=opts, typ=GetKeyHandlesResult)
    return __ret__.apply(lambda __response__: GetKeyHandlesResult(
        id=pulumi.get(__response__, 'id'),
        key_handles=pulumi.get(__response__, 'key_handles'),
        location=pulumi.get(__response__, 'location'),
        project=pulumi.get(__response__, 'project'),
        resource_type_selector=pulumi.get(__response__, 'resource_type_selector')))
