# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CryptoKeyIAMBindingCondition',
    'CryptoKeyIAMMemberCondition',
    'CryptoKeyKeyAccessJustificationsPolicy',
    'CryptoKeyPrimary',
    'CryptoKeyVersionAttestation',
    'CryptoKeyVersionAttestationCertChains',
    'CryptoKeyVersionAttestationExternalProtectionLevelOptions',
    'CryptoKeyVersionExternalProtectionLevelOptions',
    'CryptoKeyVersionTemplate',
    'EkmConnectionIamBindingCondition',
    'EkmConnectionIamMemberCondition',
    'EkmConnectionServiceResolver',
    'EkmConnectionServiceResolverServerCertificate',
    'KeyRingIAMBindingCondition',
    'KeyRingIAMMemberCondition',
    'KeyRingImportJobAttestation',
    'KeyRingImportJobPublicKey',
    'GetCryptoKeyLatestVersionPublicKeyResult',
    'GetCryptoKeyVersionsPublicKeyResult',
    'GetCryptoKeyVersionsVersionResult',
    'GetCryptoKeyVersionsVersionPublicKeyResult',
    'GetCryptoKeysKeyResult',
    'GetCryptoKeysKeyKeyAccessJustificationsPolicyResult',
    'GetCryptoKeysKeyPrimaryResult',
    'GetCryptoKeysKeyVersionTemplateResult',
    'GetKMSCryptoKeyKeyAccessJustificationsPolicyResult',
    'GetKMSCryptoKeyPrimaryResult',
    'GetKMSCryptoKeyVersionPublicKeyResult',
    'GetKMSCryptoKeyVersionTemplateResult',
    'GetKeyHandlesKeyHandleResult',
    'GetKeyRingsKeyRingResult',
]

@pulumi.output_type
class CryptoKeyIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** The provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** The provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class CryptoKeyIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** The provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** The provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class CryptoKeyKeyAccessJustificationsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAccessReasons":
            suggest = "allowed_access_reasons"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CryptoKeyKeyAccessJustificationsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CryptoKeyKeyAccessJustificationsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CryptoKeyKeyAccessJustificationsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_access_reasons: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] allowed_access_reasons: The list of allowed reasons for access to this CryptoKey. Zero allowed
               access reasons means all encrypt, decrypt, and sign operations for
               this CryptoKey will fail.
        """
        if allowed_access_reasons is not None:
            pulumi.set(__self__, "allowed_access_reasons", allowed_access_reasons)

    @property
    @pulumi.getter(name="allowedAccessReasons")
    def allowed_access_reasons(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of allowed reasons for access to this CryptoKey. Zero allowed
        access reasons means all encrypt, decrypt, and sign operations for
        this CryptoKey will fail.
        """
        return pulumi.get(self, "allowed_access_reasons")


@pulumi.output_type
class CryptoKeyPrimary(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str name: The resource name for the CryptoKey.
        :param builtins.str state: (Output)
               The current state of the CryptoKeyVersion.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The resource name for the CryptoKey.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current state of the CryptoKeyVersion.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class CryptoKeyVersionAttestation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certChains":
            suggest = "cert_chains"
        elif key == "externalProtectionLevelOptions":
            suggest = "external_protection_level_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CryptoKeyVersionAttestation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CryptoKeyVersionAttestation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CryptoKeyVersionAttestation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_chains: Optional['outputs.CryptoKeyVersionAttestationCertChains'] = None,
                 content: Optional[builtins.str] = None,
                 external_protection_level_options: Optional['outputs.CryptoKeyVersionAttestationExternalProtectionLevelOptions'] = None,
                 format: Optional[builtins.str] = None):
        """
        :param 'CryptoKeyVersionAttestationCertChainsArgs' cert_chains: The certificate chains needed to validate the attestation
               Structure is documented below.
        :param builtins.str content: (Output)
               The attestation data provided by the HSM when the key operation was performed.
        :param 'CryptoKeyVersionAttestationExternalProtectionLevelOptionsArgs' external_protection_level_options: ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
               Structure is documented below.
        :param builtins.str format: (Output)
               The format of the attestation data.
        """
        if cert_chains is not None:
            pulumi.set(__self__, "cert_chains", cert_chains)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if external_protection_level_options is not None:
            pulumi.set(__self__, "external_protection_level_options", external_protection_level_options)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter(name="certChains")
    def cert_chains(self) -> Optional['outputs.CryptoKeyVersionAttestationCertChains']:
        """
        The certificate chains needed to validate the attestation
        Structure is documented below.
        """
        return pulumi.get(self, "cert_chains")

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        """
        (Output)
        The attestation data provided by the HSM when the key operation was performed.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="externalProtectionLevelOptions")
    @_utilities.deprecated("""`externalProtectionLevelOptions` is being un-nested from the `attestation` field. Please use the top level `externalProtectionLevelOptions` field instead.""")
    def external_protection_level_options(self) -> Optional['outputs.CryptoKeyVersionAttestationExternalProtectionLevelOptions']:
        """
        ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
        Structure is documented below.
        """
        return pulumi.get(self, "external_protection_level_options")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        (Output)
        The format of the attestation data.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class CryptoKeyVersionAttestationCertChains(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caviumCerts":
            suggest = "cavium_certs"
        elif key == "googleCardCerts":
            suggest = "google_card_certs"
        elif key == "googlePartitionCerts":
            suggest = "google_partition_certs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CryptoKeyVersionAttestationCertChains. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CryptoKeyVersionAttestationCertChains.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CryptoKeyVersionAttestationCertChains.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cavium_certs: Optional[Sequence[builtins.str]] = None,
                 google_card_certs: Optional[Sequence[builtins.str]] = None,
                 google_partition_certs: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] cavium_certs: Cavium certificate chain corresponding to the attestation.
        :param Sequence[builtins.str] google_card_certs: Google card certificate chain corresponding to the attestation.
        :param Sequence[builtins.str] google_partition_certs: Google partition certificate chain corresponding to the attestation.
        """
        if cavium_certs is not None:
            pulumi.set(__self__, "cavium_certs", cavium_certs)
        if google_card_certs is not None:
            pulumi.set(__self__, "google_card_certs", google_card_certs)
        if google_partition_certs is not None:
            pulumi.set(__self__, "google_partition_certs", google_partition_certs)

    @property
    @pulumi.getter(name="caviumCerts")
    def cavium_certs(self) -> Optional[Sequence[builtins.str]]:
        """
        Cavium certificate chain corresponding to the attestation.
        """
        return pulumi.get(self, "cavium_certs")

    @property
    @pulumi.getter(name="googleCardCerts")
    def google_card_certs(self) -> Optional[Sequence[builtins.str]]:
        """
        Google card certificate chain corresponding to the attestation.
        """
        return pulumi.get(self, "google_card_certs")

    @property
    @pulumi.getter(name="googlePartitionCerts")
    def google_partition_certs(self) -> Optional[Sequence[builtins.str]]:
        """
        Google partition certificate chain corresponding to the attestation.
        """
        return pulumi.get(self, "google_partition_certs")


@pulumi.output_type
class CryptoKeyVersionAttestationExternalProtectionLevelOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ekmConnectionKeyPath":
            suggest = "ekm_connection_key_path"
        elif key == "externalKeyUri":
            suggest = "external_key_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CryptoKeyVersionAttestationExternalProtectionLevelOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CryptoKeyVersionAttestationExternalProtectionLevelOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CryptoKeyVersionAttestationExternalProtectionLevelOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ekm_connection_key_path: Optional[builtins.str] = None,
                 external_key_uri: Optional[builtins.str] = None):
        """
        :param builtins.str ekm_connection_key_path: The path to the external key material on the EKM when using EkmConnection e.g., "v0/my/key". Set this field instead of externalKeyUri when using an EkmConnection.
        :param builtins.str external_key_uri: The URI for an external resource that this CryptoKeyVersion represents.
        """
        if ekm_connection_key_path is not None:
            pulumi.set(__self__, "ekm_connection_key_path", ekm_connection_key_path)
        if external_key_uri is not None:
            pulumi.set(__self__, "external_key_uri", external_key_uri)

    @property
    @pulumi.getter(name="ekmConnectionKeyPath")
    def ekm_connection_key_path(self) -> Optional[builtins.str]:
        """
        The path to the external key material on the EKM when using EkmConnection e.g., "v0/my/key". Set this field instead of externalKeyUri when using an EkmConnection.
        """
        return pulumi.get(self, "ekm_connection_key_path")

    @property
    @pulumi.getter(name="externalKeyUri")
    def external_key_uri(self) -> Optional[builtins.str]:
        """
        The URI for an external resource that this CryptoKeyVersion represents.
        """
        return pulumi.get(self, "external_key_uri")


@pulumi.output_type
class CryptoKeyVersionExternalProtectionLevelOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ekmConnectionKeyPath":
            suggest = "ekm_connection_key_path"
        elif key == "externalKeyUri":
            suggest = "external_key_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CryptoKeyVersionExternalProtectionLevelOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CryptoKeyVersionExternalProtectionLevelOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CryptoKeyVersionExternalProtectionLevelOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ekm_connection_key_path: Optional[builtins.str] = None,
                 external_key_uri: Optional[builtins.str] = None):
        """
        :param builtins.str ekm_connection_key_path: The path to the external key material on the EKM when using EkmConnection e.g., "v0/my/key". Set this field instead of externalKeyUri when using an EkmConnection.
        :param builtins.str external_key_uri: The URI for an external resource that this CryptoKeyVersion represents.
        """
        if ekm_connection_key_path is not None:
            pulumi.set(__self__, "ekm_connection_key_path", ekm_connection_key_path)
        if external_key_uri is not None:
            pulumi.set(__self__, "external_key_uri", external_key_uri)

    @property
    @pulumi.getter(name="ekmConnectionKeyPath")
    def ekm_connection_key_path(self) -> Optional[builtins.str]:
        """
        The path to the external key material on the EKM when using EkmConnection e.g., "v0/my/key". Set this field instead of externalKeyUri when using an EkmConnection.
        """
        return pulumi.get(self, "ekm_connection_key_path")

    @property
    @pulumi.getter(name="externalKeyUri")
    def external_key_uri(self) -> Optional[builtins.str]:
        """
        The URI for an external resource that this CryptoKeyVersion represents.
        """
        return pulumi.get(self, "external_key_uri")


@pulumi.output_type
class CryptoKeyVersionTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protectionLevel":
            suggest = "protection_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CryptoKeyVersionTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CryptoKeyVersionTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CryptoKeyVersionTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: builtins.str,
                 protection_level: Optional[builtins.str] = None):
        """
        :param builtins.str algorithm: The algorithm to use when creating a version based on this template.
               See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
        :param builtins.str protection_level: The protection level to use when creating a version based on this template. Possible values include "SOFTWARE", "HSM", "EXTERNAL", "EXTERNAL_VPC". Defaults to "SOFTWARE".
        """
        pulumi.set(__self__, "algorithm", algorithm)
        if protection_level is not None:
            pulumi.set(__self__, "protection_level", protection_level)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        The algorithm to use when creating a version based on this template.
        See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> Optional[builtins.str]:
        """
        The protection level to use when creating a version based on this template. Possible values include "SOFTWARE", "HSM", "EXTERNAL", "EXTERNAL_VPC". Defaults to "SOFTWARE".
        """
        return pulumi.get(self, "protection_level")


@pulumi.output_type
class EkmConnectionIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class EkmConnectionIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class EkmConnectionServiceResolver(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverCertificates":
            suggest = "server_certificates"
        elif key == "serviceDirectoryService":
            suggest = "service_directory_service"
        elif key == "endpointFilter":
            suggest = "endpoint_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EkmConnectionServiceResolver. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EkmConnectionServiceResolver.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EkmConnectionServiceResolver.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: builtins.str,
                 server_certificates: Sequence['outputs.EkmConnectionServiceResolverServerCertificate'],
                 service_directory_service: builtins.str,
                 endpoint_filter: Optional[builtins.str] = None):
        """
        :param builtins.str hostname: Required. The hostname of the EKM replica used at TLS and HTTP layers.
        :param Sequence['EkmConnectionServiceResolverServerCertificateArgs'] server_certificates: Required. A list of leaf server certificates used to authenticate HTTPS connections to the EKM replica. Currently, a maximum of 10 Certificate is supported.
               Structure is documented below.
        :param builtins.str service_directory_service: Required. The resource name of the Service Directory service pointing to an EKM replica, in the format projects/*/locations/*/namespaces/*/services/*
        :param builtins.str endpoint_filter: Optional. The filter applied to the endpoints of the resolved service. If no filter is specified, all endpoints will be considered. An endpoint will be chosen arbitrarily from the filtered list for each request. For endpoint filter syntax and examples, see https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "server_certificates", server_certificates)
        pulumi.set(__self__, "service_directory_service", service_directory_service)
        if endpoint_filter is not None:
            pulumi.set(__self__, "endpoint_filter", endpoint_filter)

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        Required. The hostname of the EKM replica used at TLS and HTTP layers.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="serverCertificates")
    def server_certificates(self) -> Sequence['outputs.EkmConnectionServiceResolverServerCertificate']:
        """
        Required. A list of leaf server certificates used to authenticate HTTPS connections to the EKM replica. Currently, a maximum of 10 Certificate is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "server_certificates")

    @property
    @pulumi.getter(name="serviceDirectoryService")
    def service_directory_service(self) -> builtins.str:
        """
        Required. The resource name of the Service Directory service pointing to an EKM replica, in the format projects/*/locations/*/namespaces/*/services/*
        """
        return pulumi.get(self, "service_directory_service")

    @property
    @pulumi.getter(name="endpointFilter")
    def endpoint_filter(self) -> Optional[builtins.str]:
        """
        Optional. The filter applied to the endpoints of the resolved service. If no filter is specified, all endpoints will be considered. An endpoint will be chosen arbitrarily from the filtered list for each request. For endpoint filter syntax and examples, see https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
        """
        return pulumi.get(self, "endpoint_filter")


@pulumi.output_type
class EkmConnectionServiceResolverServerCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rawDer":
            suggest = "raw_der"
        elif key == "notAfterTime":
            suggest = "not_after_time"
        elif key == "notBeforeTime":
            suggest = "not_before_time"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "sha256Fingerprint":
            suggest = "sha256_fingerprint"
        elif key == "subjectAlternativeDnsNames":
            suggest = "subject_alternative_dns_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EkmConnectionServiceResolverServerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EkmConnectionServiceResolverServerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EkmConnectionServiceResolverServerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 raw_der: builtins.str,
                 issuer: Optional[builtins.str] = None,
                 not_after_time: Optional[builtins.str] = None,
                 not_before_time: Optional[builtins.str] = None,
                 parsed: Optional[builtins.bool] = None,
                 serial_number: Optional[builtins.str] = None,
                 sha256_fingerprint: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 subject_alternative_dns_names: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str raw_der: Required. The raw certificate bytes in DER format. A base64-encoded string.
        :param builtins.str issuer: (Output)
               Output only. The issuer distinguished name in RFC 2253 format. Only present if parsed is true.
        :param builtins.str not_after_time: (Output)
               Output only. The certificate is not valid after this time. Only present if parsed is true.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param builtins.str not_before_time: (Output)
               Output only. The certificate is not valid before this time. Only present if parsed is true.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param builtins.bool parsed: (Output)
               Output only. True if the certificate was parsed successfully.
        :param builtins.str serial_number: (Output)
               Output only. The certificate serial number as a hex string. Only present if parsed is true.
        :param builtins.str sha256_fingerprint: (Output)
               Output only. The SHA-256 certificate fingerprint as a hex string. Only present if parsed is true.
        :param builtins.str subject: (Output)
               Output only. The subject distinguished name in RFC 2253 format. Only present if parsed is true.
        :param Sequence[builtins.str] subject_alternative_dns_names: (Output)
               Output only. The subject Alternative DNS names. Only present if parsed is true.
        """
        pulumi.set(__self__, "raw_der", raw_der)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if not_after_time is not None:
            pulumi.set(__self__, "not_after_time", not_after_time)
        if not_before_time is not None:
            pulumi.set(__self__, "not_before_time", not_before_time)
        if parsed is not None:
            pulumi.set(__self__, "parsed", parsed)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if sha256_fingerprint is not None:
            pulumi.set(__self__, "sha256_fingerprint", sha256_fingerprint)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if subject_alternative_dns_names is not None:
            pulumi.set(__self__, "subject_alternative_dns_names", subject_alternative_dns_names)

    @property
    @pulumi.getter(name="rawDer")
    def raw_der(self) -> builtins.str:
        """
        Required. The raw certificate bytes in DER format. A base64-encoded string.
        """
        return pulumi.get(self, "raw_der")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The issuer distinguished name in RFC 2253 format. Only present if parsed is true.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="notAfterTime")
    def not_after_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The certificate is not valid after this time. Only present if parsed is true.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "not_after_time")

    @property
    @pulumi.getter(name="notBeforeTime")
    def not_before_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The certificate is not valid before this time. Only present if parsed is true.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "not_before_time")

    @property
    @pulumi.getter
    def parsed(self) -> Optional[builtins.bool]:
        """
        (Output)
        Output only. True if the certificate was parsed successfully.
        """
        return pulumi.get(self, "parsed")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The certificate serial number as a hex string. Only present if parsed is true.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="sha256Fingerprint")
    def sha256_fingerprint(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The SHA-256 certificate fingerprint as a hex string. Only present if parsed is true.
        """
        return pulumi.get(self, "sha256_fingerprint")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The subject distinguished name in RFC 2253 format. Only present if parsed is true.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAlternativeDnsNames")
    def subject_alternative_dns_names(self) -> Optional[Sequence[builtins.str]]:
        """
        (Output)
        Output only. The subject Alternative DNS names. Only present if parsed is true.
        """
        return pulumi.get(self, "subject_alternative_dns_names")


@pulumi.output_type
class KeyRingIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** The provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** The provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class KeyRingIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** The provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** The provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class KeyRingImportJobAttestation(dict):
    def __init__(__self__, *,
                 content: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None):
        """
        :param builtins.str content: (Output)
               The attestation data provided by the HSM when the key operation was performed.
               A base64-encoded string.
        :param builtins.str format: (Output)
               The format of the attestation data.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        """
        (Output)
        The attestation data provided by the HSM when the key operation was performed.
        A base64-encoded string.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        (Output)
        The format of the attestation data.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class KeyRingImportJobPublicKey(dict):
    def __init__(__self__, *,
                 pem: Optional[builtins.str] = None):
        """
        :param builtins.str pem: (Output)
               The public key, encoded in PEM format. For more information, see the RFC 7468 sections
               for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        if pem is not None:
            pulumi.set(__self__, "pem", pem)

    @property
    @pulumi.getter
    def pem(self) -> Optional[builtins.str]:
        """
        (Output)
        The public key, encoded in PEM format. For more information, see the RFC 7468 sections
        for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        return pulumi.get(self, "pem")


@pulumi.output_type
class GetCryptoKeyLatestVersionPublicKeyResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 pem: builtins.str):
        """
        :param builtins.str algorithm: The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        :param builtins.str pem: The public key, encoded in PEM format. For more information, see the RFC 7468 sections for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "pem", pem)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def pem(self) -> builtins.str:
        """
        The public key, encoded in PEM format. For more information, see the RFC 7468 sections for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        return pulumi.get(self, "pem")


@pulumi.output_type
class GetCryptoKeyVersionsPublicKeyResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 pem: builtins.str):
        """
        :param builtins.str algorithm: The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        :param builtins.str pem: The public key, encoded in PEM format. For more information, see the RFC 7468 sections for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "pem", pem)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def pem(self) -> builtins.str:
        """
        The public key, encoded in PEM format. For more information, see the RFC 7468 sections for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        return pulumi.get(self, "pem")


@pulumi.output_type
class GetCryptoKeyVersionsVersionResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 crypto_key: builtins.str,
                 id: builtins.str,
                 name: builtins.str,
                 protection_level: builtins.str,
                 public_keys: Sequence['outputs.GetCryptoKeyVersionsVersionPublicKeyResult'],
                 state: builtins.str,
                 version: builtins.int):
        """
        :param builtins.str algorithm: The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        :param builtins.str crypto_key: The `id` of the Google Cloud Platform CryptoKey to which the key version belongs. This is also the `id` field of the 
               `kms.CryptoKey` resource/datasource.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "crypto_key", crypto_key)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protection_level", protection_level)
        pulumi.set(__self__, "public_keys", public_keys)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> builtins.str:
        """
        The `id` of the Google Cloud Platform CryptoKey to which the key version belongs. This is also the `id` field of the 
        `kms.CryptoKey` resource/datasource.
        """
        return pulumi.get(self, "crypto_key")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> builtins.str:
        return pulumi.get(self, "protection_level")

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Sequence['outputs.GetCryptoKeyVersionsVersionPublicKeyResult']:
        return pulumi.get(self, "public_keys")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetCryptoKeyVersionsVersionPublicKeyResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 pem: builtins.str):
        """
        :param builtins.str algorithm: The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        :param builtins.str pem: The public key, encoded in PEM format. For more information, see the RFC 7468 sections for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "pem", pem)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def pem(self) -> builtins.str:
        """
        The public key, encoded in PEM format. For more information, see the RFC 7468 sections for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        return pulumi.get(self, "pem")


@pulumi.output_type
class GetCryptoKeysKeyResult(dict):
    def __init__(__self__, *,
                 crypto_key_backend: builtins.str,
                 destroy_scheduled_duration: builtins.str,
                 effective_labels: Mapping[str, builtins.str],
                 id: builtins.str,
                 import_only: builtins.bool,
                 key_access_justifications_policies: Sequence['outputs.GetCryptoKeysKeyKeyAccessJustificationsPolicyResult'],
                 labels: Mapping[str, builtins.str],
                 primaries: Sequence['outputs.GetCryptoKeysKeyPrimaryResult'],
                 pulumi_labels: Mapping[str, builtins.str],
                 purpose: builtins.str,
                 rotation_period: builtins.str,
                 skip_initial_version_creation: builtins.bool,
                 version_templates: Sequence['outputs.GetCryptoKeysKeyVersionTemplateResult'],
                 key_ring: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str crypto_key_backend: The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
               The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        :param builtins.str destroy_scheduled_duration: The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
               If not specified at creation time, the default duration is 30 days.
        :param builtins.bool import_only: Whether this key may contain imported versions only.
        :param Sequence['GetCryptoKeysKeyKeyAccessJustificationsPolicyArgs'] key_access_justifications_policies: The policy used for Key Access Justifications Policy Enforcement. If this
               field is present and this key is enrolled in Key Access Justifications
               Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
               sign operations, and the operation will fail if rejected by the policy. The
               policy is defined by specifying zero or more allowed justification codes.
               https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
               By default, this field is absent, and all justification codes are allowed.
               This field is currently in beta and is subject to change.
        :param Mapping[str, builtins.str] labels: Labels with user-defined metadata to apply to this resource.
               
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param Sequence['GetCryptoKeysKeyPrimaryArgs'] primaries: A copy of the primary CryptoKeyVersion that will be used by cryptoKeys.encrypt when this CryptoKey is given in EncryptRequest.name.
               Keys with purpose ENCRYPT_DECRYPT may have a primary. For other keys, this field will be unset.
        :param Mapping[str, builtins.str] pulumi_labels: The combination of labels configured directly on the resource
                and default labels configured on the provider.
        :param builtins.str purpose: The immutable purpose of this CryptoKey. See the
               [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
               for possible inputs.
               Default value is "ENCRYPT_DECRYPT".
        :param builtins.str rotation_period: Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
               The first rotation will take place after the specified period. The rotation period has
               the format of a decimal number with up to 9 fractional digits, followed by the
               letter 's' (seconds). It must be greater than a day (ie, 86400).
        :param builtins.bool skip_initial_version_creation: If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
               You must use the 'google_kms_crypto_key_version' resource to create a new CryptoKeyVersion
               or 'google_kms_key_ring_import_job' resource to import the CryptoKeyVersion.
        :param Sequence['GetCryptoKeysKeyVersionTemplateArgs'] version_templates: A template describing settings for new crypto key versions.
        :param builtins.str key_ring: The key ring that the keys belongs to. Format: 'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'.,
        :param builtins.str name: The resource name for the CryptoKey.
        """
        pulumi.set(__self__, "crypto_key_backend", crypto_key_backend)
        pulumi.set(__self__, "destroy_scheduled_duration", destroy_scheduled_duration)
        pulumi.set(__self__, "effective_labels", effective_labels)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "import_only", import_only)
        pulumi.set(__self__, "key_access_justifications_policies", key_access_justifications_policies)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "primaries", primaries)
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        pulumi.set(__self__, "purpose", purpose)
        pulumi.set(__self__, "rotation_period", rotation_period)
        pulumi.set(__self__, "skip_initial_version_creation", skip_initial_version_creation)
        pulumi.set(__self__, "version_templates", version_templates)
        if key_ring is not None:
            pulumi.set(__self__, "key_ring", key_ring)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cryptoKeyBackend")
    def crypto_key_backend(self) -> builtins.str:
        """
        The resource name of the backend environment associated with all CryptoKeyVersions within this CryptoKey.
        The resource name is in the format "projects/*/locations/*/ekmConnections/*" and only applies to "EXTERNAL_VPC" keys.
        """
        return pulumi.get(self, "crypto_key_backend")

    @property
    @pulumi.getter(name="destroyScheduledDuration")
    def destroy_scheduled_duration(self) -> builtins.str:
        """
        The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
        If not specified at creation time, the default duration is 30 days.
        """
        return pulumi.get(self, "destroy_scheduled_duration")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="importOnly")
    def import_only(self) -> builtins.bool:
        """
        Whether this key may contain imported versions only.
        """
        return pulumi.get(self, "import_only")

    @property
    @pulumi.getter(name="keyAccessJustificationsPolicies")
    def key_access_justifications_policies(self) -> Sequence['outputs.GetCryptoKeysKeyKeyAccessJustificationsPolicyResult']:
        """
        The policy used for Key Access Justifications Policy Enforcement. If this
        field is present and this key is enrolled in Key Access Justifications
        Policy Enforcement, the policy will be evaluated in encrypt, decrypt, and
        sign operations, and the operation will fail if rejected by the policy. The
        policy is defined by specifying zero or more allowed justification codes.
        https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
        By default, this field is absent, and all justification codes are allowed.
        This field is currently in beta and is subject to change.
        """
        return pulumi.get(self, "key_access_justifications_policies")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        """
        Labels with user-defined metadata to apply to this resource.


        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def primaries(self) -> Sequence['outputs.GetCryptoKeysKeyPrimaryResult']:
        """
        A copy of the primary CryptoKeyVersion that will be used by cryptoKeys.encrypt when this CryptoKey is given in EncryptRequest.name.
        Keys with purpose ENCRYPT_DECRYPT may have a primary. For other keys, this field will be unset.
        """
        return pulumi.get(self, "primaries")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        """
        The combination of labels configured directly on the resource
         and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def purpose(self) -> builtins.str:
        """
        The immutable purpose of this CryptoKey. See the
        [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
        for possible inputs.
        Default value is "ENCRYPT_DECRYPT".
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> builtins.str:
        """
        Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
        The first rotation will take place after the specified period. The rotation period has
        the format of a decimal number with up to 9 fractional digits, followed by the
        letter 's' (seconds). It must be greater than a day (ie, 86400).
        """
        return pulumi.get(self, "rotation_period")

    @property
    @pulumi.getter(name="skipInitialVersionCreation")
    def skip_initial_version_creation(self) -> builtins.bool:
        """
        If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
        You must use the 'google_kms_crypto_key_version' resource to create a new CryptoKeyVersion
        or 'google_kms_key_ring_import_job' resource to import the CryptoKeyVersion.
        """
        return pulumi.get(self, "skip_initial_version_creation")

    @property
    @pulumi.getter(name="versionTemplates")
    def version_templates(self) -> Sequence['outputs.GetCryptoKeysKeyVersionTemplateResult']:
        """
        A template describing settings for new crypto key versions.
        """
        return pulumi.get(self, "version_templates")

    @property
    @pulumi.getter(name="keyRing")
    def key_ring(self) -> Optional[builtins.str]:
        """
        The key ring that the keys belongs to. Format: 'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'.,
        """
        return pulumi.get(self, "key_ring")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The resource name for the CryptoKey.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCryptoKeysKeyKeyAccessJustificationsPolicyResult(dict):
    def __init__(__self__, *,
                 allowed_access_reasons: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] allowed_access_reasons: The list of allowed reasons for access to this CryptoKey. Zero allowed
               access reasons means all encrypt, decrypt, and sign operations for
               this CryptoKey will fail.
        """
        pulumi.set(__self__, "allowed_access_reasons", allowed_access_reasons)

    @property
    @pulumi.getter(name="allowedAccessReasons")
    def allowed_access_reasons(self) -> Sequence[builtins.str]:
        """
        The list of allowed reasons for access to this CryptoKey. Zero allowed
        access reasons means all encrypt, decrypt, and sign operations for
        this CryptoKey will fail.
        """
        return pulumi.get(self, "allowed_access_reasons")


@pulumi.output_type
class GetCryptoKeysKeyPrimaryResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str name: The resource name for this CryptoKeyVersion.
        :param builtins.str state: The current state of the CryptoKeyVersion.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The resource name for this CryptoKeyVersion.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the CryptoKeyVersion.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetCryptoKeysKeyVersionTemplateResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 protection_level: builtins.str):
        """
        :param builtins.str algorithm: The algorithm to use when creating a version based on this template.
               See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
        :param builtins.str protection_level: The protection level to use when creating a version based on this template. Possible values include "SOFTWARE", "HSM", "EXTERNAL", "EXTERNAL_VPC". Defaults to "SOFTWARE".
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "protection_level", protection_level)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        The algorithm to use when creating a version based on this template.
        See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> builtins.str:
        """
        The protection level to use when creating a version based on this template. Possible values include "SOFTWARE", "HSM", "EXTERNAL", "EXTERNAL_VPC". Defaults to "SOFTWARE".
        """
        return pulumi.get(self, "protection_level")


@pulumi.output_type
class GetKMSCryptoKeyKeyAccessJustificationsPolicyResult(dict):
    def __init__(__self__, *,
                 allowed_access_reasons: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] allowed_access_reasons: The list of allowed reasons for access to this CryptoKey. Zero allowed
               access reasons means all encrypt, decrypt, and sign operations for
               this CryptoKey will fail.
        """
        pulumi.set(__self__, "allowed_access_reasons", allowed_access_reasons)

    @property
    @pulumi.getter(name="allowedAccessReasons")
    def allowed_access_reasons(self) -> Sequence[builtins.str]:
        """
        The list of allowed reasons for access to this CryptoKey. Zero allowed
        access reasons means all encrypt, decrypt, and sign operations for
        this CryptoKey will fail.
        """
        return pulumi.get(self, "allowed_access_reasons")


@pulumi.output_type
class GetKMSCryptoKeyPrimaryResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str name: The CryptoKey's name.
               A CryptoKey’s name belonging to the specified Google Cloud Platform KeyRing and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        :param builtins.str state: The current state of the CryptoKeyVersion.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The CryptoKey's name.
        A CryptoKey’s name belonging to the specified Google Cloud Platform KeyRing and match the regular expression `[a-zA-Z0-9_-]{1,63}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the CryptoKeyVersion.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetKMSCryptoKeyVersionPublicKeyResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 pem: builtins.str):
        """
        :param builtins.str algorithm: The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        :param builtins.str pem: The public key, encoded in PEM format. For more information, see the RFC 7468 sections for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "pem", pem)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def pem(self) -> builtins.str:
        """
        The public key, encoded in PEM format. For more information, see the RFC 7468 sections for General Considerations and Textual Encoding of Subject Public Key Info.
        """
        return pulumi.get(self, "pem")


@pulumi.output_type
class GetKMSCryptoKeyVersionTemplateResult(dict):
    def __init__(__self__, *,
                 algorithm: builtins.str,
                 protection_level: builtins.str):
        """
        :param builtins.str algorithm: The algorithm to use when creating a version based on this template.
               See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
        :param builtins.str protection_level: The protection level to use when creating a version based on this template. Possible values include "SOFTWARE", "HSM", "EXTERNAL", "EXTERNAL_VPC". Defaults to "SOFTWARE".
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "protection_level", protection_level)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        The algorithm to use when creating a version based on this template.
        See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> builtins.str:
        """
        The protection level to use when creating a version based on this template. Possible values include "SOFTWARE", "HSM", "EXTERNAL", "EXTERNAL_VPC". Defaults to "SOFTWARE".
        """
        return pulumi.get(self, "protection_level")


@pulumi.output_type
class GetKeyHandlesKeyHandleResult(dict):
    def __init__(__self__, *,
                 kms_key: builtins.str,
                 name: builtins.str,
                 resource_type_selector: builtins.str):
        """
        :param builtins.str kms_key: The identifier of the KMS Key created for the KeyHandle. Its format is `projects/{projectId}/locations/{location}/keyRings/{keyRingName}/cryptoKeys/{cryptoKeyName}`.
        :param builtins.str name: The name of the KeyHandle. Its format is `projects/{projectId}/locations/{location}/keyHandles/{keyHandleName}`.
        :param builtins.str resource_type_selector: The resource type by which to filter KeyHandle e.g. {SERVICE}.googleapis.com/{TYPE}. See documentation for supported resource types. 
               
               - - -
        """
        pulumi.set(__self__, "kms_key", kms_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_type_selector", resource_type_selector)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> builtins.str:
        """
        The identifier of the KMS Key created for the KeyHandle. Its format is `projects/{projectId}/locations/{location}/keyRings/{keyRingName}/cryptoKeys/{cryptoKeyName}`.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the KeyHandle. Its format is `projects/{projectId}/locations/{location}/keyHandles/{keyHandleName}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceTypeSelector")
    def resource_type_selector(self) -> builtins.str:
        """
        The resource type by which to filter KeyHandle e.g. {SERVICE}.googleapis.com/{TYPE}. See documentation for supported resource types. 

        - - -
        """
        return pulumi.get(self, "resource_type_selector")


@pulumi.output_type
class GetKeyRingsKeyRingResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


