# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorArgs', 'Connector']

@pulumi.input_type
class ConnectorArgs:
    def __init__(__self__, *,
                 connect_cluster: pulumi.Input[builtins.str],
                 connector_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 task_restart_policy: Optional[pulumi.Input['ConnectorTaskRestartPolicyArgs']] = None):
        """
        The set of arguments for constructing a Connector resource.
        :param pulumi.Input[builtins.str] connect_cluster: The connect cluster name.
        :param pulumi.Input[builtins.str] connector_id: The ID to use for the connector, which will become the final component of the connector's name. This value is structured like: `my-connector-id`.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] configs: Connector config as keys/values. The keys of the map are connector property names, for example: `connector.class`, `tasks.max`, `key.converter`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ConnectorTaskRestartPolicyArgs'] task_restart_policy: A policy that specifies how to restart the failed connectors/tasks in a Cluster resource. If not set, the failed connectors/tasks won't be restarted.
               Structure is documented below.
        """
        pulumi.set(__self__, "connect_cluster", connect_cluster)
        pulumi.set(__self__, "connector_id", connector_id)
        pulumi.set(__self__, "location", location)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if task_restart_policy is not None:
            pulumi.set(__self__, "task_restart_policy", task_restart_policy)

    @property
    @pulumi.getter(name="connectCluster")
    def connect_cluster(self) -> pulumi.Input[builtins.str]:
        """
        The connect cluster name.
        """
        return pulumi.get(self, "connect_cluster")

    @connect_cluster.setter
    def connect_cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connect_cluster", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the connector, which will become the final component of the connector's name. This value is structured like: `my-connector-id`.
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Connector config as keys/values. The keys of the map are connector property names, for example: `connector.class`, `tasks.max`, `key.converter`.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="taskRestartPolicy")
    def task_restart_policy(self) -> Optional[pulumi.Input['ConnectorTaskRestartPolicyArgs']]:
        """
        A policy that specifies how to restart the failed connectors/tasks in a Cluster resource. If not set, the failed connectors/tasks won't be restarted.
        Structure is documented below.
        """
        return pulumi.get(self, "task_restart_policy")

    @task_restart_policy.setter
    def task_restart_policy(self, value: Optional[pulumi.Input['ConnectorTaskRestartPolicyArgs']]):
        pulumi.set(self, "task_restart_policy", value)


@pulumi.input_type
class _ConnectorState:
    def __init__(__self__, *,
                 configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 connect_cluster: Optional[pulumi.Input[builtins.str]] = None,
                 connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 task_restart_policy: Optional[pulumi.Input['ConnectorTaskRestartPolicyArgs']] = None):
        """
        Input properties used for looking up and filtering Connector resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] configs: Connector config as keys/values. The keys of the map are connector property names, for example: `connector.class`, `tasks.max`, `key.converter`.
        :param pulumi.Input[builtins.str] connect_cluster: The connect cluster name.
        :param pulumi.Input[builtins.str] connector_id: The ID to use for the connector, which will become the final component of the connector's name. This value is structured like: `my-connector-id`.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[builtins.str] name: The name of the connector. The `connector` segment is used when connecting directly to the connect cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/connectClusters/CONNECT_CLUSTER/connectors/CONNECTOR_ID`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: The current state of the connect. Possible values: `STATE_UNSPECIFIED`, `UNASSIGNED`, `RUNNING`, `PAUSED`, `FAILED`, `RESTARTING`, and `STOPPED`.
        :param pulumi.Input['ConnectorTaskRestartPolicyArgs'] task_restart_policy: A policy that specifies how to restart the failed connectors/tasks in a Cluster resource. If not set, the failed connectors/tasks won't be restarted.
               Structure is documented below.
        """
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if connect_cluster is not None:
            pulumi.set(__self__, "connect_cluster", connect_cluster)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if task_restart_policy is not None:
            pulumi.set(__self__, "task_restart_policy", task_restart_policy)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Connector config as keys/values. The keys of the map are connector property names, for example: `connector.class`, `tasks.max`, `key.converter`.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter(name="connectCluster")
    def connect_cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connect cluster name.
        """
        return pulumi.get(self, "connect_cluster")

    @connect_cluster.setter
    def connect_cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connect_cluster", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the connector, which will become the final component of the connector's name. This value is structured like: `my-connector-id`.
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the connector. The `connector` segment is used when connecting directly to the connect cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/connectClusters/CONNECT_CLUSTER/connectors/CONNECTOR_ID`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the connect. Possible values: `STATE_UNSPECIFIED`, `UNASSIGNED`, `RUNNING`, `PAUSED`, `FAILED`, `RESTARTING`, and `STOPPED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="taskRestartPolicy")
    def task_restart_policy(self) -> Optional[pulumi.Input['ConnectorTaskRestartPolicyArgs']]:
        """
        A policy that specifies how to restart the failed connectors/tasks in a Cluster resource. If not set, the failed connectors/tasks won't be restarted.
        Structure is documented below.
        """
        return pulumi.get(self, "task_restart_policy")

    @task_restart_policy.setter
    def task_restart_policy(self, value: Optional[pulumi.Input['ConnectorTaskRestartPolicyArgs']]):
        pulumi.set(self, "task_restart_policy", value)


@pulumi.type_token("gcp:managedkafka/connector:Connector")
class Connector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 connect_cluster: Optional[pulumi.Input[builtins.str]] = None,
                 connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 task_restart_policy: Optional[pulumi.Input[Union['ConnectorTaskRestartPolicyArgs', 'ConnectorTaskRestartPolicyArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Managedkafka Connector Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="tf-test_32706",
            name="tf-test_49082",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[project]))
        compute = gcp.projects.Service("compute",
            project=project.project_id,
            service="compute.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        managedkafka = gcp.projects.Service("managedkafka",
            project=project.project_id,
            service="managedkafka.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[compute]))
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        mkc_secondary_subnet = gcp.compute.Subnetwork("mkc_secondary_subnet",
            project=project.project_id,
            name="my-secondary-subnetwork-00",
            ip_cidr_range="10.5.0.0/16",
            region="us-central1",
            network="default",
            opts = pulumi.ResourceOptions(depends_on=[wait120_seconds]))
        cps_topic = gcp.pubsub.Topic("cps_topic",
            project=project.project_id,
            name="my-cps-topic",
            message_retention_duration="86600s")
        gmk_cluster = gcp.managedkafka.Cluster("gmk_cluster",
            project=project.project_id,
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": project.project_id.apply(lambda project_id: f"projects/{project_id}/regions/us-central1/subnetworks/default"),
                    }],
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        gmk_topic = gcp.managedkafka.Topic("gmk_topic",
            project=project.project_id,
            topic_id="my-topic",
            cluster=gmk_cluster.cluster_id,
            location="us-central1",
            partition_count=2,
            replication_factor=3,
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        mkc_cluster = gcp.managedkafka.ConnectCluster("mkc_cluster",
            project=project.project_id,
            connect_cluster_id="my-connect-cluster",
            kafka_cluster=pulumi.Output.all(
                project_id=project.project_id,
                cluster_id=gmk_cluster.cluster_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project_id']}/locations/us-central1/clusters/{resolved_outputs['cluster_id']}")
        ,
            location="us-central1",
            capacity_config={
                "vcpu_count": "12",
                "memory_bytes": "21474836480",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "primary_subnet": project.project_id.apply(lambda project_id: f"projects/{project_id}/regions/us-central1/subnetworks/default"),
                        "additional_subnets": [mkc_secondary_subnet.id],
                        "dns_domain_names": [pulumi.Output.all(
                            cluster_id=gmk_cluster.cluster_id,
                            project_id=project.project_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['cluster_id']}.us-central1.managedkafka.{resolved_outputs['project_id']}.cloud.goog")
        ],
                    }],
                },
            },
            labels={
                "key": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        example = gcp.managedkafka.Connector("example",
            project=project.project_id,
            connector_id="my-connector",
            connect_cluster=mkc_cluster.connect_cluster_id,
            location="us-central1",
            configs={
                "connector.class": "com.google.pubsub.kafka.sink.CloudPubSubSinkConnector",
                "name": "my-connector",
                "tasks.max": "1",
                "topics": gmk_topic.topic_id,
                "cps.topic": cps_topic.name,
                "cps.project": project.project_id,
                "value.converter": "org.apache.kafka.connect.storage.StringConverter",
                "key.converter": "org.apache.kafka.connect.storage.StringConverter",
            },
            task_restart_policy={
                "minimum_backoff": "60s",
                "maximum_backoff": "1800s",
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        ```

        ## Import

        Connector can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connectClusters/{{connect_cluster}}/connectors/{{connector_id}}`

        * `{{project}}/{{location}}/{{connect_cluster}}/{{connector_id}}`

        * `{{location}}/{{connect_cluster}}/{{connector_id}}`

        When using the `pulumi import` command, Connector can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:managedkafka/connector:Connector default projects/{{project}}/locations/{{location}}/connectClusters/{{connect_cluster}}/connectors/{{connector_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/connector:Connector default {{project}}/{{location}}/{{connect_cluster}}/{{connector_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/connector:Connector default {{location}}/{{connect_cluster}}/{{connector_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] configs: Connector config as keys/values. The keys of the map are connector property names, for example: `connector.class`, `tasks.max`, `key.converter`.
        :param pulumi.Input[builtins.str] connect_cluster: The connect cluster name.
        :param pulumi.Input[builtins.str] connector_id: The ID to use for the connector, which will become the final component of the connector's name. This value is structured like: `my-connector-id`.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ConnectorTaskRestartPolicyArgs', 'ConnectorTaskRestartPolicyArgsDict']] task_restart_policy: A policy that specifies how to restart the failed connectors/tasks in a Cluster resource. If not set, the failed connectors/tasks won't be restarted.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Managedkafka Connector Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="tf-test_32706",
            name="tf-test_49082",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[project]))
        compute = gcp.projects.Service("compute",
            project=project.project_id,
            service="compute.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        managedkafka = gcp.projects.Service("managedkafka",
            project=project.project_id,
            service="managedkafka.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[compute]))
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        mkc_secondary_subnet = gcp.compute.Subnetwork("mkc_secondary_subnet",
            project=project.project_id,
            name="my-secondary-subnetwork-00",
            ip_cidr_range="10.5.0.0/16",
            region="us-central1",
            network="default",
            opts = pulumi.ResourceOptions(depends_on=[wait120_seconds]))
        cps_topic = gcp.pubsub.Topic("cps_topic",
            project=project.project_id,
            name="my-cps-topic",
            message_retention_duration="86600s")
        gmk_cluster = gcp.managedkafka.Cluster("gmk_cluster",
            project=project.project_id,
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": project.project_id.apply(lambda project_id: f"projects/{project_id}/regions/us-central1/subnetworks/default"),
                    }],
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        gmk_topic = gcp.managedkafka.Topic("gmk_topic",
            project=project.project_id,
            topic_id="my-topic",
            cluster=gmk_cluster.cluster_id,
            location="us-central1",
            partition_count=2,
            replication_factor=3,
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        mkc_cluster = gcp.managedkafka.ConnectCluster("mkc_cluster",
            project=project.project_id,
            connect_cluster_id="my-connect-cluster",
            kafka_cluster=pulumi.Output.all(
                project_id=project.project_id,
                cluster_id=gmk_cluster.cluster_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project_id']}/locations/us-central1/clusters/{resolved_outputs['cluster_id']}")
        ,
            location="us-central1",
            capacity_config={
                "vcpu_count": "12",
                "memory_bytes": "21474836480",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "primary_subnet": project.project_id.apply(lambda project_id: f"projects/{project_id}/regions/us-central1/subnetworks/default"),
                        "additional_subnets": [mkc_secondary_subnet.id],
                        "dns_domain_names": [pulumi.Output.all(
                            cluster_id=gmk_cluster.cluster_id,
                            project_id=project.project_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['cluster_id']}.us-central1.managedkafka.{resolved_outputs['project_id']}.cloud.goog")
        ],
                    }],
                },
            },
            labels={
                "key": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        example = gcp.managedkafka.Connector("example",
            project=project.project_id,
            connector_id="my-connector",
            connect_cluster=mkc_cluster.connect_cluster_id,
            location="us-central1",
            configs={
                "connector.class": "com.google.pubsub.kafka.sink.CloudPubSubSinkConnector",
                "name": "my-connector",
                "tasks.max": "1",
                "topics": gmk_topic.topic_id,
                "cps.topic": cps_topic.name,
                "cps.project": project.project_id,
                "value.converter": "org.apache.kafka.connect.storage.StringConverter",
                "key.converter": "org.apache.kafka.connect.storage.StringConverter",
            },
            task_restart_policy={
                "minimum_backoff": "60s",
                "maximum_backoff": "1800s",
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        ```

        ## Import

        Connector can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connectClusters/{{connect_cluster}}/connectors/{{connector_id}}`

        * `{{project}}/{{location}}/{{connect_cluster}}/{{connector_id}}`

        * `{{location}}/{{connect_cluster}}/{{connector_id}}`

        When using the `pulumi import` command, Connector can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:managedkafka/connector:Connector default projects/{{project}}/locations/{{location}}/connectClusters/{{connect_cluster}}/connectors/{{connector_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/connector:Connector default {{project}}/{{location}}/{{connect_cluster}}/{{connector_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/connector:Connector default {{location}}/{{connect_cluster}}/{{connector_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 connect_cluster: Optional[pulumi.Input[builtins.str]] = None,
                 connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 task_restart_policy: Optional[pulumi.Input[Union['ConnectorTaskRestartPolicyArgs', 'ConnectorTaskRestartPolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorArgs.__new__(ConnectorArgs)

            __props__.__dict__["configs"] = configs
            if connect_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'connect_cluster'")
            __props__.__dict__["connect_cluster"] = connect_cluster
            if connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'connector_id'")
            __props__.__dict__["connector_id"] = connector_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["task_restart_policy"] = task_restart_policy
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(Connector, __self__).__init__(
            'gcp:managedkafka/connector:Connector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            connect_cluster: Optional[pulumi.Input[builtins.str]] = None,
            connector_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            task_restart_policy: Optional[pulumi.Input[Union['ConnectorTaskRestartPolicyArgs', 'ConnectorTaskRestartPolicyArgsDict']]] = None) -> 'Connector':
        """
        Get an existing Connector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] configs: Connector config as keys/values. The keys of the map are connector property names, for example: `connector.class`, `tasks.max`, `key.converter`.
        :param pulumi.Input[builtins.str] connect_cluster: The connect cluster name.
        :param pulumi.Input[builtins.str] connector_id: The ID to use for the connector, which will become the final component of the connector's name. This value is structured like: `my-connector-id`.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[builtins.str] name: The name of the connector. The `connector` segment is used when connecting directly to the connect cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/connectClusters/CONNECT_CLUSTER/connectors/CONNECTOR_ID`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: The current state of the connect. Possible values: `STATE_UNSPECIFIED`, `UNASSIGNED`, `RUNNING`, `PAUSED`, `FAILED`, `RESTARTING`, and `STOPPED`.
        :param pulumi.Input[Union['ConnectorTaskRestartPolicyArgs', 'ConnectorTaskRestartPolicyArgsDict']] task_restart_policy: A policy that specifies how to restart the failed connectors/tasks in a Cluster resource. If not set, the failed connectors/tasks won't be restarted.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorState.__new__(_ConnectorState)

        __props__.__dict__["configs"] = configs
        __props__.__dict__["connect_cluster"] = connect_cluster
        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["task_restart_policy"] = task_restart_policy
        return Connector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Connector config as keys/values. The keys of the map are connector property names, for example: `connector.class`, `tasks.max`, `key.converter`.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter(name="connectCluster")
    def connect_cluster(self) -> pulumi.Output[builtins.str]:
        """
        The connect cluster name.
        """
        return pulumi.get(self, "connect_cluster")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the connector, which will become the final component of the connector's name. This value is structured like: `my-connector-id`.
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the connector. The `connector` segment is used when connecting directly to the connect cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/connectClusters/CONNECT_CLUSTER/connectors/CONNECTOR_ID`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the connect. Possible values: `STATE_UNSPECIFIED`, `UNASSIGNED`, `RUNNING`, `PAUSED`, `FAILED`, `RESTARTING`, and `STOPPED`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskRestartPolicy")
    def task_restart_policy(self) -> pulumi.Output[Optional['outputs.ConnectorTaskRestartPolicy']]:
        """
        A policy that specifies how to restart the failed connectors/tasks in a Cluster resource. If not set, the failed connectors/tasks won't be restarted.
        Structure is documented below.
        """
        return pulumi.get(self, "task_restart_policy")

