# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceMaintenancePolicyArgs',
    'InstanceMaintenancePolicyArgsDict',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowArgsDict',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict',
    'InstanceMaintenanceScheduleArgs',
    'InstanceMaintenanceScheduleArgsDict',
    'InstanceMemcacheNodeArgs',
    'InstanceMemcacheNodeArgsDict',
    'InstanceMemcacheParametersArgs',
    'InstanceMemcacheParametersArgsDict',
    'InstanceNodeConfigArgs',
    'InstanceNodeConfigArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceMaintenancePolicyArgsDict(TypedDict):
        weekly_maintenance_windows: pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgsDict']]]
        """
        Required. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number of weekly_maintenance_windows
        is expected to be one.
        Structure is documented below.
        """
        create_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        Optional. Description of what this policy is for.
        Create/Update methods return INVALID_ARGUMENT if the
        length is greater than 512.
        """
        update_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The time when the policy was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
elif False:
    InstanceMaintenancePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMaintenancePolicyArgs:
    def __init__(__self__, *,
                 weekly_maintenance_windows: pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs']]],
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs']]] weekly_maintenance_windows: Required. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number of weekly_maintenance_windows
               is expected to be one.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: (Output)
               Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits
        :param pulumi.Input[builtins.str] description: Optional. Description of what this policy is for.
               Create/Update methods return INVALID_ARGUMENT if the
               length is greater than 512.
        :param pulumi.Input[builtins.str] update_time: (Output)
               Output only. The time when the policy was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs']]]:
        """
        Required. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number of weekly_maintenance_windows
        is expected to be one.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_maintenance_windows")

    @weekly_maintenance_windows.setter
    def weekly_maintenance_windows(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs']]]):
        pulumi.set(self, "weekly_maintenance_windows", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Description of what this policy is for.
        Create/Update methods return INVALID_ARGUMENT if the
        length is greater than 512.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The time when the policy was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


if not MYPY:
    class InstanceMaintenancePolicyWeeklyMaintenanceWindowArgsDict(TypedDict):
        day: pulumi.Input[builtins.str]
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        duration: pulumi.Input[builtins.str]
        """
        Required. The length of the maintenance window, ranging from 3 hours to 8 hours.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        start_time: pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict']
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
elif False:
    InstanceMaintenancePolicyWeeklyMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[builtins.str],
                 duration: pulumi.Input[builtins.str],
                 start_time: pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs']):
        """
        :param pulumi.Input[builtins.str] day: Required. The day of week that maintenance updates occur.
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday
               Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param pulumi.Input[builtins.str] duration: Required. The length of the maintenance window, ranging from 3 hours to 8 hours.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        :param pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs'] start_time: Required. Start time of the window in UTC time.
               Structure is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input[builtins.str]:
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.str]:
        """
        Required. The length of the maintenance window, ranging from 3 hours to 8 hours.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs']:
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input['InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs']):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict(TypedDict):
        hours: NotRequired[pulumi.Input[builtins.int]]
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        minutes: NotRequired[pulumi.Input[builtins.int]]
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        nanos: NotRequired[pulumi.Input[builtins.int]]
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
elif False:
    InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[builtins.int]] = None,
                 minutes: Optional[pulumi.Input[builtins.int]] = None,
                 nanos: Optional[pulumi.Input[builtins.int]] = None,
                 seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param pulumi.Input[builtins.int] minutes: Minutes of hour of day. Must be from 0 to 59.
        :param pulumi.Input[builtins.int] nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param pulumi.Input[builtins.int] seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds", value)


if not MYPY:
    class InstanceMaintenanceScheduleArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        schedule_deadline_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        start_time: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
elif False:
    InstanceMaintenanceScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMaintenanceScheduleArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_deadline_time: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] end_time: (Output)
               Output only. The end time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[builtins.str] schedule_deadline_time: (Output)
               Output only. The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[builtins.str] start_time: (Output)
               Output only. The start time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule_deadline_time is not None:
            pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @schedule_deadline_time.setter
    def schedule_deadline_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule_deadline_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class InstanceMemcacheNodeArgsDict(TypedDict):
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        """
        node_id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Output)
        The port number of the Memcached server on this node.
        """
        state: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Current state of the Memcached node.
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Location (GCP Zone) for the Memcached node.
        """
elif False:
    InstanceMemcacheNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMemcacheNodeArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 node_id: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] host: (Output)
               Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        :param pulumi.Input[builtins.str] node_id: (Output)
               Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        :param pulumi.Input[builtins.int] port: (Output)
               The port number of the Memcached server on this node.
        :param pulumi.Input[builtins.str] state: (Output)
               Current state of the Memcached node.
        :param pulumi.Input[builtins.str] zone: (Output)
               Location (GCP Zone) for the Memcached node.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Output)
        The port number of the Memcached server on this node.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Current state of the Memcached node.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Location (GCP Zone) for the Memcached node.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class InstanceMemcacheParametersArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        This is a unique ID associated with this set of parameters.
        """
        params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        User-defined set of parameters to use in the memcache process.
        """
elif False:
    InstanceMemcacheParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMemcacheParametersArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] id: (Output)
               This is a unique ID associated with this set of parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] params: User-defined set of parameters to use in the memcache process.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if params is not None:
            pulumi.set(__self__, "params", params)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        This is a unique ID associated with this set of parameters.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined set of parameters to use in the memcache process.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "params", value)


if not MYPY:
    class InstanceNodeConfigArgsDict(TypedDict):
        cpu_count: pulumi.Input[builtins.int]
        """
        Number of CPUs per node.
        """
        memory_size_mb: pulumi.Input[builtins.int]
        """
        Memory size in Mebibytes for each memcache node.
        """
elif False:
    InstanceNodeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNodeConfigArgs:
    def __init__(__self__, *,
                 cpu_count: pulumi.Input[builtins.int],
                 memory_size_mb: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] cpu_count: Number of CPUs per node.
        :param pulumi.Input[builtins.int] memory_size_mb: Memory size in Mebibytes for each memcache node.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)
        pulumi.set(__self__, "memory_size_mb", memory_size_mb)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Input[builtins.int]:
        """
        Number of CPUs per node.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "cpu_count", value)

    @property
    @pulumi.getter(name="memorySizeMb")
    def memory_size_mb(self) -> pulumi.Input[builtins.int]:
        """
        Memory size in Mebibytes for each memcache node.
        """
        return pulumi.get(self, "memory_size_mb")

    @memory_size_mb.setter
    def memory_size_mb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "memory_size_mb", value)


