# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    """
    A collection of values returned by getInstance.
    """
    def __init__(__self__, authorized_network=None, create_time=None, discovery_endpoint=None, display_name=None, effective_labels=None, id=None, labels=None, maintenance_policies=None, maintenance_schedules=None, memcache_full_version=None, memcache_nodes=None, memcache_parameters=None, memcache_version=None, name=None, node_configs=None, node_count=None, project=None, pulumi_labels=None, region=None, reserved_ip_range_ids=None, zones=None):
        if authorized_network and not isinstance(authorized_network, str):
            raise TypeError("Expected argument 'authorized_network' to be a str")
        pulumi.set(__self__, "authorized_network", authorized_network)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if discovery_endpoint and not isinstance(discovery_endpoint, str):
            raise TypeError("Expected argument 'discovery_endpoint' to be a str")
        pulumi.set(__self__, "discovery_endpoint", discovery_endpoint)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if maintenance_policies and not isinstance(maintenance_policies, list):
            raise TypeError("Expected argument 'maintenance_policies' to be a list")
        pulumi.set(__self__, "maintenance_policies", maintenance_policies)
        if maintenance_schedules and not isinstance(maintenance_schedules, list):
            raise TypeError("Expected argument 'maintenance_schedules' to be a list")
        pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if memcache_full_version and not isinstance(memcache_full_version, str):
            raise TypeError("Expected argument 'memcache_full_version' to be a str")
        pulumi.set(__self__, "memcache_full_version", memcache_full_version)
        if memcache_nodes and not isinstance(memcache_nodes, list):
            raise TypeError("Expected argument 'memcache_nodes' to be a list")
        pulumi.set(__self__, "memcache_nodes", memcache_nodes)
        if memcache_parameters and not isinstance(memcache_parameters, list):
            raise TypeError("Expected argument 'memcache_parameters' to be a list")
        pulumi.set(__self__, "memcache_parameters", memcache_parameters)
        if memcache_version and not isinstance(memcache_version, str):
            raise TypeError("Expected argument 'memcache_version' to be a str")
        pulumi.set(__self__, "memcache_version", memcache_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_configs and not isinstance(node_configs, list):
            raise TypeError("Expected argument 'node_configs' to be a list")
        pulumi.set(__self__, "node_configs", node_configs)
        if node_count and not isinstance(node_count, int):
            raise TypeError("Expected argument 'node_count' to be a int")
        pulumi.set(__self__, "node_count", node_count)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if reserved_ip_range_ids and not isinstance(reserved_ip_range_ids, list):
            raise TypeError("Expected argument 'reserved_ip_range_ids' to be a list")
        pulumi.set(__self__, "reserved_ip_range_ids", reserved_ip_range_ids)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> builtins.str:
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="discoveryEndpoint")
    def discovery_endpoint(self) -> builtins.str:
        return pulumi.get(self, "discovery_endpoint")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintenancePolicies")
    def maintenance_policies(self) -> Sequence['outputs.GetInstanceMaintenancePolicyResult']:
        return pulumi.get(self, "maintenance_policies")

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Sequence['outputs.GetInstanceMaintenanceScheduleResult']:
        return pulumi.get(self, "maintenance_schedules")

    @property
    @pulumi.getter(name="memcacheFullVersion")
    def memcache_full_version(self) -> builtins.str:
        return pulumi.get(self, "memcache_full_version")

    @property
    @pulumi.getter(name="memcacheNodes")
    def memcache_nodes(self) -> Sequence['outputs.GetInstanceMemcacheNodeResult']:
        return pulumi.get(self, "memcache_nodes")

    @property
    @pulumi.getter(name="memcacheParameters")
    def memcache_parameters(self) -> Sequence['outputs.GetInstanceMemcacheParameterResult']:
        return pulumi.get(self, "memcache_parameters")

    @property
    @pulumi.getter(name="memcacheVersion")
    def memcache_version(self) -> builtins.str:
        return pulumi.get(self, "memcache_version")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Sequence['outputs.GetInstanceNodeConfigResult']:
        return pulumi.get(self, "node_configs")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="reservedIpRangeIds")
    def reserved_ip_range_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "reserved_ip_range_ids")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "zones")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            authorized_network=self.authorized_network,
            create_time=self.create_time,
            discovery_endpoint=self.discovery_endpoint,
            display_name=self.display_name,
            effective_labels=self.effective_labels,
            id=self.id,
            labels=self.labels,
            maintenance_policies=self.maintenance_policies,
            maintenance_schedules=self.maintenance_schedules,
            memcache_full_version=self.memcache_full_version,
            memcache_nodes=self.memcache_nodes,
            memcache_parameters=self.memcache_parameters,
            memcache_version=self.memcache_version,
            name=self.name,
            node_configs=self.node_configs,
            node_count=self.node_count,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            region=self.region,
            reserved_ip_range_ids=self.reserved_ip_range_ids,
            zones=self.zones)


def get_instance(name: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Use this data source to get information about the available instance. For more details refer the [API docs](https://cloud.google.com/memorystore/docs/memcached/reference/rest/v1/projects.locations.instances).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    qa = gcp.memcache.get_instance()
    ```


    :param builtins.str name: The ID of the memcache instance.
           'memcache_instance_id'
    :param builtins.str project: (optional)
           The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    :param builtins.str region: (optional)
           The canonical id of the region. If it is not provided, the provider project is used. For example: us-east1.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:memcache/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        authorized_network=pulumi.get(__ret__, 'authorized_network'),
        create_time=pulumi.get(__ret__, 'create_time'),
        discovery_endpoint=pulumi.get(__ret__, 'discovery_endpoint'),
        display_name=pulumi.get(__ret__, 'display_name'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        maintenance_policies=pulumi.get(__ret__, 'maintenance_policies'),
        maintenance_schedules=pulumi.get(__ret__, 'maintenance_schedules'),
        memcache_full_version=pulumi.get(__ret__, 'memcache_full_version'),
        memcache_nodes=pulumi.get(__ret__, 'memcache_nodes'),
        memcache_parameters=pulumi.get(__ret__, 'memcache_parameters'),
        memcache_version=pulumi.get(__ret__, 'memcache_version'),
        name=pulumi.get(__ret__, 'name'),
        node_configs=pulumi.get(__ret__, 'node_configs'),
        node_count=pulumi.get(__ret__, 'node_count'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        region=pulumi.get(__ret__, 'region'),
        reserved_ip_range_ids=pulumi.get(__ret__, 'reserved_ip_range_ids'),
        zones=pulumi.get(__ret__, 'zones'))
def get_instance_output(name: Optional[pulumi.Input[builtins.str]] = None,
                        project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Use this data source to get information about the available instance. For more details refer the [API docs](https://cloud.google.com/memorystore/docs/memcached/reference/rest/v1/projects.locations.instances).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    qa = gcp.memcache.get_instance()
    ```


    :param builtins.str name: The ID of the memcache instance.
           'memcache_instance_id'
    :param builtins.str project: (optional)
           The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    :param builtins.str region: (optional)
           The canonical id of the region. If it is not provided, the provider project is used. For example: us-east1.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:memcache/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult)
    return __ret__.apply(lambda __response__: GetInstanceResult(
        authorized_network=pulumi.get(__response__, 'authorized_network'),
        create_time=pulumi.get(__response__, 'create_time'),
        discovery_endpoint=pulumi.get(__response__, 'discovery_endpoint'),
        display_name=pulumi.get(__response__, 'display_name'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        maintenance_policies=pulumi.get(__response__, 'maintenance_policies'),
        maintenance_schedules=pulumi.get(__response__, 'maintenance_schedules'),
        memcache_full_version=pulumi.get(__response__, 'memcache_full_version'),
        memcache_nodes=pulumi.get(__response__, 'memcache_nodes'),
        memcache_parameters=pulumi.get(__response__, 'memcache_parameters'),
        memcache_version=pulumi.get(__response__, 'memcache_version'),
        name=pulumi.get(__response__, 'name'),
        node_configs=pulumi.get(__response__, 'node_configs'),
        node_count=pulumi.get(__response__, 'node_count'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        region=pulumi.get(__response__, 'region'),
        reserved_ip_range_ids=pulumi.get(__response__, 'reserved_ip_range_ids'),
        zones=pulumi.get(__response__, 'zones')))
