# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceMaintenancePolicy',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindow',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime',
    'InstanceMaintenanceSchedule',
    'InstanceMemcacheNode',
    'InstanceMemcacheParameters',
    'InstanceNodeConfig',
    'GetInstanceMaintenancePolicyResult',
    'GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult',
    'GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult',
    'GetInstanceMaintenanceScheduleResult',
    'GetInstanceMemcacheNodeResult',
    'GetInstanceMemcacheParameterResult',
    'GetInstanceNodeConfigResult',
]

@pulumi.output_type
class InstanceMaintenancePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "weeklyMaintenanceWindows":
            suggest = "weekly_maintenance_windows"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenancePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenancePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenancePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 weekly_maintenance_windows: Sequence['outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindow'],
                 create_time: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 update_time: Optional[builtins.str] = None):
        """
        :param Sequence['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs'] weekly_maintenance_windows: Required. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number of weekly_maintenance_windows
               is expected to be one.
               Structure is documented below.
        :param builtins.str create_time: (Output)
               Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits
        :param builtins.str description: Optional. Description of what this policy is for.
               Create/Update methods return INVALID_ARGUMENT if the
               length is greater than 512.
        :param builtins.str update_time: (Output)
               Output only. The time when the policy was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Sequence['outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindow']:
        """
        Required. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number of weekly_maintenance_windows
        is expected to be one.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_maintenance_windows")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Optional. Description of what this policy is for.
        Create/Update methods return INVALID_ARGUMENT if the
        length is greater than 512.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The time when the policy was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenancePolicyWeeklyMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenancePolicyWeeklyMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenancePolicyWeeklyMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: builtins.str,
                 duration: builtins.str,
                 start_time: 'outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime'):
        """
        :param builtins.str day: Required. The day of week that maintenance updates occur.
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday
               Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param builtins.str duration: Required. The length of the maintenance window, ranging from 3 hours to 8 hours.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        :param 'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs' start_time: Required. Start time of the window in UTC time.
               Structure is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> builtins.str:
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Required. The length of the maintenance window, ranging from 3 hours to 8 hours.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime':
        """
        Required. Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[builtins.int] = None,
                 minutes: Optional[builtins.int] = None,
                 nanos: Optional[builtins.int] = None,
                 seconds: Optional[builtins.int] = None):
        """
        :param builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param builtins.int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param builtins.int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param builtins.int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[builtins.int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[builtins.int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[builtins.int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[builtins.int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class InstanceMaintenanceSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "scheduleDeadlineTime":
            suggest = "schedule_deadline_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenanceSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenanceSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenanceSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[builtins.str] = None,
                 schedule_deadline_time: Optional[builtins.str] = None,
                 start_time: Optional[builtins.str] = None):
        """
        :param builtins.str end_time: (Output)
               Output only. The end time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str schedule_deadline_time: (Output)
               Output only. The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str start_time: (Output)
               Output only. The start time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule_deadline_time is not None:
            pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The end time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The start time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InstanceMemcacheNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMemcacheNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMemcacheNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMemcacheNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Optional[builtins.str] = None,
                 node_id: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 state: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str host: (Output)
               Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        :param builtins.str node_id: (Output)
               Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        :param builtins.int port: (Output)
               The port number of the Memcached server on this node.
        :param builtins.str state: (Output)
               Current state of the Memcached node.
        :param builtins.str zone: (Output)
               Location (GCP Zone) for the Memcached node.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        """
        (Output)
        Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[builtins.str]:
        """
        (Output)
        Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        (Output)
        The port number of the Memcached server on this node.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        Current state of the Memcached node.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        (Output)
        Location (GCP Zone) for the Memcached node.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceMemcacheParameters(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 params: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str id: (Output)
               This is a unique ID associated with this set of parameters.
        :param Mapping[str, builtins.str] params: User-defined set of parameters to use in the memcache process.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if params is not None:
            pulumi.set(__self__, "params", params)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        (Output)
        This is a unique ID associated with this set of parameters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def params(self) -> Optional[Mapping[str, builtins.str]]:
        """
        User-defined set of parameters to use in the memcache process.
        """
        return pulumi.get(self, "params")


@pulumi.output_type
class InstanceNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"
        elif key == "memorySizeMb":
            suggest = "memory_size_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: builtins.int,
                 memory_size_mb: builtins.int):
        """
        :param builtins.int cpu_count: Number of CPUs per node.
        :param builtins.int memory_size_mb: Memory size in Mebibytes for each memcache node.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)
        pulumi.set(__self__, "memory_size_mb", memory_size_mb)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> builtins.int:
        """
        Number of CPUs per node.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="memorySizeMb")
    def memory_size_mb(self) -> builtins.int:
        """
        Memory size in Mebibytes for each memcache node.
        """
        return pulumi.get(self, "memory_size_mb")


@pulumi.output_type
class GetInstanceMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 create_time: builtins.str,
                 description: builtins.str,
                 update_time: builtins.str,
                 weekly_maintenance_windows: Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult']):
        """
        :param builtins.str create_time: Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits
        :param builtins.str description: Optional. Description of what this policy is for.
               Create/Update methods return INVALID_ARGUMENT if the
               length is greater than 512.
        :param builtins.str update_time: Output only. The time when the policy was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param Sequence['GetInstanceMaintenancePolicyWeeklyMaintenanceWindowArgs'] weekly_maintenance_windows: Required. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number of weekly_maintenance_windows
               is expected to be one.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Optional. Description of what this policy is for.
        Create/Update methods return INVALID_ARGUMENT if the
        length is greater than 512.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> builtins.str:
        """
        Output only. The time when the policy was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult']:
        """
        Required. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number of weekly_maintenance_windows
        is expected to be one.
        """
        return pulumi.get(self, "weekly_maintenance_windows")


@pulumi.output_type
class GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: builtins.str,
                 duration: builtins.str,
                 start_times: Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult']):
        """
        :param builtins.str day: Required. The day of week that maintenance updates occur.
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        :param builtins.str duration: Required. The length of the maintenance window, ranging from 3 hours to 8 hours.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        :param Sequence['GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs'] start_times: Required. Start time of the window in UTC time.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_times", start_times)

    @property
    @pulumi.getter
    def day(self) -> builtins.str:
        """
        Required. The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Required. The length of the maintenance window, ranging from 3 hours to 8 hours.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult']:
        """
        Required. Start time of the window in UTC time.
        """
        return pulumi.get(self, "start_times")


@pulumi.output_type
class GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: builtins.int,
                 minutes: builtins.int,
                 nanos: builtins.int,
                 seconds: builtins.int):
        """
        :param builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param builtins.int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param builtins.int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param builtins.int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> builtins.int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> builtins.int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> builtins.int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GetInstanceMaintenanceScheduleResult(dict):
    def __init__(__self__, *,
                 end_time: builtins.str,
                 schedule_deadline_time: builtins.str,
                 start_time: builtins.str):
        """
        :param builtins.str end_time: Output only. The end time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str schedule_deadline_time: Output only. The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param builtins.str start_time: Output only. The start time of any upcoming scheduled maintenance for this instance.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> builtins.str:
        """
        Output only. The end time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> builtins.str:
        """
        Output only. The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        Output only. The start time of any upcoming scheduled maintenance for this instance.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetInstanceMemcacheNodeResult(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 node_id: builtins.str,
                 port: builtins.int,
                 state: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str host: Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        :param builtins.str node_id: Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        :param builtins.int port: The port number of the Memcached server on this node.
        :param builtins.str state: Current state of the Memcached node.
        :param builtins.str zone: Location (GCP Zone) for the Memcached node.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> builtins.str:
        """
        Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port number of the Memcached server on this node.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Current state of the Memcached node.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        Location (GCP Zone) for the Memcached node.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceMemcacheParameterResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 params: Mapping[str, builtins.str]):
        """
        :param builtins.str id: This is a unique ID associated with this set of parameters.
        :param Mapping[str, builtins.str] params: User-defined set of parameters to use in the memcache process.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "params", params)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        This is a unique ID associated with this set of parameters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def params(self) -> Mapping[str, builtins.str]:
        """
        User-defined set of parameters to use in the memcache process.
        """
        return pulumi.get(self, "params")


@pulumi.output_type
class GetInstanceNodeConfigResult(dict):
    def __init__(__self__, *,
                 cpu_count: builtins.int,
                 memory_size_mb: builtins.int):
        """
        :param builtins.int cpu_count: Number of CPUs per node.
        :param builtins.int memory_size_mb: Memory size in Mebibytes for each memcache node.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)
        pulumi.set(__self__, "memory_size_mb", memory_size_mb)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> builtins.int:
        """
        Number of CPUs per node.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="memorySizeMb")
    def memory_size_mb(self) -> builtins.int:
        """
        Memory size in Mebibytes for each memcache node.
        """
        return pulumi.get(self, "memory_size_mb")


