# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceDesiredUserCreatedEndpointsArgs', 'InstanceDesiredUserCreatedEndpoints']

@pulumi.input_type
class InstanceDesiredUserCreatedEndpointsArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[builtins.str],
                 desired_user_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceDesiredUserCreatedEndpoints resource.
        :param pulumi.Input[builtins.str] region: The name of the region of the Memorystore instance these endpoints should be added to.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs']]] desired_user_created_endpoints: A list of desired user endpoints
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the Memorystore instance these endpoints should be added to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "region", region)
        if desired_user_created_endpoints is not None:
            pulumi.set(__self__, "desired_user_created_endpoints", desired_user_created_endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        The name of the region of the Memorystore instance these endpoints should be added to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="desiredUserCreatedEndpoints")
    def desired_user_created_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs']]]]:
        """
        A list of desired user endpoints
        Structure is documented below.
        """
        return pulumi.get(self, "desired_user_created_endpoints")

    @desired_user_created_endpoints.setter
    def desired_user_created_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs']]]]):
        pulumi.set(self, "desired_user_created_endpoints", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Memorystore instance these endpoints should be added to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InstanceDesiredUserCreatedEndpointsState:
    def __init__(__self__, *,
                 desired_user_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceDesiredUserCreatedEndpoints resources.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs']]] desired_user_created_endpoints: A list of desired user endpoints
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the Memorystore instance these endpoints should be added to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The name of the region of the Memorystore instance these endpoints should be added to.
        """
        if desired_user_created_endpoints is not None:
            pulumi.set(__self__, "desired_user_created_endpoints", desired_user_created_endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="desiredUserCreatedEndpoints")
    def desired_user_created_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs']]]]:
        """
        A list of desired user endpoints
        Structure is documented below.
        """
        return pulumi.get(self, "desired_user_created_endpoints")

    @desired_user_created_endpoints.setter
    def desired_user_created_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs']]]]):
        pulumi.set(self, "desired_user_created_endpoints", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Memorystore instance these endpoints should be added to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the region of the Memorystore instance these endpoints should be added to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints")
class InstanceDesiredUserCreatedEndpoints(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_user_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs', 'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Memorystore Instance Desired User Created Endpoints

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network1 = gcp.compute.Network("network1",
            name="net1",
            auto_create_subnetworks=False)
        subnet_network1 = gcp.compute.Subnetwork("subnet_network1",
            name="subnet-net1",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network1.id)
        ip1_network1 = gcp.compute.Address("ip1_network1",
            name="ip1-net1",
            region="us-central1",
            subnetwork=subnet_network1.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        #Valkey instance without endpoints
        instance_user_conn_instance = gcp.memorystore.Instance("instance-user-conn",
            instance_id="instance-user-conn",
            shard_count=1,
            location="us-central1",
            deletion_protection_enabled=False)
        forwarding_rule1_network1 = gcp.compute.ForwardingRule("forwarding_rule1_network1",
            name="fwd1-net1",
            region="us-central1",
            ip_address=ip1_network1.id,
            load_balancing_scheme="",
            network=network1.id,
            target=instance_user_conn_instance.psc_attachment_details[0].service_attachment)
        ip2_network1 = gcp.compute.Address("ip2_network1",
            name="ip2-net1",
            region="us-central1",
            subnetwork=subnet_network1.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network1 = gcp.compute.ForwardingRule("forwarding_rule2_network1",
            name="fwd2-net1",
            region="us-central1",
            ip_address=ip2_network1.id,
            load_balancing_scheme="",
            network=network1.id,
            target=instance_user_conn_instance.psc_attachment_details[1].service_attachment)
        network2 = gcp.compute.Network("network2",
            name="network2",
            auto_create_subnetworks=False)
        subnet_network2 = gcp.compute.Subnetwork("subnet_network2",
            name="subnet-net2",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network2.id)
        ip1_network2 = gcp.compute.Address("ip1_network2",
            name="ip1-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule1_network2 = gcp.compute.ForwardingRule("forwarding_rule1_network2",
            name="fwd1-net2",
            region="us-central1",
            ip_address=ip1_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=instance_user_conn_instance.psc_attachment_details[0].service_attachment)
        ip2_network2 = gcp.compute.Address("ip2_network2",
            name="ip2-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network2 = gcp.compute.ForwardingRule("forwarding_rule2_network2",
            name="fwd2-net2",
            region="us-central1",
            ip_address=ip2_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=instance_user_conn_instance.psc_attachment_details[1].service_attachment)
        instance_user_conn = gcp.memorystore.InstanceDesiredUserCreatedEndpoints("instance-user-conn",
            name="instance-user-conn",
            region="us-central1",
            desired_user_created_endpoints=[
                {
                    "connections": [
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule1_network1.psc_connection_id,
                                "ip_address": ip1_network1.address,
                                "forwarding_rule": forwarding_rule1_network1.id,
                                "network": network1.id,
                                "service_attachment": instance_user_conn_instance.psc_attachment_details[0].service_attachment,
                            },
                        },
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule2_network1.psc_connection_id,
                                "ip_address": ip2_network1.address,
                                "forwarding_rule": forwarding_rule2_network1.id,
                                "network": network1.id,
                                "service_attachment": instance_user_conn_instance.psc_attachment_details[1].service_attachment,
                            },
                        },
                    ],
                },
                {
                    "connections": [
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule1_network2.psc_connection_id,
                                "ip_address": ip1_network2.address,
                                "forwarding_rule": forwarding_rule1_network2.id,
                                "network": network2.id,
                                "service_attachment": instance_user_conn_instance.psc_attachment_details[0].service_attachment,
                            },
                        },
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule2_network2.psc_connection_id,
                                "ip_address": ip2_network2.address,
                                "forwarding_rule": forwarding_rule2_network2.id,
                                "network": network2.id,
                                "service_attachment": instance_user_conn_instance.psc_attachment_details[1].service_attachment,
                            },
                        },
                    ],
                },
            ])
        project = gcp.organizations.get_project()
        ```
        ### Memorystore Instance Desired User And Auto Created Endpoints

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network2 = gcp.compute.Network("network2",
            name="network2",
            auto_create_subnetworks=False)
        subnet_network2 = gcp.compute.Subnetwork("subnet_network2",
            name="subnet-net2",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network2.id)
        ip1_network2 = gcp.compute.Address("ip1_network2",
            name="ip1-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        network1 = gcp.compute.Network("network1",
            name="net1",
            auto_create_subnetworks=False)
        subnet_network1 = gcp.compute.Subnetwork("subnet_network1",
            name="subnet-net1",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network1.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="scpolicy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=network1.id,
            psc_config={
                "subnetworks": [subnet_network1.id],
            })
        project = gcp.organizations.get_project()
        #valkey instance with endpoints
        instance_user_auto_conn_instance = gcp.memorystore.Instance("instance-user-auto-conn",
            instance_id="instance-user-auto-conn",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": network1.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            deletion_protection_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        forwarding_rule1_network2 = gcp.compute.ForwardingRule("forwarding_rule1_network2",
            name="fwd1-net2",
            region="us-central1",
            ip_address=ip1_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=instance_user_auto_conn_instance.psc_attachment_details[0].service_attachment)
        ip2_network2 = gcp.compute.Address("ip2_network2",
            name="ip2-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network2 = gcp.compute.ForwardingRule("forwarding_rule2_network2",
            name="fwd2-net2",
            region="us-central1",
            ip_address=ip2_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=instance_user_auto_conn_instance.psc_attachment_details[1].service_attachment)
        instance_user_auto_conn = gcp.memorystore.InstanceDesiredUserCreatedEndpoints("instance-user-auto-conn",
            name="instance-user-auto-conn",
            region="us-central1",
            desired_user_created_endpoints=[{
                "connections": [
                    {
                        "psc_connection": {
                            "psc_connection_id": forwarding_rule1_network2.psc_connection_id,
                            "ip_address": ip1_network2.address,
                            "forwarding_rule": forwarding_rule1_network2.id,
                            "network": network2.id,
                            "service_attachment": instance_user_auto_conn_instance.psc_attachment_details[0].service_attachment,
                        },
                    },
                    {
                        "psc_connection": {
                            "psc_connection_id": forwarding_rule2_network2.psc_connection_id,
                            "ip_address": ip2_network2.address,
                            "forwarding_rule": forwarding_rule2_network2.id,
                            "network": network2.id,
                            "service_attachment": instance_user_auto_conn_instance.psc_attachment_details[1].service_attachment,
                        },
                    },
                ],
            }])
        ```

        ## Import

        InstanceDesiredUserCreatedEndpoints can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InstanceDesiredUserCreatedEndpoints can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs', 'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgsDict']]]] desired_user_created_endpoints: A list of desired user endpoints
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the Memorystore instance these endpoints should be added to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The name of the region of the Memorystore instance these endpoints should be added to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceDesiredUserCreatedEndpointsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Memorystore Instance Desired User Created Endpoints

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network1 = gcp.compute.Network("network1",
            name="net1",
            auto_create_subnetworks=False)
        subnet_network1 = gcp.compute.Subnetwork("subnet_network1",
            name="subnet-net1",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network1.id)
        ip1_network1 = gcp.compute.Address("ip1_network1",
            name="ip1-net1",
            region="us-central1",
            subnetwork=subnet_network1.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        #Valkey instance without endpoints
        instance_user_conn_instance = gcp.memorystore.Instance("instance-user-conn",
            instance_id="instance-user-conn",
            shard_count=1,
            location="us-central1",
            deletion_protection_enabled=False)
        forwarding_rule1_network1 = gcp.compute.ForwardingRule("forwarding_rule1_network1",
            name="fwd1-net1",
            region="us-central1",
            ip_address=ip1_network1.id,
            load_balancing_scheme="",
            network=network1.id,
            target=instance_user_conn_instance.psc_attachment_details[0].service_attachment)
        ip2_network1 = gcp.compute.Address("ip2_network1",
            name="ip2-net1",
            region="us-central1",
            subnetwork=subnet_network1.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network1 = gcp.compute.ForwardingRule("forwarding_rule2_network1",
            name="fwd2-net1",
            region="us-central1",
            ip_address=ip2_network1.id,
            load_balancing_scheme="",
            network=network1.id,
            target=instance_user_conn_instance.psc_attachment_details[1].service_attachment)
        network2 = gcp.compute.Network("network2",
            name="network2",
            auto_create_subnetworks=False)
        subnet_network2 = gcp.compute.Subnetwork("subnet_network2",
            name="subnet-net2",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network2.id)
        ip1_network2 = gcp.compute.Address("ip1_network2",
            name="ip1-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule1_network2 = gcp.compute.ForwardingRule("forwarding_rule1_network2",
            name="fwd1-net2",
            region="us-central1",
            ip_address=ip1_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=instance_user_conn_instance.psc_attachment_details[0].service_attachment)
        ip2_network2 = gcp.compute.Address("ip2_network2",
            name="ip2-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network2 = gcp.compute.ForwardingRule("forwarding_rule2_network2",
            name="fwd2-net2",
            region="us-central1",
            ip_address=ip2_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=instance_user_conn_instance.psc_attachment_details[1].service_attachment)
        instance_user_conn = gcp.memorystore.InstanceDesiredUserCreatedEndpoints("instance-user-conn",
            name="instance-user-conn",
            region="us-central1",
            desired_user_created_endpoints=[
                {
                    "connections": [
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule1_network1.psc_connection_id,
                                "ip_address": ip1_network1.address,
                                "forwarding_rule": forwarding_rule1_network1.id,
                                "network": network1.id,
                                "service_attachment": instance_user_conn_instance.psc_attachment_details[0].service_attachment,
                            },
                        },
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule2_network1.psc_connection_id,
                                "ip_address": ip2_network1.address,
                                "forwarding_rule": forwarding_rule2_network1.id,
                                "network": network1.id,
                                "service_attachment": instance_user_conn_instance.psc_attachment_details[1].service_attachment,
                            },
                        },
                    ],
                },
                {
                    "connections": [
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule1_network2.psc_connection_id,
                                "ip_address": ip1_network2.address,
                                "forwarding_rule": forwarding_rule1_network2.id,
                                "network": network2.id,
                                "service_attachment": instance_user_conn_instance.psc_attachment_details[0].service_attachment,
                            },
                        },
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule2_network2.psc_connection_id,
                                "ip_address": ip2_network2.address,
                                "forwarding_rule": forwarding_rule2_network2.id,
                                "network": network2.id,
                                "service_attachment": instance_user_conn_instance.psc_attachment_details[1].service_attachment,
                            },
                        },
                    ],
                },
            ])
        project = gcp.organizations.get_project()
        ```
        ### Memorystore Instance Desired User And Auto Created Endpoints

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network2 = gcp.compute.Network("network2",
            name="network2",
            auto_create_subnetworks=False)
        subnet_network2 = gcp.compute.Subnetwork("subnet_network2",
            name="subnet-net2",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network2.id)
        ip1_network2 = gcp.compute.Address("ip1_network2",
            name="ip1-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        network1 = gcp.compute.Network("network1",
            name="net1",
            auto_create_subnetworks=False)
        subnet_network1 = gcp.compute.Subnetwork("subnet_network1",
            name="subnet-net1",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network1.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="scpolicy",
            location="us-central1",
            service_class="gcp-memorystore",
            description="my basic service connection policy",
            network=network1.id,
            psc_config={
                "subnetworks": [subnet_network1.id],
            })
        project = gcp.organizations.get_project()
        #valkey instance with endpoints
        instance_user_auto_conn_instance = gcp.memorystore.Instance("instance-user-auto-conn",
            instance_id="instance-user-auto-conn",
            shard_count=1,
            desired_auto_created_endpoints=[{
                "network": network1.id,
                "project_id": project.project_id,
            }],
            location="us-central1",
            deletion_protection_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        forwarding_rule1_network2 = gcp.compute.ForwardingRule("forwarding_rule1_network2",
            name="fwd1-net2",
            region="us-central1",
            ip_address=ip1_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=instance_user_auto_conn_instance.psc_attachment_details[0].service_attachment)
        ip2_network2 = gcp.compute.Address("ip2_network2",
            name="ip2-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network2 = gcp.compute.ForwardingRule("forwarding_rule2_network2",
            name="fwd2-net2",
            region="us-central1",
            ip_address=ip2_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=instance_user_auto_conn_instance.psc_attachment_details[1].service_attachment)
        instance_user_auto_conn = gcp.memorystore.InstanceDesiredUserCreatedEndpoints("instance-user-auto-conn",
            name="instance-user-auto-conn",
            region="us-central1",
            desired_user_created_endpoints=[{
                "connections": [
                    {
                        "psc_connection": {
                            "psc_connection_id": forwarding_rule1_network2.psc_connection_id,
                            "ip_address": ip1_network2.address,
                            "forwarding_rule": forwarding_rule1_network2.id,
                            "network": network2.id,
                            "service_attachment": instance_user_auto_conn_instance.psc_attachment_details[0].service_attachment,
                        },
                    },
                    {
                        "psc_connection": {
                            "psc_connection_id": forwarding_rule2_network2.psc_connection_id,
                            "ip_address": ip2_network2.address,
                            "forwarding_rule": forwarding_rule2_network2.id,
                            "network": network2.id,
                            "service_attachment": instance_user_auto_conn_instance.psc_attachment_details[1].service_attachment,
                        },
                    },
                ],
            }])
        ```

        ## Import

        InstanceDesiredUserCreatedEndpoints can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InstanceDesiredUserCreatedEndpoints can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceDesiredUserCreatedEndpointsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceDesiredUserCreatedEndpointsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_user_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs', 'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceDesiredUserCreatedEndpointsArgs.__new__(InstanceDesiredUserCreatedEndpointsArgs)

            __props__.__dict__["desired_user_created_endpoints"] = desired_user_created_endpoints
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
        super(InstanceDesiredUserCreatedEndpoints, __self__).__init__(
            'gcp:memorystore/instanceDesiredUserCreatedEndpoints:InstanceDesiredUserCreatedEndpoints',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            desired_user_created_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs', 'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'InstanceDesiredUserCreatedEndpoints':
        """
        Get an existing InstanceDesiredUserCreatedEndpoints resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgs', 'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointArgsDict']]]] desired_user_created_endpoints: A list of desired user endpoints
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the Memorystore instance these endpoints should be added to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The name of the region of the Memorystore instance these endpoints should be added to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceDesiredUserCreatedEndpointsState.__new__(_InstanceDesiredUserCreatedEndpointsState)

        __props__.__dict__["desired_user_created_endpoints"] = desired_user_created_endpoints
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        return InstanceDesiredUserCreatedEndpoints(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="desiredUserCreatedEndpoints")
    def desired_user_created_endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpoint']]]:
        """
        A list of desired user endpoints
        Structure is documented below.
        """
        return pulumi.get(self, "desired_user_created_endpoints")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Memorystore instance these endpoints should be added to.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The name of the region of the Memorystore instance these endpoints should be added to.
        """
        return pulumi.get(self, "region")

