# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreferenceSetArgs', 'PreferenceSet']

@pulumi.input_type
class PreferenceSetArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 preference_set_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_preferences: Optional[pulumi.Input['PreferenceSetVirtualMachinePreferencesArgs']] = None):
        """
        The set of arguments for constructing a PreferenceSet resource.
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] preference_set_id: Required. User specified ID for the preference set. It will become the last component of the preference set name. The ID must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. The ID must match the regular expression `a-z?`.
        :param pulumi.Input[builtins.str] description: A description of the preference set.
        :param pulumi.Input[builtins.str] display_name: User-friendly display name. Maximum length is 63 characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['PreferenceSetVirtualMachinePreferencesArgs'] virtual_machine_preferences: VirtualMachinePreferences enables you to create sets of assumptions, for example, a geographical location and pricing track, for your migrated virtual machines. The set of preferences influence recommendations for migrating virtual machine assets.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "preference_set_id", preference_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if virtual_machine_preferences is not None:
            pulumi.set(__self__, "virtual_machine_preferences", virtual_machine_preferences)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="preferenceSetId")
    def preference_set_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. User specified ID for the preference set. It will become the last component of the preference set name. The ID must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. The ID must match the regular expression `a-z?`.
        """
        return pulumi.get(self, "preference_set_id")

    @preference_set_id.setter
    def preference_set_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "preference_set_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the preference set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-friendly display name. Maximum length is 63 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="virtualMachinePreferences")
    def virtual_machine_preferences(self) -> Optional[pulumi.Input['PreferenceSetVirtualMachinePreferencesArgs']]:
        """
        VirtualMachinePreferences enables you to create sets of assumptions, for example, a geographical location and pricing track, for your migrated virtual machines. The set of preferences influence recommendations for migrating virtual machine assets.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_machine_preferences")

    @virtual_machine_preferences.setter
    def virtual_machine_preferences(self, value: Optional[pulumi.Input['PreferenceSetVirtualMachinePreferencesArgs']]):
        pulumi.set(self, "virtual_machine_preferences", value)


@pulumi.input_type
class _PreferenceSetState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 preference_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_preferences: Optional[pulumi.Input['PreferenceSetVirtualMachinePreferencesArgs']] = None):
        """
        Input properties used for looking up and filtering PreferenceSet resources.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp when the preference set was created.
        :param pulumi.Input[builtins.str] description: A description of the preference set.
        :param pulumi.Input[builtins.str] display_name: User-friendly display name. Maximum length is 63 characters.
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] name: Output only. Name of the preference set.
        :param pulumi.Input[builtins.str] preference_set_id: Required. User specified ID for the preference set. It will become the last component of the preference set name. The ID must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. The ID must match the regular expression `a-z?`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] update_time: Output only. The timestamp when the preference set was last updated.
        :param pulumi.Input['PreferenceSetVirtualMachinePreferencesArgs'] virtual_machine_preferences: VirtualMachinePreferences enables you to create sets of assumptions, for example, a geographical location and pricing track, for your migrated virtual machines. The set of preferences influence recommendations for migrating virtual machine assets.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preference_set_id is not None:
            pulumi.set(__self__, "preference_set_id", preference_set_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if virtual_machine_preferences is not None:
            pulumi.set(__self__, "virtual_machine_preferences", virtual_machine_preferences)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp when the preference set was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the preference set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-friendly display name. Maximum length is 63 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Name of the preference set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="preferenceSetId")
    def preference_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. User specified ID for the preference set. It will become the last component of the preference set name. The ID must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. The ID must match the regular expression `a-z?`.
        """
        return pulumi.get(self, "preference_set_id")

    @preference_set_id.setter
    def preference_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preference_set_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp when the preference set was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="virtualMachinePreferences")
    def virtual_machine_preferences(self) -> Optional[pulumi.Input['PreferenceSetVirtualMachinePreferencesArgs']]:
        """
        VirtualMachinePreferences enables you to create sets of assumptions, for example, a geographical location and pricing track, for your migrated virtual machines. The set of preferences influence recommendations for migrating virtual machine assets.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_machine_preferences")

    @virtual_machine_preferences.setter
    def virtual_machine_preferences(self, value: Optional[pulumi.Input['PreferenceSetVirtualMachinePreferencesArgs']]):
        pulumi.set(self, "virtual_machine_preferences", value)


@pulumi.type_token("gcp:migrationcenter/preferenceSet:PreferenceSet")
class PreferenceSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 preference_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_preferences: Optional[pulumi.Input[Union['PreferenceSetVirtualMachinePreferencesArgs', 'PreferenceSetVirtualMachinePreferencesArgsDict']]] = None,
                 __props__=None):
        """
        Manages the PreferenceSet resource.

        To get more information about PreferenceSet, see:

        * [API documentation](https://cloud.google.com/migration-center/docs/reference/rest/v1)
        * How-to Guides
            * [Managing Migration Preferences](https://cloud.google.com/migration-center/docs/migration-preferences)

        ## Example Usage

        ### Preference Set Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.migrationcenter.PreferenceSet("default",
            location="us-central1",
            preference_set_id="preference-set-test",
            description="Terraform integration test description",
            display_name="Terraform integration test display",
            virtual_machine_preferences={
                "vmware_engine_preferences": {
                    "cpu_overcommit_ratio": 1.5,
                },
                "sizing_optimization_strategy": "SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE",
                "target_product": "COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE",
            })
        ```
        ### Preference Set Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.migrationcenter.PreferenceSet("default",
            location="us-central1",
            preference_set_id="preference-set-test",
            description="Terraform integration test description",
            display_name="Terraform integration test display",
            virtual_machine_preferences={
                "vmware_engine_preferences": {
                    "cpu_overcommit_ratio": 1.5,
                    "storage_deduplication_compression_ratio": 1.3,
                    "commitment_plan": "ON_DEMAND",
                },
                "sizing_optimization_strategy": "SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE",
                "target_product": "COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE",
                "commitment_plan": "COMMITMENT_PLAN_ONE_YEAR",
                "region_preferences": {
                    "preferred_regions": ["us-central1"],
                },
                "sole_tenancy_preferences": {
                    "commitment_plan": "ON_DEMAND",
                    "cpu_overcommit_ratio": 1.2,
                    "host_maintenance_policy": "HOST_MAINTENANCE_POLICY_DEFAULT",
                    "node_types": [{
                        "node_name": "tf-test",
                    }],
                },
                "compute_engine_preferences": {
                    "license_type": "LICENSE_TYPE_BRING_YOUR_OWN_LICENSE",
                    "machine_preferences": {
                        "allowed_machine_series": [{
                            "code": "C3",
                        }],
                    },
                },
            })
        ```

        ## Import

        PreferenceSet can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/preferenceSets/{{preference_set_id}}`

        * `{{project}}/{{location}}/{{preference_set_id}}`

        * `{{location}}/{{preference_set_id}}`

        When using the `pulumi import` command, PreferenceSet can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:migrationcenter/preferenceSet:PreferenceSet default projects/{{project}}/locations/{{location}}/preferenceSets/{{preference_set_id}}
        ```

        ```sh
        $ pulumi import gcp:migrationcenter/preferenceSet:PreferenceSet default {{project}}/{{location}}/{{preference_set_id}}
        ```

        ```sh
        $ pulumi import gcp:migrationcenter/preferenceSet:PreferenceSet default {{location}}/{{preference_set_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the preference set.
        :param pulumi.Input[builtins.str] display_name: User-friendly display name. Maximum length is 63 characters.
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] preference_set_id: Required. User specified ID for the preference set. It will become the last component of the preference set name. The ID must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. The ID must match the regular expression `a-z?`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['PreferenceSetVirtualMachinePreferencesArgs', 'PreferenceSetVirtualMachinePreferencesArgsDict']] virtual_machine_preferences: VirtualMachinePreferences enables you to create sets of assumptions, for example, a geographical location and pricing track, for your migrated virtual machines. The set of preferences influence recommendations for migrating virtual machine assets.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreferenceSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the PreferenceSet resource.

        To get more information about PreferenceSet, see:

        * [API documentation](https://cloud.google.com/migration-center/docs/reference/rest/v1)
        * How-to Guides
            * [Managing Migration Preferences](https://cloud.google.com/migration-center/docs/migration-preferences)

        ## Example Usage

        ### Preference Set Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.migrationcenter.PreferenceSet("default",
            location="us-central1",
            preference_set_id="preference-set-test",
            description="Terraform integration test description",
            display_name="Terraform integration test display",
            virtual_machine_preferences={
                "vmware_engine_preferences": {
                    "cpu_overcommit_ratio": 1.5,
                },
                "sizing_optimization_strategy": "SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE",
                "target_product": "COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE",
            })
        ```
        ### Preference Set Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.migrationcenter.PreferenceSet("default",
            location="us-central1",
            preference_set_id="preference-set-test",
            description="Terraform integration test description",
            display_name="Terraform integration test display",
            virtual_machine_preferences={
                "vmware_engine_preferences": {
                    "cpu_overcommit_ratio": 1.5,
                    "storage_deduplication_compression_ratio": 1.3,
                    "commitment_plan": "ON_DEMAND",
                },
                "sizing_optimization_strategy": "SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE",
                "target_product": "COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE",
                "commitment_plan": "COMMITMENT_PLAN_ONE_YEAR",
                "region_preferences": {
                    "preferred_regions": ["us-central1"],
                },
                "sole_tenancy_preferences": {
                    "commitment_plan": "ON_DEMAND",
                    "cpu_overcommit_ratio": 1.2,
                    "host_maintenance_policy": "HOST_MAINTENANCE_POLICY_DEFAULT",
                    "node_types": [{
                        "node_name": "tf-test",
                    }],
                },
                "compute_engine_preferences": {
                    "license_type": "LICENSE_TYPE_BRING_YOUR_OWN_LICENSE",
                    "machine_preferences": {
                        "allowed_machine_series": [{
                            "code": "C3",
                        }],
                    },
                },
            })
        ```

        ## Import

        PreferenceSet can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/preferenceSets/{{preference_set_id}}`

        * `{{project}}/{{location}}/{{preference_set_id}}`

        * `{{location}}/{{preference_set_id}}`

        When using the `pulumi import` command, PreferenceSet can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:migrationcenter/preferenceSet:PreferenceSet default projects/{{project}}/locations/{{location}}/preferenceSets/{{preference_set_id}}
        ```

        ```sh
        $ pulumi import gcp:migrationcenter/preferenceSet:PreferenceSet default {{project}}/{{location}}/{{preference_set_id}}
        ```

        ```sh
        $ pulumi import gcp:migrationcenter/preferenceSet:PreferenceSet default {{location}}/{{preference_set_id}}
        ```

        :param str resource_name: The name of the resource.
        :param PreferenceSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreferenceSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 preference_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_preferences: Optional[pulumi.Input[Union['PreferenceSetVirtualMachinePreferencesArgs', 'PreferenceSetVirtualMachinePreferencesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreferenceSetArgs.__new__(PreferenceSetArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if preference_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'preference_set_id'")
            __props__.__dict__["preference_set_id"] = preference_set_id
            __props__.__dict__["project"] = project
            __props__.__dict__["virtual_machine_preferences"] = virtual_machine_preferences
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(PreferenceSet, __self__).__init__(
            'gcp:migrationcenter/preferenceSet:PreferenceSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            preference_set_id: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            virtual_machine_preferences: Optional[pulumi.Input[Union['PreferenceSetVirtualMachinePreferencesArgs', 'PreferenceSetVirtualMachinePreferencesArgsDict']]] = None) -> 'PreferenceSet':
        """
        Get an existing PreferenceSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp when the preference set was created.
        :param pulumi.Input[builtins.str] description: A description of the preference set.
        :param pulumi.Input[builtins.str] display_name: User-friendly display name. Maximum length is 63 characters.
        :param pulumi.Input[builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[builtins.str] name: Output only. Name of the preference set.
        :param pulumi.Input[builtins.str] preference_set_id: Required. User specified ID for the preference set. It will become the last component of the preference set name. The ID must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. The ID must match the regular expression `a-z?`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] update_time: Output only. The timestamp when the preference set was last updated.
        :param pulumi.Input[Union['PreferenceSetVirtualMachinePreferencesArgs', 'PreferenceSetVirtualMachinePreferencesArgsDict']] virtual_machine_preferences: VirtualMachinePreferences enables you to create sets of assumptions, for example, a geographical location and pricing track, for your migrated virtual machines. The set of preferences influence recommendations for migrating virtual machine assets.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreferenceSetState.__new__(_PreferenceSetState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["preference_set_id"] = preference_set_id
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["virtual_machine_preferences"] = virtual_machine_preferences
        return PreferenceSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp when the preference set was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the preference set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-friendly display name. Maximum length is 63 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Name of the preference set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preferenceSetId")
    def preference_set_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. User specified ID for the preference set. It will become the last component of the preference set name. The ID must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. The ID must match the regular expression `a-z?`.
        """
        return pulumi.get(self, "preference_set_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp when the preference set was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="virtualMachinePreferences")
    def virtual_machine_preferences(self) -> pulumi.Output[Optional['outputs.PreferenceSetVirtualMachinePreferences']]:
        """
        VirtualMachinePreferences enables you to create sets of assumptions, for example, a geographical location and pricing track, for your migrated virtual machines. The set of preferences influence recommendations for migrating virtual machine assets.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_machine_preferences")

