# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TemplateArgs', 'Template']

@pulumi.input_type
class TemplateArgs:
    def __init__(__self__, *,
                 filter_config: pulumi.Input['TemplateFilterConfigArgs'],
                 location: pulumi.Input[builtins.str],
                 template_id: pulumi.Input[builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template_metadata: Optional[pulumi.Input['TemplateTemplateMetadataArgs']] = None):
        """
        The set of arguments for constructing a Template resource.
        :param pulumi.Input['TemplateFilterConfigArgs'] filter_config: Filters configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] template_id: Id of the requesting object
               If auto-generating Id server-side, remove this field and
               template_id from the method_signature of Create RPC
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['TemplateTemplateMetadataArgs'] template_metadata: Message describing TemplateMetadata
               Structure is documented below.
        """
        pulumi.set(__self__, "filter_config", filter_config)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "template_id", template_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if template_metadata is not None:
            pulumi.set(__self__, "template_metadata", template_metadata)

    @property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> pulumi.Input['TemplateFilterConfigArgs']:
        """
        Filters configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_config")

    @filter_config.setter
    def filter_config(self, value: pulumi.Input['TemplateFilterConfigArgs']):
        pulumi.set(self, "filter_config", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the requesting object
        If auto-generating Id server-side, remove this field and
        template_id from the method_signature of Create RPC
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="templateMetadata")
    def template_metadata(self) -> Optional[pulumi.Input['TemplateTemplateMetadataArgs']]:
        """
        Message describing TemplateMetadata
        Structure is documented below.
        """
        return pulumi.get(self, "template_metadata")

    @template_metadata.setter
    def template_metadata(self, value: Optional[pulumi.Input['TemplateTemplateMetadataArgs']]):
        pulumi.set(self, "template_metadata", value)


@pulumi.input_type
class _TemplateState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 filter_config: Optional[pulumi.Input['TemplateFilterConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 template_metadata: Optional[pulumi.Input['TemplateTemplateMetadataArgs']] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Template resources.
        :param pulumi.Input[builtins.str] create_time: Create time stamp
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['TemplateFilterConfigArgs'] filter_config: Filters configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Identifier. name of resource
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] template_id: Id of the requesting object
               If auto-generating Id server-side, remove this field and
               template_id from the method_signature of Create RPC
        :param pulumi.Input['TemplateTemplateMetadataArgs'] template_metadata: Message describing TemplateMetadata
               Structure is documented below.
        :param pulumi.Input[builtins.str] update_time: Update time stamp
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if filter_config is not None:
            pulumi.set(__self__, "filter_config", filter_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if template_metadata is not None:
            pulumi.set(__self__, "template_metadata", template_metadata)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Create time stamp
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> Optional[pulumi.Input['TemplateFilterConfigArgs']]:
        """
        Filters configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_config")

    @filter_config.setter
    def filter_config(self, value: Optional[pulumi.Input['TemplateFilterConfigArgs']]):
        pulumi.set(self, "filter_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. name of resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the requesting object
        If auto-generating Id server-side, remove this field and
        template_id from the method_signature of Create RPC
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter(name="templateMetadata")
    def template_metadata(self) -> Optional[pulumi.Input['TemplateTemplateMetadataArgs']]:
        """
        Message describing TemplateMetadata
        Structure is documented below.
        """
        return pulumi.get(self, "template_metadata")

    @template_metadata.setter
    def template_metadata(self, value: Optional[pulumi.Input['TemplateTemplateMetadataArgs']]):
        pulumi.set(self, "template_metadata", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Update time stamp
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:modelarmor/template:Template")
class Template(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_config: Optional[pulumi.Input[Union['TemplateFilterConfigArgs', 'TemplateFilterConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 template_metadata: Optional[pulumi.Input[Union['TemplateTemplateMetadataArgs', 'TemplateTemplateMetadataArgsDict']]] = None,
                 __props__=None):
        """
        A `Template` is a resource of Model Armor that lets you configure how Model Armor screens prompts and responses.
        It functions as sets of customized filters and thresholds for different safety and security confidence levels, allowing control over what content is flagged.

        ## Example Usage

        ### Modelarmor Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        template_basic = gcp.modelarmor.Template("template-basic",
            location="<no value>",
            template_id="<no value>",
            filter_config={},
            template_metadata={})
        ```
        ## Import

        Template can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/templates/{{template_id}}`

        * `{{project}}/{{location}}/{{template_id}}`

        * `{{location}}/{{template_id}}`

        When using the `pulumi import` command, Template can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:modelarmor/template:Template default projects/{{project}}/locations/{{location}}/templates/{{template_id}}
        ```

        ```sh
        $ pulumi import gcp:modelarmor/template:Template default {{project}}/{{location}}/{{template_id}}
        ```

        ```sh
        $ pulumi import gcp:modelarmor/template:Template default {{location}}/{{template_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TemplateFilterConfigArgs', 'TemplateFilterConfigArgsDict']] filter_config: Filters configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] template_id: Id of the requesting object
               If auto-generating Id server-side, remove this field and
               template_id from the method_signature of Create RPC
        :param pulumi.Input[Union['TemplateTemplateMetadataArgs', 'TemplateTemplateMetadataArgsDict']] template_metadata: Message describing TemplateMetadata
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A `Template` is a resource of Model Armor that lets you configure how Model Armor screens prompts and responses.
        It functions as sets of customized filters and thresholds for different safety and security confidence levels, allowing control over what content is flagged.

        ## Example Usage

        ### Modelarmor Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        template_basic = gcp.modelarmor.Template("template-basic",
            location="<no value>",
            template_id="<no value>",
            filter_config={},
            template_metadata={})
        ```
        ## Import

        Template can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/templates/{{template_id}}`

        * `{{project}}/{{location}}/{{template_id}}`

        * `{{location}}/{{template_id}}`

        When using the `pulumi import` command, Template can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:modelarmor/template:Template default projects/{{project}}/locations/{{location}}/templates/{{template_id}}
        ```

        ```sh
        $ pulumi import gcp:modelarmor/template:Template default {{project}}/{{location}}/{{template_id}}
        ```

        ```sh
        $ pulumi import gcp:modelarmor/template:Template default {{location}}/{{template_id}}
        ```

        :param str resource_name: The name of the resource.
        :param TemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter_config: Optional[pulumi.Input[Union['TemplateFilterConfigArgs', 'TemplateFilterConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 template_metadata: Optional[pulumi.Input[Union['TemplateTemplateMetadataArgs', 'TemplateTemplateMetadataArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateArgs.__new__(TemplateArgs)

            if filter_config is None and not opts.urn:
                raise TypeError("Missing required property 'filter_config'")
            __props__.__dict__["filter_config"] = filter_config
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if template_id is None and not opts.urn:
                raise TypeError("Missing required property 'template_id'")
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["template_metadata"] = template_metadata
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Template, __self__).__init__(
            'gcp:modelarmor/template:Template',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            filter_config: Optional[pulumi.Input[Union['TemplateFilterConfigArgs', 'TemplateFilterConfigArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            template_id: Optional[pulumi.Input[builtins.str]] = None,
            template_metadata: Optional[pulumi.Input[Union['TemplateTemplateMetadataArgs', 'TemplateTemplateMetadataArgsDict']]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Template':
        """
        Get an existing Template resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Create time stamp
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['TemplateFilterConfigArgs', 'TemplateFilterConfigArgsDict']] filter_config: Filters configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Identifier. name of resource
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] template_id: Id of the requesting object
               If auto-generating Id server-side, remove this field and
               template_id from the method_signature of Create RPC
        :param pulumi.Input[Union['TemplateTemplateMetadataArgs', 'TemplateTemplateMetadataArgsDict']] template_metadata: Message describing TemplateMetadata
               Structure is documented below.
        :param pulumi.Input[builtins.str] update_time: Update time stamp
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TemplateState.__new__(_TemplateState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["filter_config"] = filter_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["template_metadata"] = template_metadata
        __props__.__dict__["update_time"] = update_time
        return Template(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Create time stamp
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> pulumi.Output['outputs.TemplateFilterConfig']:
        """
        Filters configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "filter_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. name of resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the requesting object
        If auto-generating Id server-side, remove this field and
        template_id from the method_signature of Create RPC
        """
        return pulumi.get(self, "template_id")

    @property
    @pulumi.getter(name="templateMetadata")
    def template_metadata(self) -> pulumi.Output[Optional['outputs.TemplateTemplateMetadata']]:
        """
        Message describing TemplateMetadata
        Structure is documented below.
        """
        return pulumi.get(self, "template_metadata")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Update time stamp
        """
        return pulumi.get(self, "update_time")

