# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ActiveDirectoryArgs', 'ActiveDirectory']

@pulumi.input_type
class ActiveDirectoryArgs:
    def __init__(__self__, *,
                 dns: pulumi.Input[builtins.str],
                 domain: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 net_bios_prefix: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 aes_encryption: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encrypt_dc_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 kdc_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 kdc_ip: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ldap_signing: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nfs_users_with_ldap: Optional[pulumi.Input[builtins.bool]] = None,
                 organizational_unit: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 site: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ActiveDirectory resource.
        :param pulumi.Input[builtins.str] dns: Comma separated list of DNS server IP addresses for the Active Directory domain.
        :param pulumi.Input[builtins.str] domain: Fully qualified domain name for the Active Directory domain.
        :param pulumi.Input[builtins.str] location: Name of the region for the policy to apply to.
        :param pulumi.Input[builtins.str] net_bios_prefix: NetBIOS name prefix of the server to be created.
               A five-character random ID is generated automatically, for example, -6f9a, and appended to the prefix. The full UNC share path will have the following format:
               `\\\\NetBIOS_PREFIX-ABCD.DOMAIN_NAME\\SHARE_NAME`
        :param pulumi.Input[builtins.str] username: Username for the Active Directory account with permissions to create the compute account within the specified organizational unit.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] administrators: Domain user accounts to be added to the local Administrators group of the SMB service. Comma-separated list of domain users or groups. The Domain Admin group is automatically added when the service joins your domain as a hidden group.
        :param pulumi.Input[builtins.bool] aes_encryption: Enables AES-128 and AES-256 encryption for Kerberos-based communication with Active Directory.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_operators: Domain user/group accounts to be added to the Backup Operators group of the SMB service. The Backup Operators group allows members to backup and restore files regardless of whether they have read or write access to the files. Comma-separated list.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.bool] encrypt_dc_connections: If enabled, traffic between the SMB server to Domain Controller (DC) will be encrypted.
        :param pulumi.Input[builtins.str] kdc_hostname: Hostname of the Active Directory server used as Kerberos Key Distribution Center. Only required for volumes using kerberized NFSv4.1
        :param pulumi.Input[builtins.str] kdc_ip: IP address of the Active Directory server used as Kerberos Key Distribution Center.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.bool] ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
        :param pulumi.Input[builtins.str] name: The resource name of the Active Directory pool. Needs to be unique per location.
        :param pulumi.Input[builtins.bool] nfs_users_with_ldap: Local UNIX users on clients without valid user information in Active Directory are blocked from access to LDAP enabled volumes.
               This option can be used to temporarily switch such volumes to AUTH_SYS authentication (user ID + 1-16 groups).
        :param pulumi.Input[builtins.str] organizational_unit: Name of the Organizational Unit where you intend to create the computer account for NetApp Volumes.
               Defaults to `CN=Computers` if left empty.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_operators: Domain accounts that require elevated privileges such as `SeSecurityPrivilege` to manage security logs. Comma-separated list.
        :param pulumi.Input[builtins.str] site: Specifies an Active Directory site to manage domain controller selection.
               Use when Active Directory domain controllers in multiple regions are configured. Defaults to `Default-First-Site-Name` if left empty.
        """
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "net_bios_prefix", net_bios_prefix)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if administrators is not None:
            pulumi.set(__self__, "administrators", administrators)
        if aes_encryption is not None:
            pulumi.set(__self__, "aes_encryption", aes_encryption)
        if backup_operators is not None:
            pulumi.set(__self__, "backup_operators", backup_operators)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_dc_connections is not None:
            pulumi.set(__self__, "encrypt_dc_connections", encrypt_dc_connections)
        if kdc_hostname is not None:
            pulumi.set(__self__, "kdc_hostname", kdc_hostname)
        if kdc_ip is not None:
            pulumi.set(__self__, "kdc_ip", kdc_ip)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if ldap_signing is not None:
            pulumi.set(__self__, "ldap_signing", ldap_signing)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_users_with_ldap is not None:
            pulumi.set(__self__, "nfs_users_with_ldap", nfs_users_with_ldap)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_operators is not None:
            pulumi.set(__self__, "security_operators", security_operators)
        if site is not None:
            pulumi.set(__self__, "site", site)

    @property
    @pulumi.getter
    def dns(self) -> pulumi.Input[builtins.str]:
        """
        Comma separated list of DNS server IP addresses for the Active Directory domain.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[builtins.str]:
        """
        Fully qualified domain name for the Active Directory domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Name of the region for the policy to apply to.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="netBiosPrefix")
    def net_bios_prefix(self) -> pulumi.Input[builtins.str]:
        """
        NetBIOS name prefix of the server to be created.
        A five-character random ID is generated automatically, for example, -6f9a, and appended to the prefix. The full UNC share path will have the following format:
        `\\\\NetBIOS_PREFIX-ABCD.DOMAIN_NAME\\SHARE_NAME`
        """
        return pulumi.get(self, "net_bios_prefix")

    @net_bios_prefix.setter
    def net_bios_prefix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "net_bios_prefix", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Username for the Active Directory account with permissions to create the compute account within the specified organizational unit.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def administrators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Domain user accounts to be added to the local Administrators group of the SMB service. Comma-separated list of domain users or groups. The Domain Admin group is automatically added when the service joins your domain as a hidden group.
        """
        return pulumi.get(self, "administrators")

    @administrators.setter
    def administrators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "administrators", value)

    @property
    @pulumi.getter(name="aesEncryption")
    def aes_encryption(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables AES-128 and AES-256 encryption for Kerberos-based communication with Active Directory.
        """
        return pulumi.get(self, "aes_encryption")

    @aes_encryption.setter
    def aes_encryption(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aes_encryption", value)

    @property
    @pulumi.getter(name="backupOperators")
    def backup_operators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Domain user/group accounts to be added to the Backup Operators group of the SMB service. The Backup Operators group allows members to backup and restore files regardless of whether they have read or write access to the files. Comma-separated list.
        """
        return pulumi.get(self, "backup_operators")

    @backup_operators.setter
    def backup_operators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backup_operators", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptDcConnections")
    def encrypt_dc_connections(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, traffic between the SMB server to Domain Controller (DC) will be encrypted.
        """
        return pulumi.get(self, "encrypt_dc_connections")

    @encrypt_dc_connections.setter
    def encrypt_dc_connections(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypt_dc_connections", value)

    @property
    @pulumi.getter(name="kdcHostname")
    def kdc_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname of the Active Directory server used as Kerberos Key Distribution Center. Only required for volumes using kerberized NFSv4.1
        """
        return pulumi.get(self, "kdc_hostname")

    @kdc_hostname.setter
    def kdc_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kdc_hostname", value)

    @property
    @pulumi.getter(name="kdcIp")
    def kdc_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address of the Active Directory server used as Kerberos Key Distribution Center.
        """
        return pulumi.get(self, "kdc_ip")

    @kdc_ip.setter
    def kdc_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kdc_ip", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="ldapSigning")
    def ldap_signing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether or not the LDAP traffic needs to be signed.
        """
        return pulumi.get(self, "ldap_signing")

    @ldap_signing.setter
    def ldap_signing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ldap_signing", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Active Directory pool. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nfsUsersWithLdap")
    def nfs_users_with_ldap(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Local UNIX users on clients without valid user information in Active Directory are blocked from access to LDAP enabled volumes.
        This option can be used to temporarily switch such volumes to AUTH_SYS authentication (user ID + 1-16 groups).
        """
        return pulumi.get(self, "nfs_users_with_ldap")

    @nfs_users_with_ldap.setter
    def nfs_users_with_ldap(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "nfs_users_with_ldap", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Organizational Unit where you intend to create the computer account for NetApp Volumes.
        Defaults to `CN=Computers` if left empty.
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="securityOperators")
    def security_operators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Domain accounts that require elevated privileges such as `SeSecurityPrivilege` to manage security logs. Comma-separated list.
        """
        return pulumi.get(self, "security_operators")

    @security_operators.setter
    def security_operators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_operators", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an Active Directory site to manage domain controller selection.
        Use when Active Directory domain controllers in multiple regions are configured. Defaults to `Default-First-Site-Name` if left empty.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "site", value)


@pulumi.input_type
class _ActiveDirectoryState:
    def __init__(__self__, *,
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 aes_encryption: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dns: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 encrypt_dc_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 kdc_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 kdc_ip: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ldap_signing: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 net_bios_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 nfs_users_with_ldap: Optional[pulumi.Input[builtins.bool]] = None,
                 organizational_unit: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 security_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 site: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_details: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActiveDirectory resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] administrators: Domain user accounts to be added to the local Administrators group of the SMB service. Comma-separated list of domain users or groups. The Domain Admin group is automatically added when the service joins your domain as a hidden group.
        :param pulumi.Input[builtins.bool] aes_encryption: Enables AES-128 and AES-256 encryption for Kerberos-based communication with Active Directory.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_operators: Domain user/group accounts to be added to the Backup Operators group of the SMB service. The Backup Operators group allows members to backup and restore files regardless of whether they have read or write access to the files. Comma-separated list.
        :param pulumi.Input[builtins.str] create_time: Create time of the active directory. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] dns: Comma separated list of DNS server IP addresses for the Active Directory domain.
        :param pulumi.Input[builtins.str] domain: Fully qualified domain name for the Active Directory domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] encrypt_dc_connections: If enabled, traffic between the SMB server to Domain Controller (DC) will be encrypted.
        :param pulumi.Input[builtins.str] kdc_hostname: Hostname of the Active Directory server used as Kerberos Key Distribution Center. Only required for volumes using kerberized NFSv4.1
        :param pulumi.Input[builtins.str] kdc_ip: IP address of the Active Directory server used as Kerberos Key Distribution Center.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.bool] ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
        :param pulumi.Input[builtins.str] location: Name of the region for the policy to apply to.
        :param pulumi.Input[builtins.str] name: The resource name of the Active Directory pool. Needs to be unique per location.
        :param pulumi.Input[builtins.str] net_bios_prefix: NetBIOS name prefix of the server to be created.
               A five-character random ID is generated automatically, for example, -6f9a, and appended to the prefix. The full UNC share path will have the following format:
               `\\\\NetBIOS_PREFIX-ABCD.DOMAIN_NAME\\SHARE_NAME`
        :param pulumi.Input[builtins.bool] nfs_users_with_ldap: Local UNIX users on clients without valid user information in Active Directory are blocked from access to LDAP enabled volumes.
               This option can be used to temporarily switch such volumes to AUTH_SYS authentication (user ID + 1-16 groups).
        :param pulumi.Input[builtins.str] organizational_unit: Name of the Organizational Unit where you intend to create the computer account for NetApp Volumes.
               Defaults to `CN=Computers` if left empty.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_operators: Domain accounts that require elevated privileges such as `SeSecurityPrivilege` to manage security logs. Comma-separated list.
        :param pulumi.Input[builtins.str] site: Specifies an Active Directory site to manage domain controller selection.
               Use when Active Directory domain controllers in multiple regions are configured. Defaults to `Default-First-Site-Name` if left empty.
        :param pulumi.Input[builtins.str] state: The state of the Active Directory policy (not the Active Directory itself).
        :param pulumi.Input[builtins.str] state_details: The state details of the Active Directory.
        :param pulumi.Input[builtins.str] username: Username for the Active Directory account with permissions to create the compute account within the specified organizational unit.
        """
        if administrators is not None:
            pulumi.set(__self__, "administrators", administrators)
        if aes_encryption is not None:
            pulumi.set(__self__, "aes_encryption", aes_encryption)
        if backup_operators is not None:
            pulumi.set(__self__, "backup_operators", backup_operators)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if encrypt_dc_connections is not None:
            pulumi.set(__self__, "encrypt_dc_connections", encrypt_dc_connections)
        if kdc_hostname is not None:
            pulumi.set(__self__, "kdc_hostname", kdc_hostname)
        if kdc_ip is not None:
            pulumi.set(__self__, "kdc_ip", kdc_ip)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if ldap_signing is not None:
            pulumi.set(__self__, "ldap_signing", ldap_signing)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if net_bios_prefix is not None:
            pulumi.set(__self__, "net_bios_prefix", net_bios_prefix)
        if nfs_users_with_ldap is not None:
            pulumi.set(__self__, "nfs_users_with_ldap", nfs_users_with_ldap)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if security_operators is not None:
            pulumi.set(__self__, "security_operators", security_operators)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def administrators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Domain user accounts to be added to the local Administrators group of the SMB service. Comma-separated list of domain users or groups. The Domain Admin group is automatically added when the service joins your domain as a hidden group.
        """
        return pulumi.get(self, "administrators")

    @administrators.setter
    def administrators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "administrators", value)

    @property
    @pulumi.getter(name="aesEncryption")
    def aes_encryption(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables AES-128 and AES-256 encryption for Kerberos-based communication with Active Directory.
        """
        return pulumi.get(self, "aes_encryption")

    @aes_encryption.setter
    def aes_encryption(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aes_encryption", value)

    @property
    @pulumi.getter(name="backupOperators")
    def backup_operators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Domain user/group accounts to be added to the Backup Operators group of the SMB service. The Backup Operators group allows members to backup and restore files regardless of whether they have read or write access to the files. Comma-separated list.
        """
        return pulumi.get(self, "backup_operators")

    @backup_operators.setter
    def backup_operators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backup_operators", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Create time of the active directory. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Comma separated list of DNS server IP addresses for the Active Directory domain.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified domain name for the Active Directory domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="encryptDcConnections")
    def encrypt_dc_connections(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, traffic between the SMB server to Domain Controller (DC) will be encrypted.
        """
        return pulumi.get(self, "encrypt_dc_connections")

    @encrypt_dc_connections.setter
    def encrypt_dc_connections(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypt_dc_connections", value)

    @property
    @pulumi.getter(name="kdcHostname")
    def kdc_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname of the Active Directory server used as Kerberos Key Distribution Center. Only required for volumes using kerberized NFSv4.1
        """
        return pulumi.get(self, "kdc_hostname")

    @kdc_hostname.setter
    def kdc_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kdc_hostname", value)

    @property
    @pulumi.getter(name="kdcIp")
    def kdc_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address of the Active Directory server used as Kerberos Key Distribution Center.
        """
        return pulumi.get(self, "kdc_ip")

    @kdc_ip.setter
    def kdc_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kdc_ip", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="ldapSigning")
    def ldap_signing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether or not the LDAP traffic needs to be signed.
        """
        return pulumi.get(self, "ldap_signing")

    @ldap_signing.setter
    def ldap_signing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ldap_signing", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the region for the policy to apply to.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Active Directory pool. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="netBiosPrefix")
    def net_bios_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        NetBIOS name prefix of the server to be created.
        A five-character random ID is generated automatically, for example, -6f9a, and appended to the prefix. The full UNC share path will have the following format:
        `\\\\NetBIOS_PREFIX-ABCD.DOMAIN_NAME\\SHARE_NAME`
        """
        return pulumi.get(self, "net_bios_prefix")

    @net_bios_prefix.setter
    def net_bios_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "net_bios_prefix", value)

    @property
    @pulumi.getter(name="nfsUsersWithLdap")
    def nfs_users_with_ldap(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Local UNIX users on clients without valid user information in Active Directory are blocked from access to LDAP enabled volumes.
        This option can be used to temporarily switch such volumes to AUTH_SYS authentication (user ID + 1-16 groups).
        """
        return pulumi.get(self, "nfs_users_with_ldap")

    @nfs_users_with_ldap.setter
    def nfs_users_with_ldap(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "nfs_users_with_ldap", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Organizational Unit where you intend to create the computer account for NetApp Volumes.
        Defaults to `CN=Computers` if left empty.
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="securityOperators")
    def security_operators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Domain accounts that require elevated privileges such as `SeSecurityPrivilege` to manage security logs. Comma-separated list.
        """
        return pulumi.get(self, "security_operators")

    @security_operators.setter
    def security_operators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_operators", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an Active Directory site to manage domain controller selection.
        Use when Active Directory domain controllers in multiple regions are configured. Defaults to `Default-First-Site-Name` if left empty.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the Active Directory policy (not the Active Directory itself).
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state details of the Active Directory.
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_details", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username for the Active Directory account with permissions to create the compute account within the specified organizational unit.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("gcp:netapp/activeDirectory:ActiveDirectory")
class ActiveDirectory(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 aes_encryption: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dns: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 encrypt_dc_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 kdc_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 kdc_ip: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ldap_signing: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 net_bios_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 nfs_users_with_ldap: Optional[pulumi.Input[builtins.bool]] = None,
                 organizational_unit: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 site: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ActiveDirectory is the public representation of the active directory config.

        To get more information about ActiveDirectory, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.activeDirectories)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/netapp/volumes/docs/configure-and-use/active-directory/about-ad)

        ## Example Usage

        ### Netapp Active Directory Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_active_directory_full = gcp.netapp.ActiveDirectory("test_active_directory_full",
            name="test-active-directory-full",
            location="us-central1",
            domain="ad.internal",
            dns="172.30.64.3",
            net_bios_prefix="smbserver",
            username="user",
            password="pass",
            aes_encryption=False,
            backup_operators=[
                "test1",
                "test2",
            ],
            administrators=[
                "test1",
                "test2",
            ],
            description="ActiveDirectory is the public representation of the active directory config.",
            encrypt_dc_connections=False,
            kdc_hostname="hostname",
            kdc_ip="10.10.0.11",
            labels={
                "foo": "bar",
            },
            ldap_signing=False,
            nfs_users_with_ldap=False,
            organizational_unit="CN=Computers",
            security_operators=[
                "test1",
                "test2",
            ],
            site="test-site")
        ```

        ## Import

        ActiveDirectory can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ActiveDirectory can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/activeDirectory:ActiveDirectory default projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/activeDirectory:ActiveDirectory default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/activeDirectory:ActiveDirectory default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] administrators: Domain user accounts to be added to the local Administrators group of the SMB service. Comma-separated list of domain users or groups. The Domain Admin group is automatically added when the service joins your domain as a hidden group.
        :param pulumi.Input[builtins.bool] aes_encryption: Enables AES-128 and AES-256 encryption for Kerberos-based communication with Active Directory.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_operators: Domain user/group accounts to be added to the Backup Operators group of the SMB service. The Backup Operators group allows members to backup and restore files regardless of whether they have read or write access to the files. Comma-separated list.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] dns: Comma separated list of DNS server IP addresses for the Active Directory domain.
        :param pulumi.Input[builtins.str] domain: Fully qualified domain name for the Active Directory domain.
        :param pulumi.Input[builtins.bool] encrypt_dc_connections: If enabled, traffic between the SMB server to Domain Controller (DC) will be encrypted.
        :param pulumi.Input[builtins.str] kdc_hostname: Hostname of the Active Directory server used as Kerberos Key Distribution Center. Only required for volumes using kerberized NFSv4.1
        :param pulumi.Input[builtins.str] kdc_ip: IP address of the Active Directory server used as Kerberos Key Distribution Center.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.bool] ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
        :param pulumi.Input[builtins.str] location: Name of the region for the policy to apply to.
        :param pulumi.Input[builtins.str] name: The resource name of the Active Directory pool. Needs to be unique per location.
        :param pulumi.Input[builtins.str] net_bios_prefix: NetBIOS name prefix of the server to be created.
               A five-character random ID is generated automatically, for example, -6f9a, and appended to the prefix. The full UNC share path will have the following format:
               `\\\\NetBIOS_PREFIX-ABCD.DOMAIN_NAME\\SHARE_NAME`
        :param pulumi.Input[builtins.bool] nfs_users_with_ldap: Local UNIX users on clients without valid user information in Active Directory are blocked from access to LDAP enabled volumes.
               This option can be used to temporarily switch such volumes to AUTH_SYS authentication (user ID + 1-16 groups).
        :param pulumi.Input[builtins.str] organizational_unit: Name of the Organizational Unit where you intend to create the computer account for NetApp Volumes.
               Defaults to `CN=Computers` if left empty.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_operators: Domain accounts that require elevated privileges such as `SeSecurityPrivilege` to manage security logs. Comma-separated list.
        :param pulumi.Input[builtins.str] site: Specifies an Active Directory site to manage domain controller selection.
               Use when Active Directory domain controllers in multiple regions are configured. Defaults to `Default-First-Site-Name` if left empty.
        :param pulumi.Input[builtins.str] username: Username for the Active Directory account with permissions to create the compute account within the specified organizational unit.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActiveDirectoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ActiveDirectory is the public representation of the active directory config.

        To get more information about ActiveDirectory, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.activeDirectories)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/netapp/volumes/docs/configure-and-use/active-directory/about-ad)

        ## Example Usage

        ### Netapp Active Directory Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_active_directory_full = gcp.netapp.ActiveDirectory("test_active_directory_full",
            name="test-active-directory-full",
            location="us-central1",
            domain="ad.internal",
            dns="172.30.64.3",
            net_bios_prefix="smbserver",
            username="user",
            password="pass",
            aes_encryption=False,
            backup_operators=[
                "test1",
                "test2",
            ],
            administrators=[
                "test1",
                "test2",
            ],
            description="ActiveDirectory is the public representation of the active directory config.",
            encrypt_dc_connections=False,
            kdc_hostname="hostname",
            kdc_ip="10.10.0.11",
            labels={
                "foo": "bar",
            },
            ldap_signing=False,
            nfs_users_with_ldap=False,
            organizational_unit="CN=Computers",
            security_operators=[
                "test1",
                "test2",
            ],
            site="test-site")
        ```

        ## Import

        ActiveDirectory can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ActiveDirectory can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/activeDirectory:ActiveDirectory default projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/activeDirectory:ActiveDirectory default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/activeDirectory:ActiveDirectory default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ActiveDirectoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActiveDirectoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 aes_encryption: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dns: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 encrypt_dc_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 kdc_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 kdc_ip: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ldap_signing: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 net_bios_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 nfs_users_with_ldap: Optional[pulumi.Input[builtins.bool]] = None,
                 organizational_unit: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 security_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 site: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActiveDirectoryArgs.__new__(ActiveDirectoryArgs)

            __props__.__dict__["administrators"] = administrators
            __props__.__dict__["aes_encryption"] = aes_encryption
            __props__.__dict__["backup_operators"] = backup_operators
            __props__.__dict__["description"] = description
            if dns is None and not opts.urn:
                raise TypeError("Missing required property 'dns'")
            __props__.__dict__["dns"] = dns
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["encrypt_dc_connections"] = encrypt_dc_connections
            __props__.__dict__["kdc_hostname"] = kdc_hostname
            __props__.__dict__["kdc_ip"] = kdc_ip
            __props__.__dict__["labels"] = labels
            __props__.__dict__["ldap_signing"] = ldap_signing
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if net_bios_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'net_bios_prefix'")
            __props__.__dict__["net_bios_prefix"] = net_bios_prefix
            __props__.__dict__["nfs_users_with_ldap"] = nfs_users_with_ldap
            __props__.__dict__["organizational_unit"] = organizational_unit
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["project"] = project
            __props__.__dict__["security_operators"] = security_operators
            __props__.__dict__["site"] = site
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_details"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "password", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ActiveDirectory, __self__).__init__(
            'gcp:netapp/activeDirectory:ActiveDirectory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            aes_encryption: Optional[pulumi.Input[builtins.bool]] = None,
            backup_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dns: Optional[pulumi.Input[builtins.str]] = None,
            domain: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            encrypt_dc_connections: Optional[pulumi.Input[builtins.bool]] = None,
            kdc_hostname: Optional[pulumi.Input[builtins.str]] = None,
            kdc_ip: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            ldap_signing: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            net_bios_prefix: Optional[pulumi.Input[builtins.str]] = None,
            nfs_users_with_ldap: Optional[pulumi.Input[builtins.bool]] = None,
            organizational_unit: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            security_operators: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            site: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_details: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'ActiveDirectory':
        """
        Get an existing ActiveDirectory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] administrators: Domain user accounts to be added to the local Administrators group of the SMB service. Comma-separated list of domain users or groups. The Domain Admin group is automatically added when the service joins your domain as a hidden group.
        :param pulumi.Input[builtins.bool] aes_encryption: Enables AES-128 and AES-256 encryption for Kerberos-based communication with Active Directory.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_operators: Domain user/group accounts to be added to the Backup Operators group of the SMB service. The Backup Operators group allows members to backup and restore files regardless of whether they have read or write access to the files. Comma-separated list.
        :param pulumi.Input[builtins.str] create_time: Create time of the active directory. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] dns: Comma separated list of DNS server IP addresses for the Active Directory domain.
        :param pulumi.Input[builtins.str] domain: Fully qualified domain name for the Active Directory domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] encrypt_dc_connections: If enabled, traffic between the SMB server to Domain Controller (DC) will be encrypted.
        :param pulumi.Input[builtins.str] kdc_hostname: Hostname of the Active Directory server used as Kerberos Key Distribution Center. Only required for volumes using kerberized NFSv4.1
        :param pulumi.Input[builtins.str] kdc_ip: IP address of the Active Directory server used as Kerberos Key Distribution Center.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.bool] ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
        :param pulumi.Input[builtins.str] location: Name of the region for the policy to apply to.
        :param pulumi.Input[builtins.str] name: The resource name of the Active Directory pool. Needs to be unique per location.
        :param pulumi.Input[builtins.str] net_bios_prefix: NetBIOS name prefix of the server to be created.
               A five-character random ID is generated automatically, for example, -6f9a, and appended to the prefix. The full UNC share path will have the following format:
               `\\\\NetBIOS_PREFIX-ABCD.DOMAIN_NAME\\SHARE_NAME`
        :param pulumi.Input[builtins.bool] nfs_users_with_ldap: Local UNIX users on clients without valid user information in Active Directory are blocked from access to LDAP enabled volumes.
               This option can be used to temporarily switch such volumes to AUTH_SYS authentication (user ID + 1-16 groups).
        :param pulumi.Input[builtins.str] organizational_unit: Name of the Organizational Unit where you intend to create the computer account for NetApp Volumes.
               Defaults to `CN=Computers` if left empty.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_operators: Domain accounts that require elevated privileges such as `SeSecurityPrivilege` to manage security logs. Comma-separated list.
        :param pulumi.Input[builtins.str] site: Specifies an Active Directory site to manage domain controller selection.
               Use when Active Directory domain controllers in multiple regions are configured. Defaults to `Default-First-Site-Name` if left empty.
        :param pulumi.Input[builtins.str] state: The state of the Active Directory policy (not the Active Directory itself).
        :param pulumi.Input[builtins.str] state_details: The state details of the Active Directory.
        :param pulumi.Input[builtins.str] username: Username for the Active Directory account with permissions to create the compute account within the specified organizational unit.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActiveDirectoryState.__new__(_ActiveDirectoryState)

        __props__.__dict__["administrators"] = administrators
        __props__.__dict__["aes_encryption"] = aes_encryption
        __props__.__dict__["backup_operators"] = backup_operators
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dns"] = dns
        __props__.__dict__["domain"] = domain
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["encrypt_dc_connections"] = encrypt_dc_connections
        __props__.__dict__["kdc_hostname"] = kdc_hostname
        __props__.__dict__["kdc_ip"] = kdc_ip
        __props__.__dict__["labels"] = labels
        __props__.__dict__["ldap_signing"] = ldap_signing
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["net_bios_prefix"] = net_bios_prefix
        __props__.__dict__["nfs_users_with_ldap"] = nfs_users_with_ldap
        __props__.__dict__["organizational_unit"] = organizational_unit
        __props__.__dict__["password"] = password
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["security_operators"] = security_operators
        __props__.__dict__["site"] = site
        __props__.__dict__["state"] = state
        __props__.__dict__["state_details"] = state_details
        __props__.__dict__["username"] = username
        return ActiveDirectory(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def administrators(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Domain user accounts to be added to the local Administrators group of the SMB service. Comma-separated list of domain users or groups. The Domain Admin group is automatically added when the service joins your domain as a hidden group.
        """
        return pulumi.get(self, "administrators")

    @property
    @pulumi.getter(name="aesEncryption")
    def aes_encryption(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables AES-128 and AES-256 encryption for Kerberos-based communication with Active Directory.
        """
        return pulumi.get(self, "aes_encryption")

    @property
    @pulumi.getter(name="backupOperators")
    def backup_operators(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Domain user/group accounts to be added to the Backup Operators group of the SMB service. The Backup Operators group allows members to backup and restore files regardless of whether they have read or write access to the files. Comma-separated list.
        """
        return pulumi.get(self, "backup_operators")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Create time of the active directory. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dns(self) -> pulumi.Output[builtins.str]:
        """
        Comma separated list of DNS server IP addresses for the Active Directory domain.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[builtins.str]:
        """
        Fully qualified domain name for the Active Directory domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="encryptDcConnections")
    def encrypt_dc_connections(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If enabled, traffic between the SMB server to Domain Controller (DC) will be encrypted.
        """
        return pulumi.get(self, "encrypt_dc_connections")

    @property
    @pulumi.getter(name="kdcHostname")
    def kdc_hostname(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Hostname of the Active Directory server used as Kerberos Key Distribution Center. Only required for volumes using kerberized NFSv4.1
        """
        return pulumi.get(self, "kdc_hostname")

    @property
    @pulumi.getter(name="kdcIp")
    def kdc_ip(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP address of the Active Directory server used as Kerberos Key Distribution Center.
        """
        return pulumi.get(self, "kdc_ip")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="ldapSigning")
    def ldap_signing(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether or not the LDAP traffic needs to be signed.
        """
        return pulumi.get(self, "ldap_signing")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Name of the region for the policy to apply to.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the Active Directory pool. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="netBiosPrefix")
    def net_bios_prefix(self) -> pulumi.Output[builtins.str]:
        """
        NetBIOS name prefix of the server to be created.
        A five-character random ID is generated automatically, for example, -6f9a, and appended to the prefix. The full UNC share path will have the following format:
        `\\\\NetBIOS_PREFIX-ABCD.DOMAIN_NAME\\SHARE_NAME`
        """
        return pulumi.get(self, "net_bios_prefix")

    @property
    @pulumi.getter(name="nfsUsersWithLdap")
    def nfs_users_with_ldap(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Local UNIX users on clients without valid user information in Active Directory are blocked from access to LDAP enabled volumes.
        This option can be used to temporarily switch such volumes to AUTH_SYS authentication (user ID + 1-16 groups).
        """
        return pulumi.get(self, "nfs_users_with_ldap")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Organizational Unit where you intend to create the computer account for NetApp Volumes.
        Defaults to `CN=Computers` if left empty.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="securityOperators")
    def security_operators(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Domain accounts that require elevated privileges such as `SeSecurityPrivilege` to manage security logs. Comma-separated list.
        """
        return pulumi.get(self, "security_operators")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies an Active Directory site to manage domain controller selection.
        Use when Active Directory domain controllers in multiple regions are configured. Defaults to `Default-First-Site-Name` if left empty.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the Active Directory policy (not the Active Directory itself).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> pulumi.Output[builtins.str]:
        """
        The state details of the Active Directory.
        """
        return pulumi.get(self, "state_details")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        Username for the Active Directory account with permissions to create the compute account within the specified organizational unit.
        """
        return pulumi.get(self, "username")

