# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StoragePoolArgs', 'StoragePool']

@pulumi.input_type
class StoragePoolArgs:
    def __init__(__self__, *,
                 capacity_gib: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 network: pulumi.Input[builtins.str],
                 service_level: pulumi.Input[builtins.str],
                 active_directory: Optional[pulumi.Input[builtins.str]] = None,
                 allow_auto_tiering: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_performance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_hot_tier_auto_resize: Optional[pulumi.Input[builtins.bool]] = None,
                 hot_tier_size_gib: Optional[pulumi.Input[builtins.str]] = None,
                 kms_config: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ldap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 replica_zone: Optional[pulumi.Input[builtins.str]] = None,
                 total_iops: Optional[pulumi.Input[builtins.str]] = None,
                 total_throughput_mibps: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a StoragePool resource.
        :param pulumi.Input[builtins.str] capacity_gib: Capacity of the storage pool (in GiB).
        :param pulumi.Input[builtins.str] location: Name of the location. For zonal Flex pools specify a zone name, in all other cases a region name.
        :param pulumi.Input[builtins.str] network: VPC network name with format: `projects/{{project}}/global/networks/{{network}}`
        :param pulumi.Input[builtins.str] service_level: Service level of the storage pool.
               Possible values are: `PREMIUM`, `EXTREME`, `STANDARD`, `FLEX`.
        :param pulumi.Input[builtins.str] active_directory: Specifies the Active Directory policy to be used. Format: `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`.
               The policy needs to be in the same location as the storage pool.
        :param pulumi.Input[builtins.bool] allow_auto_tiering: Optional. True if the storage pool supports Auto Tiering enabled volumes. Default is false.
               Auto-tiering can be enabled after storage pool creation but it can't be disabled once enabled.
        :param pulumi.Input[builtins.bool] custom_performance_enabled: Optional. True if using Independent Scaling of capacity and performance (Hyperdisk). Default is false.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.bool] enable_hot_tier_auto_resize: Flag indicating that the hot-tier threshold will be auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
               The increment will kick in only if the new size after increment is still less than or equal to storage pool size.
        :param pulumi.Input[builtins.str] hot_tier_size_gib: Total hot tier capacity for the Storage Pool. It is applicable only to Flex service level.
               It should be less than the minimum storage pool size and cannot be more than the current storage pool size. It cannot be decreased once set.
        :param pulumi.Input[builtins.str] kms_config: Specifies the CMEK policy to be used for volume encryption. Format: `projects/{{project}}/locations/{{location}}/kmsConfigs/{{name}}`.
               The policy needs to be in the same location as the storage pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.bool] ldap_enabled: When enabled, the volumes uses Active Directory as LDAP name service for UID/GID lookups. Required to enable extended group support for NFSv3,
               using security identifiers for NFSv4.1 or principal names for kerberized NFSv4.1.
        :param pulumi.Input[builtins.str] name: The resource name of the storage pool. Needs to be unique per location/region.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] replica_zone: Specifies the replica zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
               [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        :param pulumi.Input[builtins.str] total_iops: Optional. Custom Performance Total IOPS of the pool If not provided, it will be calculated based on the totalThroughputMibps
        :param pulumi.Input[builtins.str] total_throughput_mibps: Optional. Custom Performance Total Throughput of the pool (in MiB/s).
        :param pulumi.Input[builtins.str] zone: Specifies the active zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
               [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
               If you want to create a zonal Flex pool, specify a zone name for `location` and omit `zone`.
        """
        pulumi.set(__self__, "capacity_gib", capacity_gib)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "service_level", service_level)
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if allow_auto_tiering is not None:
            pulumi.set(__self__, "allow_auto_tiering", allow_auto_tiering)
        if custom_performance_enabled is not None:
            pulumi.set(__self__, "custom_performance_enabled", custom_performance_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_hot_tier_auto_resize is not None:
            pulumi.set(__self__, "enable_hot_tier_auto_resize", enable_hot_tier_auto_resize)
        if hot_tier_size_gib is not None:
            pulumi.set(__self__, "hot_tier_size_gib", hot_tier_size_gib)
        if kms_config is not None:
            pulumi.set(__self__, "kms_config", kms_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if ldap_enabled is not None:
            pulumi.set(__self__, "ldap_enabled", ldap_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replica_zone is not None:
            pulumi.set(__self__, "replica_zone", replica_zone)
        if total_iops is not None:
            pulumi.set(__self__, "total_iops", total_iops)
        if total_throughput_mibps is not None:
            pulumi.set(__self__, "total_throughput_mibps", total_throughput_mibps)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> pulumi.Input[builtins.str]:
        """
        Capacity of the storage pool (in GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @capacity_gib.setter
    def capacity_gib(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "capacity_gib", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Name of the location. For zonal Flex pools specify a zone name, in all other cases a region name.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        VPC network name with format: `projects/{{project}}/global/networks/{{network}}`
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Input[builtins.str]:
        """
        Service level of the storage pool.
        Possible values are: `PREMIUM`, `EXTREME`, `STANDARD`, `FLEX`.
        """
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_level", value)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Active Directory policy to be used. Format: `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`.
        The policy needs to be in the same location as the storage pool.
        """
        return pulumi.get(self, "active_directory")

    @active_directory.setter
    def active_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "active_directory", value)

    @property
    @pulumi.getter(name="allowAutoTiering")
    def allow_auto_tiering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. True if the storage pool supports Auto Tiering enabled volumes. Default is false.
        Auto-tiering can be enabled after storage pool creation but it can't be disabled once enabled.
        """
        return pulumi.get(self, "allow_auto_tiering")

    @allow_auto_tiering.setter
    def allow_auto_tiering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_auto_tiering", value)

    @property
    @pulumi.getter(name="customPerformanceEnabled")
    def custom_performance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. True if using Independent Scaling of capacity and performance (Hyperdisk). Default is false.
        """
        return pulumi.get(self, "custom_performance_enabled")

    @custom_performance_enabled.setter
    def custom_performance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "custom_performance_enabled", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableHotTierAutoResize")
    def enable_hot_tier_auto_resize(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag indicating that the hot-tier threshold will be auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
        The increment will kick in only if the new size after increment is still less than or equal to storage pool size.
        """
        return pulumi.get(self, "enable_hot_tier_auto_resize")

    @enable_hot_tier_auto_resize.setter
    def enable_hot_tier_auto_resize(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_hot_tier_auto_resize", value)

    @property
    @pulumi.getter(name="hotTierSizeGib")
    def hot_tier_size_gib(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Total hot tier capacity for the Storage Pool. It is applicable only to Flex service level.
        It should be less than the minimum storage pool size and cannot be more than the current storage pool size. It cannot be decreased once set.
        """
        return pulumi.get(self, "hot_tier_size_gib")

    @hot_tier_size_gib.setter
    def hot_tier_size_gib(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hot_tier_size_gib", value)

    @property
    @pulumi.getter(name="kmsConfig")
    def kms_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the CMEK policy to be used for volume encryption. Format: `projects/{{project}}/locations/{{location}}/kmsConfigs/{{name}}`.
        The policy needs to be in the same location as the storage pool.
        """
        return pulumi.get(self, "kms_config")

    @kms_config.setter
    def kms_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="ldapEnabled")
    def ldap_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When enabled, the volumes uses Active Directory as LDAP name service for UID/GID lookups. Required to enable extended group support for NFSv3,
        using security identifiers for NFSv4.1 or principal names for kerberized NFSv4.1.
        """
        return pulumi.get(self, "ldap_enabled")

    @ldap_enabled.setter
    def ldap_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ldap_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the storage pool. Needs to be unique per location/region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="replicaZone")
    def replica_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the replica zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
        [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        """
        return pulumi.get(self, "replica_zone")

    @replica_zone.setter
    def replica_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replica_zone", value)

    @property
    @pulumi.getter(name="totalIops")
    def total_iops(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Custom Performance Total IOPS of the pool If not provided, it will be calculated based on the totalThroughputMibps
        """
        return pulumi.get(self, "total_iops")

    @total_iops.setter
    def total_iops(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "total_iops", value)

    @property
    @pulumi.getter(name="totalThroughputMibps")
    def total_throughput_mibps(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Custom Performance Total Throughput of the pool (in MiB/s).
        """
        return pulumi.get(self, "total_throughput_mibps")

    @total_throughput_mibps.setter
    def total_throughput_mibps(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "total_throughput_mibps", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the active zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
        [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        If you want to create a zonal Flex pool, specify a zone name for `location` and omit `zone`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _StoragePoolState:
    def __init__(__self__, *,
                 active_directory: Optional[pulumi.Input[builtins.str]] = None,
                 allow_auto_tiering: Optional[pulumi.Input[builtins.bool]] = None,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 custom_performance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enable_hot_tier_auto_resize: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[builtins.str]] = None,
                 hot_tier_size_gib: Optional[pulumi.Input[builtins.str]] = None,
                 kms_config: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ldap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 replica_zone: Optional[pulumi.Input[builtins.str]] = None,
                 service_level: Optional[pulumi.Input[builtins.str]] = None,
                 total_iops: Optional[pulumi.Input[builtins.str]] = None,
                 total_throughput_mibps: Optional[pulumi.Input[builtins.str]] = None,
                 volume_capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 volume_count: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering StoragePool resources.
        :param pulumi.Input[builtins.str] active_directory: Specifies the Active Directory policy to be used. Format: `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`.
               The policy needs to be in the same location as the storage pool.
        :param pulumi.Input[builtins.bool] allow_auto_tiering: Optional. True if the storage pool supports Auto Tiering enabled volumes. Default is false.
               Auto-tiering can be enabled after storage pool creation but it can't be disabled once enabled.
        :param pulumi.Input[builtins.str] capacity_gib: Capacity of the storage pool (in GiB).
        :param pulumi.Input[builtins.bool] custom_performance_enabled: Optional. True if using Independent Scaling of capacity and performance (Hyperdisk). Default is false.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_hot_tier_auto_resize: Flag indicating that the hot-tier threshold will be auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
               The increment will kick in only if the new size after increment is still less than or equal to storage pool size.
        :param pulumi.Input[builtins.str] encryption_type: Reports if volumes in the pool are encrypted using a Google-managed encryption key or CMEK.
        :param pulumi.Input[builtins.str] hot_tier_size_gib: Total hot tier capacity for the Storage Pool. It is applicable only to Flex service level.
               It should be less than the minimum storage pool size and cannot be more than the current storage pool size. It cannot be decreased once set.
        :param pulumi.Input[builtins.str] kms_config: Specifies the CMEK policy to be used for volume encryption. Format: `projects/{{project}}/locations/{{location}}/kmsConfigs/{{name}}`.
               The policy needs to be in the same location as the storage pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.bool] ldap_enabled: When enabled, the volumes uses Active Directory as LDAP name service for UID/GID lookups. Required to enable extended group support for NFSv3,
               using security identifiers for NFSv4.1 or principal names for kerberized NFSv4.1.
        :param pulumi.Input[builtins.str] location: Name of the location. For zonal Flex pools specify a zone name, in all other cases a region name.
        :param pulumi.Input[builtins.str] name: The resource name of the storage pool. Needs to be unique per location/region.
        :param pulumi.Input[builtins.str] network: VPC network name with format: `projects/{{project}}/global/networks/{{network}}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] replica_zone: Specifies the replica zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
               [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        :param pulumi.Input[builtins.str] service_level: Service level of the storage pool.
               Possible values are: `PREMIUM`, `EXTREME`, `STANDARD`, `FLEX`.
        :param pulumi.Input[builtins.str] total_iops: Optional. Custom Performance Total IOPS of the pool If not provided, it will be calculated based on the totalThroughputMibps
        :param pulumi.Input[builtins.str] total_throughput_mibps: Optional. Custom Performance Total Throughput of the pool (in MiB/s).
        :param pulumi.Input[builtins.str] volume_capacity_gib: Size allocated to volumes in the storage pool (in GiB).
        :param pulumi.Input[builtins.int] volume_count: Number of volume in the storage pool.
        :param pulumi.Input[builtins.str] zone: Specifies the active zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
               [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
               If you want to create a zonal Flex pool, specify a zone name for `location` and omit `zone`.
        """
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if allow_auto_tiering is not None:
            pulumi.set(__self__, "allow_auto_tiering", allow_auto_tiering)
        if capacity_gib is not None:
            pulumi.set(__self__, "capacity_gib", capacity_gib)
        if custom_performance_enabled is not None:
            pulumi.set(__self__, "custom_performance_enabled", custom_performance_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_hot_tier_auto_resize is not None:
            pulumi.set(__self__, "enable_hot_tier_auto_resize", enable_hot_tier_auto_resize)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if hot_tier_size_gib is not None:
            pulumi.set(__self__, "hot_tier_size_gib", hot_tier_size_gib)
        if kms_config is not None:
            pulumi.set(__self__, "kms_config", kms_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if ldap_enabled is not None:
            pulumi.set(__self__, "ldap_enabled", ldap_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if replica_zone is not None:
            pulumi.set(__self__, "replica_zone", replica_zone)
        if service_level is not None:
            pulumi.set(__self__, "service_level", service_level)
        if total_iops is not None:
            pulumi.set(__self__, "total_iops", total_iops)
        if total_throughput_mibps is not None:
            pulumi.set(__self__, "total_throughput_mibps", total_throughput_mibps)
        if volume_capacity_gib is not None:
            pulumi.set(__self__, "volume_capacity_gib", volume_capacity_gib)
        if volume_count is not None:
            pulumi.set(__self__, "volume_count", volume_count)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Active Directory policy to be used. Format: `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`.
        The policy needs to be in the same location as the storage pool.
        """
        return pulumi.get(self, "active_directory")

    @active_directory.setter
    def active_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "active_directory", value)

    @property
    @pulumi.getter(name="allowAutoTiering")
    def allow_auto_tiering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. True if the storage pool supports Auto Tiering enabled volumes. Default is false.
        Auto-tiering can be enabled after storage pool creation but it can't be disabled once enabled.
        """
        return pulumi.get(self, "allow_auto_tiering")

    @allow_auto_tiering.setter
    def allow_auto_tiering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_auto_tiering", value)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Capacity of the storage pool (in GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @capacity_gib.setter
    def capacity_gib(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_gib", value)

    @property
    @pulumi.getter(name="customPerformanceEnabled")
    def custom_performance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. True if using Independent Scaling of capacity and performance (Hyperdisk). Default is false.
        """
        return pulumi.get(self, "custom_performance_enabled")

    @custom_performance_enabled.setter
    def custom_performance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "custom_performance_enabled", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="enableHotTierAutoResize")
    def enable_hot_tier_auto_resize(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag indicating that the hot-tier threshold will be auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
        The increment will kick in only if the new size after increment is still less than or equal to storage pool size.
        """
        return pulumi.get(self, "enable_hot_tier_auto_resize")

    @enable_hot_tier_auto_resize.setter
    def enable_hot_tier_auto_resize(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_hot_tier_auto_resize", value)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reports if volumes in the pool are encrypted using a Google-managed encryption key or CMEK.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="hotTierSizeGib")
    def hot_tier_size_gib(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Total hot tier capacity for the Storage Pool. It is applicable only to Flex service level.
        It should be less than the minimum storage pool size and cannot be more than the current storage pool size. It cannot be decreased once set.
        """
        return pulumi.get(self, "hot_tier_size_gib")

    @hot_tier_size_gib.setter
    def hot_tier_size_gib(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hot_tier_size_gib", value)

    @property
    @pulumi.getter(name="kmsConfig")
    def kms_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the CMEK policy to be used for volume encryption. Format: `projects/{{project}}/locations/{{location}}/kmsConfigs/{{name}}`.
        The policy needs to be in the same location as the storage pool.
        """
        return pulumi.get(self, "kms_config")

    @kms_config.setter
    def kms_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="ldapEnabled")
    def ldap_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When enabled, the volumes uses Active Directory as LDAP name service for UID/GID lookups. Required to enable extended group support for NFSv3,
        using security identifiers for NFSv4.1 or principal names for kerberized NFSv4.1.
        """
        return pulumi.get(self, "ldap_enabled")

    @ldap_enabled.setter
    def ldap_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ldap_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the location. For zonal Flex pools specify a zone name, in all other cases a region name.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the storage pool. Needs to be unique per location/region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        VPC network name with format: `projects/{{project}}/global/networks/{{network}}`
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="replicaZone")
    def replica_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the replica zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
        [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        """
        return pulumi.get(self, "replica_zone")

    @replica_zone.setter
    def replica_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replica_zone", value)

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service level of the storage pool.
        Possible values are: `PREMIUM`, `EXTREME`, `STANDARD`, `FLEX`.
        """
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_level", value)

    @property
    @pulumi.getter(name="totalIops")
    def total_iops(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Custom Performance Total IOPS of the pool If not provided, it will be calculated based on the totalThroughputMibps
        """
        return pulumi.get(self, "total_iops")

    @total_iops.setter
    def total_iops(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "total_iops", value)

    @property
    @pulumi.getter(name="totalThroughputMibps")
    def total_throughput_mibps(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Custom Performance Total Throughput of the pool (in MiB/s).
        """
        return pulumi.get(self, "total_throughput_mibps")

    @total_throughput_mibps.setter
    def total_throughput_mibps(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "total_throughput_mibps", value)

    @property
    @pulumi.getter(name="volumeCapacityGib")
    def volume_capacity_gib(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Size allocated to volumes in the storage pool (in GiB).
        """
        return pulumi.get(self, "volume_capacity_gib")

    @volume_capacity_gib.setter
    def volume_capacity_gib(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_capacity_gib", value)

    @property
    @pulumi.getter(name="volumeCount")
    def volume_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of volume in the storage pool.
        """
        return pulumi.get(self, "volume_count")

    @volume_count.setter
    def volume_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_count", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the active zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
        [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        If you want to create a zonal Flex pool, specify a zone name for `location` and omit `zone`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:netapp/storagePool:StoragePool")
class StoragePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory: Optional[pulumi.Input[builtins.str]] = None,
                 allow_auto_tiering: Optional[pulumi.Input[builtins.bool]] = None,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 custom_performance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_hot_tier_auto_resize: Optional[pulumi.Input[builtins.bool]] = None,
                 hot_tier_size_gib: Optional[pulumi.Input[builtins.str]] = None,
                 kms_config: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ldap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 replica_zone: Optional[pulumi.Input[builtins.str]] = None,
                 service_level: Optional[pulumi.Input[builtins.str]] = None,
                 total_iops: Optional[pulumi.Input[builtins.str]] = None,
                 total_throughput_mibps: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Storage Pool Create Doc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Create a network or use datasource to reference existing network
        peering_network = gcp.compute.Network("peering_network", name="test-network")
        # Reserve a CIDR for NetApp Volumes to use
        # When using shared-VPCs, this resource needs to be created in host project
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="test-address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=peering_network.id)
        # Create a Private Service Access connection
        # When using shared-VPCs, this resource needs to be created in host project
        default = gcp.servicenetworking.Connection("default",
            network=peering_network.id,
            service="netapp.servicenetworking.goog",
            reserved_peering_ranges=[private_ip_alloc.name])
        # Modify the PSA Connection to allow import/export of custom routes
        # When using shared-VPCs, this resource needs to be created in host project
        route_updates = gcp.compute.NetworkPeeringRoutesConfig("route_updates",
            peering=default.peering,
            network=peering_network.name,
            import_custom_routes=True,
            export_custom_routes=True)
        # Create a storage pool
        # Create this resource in the project which is expected to own the volumes
        test_pool = gcp.netapp.StoragePool("test_pool",
            name="test-pool",
            location="us-central1",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=peering_network.id)
        ```

        ## Import

        StoragePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/storagePools/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, StoragePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/storagePool:StoragePool default projects/{{project}}/locations/{{location}}/storagePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/storagePool:StoragePool default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/storagePool:StoragePool default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] active_directory: Specifies the Active Directory policy to be used. Format: `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`.
               The policy needs to be in the same location as the storage pool.
        :param pulumi.Input[builtins.bool] allow_auto_tiering: Optional. True if the storage pool supports Auto Tiering enabled volumes. Default is false.
               Auto-tiering can be enabled after storage pool creation but it can't be disabled once enabled.
        :param pulumi.Input[builtins.str] capacity_gib: Capacity of the storage pool (in GiB).
        :param pulumi.Input[builtins.bool] custom_performance_enabled: Optional. True if using Independent Scaling of capacity and performance (Hyperdisk). Default is false.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.bool] enable_hot_tier_auto_resize: Flag indicating that the hot-tier threshold will be auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
               The increment will kick in only if the new size after increment is still less than or equal to storage pool size.
        :param pulumi.Input[builtins.str] hot_tier_size_gib: Total hot tier capacity for the Storage Pool. It is applicable only to Flex service level.
               It should be less than the minimum storage pool size and cannot be more than the current storage pool size. It cannot be decreased once set.
        :param pulumi.Input[builtins.str] kms_config: Specifies the CMEK policy to be used for volume encryption. Format: `projects/{{project}}/locations/{{location}}/kmsConfigs/{{name}}`.
               The policy needs to be in the same location as the storage pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.bool] ldap_enabled: When enabled, the volumes uses Active Directory as LDAP name service for UID/GID lookups. Required to enable extended group support for NFSv3,
               using security identifiers for NFSv4.1 or principal names for kerberized NFSv4.1.
        :param pulumi.Input[builtins.str] location: Name of the location. For zonal Flex pools specify a zone name, in all other cases a region name.
        :param pulumi.Input[builtins.str] name: The resource name of the storage pool. Needs to be unique per location/region.
        :param pulumi.Input[builtins.str] network: VPC network name with format: `projects/{{project}}/global/networks/{{network}}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] replica_zone: Specifies the replica zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
               [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        :param pulumi.Input[builtins.str] service_level: Service level of the storage pool.
               Possible values are: `PREMIUM`, `EXTREME`, `STANDARD`, `FLEX`.
        :param pulumi.Input[builtins.str] total_iops: Optional. Custom Performance Total IOPS of the pool If not provided, it will be calculated based on the totalThroughputMibps
        :param pulumi.Input[builtins.str] total_throughput_mibps: Optional. Custom Performance Total Throughput of the pool (in MiB/s).
        :param pulumi.Input[builtins.str] zone: Specifies the active zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
               [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
               If you want to create a zonal Flex pool, specify a zone name for `location` and omit `zone`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StoragePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Storage Pool Create Doc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Create a network or use datasource to reference existing network
        peering_network = gcp.compute.Network("peering_network", name="test-network")
        # Reserve a CIDR for NetApp Volumes to use
        # When using shared-VPCs, this resource needs to be created in host project
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="test-address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=peering_network.id)
        # Create a Private Service Access connection
        # When using shared-VPCs, this resource needs to be created in host project
        default = gcp.servicenetworking.Connection("default",
            network=peering_network.id,
            service="netapp.servicenetworking.goog",
            reserved_peering_ranges=[private_ip_alloc.name])
        # Modify the PSA Connection to allow import/export of custom routes
        # When using shared-VPCs, this resource needs to be created in host project
        route_updates = gcp.compute.NetworkPeeringRoutesConfig("route_updates",
            peering=default.peering,
            network=peering_network.name,
            import_custom_routes=True,
            export_custom_routes=True)
        # Create a storage pool
        # Create this resource in the project which is expected to own the volumes
        test_pool = gcp.netapp.StoragePool("test_pool",
            name="test-pool",
            location="us-central1",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=peering_network.id)
        ```

        ## Import

        StoragePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/storagePools/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, StoragePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/storagePool:StoragePool default projects/{{project}}/locations/{{location}}/storagePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/storagePool:StoragePool default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/storagePool:StoragePool default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param StoragePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StoragePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory: Optional[pulumi.Input[builtins.str]] = None,
                 allow_auto_tiering: Optional[pulumi.Input[builtins.bool]] = None,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 custom_performance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_hot_tier_auto_resize: Optional[pulumi.Input[builtins.bool]] = None,
                 hot_tier_size_gib: Optional[pulumi.Input[builtins.str]] = None,
                 kms_config: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ldap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 replica_zone: Optional[pulumi.Input[builtins.str]] = None,
                 service_level: Optional[pulumi.Input[builtins.str]] = None,
                 total_iops: Optional[pulumi.Input[builtins.str]] = None,
                 total_throughput_mibps: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StoragePoolArgs.__new__(StoragePoolArgs)

            __props__.__dict__["active_directory"] = active_directory
            __props__.__dict__["allow_auto_tiering"] = allow_auto_tiering
            if capacity_gib is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_gib'")
            __props__.__dict__["capacity_gib"] = capacity_gib
            __props__.__dict__["custom_performance_enabled"] = custom_performance_enabled
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_hot_tier_auto_resize"] = enable_hot_tier_auto_resize
            __props__.__dict__["hot_tier_size_gib"] = hot_tier_size_gib
            __props__.__dict__["kms_config"] = kms_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["ldap_enabled"] = ldap_enabled
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["replica_zone"] = replica_zone
            if service_level is None and not opts.urn:
                raise TypeError("Missing required property 'service_level'")
            __props__.__dict__["service_level"] = service_level
            __props__.__dict__["total_iops"] = total_iops
            __props__.__dict__["total_throughput_mibps"] = total_throughput_mibps
            __props__.__dict__["zone"] = zone
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["encryption_type"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["volume_capacity_gib"] = None
            __props__.__dict__["volume_count"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StoragePool, __self__).__init__(
            'gcp:netapp/storagePool:StoragePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_directory: Optional[pulumi.Input[builtins.str]] = None,
            allow_auto_tiering: Optional[pulumi.Input[builtins.bool]] = None,
            capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
            custom_performance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            enable_hot_tier_auto_resize: Optional[pulumi.Input[builtins.bool]] = None,
            encryption_type: Optional[pulumi.Input[builtins.str]] = None,
            hot_tier_size_gib: Optional[pulumi.Input[builtins.str]] = None,
            kms_config: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            ldap_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            replica_zone: Optional[pulumi.Input[builtins.str]] = None,
            service_level: Optional[pulumi.Input[builtins.str]] = None,
            total_iops: Optional[pulumi.Input[builtins.str]] = None,
            total_throughput_mibps: Optional[pulumi.Input[builtins.str]] = None,
            volume_capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
            volume_count: Optional[pulumi.Input[builtins.int]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'StoragePool':
        """
        Get an existing StoragePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] active_directory: Specifies the Active Directory policy to be used. Format: `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`.
               The policy needs to be in the same location as the storage pool.
        :param pulumi.Input[builtins.bool] allow_auto_tiering: Optional. True if the storage pool supports Auto Tiering enabled volumes. Default is false.
               Auto-tiering can be enabled after storage pool creation but it can't be disabled once enabled.
        :param pulumi.Input[builtins.str] capacity_gib: Capacity of the storage pool (in GiB).
        :param pulumi.Input[builtins.bool] custom_performance_enabled: Optional. True if using Independent Scaling of capacity and performance (Hyperdisk). Default is false.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_hot_tier_auto_resize: Flag indicating that the hot-tier threshold will be auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
               The increment will kick in only if the new size after increment is still less than or equal to storage pool size.
        :param pulumi.Input[builtins.str] encryption_type: Reports if volumes in the pool are encrypted using a Google-managed encryption key or CMEK.
        :param pulumi.Input[builtins.str] hot_tier_size_gib: Total hot tier capacity for the Storage Pool. It is applicable only to Flex service level.
               It should be less than the minimum storage pool size and cannot be more than the current storage pool size. It cannot be decreased once set.
        :param pulumi.Input[builtins.str] kms_config: Specifies the CMEK policy to be used for volume encryption. Format: `projects/{{project}}/locations/{{location}}/kmsConfigs/{{name}}`.
               The policy needs to be in the same location as the storage pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.bool] ldap_enabled: When enabled, the volumes uses Active Directory as LDAP name service for UID/GID lookups. Required to enable extended group support for NFSv3,
               using security identifiers for NFSv4.1 or principal names for kerberized NFSv4.1.
        :param pulumi.Input[builtins.str] location: Name of the location. For zonal Flex pools specify a zone name, in all other cases a region name.
        :param pulumi.Input[builtins.str] name: The resource name of the storage pool. Needs to be unique per location/region.
        :param pulumi.Input[builtins.str] network: VPC network name with format: `projects/{{project}}/global/networks/{{network}}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] replica_zone: Specifies the replica zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
               [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        :param pulumi.Input[builtins.str] service_level: Service level of the storage pool.
               Possible values are: `PREMIUM`, `EXTREME`, `STANDARD`, `FLEX`.
        :param pulumi.Input[builtins.str] total_iops: Optional. Custom Performance Total IOPS of the pool If not provided, it will be calculated based on the totalThroughputMibps
        :param pulumi.Input[builtins.str] total_throughput_mibps: Optional. Custom Performance Total Throughput of the pool (in MiB/s).
        :param pulumi.Input[builtins.str] volume_capacity_gib: Size allocated to volumes in the storage pool (in GiB).
        :param pulumi.Input[builtins.int] volume_count: Number of volume in the storage pool.
        :param pulumi.Input[builtins.str] zone: Specifies the active zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
               [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
               If you want to create a zonal Flex pool, specify a zone name for `location` and omit `zone`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StoragePoolState.__new__(_StoragePoolState)

        __props__.__dict__["active_directory"] = active_directory
        __props__.__dict__["allow_auto_tiering"] = allow_auto_tiering
        __props__.__dict__["capacity_gib"] = capacity_gib
        __props__.__dict__["custom_performance_enabled"] = custom_performance_enabled
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_hot_tier_auto_resize"] = enable_hot_tier_auto_resize
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["hot_tier_size_gib"] = hot_tier_size_gib
        __props__.__dict__["kms_config"] = kms_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["ldap_enabled"] = ldap_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["replica_zone"] = replica_zone
        __props__.__dict__["service_level"] = service_level
        __props__.__dict__["total_iops"] = total_iops
        __props__.__dict__["total_throughput_mibps"] = total_throughput_mibps
        __props__.__dict__["volume_capacity_gib"] = volume_capacity_gib
        __props__.__dict__["volume_count"] = volume_count
        __props__.__dict__["zone"] = zone
        return StoragePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Active Directory policy to be used. Format: `projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}`.
        The policy needs to be in the same location as the storage pool.
        """
        return pulumi.get(self, "active_directory")

    @property
    @pulumi.getter(name="allowAutoTiering")
    def allow_auto_tiering(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Optional. True if the storage pool supports Auto Tiering enabled volumes. Default is false.
        Auto-tiering can be enabled after storage pool creation but it can't be disabled once enabled.
        """
        return pulumi.get(self, "allow_auto_tiering")

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> pulumi.Output[builtins.str]:
        """
        Capacity of the storage pool (in GiB).
        """
        return pulumi.get(self, "capacity_gib")

    @property
    @pulumi.getter(name="customPerformanceEnabled")
    def custom_performance_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Optional. True if using Independent Scaling of capacity and performance (Hyperdisk). Default is false.
        """
        return pulumi.get(self, "custom_performance_enabled")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableHotTierAutoResize")
    def enable_hot_tier_auto_resize(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Flag indicating that the hot-tier threshold will be auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
        The increment will kick in only if the new size after increment is still less than or equal to storage pool size.
        """
        return pulumi.get(self, "enable_hot_tier_auto_resize")

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[builtins.str]:
        """
        Reports if volumes in the pool are encrypted using a Google-managed encryption key or CMEK.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="hotTierSizeGib")
    def hot_tier_size_gib(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Total hot tier capacity for the Storage Pool. It is applicable only to Flex service level.
        It should be less than the minimum storage pool size and cannot be more than the current storage pool size. It cannot be decreased once set.
        """
        return pulumi.get(self, "hot_tier_size_gib")

    @property
    @pulumi.getter(name="kmsConfig")
    def kms_config(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the CMEK policy to be used for volume encryption. Format: `projects/{{project}}/locations/{{location}}/kmsConfigs/{{name}}`.
        The policy needs to be in the same location as the storage pool.
        """
        return pulumi.get(self, "kms_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="ldapEnabled")
    def ldap_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When enabled, the volumes uses Active Directory as LDAP name service for UID/GID lookups. Required to enable extended group support for NFSv3,
        using security identifiers for NFSv4.1 or principal names for kerberized NFSv4.1.
        """
        return pulumi.get(self, "ldap_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Name of the location. For zonal Flex pools specify a zone name, in all other cases a region name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the storage pool. Needs to be unique per location/region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        VPC network name with format: `projects/{{project}}/global/networks/{{network}}`
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="replicaZone")
    def replica_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the replica zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
        [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        """
        return pulumi.get(self, "replica_zone")

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Output[builtins.str]:
        """
        Service level of the storage pool.
        Possible values are: `PREMIUM`, `EXTREME`, `STANDARD`, `FLEX`.
        """
        return pulumi.get(self, "service_level")

    @property
    @pulumi.getter(name="totalIops")
    def total_iops(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. Custom Performance Total IOPS of the pool If not provided, it will be calculated based on the totalThroughputMibps
        """
        return pulumi.get(self, "total_iops")

    @property
    @pulumi.getter(name="totalThroughputMibps")
    def total_throughput_mibps(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. Custom Performance Total Throughput of the pool (in MiB/s).
        """
        return pulumi.get(self, "total_throughput_mibps")

    @property
    @pulumi.getter(name="volumeCapacityGib")
    def volume_capacity_gib(self) -> pulumi.Output[builtins.str]:
        """
        Size allocated to volumes in the storage pool (in GiB).
        """
        return pulumi.get(self, "volume_capacity_gib")

    @property
    @pulumi.getter(name="volumeCount")
    def volume_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of volume in the storage pool.
        """
        return pulumi.get(self, "volume_count")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the active zone for regional Flex pools. `zone` and `replica_zone` values can be swapped to initiate a
        [zone switch](https://cloud.google.com/netapp/volumes/docs/configure-and-use/storage-pools/edit-or-delete-storage-pool#switch_active_and_replica_zones).
        If you want to create a zonal Flex pool, specify a zone name for `location` and omit `zone`.
        """
        return pulumi.get(self, "zone")

