# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectivityTestArgs', 'ConnectivityTest']

@pulumi.input_type
class ConnectivityTestArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['ConnectivityTestDestinationArgs'],
                 source: pulumi.Input['ConnectivityTestSourceArgs'],
                 bypass_firewall_checks: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 related_projects: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 round_trip: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ConnectivityTest resource.
        :param pulumi.Input['ConnectivityTestDestinationArgs'] destination: Required. Destination specification of the Connectivity Test.
               You can use a combination of destination IP address, URI of a supported
               endpoint, project ID, or VPC network to identify the destination location.
               Reachability analysis proceeds even if the destination location is
               ambiguous. However, the test result might include endpoints or use a
               destination that you don't intend to test.
               Structure is documented below.
        :param pulumi.Input['ConnectivityTestSourceArgs'] source: Required. Source specification of the Connectivity Test.
               You can use a combination of source IP address, URI of a supported
               endpoint, project ID, or VPC network to identify the source location.
               Reachability analysis might proceed even if the source location is
               ambiguous. However, the test result might include endpoints or use a source
               that you don't intend to test.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] bypass_firewall_checks: Whether the analysis should skip firewall checking. Default value is false.
        :param pulumi.Input[builtins.str] description: The user-supplied description of the Connectivity Test.
               Maximum of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Unique name for the connectivity test.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] protocol: IP Protocol of the test. When not provided, "TCP" is assumed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] related_projects: Other projects that may be relevant for reachability analysis.
               This is applicable to scenarios where a test can cross project
               boundaries.
        :param pulumi.Input[builtins.bool] round_trip: Whether run analysis for the return path from destination to source.
               Default value is false.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "source", source)
        if bypass_firewall_checks is not None:
            pulumi.set(__self__, "bypass_firewall_checks", bypass_firewall_checks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if related_projects is not None:
            pulumi.set(__self__, "related_projects", related_projects)
        if round_trip is not None:
            pulumi.set(__self__, "round_trip", round_trip)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['ConnectivityTestDestinationArgs']:
        """
        Required. Destination specification of the Connectivity Test.
        You can use a combination of destination IP address, URI of a supported
        endpoint, project ID, or VPC network to identify the destination location.
        Reachability analysis proceeds even if the destination location is
        ambiguous. However, the test result might include endpoints or use a
        destination that you don't intend to test.
        Structure is documented below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['ConnectivityTestDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['ConnectivityTestSourceArgs']:
        """
        Required. Source specification of the Connectivity Test.
        You can use a combination of source IP address, URI of a supported
        endpoint, project ID, or VPC network to identify the source location.
        Reachability analysis might proceed even if the source location is
        ambiguous. However, the test result might include endpoints or use a source
        that you don't intend to test.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['ConnectivityTestSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="bypassFirewallChecks")
    def bypass_firewall_checks(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the analysis should skip firewall checking. Default value is false.
        """
        return pulumi.get(self, "bypass_firewall_checks")

    @bypass_firewall_checks.setter
    def bypass_firewall_checks(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "bypass_firewall_checks", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-supplied description of the Connectivity Test.
        Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name for the connectivity test.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP Protocol of the test. When not provided, "TCP" is assumed.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="relatedProjects")
    def related_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Other projects that may be relevant for reachability analysis.
        This is applicable to scenarios where a test can cross project
        boundaries.
        """
        return pulumi.get(self, "related_projects")

    @related_projects.setter
    def related_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "related_projects", value)

    @property
    @pulumi.getter(name="roundTrip")
    def round_trip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether run analysis for the return path from destination to source.
        Default value is false.
        """
        return pulumi.get(self, "round_trip")

    @round_trip.setter
    def round_trip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "round_trip", value)


@pulumi.input_type
class _ConnectivityTestState:
    def __init__(__self__, *,
                 bypass_firewall_checks: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input['ConnectivityTestDestinationArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 related_projects: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 round_trip: Optional[pulumi.Input[builtins.bool]] = None,
                 source: Optional[pulumi.Input['ConnectivityTestSourceArgs']] = None):
        """
        Input properties used for looking up and filtering ConnectivityTest resources.
        :param pulumi.Input[builtins.bool] bypass_firewall_checks: Whether the analysis should skip firewall checking. Default value is false.
        :param pulumi.Input[builtins.str] description: The user-supplied description of the Connectivity Test.
               Maximum of 512 characters.
        :param pulumi.Input['ConnectivityTestDestinationArgs'] destination: Required. Destination specification of the Connectivity Test.
               You can use a combination of destination IP address, URI of a supported
               endpoint, project ID, or VPC network to identify the destination location.
               Reachability analysis proceeds even if the destination location is
               ambiguous. However, the test result might include endpoints or use a
               destination that you don't intend to test.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Unique name for the connectivity test.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] protocol: IP Protocol of the test. When not provided, "TCP" is assumed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] related_projects: Other projects that may be relevant for reachability analysis.
               This is applicable to scenarios where a test can cross project
               boundaries.
        :param pulumi.Input[builtins.bool] round_trip: Whether run analysis for the return path from destination to source.
               Default value is false.
        :param pulumi.Input['ConnectivityTestSourceArgs'] source: Required. Source specification of the Connectivity Test.
               You can use a combination of source IP address, URI of a supported
               endpoint, project ID, or VPC network to identify the source location.
               Reachability analysis might proceed even if the source location is
               ambiguous. However, the test result might include endpoints or use a source
               that you don't intend to test.
               Structure is documented below.
        """
        if bypass_firewall_checks is not None:
            pulumi.set(__self__, "bypass_firewall_checks", bypass_firewall_checks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if related_projects is not None:
            pulumi.set(__self__, "related_projects", related_projects)
        if round_trip is not None:
            pulumi.set(__self__, "round_trip", round_trip)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="bypassFirewallChecks")
    def bypass_firewall_checks(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the analysis should skip firewall checking. Default value is false.
        """
        return pulumi.get(self, "bypass_firewall_checks")

    @bypass_firewall_checks.setter
    def bypass_firewall_checks(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "bypass_firewall_checks", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-supplied description of the Connectivity Test.
        Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['ConnectivityTestDestinationArgs']]:
        """
        Required. Destination specification of the Connectivity Test.
        You can use a combination of destination IP address, URI of a supported
        endpoint, project ID, or VPC network to identify the destination location.
        Reachability analysis proceeds even if the destination location is
        ambiguous. However, the test result might include endpoints or use a
        destination that you don't intend to test.
        Structure is documented below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['ConnectivityTestDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name for the connectivity test.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP Protocol of the test. When not provided, "TCP" is assumed.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="relatedProjects")
    def related_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Other projects that may be relevant for reachability analysis.
        This is applicable to scenarios where a test can cross project
        boundaries.
        """
        return pulumi.get(self, "related_projects")

    @related_projects.setter
    def related_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "related_projects", value)

    @property
    @pulumi.getter(name="roundTrip")
    def round_trip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether run analysis for the return path from destination to source.
        Default value is false.
        """
        return pulumi.get(self, "round_trip")

    @round_trip.setter
    def round_trip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "round_trip", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['ConnectivityTestSourceArgs']]:
        """
        Required. Source specification of the Connectivity Test.
        You can use a combination of source IP address, URI of a supported
        endpoint, project ID, or VPC network to identify the source location.
        Reachability analysis might proceed even if the source location is
        ambiguous. However, the test result might include endpoints or use a source
        that you don't intend to test.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['ConnectivityTestSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.type_token("gcp:networkmanagement/connectivityTest:ConnectivityTest")
class ConnectivityTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_firewall_checks: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['ConnectivityTestDestinationArgs', 'ConnectivityTestDestinationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 related_projects: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 round_trip: Optional[pulumi.Input[builtins.bool]] = None,
                 source: Optional[pulumi.Input[Union['ConnectivityTestSourceArgs', 'ConnectivityTestSourceArgsDict']]] = None,
                 __props__=None):
        """
        A connectivity test are a static analysis of your resource configurations
        that enables you to evaluate connectivity to and from Google Cloud
        resources in your Virtual Private Cloud (VPC) network.

        To get more information about ConnectivityTest, see:

        * [API documentation](https://cloud.google.com/network-intelligence-center/docs/connectivity-tests/reference/networkmanagement/rest/v1/projects.locations.global.connectivityTests)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/network-intelligence-center/docs)

        ## Example Usage

        ### Network Management Connectivity Test Instances

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc = gcp.compute.Network("vpc", name="conn-test-net")
        debian9 = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        source = gcp.compute.Instance("source",
            network_interfaces=[{
                "access_configs": [{}],
                "network": vpc.id,
            }],
            name="source-vm",
            machine_type="e2-medium",
            boot_disk={
                "initialize_params": {
                    "image": debian9.id,
                },
            })
        destination = gcp.compute.Instance("destination",
            network_interfaces=[{
                "access_configs": [{}],
                "network": vpc.id,
            }],
            name="dest-vm",
            machine_type="e2-medium",
            boot_disk={
                "initialize_params": {
                    "image": debian9.id,
                },
            })
        instance_test = gcp.networkmanagement.ConnectivityTest("instance-test",
            name="conn-test-instances",
            source={
                "instance": source.id,
            },
            destination={
                "instance": destination.id,
            },
            protocol="TCP",
            labels={
                "env": "test",
            })
        ```
        ### Network Management Connectivity Test Addresses

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc = gcp.compute.Network("vpc", name="connectivity-vpc")
        subnet = gcp.compute.Subnetwork("subnet",
            name="connectivity-vpc-subnet",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=vpc.id)
        source_addr = gcp.compute.Address("source-addr",
            name="src-addr",
            subnetwork=subnet.id,
            address_type="INTERNAL",
            address="10.0.42.42",
            region="us-central1")
        dest_addr = gcp.compute.Address("dest-addr",
            name="dest-addr",
            subnetwork=subnet.id,
            address_type="INTERNAL",
            address="10.0.43.43",
            region="us-central1")
        address_test = gcp.networkmanagement.ConnectivityTest("address-test",
            name="conn-test-addr",
            source={
                "ip_address": source_addr.address,
                "project_id": source_addr.project,
                "network": vpc.id,
                "network_type": "GCP_NETWORK",
            },
            destination={
                "ip_address": dest_addr.address,
                "project_id": dest_addr.project,
                "network": vpc.id,
            },
            protocol="UDP")
        ```
        ### Network Management Connectivity Test Endpoints

        ```python
        import pulumi
        import pulumi_gcp as gcp

        endpoints_test = gcp.networkmanagement.ConnectivityTest("endpoints-test",
            name="conn-test-endpoints",
            source={
                "gke_master_cluster": "projects/test-project/locations/us-central1/clusters/name",
                "cloud_sql_instance": "projects/test-project/instances/name",
                "app_engine_version": {
                    "uri": "apps/test-project/services/default/versions/name",
                },
                "cloud_function": {
                    "uri": "projects/test-project/locations/us-central1/functions/name",
                },
                "cloud_run_revision": {
                    "uri": "projects/test-project/locations/us-central1/revisions/name",
                },
                "port": 80,
            },
            destination={
                "port": 443,
                "forwarding_rule": "projects/test-project/regions/us-central1/forwardingRules/name",
                "gke_master_cluster": "projects/test-project/locations/us-central1/clusters/name",
                "fqdn": "name.us-central1.gke.goog",
                "cloud_sql_instance": "projects/test-project/instances/name",
                "redis_instance": "projects/test-project/locations/us-central1/instances/name",
                "redis_cluster": "projects/test-project/locations/us-central1/clusters/name",
            },
            bypass_firewall_checks=True,
            round_trip=True)
        ```

        ## Import

        ConnectivityTest can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/connectivityTests/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ConnectivityTest can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkmanagement/connectivityTest:ConnectivityTest default projects/{{project}}/locations/global/connectivityTests/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/connectivityTest:ConnectivityTest default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/connectivityTest:ConnectivityTest default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] bypass_firewall_checks: Whether the analysis should skip firewall checking. Default value is false.
        :param pulumi.Input[builtins.str] description: The user-supplied description of the Connectivity Test.
               Maximum of 512 characters.
        :param pulumi.Input[Union['ConnectivityTestDestinationArgs', 'ConnectivityTestDestinationArgsDict']] destination: Required. Destination specification of the Connectivity Test.
               You can use a combination of destination IP address, URI of a supported
               endpoint, project ID, or VPC network to identify the destination location.
               Reachability analysis proceeds even if the destination location is
               ambiguous. However, the test result might include endpoints or use a
               destination that you don't intend to test.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Unique name for the connectivity test.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] protocol: IP Protocol of the test. When not provided, "TCP" is assumed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] related_projects: Other projects that may be relevant for reachability analysis.
               This is applicable to scenarios where a test can cross project
               boundaries.
        :param pulumi.Input[builtins.bool] round_trip: Whether run analysis for the return path from destination to source.
               Default value is false.
        :param pulumi.Input[Union['ConnectivityTestSourceArgs', 'ConnectivityTestSourceArgsDict']] source: Required. Source specification of the Connectivity Test.
               You can use a combination of source IP address, URI of a supported
               endpoint, project ID, or VPC network to identify the source location.
               Reachability analysis might proceed even if the source location is
               ambiguous. However, the test result might include endpoints or use a source
               that you don't intend to test.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectivityTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A connectivity test are a static analysis of your resource configurations
        that enables you to evaluate connectivity to and from Google Cloud
        resources in your Virtual Private Cloud (VPC) network.

        To get more information about ConnectivityTest, see:

        * [API documentation](https://cloud.google.com/network-intelligence-center/docs/connectivity-tests/reference/networkmanagement/rest/v1/projects.locations.global.connectivityTests)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/network-intelligence-center/docs)

        ## Example Usage

        ### Network Management Connectivity Test Instances

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc = gcp.compute.Network("vpc", name="conn-test-net")
        debian9 = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        source = gcp.compute.Instance("source",
            network_interfaces=[{
                "access_configs": [{}],
                "network": vpc.id,
            }],
            name="source-vm",
            machine_type="e2-medium",
            boot_disk={
                "initialize_params": {
                    "image": debian9.id,
                },
            })
        destination = gcp.compute.Instance("destination",
            network_interfaces=[{
                "access_configs": [{}],
                "network": vpc.id,
            }],
            name="dest-vm",
            machine_type="e2-medium",
            boot_disk={
                "initialize_params": {
                    "image": debian9.id,
                },
            })
        instance_test = gcp.networkmanagement.ConnectivityTest("instance-test",
            name="conn-test-instances",
            source={
                "instance": source.id,
            },
            destination={
                "instance": destination.id,
            },
            protocol="TCP",
            labels={
                "env": "test",
            })
        ```
        ### Network Management Connectivity Test Addresses

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc = gcp.compute.Network("vpc", name="connectivity-vpc")
        subnet = gcp.compute.Subnetwork("subnet",
            name="connectivity-vpc-subnet",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=vpc.id)
        source_addr = gcp.compute.Address("source-addr",
            name="src-addr",
            subnetwork=subnet.id,
            address_type="INTERNAL",
            address="10.0.42.42",
            region="us-central1")
        dest_addr = gcp.compute.Address("dest-addr",
            name="dest-addr",
            subnetwork=subnet.id,
            address_type="INTERNAL",
            address="10.0.43.43",
            region="us-central1")
        address_test = gcp.networkmanagement.ConnectivityTest("address-test",
            name="conn-test-addr",
            source={
                "ip_address": source_addr.address,
                "project_id": source_addr.project,
                "network": vpc.id,
                "network_type": "GCP_NETWORK",
            },
            destination={
                "ip_address": dest_addr.address,
                "project_id": dest_addr.project,
                "network": vpc.id,
            },
            protocol="UDP")
        ```
        ### Network Management Connectivity Test Endpoints

        ```python
        import pulumi
        import pulumi_gcp as gcp

        endpoints_test = gcp.networkmanagement.ConnectivityTest("endpoints-test",
            name="conn-test-endpoints",
            source={
                "gke_master_cluster": "projects/test-project/locations/us-central1/clusters/name",
                "cloud_sql_instance": "projects/test-project/instances/name",
                "app_engine_version": {
                    "uri": "apps/test-project/services/default/versions/name",
                },
                "cloud_function": {
                    "uri": "projects/test-project/locations/us-central1/functions/name",
                },
                "cloud_run_revision": {
                    "uri": "projects/test-project/locations/us-central1/revisions/name",
                },
                "port": 80,
            },
            destination={
                "port": 443,
                "forwarding_rule": "projects/test-project/regions/us-central1/forwardingRules/name",
                "gke_master_cluster": "projects/test-project/locations/us-central1/clusters/name",
                "fqdn": "name.us-central1.gke.goog",
                "cloud_sql_instance": "projects/test-project/instances/name",
                "redis_instance": "projects/test-project/locations/us-central1/instances/name",
                "redis_cluster": "projects/test-project/locations/us-central1/clusters/name",
            },
            bypass_firewall_checks=True,
            round_trip=True)
        ```

        ## Import

        ConnectivityTest can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/connectivityTests/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ConnectivityTest can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkmanagement/connectivityTest:ConnectivityTest default projects/{{project}}/locations/global/connectivityTests/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/connectivityTest:ConnectivityTest default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/connectivityTest:ConnectivityTest default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectivityTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectivityTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_firewall_checks: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['ConnectivityTestDestinationArgs', 'ConnectivityTestDestinationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 related_projects: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 round_trip: Optional[pulumi.Input[builtins.bool]] = None,
                 source: Optional[pulumi.Input[Union['ConnectivityTestSourceArgs', 'ConnectivityTestSourceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectivityTestArgs.__new__(ConnectivityTestArgs)

            __props__.__dict__["bypass_firewall_checks"] = bypass_firewall_checks
            __props__.__dict__["description"] = description
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["related_projects"] = related_projects
            __props__.__dict__["round_trip"] = round_trip
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ConnectivityTest, __self__).__init__(
            'gcp:networkmanagement/connectivityTest:ConnectivityTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bypass_firewall_checks: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['ConnectivityTestDestinationArgs', 'ConnectivityTestDestinationArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            related_projects: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            round_trip: Optional[pulumi.Input[builtins.bool]] = None,
            source: Optional[pulumi.Input[Union['ConnectivityTestSourceArgs', 'ConnectivityTestSourceArgsDict']]] = None) -> 'ConnectivityTest':
        """
        Get an existing ConnectivityTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] bypass_firewall_checks: Whether the analysis should skip firewall checking. Default value is false.
        :param pulumi.Input[builtins.str] description: The user-supplied description of the Connectivity Test.
               Maximum of 512 characters.
        :param pulumi.Input[Union['ConnectivityTestDestinationArgs', 'ConnectivityTestDestinationArgsDict']] destination: Required. Destination specification of the Connectivity Test.
               You can use a combination of destination IP address, URI of a supported
               endpoint, project ID, or VPC network to identify the destination location.
               Reachability analysis proceeds even if the destination location is
               ambiguous. However, the test result might include endpoints or use a
               destination that you don't intend to test.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Unique name for the connectivity test.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] protocol: IP Protocol of the test. When not provided, "TCP" is assumed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] related_projects: Other projects that may be relevant for reachability analysis.
               This is applicable to scenarios where a test can cross project
               boundaries.
        :param pulumi.Input[builtins.bool] round_trip: Whether run analysis for the return path from destination to source.
               Default value is false.
        :param pulumi.Input[Union['ConnectivityTestSourceArgs', 'ConnectivityTestSourceArgsDict']] source: Required. Source specification of the Connectivity Test.
               You can use a combination of source IP address, URI of a supported
               endpoint, project ID, or VPC network to identify the source location.
               Reachability analysis might proceed even if the source location is
               ambiguous. However, the test result might include endpoints or use a source
               that you don't intend to test.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectivityTestState.__new__(_ConnectivityTestState)

        __props__.__dict__["bypass_firewall_checks"] = bypass_firewall_checks
        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["related_projects"] = related_projects
        __props__.__dict__["round_trip"] = round_trip
        __props__.__dict__["source"] = source
        return ConnectivityTest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bypassFirewallChecks")
    def bypass_firewall_checks(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the analysis should skip firewall checking. Default value is false.
        """
        return pulumi.get(self, "bypass_firewall_checks")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user-supplied description of the Connectivity Test.
        Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.ConnectivityTestDestination']:
        """
        Required. Destination specification of the Connectivity Test.
        You can use a combination of destination IP address, URI of a supported
        endpoint, project ID, or VPC network to identify the destination location.
        Reachability analysis proceeds even if the destination location is
        ambiguous. However, the test result might include endpoints or use a
        destination that you don't intend to test.
        Structure is documented below.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Unique name for the connectivity test.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP Protocol of the test. When not provided, "TCP" is assumed.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="relatedProjects")
    def related_projects(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Other projects that may be relevant for reachability analysis.
        This is applicable to scenarios where a test can cross project
        boundaries.
        """
        return pulumi.get(self, "related_projects")

    @property
    @pulumi.getter(name="roundTrip")
    def round_trip(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether run analysis for the return path from destination to source.
        Default value is false.
        """
        return pulumi.get(self, "round_trip")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.ConnectivityTestSource']:
        """
        Required. Source specification of the Connectivity Test.
        You can use a combination of source IP address, URI of a supported
        endpoint, project ID, or VPC network to identify the source location.
        Reachability analysis might proceed even if the source location is
        ambiguous. However, the test result might include endpoints or use a source
        that you don't intend to test.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

