# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcFlowLogsConfigArgs', 'VpcFlowLogsConfig']

@pulumi.input_type
class VpcFlowLogsConfigArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 vpc_flow_logs_config_id: pulumi.Input[builtins.str],
                 aggregation_interval: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filter_expr: Optional[pulumi.Input[builtins.str]] = None,
                 flow_sampling: Optional[pulumi.Input[builtins.float]] = None,
                 interconnect_attachment: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[builtins.str]] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpcFlowLogsConfig resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource
               within its parent collection as described in https://google.aip.dev/122. See documentation
               for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        :param pulumi.Input[builtins.str] vpc_flow_logs_config_id: Required. ID of the `VpcFlowLogsConfig`.
        :param pulumi.Input[builtins.str] aggregation_interval: Optional. The aggregation interval for the logs. Default value is
               INTERVAL_5_SEC.   Possible values:  AGGREGATION_INTERVAL_UNSPECIFIED INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN"
        :param pulumi.Input[builtins.str] description: Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
               of 512 characters.
        :param pulumi.Input[builtins.str] filter_expr: Optional. Export filter used to define which VPC Flow Logs should be logged.
        :param pulumi.Input[builtins.float] flow_sampling: Optional. The value of the field must be in (0, 1]. The sampling rate
               of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
               sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
               the state field instead. Default value is 1.0.
        :param pulumi.Input[builtins.str] interconnect_attachment: Traffic will be logged from the Interconnect Attachment. Format: projects/{project_id}/regions/{region}/interconnectAttachments/{name}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] metadata: Optional. Configures whether all, none or a subset of metadata fields
               should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
               Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] metadata_fields: Optional. Custom metadata fields to include in the reported VPC flow
               logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: Optional. The state of the VPC Flow Log configuration. Default value
               is ENABLED. When creating a new configuration, it must be enabled.   Possible
        :param pulumi.Input[builtins.str] vpn_tunnel: Traffic will be logged from the VPN Tunnel. Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "vpc_flow_logs_config_id", vpc_flow_logs_config_id)
        if aggregation_interval is not None:
            pulumi.set(__self__, "aggregation_interval", aggregation_interval)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter_expr is not None:
            pulumi.set(__self__, "filter_expr", filter_expr)
        if flow_sampling is not None:
            pulumi.set(__self__, "flow_sampling", flow_sampling)
        if interconnect_attachment is not None:
            pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fields is not None:
            pulumi.set(__self__, "metadata_fields", metadata_fields)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vpn_tunnel is not None:
            pulumi.set(__self__, "vpn_tunnel", vpn_tunnel)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource
        within its parent collection as described in https://google.aip.dev/122. See documentation
        for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="vpcFlowLogsConfigId")
    def vpc_flow_logs_config_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. ID of the `VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "vpc_flow_logs_config_id")

    @vpc_flow_logs_config_id.setter
    def vpc_flow_logs_config_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_flow_logs_config_id", value)

    @property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The aggregation interval for the logs. Default value is
        INTERVAL_5_SEC.   Possible values:  AGGREGATION_INTERVAL_UNSPECIFIED INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN"
        """
        return pulumi.get(self, "aggregation_interval")

    @aggregation_interval.setter
    def aggregation_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aggregation_interval", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
        of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="filterExpr")
    def filter_expr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Export filter used to define which VPC Flow Logs should be logged.
        """
        return pulumi.get(self, "filter_expr")

    @filter_expr.setter
    def filter_expr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_expr", value)

    @property
    @pulumi.getter(name="flowSampling")
    def flow_sampling(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Optional. The value of the field must be in (0, 1]. The sampling rate
        of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
        sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
        the state field instead. Default value is 1.0.
        """
        return pulumi.get(self, "flow_sampling")

    @flow_sampling.setter
    def flow_sampling(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "flow_sampling", value)

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Traffic will be logged from the Interconnect Attachment. Format: projects/{project_id}/regions/{region}/interconnectAttachments/{name}
        """
        return pulumi.get(self, "interconnect_attachment")

    @interconnect_attachment.setter
    def interconnect_attachment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interconnect_attachment", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Configures whether all, none or a subset of metadata fields
        should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
        Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optional. Custom metadata fields to include in the reported VPC flow
        logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        """
        return pulumi.get(self, "metadata_fields")

    @metadata_fields.setter
    def metadata_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata_fields", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The state of the VPC Flow Log configuration. Default value
        is ENABLED. When creating a new configuration, it must be enabled.   Possible
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="vpnTunnel")
    def vpn_tunnel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Traffic will be logged from the VPN Tunnel. Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
        """
        return pulumi.get(self, "vpn_tunnel")

    @vpn_tunnel.setter
    def vpn_tunnel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpn_tunnel", value)


@pulumi.input_type
class _VpcFlowLogsConfigState:
    def __init__(__self__, *,
                 aggregation_interval: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 filter_expr: Optional[pulumi.Input[builtins.str]] = None,
                 flow_sampling: Optional[pulumi.Input[builtins.float]] = None,
                 interconnect_attachment: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[builtins.str]] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_flow_logs_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcFlowLogsConfig resources.
        :param pulumi.Input[builtins.str] aggregation_interval: Optional. The aggregation interval for the logs. Default value is
               INTERVAL_5_SEC.   Possible values:  AGGREGATION_INTERVAL_UNSPECIFIED INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN"
        :param pulumi.Input[builtins.str] create_time: Output only. The time the config was created.
        :param pulumi.Input[builtins.str] description: Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
               of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] filter_expr: Optional. Export filter used to define which VPC Flow Logs should be logged.
        :param pulumi.Input[builtins.float] flow_sampling: Optional. The value of the field must be in (0, 1]. The sampling rate
               of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
               sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
               the state field instead. Default value is 1.0.
        :param pulumi.Input[builtins.str] interconnect_attachment: Traffic will be logged from the Interconnect Attachment. Format: projects/{project_id}/regions/{region}/interconnectAttachments/{name}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource
               within its parent collection as described in https://google.aip.dev/122. See documentation
               for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        :param pulumi.Input[builtins.str] metadata: Optional. Configures whether all, none or a subset of metadata fields
               should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
               Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] metadata_fields: Optional. Custom metadata fields to include in the reported VPC flow
               logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        :param pulumi.Input[builtins.str] name: Identifier. Unique name of the configuration using the form:     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: Optional. The state of the VPC Flow Log configuration. Default value
               is ENABLED. When creating a new configuration, it must be enabled.   Possible
        :param pulumi.Input[builtins.str] update_time: Output only. The time the config was updated.
        :param pulumi.Input[builtins.str] vpc_flow_logs_config_id: Required. ID of the `VpcFlowLogsConfig`.
        :param pulumi.Input[builtins.str] vpn_tunnel: Traffic will be logged from the VPN Tunnel. Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
        """
        if aggregation_interval is not None:
            pulumi.set(__self__, "aggregation_interval", aggregation_interval)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if filter_expr is not None:
            pulumi.set(__self__, "filter_expr", filter_expr)
        if flow_sampling is not None:
            pulumi.set(__self__, "flow_sampling", flow_sampling)
        if interconnect_attachment is not None:
            pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fields is not None:
            pulumi.set(__self__, "metadata_fields", metadata_fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpc_flow_logs_config_id is not None:
            pulumi.set(__self__, "vpc_flow_logs_config_id", vpc_flow_logs_config_id)
        if vpn_tunnel is not None:
            pulumi.set(__self__, "vpn_tunnel", vpn_tunnel)

    @property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The aggregation interval for the logs. Default value is
        INTERVAL_5_SEC.   Possible values:  AGGREGATION_INTERVAL_UNSPECIFIED INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN"
        """
        return pulumi.get(self, "aggregation_interval")

    @aggregation_interval.setter
    def aggregation_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aggregation_interval", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time the config was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
        of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="filterExpr")
    def filter_expr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Export filter used to define which VPC Flow Logs should be logged.
        """
        return pulumi.get(self, "filter_expr")

    @filter_expr.setter
    def filter_expr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_expr", value)

    @property
    @pulumi.getter(name="flowSampling")
    def flow_sampling(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Optional. The value of the field must be in (0, 1]. The sampling rate
        of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
        sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
        the state field instead. Default value is 1.0.
        """
        return pulumi.get(self, "flow_sampling")

    @flow_sampling.setter
    def flow_sampling(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "flow_sampling", value)

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Traffic will be logged from the Interconnect Attachment. Format: projects/{project_id}/regions/{region}/interconnectAttachments/{name}
        """
        return pulumi.get(self, "interconnect_attachment")

    @interconnect_attachment.setter
    def interconnect_attachment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interconnect_attachment", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource
        within its parent collection as described in https://google.aip.dev/122. See documentation
        for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Configures whether all, none or a subset of metadata fields
        should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
        Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optional. Custom metadata fields to include in the reported VPC flow
        logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        """
        return pulumi.get(self, "metadata_fields")

    @metadata_fields.setter
    def metadata_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata_fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. Unique name of the configuration using the form:     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The state of the VPC Flow Log configuration. Default value
        is ENABLED. When creating a new configuration, it must be enabled.   Possible
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time the config was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vpcFlowLogsConfigId")
    def vpc_flow_logs_config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. ID of the `VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "vpc_flow_logs_config_id")

    @vpc_flow_logs_config_id.setter
    def vpc_flow_logs_config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_flow_logs_config_id", value)

    @property
    @pulumi.getter(name="vpnTunnel")
    def vpn_tunnel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Traffic will be logged from the VPN Tunnel. Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
        """
        return pulumi.get(self, "vpn_tunnel")

    @vpn_tunnel.setter
    def vpn_tunnel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpn_tunnel", value)


@pulumi.type_token("gcp:networkmanagement/vpcFlowLogsConfig:VpcFlowLogsConfig")
class VpcFlowLogsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_interval: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filter_expr: Optional[pulumi.Input[builtins.str]] = None,
                 flow_sampling: Optional[pulumi.Input[builtins.float]] = None,
                 interconnect_attachment: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[builtins.str]] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_flow_logs_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        VPC Flow Logs Config is a resource that lets you configure Flow Logs for VPC, Interconnect attachments or VPN Tunnels.

        ## Example Usage

        ### Network Management Vpc Flow Logs Config Interconnect Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        network = gcp.compute.Network("network", name="full-interconnect-test-network")
        router = gcp.compute.Router("router",
            name="full-interconnect-test-router",
            network=network.name,
            bgp={
                "asn": 16550,
            })
        attachment = gcp.compute.InterconnectAttachment("attachment",
            name="full-interconnect-test-id",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            mtu="1500")
        interconnect_test = gcp.networkmanagement.VpcFlowLogsConfig("interconnect-test",
            vpc_flow_logs_config_id="full-interconnect-test-id",
            location="global",
            interconnect_attachment=attachment.name.apply(lambda name: f"projects/{project.number}/regions/us-east4/interconnectAttachments/{name}"),
            state="ENABLED",
            aggregation_interval="INTERVAL_5_SEC",
            description="VPC Flow Logs over a VPN Gateway.",
            flow_sampling=0.5,
            metadata="INCLUDE_ALL_METADATA")
        ```
        ### Network Management Vpc Flow Logs Config Interconnect Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        network = gcp.compute.Network("network", name="basic-interconnect-test-network")
        router = gcp.compute.Router("router",
            name="basic-interconnect-test-router",
            network=network.name,
            bgp={
                "asn": 16550,
            })
        attachment = gcp.compute.InterconnectAttachment("attachment",
            name="basic-interconnect-test-id",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            mtu="1500")
        interconnect_test = gcp.networkmanagement.VpcFlowLogsConfig("interconnect-test",
            vpc_flow_logs_config_id="basic-interconnect-test-id",
            location="global",
            interconnect_attachment=attachment.name.apply(lambda name: f"projects/{project.number}/regions/us-east4/interconnectAttachments/{name}"))
        ```
        ### Network Management Vpc Flow Logs Config Vpn Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        network = gcp.compute.Network("network", name="basic-test-network")
        target_gateway = gcp.compute.VPNGateway("target_gateway",
            name="basic-test-gateway",
            network=network.id)
        vpn_static_ip = gcp.compute.Address("vpn_static_ip", name="basic-test-address")
        fr_esp = gcp.compute.ForwardingRule("fr_esp",
            name="basic-test-fresp",
            ip_protocol="ESP",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        fr_udp500 = gcp.compute.ForwardingRule("fr_udp500",
            name="basic-test-fr500",
            ip_protocol="UDP",
            port_range="500",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        fr_udp4500 = gcp.compute.ForwardingRule("fr_udp4500",
            name="basic-test-fr4500",
            ip_protocol="UDP",
            port_range="4500",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        tunnel = gcp.compute.VPNTunnel("tunnel",
            name="basic-test-tunnel",
            peer_ip="15.0.0.120",
            shared_secret="a secret message",
            target_vpn_gateway=target_gateway.id,
            opts = pulumi.ResourceOptions(depends_on=[
                    fr_esp,
                    fr_udp500,
                    fr_udp4500,
                ]))
        vpn_test = gcp.networkmanagement.VpcFlowLogsConfig("vpn-test",
            vpc_flow_logs_config_id="basic-test-id",
            location="global",
            vpn_tunnel=tunnel.name.apply(lambda name: f"projects/{project.number}/regions/us-central1/vpnTunnels/{name}"))
        route = gcp.compute.Route("route",
            name="basic-test-route",
            network=network.name,
            dest_range="15.0.0.0/24",
            priority=1000,
            next_hop_vpn_tunnel=tunnel.id)
        ```
        ### Network Management Vpc Flow Logs Config Vpn Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        network = gcp.compute.Network("network", name="full-test-network")
        target_gateway = gcp.compute.VPNGateway("target_gateway",
            name="full-test-gateway",
            network=network.id)
        vpn_static_ip = gcp.compute.Address("vpn_static_ip", name="full-test-address")
        fr_esp = gcp.compute.ForwardingRule("fr_esp",
            name="full-test-fresp",
            ip_protocol="ESP",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        fr_udp500 = gcp.compute.ForwardingRule("fr_udp500",
            name="full-test-fr500",
            ip_protocol="UDP",
            port_range="500",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        fr_udp4500 = gcp.compute.ForwardingRule("fr_udp4500",
            name="full-test-fr4500",
            ip_protocol="UDP",
            port_range="4500",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        tunnel = gcp.compute.VPNTunnel("tunnel",
            name="full-test-tunnel",
            peer_ip="15.0.0.120",
            shared_secret="a secret message",
            target_vpn_gateway=target_gateway.id,
            opts = pulumi.ResourceOptions(depends_on=[
                    fr_esp,
                    fr_udp500,
                    fr_udp4500,
                ]))
        vpn_test = gcp.networkmanagement.VpcFlowLogsConfig("vpn-test",
            vpc_flow_logs_config_id="full-test-id",
            location="global",
            vpn_tunnel=tunnel.name.apply(lambda name: f"projects/{project.number}/regions/us-central1/vpnTunnels/{name}"),
            state="ENABLED",
            aggregation_interval="INTERVAL_5_SEC",
            description="VPC Flow Logs over a VPN Gateway.",
            flow_sampling=0.5,
            metadata="INCLUDE_ALL_METADATA")
        route = gcp.compute.Route("route",
            name="full-test-route",
            network=network.name,
            dest_range="15.0.0.0/24",
            priority=1000,
            next_hop_vpn_tunnel=tunnel.id)
        ```

        ## Import

        VpcFlowLogsConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vpcFlowLogsConfigs/{{vpc_flow_logs_config_id}}`

        * `{{project}}/{{location}}/{{vpc_flow_logs_config_id}}`

        * `{{location}}/{{vpc_flow_logs_config_id}}`

        When using the `pulumi import` command, VpcFlowLogsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkmanagement/vpcFlowLogsConfig:VpcFlowLogsConfig default projects/{{project}}/locations/{{location}}/vpcFlowLogsConfigs/{{vpc_flow_logs_config_id}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/vpcFlowLogsConfig:VpcFlowLogsConfig default {{project}}/{{location}}/{{vpc_flow_logs_config_id}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/vpcFlowLogsConfig:VpcFlowLogsConfig default {{location}}/{{vpc_flow_logs_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aggregation_interval: Optional. The aggregation interval for the logs. Default value is
               INTERVAL_5_SEC.   Possible values:  AGGREGATION_INTERVAL_UNSPECIFIED INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN"
        :param pulumi.Input[builtins.str] description: Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
               of 512 characters.
        :param pulumi.Input[builtins.str] filter_expr: Optional. Export filter used to define which VPC Flow Logs should be logged.
        :param pulumi.Input[builtins.float] flow_sampling: Optional. The value of the field must be in (0, 1]. The sampling rate
               of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
               sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
               the state field instead. Default value is 1.0.
        :param pulumi.Input[builtins.str] interconnect_attachment: Traffic will be logged from the Interconnect Attachment. Format: projects/{project_id}/regions/{region}/interconnectAttachments/{name}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource
               within its parent collection as described in https://google.aip.dev/122. See documentation
               for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        :param pulumi.Input[builtins.str] metadata: Optional. Configures whether all, none or a subset of metadata fields
               should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
               Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] metadata_fields: Optional. Custom metadata fields to include in the reported VPC flow
               logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: Optional. The state of the VPC Flow Log configuration. Default value
               is ENABLED. When creating a new configuration, it must be enabled.   Possible
        :param pulumi.Input[builtins.str] vpc_flow_logs_config_id: Required. ID of the `VpcFlowLogsConfig`.
        :param pulumi.Input[builtins.str] vpn_tunnel: Traffic will be logged from the VPN Tunnel. Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcFlowLogsConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        VPC Flow Logs Config is a resource that lets you configure Flow Logs for VPC, Interconnect attachments or VPN Tunnels.

        ## Example Usage

        ### Network Management Vpc Flow Logs Config Interconnect Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        network = gcp.compute.Network("network", name="full-interconnect-test-network")
        router = gcp.compute.Router("router",
            name="full-interconnect-test-router",
            network=network.name,
            bgp={
                "asn": 16550,
            })
        attachment = gcp.compute.InterconnectAttachment("attachment",
            name="full-interconnect-test-id",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            mtu="1500")
        interconnect_test = gcp.networkmanagement.VpcFlowLogsConfig("interconnect-test",
            vpc_flow_logs_config_id="full-interconnect-test-id",
            location="global",
            interconnect_attachment=attachment.name.apply(lambda name: f"projects/{project.number}/regions/us-east4/interconnectAttachments/{name}"),
            state="ENABLED",
            aggregation_interval="INTERVAL_5_SEC",
            description="VPC Flow Logs over a VPN Gateway.",
            flow_sampling=0.5,
            metadata="INCLUDE_ALL_METADATA")
        ```
        ### Network Management Vpc Flow Logs Config Interconnect Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        network = gcp.compute.Network("network", name="basic-interconnect-test-network")
        router = gcp.compute.Router("router",
            name="basic-interconnect-test-router",
            network=network.name,
            bgp={
                "asn": 16550,
            })
        attachment = gcp.compute.InterconnectAttachment("attachment",
            name="basic-interconnect-test-id",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            mtu="1500")
        interconnect_test = gcp.networkmanagement.VpcFlowLogsConfig("interconnect-test",
            vpc_flow_logs_config_id="basic-interconnect-test-id",
            location="global",
            interconnect_attachment=attachment.name.apply(lambda name: f"projects/{project.number}/regions/us-east4/interconnectAttachments/{name}"))
        ```
        ### Network Management Vpc Flow Logs Config Vpn Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        network = gcp.compute.Network("network", name="basic-test-network")
        target_gateway = gcp.compute.VPNGateway("target_gateway",
            name="basic-test-gateway",
            network=network.id)
        vpn_static_ip = gcp.compute.Address("vpn_static_ip", name="basic-test-address")
        fr_esp = gcp.compute.ForwardingRule("fr_esp",
            name="basic-test-fresp",
            ip_protocol="ESP",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        fr_udp500 = gcp.compute.ForwardingRule("fr_udp500",
            name="basic-test-fr500",
            ip_protocol="UDP",
            port_range="500",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        fr_udp4500 = gcp.compute.ForwardingRule("fr_udp4500",
            name="basic-test-fr4500",
            ip_protocol="UDP",
            port_range="4500",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        tunnel = gcp.compute.VPNTunnel("tunnel",
            name="basic-test-tunnel",
            peer_ip="15.0.0.120",
            shared_secret="a secret message",
            target_vpn_gateway=target_gateway.id,
            opts = pulumi.ResourceOptions(depends_on=[
                    fr_esp,
                    fr_udp500,
                    fr_udp4500,
                ]))
        vpn_test = gcp.networkmanagement.VpcFlowLogsConfig("vpn-test",
            vpc_flow_logs_config_id="basic-test-id",
            location="global",
            vpn_tunnel=tunnel.name.apply(lambda name: f"projects/{project.number}/regions/us-central1/vpnTunnels/{name}"))
        route = gcp.compute.Route("route",
            name="basic-test-route",
            network=network.name,
            dest_range="15.0.0.0/24",
            priority=1000,
            next_hop_vpn_tunnel=tunnel.id)
        ```
        ### Network Management Vpc Flow Logs Config Vpn Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        network = gcp.compute.Network("network", name="full-test-network")
        target_gateway = gcp.compute.VPNGateway("target_gateway",
            name="full-test-gateway",
            network=network.id)
        vpn_static_ip = gcp.compute.Address("vpn_static_ip", name="full-test-address")
        fr_esp = gcp.compute.ForwardingRule("fr_esp",
            name="full-test-fresp",
            ip_protocol="ESP",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        fr_udp500 = gcp.compute.ForwardingRule("fr_udp500",
            name="full-test-fr500",
            ip_protocol="UDP",
            port_range="500",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        fr_udp4500 = gcp.compute.ForwardingRule("fr_udp4500",
            name="full-test-fr4500",
            ip_protocol="UDP",
            port_range="4500",
            ip_address=vpn_static_ip.address,
            target=target_gateway.id)
        tunnel = gcp.compute.VPNTunnel("tunnel",
            name="full-test-tunnel",
            peer_ip="15.0.0.120",
            shared_secret="a secret message",
            target_vpn_gateway=target_gateway.id,
            opts = pulumi.ResourceOptions(depends_on=[
                    fr_esp,
                    fr_udp500,
                    fr_udp4500,
                ]))
        vpn_test = gcp.networkmanagement.VpcFlowLogsConfig("vpn-test",
            vpc_flow_logs_config_id="full-test-id",
            location="global",
            vpn_tunnel=tunnel.name.apply(lambda name: f"projects/{project.number}/regions/us-central1/vpnTunnels/{name}"),
            state="ENABLED",
            aggregation_interval="INTERVAL_5_SEC",
            description="VPC Flow Logs over a VPN Gateway.",
            flow_sampling=0.5,
            metadata="INCLUDE_ALL_METADATA")
        route = gcp.compute.Route("route",
            name="full-test-route",
            network=network.name,
            dest_range="15.0.0.0/24",
            priority=1000,
            next_hop_vpn_tunnel=tunnel.id)
        ```

        ## Import

        VpcFlowLogsConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/vpcFlowLogsConfigs/{{vpc_flow_logs_config_id}}`

        * `{{project}}/{{location}}/{{vpc_flow_logs_config_id}}`

        * `{{location}}/{{vpc_flow_logs_config_id}}`

        When using the `pulumi import` command, VpcFlowLogsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkmanagement/vpcFlowLogsConfig:VpcFlowLogsConfig default projects/{{project}}/locations/{{location}}/vpcFlowLogsConfigs/{{vpc_flow_logs_config_id}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/vpcFlowLogsConfig:VpcFlowLogsConfig default {{project}}/{{location}}/{{vpc_flow_logs_config_id}}
        ```

        ```sh
        $ pulumi import gcp:networkmanagement/vpcFlowLogsConfig:VpcFlowLogsConfig default {{location}}/{{vpc_flow_logs_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param VpcFlowLogsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcFlowLogsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_interval: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filter_expr: Optional[pulumi.Input[builtins.str]] = None,
                 flow_sampling: Optional[pulumi.Input[builtins.float]] = None,
                 interconnect_attachment: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[builtins.str]] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_flow_logs_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcFlowLogsConfigArgs.__new__(VpcFlowLogsConfigArgs)

            __props__.__dict__["aggregation_interval"] = aggregation_interval
            __props__.__dict__["description"] = description
            __props__.__dict__["filter_expr"] = filter_expr
            __props__.__dict__["flow_sampling"] = flow_sampling
            __props__.__dict__["interconnect_attachment"] = interconnect_attachment
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metadata_fields"] = metadata_fields
            __props__.__dict__["project"] = project
            __props__.__dict__["state"] = state
            if vpc_flow_logs_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_flow_logs_config_id'")
            __props__.__dict__["vpc_flow_logs_config_id"] = vpc_flow_logs_config_id
            __props__.__dict__["vpn_tunnel"] = vpn_tunnel
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VpcFlowLogsConfig, __self__).__init__(
            'gcp:networkmanagement/vpcFlowLogsConfig:VpcFlowLogsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation_interval: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            filter_expr: Optional[pulumi.Input[builtins.str]] = None,
            flow_sampling: Optional[pulumi.Input[builtins.float]] = None,
            interconnect_attachment: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[builtins.str]] = None,
            metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            vpc_flow_logs_config_id: Optional[pulumi.Input[builtins.str]] = None,
            vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None) -> 'VpcFlowLogsConfig':
        """
        Get an existing VpcFlowLogsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aggregation_interval: Optional. The aggregation interval for the logs. Default value is
               INTERVAL_5_SEC.   Possible values:  AGGREGATION_INTERVAL_UNSPECIFIED INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN"
        :param pulumi.Input[builtins.str] create_time: Output only. The time the config was created.
        :param pulumi.Input[builtins.str] description: Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
               of 512 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] filter_expr: Optional. Export filter used to define which VPC Flow Logs should be logged.
        :param pulumi.Input[builtins.float] flow_sampling: Optional. The value of the field must be in (0, 1]. The sampling rate
               of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
               sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
               the state field instead. Default value is 1.0.
        :param pulumi.Input[builtins.str] interconnect_attachment: Traffic will be logged from the Interconnect Attachment. Format: projects/{project_id}/regions/{region}/interconnectAttachments/{name}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Resource labels to represent user-provided metadata.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource
               within its parent collection as described in https://google.aip.dev/122. See documentation
               for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        :param pulumi.Input[builtins.str] metadata: Optional. Configures whether all, none or a subset of metadata fields
               should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
               Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] metadata_fields: Optional. Custom metadata fields to include in the reported VPC flow
               logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        :param pulumi.Input[builtins.str] name: Identifier. Unique name of the configuration using the form:     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: Optional. The state of the VPC Flow Log configuration. Default value
               is ENABLED. When creating a new configuration, it must be enabled.   Possible
        :param pulumi.Input[builtins.str] update_time: Output only. The time the config was updated.
        :param pulumi.Input[builtins.str] vpc_flow_logs_config_id: Required. ID of the `VpcFlowLogsConfig`.
        :param pulumi.Input[builtins.str] vpn_tunnel: Traffic will be logged from the VPN Tunnel. Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcFlowLogsConfigState.__new__(_VpcFlowLogsConfigState)

        __props__.__dict__["aggregation_interval"] = aggregation_interval
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["filter_expr"] = filter_expr
        __props__.__dict__["flow_sampling"] = flow_sampling
        __props__.__dict__["interconnect_attachment"] = interconnect_attachment
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_fields"] = metadata_fields
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpc_flow_logs_config_id"] = vpc_flow_logs_config_id
        __props__.__dict__["vpn_tunnel"] = vpn_tunnel
        return VpcFlowLogsConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> pulumi.Output[builtins.str]:
        """
        Optional. The aggregation interval for the logs. Default value is
        INTERVAL_5_SEC.   Possible values:  AGGREGATION_INTERVAL_UNSPECIFIED INTERVAL_5_SEC INTERVAL_30_SEC INTERVAL_1_MIN INTERVAL_5_MIN INTERVAL_10_MIN INTERVAL_15_MIN"
        """
        return pulumi.get(self, "aggregation_interval")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time the config was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. The user-supplied description of the VPC Flow Logs configuration. Maximum
        of 512 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="filterExpr")
    def filter_expr(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. Export filter used to define which VPC Flow Logs should be logged.
        """
        return pulumi.get(self, "filter_expr")

    @property
    @pulumi.getter(name="flowSampling")
    def flow_sampling(self) -> pulumi.Output[builtins.float]:
        """
        Optional. The value of the field must be in (0, 1]. The sampling rate
        of VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
        sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs, use
        the state field instead. Default value is 1.0.
        """
        return pulumi.get(self, "flow_sampling")

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Traffic will be logged from the Interconnect Attachment. Format: projects/{project_id}/regions/{region}/interconnectAttachments/{name}
        """
        return pulumi.get(self, "interconnect_attachment")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Resource labels to represent user-provided metadata.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource
        within its parent collection as described in https://google.aip.dev/122. See documentation
        for resource type `networkmanagement.googleapis.com/VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[builtins.str]:
        """
        Optional. Configures whether all, none or a subset of metadata fields
        should be added to the reported VPC flow logs. Default value is INCLUDE_ALL_METADATA.
        Possible values:  METADATA_UNSPECIFIED INCLUDE_ALL_METADATA EXCLUDE_ALL_METADATA CUSTOM_METADATA
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Optional. Custom metadata fields to include in the reported VPC flow
        logs. Can only be specified if \\"metadata\\" was set to CUSTOM_METADATA.
        """
        return pulumi.get(self, "metadata_fields")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. Unique name of the configuration using the form:     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Optional. The state of the VPC Flow Log configuration. Default value
        is ENABLED. When creating a new configuration, it must be enabled.   Possible
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time the config was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcFlowLogsConfigId")
    def vpc_flow_logs_config_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. ID of the `VpcFlowLogsConfig`.
        """
        return pulumi.get(self, "vpc_flow_logs_config_id")

    @property
    @pulumi.getter(name="vpnTunnel")
    def vpn_tunnel(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Traffic will be logged from the VPN Tunnel. Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
        """
        return pulumi.get(self, "vpn_tunnel")

