# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AddressGroupArgs', 'AddressGroup']

@pulumi.input_type
class AddressGroupArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[builtins.int],
                 location: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 purposes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AddressGroup resource.
        :param pulumi.Input[builtins.int] capacity: Capacity of the Address Group.
        :param pulumi.Input[builtins.str] location: The location of the gateway security policy.
               The default value is `global`.
        :param pulumi.Input[builtins.str] type: The type of the Address Group. Possible values are "IPV4" or "IPV6".
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: List of items.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the AddressGroup resource.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the AddressGroup resource.
        :param pulumi.Input[builtins.str] parent: The name of the parent this address group belongs to. Format: organizations/{organization_id} or projects/{project_id}.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] purposes: List of supported purposes of the Address Group.
               Each value may be one of: `DEFAULT`, `CLOUD_ARMOR`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if purposes is not None:
            pulumi.set(__self__, "purposes", purposes)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[builtins.int]:
        """
        Capacity of the Address Group.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the gateway security policy.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the Address Group. Possible values are "IPV4" or "IPV6".
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of items.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the AddressGroup resource.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the AddressGroup resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the parent this address group belongs to. Format: organizations/{organization_id} or projects/{project_id}.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def purposes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported purposes of the Address Group.
        Each value may be one of: `DEFAULT`, `CLOUD_ARMOR`.
        """
        return pulumi.get(self, "purposes")

    @purposes.setter
    def purposes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "purposes", value)


@pulumi.input_type
class _AddressGroupState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 purposes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddressGroup resources.
        :param pulumi.Input[builtins.int] capacity: Capacity of the Address Group.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: List of items.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the AddressGroup resource.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the gateway security policy.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the AddressGroup resource.
        :param pulumi.Input[builtins.str] parent: The name of the parent this address group belongs to. Format: organizations/{organization_id} or projects/{project_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] purposes: List of supported purposes of the Address Group.
               Each value may be one of: `DEFAULT`, `CLOUD_ARMOR`.
        :param pulumi.Input[builtins.str] type: The type of the Address Group. Possible values are "IPV4" or "IPV6".
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if purposes is not None:
            pulumi.set(__self__, "purposes", purposes)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Capacity of the Address Group.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of items.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the AddressGroup resource.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the gateway security policy.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the AddressGroup resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the parent this address group belongs to. Format: organizations/{organization_id} or projects/{project_id}.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def purposes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported purposes of the Address Group.
        Each value may be one of: `DEFAULT`, `CLOUD_ARMOR`.
        """
        return pulumi.get(self, "purposes")

    @purposes.setter
    def purposes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "purposes", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the Address Group. Possible values are "IPV4" or "IPV6".
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networksecurity/addressGroup:AddressGroup")
class AddressGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 purposes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        AddressGroup is a resource that specifies how a collection of IP/DNS used in Firewall Policy.

        To get more information about AddressGroup, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-security/rest/v1beta1/organizations.locations.addressGroups)
        * How-to Guides
            * [Use AddressGroups](https://cloud.google.com/vpc/docs/use-address-groups-firewall-policies)

        ## Example Usage

        ### Network Security Address Groups Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.AddressGroup("default",
            name="my-address-groups",
            parent="projects/my-project-name",
            location="us-central1",
            type="IPV4",
            capacity=100,
            items=["208.80.154.224/32"])
        ```
        ### Network Security Address Groups Organization Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.AddressGroup("default",
            name="my-address-groups",
            parent="organizations/123456789",
            location="us-central1",
            type="IPV4",
            capacity=100,
            items=["208.80.154.224/32"])
        ```
        ### Network Security Address Groups Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.AddressGroup("default",
            name="my-address-groups",
            parent="projects/my-project-name",
            location="us-central1",
            description="my description",
            type="IPV4",
            capacity=100,
            items=["208.80.154.224/32"])
        ```
        ### Network Security Address Groups Cloud Armor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.AddressGroup("default",
            name="my-address-groups",
            parent="projects/my-project-name",
            location="global",
            type="IPV4",
            capacity=100,
            purposes=["CLOUD_ARMOR"],
            items=["208.80.154.224/32"])
        ```

        ## Import

        AddressGroup can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/addressGroups/{{name}}`

        When using the `pulumi import` command, AddressGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/addressGroup:AddressGroup default {{parent}}/locations/{{location}}/addressGroups/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] capacity: Capacity of the Address Group.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: List of items.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the AddressGroup resource.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the gateway security policy.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the AddressGroup resource.
        :param pulumi.Input[builtins.str] parent: The name of the parent this address group belongs to. Format: organizations/{organization_id} or projects/{project_id}.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] purposes: List of supported purposes of the Address Group.
               Each value may be one of: `DEFAULT`, `CLOUD_ARMOR`.
        :param pulumi.Input[builtins.str] type: The type of the Address Group. Possible values are "IPV4" or "IPV6".
               Possible values are: `IPV4`, `IPV6`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddressGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AddressGroup is a resource that specifies how a collection of IP/DNS used in Firewall Policy.

        To get more information about AddressGroup, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-security/rest/v1beta1/organizations.locations.addressGroups)
        * How-to Guides
            * [Use AddressGroups](https://cloud.google.com/vpc/docs/use-address-groups-firewall-policies)

        ## Example Usage

        ### Network Security Address Groups Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.AddressGroup("default",
            name="my-address-groups",
            parent="projects/my-project-name",
            location="us-central1",
            type="IPV4",
            capacity=100,
            items=["208.80.154.224/32"])
        ```
        ### Network Security Address Groups Organization Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.AddressGroup("default",
            name="my-address-groups",
            parent="organizations/123456789",
            location="us-central1",
            type="IPV4",
            capacity=100,
            items=["208.80.154.224/32"])
        ```
        ### Network Security Address Groups Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.AddressGroup("default",
            name="my-address-groups",
            parent="projects/my-project-name",
            location="us-central1",
            description="my description",
            type="IPV4",
            capacity=100,
            items=["208.80.154.224/32"])
        ```
        ### Network Security Address Groups Cloud Armor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.AddressGroup("default",
            name="my-address-groups",
            parent="projects/my-project-name",
            location="global",
            type="IPV4",
            capacity=100,
            purposes=["CLOUD_ARMOR"],
            items=["208.80.154.224/32"])
        ```

        ## Import

        AddressGroup can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/addressGroups/{{name}}`

        When using the `pulumi import` command, AddressGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/addressGroup:AddressGroup default {{parent}}/locations/{{location}}/addressGroups/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AddressGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 purposes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressGroupArgs.__new__(AddressGroupArgs)

            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["description"] = description
            __props__.__dict__["items"] = items
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["parent"] = parent
            __props__.__dict__["purposes"] = purposes
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AddressGroup, __self__).__init__(
            'gcp:networksecurity/addressGroup:AddressGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[builtins.int]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            purposes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'AddressGroup':
        """
        Get an existing AddressGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] capacity: Capacity of the Address Group.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] items: List of items.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the AddressGroup resource.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the gateway security policy.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the AddressGroup resource.
        :param pulumi.Input[builtins.str] parent: The name of the parent this address group belongs to. Format: organizations/{organization_id} or projects/{project_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] purposes: List of supported purposes of the Address Group.
               Each value may be one of: `DEFAULT`, `CLOUD_ARMOR`.
        :param pulumi.Input[builtins.str] type: The type of the Address Group. Possible values are "IPV4" or "IPV6".
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressGroupState.__new__(_AddressGroupState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["items"] = items
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["purposes"] = purposes
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        return AddressGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[builtins.int]:
        """
        Capacity of the Address Group.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of items.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Set of label tags associated with the AddressGroup resource.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the gateway security policy.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the AddressGroup resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the parent this address group belongs to. Format: organizations/{organization_id} or projects/{project_id}.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def purposes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported purposes of the Address Group.
        Each value may be one of: `DEFAULT`, `CLOUD_ARMOR`.
        """
        return pulumi.get(self, "purposes")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the Address Group. Possible values are "IPV4" or "IPV6".
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

