# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackendAuthenticationConfigArgs', 'BackendAuthenticationConfig']

@pulumi.input_type
class BackendAuthenticationConfigArgs:
    def __init__(__self__, *,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 trust_config: Optional[pulumi.Input[builtins.str]] = None,
                 well_known_roots: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BackendAuthenticationConfig resource.
        :param pulumi.Input[builtins.str] client_certificate: Reference to a Certificate resource from the certificatemanager.googleapis.com namespace.
               Used by a BackendService to negotiate mTLS when the backend connection uses TLS and the backend requests a client certificate. Must have a CLIENT_AUTH scope.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the BackendAuthenticationConfig resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the backend authentication config.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the BackendAuthenticationConfig resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] trust_config: Reference to a TrustConfig resource from the certificatemanager.googleapis.com namespace.
               A BackendService uses the chain of trust represented by this TrustConfig, if specified, to validate the server certificates presented by the backend. Required unless wellKnownRoots is set to PUBLIC_ROOTS.
        :param pulumi.Input[builtins.str] well_known_roots: Well known roots to use for server certificate validation. If set to NONE, the BackendService will only validate server certificates against roots specified in TrustConfig.
               If set to PUBLIC_ROOTS, the BackendService uses a set of well-known public roots, in addition to any roots specified in the trustConfig field, when validating the server certificates presented by the backend.
               Validation with these roots is only considered when the TlsSettings.sni field in the BackendService is set. The well-known roots are a set of root CAs managed by Google. CAs in this set can be added or removed without notice.
               Possible values are: `NONE`, `PUBLIC_ROOTS`.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if trust_config is not None:
            pulumi.set(__self__, "trust_config", trust_config)
        if well_known_roots is not None:
            pulumi.set(__self__, "well_known_roots", well_known_roots)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reference to a Certificate resource from the certificatemanager.googleapis.com namespace.
        Used by a BackendService to negotiate mTLS when the backend connection uses TLS and the backend requests a client certificate. Must have a CLIENT_AUTH scope.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the BackendAuthenticationConfig resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the backend authentication config.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the BackendAuthenticationConfig resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="trustConfig")
    def trust_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reference to a TrustConfig resource from the certificatemanager.googleapis.com namespace.
        A BackendService uses the chain of trust represented by this TrustConfig, if specified, to validate the server certificates presented by the backend. Required unless wellKnownRoots is set to PUBLIC_ROOTS.
        """
        return pulumi.get(self, "trust_config")

    @trust_config.setter
    def trust_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_config", value)

    @property
    @pulumi.getter(name="wellKnownRoots")
    def well_known_roots(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Well known roots to use for server certificate validation. If set to NONE, the BackendService will only validate server certificates against roots specified in TrustConfig.
        If set to PUBLIC_ROOTS, the BackendService uses a set of well-known public roots, in addition to any roots specified in the trustConfig field, when validating the server certificates presented by the backend.
        Validation with these roots is only considered when the TlsSettings.sni field in the BackendService is set. The well-known roots are a set of root CAs managed by Google. CAs in this set can be added or removed without notice.
        Possible values are: `NONE`, `PUBLIC_ROOTS`.
        """
        return pulumi.get(self, "well_known_roots")

    @well_known_roots.setter
    def well_known_roots(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "well_known_roots", value)


@pulumi.input_type
class _BackendAuthenticationConfigState:
    def __init__(__self__, *,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 trust_config: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 well_known_roots: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackendAuthenticationConfig resources.
        :param pulumi.Input[builtins.str] client_certificate: Reference to a Certificate resource from the certificatemanager.googleapis.com namespace.
               Used by a BackendService to negotiate mTLS when the backend connection uses TLS and the backend requests a client certificate. Must have a CLIENT_AUTH scope.
        :param pulumi.Input[builtins.str] create_time: Time the BackendAuthenticationConfig was created in UTC.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the BackendAuthenticationConfig resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the backend authentication config.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the BackendAuthenticationConfig resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] trust_config: Reference to a TrustConfig resource from the certificatemanager.googleapis.com namespace.
               A BackendService uses the chain of trust represented by this TrustConfig, if specified, to validate the server certificates presented by the backend. Required unless wellKnownRoots is set to PUBLIC_ROOTS.
        :param pulumi.Input[builtins.str] update_time: Time the BackendAuthenticationConfig was updated in UTC.
        :param pulumi.Input[builtins.str] well_known_roots: Well known roots to use for server certificate validation. If set to NONE, the BackendService will only validate server certificates against roots specified in TrustConfig.
               If set to PUBLIC_ROOTS, the BackendService uses a set of well-known public roots, in addition to any roots specified in the trustConfig field, when validating the server certificates presented by the backend.
               Validation with these roots is only considered when the TlsSettings.sni field in the BackendService is set. The well-known roots are a set of root CAs managed by Google. CAs in this set can be added or removed without notice.
               Possible values are: `NONE`, `PUBLIC_ROOTS`.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if trust_config is not None:
            pulumi.set(__self__, "trust_config", trust_config)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if well_known_roots is not None:
            pulumi.set(__self__, "well_known_roots", well_known_roots)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reference to a Certificate resource from the certificatemanager.googleapis.com namespace.
        Used by a BackendService to negotiate mTLS when the backend connection uses TLS and the backend requests a client certificate. Must have a CLIENT_AUTH scope.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the BackendAuthenticationConfig was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the BackendAuthenticationConfig resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the backend authentication config.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the BackendAuthenticationConfig resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="trustConfig")
    def trust_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reference to a TrustConfig resource from the certificatemanager.googleapis.com namespace.
        A BackendService uses the chain of trust represented by this TrustConfig, if specified, to validate the server certificates presented by the backend. Required unless wellKnownRoots is set to PUBLIC_ROOTS.
        """
        return pulumi.get(self, "trust_config")

    @trust_config.setter
    def trust_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_config", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the BackendAuthenticationConfig was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="wellKnownRoots")
    def well_known_roots(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Well known roots to use for server certificate validation. If set to NONE, the BackendService will only validate server certificates against roots specified in TrustConfig.
        If set to PUBLIC_ROOTS, the BackendService uses a set of well-known public roots, in addition to any roots specified in the trustConfig field, when validating the server certificates presented by the backend.
        Validation with these roots is only considered when the TlsSettings.sni field in the BackendService is set. The well-known roots are a set of root CAs managed by Google. CAs in this set can be added or removed without notice.
        Possible values are: `NONE`, `PUBLIC_ROOTS`.
        """
        return pulumi.get(self, "well_known_roots")

    @well_known_roots.setter
    def well_known_roots(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "well_known_roots", value)


@pulumi.type_token("gcp:networksecurity/backendAuthenticationConfig:BackendAuthenticationConfig")
class BackendAuthenticationConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 trust_config: Optional[pulumi.Input[builtins.str]] = None,
                 well_known_roots: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        BackendAuthenticationConfig groups the TrustConfig together with other settings that control how the load balancer authenticates, and expresses its identity to the backend.

        To get more information about BackendAuthenticationConfig, see:
        * How-to Guides
            * [Backend mTLS](https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#backend-authentication-config)

        ## Example Usage

        ### Network Security Backend Authentication Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.BackendAuthenticationConfig("default",
            name="my-backend-authentication-config",
            labels={
                "foo": "bar",
            },
            description="my description",
            well_known_roots="PUBLIC_ROOTS")
        ```
        ### Network Security Backend Authentication Config Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        certificate = gcp.certificatemanager.Certificate("certificate",
            name="my-certificate",
            labels={
                "foo": "bar",
            },
            location="global",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/key.pem").result,
            },
            scope="CLIENT_AUTH")
        trust_config = gcp.certificatemanager.TrustConfig("trust_config",
            name="my-trust-config",
            description="sample description for the trust config",
            location="global",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                }],
            }],
            labels={
                "foo": "bar",
            })
        default = gcp.networksecurity.BackendAuthenticationConfig("default",
            name="my-backend-authentication-config",
            labels={
                "bar": "foo",
            },
            location="global",
            description="my description",
            well_known_roots="PUBLIC_ROOTS",
            client_certificate=certificate.id,
            trust_config=trust_config.id)
        ```
        ### Backend Service Tls Settings

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default_backend_authentication_config = gcp.networksecurity.BackendAuthenticationConfig("default",
            name="authentication",
            well_known_roots="PUBLIC_ROOTS")
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            protocol="HTTPS",
            tls_settings={
                "sni": "example.com",
                "subject_alt_names": [
                    {
                        "dns_name": "example.com",
                    },
                    {
                        "uniform_resource_identifier": "https://example.com",
                    },
                ],
                "authentication_config": default_backend_authentication_config.id.apply(lambda id: f"//networksecurity.googleapis.com/{id}"),
            })
        ```

        ## Import

        BackendAuthenticationConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backendAuthenticationConfigs/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, BackendAuthenticationConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/backendAuthenticationConfig:BackendAuthenticationConfig default projects/{{project}}/locations/{{location}}/backendAuthenticationConfigs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/backendAuthenticationConfig:BackendAuthenticationConfig default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/backendAuthenticationConfig:BackendAuthenticationConfig default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_certificate: Reference to a Certificate resource from the certificatemanager.googleapis.com namespace.
               Used by a BackendService to negotiate mTLS when the backend connection uses TLS and the backend requests a client certificate. Must have a CLIENT_AUTH scope.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the BackendAuthenticationConfig resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the backend authentication config.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the BackendAuthenticationConfig resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] trust_config: Reference to a TrustConfig resource from the certificatemanager.googleapis.com namespace.
               A BackendService uses the chain of trust represented by this TrustConfig, if specified, to validate the server certificates presented by the backend. Required unless wellKnownRoots is set to PUBLIC_ROOTS.
        :param pulumi.Input[builtins.str] well_known_roots: Well known roots to use for server certificate validation. If set to NONE, the BackendService will only validate server certificates against roots specified in TrustConfig.
               If set to PUBLIC_ROOTS, the BackendService uses a set of well-known public roots, in addition to any roots specified in the trustConfig field, when validating the server certificates presented by the backend.
               Validation with these roots is only considered when the TlsSettings.sni field in the BackendService is set. The well-known roots are a set of root CAs managed by Google. CAs in this set can be added or removed without notice.
               Possible values are: `NONE`, `PUBLIC_ROOTS`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BackendAuthenticationConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        BackendAuthenticationConfig groups the TrustConfig together with other settings that control how the load balancer authenticates, and expresses its identity to the backend.

        To get more information about BackendAuthenticationConfig, see:
        * How-to Guides
            * [Backend mTLS](https://cloud.google.com/load-balancing/docs/backend-authenticated-tls-backend-mtls#backend-authentication-config)

        ## Example Usage

        ### Network Security Backend Authentication Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.BackendAuthenticationConfig("default",
            name="my-backend-authentication-config",
            labels={
                "foo": "bar",
            },
            description="my description",
            well_known_roots="PUBLIC_ROOTS")
        ```
        ### Network Security Backend Authentication Config Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        certificate = gcp.certificatemanager.Certificate("certificate",
            name="my-certificate",
            labels={
                "foo": "bar",
            },
            location="global",
            self_managed={
                "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                "pem_private_key": std.file(input="test-fixtures/key.pem").result,
            },
            scope="CLIENT_AUTH")
        trust_config = gcp.certificatemanager.TrustConfig("trust_config",
            name="my-trust-config",
            description="sample description for the trust config",
            location="global",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                }],
            }],
            labels={
                "foo": "bar",
            })
        default = gcp.networksecurity.BackendAuthenticationConfig("default",
            name="my-backend-authentication-config",
            labels={
                "bar": "foo",
            },
            location="global",
            description="my description",
            well_known_roots="PUBLIC_ROOTS",
            client_certificate=certificate.id,
            trust_config=trust_config.id)
        ```
        ### Backend Service Tls Settings

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        default_backend_authentication_config = gcp.networksecurity.BackendAuthenticationConfig("default",
            name="authentication",
            well_known_roots="PUBLIC_ROOTS")
        default = gcp.compute.BackendService("default",
            name="backend-service",
            health_checks=default_health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            protocol="HTTPS",
            tls_settings={
                "sni": "example.com",
                "subject_alt_names": [
                    {
                        "dns_name": "example.com",
                    },
                    {
                        "uniform_resource_identifier": "https://example.com",
                    },
                ],
                "authentication_config": default_backend_authentication_config.id.apply(lambda id: f"//networksecurity.googleapis.com/{id}"),
            })
        ```

        ## Import

        BackendAuthenticationConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backendAuthenticationConfigs/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, BackendAuthenticationConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/backendAuthenticationConfig:BackendAuthenticationConfig default projects/{{project}}/locations/{{location}}/backendAuthenticationConfigs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/backendAuthenticationConfig:BackendAuthenticationConfig default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/backendAuthenticationConfig:BackendAuthenticationConfig default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BackendAuthenticationConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendAuthenticationConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 trust_config: Optional[pulumi.Input[builtins.str]] = None,
                 well_known_roots: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendAuthenticationConfigArgs.__new__(BackendAuthenticationConfigArgs)

            __props__.__dict__["client_certificate"] = client_certificate
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["trust_config"] = trust_config
            __props__.__dict__["well_known_roots"] = well_known_roots
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BackendAuthenticationConfig, __self__).__init__(
            'gcp:networksecurity/backendAuthenticationConfig:BackendAuthenticationConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_certificate: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            trust_config: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            well_known_roots: Optional[pulumi.Input[builtins.str]] = None) -> 'BackendAuthenticationConfig':
        """
        Get an existing BackendAuthenticationConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_certificate: Reference to a Certificate resource from the certificatemanager.googleapis.com namespace.
               Used by a BackendService to negotiate mTLS when the backend connection uses TLS and the backend requests a client certificate. Must have a CLIENT_AUTH scope.
        :param pulumi.Input[builtins.str] create_time: Time the BackendAuthenticationConfig was created in UTC.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the BackendAuthenticationConfig resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the backend authentication config.
               The default value is `global`.
        :param pulumi.Input[builtins.str] name: Name of the BackendAuthenticationConfig resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] trust_config: Reference to a TrustConfig resource from the certificatemanager.googleapis.com namespace.
               A BackendService uses the chain of trust represented by this TrustConfig, if specified, to validate the server certificates presented by the backend. Required unless wellKnownRoots is set to PUBLIC_ROOTS.
        :param pulumi.Input[builtins.str] update_time: Time the BackendAuthenticationConfig was updated in UTC.
        :param pulumi.Input[builtins.str] well_known_roots: Well known roots to use for server certificate validation. If set to NONE, the BackendService will only validate server certificates against roots specified in TrustConfig.
               If set to PUBLIC_ROOTS, the BackendService uses a set of well-known public roots, in addition to any roots specified in the trustConfig field, when validating the server certificates presented by the backend.
               Validation with these roots is only considered when the TlsSettings.sni field in the BackendService is set. The well-known roots are a set of root CAs managed by Google. CAs in this set can be added or removed without notice.
               Possible values are: `NONE`, `PUBLIC_ROOTS`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendAuthenticationConfigState.__new__(_BackendAuthenticationConfigState)

        __props__.__dict__["client_certificate"] = client_certificate
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["trust_config"] = trust_config
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["well_known_roots"] = well_known_roots
        return BackendAuthenticationConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Reference to a Certificate resource from the certificatemanager.googleapis.com namespace.
        Used by a BackendService to negotiate mTLS when the backend connection uses TLS and the backend requests a client certificate. Must have a CLIENT_AUTH scope.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the BackendAuthenticationConfig was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Set of label tags associated with the BackendAuthenticationConfig resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location of the backend authentication config.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the BackendAuthenticationConfig resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="trustConfig")
    def trust_config(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Reference to a TrustConfig resource from the certificatemanager.googleapis.com namespace.
        A BackendService uses the chain of trust represented by this TrustConfig, if specified, to validate the server certificates presented by the backend. Required unless wellKnownRoots is set to PUBLIC_ROOTS.
        """
        return pulumi.get(self, "trust_config")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the BackendAuthenticationConfig was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="wellKnownRoots")
    def well_known_roots(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Well known roots to use for server certificate validation. If set to NONE, the BackendService will only validate server certificates against roots specified in TrustConfig.
        If set to PUBLIC_ROOTS, the BackendService uses a set of well-known public roots, in addition to any roots specified in the trustConfig field, when validating the server certificates presented by the backend.
        Validation with these roots is only considered when the TlsSettings.sni field in the BackendService is set. The well-known roots are a set of root CAs managed by Google. CAs in this set can be added or removed without notice.
        Possible values are: `NONE`, `PUBLIC_ROOTS`.
        """
        return pulumi.get(self, "well_known_roots")

