# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FirewallEndpointArgs', 'FirewallEndpoint']

@pulumi.input_type
class FirewallEndpointArgs:
    def __init__(__self__, *,
                 billing_project_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 parent: pulumi.Input[builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FirewallEndpoint resource.
        :param pulumi.Input[builtins.str] billing_project_id: Project to bill on endpoint uptime usage.
        :param pulumi.Input[builtins.str] location: The location (zone) of the firewall endpoint.
        :param pulumi.Input[builtins.str] parent: The name of the parent this firewall endpoint belongs to.
               Format: organizations/{organization_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The name of the firewall endpoint resource.
        """
        pulumi.set(__self__, "billing_project_id", billing_project_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "parent", parent)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="billingProjectId")
    def billing_project_id(self) -> pulumi.Input[builtins.str]:
        """
        Project to bill on endpoint uptime usage.
        """
        return pulumi.get(self, "billing_project_id")

    @billing_project_id.setter
    def billing_project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "billing_project_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location (zone) of the firewall endpoint.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The name of the parent this firewall endpoint belongs to.
        Format: organizations/{organization_id}.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the firewall endpoint resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FirewallEndpointState:
    def __init__(__self__, *,
                 associated_networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 billing_project_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirewallEndpoint resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_networks: List of networks that are associated with this endpoint in the local zone.
               This is a projection of the FirewallEndpointAssociations pointing at this
               endpoint. A network will only appear in this list after traffic routing is
               fully configured. Format: projects/{project}/global/networks/{name}.
        :param pulumi.Input[builtins.str] billing_project_id: Project to bill on endpoint uptime usage.
        :param pulumi.Input[builtins.str] create_time: Time the firewall endpoint was created in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location (zone) of the firewall endpoint.
        :param pulumi.Input[builtins.str] name: The name of the firewall endpoint resource.
        :param pulumi.Input[builtins.str] parent: The name of the parent this firewall endpoint belongs to.
               Format: organizations/{organization_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Whether reconciling is in progress, recommended per https://google.aip.dev/128.
        :param pulumi.Input[builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[builtins.str] update_time: Time the firewall endpoint was updated in UTC.
        """
        if associated_networks is not None:
            pulumi.set(__self__, "associated_networks", associated_networks)
        if billing_project_id is not None:
            pulumi.set(__self__, "billing_project_id", billing_project_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="associatedNetworks")
    def associated_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of networks that are associated with this endpoint in the local zone.
        This is a projection of the FirewallEndpointAssociations pointing at this
        endpoint. A network will only appear in this list after traffic routing is
        fully configured. Format: projects/{project}/global/networks/{name}.
        """
        return pulumi.get(self, "associated_networks")

    @associated_networks.setter
    def associated_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_networks", value)

    @property
    @pulumi.getter(name="billingProjectId")
    def billing_project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Project to bill on endpoint uptime usage.
        """
        return pulumi.get(self, "billing_project_id")

    @billing_project_id.setter
    def billing_project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_project_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the firewall endpoint was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location (zone) of the firewall endpoint.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the firewall endpoint resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the parent this firewall endpoint belongs to.
        Format: organizations/{organization_id}.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether reconciling is in progress, recommended per https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the firewall endpoint was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networksecurity/firewallEndpoint:FirewallEndpoint")
class FirewallEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_project_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Firewall endpoint is a Cloud Firewall resource that enables
        layer 7 advanced protection capabilities, such as intrusion prevention,
        in your network.

        To get more information about FirewallEndpoint, see:

        * [API documentation](https://cloud.google.com/firewall/docs/reference/network-security/rest/v1/organizations.locations.firewallEndpoints)
        * How-to Guides
            * [Create and associate firewall endpoints](https://cloud.google.com/firewall/docs/configure-firewall-endpoints)
            * [Firewall endpoint overview](https://cloud.google.com/firewall/docs/about-firewall-endpoints)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project_id` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project_id` you defined.

        ## Example Usage

        ### Network Security Firewall Endpoint Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.FirewallEndpoint("default",
            name="my-firewall-endpoint",
            parent="organizations/123456789",
            location="us-central1-a",
            billing_project_id="my-project-name",
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        FirewallEndpoint can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/firewallEndpoints/{{name}}`

        When using the `pulumi import` command, FirewallEndpoint can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/firewallEndpoint:FirewallEndpoint default {{parent}}/locations/{{location}}/firewallEndpoints/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] billing_project_id: Project to bill on endpoint uptime usage.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location (zone) of the firewall endpoint.
        :param pulumi.Input[builtins.str] name: The name of the firewall endpoint resource.
        :param pulumi.Input[builtins.str] parent: The name of the parent this firewall endpoint belongs to.
               Format: organizations/{organization_id}.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Firewall endpoint is a Cloud Firewall resource that enables
        layer 7 advanced protection capabilities, such as intrusion prevention,
        in your network.

        To get more information about FirewallEndpoint, see:

        * [API documentation](https://cloud.google.com/firewall/docs/reference/network-security/rest/v1/organizations.locations.firewallEndpoints)
        * How-to Guides
            * [Create and associate firewall endpoints](https://cloud.google.com/firewall/docs/configure-firewall-endpoints)
            * [Firewall endpoint overview](https://cloud.google.com/firewall/docs/about-firewall-endpoints)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project_id` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project_id` you defined.

        ## Example Usage

        ### Network Security Firewall Endpoint Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networksecurity.FirewallEndpoint("default",
            name="my-firewall-endpoint",
            parent="organizations/123456789",
            location="us-central1-a",
            billing_project_id="my-project-name",
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        FirewallEndpoint can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/firewallEndpoints/{{name}}`

        When using the `pulumi import` command, FirewallEndpoint can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/firewallEndpoint:FirewallEndpoint default {{parent}}/locations/{{location}}/firewallEndpoints/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FirewallEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_project_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallEndpointArgs.__new__(FirewallEndpointArgs)

            if billing_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'billing_project_id'")
            __props__.__dict__["billing_project_id"] = billing_project_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["associated_networks"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FirewallEndpoint, __self__).__init__(
            'gcp:networksecurity/firewallEndpoint:FirewallEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            billing_project_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'FirewallEndpoint':
        """
        Get an existing FirewallEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_networks: List of networks that are associated with this endpoint in the local zone.
               This is a projection of the FirewallEndpointAssociations pointing at this
               endpoint. A network will only appear in this list after traffic routing is
               fully configured. Format: projects/{project}/global/networks/{name}.
        :param pulumi.Input[builtins.str] billing_project_id: Project to bill on endpoint uptime usage.
        :param pulumi.Input[builtins.str] create_time: Time the firewall endpoint was created in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location (zone) of the firewall endpoint.
        :param pulumi.Input[builtins.str] name: The name of the firewall endpoint resource.
        :param pulumi.Input[builtins.str] parent: The name of the parent this firewall endpoint belongs to.
               Format: organizations/{organization_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Whether reconciling is in progress, recommended per https://google.aip.dev/128.
        :param pulumi.Input[builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[builtins.str] update_time: Time the firewall endpoint was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallEndpointState.__new__(_FirewallEndpointState)

        __props__.__dict__["associated_networks"] = associated_networks
        __props__.__dict__["billing_project_id"] = billing_project_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return FirewallEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedNetworks")
    def associated_networks(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of networks that are associated with this endpoint in the local zone.
        This is a projection of the FirewallEndpointAssociations pointing at this
        endpoint. A network will only appear in this list after traffic routing is
        fully configured. Format: projects/{project}/global/networks/{name}.
        """
        return pulumi.get(self, "associated_networks")

    @property
    @pulumi.getter(name="billingProjectId")
    def billing_project_id(self) -> pulumi.Output[builtins.str]:
        """
        Project to bill on endpoint uptime usage.
        """
        return pulumi.get(self, "billing_project_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the firewall endpoint was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location (zone) of the firewall endpoint.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the firewall endpoint resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The name of the parent this firewall endpoint belongs to.
        Format: organizations/{organization_id}.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        Whether reconciling is in progress, recommended per https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the firewall endpoint was updated in UTC.
        """
        return pulumi.get(self, "update_time")

